package com.ejie.y41b.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;

/**
 * * TramiteRegistroDecision  
 * 
 *  
 */

public class TramiteRegistroDecision extends TramiteDatosBasicos implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Acta
	private String ancodigo;

	// Destinatario
	private String tidestinatario;

	private String tipoDecision;
	private Date fechaDecision;

	// Traslado
	private String codOrgTraslado;
	private String nombreOrgTrasladoEs;
	private String nombreOrgTrasladoEu;

	private String justificacionInfraccion;
	private Date plazoRecurso;

	// sol apercibimiento
	private String apercibimientoEs;
	private String apercibimientoEu;

	/**
	 * 
	 */
	public TramiteRegistroDecision() {
		super();
	}

	/**
	 * @return the ancodigo
	 */
	public String getAncodigo() {
		return ancodigo;
	}

	/**
	 * @param ancodigo
	 *            the ancodigo to set
	 */
	public void setAncodigo(String ancodigo) {
		this.ancodigo = ancodigo;
	}

	/**
	 * @return the tipoDecision
	 */
	public String getTipoDecision() {
		return tipoDecision;
	}

	/**
	 * @param tipoDecision
	 *            the tipoDecision to set
	 */
	public void setTipoDecision(String tipoDecision) {
		this.tipoDecision = tipoDecision;
	}

	/**
	 * @return the fechaDecision
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaDecision() {
		return fechaDecision;
	}

	/**
	 * @param fechaDecision
	 *            the fechaDecision to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaDecision(Date fechaDecision) {
		this.fechaDecision = fechaDecision;
	}

	/**
	 * @return the codOrgTraslado
	 */
	public String getCodOrgTraslado() {
		return codOrgTraslado;
	}

	/**
	 * @param codOrgTraslado
	 *            the codOrgTraslado to set
	 */
	public void setCodOrgTraslado(String codOrgTraslado) {
		this.codOrgTraslado = codOrgTraslado;
	}

	/**
	 * @return the nombreOrgTrasladoEs
	 */
	public String getNombreOrgTrasladoEs() {
		return nombreOrgTrasladoEs;
	}

	/**
	 * @param nombreOrgTrasladoEs
	 *            the nombreOrgTrasladoEs to set
	 */
	public void setNombreOrgTrasladoEs(String nombreOrgTrasladoEs) {
		this.nombreOrgTrasladoEs = nombreOrgTrasladoEs;
	}

	/**
	 * @return the nombreOrgTrasladoEu
	 */
	public String getNombreOrgTrasladoEu() {
		return nombreOrgTrasladoEu;
	}

	/**
	 * @param nombreOrgTrasladoEu
	 *            the nombreOrgTrasladoEu to set
	 */
	public void setNombreOrgTrasladoEu(String nombreOrgTrasladoEu) {
		this.nombreOrgTrasladoEu = nombreOrgTrasladoEu;
	}

	/**
	 * @return the justificacionInfraccion
	 */
	public String getJustificacionInfraccion() {
		return justificacionInfraccion;
	}

	/**
	 * @param justificacionInfraccion
	 *            the justificacionInfraccion to set
	 */
	public void setJustificacionInfraccion(String justificacionInfraccion) {
		this.justificacionInfraccion = justificacionInfraccion;
	}

	/**
	 * @return the plazoRecurso
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getPlazoRecurso() {
		return plazoRecurso;
	}

	/**
	 * @param plazoRecurso
	 *            the plazoRecurso to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setPlazoRecurso(Date plazoRecurso) {
		this.plazoRecurso = plazoRecurso;
	}

	/**
	 * @return the tidestinatario
	 */
	public String getTidestinatario() {
		return tidestinatario;
	}

	/**
	 * @param tidestinatario
	 *            the tidestinatario to set
	 */
	public void setTidestinatario(String tidestinatario) {
		this.tidestinatario = tidestinatario;
	}

	/**
	 * @return the apercibimientoEs
	 */
	public String getApercibimientoEs() {
		return apercibimientoEs;
	}

	/**
	 * @param apercibimientoEs
	 *            the apercibimientoEs to set
	 */
	public void setApercibimientoEs(String apercibimientoEs) {
		this.apercibimientoEs = apercibimientoEs;
	}

	/**
	 * @return the apercibimientoEu
	 */
	public String getApercibimientoEu() {
		return apercibimientoEu;
	}

	/**
	 * @param apercibimientoEu
	 *            the apercibimientoEu to set
	 */
	public void setApercibimientoEu(String apercibimientoEu) {
		this.apercibimientoEu = apercibimientoEu;
	}

}
