package com.ejie.y41b.model;

import java.sql.Blob;
import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateTimeDeserializer;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;

/**
 * * TramiteHechoDetalle  
 * 
 *  
 */

public class TramiteInspeccionDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	// Tramite inspeccion
	private String ticodigo;

	// Actuacion
	private String atcodigo;

	// Fase
	private String fcodigo;
	private String fnombre;
	private String fnombree;

	// Tramite
	private String trcodigo;
	private String trnombre;
	private String trnombree;

	private Date tifechainicio;
	private Date tifechafin;
	private Date tifechalimite;

	private Date tifecha;
	private String tithora;
	private String titexto;
	private String ticotee;

	// Monitor
	private String mocodigo;
	private String monombre;

	// Estado tramite
	private String tiestadotramite;

	// Documento
	private String indVariosDocumentos; // S o N
	private String q5codocumento;
	private String q5nofile;
	private Blob q5datafile;
	private Integer q5sizefile;
	private String q5tedesfile;
	private String q5contenttypefile;

	private String situacionacuse;

	private Date tifechaEnvioBOPVBOE;

	private String tiidorganismocolabsol;
	private String tivcdessitcorreoseu;
	private String tivcdessitcorreoses;

	private String tiproceedingsidplatea;

	// Decision
	private String decodigo;
	private String denombre;
	private String denombree;

	// origen/destino
	private String origenDestino;

	// nombre destinatario
	private String idDestinatario;
	private String nomDestinatario;
	private String tipoDestinatario;

	// tipo interviniente
	private String tipoInterviniente;

	private String tiacusereintentado;
	private String tiacusereciborecibido;

	private String envcdessitcorreoseu;
	private String envcdessitcorreoses;

	private String ticomodesignado;
	private String ticoortraspaso;

	private String tinombretramite;

	private String tiaccodigo;
	private String ancodac;
	private String tiorigenalegacion;

	private String tiligadoprotocolo;

	private String tiistelematico;
	private String tiissir;
	private String tiissirconnumregentori;

	private TramiteInspeccionDetalle tramiteInspeccionDetalle;

	/**
	 * Un constructor
	 */
	public TramiteInspeccionDetalle() {
	}

	/**
	 * @param ticodigo
	 *            String
	 */
	public TramiteInspeccionDetalle(String ticodigo) {
		super();
		this.ticodigo = ticodigo;
	}

	/**
	 * Un constructor
	 * 
	 * @param fcodigo
	 *            String
	 * @param trcodigo
	 *            String
	 * @param tiestadotramite
	 *            String
	 */
	public TramiteInspeccionDetalle(String fcodigo, String trcodigo, String tiestadotramite) {
		this.fcodigo = fcodigo;
		this.trcodigo = trcodigo;
		this.tiestadotramite = tiestadotramite;
	}

	/**
	 * @param ticodigo
	 *            String
	 * @param atcodigo
	 *            String
	 * @param fcodigo
	 *            String
	 * @param fnombre
	 *            String
	 * @param fnombree
	 *            String
	 * @param trcodigo
	 *            String
	 * @param trnombre
	 *            String
	 * @param trnombree
	 *            String
	 * @param tifechainicio
	 *            Date
	 * @param tifechafin
	 *            Date
	 * @param mocodigo
	 *            String
	 * @param monombre
	 *            String
	 * @param tiestadotramite
	 *            String
	 */
	public TramiteInspeccionDetalle(String ticodigo, String atcodigo, String fcodigo, String fnombre, String fnombree,
			String trcodigo, String trnombre, String trnombree, Date tifechainicio, Date tifechafin, String mocodigo,
			String monombre, String tiestadotramite) {
		super();
		this.ticodigo = ticodigo;
		this.atcodigo = atcodigo;
		this.fcodigo = fcodigo;
		this.fnombre = fnombre;
		this.fnombree = fnombree;
		this.trcodigo = trcodigo;
		this.trnombre = trnombre;
		this.trnombree = trnombree;
		this.tifechainicio = tifechainicio;
		this.tifechafin = tifechafin;
		this.mocodigo = mocodigo;
		this.monombre = monombre;
		this.tiestadotramite = tiestadotramite;
	}

	/**
	 * @return the ticoortraspaso
	 */
	public String getTicoortraspaso() {
		return this.ticoortraspaso;
	}

	/**
	 * @param ticoortraspaso
	 *            the ticoortraspaso to set
	 */
	public void setTicoortraspaso(String ticoortraspaso) {
		this.ticoortraspaso = ticoortraspaso;
	}

	/**
	 * @return the ticomodesignado
	 */
	public String getTicomodesignado() {
		return this.ticomodesignado;
	}

	/**
	 * @param ticomodesignado
	 *            the ticomodesignado to set
	 */
	public void setTicomodesignado(String ticomodesignado) {
		this.ticomodesignado = ticomodesignado;
	}

	/**
	 * @return the ticotee
	 */
	public String getTicotee() {
		return this.ticotee;
	}

	/**
	 * @param ticotee
	 *            the ticotee to set
	 */
	public void setTicotee(String ticotee) {
		this.ticotee = ticotee;
	}

	/**
	 * @return the ticodigo
	 */
	public String getTicodigo() {
		return this.ticodigo;
	}

	/**
	 * @param ticodigo
	 *            the ticodigo to set
	 */
	public void setTicodigo(String ticodigo) {
		this.ticodigo = ticodigo;
	}

	/**
	 * @return the atcodigo
	 */
	public String getAtcodigo() {
		return this.atcodigo;
	}

	/**
	 * @param atcodigo
	 *            the atcodigo to set
	 */
	public void setAtcodigo(String atcodigo) {
		this.atcodigo = atcodigo;
	}

	/**
	 * @return the fcodigo
	 */
	public String getFcodigo() {
		return this.fcodigo;
	}

	/**
	 * @param fcodigo
	 *            the fcodigo to set
	 */
	public void setFcodigo(String fcodigo) {
		this.fcodigo = fcodigo;
	}

	/**
	 * @return the fnombre
	 */
	public String getFnombre() {
		return this.fnombre;
	}

	/**
	 * @param fnombre
	 *            the fnombre to set
	 */
	public void setFnombre(String fnombre) {
		this.fnombre = fnombre;
	}

	/**
	 * @return the fnombree
	 */
	public String getFnombree() {
		return this.fnombree;
	}

	/**
	 * @param fnombree
	 *            the fnombree to set
	 */
	public void setFnombree(String fnombree) {
		this.fnombree = fnombree;
	}

	/**
	 * @return the trcodigo
	 */
	public String getTrcodigo() {
		return this.trcodigo;
	}

	/**
	 * @param trcodigo
	 *            the trcodigo to set
	 */
	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * @return the trnombre
	 */
	public String getTrnombre() {
		return this.trnombre;
	}

	/**
	 * @param trnombre
	 *            the trnombre to set
	 */
	public void setTrnombre(String trnombre) {
		this.trnombre = trnombre;
	}

	/**
	 * @return the trnombree
	 */
	public String getTrnombree() {
		return this.trnombree;
	}

	/**
	 * @param trnombree
	 *            the trnombree to set
	 */
	public void setTrnombree(String trnombree) {
		this.trnombree = trnombree;
	}

	/**
	 * @return the tifechainicio
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getTifechainicio() {
		return this.tifechainicio;
	}

	/**
	 * @param tifechainicio
	 *            the tifechainicio to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setTifechainicio(Date tifechainicio) {
		this.tifechainicio = tifechainicio;
	}

	/**
	 * @return the tifechafin
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getTifechafin() {
		return this.tifechafin;
	}

	/**
	 * @param tifechafin
	 *            the tifechafin to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setTifechafin(Date tifechafin) {
		this.tifechafin = tifechafin;
	}

	/**
	 * @return the tifechalimite
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getTifechalimite() {
		return this.tifechalimite;
	}

	/**
	 * @param tifechalimite
	 *            the tifechalimite to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setTifechalimite(Date tifechalimite) {
		this.tifechalimite = tifechalimite;
	}

	/**
	 * @return the tifecha
	 */
	public Date getTifecha() {
		return this.tifecha;
	}

	/**
	 * @param tifecha
	 *            the tifecha to set
	 */
	public void setTifecha(Date tifecha) {
		this.tifecha = tifecha;
	}

	/**
	 * @return the tithora
	 */
	public String getTithora() {
		return this.tithora;
	}

	/**
	 * @param tithora
	 *            the tithora to set
	 */
	public void setTithora(String tithora) {
		this.tithora = tithora;
	}

	/**
	 * @return the titexto
	 */
	public String getTitexto() {
		return this.titexto;
	}

	/**
	 * @param titexto
	 *            the titexto to set
	 */
	public void setTitexto(String titexto) {
		this.titexto = titexto;
	}

	/**
	 * @return the mocodigo
	 */
	public String getMocodigo() {
		return this.mocodigo;
	}

	/**
	 * @param mocodigo
	 *            the mocodigo to set
	 */
	public void setMocodigo(String mocodigo) {
		this.mocodigo = mocodigo;
	}

	/**
	 * @return the monombre
	 */
	public String getMonombre() {
		return this.monombre;
	}

	/**
	 * @param monombre
	 *            the monombre to set
	 */
	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * @return the tiestadotramite
	 */
	public String getTiestadotramite() {
		return this.tiestadotramite;
	}

	/**
	 * @param tiestadotramite
	 *            the tiestadotramite to set
	 */
	public void setTiestadotramite(String tiestadotramite) {
		this.tiestadotramite = tiestadotramite;
	}

	/**
	 * @return the indVariosDocumentos
	 */
	public String getIndVariosDocumentos() {
		return this.indVariosDocumentos;
	}

	/**
	 * @param indVariosDocumentos
	 *            the indVariosDocumentos to set
	 */
	public void setIndVariosDocumentos(String indVariosDocumentos) {
		this.indVariosDocumentos = indVariosDocumentos;
	}

	/**
	 * @return the q5codocumento
	 */
	public String getQ5codocumento() {
		return this.q5codocumento;
	}

	/**
	 * @param q5codocumento
	 *            the q5codocumento to set
	 */
	public void setQ5codocumento(String q5codocumento) {
		this.q5codocumento = q5codocumento;
	}

	/**
	 * @return the q5nofile
	 */
	public String getQ5nofile() {
		return this.q5nofile;
	}

	/**
	 * @param q5nofile
	 *            the q5nofile to set
	 */
	public void setQ5nofile(String q5nofile) {
		this.q5nofile = q5nofile;
	}

	/**
	 * @return the q5datafile
	 */
	public Blob getQ5datafile() {
		return this.q5datafile;
	}

	/**
	 * @param q5datafile
	 *            the q5datafile to set
	 */
	public void setQ5datafile(Blob q5datafile) {
		this.q5datafile = q5datafile;
	}

	/**
	 * @return the q5sizefile
	 */
	public Integer getQ5sizefile() {
		return this.q5sizefile;
	}

	/**
	 * @param q5sizefile
	 *            the q5sizefile to set
	 */
	public void setQ5sizefile(Integer q5sizefile) {
		this.q5sizefile = q5sizefile;
	}

	/**
	 * @return the q5tedesfile
	 */
	public String getQ5tedesfile() {
		return this.q5tedesfile;
	}

	/**
	 * @param q5tedesfile
	 *            the q5tedesfile to set
	 */
	public void setQ5tedesfile(String q5tedesfile) {
		this.q5tedesfile = q5tedesfile;
	}

	/**
	 * @return the q5contenttypefile
	 */
	public String getQ5contenttypefile() {
		return this.q5contenttypefile;
	}

	/**
	 * @param q5contenttypefile
	 *            the q5contenttypefile to set
	 */
	public void setQ5contenttypefile(String q5contenttypefile) {
		this.q5contenttypefile = q5contenttypefile;
	}

	/**
	 * @return the situacionacuse
	 */
	public String getSituacionacuse() {
		return this.situacionacuse;
	}

	/**
	 * @param situacionacuse
	 *            the situacionacuse to set
	 */
	public void setSituacionacuse(String situacionacuse) {
		this.situacionacuse = situacionacuse;
	}

	/**
	 * @return the tifechaEnvioBOPVBOE
	 */
	public Date getTifechaEnvioBOPVBOE() {
		return this.tifechaEnvioBOPVBOE;
	}

	/**
	 * @param tifechaEnvioBOPVBOE
	 *            the tifechaEnvioBOPVBOE to set
	 */
	public void setTifechaEnvioBOPVBOE(Date tifechaEnvioBOPVBOE) {
		this.tifechaEnvioBOPVBOE = tifechaEnvioBOPVBOE;
	}

	/**
	 * @return the tiidorganismocolabsol
	 */
	public String getTiidorganismocolabsol() {
		return this.tiidorganismocolabsol;
	}

	/**
	 * @param tiidorganismocolabsol
	 *            the tiidorganismocolabsol to set
	 */
	public void setTiidorganismocolabsol(String tiidorganismocolabsol) {
		this.tiidorganismocolabsol = tiidorganismocolabsol;
	}

	/**
	 * @return the tivcdessitcorreoseu
	 */
	public String getTivcdessitcorreoseu() {
		return this.tivcdessitcorreoseu;
	}

	/**
	 * @param tivcdessitcorreoseu
	 *            the tivcdessitcorreoseu to set
	 */
	public void setTivcdessitcorreoseu(String tivcdessitcorreoseu) {
		this.tivcdessitcorreoseu = tivcdessitcorreoseu;
	}

	/**
	 * @return the tivcdessitcorreoses
	 */
	public String getTivcdessitcorreoses() {
		return this.tivcdessitcorreoses;
	}

	/**
	 * @param tivcdessitcorreoses
	 *            the tivcdessitcorreoses to set
	 */
	public void setTivcdessitcorreoses(String tivcdessitcorreoses) {
		this.tivcdessitcorreoses = tivcdessitcorreoses;
	}

	/**
	 * @return the tiproceedingsidplatea
	 */
	public String getTiproceedingsidplatea() {
		return this.tiproceedingsidplatea;
	}

	/**
	 * @param tiproceedingsidplatea
	 *            the tiproceedingsidplatea to set
	 */
	public void setTiproceedingsidplatea(String tiproceedingsidplatea) {
		this.tiproceedingsidplatea = tiproceedingsidplatea;
	}

	/**
	 * @return the decodigo
	 */
	public String getDecodigo() {
		return this.decodigo;
	}

	/**
	 * @param decodigo
	 *            the decodigo to set
	 */
	public void setDecodigo(String decodigo) {
		this.decodigo = decodigo;
	}

	/**
	 * @return the denombre
	 */
	public String getDenombre() {
		return this.denombre;
	}

	/**
	 * @param denombre
	 *            the denombre to set
	 */
	public void setDenombre(String denombre) {
		this.denombre = denombre;
	}

	/**
	 * @return the denombree
	 */
	public String getDenombree() {
		return this.denombree;
	}

	/**
	 * @param denombree
	 *            the denombree to set
	 */
	public void setDenombree(String denombree) {
		this.denombree = denombree;
	}

	/**
	 * @return the origenDestino
	 */
	public String getOrigenDestino() {
		return this.origenDestino;
	}

	/**
	 * @param origenDestino
	 *            the origenDestino to set
	 */
	public void setOrigenDestino(String origenDestino) {
		this.origenDestino = origenDestino;
	}

	/**
	 * @return the idDestinatario
	 */
	public String getIdDestinatario() {
		return this.idDestinatario;
	}

	/**
	 * @param idDestinatario
	 *            the idDestinatario to set
	 */
	public void setIdDestinatario(String idDestinatario) {
		this.idDestinatario = idDestinatario;
	}

	/**
	 * @return the nomDestinatario
	 */
	public String getNomDestinatario() {
		return this.nomDestinatario;
	}

	/**
	 * @param nomDestinatario
	 *            the nomDestinatario to set
	 */
	public void setNomDestinatario(String nomDestinatario) {
		this.nomDestinatario = nomDestinatario;
	}

	/**
	 * @return the tipoInterviniente
	 */
	public String getTipoInterviniente() {
		return this.tipoInterviniente;
	}

	/**
	 * @param tipoInterviniente
	 *            the tipoInterviniente to set
	 */
	public void setTipoInterviniente(String tipoInterviniente) {
		this.tipoInterviniente = tipoInterviniente;
	}

	/**
	 * @return the tiacusereintentado
	 */
	public String getTiacusereintentado() {
		return this.tiacusereintentado;
	}

	/**
	 * @param tiacusereintentado
	 *            the tiacusereintentado to set
	 */
	public void setTiacusereintentado(String tiacusereintentado) {
		this.tiacusereintentado = tiacusereintentado;
	}

	/**
	 * @return the envcdessitcorreoseu
	 */
	public String getEnvcdessitcorreoseu() {
		return this.envcdessitcorreoseu;
	}

	/**
	 * @param envcdessitcorreoseu
	 *            the envcdessitcorreoseu to set
	 */
	public void setEnvcdessitcorreoseu(String envcdessitcorreoseu) {
		this.envcdessitcorreoseu = envcdessitcorreoseu;
	}

	/**
	 * @return the envcdessitcorreoses
	 */
	public String getEnvcdessitcorreoses() {
		return this.envcdessitcorreoses;
	}

	/**
	 * @param envcdessitcorreoses
	 *            the envcdessitcorreoses to set
	 */
	public void setEnvcdessitcorreoses(String envcdessitcorreoses) {
		this.envcdessitcorreoses = envcdessitcorreoses;
	}

	/**
	 * @return the tiacusereciborecibido
	 */
	public String getTiacusereciborecibido() {
		return this.tiacusereciborecibido;
	}

	/**
	 * @param tiacusereciborecibido
	 *            the tiacusereciborecibido to set
	 */
	public void setTiacusereciborecibido(String tiacusereciborecibido) {
		this.tiacusereciborecibido = tiacusereciborecibido;
	}

	/**
	 * @return the tinombretramite
	 */
	public String getTinombretramite() {
		return this.tinombretramite;
	}

	/**
	 * @param tinombretramite
	 *            the tinombretramite to set
	 */
	public void setTinombretramite(String tinombretramite) {
		this.tinombretramite = tinombretramite;
	}

	/**
	 * @return the tiaccodigo
	 */
	public String getTiaccodigo() {
		return this.tiaccodigo;
	}

	/**
	 * @param tiaccodigo
	 *            the tiaccodigo to set
	 */
	public void setTiaccodigo(String tiaccodigo) {
		this.tiaccodigo = tiaccodigo;
	}

	/**
	 * @return the ancodac
	 */
	public String getAncodac() {
		return this.ancodac;
	}

	/**
	 * @param ancodac
	 *            the ancodac to set
	 */
	public void setAncodac(String ancodac) {
		this.ancodac = ancodac;
	}

	/**
	 * @return the tramiteInspeccionDetalle
	 */
	public TramiteInspeccionDetalle getTramiteInspeccionDetalle() {
		return this.tramiteInspeccionDetalle;
	}

	/**
	 * @param tramiteInspeccionDetalle
	 *            the tramiteInspeccionDetalle to set
	 */
	public void setTramiteInspeccionDetalle(TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		this.tramiteInspeccionDetalle = tramiteInspeccionDetalle;
	}

	/**
	 * @return the tipoDestinatario
	 */
	public String getTipoDestinatario() {
		return this.tipoDestinatario;
	}

	/**
	 * @param tipoDestinatario
	 *            the tipoDestinatario to set
	 */
	public void setTipoDestinatario(String tipoDestinatario) {
		this.tipoDestinatario = tipoDestinatario;
	}

	/**
	 * @return the tiorigenalegacion
	 */
	public String getTiorigenalegacion() {
		return this.tiorigenalegacion;
	}

	/**
	 * @param tiorigenalegacion
	 *            the tiorigenalegacion to set
	 */
	public void setTiorigenalegacion(String tiorigenalegacion) {
		this.tiorigenalegacion = tiorigenalegacion;
	}

	/**
	 * @return the tiligadoprotocolo
	 */
	public String getTiligadoprotocolo() {
		return tiligadoprotocolo;
	}

	/**
	 * @param tiligadoprotocolo
	 *            the tiligadoprotocolo to set
	 */
	public void setTiligadoprotocolo(String tiligadoprotocolo) {
		this.tiligadoprotocolo = tiligadoprotocolo;
	}

	/**
	 * @return the tiistelematico
	 */
	public String getTiistelematico() {
		return tiistelematico;
	}

	/**
	 * @param tiistelematico
	 *            the tiistelematico to set
	 */
	public void setTiistelematico(String tiistelematico) {
		this.tiistelematico = tiistelematico;
	}

	/**
	 * @return the tiissir
	 */
	public String getTiissir() {
		return tiissir;
	}

	/**
	 * @param tiissir
	 *            the tiissir to set
	 */
	public void setTiissir(String tiissir) {
		this.tiissir = tiissir;
	}

	/**
	 * @return the tiissirconnumregentori
	 */
	public String getTiissirconnumregentori() {
		return tiissirconnumregentori;
	}

	/**
	 * @param tiissirconnumregentori
	 *            the tiissirconnumregentori to set
	 */
	public void setTiissirconnumregentori(String tiissirconnumregentori) {
		this.tiissirconnumregentori = tiissirconnumregentori;
	}

}
