package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;

/**
 * * TramiteHechoDetalle  
 * 
 *  
 */

public class TramiteHechoDetalleKnet implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String ehcodigo;
	@NotNull(message = "required.ehfecha")
	private Date ehfecha;
	@NotEmpty(message = "required.ehhora")
	private String ehhora;
	private String ehcodpor;
	private String ehcodpde;
	private String ehtexto;
	private String ehcozs;
	private BigDecimal ehcivihe;
	private Date ehacuse;
	private String ehenviomail;
	private String ehdiremail;

	// Tramite
	@NotEmpty(message = "required.trcodigo")
	@NotNull()
	@Length(max = 3, message = "lenght.trcodigo")
	private String trcodigo;
	private String trnombre;
	private String trnombree;
	private Date trbaja;

	// Monitor
	@NotEmpty(message = "required.mocodigo")
	@NotNull()
	@Length(max = 3, message = "lenght.mocodigo")
	private String mocodigo;
	private String codOrg;
	private String monombre;
	private String mocoem;

	// Hecho Denunciado
	private String hdcodigo;

	// Documento
	private Integer q5codocumento;
	private String q5nofile;
	private Blob q5datafile;
	private Integer q5sizefile;
	private String q5tedesfile;
	private String q5origen;
	private Date q5fecha;
	private String q5indmail;
	private String q5contenttypefile;

	// Traslado
	private String codOrgTraslado;
	private String nombreOrgTrasladoEs;
	private String nombreOrgTrasladoEu;

	// Email
	private String emailReclamante;
	private String emailReclamado;

	// Numero Solicitud
	private String decoor;
	private BigDecimal denran;
	private BigDecimal denror;
	private BigDecimal hdnror;

	// Documentos adjuntos mail
	private List<DocumentoHecho> documentoHechosMail = new ArrayList<DocumentoHecho>();

	/**
	 * 
	 */
	public TramiteHechoDetalleKnet() {
	}

	/**
	 * @param ehcodigo
	 * @param ehfecha
	 * @param ehhora
	 * @param ehcodpor
	 * @param ehcodpde
	 * @param ehtexto
	 * @param ehcozs
	 * @param ehcivihe
	 * @param ehacuse
	 * @param ehenviomail
	 * @param ehdiremail
	 * @param trcodigo
	 * @param trnombre
	 * @param trnombree
	 * @param trbaja
	 * @param mocodigo
	 * @param codOrg
	 * @param monombre
	 * @param mocoem
	 * @param hdcodigo
	 * @param q5codocumento
	 * @param q5nofile
	 * @param q5datafile
	 * @param q5sizefile
	 * @param q5tedesfile
	 * @param q5origen
	 * @param q5fecha
	 * @param q5indmail
	 * @param q5contenttypefile
	 * @param codOrgTraslado
	 * @param nombreOrgTrasladoEs
	 * @param nombreOrgTrasladoEu
	 * @param emailReclamante
	 * @param emailReclamado
	 */
	public TramiteHechoDetalleKnet(String ehcodigo, Date ehfecha,
			String ehhora, String ehcodpor, String ehcodpde, String ehtexto,
			String ehcozs, BigDecimal ehcivihe, Date ehacuse,
			String ehenviomail, String ehdiremail, String trcodigo,
			String trnombre, String trnombree, Date trbaja, String mocodigo,
			String codOrg, String monombre, String mocoem, String hdcodigo,
			Integer q5codocumento, String q5nofile, Blob q5datafile,
			Integer q5sizefile, String q5tedesfile, String q5origen,
			Date q5fecha, String q5indmail, String q5contenttypefile,
			String codOrgTraslado, String nombreOrgTrasladoEs,
			String nombreOrgTrasladoEu, String emailReclamante,
			String emailReclamado) {
		this.ehcodigo = ehcodigo;
		this.ehfecha = ehfecha;
		this.ehhora = ehhora;
		this.ehcodpor = ehcodpor;
		this.ehcodpde = ehcodpde;
		this.ehtexto = ehtexto;
		this.ehcozs = ehcozs;
		this.ehcivihe = ehcivihe;
		this.ehacuse = ehacuse;
		this.ehenviomail = ehenviomail;
		this.ehdiremail = ehdiremail;
		this.trcodigo = trcodigo;
		this.trnombre = trnombre;
		this.trnombree = trnombree;
		this.trbaja = trbaja;
		this.mocodigo = mocodigo;
		this.codOrg = codOrg;
		this.monombre = monombre;
		this.mocoem = mocoem;
		this.hdcodigo = hdcodigo;
		this.q5codocumento = q5codocumento;
		this.q5nofile = q5nofile;
		this.q5datafile = q5datafile;
		this.q5sizefile = q5sizefile;
		this.q5tedesfile = q5tedesfile;
		this.q5origen = q5origen;
		this.q5fecha = q5fecha;
		this.q5indmail = q5indmail;
		this.q5contenttypefile = q5contenttypefile;
		this.codOrgTraslado = codOrgTraslado;
		this.nombreOrgTrasladoEs = nombreOrgTrasladoEs;
		this.nombreOrgTrasladoEu = nombreOrgTrasladoEu;
		this.emailReclamante = emailReclamante;
		this.emailReclamado = emailReclamado;
	}

	/**
	 * @return the ehcodigo
	 */
	public String getEhcodigo() {
		return ehcodigo;
	}

	/**
	 * @param ehcodigo
	 *            the ehcodigo to set
	 */
	public void setEhcodigo(String ehcodigo) {
		this.ehcodigo = ehcodigo;
	}

	/**
	 * @return the ehfecha
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getEhfecha() {
		return ehfecha;
	}

	/**
	 * @param ehfecha
	 *            the ehfecha to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setEhfecha(Date ehfecha) {
		this.ehfecha = ehfecha;
	}

	/**
	 * @return the ehhora
	 */
	public String getEhhora() {
		return ehhora;
	}

	/**
	 * @param ehhora
	 *            the ehhora to set
	 */
	public void setEhhora(String ehhora) {
		this.ehhora = ehhora;
	}

	/**
	 * @return the ehcodpor
	 */
	public String getEhcodpor() {
		return ehcodpor;
	}

	/**
	 * @param ehcodpor
	 *            the ehcodpor to set
	 */
	public void setEhcodpor(String ehcodpor) {
		this.ehcodpor = ehcodpor;
	}

	/**
	 * @return the ehcodpde
	 */
	public String getEhcodpde() {
		return ehcodpde;
	}

	/**
	 * @param ehcodpde
	 *            the ehcodpde to set
	 */
	public void setEhcodpde(String ehcodpde) {
		this.ehcodpde = ehcodpde;
	}

	/**
	 * @return the ehtexto
	 */
	public String getEhtexto() {
		return ehtexto;
	}

	/**
	 * @param ehtexto
	 *            the ehtexto to set
	 */
	public void setEhtexto(String ehtexto) {
		this.ehtexto = ehtexto;
	}

	/**
	 * @return the ehcozs
	 */
	public String getEhcozs() {
		return ehcozs;
	}

	/**
	 * @param ehcozs
	 *            the ehcozs to set
	 */
	public void setEhcozs(String ehcozs) {
		this.ehcozs = ehcozs;
	}

	/**
	 * @return the ehcivihe
	 */
	public BigDecimal getEhcivihe() {
		return ehcivihe;
	}

	/**
	 * @param ehcivihe
	 *            the ehcivihe to set
	 */
	public void setEhcivihe(BigDecimal ehcivihe) {
		this.ehcivihe = ehcivihe;
	}

	/**
	 * @return the ehacuse
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getEhacuse() {
		return ehacuse;
	}

	/**
	 * @param ehacuse
	 *            the ehacuse to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setEhacuse(Date ehacuse) {
		this.ehacuse = ehacuse;
	}

	/**
	 * @return the ehenviomail
	 */
	public String getEhenviomail() {
		return ehenviomail;
	}

	/**
	 * @param ehenviomail
	 *            the ehenviomail to set
	 */
	public void setEhenviomail(String ehenviomail) {
		this.ehenviomail = ehenviomail;
	}

	/**
	 * @return the ehdiremail
	 */
	public String getEhdiremail() {
		return ehdiremail;
	}

	/**
	 * @param ehdiremail
	 *            the ehdiremail to set
	 */
	public void setEhdiremail(String ehdiremail) {
		this.ehdiremail = ehdiremail;
	}

	/**
	 * @return the trcodigo
	 */
	public String getTrcodigo() {
		return trcodigo;
	}

	/**
	 * @param trcodigo
	 *            the trcodigo to set
	 */
	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * @return the trnombre
	 */
	public String getTrnombre() {
		return trnombre;
	}

	/**
	 * @param trnombre
	 *            the trnombre to set
	 */
	public void setTrnombre(String trnombre) {
		this.trnombre = trnombre;
	}

	/**
	 * @return the trnombree
	 */
	public String getTrnombree() {
		return trnombree;
	}

	/**
	 * @param trnombree
	 *            the trnombree to set
	 */
	public void setTrnombree(String trnombree) {
		this.trnombree = trnombree;
	}

	/**
	 * @return the trbaja
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getTrbaja() {
		return trbaja;
	}

	/**
	 * @param trbaja
	 *            the trbaja to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setTrbaja(Date trbaja) {
		this.trbaja = trbaja;
	}

	/**
	 * @return the mocodigo
	 */
	public String getMocodigo() {
		return mocodigo;
	}

	/**
	 * @param mocodigo
	 *            the mocodigo to set
	 */
	public void setMocodigo(String mocodigo) {
		this.mocodigo = mocodigo;
	}

	/**
	 * @return the codOrg
	 */
	public String getCodOrg() {
		return codOrg;
	}

	/**
	 * @param codOrg
	 *            the codOrg to set
	 */
	public void setCodOrg(String codOrg) {
		this.codOrg = codOrg;
	}

	/**
	 * @return the monombre
	 */
	public String getMonombre() {
		return monombre;
	}

	/**
	 * @param monombre
	 *            the monombre to set
	 */
	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * @return the hdcodigo
	 */
	public String getHdcodigo() {
		return hdcodigo;
	}

	/**
	 * @param hdcodigo
	 *            the hdcodigo to set
	 */
	public void setHdcodigo(String hdcodigo) {
		this.hdcodigo = hdcodigo;
	}

	/**
	 * @return the q5codocumento
	 */
	public Integer getQ5codocumento() {
		return q5codocumento;
	}

	/**
	 * @param q5codocumento
	 *            the q5codocumento to set
	 */
	public void setQ5codocumento(Integer q5codocumento) {
		this.q5codocumento = q5codocumento;
	}

	/**
	 * @return the q5nofile
	 */
	public String getQ5nofile() {
		return q5nofile;
	}

	/**
	 * @param q5nofile
	 *            the q5nofile to set
	 */
	public void setQ5nofile(String q5nofile) {
		this.q5nofile = q5nofile;
	}

	/**
	 * @return the q5datafile
	 */
	@JsonIgnore
	public Blob getQ5datafile() {
		return q5datafile;
	}

	/**
	 * @param q5datafile
	 *            the q5datafile to set
	 */
	public void setQ5datafile(Blob q5datafile) {
		this.q5datafile = q5datafile;
	}

	/**
	 * @return the q5sizefile
	 */
	public Integer getQ5sizefile() {
		return q5sizefile;
	}

	/**
	 * @param q5sizefile
	 *            the q5sizefile to set
	 */
	public void setQ5sizefile(Integer q5sizefile) {
		this.q5sizefile = q5sizefile;
	}

	/**
	 * @return the q5tedesfile
	 */
	public String getQ5tedesfile() {
		return q5tedesfile;
	}

	/**
	 * @param q5tedesfile
	 *            the q5tedesfile to set
	 */
	public void setQ5tedesfile(String q5tedesfile) {
		this.q5tedesfile = q5tedesfile;
	}

	/**
	 * @return the q5origen
	 */
	public String getQ5origen() {
		return q5origen;
	}

	/**
	 * @param q5origen
	 *            the q5origen to set
	 */
	public void setQ5origen(String q5origen) {
		this.q5origen = q5origen;
	}

	/**
	 * @return the q5fecha
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getQ5fecha() {
		return q5fecha;
	}

	/**
	 * @param q5fecha
	 *            the q5fecha to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setQ5fecha(Date q5fecha) {
		this.q5fecha = q5fecha;
	}

	/**
	 * @return the q5indmail
	 */
	public String getQ5indmail() {
		return q5indmail;
	}

	/**
	 * @param q5indmail
	 *            the q5indmail to set
	 */
	public void setQ5indmail(String q5indmail) {
		this.q5indmail = q5indmail;
	}

	/**
	 * @return the q5contenttypefile
	 */
	public String getQ5contenttypefile() {
		return q5contenttypefile;
	}

	/**
	 * @param q5contenttypefile
	 *            the q5contenttypefile to set
	 */
	public void setQ5contenttypefile(String q5contenttypefile) {
		this.q5contenttypefile = q5contenttypefile;
	}

	/**
	 * @return the codOrgTraslado
	 */
	public String getCodOrgTraslado() {
		return codOrgTraslado;
	}

	/**
	 * @param codOrgTraslado
	 *            the codOrgTraslado to set
	 */
	public void setCodOrgTraslado(String codOrgTraslado) {
		this.codOrgTraslado = codOrgTraslado;
	}

	/**
	 * @return the nombreOrgTrasladoEs
	 */
	public String getNombreOrgTrasladoEs() {
		return nombreOrgTrasladoEs;
	}

	/**
	 * @param nombreOrgTrasladoEs
	 *            the nombreOrgTrasladoEs to set
	 */
	public void setNombreOrgTrasladoEs(String nombreOrgTrasladoEs) {
		this.nombreOrgTrasladoEs = nombreOrgTrasladoEs;
	}

	/**
	 * @return the nombreOrgTrasladoEu
	 */
	public String getNombreOrgTrasladoEu() {
		return nombreOrgTrasladoEu;
	}

	/**
	 * @param nombreOrgTrasladoEu
	 *            the nombreOrgTrasladoEu to set
	 */
	public void setNombreOrgTrasladoEu(String nombreOrgTrasladoEu) {
		this.nombreOrgTrasladoEu = nombreOrgTrasladoEu;
	}

	/**
	 * @return the emailReclamante
	 */
	public String getEmailReclamante() {
		return emailReclamante;
	}

	/**
	 * @param emailReclamante
	 *            the emailReclamante to set
	 */
	public void setEmailReclamante(String emailReclamante) {
		this.emailReclamante = emailReclamante;
	}

	/**
	 * @return the emailReclamado
	 */
	public String getEmailReclamado() {
		return emailReclamado;
	}

	/**
	 * @param emailReclamado
	 *            the emailReclamado to set
	 */
	public void setEmailReclamado(String emailReclamado) {
		this.emailReclamado = emailReclamado;
	}

	/**
	 * @return the mocoem
	 */
	public String getMocoem() {
		return mocoem;
	}

	/**
	 * @param mocoem
	 *            the mocoem to set
	 */
	public void setMocoem(String mocoem) {
		this.mocoem = mocoem;
	}

	/**
	 * @return the documentoHechosMail
	 */
	@JsonIgnore
	public List<DocumentoHecho> getDocumentoHechosMail() {
		return documentoHechosMail;
	}

	/**
	 * @param documentoHechosMail
	 *            the documentoHechosMail to set
	 */
	public void setDocumentoHechosMail(List<DocumentoHecho> documentoHechosMail) {
		this.documentoHechosMail = documentoHechosMail;
	}

	/**
	 * @return the decoor
	 */
	public String getDecoor() {
		return decoor;
	}

	/**
	 * @param decoor
	 *            the decoor to set
	 */
	public void setDecoor(String decoor) {
		this.decoor = decoor;
	}

	/**
	 * @return the denran
	 */
	public BigDecimal getDenran() {
		return denran;
	}

	/**
	 * @param denran
	 *            the denran to set
	 */
	public void setDenran(BigDecimal denran) {
		this.denran = denran;
	}

	/**
	 * @return the denror
	 */
	public BigDecimal getDenror() {
		return denror;
	}

	/**
	 * @param denror
	 *            the denror to set
	 */
	public void setDenror(BigDecimal denror) {
		this.denror = denror;
	}

	/**
	 * @return the hdnror
	 */
	public BigDecimal getHdnror() {
		return hdnror;
	}

	/**
	 * @param hdnror
	 *            the hdnror to set
	 */
	public void setHdnror(BigDecimal hdnror) {
		this.hdnror = hdnror;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "TramiteHechoDetalle [ehcodigo=" + ehcodigo + ", ehfecha="
				+ ehfecha + ", ehhora=" + ehhora + ", ehcodpor=" + ehcodpor
				+ ", ehcodpde=" + ehcodpde + ", ehtexto=" + ehtexto
				+ ", ehcozs=" + ehcozs + ", ehcivihe=" + ehcivihe
				+ ", ehacuse=" + ehacuse + ", ehenviomail=" + ehenviomail
				+ ", ehdiremail=" + ehdiremail + ", trcodigo=" + trcodigo
				+ ", trnombre=" + trnombre + ", trnombree=" + trnombree
				+ ", trbaja=" + trbaja + ", mocodigo=" + mocodigo + ", codOrg="
				+ codOrg + ", monombre=" + monombre + ", mocoem=" + mocoem
				+ ", hdcodigo=" + hdcodigo + ", q5codocumento=" + q5codocumento
				+ ", q5nofile=" + q5nofile + ", q5datafile=" + q5datafile
				+ ", q5sizefile=" + q5sizefile + ", q5tedesfile=" + q5tedesfile
				+ ", q5origen=" + q5origen + ", q5fecha=" + q5fecha
				+ ", q5indmail=" + q5indmail + ", q5contenttypefile="
				+ q5contenttypefile + ", codOrgTraslado=" + codOrgTraslado
				+ ", nombreOrgTrasladoEs=" + nombreOrgTrasladoEs
				+ ", nombreOrgTrasladoEu=" + nombreOrgTrasladoEu
				+ ", emailReclamante=" + emailReclamante + ", emailReclamado="
				+ emailReclamado + "]";
	}

}
