package com.ejie.y41b.model;

import java.sql.Blob;
import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;
import com.ejie.y41b.control.Y41bJsonDateTimeDeserializer;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;

/**
 * * TramiteHechoDetalle  
 * 
 *  
 */

public class TramiteHechoDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	// Tramite hecho
	private String ehcodigo;

	// Hecho Denunciado
	private String hdcodigo;

	// Fase
	private String fcodigo;
	private String fnombre;
	private String fnombree;

	// Tramite
	private String trcodigo;
	private String trnombre;
	private String trnombree;

	private Date ehfechainicio;
	private Date ehfechafin;
	private Date ehfecha;
	private String ehhora;
	private String ehtexto;

	private String ehcoortraspaso;
	private String ehcodigorelacionado;

	// Monitor
	private String mocodigo;
	private String monombre;

	// Estado tramite
	private String ehestadotramite;

	// Documento
	private String indVariosDocumentos; // S o N
	private String q5codocumento;
	private String q5nofile;
	private Blob q5datafile;
	private Integer q5sizefile;
	private String q5tedesfile;
	private String q5contenttypefile;

	private String situacionacuse;

	private Date ehfechaEnvioBOPVBOE;

	private String ehidorganismocolabsol;
	private String envcdessitcorreoseu;
	private String envcdessitcorreoses;

	private String ehproceedingsidplatea;

	// Decision
	private String decodigo;
	private String denombre;
	private String denombree;

	// origen/destino
	private String origenDestino;

	// nombre destinatario
	private String nomDestinatario;

	// tipo interviniente
	private String tipoInterviniente;

	private String ehacusereintentado;

	private String ehistelematico;

	private String ehissir;
	private String ehissirconnumregentori;

	private String ehIsWebSinCertificado;

	/**
	 * 
	 */
	public TramiteHechoDetalle() {
		super();
	}

	/**
	 * @param ehcodigo
	 * @param hdcodigo
	 * @param fcodigo
	 * @param fnombre
	 * @param fnombree
	 * @param trcodigo
	 * @param trnombre
	 * @param trnombree
	 * @param ehfechainicio
	 * @param ehfechafin
	 * @param ehfecha
	 * @param ehhora
	 * @param ehtexto
	 * @param ehcoortraspaso
	 * @param ehcodigorelacionado
	 * @param mocodigo
	 * @param monombre
	 * @param ehestadotramite
	 * @param indVariosDocumentos
	 * @param q5codocumento
	 * @param q5nofile
	 * @param q5datafile
	 * @param q5sizefile
	 * @param q5tedesfile
	 * @param q5contenttypefile
	 * @param situacionacuse
	 * @param ehfechaEnvioBOPVBOE
	 * @param envcdessitcorreoses
	 * @param envcdessitcorreoseu
	 * @param ehidorganismocolabsol
	 * @param ehproceedingsidplatea
	 * @param decodigo
	 * @param denombre
	 * @param denombree
	 * @param origenDestino
	 * @param nomDestinatario
	 * @param ehacusereintentado
	 * @param ehistelematico
	 * @param ehissir
	 * @param ehissirconnumregentori;
	 * @param ehIsWebSinCertificado;
	 */
	public TramiteHechoDetalle(String ehcodigo, String hdcodigo, String fcodigo, String fnombre, String fnombree,
			String trcodigo, String trnombre, String trnombree, Date ehfechainicio, Date ehfechafin, Date ehfecha,
			String ehhora, String ehtexto, String ehcoortraspaso, String ehcodigorelacionado, String mocodigo,
			String monombre, String ehestadotramite, String indVariosDocumentos, String q5codocumento, String q5nofile,
			Blob q5datafile, Integer q5sizefile, String q5tedesfile, String q5contenttypefile, String situacionacuse,
			Date ehfechaEnvioBOPVBOE, String envcdessitcorreoses, String envcdessitcorreoseu,
			String ehidorganismocolabsol, String ehproceedingsidplatea, String decodigo, String denombre,
			String denombree, String origenDestino, String nomDestinatario, String tipoInterviniente,
			String ehacusereintentado, String ehistelematico, String ehissir, String ehissirconnumregentori,
			String ehIsWebSinCertificado) {
		super();
		this.ehcodigo = ehcodigo;
		this.hdcodigo = hdcodigo;
		this.fcodigo = fcodigo;
		this.fnombre = fnombre;
		this.fnombree = fnombree;
		this.trcodigo = trcodigo;
		this.trnombre = trnombre;
		this.trnombree = trnombree;
		this.ehfechainicio = ehfechainicio;
		this.ehfechafin = ehfechafin;
		this.ehfecha = ehfecha;
		this.ehhora = ehhora;
		this.ehtexto = ehtexto;
		this.ehcoortraspaso = ehcoortraspaso;
		this.ehcodigorelacionado = ehcodigorelacionado;
		this.mocodigo = mocodigo;
		this.monombre = monombre;
		this.ehestadotramite = ehestadotramite;
		this.indVariosDocumentos = indVariosDocumentos;
		this.q5codocumento = q5codocumento;
		this.q5nofile = q5nofile;
		this.q5datafile = q5datafile;
		this.q5sizefile = q5sizefile;
		this.q5tedesfile = q5tedesfile;
		this.q5contenttypefile = q5contenttypefile;
		this.situacionacuse = situacionacuse;
		this.ehfechaEnvioBOPVBOE = ehfechaEnvioBOPVBOE;
		this.envcdessitcorreoses = envcdessitcorreoses;
		this.envcdessitcorreoseu = envcdessitcorreoseu;
		this.ehidorganismocolabsol = ehidorganismocolabsol;
		this.ehproceedingsidplatea = ehproceedingsidplatea;

		this.decodigo = decodigo;
		this.denombre = denombre;
		this.denombree = denombree;
		this.origenDestino = origenDestino;
		this.nomDestinatario = nomDestinatario;
		this.tipoInterviniente = tipoInterviniente;

		this.ehacusereintentado = ehacusereintentado;
		this.ehistelematico = ehistelematico;
		this.ehissir = ehissir;
		this.ehissirconnumregentori = ehissirconnumregentori;
		this.ehIsWebSinCertificado = ehIsWebSinCertificado;
	}

	/**
	 * @return the ehcodigo
	 */
	public String getEhcodigo() {
		return ehcodigo;
	}

	/**
	 * @param ehcodigo
	 *            the ehcodigo to set
	 */
	public void setEhcodigo(String ehcodigo) {
		this.ehcodigo = ehcodigo;
	}

	/**
	 * @return the hdcodigo
	 */
	public String getHdcodigo() {
		return hdcodigo;
	}

	/**
	 * @param hdcodigo
	 *            the hdcodigo to set
	 */
	public void setHdcodigo(String hdcodigo) {
		this.hdcodigo = hdcodigo;
	}

	/**
	 * @return the fcodigo
	 */
	public String getFcodigo() {
		return fcodigo;
	}

	/**
	 * @param fcodigo
	 *            the fcodigo to set
	 */
	public void setFcodigo(String fcodigo) {
		this.fcodigo = fcodigo;
	}

	/**
	 * @return the fnombre
	 */
	public String getFnombre() {
		return fnombre;
	}

	/**
	 * @param fnombre
	 *            the fnombre to set
	 */
	public void setFnombre(String fnombre) {
		this.fnombre = fnombre;
	}

	/**
	 * @return the fnombree
	 */
	public String getFnombree() {
		return fnombree;
	}

	/**
	 * @param fnombree
	 *            the fnombree to set
	 */
	public void setFnombree(String fnombree) {
		this.fnombree = fnombree;
	}

	/**
	 * @return the trcodigo
	 */
	public String getTrcodigo() {
		return trcodigo;
	}

	/**
	 * @param trcodigo
	 *            the trcodigo to set
	 */
	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * @return the trnombre
	 */
	public String getTrnombre() {
		return trnombre;
	}

	/**
	 * @param trnombre
	 *            the trnombre to set
	 */
	public void setTrnombre(String trnombre) {
		this.trnombre = trnombre;
	}

	/**
	 * @return the trnombree
	 */
	public String getTrnombree() {
		return trnombree;
	}

	/**
	 * @param trnombree
	 *            the trnombree to set
	 */
	public void setTrnombree(String trnombree) {
		this.trnombree = trnombree;
	}

	/**
	 * @return the ehfechainicio
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getEhfechainicio() {
		return ehfechainicio;
	}

	/**
	 * @param ehfechainicio
	 *            the ehfechainicio to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setEhfechainicio(Date ehfechainicio) {
		this.ehfechainicio = ehfechainicio;
	}

	/**
	 * @return the ehfechafin
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getEhfechafin() {
		return ehfechafin;
	}

	/**
	 * @param ehfechafin
	 *            the ehfechafin to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setEhfechafin(Date ehfechafin) {
		this.ehfechafin = ehfechafin;
	}

	/**
	 * @return the mocodigo
	 */
	public String getMocodigo() {
		return mocodigo;
	}

	/**
	 * @param mocodigo
	 *            the mocodigo to set
	 */
	public void setMocodigo(String mocodigo) {
		this.mocodigo = mocodigo;
	}

	/**
	 * @return the monombre
	 */
	public String getMonombre() {
		return monombre;
	}

	/**
	 * @param monombre
	 *            the monombre to set
	 */
	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * @return the ehestadotramite
	 */
	public String getEhestadotramite() {
		return ehestadotramite;
	}

	/**
	 * @param ehestadotramite
	 *            the ehestadotramite to set
	 */
	public void setEhestadotramite(String ehestadotramite) {
		this.ehestadotramite = ehestadotramite;
	}

	/**
	 * @return the indVariosDocumentos
	 */
	public String getIndVariosDocumentos() {
		return indVariosDocumentos;
	}

	/**
	 * @param indVariosDocumentos
	 *            the indVariosDocumentos to set
	 */
	public void setIndVariosDocumentos(String indVariosDocumentos) {
		this.indVariosDocumentos = indVariosDocumentos;
	}

	/**
	 * @return the q5codocumento
	 */
	public String getQ5codocumento() {
		return q5codocumento;
	}

	/**
	 * @param q5codocumento
	 *            the q5codocumento to set
	 */
	public void setQ5codocumento(String q5codocumento) {
		this.q5codocumento = q5codocumento;
	}

	/**
	 * @return the q5nofile
	 */
	public String getQ5nofile() {
		return q5nofile;
	}

	/**
	 * @param q5nofile
	 *            the q5nofile to set
	 */
	public void setQ5nofile(String q5nofile) {
		this.q5nofile = q5nofile;
	}

	/**
	 * @return the q5datafile
	 */
	@JsonIgnore
	public Blob getQ5datafile() {
		return q5datafile;
	}

	/**
	 * @param q5datafile
	 *            the q5datafile to set
	 */
	public void setQ5datafile(Blob q5datafile) {
		this.q5datafile = q5datafile;
	}

	/**
	 * @return the q5sizefile
	 */
	public Integer getQ5sizefile() {
		return q5sizefile;
	}

	/**
	 * @param q5sizefile
	 *            the q5sizefile to set
	 */
	public void setQ5sizefile(Integer q5sizefile) {
		this.q5sizefile = q5sizefile;
	}

	/**
	 * @return the q5tedesfile
	 */
	public String getQ5tedesfile() {
		return q5tedesfile;
	}

	/**
	 * @param q5tedesfile
	 *            the q5tedesfile to set
	 */
	public void setQ5tedesfile(String q5tedesfile) {
		this.q5tedesfile = q5tedesfile;
	}

	/**
	 * @return the q5contenttypefile
	 */
	public String getQ5contenttypefile() {
		return q5contenttypefile;
	}

	/**
	 * @param q5contenttypefile
	 *            the q5contenttypefile to set
	 */
	public void setQ5contenttypefile(String q5contenttypefile) {
		this.q5contenttypefile = q5contenttypefile;
	}

	/**
	 * @return the ehfecha
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getEhfecha() {
		return ehfecha;
	}

	/**
	 * @param ehfecha
	 *            the ehfecha to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setEhfecha(Date ehfecha) {
		this.ehfecha = ehfecha;
	}

	/**
	 * @return the ehhora
	 */
	public String getEhhora() {
		return ehhora;
	}

	/**
	 * @param ehhora
	 *            the ehhora to set
	 */
	public void setEhhora(String ehhora) {
		this.ehhora = ehhora;
	}

	/**
	 * @return the ehtexto
	 */
	public String getEhtexto() {
		return ehtexto;
	}

	/**
	 * @param ehtexto
	 *            the ehtexto to set
	 */
	public void setEhtexto(String ehtexto) {
		this.ehtexto = ehtexto;
	}

	/**
	 * @return the ehcoortraspaso
	 */
	public String getEhcoortraspaso() {
		return ehcoortraspaso;
	}

	/**
	 * @param ehcoortraspaso
	 *            the ehcoortraspaso to set
	 */
	public void setEhcoortraspaso(String ehcoortraspaso) {
		this.ehcoortraspaso = ehcoortraspaso;
	}

	/**
	 * @return the ehcodigorelacionado
	 */
	public String getEhcodigorelacionado() {
		return ehcodigorelacionado;
	}

	/**
	 * @param ehcodigorelacionado
	 *            the ehcodigorelacionado to set
	 */
	public void setEhcodigorelacionado(String ehcodigorelacionado) {
		this.ehcodigorelacionado = ehcodigorelacionado;
	}

	/**
	 * @return the situacionacuse
	 */
	public String getSituacionacuse() {
		return situacionacuse;
	}

	/**
	 * @param situacionacuse
	 *            the situacionacuse to set
	 */
	public void setSituacionacuse(String situacionacuse) {
		this.situacionacuse = situacionacuse;
	}

	/**
	 * @return the ehfechaEnvioBOPVBOE
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getEhfechaEnvioBOPVBOE() {
		return ehfechaEnvioBOPVBOE;
	}

	/**
	 * @param ehfechaEnvioBOPVBOE
	 *            the ehfechaEnvioBOPVBOE to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setEhfechaEnvioBOPVBOE(Date ehfechaEnvioBOPVBOE) {
		this.ehfechaEnvioBOPVBOE = ehfechaEnvioBOPVBOE;
	}

	/**
	 * @return the ehidorganismocolabsol
	 */
	public String getEhidorganismocolabsol() {
		return ehidorganismocolabsol;
	}

	/**
	 * @param ehidorganismocolabsol
	 *            the ehidorganismocolabsol to set
	 */
	public void setEhidorganismocolabsol(String ehidorganismocolabsol) {
		this.ehidorganismocolabsol = ehidorganismocolabsol;
	}

	/**
	 * @return the envcdessitcorreoseu
	 */
	public String getEnvcdessitcorreoseu() {
		return envcdessitcorreoseu;
	}

	/**
	 * @param envcdessitcorreoseu
	 *            the envcdessitcorreoseu to set
	 */
	public void setEnvcdessitcorreoseu(String envcdessitcorreoseu) {
		this.envcdessitcorreoseu = envcdessitcorreoseu;
	}

	/**
	 * @return the envcdessitcorreoses
	 */
	public String getEnvcdessitcorreoses() {
		return envcdessitcorreoses;
	}

	/**
	 * @param envcdessitcorreoses
	 *            the envcdessitcorreoses to set
	 */
	public void setEnvcdessitcorreoses(String envcdessitcorreoses) {
		this.envcdessitcorreoses = envcdessitcorreoses;
	}

	/**
	 * @return the ehproceedingsidplatea
	 */
	public String getEhproceedingsidplatea() {
		return ehproceedingsidplatea;
	}

	/**
	 * @param ehproceedingsidplatea
	 *            the ehproceedingsidplatea to set
	 */
	public void setEhproceedingsidplatea(String ehproceedingsidplatea) {
		this.ehproceedingsidplatea = ehproceedingsidplatea;
	}

	/**
	 * @return the decodigo
	 */
	public String getDecodigo() {
		return decodigo;
	}

	/**
	 * @param decodigo
	 *            the decodigo to set
	 */
	public void setDecodigo(String decodigo) {
		this.decodigo = decodigo;
	}

	/**
	 * @return the denombre
	 */
	public String getDenombre() {
		return denombre;
	}

	/**
	 * @param denombre
	 *            the denombre to set
	 */
	public void setDenombre(String denombre) {
		this.denombre = denombre;
	}

	/**
	 * @return the denombree
	 */
	public String getDenombree() {
		return denombree;
	}

	/**
	 * @param denombree
	 *            the denombree to set
	 */
	public void setDenombree(String denombree) {
		this.denombree = denombree;
	}

	/**
	 * @return the origenDestino
	 */
	public String getOrigenDestino() {
		return origenDestino;
	}

	/**
	 * @param origenDestino
	 *            the origenDestino to set
	 */
	public void setOrigenDestino(String origenDestino) {
		this.origenDestino = origenDestino;
	}

	/**
	 * @return the nomDestinatario
	 */
	public String getNomDestinatario() {
		return nomDestinatario;
	}

	/**
	 * @param nomDestinatario
	 *            the nomDestinatario to set
	 */
	public void setNomDestinatario(String nomDestinatario) {
		this.nomDestinatario = nomDestinatario;
	}

	/**
	 * @return the tipoInterviniente
	 */
	public String getTipoInterviniente() {
		return tipoInterviniente;
	}

	/**
	 * @param tipoInterviniente
	 *            the tipoInterviniente to set
	 */
	public void setTipoInterviniente(String tipoInterviniente) {
		this.tipoInterviniente = tipoInterviniente;
	}

	/**
	 * @return the ehacusereintentado
	 */
	public String getEhacusereintentado() {
		return ehacusereintentado;
	}

	/**
	 * @param ehacusereintentado
	 *            the ehacusereintentado to set
	 */
	public void setEhacusereintentado(String ehacusereintentado) {
		this.ehacusereintentado = ehacusereintentado;
	}

	/**
	 * @return the ehistelematico
	 */
	public String getEhistelematico() {
		return ehistelematico;
	}

	/**
	 * @param ehistelematico
	 *            the ehistelematico to set
	 */
	public void setEhistelematico(String ehistelematico) {
		this.ehistelematico = ehistelematico;
	}

	/**
	 * @return the ehissir
	 */
	public String getEhissir() {
		return ehissir;
	}

	/**
	 * @param ehissir
	 *            the ehissir to set
	 */
	public void setEhissir(String ehissir) {
		this.ehissir = ehissir;
	}

	/**
	 * @return the ehissirconnumregentori
	 */
	public String getEhissirconnumregentori() {
		return ehissirconnumregentori;
	}

	/**
	 * @param ehissirconnumregentori
	 *            the ehissirconnumregentori to set
	 */
	public void setEhissirconnumregentori(String ehissirconnumregentori) {
		this.ehissirconnumregentori = ehissirconnumregentori;
	}

	/**
	 * @return the ehIsWebSinCertificado
	 */
	public String getEhIsWebSinCertificado() {
		return ehIsWebSinCertificado;
	}

	/**
	 * @param ehIsWebSinCertificado
	 *            the ehIsWebSinCertificado to set
	 */
	public void setEhIsWebSinCertificado(String ehIsWebSinCertificado) {
		this.ehIsWebSinCertificado = ehIsWebSinCertificado;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "TramiteHechoDetalle [ehcodigo=" + ehcodigo + ", hdcodigo=" + hdcodigo + ", fcodigo=" + fcodigo
				+ ", fnombre=" + fnombre + ", fnombree=" + fnombree + ", trcodigo=" + trcodigo + ", trnombre="
				+ trnombre + ", trnombree=" + trnombree + ", ehfechainicio=" + ehfechainicio + ", ehfechafin="
				+ ehfechafin + ", ehfecha=" + ehfecha + ", ehhora=" + ehhora + ", ehtexto=" + ehtexto
				+ ", ehcoortraspaso=" + ehcoortraspaso + ", ehcodigorelacionado=" + ehcodigorelacionado + ", mocodigo="
				+ mocodigo + ", monombre=" + monombre + ", ehestadotramite=" + ehestadotramite
				+ ", indVariosDocumentos=" + indVariosDocumentos + ", q5codocumento=" + q5codocumento + ", q5nofile="
				+ q5nofile + ", q5datafile=" + q5datafile + ", q5sizefile=" + q5sizefile + ", q5tedesfile="
				+ q5tedesfile + ", q5contenttypefile=" + q5contenttypefile + ", situacionacuse=" + situacionacuse
				+ ", ehfechaEnvioBOPVBOE=" + ehfechaEnvioBOPVBOE + ", ehidorganismocolabsol=" + ehidorganismocolabsol
				+ ", envcdessitcorreoseu=" + envcdessitcorreoseu + ", envcdessitcorreoses=" + envcdessitcorreoses
				+ ", ehproceedingsidplatea=" + ehproceedingsidplatea + ", decodigo=" + decodigo + ", denombre="
				+ denombre + ", denombree=" + denombree + ", origenDestino=" + origenDestino + ", nomDestinatario="
				+ nomDestinatario + ", tipoInterviniente=" + tipoInterviniente + "]";
	}
}
