package com.ejie.y41b.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;

/**
 * * TramiteComun  
 * 
 *  
 */

public class TramiteDatosBasicos extends TramiteComun implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Date fechaInicio;
	private Date fechaFin;
	private CensoMonitor instructorAsignado;
	private CensoMonitor instructorEjecucion;
	private String comentario;

	private String estadoTramite;
	private String permisoModificacion;
	private String istelematico;

	private String anyadirPlantilla;

	private List<DocumentoExpediente> documentosExpediente = new ArrayList<DocumentoExpediente>();

	private String isSIR;
	private String isSIRConNumRegEntOri;
	private String isWebSinCertificado;

	/**
	 * 
	 */
	public TramiteDatosBasicos() {
		super();
	}

	/**
	 * @param fechaInicio
	 * @param fechaFin
	 * @param instructorAsignado
	 * @param instructorEjecucion
	 * @param comentario
	 * @param estadoTramite
	 * @param permisoModificacion
	 */
	public TramiteDatosBasicos(Date fechaInicio, Date fechaFin, CensoMonitor instructorAsignado,
			CensoMonitor instructorEjecucion, String comentario, String estadoTramite, String permisoModificacion) {
		super();
		this.fechaInicio = fechaInicio;
		this.fechaFin = fechaFin;
		this.instructorAsignado = instructorAsignado;
		this.instructorEjecucion = instructorEjecucion;
		this.comentario = comentario;
		this.estadoTramite = estadoTramite;
		this.permisoModificacion = permisoModificacion;
	}

	/**
	 * @return the fechaInicio
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getFechaInicio() {
		return fechaInicio;
	}

	/**
	 * @param fechaInicio
	 *            the fechaInicio to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setFechaInicio(Date fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	/**
	 * @return the fechaFin
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getFechaFin() {
		return fechaFin;
	}

	/**
	 * @param fechaFin
	 *            the fechaFin to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setFechaFin(Date fechaFin) {
		this.fechaFin = fechaFin;
	}

	/**
	 * @return the instructorAsignado
	 */
	public CensoMonitor getInstructorAsignado() {
		return instructorAsignado;
	}

	/**
	 * @param instructorAsignado
	 *            the instructorAsignado to set
	 */
	public void setInstructorAsignado(CensoMonitor instructorAsignado) {
		this.instructorAsignado = instructorAsignado;
	}

	/**
	 * @return the instructorEjecucion
	 */
	public CensoMonitor getInstructorEjecucion() {
		return instructorEjecucion;
	}

	/**
	 * @param instructorEjecucion
	 *            the instructorEjecucion to set
	 */
	public void setInstructorEjecucion(CensoMonitor instructorEjecucion) {
		this.instructorEjecucion = instructorEjecucion;
	}

	/**
	 * @return the comentario
	 */
	public String getComentario() {
		return comentario;
	}

	/**
	 * @param comentario
	 *            the comentario to set
	 */
	public void setComentario(String comentario) {
		this.comentario = comentario;
	}

	/**
	 * @return the estadoTramite
	 */
	public String getEstadoTramite() {
		return estadoTramite;
	}

	/**
	 * @param estadoTramite
	 *            the estadoTramite to set
	 */
	public void setEstadoTramite(String estadoTramite) {
		this.estadoTramite = estadoTramite;
	}

	/**
	 * @return the permisoModificacion
	 */
	public String getPermisoModificacion() {
		return permisoModificacion;
	}

	/**
	 * @param permisoModificacion
	 *            the permisoModificacion to set
	 */
	public void setPermisoModificacion(String permisoModificacion) {
		this.permisoModificacion = permisoModificacion;
	}

	/**
	 * @return the anyadirPlantilla
	 */
	public String getAnyadirPlantilla() {
		return anyadirPlantilla;
	}

	/**
	 * @param anyadirPlantilla
	 *            the anyadirPlantilla to set
	 */
	public void setAnyadirPlantilla(String anyadirPlantilla) {
		this.anyadirPlantilla = anyadirPlantilla;
	}

	/**
	 * @return the documentosExpediente
	 */
	public List<DocumentoExpediente> getDocumentosExpediente() {
		return documentosExpediente;
	}

	/**
	 * @param documentosExpediente
	 *            the documentosExpediente to set
	 */
	public void setDocumentosExpediente(List<DocumentoExpediente> documentosExpediente) {
		this.documentosExpediente = documentosExpediente;
	}

	/**
	 * @return the istelematico
	 */
	public String getIstelematico() {
		return istelematico;
	}

	/**
	 * @param istelematico
	 *            the istelematico to set
	 */
	public void setIstelematico(String istelematico) {
		this.istelematico = istelematico;
	}

	public String getIsSIR() {
		return isSIR;
	}

	public void setIsSIR(String isSIR) {
		this.isSIR = isSIR;
	}

	/**
	 * @return the isSIRConNumRegEntOri
	 */
	public String getIsSIRConNumRegEntOri() {
		return isSIRConNumRegEntOri;
	}

	/**
	 * @param isSIRConNumRegEntOri
	 *            the isSIRConNumRegEntOri to set
	 */
	public void setIsSIRConNumRegEntOri(String isSIRConNumRegEntOri) {
		this.isSIRConNumRegEntOri = isSIRConNumRegEntOri;
	}

	/**
	 * @return the isWebSinCertificado
	 */
	public String getIsWebSinCertificado() {
		return isWebSinCertificado;
	}

	/**
	 * @param isWebSinCertificado
	 *            the isWebSinCertificado to set
	 */
	public void setIsWebSinCertificado(String isWebSinCertificado) {
		this.isWebSinCertificado = isWebSinCertificado;
	}

}
