package com.ejie.y41b.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;

/**
 * * fechaAcuerdoIncoacion  
 * 
 *  
 */

public class TramiteARBResolucion extends TramiteDatosBasicos implements
		java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private Date fechaReso;
	private String decision;
	private Date fechaDesistimiento;
	private String motivoInadmision;
	private Date fechaAcuerdo;
	private String importeAcuerdo;
	private String descAcuerdo;
	private String sacodigoAcumula;
	private String sacojaAc;
	private String sanrorAc;
	private String sanranAc;
	private String motivoTraslado;
	private String organismoTraslado;
	private String motivoNoLocalizado;

	private String notComReclamante;
	private String notComReclamado;
	private String notComOtros;

	private String anyadirPlantilla;

	// la resolucin viene de una aceptacin negativa
	private String origenAceptacionNegativa;
	// 0148096 valor para almacenar a quien va dirigido cuando es archivo por
	// error
	private String tramitesGenerar;

	/**
	 * 
	 */
	public TramiteARBResolucion() {
		super();
	}

	/**
	 * @return the notComReclamante
	 */
	public String getNotComReclamante() {
		return notComReclamante;
	}

	/**
	 * @param notComReclamante
	 *            the notComReclamante to set
	 */
	public void setNotComReclamante(String notComReclamante) {
		this.notComReclamante = notComReclamante;
	}

	/**
	 * @return the notComReclamado
	 */
	public String getNotComReclamado() {
		return notComReclamado;
	}

	/**
	 * @param notComReclamado
	 *            the notComReclamado to set
	 */
	public void setNotComReclamado(String notComReclamado) {
		this.notComReclamado = notComReclamado;
	}

	/**
	 * @return the notComOtros
	 */
	public String getNotComOtros() {
		return notComOtros;
	}

	/**
	 * @param notComOtros
	 *            the notComOtros to set
	 */
	public void setNotComOtros(String notComOtros) {
		this.notComOtros = notComOtros;
	}

	/**
	 * @return the decision
	 */
	public String getDecision() {
		return decision;
	}

	/**
	 * @param decision
	 *            the decision to set
	 */
	public void setDecision(String decision) {
		this.decision = decision;
	}

	/**
	 * @return the fechaReso
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getFechaReso() {
		return fechaReso;
	}

	/**
	 * @param fechaReso
	 *            the fechaReso to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setFechaReso(Date fechaReso) {
		this.fechaReso = fechaReso;
	}

	/**
	 * @return the fechaDesistimiento
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getFechaDesistimiento() {
		return fechaDesistimiento;
	}

	/**
	 * @param fechaDesistimiento
	 *            the fechaDesistimiento to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setFechaDesistimiento(Date fechaDesistimiento) {
		this.fechaDesistimiento = fechaDesistimiento;
	}

	/**
	 * @return the motivoInadmision
	 */
	public String getMotivoInadmision() {
		return motivoInadmision;
	}

	/**
	 * @param motivoInadmision
	 *            the motivoInadmision to set
	 */
	public void setMotivoInadmision(String motivoInadmision) {
		this.motivoInadmision = motivoInadmision;
	}

	/**
	 * @return the fechaAcuerdo
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getFechaAcuerdo() {
		return fechaAcuerdo;
	}

	/**
	 * @param fechaAcuerdo
	 *            the fechaAcuerdo to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setFechaAcuerdo(Date fechaAcuerdo) {
		this.fechaAcuerdo = fechaAcuerdo;
	}

	/**
	 * @return the importeAcuerdo
	 */
	public String getImporteAcuerdo() {
		return importeAcuerdo;
	}

	/**
	 * @param importeAcuerdo
	 *            the importeAcuerdo to set
	 */
	public void setImporteAcuerdo(String importeAcuerdo) {
		this.importeAcuerdo = importeAcuerdo;
	}

	/**
	 * @return the descAcuerdo
	 */
	public String getDescAcuerdo() {
		return descAcuerdo;
	}

	/**
	 * @param descAcuerdo
	 *            the descAcuerdo to set
	 */
	public void setDescAcuerdo(String descAcuerdo) {
		this.descAcuerdo = descAcuerdo;
	}

	/**
	 * @return the sacodigoAcumula
	 */
	public String getSacodigoAcumula() {
		return sacodigoAcumula;
	}

	/**
	 * @param sacodigoAcumula
	 *            the sacodigoAcumula to set
	 */
	public void setSacodigoAcumula(String sacodigoAcumula) {
		this.sacodigoAcumula = sacodigoAcumula;
	}

	/**
	 * @return the motivoTraslado
	 */
	public String getMotivoTraslado() {
		return motivoTraslado;
	}

	/**
	 * @param motivoTraslado
	 *            the motivoTraslado to set
	 */
	public void setMotivoTraslado(String motivoTraslado) {
		this.motivoTraslado = motivoTraslado;
	}

	/**
	 * @return the organismoTraslado
	 */
	public String getOrganismoTraslado() {
		return organismoTraslado;
	}

	/**
	 * @param organismoTraslado
	 *            the organismoTraslado to set
	 */
	public void setOrganismoTraslado(String organismoTraslado) {
		this.organismoTraslado = organismoTraslado;
	}

	/**
	 * @return the motivoNoLocalizado
	 */
	public String getMotivoNoLocalizado() {
		return motivoNoLocalizado;
	}

	/**
	 * @param motivoNoLocalizado
	 *            the motivoNoLocalizado to set
	 */
	public void setMotivoNoLocalizado(String motivoNoLocalizado) {
		this.motivoNoLocalizado = motivoNoLocalizado;
	}

	/**
	 * @return the anyadirPlantilla
	 */
	public String getAnyadirPlantilla() {
		return anyadirPlantilla;
	}

	/**
	 * @param anyadirPlantilla
	 *            the anyadirPlantilla to set
	 */
	public void setAnyadirPlantilla(String anyadirPlantilla) {
		this.anyadirPlantilla = anyadirPlantilla;
	}

	/**
	 * @return the sacojaAc
	 */
	public String getSacojaAc() {
		return sacojaAc;
	}

	/**
	 * @param sacojaAc
	 *            the sacojaAc to set
	 */
	public void setSacojaAc(String sacojaAc) {
		this.sacojaAc = sacojaAc;
	}

	/**
	 * @return the sanrorAc
	 */
	public String getSanrorAc() {
		return sanrorAc;
	}

	/**
	 * @param sanrorAc
	 *            the sanrorAc to set
	 */
	public void setSanrorAc(String sanrorAc) {
		this.sanrorAc = sanrorAc;
	}

	/**
	 * @return the sanranAc
	 */
	public String getSanranAc() {
		return sanranAc;
	}

	/**
	 * @param sanranAc
	 *            the sanranAc to set
	 */
	public void setSanranAc(String sanranAc) {
		this.sanranAc = sanranAc;
	}

	/**
	 * @return the origenAceptacionNegativa
	 */
	public String getOrigenAceptacionNegativa() {
		return origenAceptacionNegativa;
	}

	/**
	 * @param origenAceptacionNegativa
	 *            the origenAceptacionNegativa to set
	 */
	public void setOrigenAceptacionNegativa(String origenAceptacionNegativa) {
		this.origenAceptacionNegativa = origenAceptacionNegativa;
	}

	public void setTramitesGenerar(String tramitesGenerar) {
		this.tramitesGenerar = tramitesGenerar;
	}

	public String getTramitesGenerar() {
		return tramitesGenerar;
	}

}
