package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Tramite  
 * 
 *  
 */

public class Tramite implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String trcodigo;
	private Fase fase;
	private String trnombre;
	private String trnombree;
	private Date trbaja;
	private String iskontsumonet;
	private String pcodigo;
	private String idPerfil;
	private Long plazo;
	private List<PlantillaTramite> plantillaTramites = new ArrayList<PlantillaTramite>();

	/**
	 * Method 'Tramite'.
	 */
	public Tramite() {
	}

	/**
	 * Method 'Tramite'.
	 * 
	 * @param trcodigo
	 *            the trcodigo
	 */
	public Tramite(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * Method 'Tramite'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param trnombre
	 *            String
	 * @param trnombree
	 *            String
	 * @param trbaja
	 *            Date
	 * @param iskontsumonet
	 *            String
	 * @param pcodigo
	 *            String
	 * @param idPerfil
	 *            String
	 * @param plazo
	 *            Long
	 * @param fase
	 *            Fase
	 */
	public Tramite(String trcodigo, String trnombre, String trnombree,
			Date trbaja, String iskontsumonet, String pcodigo, String idPerfil,
			Long plazo, Fase fase) {
		this.trcodigo = trcodigo;
		this.fase = fase;
		this.trnombre = trnombre;
		this.trnombree = trnombree;
		this.trbaja = trbaja;
		this.iskontsumonet = iskontsumonet;
		this.pcodigo = pcodigo;
		this.idPerfil = idPerfil;
		this.plazo = plazo;
	}

	/**
	 * Method 'Tramite'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param trnombre
	 *            String
	 * @param trnombree
	 *            String
	 */
	public Tramite(String trcodigo, String trnombre, String trnombree) {
		this.trcodigo = trcodigo;
		this.trnombre = trnombre;
		this.trnombree = trnombree;

	}

	/**
	 * Method 'Tramite'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param trnombre
	 *            String
	 * @param trnombree
	 *            String
	 * @param trbaja
	 *            Date
	 * @param iskontsumonet
	 *            String
	 * @param pcodigo
	 *            String
	 * @param idPerfil
	 *            String
	 * @param plazo
	 *            Long
	 * @param fase
	 *            Fase
	 * @param plantillaTramites
	 *            List<PlantillaTramite>
	 */
	public Tramite(String trcodigo, String trnombre, String trnombree,
			Date trbaja, String iskontsumonet, String pcodigo, String idPerfil,
			Long plazo, Fase fase, List<PlantillaTramite> plantillaTramites) {

		this.trcodigo = trcodigo;
		this.fase = fase;
		this.trnombre = trnombre;
		this.trnombree = trnombree;
		this.trbaja = trbaja;
		this.iskontsumonet = iskontsumonet;
		this.pcodigo = pcodigo;
		this.idPerfil = idPerfil;
		this.plazo = plazo;
		this.plantillaTramites = plantillaTramites;
	}

	/**
	 * Method 'getTrcodigo'.
	 * 
	 * @return String
	 */

	public String getTrcodigo() {
		return this.trcodigo;
	}

	/**
	 * Method 'setTrcodigo'.
	 * 
	 * @param trcodigo
	 *            String
	 * @return
	 */

	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * Method 'getFase'.
	 * 
	 * @return Fase
	 */
	public Fase getFase() {
		return this.fase;
	}

	/**
	 * Method 'setFase'.
	 * 
	 * @param fase
	 *            Fase
	 * @return
	 */

	public void setFase(Fase fase) {
		this.fase = fase;
	}

	/**
	 * Method 'getTrnombre'.
	 * 
	 * @return String
	 */

	public String getTrnombre() {
		return this.trnombre;
	}

	/**
	 * Method 'setTrnombre'.
	 * 
	 * @param trnombre
	 *            String
	 * @return
	 */

	public void setTrnombre(String trnombre) {
		this.trnombre = trnombre;
	}

	/**
	 * Method 'getTrnombree'.
	 * 
	 * @return String
	 */

	public String getTrnombree() {
		return this.trnombree;
	}

	/**
	 * Method 'setTrnombree'.
	 * 
	 * @param trnombree
	 *            String
	 * @return
	 */

	public void setTrnombree(String trnombree) {
		this.trnombree = trnombree;
	}

	/**
	 * Method 'getTrbaja'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrbaja() {
		return this.trbaja;
	}

	/**
	 * Method 'setTrbaja'.
	 * 
	 * @param trbaja
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrbaja(Date trbaja) {
		this.trbaja = trbaja;
	}

	/**
	 * Method 'getIskontsumonet'.
	 * 
	 * @return String
	 */

	public String getIskontsumonet() {
		return this.iskontsumonet;
	}

	/**
	 * Method 'setIskontsumonet'.
	 * 
	 * @param iskontsumonet
	 *            String
	 * @return
	 */

	public void setIskontsumonet(String iskontsumonet) {
		this.iskontsumonet = iskontsumonet;
	}

	/**
	 * Method 'getPcodigo'.
	 * 
	 * @return String
	 */

	public String getPcodigo() {
		return this.pcodigo;
	}

	/**
	 * Method 'setPcodigo'.
	 * 
	 * @param pcodigo
	 *            String
	 * @return
	 */

	public void setPcodigo(String pcodigo) {
		this.pcodigo = pcodigo;
	}

	/**
	 * Method 'getIdPerfil'.
	 * 
	 * @return String
	 */

	public String getIdPerfil() {
		return this.idPerfil;
	}

	/**
	 * Method 'setIdPerfil'.
	 * 
	 * @param idPerfil
	 *            String
	 * @return
	 */

	public void setIdPerfil(String idPerfil) {
		this.idPerfil = idPerfil;
	}

	/**
	 * Method 'getPlantillaTramites'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<PlantillaTramite> getPlantillaTramites() {
		return this.plantillaTramites;
	}

	/**
	 * Method 'setPlantillaTramites'.
	 * 
	 * @param plantillaTramites
	 *            List
	 * @return
	 */
	public void setPlantillaTramites(List<PlantillaTramite> plantillaTramites) {
		this.plantillaTramites = plantillaTramites;
	}

	/**
	 * @return the plazo
	 */
	public Long getPlazo() {
		return plazo;
	}

	/**
	 * @param plazo
	 *            the plazo to set
	 */
	public void setPlazo(Long plazo) {
		this.plazo = plazo;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Tramite [trcodigo=" + trcodigo + ", fase=" + fase
				+ ", trnombre=" + trnombre + ", trnombree=" + trnombree
				+ ", trbaja=" + trbaja + ", iskontsumonet=" + iskontsumonet
				+ ", pcodigo=" + pcodigo + ", idPerfil=" + idPerfil
				+ ", plazo=" + plazo + ", plantillaTramites="
				+ plantillaTramites + "]";
	}
}
