package com.ejie.y41b.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;

/**
 * TipProtocolo  
 * 
 *  
 */

public class TipProtocolo implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String tpcodigo;
	private Campanha campanha;
	private String tpnombre;
	private String tpcotmo;
	private String tpestandar;
	private List<TipPregProtoc> tipPregProtocs = new ArrayList<TipPregProtoc>();
	private List<AdjuntarCampanhatipoprot> adjuntarCampanhatipoprots = new ArrayList<AdjuntarCampanhatipoprot>();
	private List<Campanha> campanhas = new ArrayList<Campanha>();
	private String atcodigo;
	private String preguntascontestadas;

	/**
	 * Method 'TipProtocolo'.
	 */
	public TipProtocolo() {
	}

	/**
	 * Method 'TipProtocolo'.
	 * 
	 * @param tpcodigo
	 *            String
	 * @param tpnombre
	 *            String
	 * @param tpcotmo
	 *            String
	 * @param tpestandar
	 *            String
	 * @param campanha
	 *            Campanha
	 */
	public TipProtocolo(String tpcodigo, String tpnombre, String tpcotmo,
			String tpestandar, Campanha campanha) {
		this.tpcodigo = tpcodigo;
		this.campanha = campanha;
		this.tpnombre = tpnombre;
		this.tpcotmo = tpcotmo;
		this.tpestandar = tpestandar;
	}

	/**
	 * Method 'TipProtocolo'.
	 * 
	 * @param tpcodigo
	 *            String
	 * @param tpnombre
	 *            String
	 * @param tpcotmo
	 *            String
	 * @param tpestandar
	 *            String
	 * @param campanha
	 *            Campanha
	 * @param tipPregProtocs
	 *            List<TipPregProtoc>
	 * @param adjuntarCampanhatipoprots
	 *            List<AdjuntarCampanhatipoprot>
	 * @param campanhas
	 *            List<Campanha>
	 */
	public TipProtocolo(String tpcodigo, String tpnombre, String tpcotmo,
			String tpestandar, Campanha campanha,
			List<TipPregProtoc> tipPregProtocs,
			List<AdjuntarCampanhatipoprot> adjuntarCampanhatipoprots,
			List<Campanha> campanhas) {

		this.tpcodigo = tpcodigo;
		this.campanha = campanha;
		this.tpnombre = tpnombre;
		this.tpcotmo = tpcotmo;
		this.tpestandar = tpestandar;
		this.tipPregProtocs = tipPregProtocs;
		this.adjuntarCampanhatipoprots = adjuntarCampanhatipoprots;
		this.campanhas = campanhas;
	}

	/**
	 * Method 'getTpcodigo'.
	 * 
	 * @return String
	 */

	public String getTpcodigo() {
		return this.tpcodigo;
	}

	/**
	 * Method 'setTpcodigo'.
	 * 
	 * @param tpcodigo
	 *            String
	 * @return
	 */

	public void setTpcodigo(String tpcodigo) {
		this.tpcodigo = tpcodigo;
	}

	/**
	 * Method 'getCampanha'.
	 * 
	 * @return Campanha
	 */
	@JsonIgnore
	public Campanha getCampanha() {
		return this.campanha;
	}

	/**
	 * Method 'setCampanha'.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return
	 */

	public void setCampanha(Campanha campanha) {
		this.campanha = campanha;
	}

	/**
	 * Method 'getTpnombre'.
	 * 
	 * @return String
	 */

	public String getTpnombre() {
		return this.tpnombre;
	}

	/**
	 * Method 'setTpnombre'.
	 * 
	 * @param tpnombre
	 *            String
	 * @return
	 */

	public void setTpnombre(String tpnombre) {
		this.tpnombre = tpnombre;
	}

	/**
	 * Method 'getTpcotmo'.
	 * 
	 * @return String
	 */

	public String getTpcotmo() {
		return this.tpcotmo;
	}

	/**
	 * Method 'setTpcotmo'.
	 * 
	 * @param tpcotmo
	 *            String
	 * @return
	 */

	public void setTpcotmo(String tpcotmo) {
		this.tpcotmo = tpcotmo;
	}

	/**
	 * Method 'getTpestandar'.
	 * 
	 * @return String
	 */

	public String getTpestandar() {
		return this.tpestandar;
	}

	/**
	 * Method 'setTpestandar'.
	 * 
	 * @param tpestandar
	 *            String
	 * @return
	 */

	public void setTpestandar(String tpestandar) {
		this.tpestandar = tpestandar;
	}

	/**
	 * Method 'getTipPregProtocs'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<TipPregProtoc> getTipPregProtocs() {
		return this.tipPregProtocs;
	}

	/**
	 * Method 'setTipPregProtocs'.
	 * 
	 * @param tipPregProtocs
	 *            List
	 * @return
	 */
	public void setTipPregProtocs(List<TipPregProtoc> tipPregProtocs) {
		this.tipPregProtocs = tipPregProtocs;
	}

	/**
	 * Method 'getAdjuntarCampanhatipoprots'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<AdjuntarCampanhatipoprot> getAdjuntarCampanhatipoprots() {
		return this.adjuntarCampanhatipoprots;
	}

	/**
	 * Method 'setAdjuntarCampanhatipoprots'.
	 * 
	 * @param adjuntarCampanhatipoprots
	 *            List
	 * @return
	 */
	public void setAdjuntarCampanhatipoprots(
			List<AdjuntarCampanhatipoprot> adjuntarCampanhatipoprots) {
		this.adjuntarCampanhatipoprots = adjuntarCampanhatipoprots;
	}

	/**
	 * Method 'getCampanhas'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Campanha> getCampanhas() {
		return this.campanhas;
	}

	/**
	 * Method 'setCampanhas'.
	 * 
	 * @param campanhas
	 *            List
	 * @return
	 */
	public void setCampanhas(List<Campanha> campanhas) {
		this.campanhas = campanhas;
	}

	/**
	 * @return the atcodigo
	 */
	public String getAtcodigo() {
		return atcodigo;
	}

	/**
	 * @param atcodigo
	 *            the atcodigo to set
	 */
	public void setAtcodigo(String atcodigo) {
		this.atcodigo = atcodigo;
	}

	/**
	 * @return the preguntascontestadas
	 */
	public String getPreguntascontestadas() {
		return preguntascontestadas;
	}

	/**
	 * @param preguntascontestadas
	 *            the preguntascontestadas to set
	 */
	public void setPreguntascontestadas(String preguntascontestadas) {
		this.preguntascontestadas = preguntascontestadas;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ tpcodigo: ").append(this.tpcodigo).append(" ]");
		result.append(", [ tpnombre: ").append(this.tpnombre).append(" ]");
		result.append(", [ tpcotmo: ").append(this.tpcotmo).append(" ]");
		result.append(", [ tpestandar: ").append(this.tpestandar).append(" ]");
		result.append("}");
		return result.toString();
	}

}
