package com.ejie.y41b.model;

import java.sql.Clob;
import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.xml.Y41bXMLUtils;
import java.io.IOException;

import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;

/**
 * Remesa  
 * 
 *  
 */

public class SolicitudTelematicaEventos implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String stCodigo;
	private String stTipoExpediente; // pcodigo
	private String stPnombre;
	private String stPnombree;
	private String stNumExpediente;
	private Date stFechaRegistro;
	private String stNumRegistro;
	private String stIdAccionTelematica;
	private Clob stXMLSolicitud;
	private List<DocumentoSolicitudTelematicaEventos> documentoSolicitudTelematicaEventos = new ArrayList<DocumentoSolicitudTelematicaEventos>();

	/**
	 * Method 'SolicitudTelematicaEventos'.
	 */
	public SolicitudTelematicaEventos() {
	}

	/**
	 * Method 'SolicitudTelematicaEventos'.
	 * 
	 * @param stCodigo
	 */
	public SolicitudTelematicaEventos(String stCodigo) {
		super();
		this.stCodigo = stCodigo;
	}

	/**
	 * Method 'SolicitudTelematicaEventos'.
	 * 
	 * @param stCodigo
	 *            String
	 * @param stTipoExpediente
	 *            String
	 * @param stPnombre
	 *            String
	 * @param stPnombree
	 *            String
	 * @param stNumExpediente
	 *            String
	 * @param stFechaRegistro
	 *            Date
	 * @param stNumRegistro
	 *            String
	 * @param stIdAccionTelematica
	 *            String
	 * @param stXMLSolicitud
	 *            Blob
	 */
	public SolicitudTelematicaEventos(String stCodigo, String stTipoExpediente, String stPnombre, String stPnombree,
			String stNumExpediente, Date stFechaRegistro, String stNumRegistro, String stIdAccionTelematica,
			Clob stXMLSolicitud) {

		this.stCodigo = stCodigo;
		this.stTipoExpediente = stTipoExpediente;
		this.stPnombre = stPnombre;
		this.stPnombree = stPnombree;
		this.stNumExpediente = stNumExpediente;
		this.stFechaRegistro = stFechaRegistro;
		this.stNumRegistro = stNumRegistro;
		this.stIdAccionTelematica = stIdAccionTelematica;
		this.stXMLSolicitud = stXMLSolicitud;

	}

	/**
	 * Method 'SolicitudTelematicaEventos'.
	 * 
	 * @param stCodigo
	 *            String
	 * 
	 * @param stXMLSolicitud
	 *            Blob
	 */
	public SolicitudTelematicaEventos(String stCodigo, Clob stXMLSolicitud) {

		this.stCodigo = stCodigo;
		this.stXMLSolicitud = stXMLSolicitud;

	}

	/**
	 * @return the stCodigo
	 */
	public String getStCodigo() {
		return stCodigo;
	}

	/**
	 * @param stCodigo
	 *            the stCodigo to set
	 */
	public void setStCodigo(String stCodigo) {
		this.stCodigo = stCodigo;
	}

	/**
	 * @return the stTipoExpediente
	 */
	public String getStTipoExpediente() {
		return stTipoExpediente;
	}

	/**
	 * @param stTipoExpediente
	 *            the stTipoExpediente to set
	 */
	public void setStTipoExpediente(String stTipoExpediente) {
		this.stTipoExpediente = stTipoExpediente;
	}

	/**
	 * @return the stPnombre
	 */
	public String getStPnombre() {
		return stPnombre;
	}

	/**
	 * @param stPnombre
	 *            the stPnombre to set
	 */
	public void setStPnombre(String stPnombre) {
		this.stPnombre = stPnombre;
	}

	/**
	 * @return the stPnombree
	 */
	public String getStPnombree() {
		return stPnombree;
	}

	/**
	 * @param stPnombree
	 *            the stPnombree to set
	 */
	public void setStPnombree(String stPnombree) {
		this.stPnombree = stPnombree;
	}

	/**
	 * @return the stNumExpediente
	 */
	public String getStNumExpediente() {
		return stNumExpediente;
	}

	/**
	 * @param stNumExpediente
	 *            the stNumExpediente to set
	 */
	public void setStNumExpediente(String stNumExpediente) {
		this.stNumExpediente = stNumExpediente;
	}

	/**
	 * @return the stFechaRegistro
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getStFechaRegistro() {
		return stFechaRegistro;
	}

	/**
	 * @param stFechaRegistro
	 *            the stFechaRegistro to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setStFechaRegistro(Date stFechaRegistro) {
		this.stFechaRegistro = stFechaRegistro;
	}

	/**
	 * @return the stNumRegistro
	 */
	public String getStNumRegistro() {
		return stNumRegistro;
	}

	/**
	 * @param stNumRegistro
	 *            the stNumRegistro to set
	 */
	public void setStNumRegistro(String stNumRegistro) {
		this.stNumRegistro = stNumRegistro;
	}

	/**
	 * @return the stIdAccionTelematica
	 */
	public String getStIdAccionTelematica() {
		return stIdAccionTelematica;
	}

	/**
	 * @param stIdAccionTelematica
	 *            the stIdAccionTelematica to set
	 */
	public void setStIdAccionTelematica(String stIdAccionTelematica) {
		this.stIdAccionTelematica = stIdAccionTelematica;
	}

	/**
	 * @return the stXMLSolicitud
	 */
	@JsonIgnore
	public Clob getStXMLSolicitud() {
		return stXMLSolicitud;
	}

	/**
	 * @param stXMLSolicitud
	 *            the stXMLSolicitud to set
	 */
	public void setStXMLSolicitud(Clob stXMLSolicitud) {
		this.stXMLSolicitud = stXMLSolicitud;
	}

	/**
	 * Method 'setXmlsolicitud'.
	 * 
	 * @param xmlsolicitud
	 * 
	 * @throws IOException
	 *             e
	 * @throws SQLException
	 *             e
	 */
	public void setStXMLSolicitud(String stXMLSolicitud) throws SQLException, IOException {
		this.stXMLSolicitud = Y41bUtils.stringToClob(Y41bXMLUtils.replaceXMLCharacters(stXMLSolicitud));
	}

	/**
	 * @return the documentoSolicitudTelematicaEventos
	 */
	@JsonIgnore
	public List<DocumentoSolicitudTelematicaEventos> getDocumentoSolicitudTelematicaEventos() {
		return documentoSolicitudTelematicaEventos;
	}

	/**
	 * @param documentoSolicitudTelematicaEventos
	 *            the documentoSolicitudTelematicaEventos to set
	 */
	public void setDocumentoSolicitudTelematicaEventos(
			List<DocumentoSolicitudTelematicaEventos> documentoSolicitudTelematicaEventos) {
		this.documentoSolicitudTelematicaEventos = documentoSolicitudTelematicaEventos;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ stCodigo: ").append(this.stCodigo).append(" ]");
		result.append(", [ stTipoExpediente: ").append(this.stTipoExpediente).append(" ]");
		result.append(", [ stPnombre: ").append(this.stPnombre).append(" ]");
		result.append(", [ stPnombree: ").append(this.stPnombree).append(" ]");
		result.append(", [ stNumExpediente: ").append(this.stNumExpediente).append(" ]");
		result.append(", [ stFechaRegistro: ").append(this.stFechaRegistro).append(" ]");
		result.append(", [ stNumRegistro: ").append(this.stNumRegistro).append(" ]");
		result.append(", [ stIdAccionTelematica: ").append(this.stIdAccionTelematica).append(" ]");
		result.append(", [ stXMLSolicitud: ").append(this.stXMLSolicitud).append(" ]");
		result.append("}");
		return result.toString();
	}

}
