package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.format.annotation.NumberFormat;
import org.springframework.format.annotation.NumberFormat.Style;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;

/**
 * * SolicitudBusqueda  
 * 
 *  
 */

public class SolicitudDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	// Denuncia
	private String decodigo;
	@Length(max = 6, message = "error01.length.decoor")
	private String decoor;
	@Digits(integer = 4, fraction = 0, message = "error02.length.denran")
	@NumberFormat(style = NumberFormat.Style.NUMBER)
	private Integer denran;
	@Digits(integer = 11, fraction = 0, message = "error04.length.denror")
	@NumberFormat(style = NumberFormat.Style.NUMBER)
	private Long denror;
	@NotNull(message = "error06.required.defede")
	private Date defede;
	@NotNull(message = "error07.required.defere")
	private Date defere;
	private String dehojareclamacion;

	// Forma Presentacion
	@NotEmpty(message = "error08.required.tfpcodigo")
	@NotNull()
	@Length(max = 1, message = "error08.lenght.tfpcodigo")
	private String tfpcodigo;
	@Length(max = 30, message = "error09.lenght.tfpnombre")
	private String tfpnombre;
	@Length(max = 30, message = "error09.lenght.tfpnombree")
	private String tfpnombree;

	// Codigo expediente origen
	private String hdcodexpedienteorigen;

	// Forma Notificacion
	private String hdformanotificacion;
	private String hdformanotificacionestablecimiento;
	private String hddestnotificareclamante;
	private String hddestnotificareclamado;

	private String hdesnombretelematico;
	private String hdesdirecciontelematico;
	private String istelematico;

	// Numero de registro de entrada
	private String numregistroentrada;

	// Consumidor
	@NotEmpty(message = "error10.required.dtcodigo")
	@NotNull()
	@Length(max = 20, message = "error10.lenght.dtcodigo")
	private String dtcodigo;
	private String dtnombre;
	private String dtapellido1;
	private String dtapellido2;
	private String dtnif;
	private String dttecoem;
	private String dtnrtel;
	private String dtnombreProvincia;
	private String dtnombreMunicipio;
	private String dtnombreLocalidad;
	private String dtextranjero;
	private String dtnoraPaisNombre;
	private String dtdireccion_nocapv;

	// Establecimiento
	@NotEmpty(message = "error11.required.escodigo")
	@NotNull()
	@Length(max = 20, message = "error11.lenght.escodigo")
	private String escodigo;
	private String esnombre;
	private String esnif;
	private String esnoco;
	private String escoem;
	private String esnrtel;
	private String esinadar;
	private String esnombreProvincia;
	private String esnombreMunicipio;
	private String esnombreLocalidad;
	private String esextranjero;
	private String esnoraPaisNombre;
	private String esdireccion_nocapv;

	// Sector
	private String secodigo;
	private String senombre;
	private String senombree;

	// Hecho denuncia
	private String hdcodigo;
	@NotNull(message = "error12.required.hdfehd")
	private Date hdfehd;
	@NotEmpty(message = "error13.required.hdte")
	@Length(max = 4000, message = "error13.lenght.hdte")
	private String hdte;
	@Digits(integer = 11, fraction = 0, message = "error20.length.hdnror")
	@NumberFormat(style = Style.NUMBER)
	private Long hdnror;
	private String hdinsoma;
	private String hdinteresado;
	@Digits(integer = 8, fraction = 2, message = "error21.lenght.hdcaptso")
	// @NumberFormat(style = NumberFormat.Style.NUMBER)
	private BigDecimal hdcaptso;
	@Length(max = 255, message = "error16.lenght.hdteso")
	private String hdteso;

	@NotEmpty(message = "error05.required.hdcosc")
	@NotNull()
	@Length(max = 1, message = "error05.lenght.hdcosc")
	private String hdcosc;

	// Monitor
	@NotEmpty(message = "error22.required.mocodigo")
	@NotNull()
	@Length(max = 3, message = "error22.lenght.mocodigo")
	private String mocodigo;
	private String monombre;

	// Producto
	@Length(max = 20, message = "error14.lenght.pscodigo")
	@NotEmpty(message = "error14.required.pscodigo")
	@NotNull()
	private String pscodigo;
	@Length(max = 110, message = "error15.lenght.psnombre")
	private String psnombre;
	@Length(max = 110, message = "error15.lenght.psnombree")
	private String psnombree;

	// Nombre
	private String hdnops;
	// Marca
	private String hdnomaps;
	// Modelo
	private String hdnomops;
	// Numero lote
	private String hdnrlops;
	// Fecha duracion minima
	private Date hdfedmps;
	// Fecha cierre
	private Date hdfechacierre;
	// Codigo de barras
	private String hdcodigobarras;

	// Motivo
	@Length(max = 20, message = "error16.lenght.tircodigo")
	@NotEmpty(message = "error16.required.tircodigo")
	@NotNull()
	private String tircodigo;
	@Length(max = 100, message = "error17.lenght.tirnombre")
	private String tirnombre;

	// Tipo reclamacion
	@Length(max = 2, message = "error18.lenght.tsrcodigo")
	@NotEmpty(message = "error18.required.tsrcodigo")
	@NotNull()
	private String tsrcodigo;
	@Length(max = 30, message = "error19.lenght.tsrnombre")
	private String tsrnombre;
	@Length(max = 30, message = "error19.lenght.tsrnombree")
	private String tsrnombree;

	private String estado;
	private String numExpediente;
	private String codOrgConectado;
	private String hccoor;
	private Date hcfede;
	// tipo decisn
	private String hccottd;
	private String ihcoordt;
	private Date ihfereen;
	private String orgiskontsumonet;

	// Fase
	private String fcodigo;
	private String fnombre;
	private String fnombree;

	// Ultimo Tramite
	private String trcodigo;
	private String trnombre;
	private String trnombree;

	// Codigo trámite origen para obtener los posibles tramites
	private String trPosibleCodigo;

	private String permisoModificacion;

	private String permisoModificacionFechaHecho;

	private String permisoModificacionTipoSolicitud;

	private String permisoModificacionCambioResponsable;

	private String siguientesTramitesCambioResponsable;

	private String idsDescriptores;
	private String descsDescriptores;

	private String permisoConversionDenuncia;// 0135090

	// Indicios de infraccion
	private String hdininin;

	private String hdidioma;

	private String hdnumregistroentradaorigen;
	private Date hdfecharegistroorigen;

	private String fvcodigo;
	private String fvnombre;
	private String fvnombree;

	private String fvtelematicocodigo;
	private String fvtelematiconombre;
	private String fvtelematiconombree;

	// campo necesario para alta de arbitraje
	private boolean existeArbRel;
	private boolean existeDecisionCorrecta;

	private List<Descriptor> descriptores = new ArrayList<Descriptor>();

	// es solicitud o denuncia aacc
	private String hddenunciaaaccempresas;

	// datos telematicos si la denuncia se ha hecho via web
	private String denombretelematico;
	private String dedirecciontelematico;

	private String hdtipodenunciante;
	private String hdidiomareclamado;

	private String hdparticipacionreclamado;

	private String reclamanteCambio;
	private String reclamadoCambio;

	private String hdidparticipacionreclamante;
	private String hdidparticipacionreclamado;

	private String dtEstablecimientoCerrado;
	private String esEstablecimientoCerrado;

	// AsientoRegistral
	private String isSir;
	private String idAsiento;
	private String arSolicitante;
	private String arResumen;

	/**
	 * Constructor vacio
	 */
	public SolicitudDetalle() {
	}

	/**
	 * @param hdcodigo
	 *            String
	 * @param hdte
	 *            String
	 */
	public SolicitudDetalle(String hdcodigo, String hdte) {
		super();
		this.hdcodigo = hdcodigo;
		this.hdte = hdte;
	}

	/**
	 * @param decodigo
	 *            String
	 * @param decoor
	 *            String
	 * @param denran
	 *            Integer
	 * @param denror
	 *            Long
	 * @param defede
	 *            Date
	 * @param defere
	 *            Date
	 * @param dehojareclamacion
	 *            String
	 * @param tfpcodigo
	 *            String
	 * @param tfpnombre
	 *            String
	 * @param tfpnombree
	 *            String
	 * @param hdcodexpedienteorigen
	 *            String
	 * @param hdformanotificacion
	 *            String
	 * @param hdformanotificacionestablecimiento
	 *            String
	 * @param hdesnombretelematico
	 *            String
	 * @param hdesdirecciontelematico
	 *            String
	 * @param istelematico
	 *            String
	 * @param numregistroentrada
	 *            String
	 * @param dtcodigo
	 *            String
	 * @param dtnombre
	 *            String
	 * @param dtapellido1
	 *            String
	 * @param dtapellido2
	 *            String
	 * @param dtnif
	 *            String
	 * @param dttecoem
	 *            String
	 * @param dtnrtel
	 *            String
	 * @param dtnombreProvincia
	 *            String
	 * @param dtnombreMunicipio
	 *            String
	 * @param dtnombreLocalidad
	 *            String
	 * @param dtextranjero
	 *            String
	 * @param dtnoraPaisNombre
	 *            String
	 * @param dtdireccion_nocapv
	 *            String
	 * @param escodigo
	 *            String
	 * @param esnombre
	 *            String
	 * @param esnif
	 *            String
	 * @param esnoco
	 *            String
	 * @param escoem
	 *            String
	 * @param esnrtel
	 *            String
	 * @param esinadar
	 *            String
	 * @param esnombreProvincia
	 *            String
	 * @param esnombreMunicipio
	 *            String
	 * @param esnombreLocalidad
	 *            String
	 * @param esextranjero
	 *            String
	 * @param esnoraPaisNombre
	 *            String
	 * @param esdireccion_nocapv
	 *            String
	 * @param secodigo
	 *            String
	 * @param senombre
	 *            String
	 * @param senombree
	 *            String
	 * @param hdcodigo
	 *            String
	 * @param hdfehd
	 *            String
	 * @param hdte
	 *            String
	 * @param hdnror
	 *            Long
	 * @param hdinsoma
	 *            String
	 * @param hdcaptso
	 *            BigDecimal
	 * @param hdteso
	 *            String
	 * @param hdcosc
	 *            String
	 * @param mocodigo
	 *            String
	 * @param monombre
	 *            String
	 * @param pscodigo
	 *            String
	 * @param psnombre
	 *            String
	 * @param psnombree
	 *            String String
	 * @param hdnops
	 *            String
	 * @param hdnomaps
	 *            String
	 * @param hdcodigobarras
	 *            String
	 * @param hdinteresado
	 *            String
	 * @param hdnomops
	 *            String
	 * @param hdnrlops
	 *            String
	 * @param hdfedmps
	 *            Date
	 * @param tircodigo
	 *            String
	 * @param tirnombre
	 *            String
	 * @param tsrcodigo
	 *            String
	 * @param tsrnombre
	 *            String
	 * @param tsrnombree
	 *            String
	 * @param estado
	 *            String
	 * @param numExpediente
	 *            String
	 * @param codOrgConectado
	 *            String
	 * @param hccoor
	 *            String
	 * @param hcfede
	 *            Date
	 * @param ihcoordt
	 *            String
	 * @param ihfereen
	 *            Date
	 * @param orgiskontsumonet
	 *            String
	 * @param fcodigo
	 *            String
	 * @param fnombre
	 *            String
	 * @param fnombree
	 *            String
	 * @param trcodigo
	 *            String
	 * @param trnombre
	 *            String
	 * @param trnombree
	 *            String
	 * @param trPosibleCodigo
	 *            String
	 * @param permisoModificacion
	 *            String
	 * @param idsDescriptores
	 *            String
	 * @param descsDescriptores
	 *            String
	 * @param hdininin
	 *            String
	 * @param hdfechacierre
	 *            Date
	 * @param hdidioma
	 *            String
	 * @param hdnumregistroentradaorigen
	 *            String
	 * @param hdfecharegistroorigen
	 *            Date
	 * @param fvcodigo
	 *            String
	 * @param fvnombre
	 *            String
	 * @param fvnombree
	 *            String
	 * @param hccottd
	 *            String
	 * @param descriptores
	 *            List<Descriptor>
	 * @param hddenunciaaaccempresas
	 *            String
	 * @param denombretelematico
	 *            String
	 * @param dedirecciontelematico
	 *            String
	 * @param hdnombretelematico
	 *            String
	 * @param hddirecciontelematico
	 *            String
	 * @param hdtipodenunciante
	 *            String
	 * @param hdidiomareclamado
	 *            String
	 * @param hdparticipacionreclamado
	 *            String
	 * @param hddestnotificareclamante
	 *            String
	 * @param hddestnotificareclamado
	 *            String
	 * @param hdidparticipacionreclamante
	 *            String
	 * @param hdidparticipacionreclamado
	 *            String
	 * @param isSir
	 *            String
	 * @param arSolicitante
	 *            String
	 * @param arResumen
	 *            String
	 */
	public SolicitudDetalle(String decodigo, String decoor, Integer denran, Long denror, Date defede, Date defere,
			String dehojareclamacion, String tfpcodigo, String tfpnombre, String tfpnombree,
			String hdcodexpedienteorigen, String hdformanotificacion, String hdformanotificacionestablecimiento,
			String hdesnombretelematico, String hdesdirecciontelematico, String istelematico, String numregistroentrada,
			String dtcodigo, String dtnombre, String dtapellido1, String dtapellido2, String dtnif, String dttecoem,
			String dtnrtel, String dtnombreProvincia, String dtnombreMunicipio, String dtnombreLocalidad,
			String dtextranjero, String dtnoraPaisNombre, String dtdireccion_nocapv, String escodigo, String esnombre,
			String esnif, String esnoco, String escoem, String esnrtel, String esinadar, String esnombreProvincia,
			String esnombreMunicipio, String esnombreLocalidad, String esextranjero, String esnoraPaisNombre,
			String esdireccion_nocapv, String secodigo, String senombre, String senombree, String hdcodigo, Date hdfehd,
			String hdte, Long hdnror, String hdinsoma, BigDecimal hdcaptso, String hdteso, String hdcosc,
			String mocodigo, String monombre, String pscodigo, String psnombre, String psnombree, String hdnops,
			String hdnomaps, String hdcodigobarras, String hdinteresado, String hdnomops, String hdnrlops,
			Date hdfedmps, String tircodigo, String tirnombre, String tsrcodigo, String tsrnombre, String tsrnombree,
			String estado, String numExpediente, String codOrgConectado, String hccoor, Date hcfede, String ihcoordt,
			Date ihfereen, String orgiskontsumonet, String fcodigo, String fnombre, String fnombree, String trcodigo,
			String trnombre, String trnombree, String trPosibleCodigo, String permisoModificacion,
			String idsDescriptores, String descsDescriptores, String hdininin, Date hdfechacierre, String hdidioma,
			String hdnumregistroentradaorigen, Date hdfecharegistroorigen, String fvcodigo, String fvnombre,
			String fvnombree, String fvtelematicocodigo, String fvtelematiconombre, String fvtelematiconombree,
			String hccottd, List<Descriptor> descriptores, String hddenunciaaaccempresas, String denombretelematico,
			String dedirecciontelematico, String hdnombretelematico, String hddirecciontelematico,
			String hdtipodenunciante, String hdidiomareclamado, String hdparticipacionreclamado,
			String hddestnotificareclamante, String hddestnotificareclamado, String hdidparticipacionreclamante,
			String hdidparticipacionreclamado, String isSir, String arSolicitante, String arResumen) {
		super();
		this.decodigo = decodigo;
		this.decoor = decoor;
		this.denran = denran;
		this.denror = denror;
		this.defede = defede;
		this.defere = defere;
		this.dehojareclamacion = dehojareclamacion;
		this.tfpcodigo = tfpcodigo;
		this.tfpnombre = tfpnombre;
		this.tfpnombree = tfpnombree;
		this.hdcodexpedienteorigen = hdcodexpedienteorigen;
		this.hdformanotificacion = hdformanotificacion;
		this.hdformanotificacionestablecimiento = hdformanotificacionestablecimiento;
		this.hdesnombretelematico = hdesnombretelematico;
		this.hdesdirecciontelematico = hdesdirecciontelematico;
		this.istelematico = istelematico;
		this.numregistroentrada = numregistroentrada;
		this.dtcodigo = dtcodigo;
		this.dtnombre = dtnombre;
		this.dtapellido1 = dtapellido1;
		this.dtapellido2 = dtapellido2;
		this.dtnif = dtnif;
		this.dttecoem = dttecoem;
		this.dtnrtel = dtnrtel;
		this.dtnombreProvincia = dtnombreProvincia;
		this.dtnombreMunicipio = dtnombreMunicipio;
		this.dtnombreLocalidad = dtnombreLocalidad;
		this.dtextranjero = dtextranjero;
		this.dtnoraPaisNombre = dtnoraPaisNombre;
		this.dtdireccion_nocapv = dtdireccion_nocapv;
		this.escodigo = escodigo;
		this.esnombre = esnombre;
		this.esnif = esnif;
		this.esnoco = esnoco;
		this.escoem = escoem;
		this.esnrtel = esnrtel;
		this.esinadar = esinadar;
		this.esnombreProvincia = esnombreProvincia;
		this.esnombreMunicipio = esnombreMunicipio;
		this.esnombreLocalidad = esnombreLocalidad;
		this.esextranjero = esextranjero;
		this.esnoraPaisNombre = esnoraPaisNombre;
		this.esdireccion_nocapv = esdireccion_nocapv;
		this.secodigo = secodigo;
		this.senombre = senombre;
		this.senombree = senombree;
		this.hdcodigo = hdcodigo;
		this.hdfehd = hdfehd;
		this.hdte = hdte;
		this.hdnror = hdnror;
		this.hdinsoma = hdinsoma;
		this.hdcaptso = hdcaptso;
		this.hdteso = hdteso;
		this.hdcosc = hdcosc;
		this.mocodigo = mocodigo;
		this.monombre = monombre;
		this.pscodigo = pscodigo;
		this.psnombre = psnombre;
		this.psnombree = psnombree;
		this.hdnops = hdnops;
		this.hdnomaps = hdnomaps;
		this.hdcodigobarras = hdcodigobarras;
		this.hdinteresado = hdinteresado;
		this.hdnomops = hdnomops;
		this.hdnrlops = hdnrlops;
		this.hdfedmps = hdfedmps;
		this.tircodigo = tircodigo;
		this.tirnombre = tirnombre;
		this.tsrcodigo = tsrcodigo;
		this.tsrnombre = tsrnombre;
		this.tsrnombree = tsrnombree;
		this.estado = estado;
		this.numExpediente = numExpediente;
		this.codOrgConectado = codOrgConectado;
		this.hccoor = hccoor;
		this.hcfede = hcfede;
		this.ihcoordt = ihcoordt;
		this.ihfereen = ihfereen;
		this.orgiskontsumonet = orgiskontsumonet;
		this.fcodigo = fcodigo;
		this.fnombre = fnombre;
		this.fnombree = fnombree;
		this.trcodigo = trcodigo;
		this.trnombre = trnombre;
		this.trnombree = trnombree;
		this.trPosibleCodigo = trPosibleCodigo;
		this.permisoModificacion = permisoModificacion;
		this.idsDescriptores = idsDescriptores;
		this.descsDescriptores = descsDescriptores;
		this.hdininin = hdininin;
		this.hdfechacierre = hdfechacierre;
		this.hdidioma = hdidioma;

		this.hdnumregistroentradaorigen = hdnumregistroentradaorigen;
		this.hdfecharegistroorigen = hdfecharegistroorigen;
		this.fvcodigo = fvcodigo;
		this.fvnombre = fvnombre;
		this.fvnombree = fvnombree;

		this.fvtelematicocodigo = fvtelematicocodigo;
		this.fvtelematiconombre = fvtelematiconombre;
		this.fvtelematiconombree = fvtelematiconombree;

		this.hccottd = hccottd;

		this.descriptores = descriptores;

		this.hddenunciaaaccempresas = hddenunciaaaccempresas;

		this.denombretelematico = denombretelematico;
		this.dedirecciontelematico = dedirecciontelematico;
		this.hdesnombretelematico = hdnombretelematico;
		this.hdesdirecciontelematico = hddirecciontelematico;

		this.hdtipodenunciante = hdtipodenunciante;

		this.hdidiomareclamado = hdidiomareclamado;
		this.hdparticipacionreclamado = hdparticipacionreclamado;

		this.hddestnotificareclamante = hddestnotificareclamante;
		this.hddestnotificareclamado = hddestnotificareclamado;

		this.hdidparticipacionreclamante = hdidparticipacionreclamante;
		this.hdidparticipacionreclamado = hdidparticipacionreclamado;

		this.isSir = isSir;
		this.arSolicitante = arSolicitante;
		this.arResumen = arResumen;
	}

	/**
	 * @return the decodigo
	 */
	public String getDecodigo() {
		return decodigo;
	}

	/**
	 * @param decodigo
	 *            the decodigo to set
	 */
	public void setDecodigo(String decodigo) {
		this.decodigo = decodigo;
	}

	/**
	 * @return the decoor
	 */
	public String getDecoor() {
		return decoor;
	}

	/**
	 * @param decoor
	 *            the decoor to set
	 */
	public void setDecoor(String decoor) {
		this.decoor = decoor;
	}

	/**
	 * @return the defede
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getDefede() {
		return defede;
	}

	/**
	 * @param defede
	 *            the defede to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setDefede(Date defede) {
		this.defede = defede;
	}

	/**
	 * @return the defere
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getDefere() {
		return defere;
	}

	/**
	 * @param defere
	 *            the defere to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setDefere(Date defere) {
		this.defere = defere;
	}

	/**
	 * @return the tfpcodigo
	 */
	public String getTfpcodigo() {
		return tfpcodigo;
	}

	/**
	 * @param tfpcodigo
	 *            the tfpcodigo to set
	 */
	public void setTfpcodigo(String tfpcodigo) {
		this.tfpcodigo = tfpcodigo;
	}

	/**
	 * @return the tfpnombre
	 */
	public String getTfpnombre() {
		return tfpnombre;
	}

	/**
	 * @param tfpnombre
	 *            the tfpnombre to set
	 */
	public void setTfpnombre(String tfpnombre) {
		this.tfpnombre = tfpnombre;
	}

	/**
	 * @return the tfpnombree
	 */
	public String getTfpnombree() {
		return tfpnombree;
	}

	/**
	 * @param tfpnombree
	 *            the tfpnombree to set
	 */
	public void setTfpnombree(String tfpnombree) {
		this.tfpnombree = tfpnombree;
	}

	/**
	 * @return the dtcodigo
	 */
	public String getDtcodigo() {
		return dtcodigo;
	}

	/**
	 * @param dtcodigo
	 *            the dtcodigo to set
	 */
	public void setDtcodigo(String dtcodigo) {
		this.dtcodigo = dtcodigo;
	}

	/**
	 * @return the dtnombre
	 */
	public String getDtnombre() {
		return dtnombre;
	}

	/**
	 * @param dtnombre
	 *            the dtnombre to set
	 */
	public void setDtnombre(String dtnombre) {
		this.dtnombre = dtnombre;
	}

	/**
	 * @return the dtnif
	 */
	public String getDtnif() {
		return dtnif;
	}

	/**
	 * @param dtnif
	 *            the dtnif to set
	 */
	public void setDtnif(String dtnif) {
		this.dtnif = dtnif;
	}

	/**
	 * @return the dttecoem
	 */
	public String getDttecoem() {
		return dttecoem;
	}

	/**
	 * @param dttecoem
	 *            the dttecoem to set
	 */
	public void setDttecoem(String dttecoem) {
		this.dttecoem = dttecoem;
	}

	/**
	 * @return the dtnrtel
	 */
	public String getDtnrtel() {
		return dtnrtel;
	}

	/**
	 * @param dtnrtel
	 *            the dtnrtel to set
	 */
	public void setDtnrtel(String dtnrtel) {
		this.dtnrtel = dtnrtel;
	}

	/**
	 * @return the escodigo
	 */
	public String getEscodigo() {
		return escodigo;
	}

	/**
	 * @param escodigo
	 *            the escodigo to set
	 */
	public void setEscodigo(String escodigo) {
		this.escodigo = escodigo;
	}

	/**
	 * @return the esnombre
	 */
	public String getEsnombre() {
		return esnombre;
	}

	/**
	 * @param esnombre
	 *            the esnombre to set
	 */
	public void setEsnombre(String esnombre) {
		this.esnombre = esnombre;
	}

	/**
	 * @return the esnif
	 */
	public String getEsnif() {
		return esnif;
	}

	/**
	 * @param esnif
	 *            the esnif to set
	 */
	public void setEsnif(String esnif) {
		this.esnif = esnif;
	}

	/**
	 * @return the esnoco
	 */
	public String getEsnoco() {
		return esnoco;
	}

	/**
	 * @param esnoco
	 *            the esnoco to set
	 */
	public void setEsnoco(String esnoco) {
		this.esnoco = esnoco;
	}

	/**
	 * @return the esinadar
	 */
	public String getEsinadar() {
		return esinadar;
	}

	/**
	 * @param esinadar
	 *            the esinadar to set
	 */
	public void setEsinadar(String esinadar) {
		this.esinadar = esinadar;
	}

	/**
	 * @return the secodigo
	 */
	public String getSecodigo() {
		return secodigo;
	}

	/**
	 * @param secodigo
	 *            the secodigo to set
	 */
	public void setSecodigo(String secodigo) {
		this.secodigo = secodigo;
	}

	/**
	 * @return the senombre
	 */
	public String getSenombre() {
		return senombre;
	}

	/**
	 * @param senombre
	 *            the senombre to set
	 */
	public void setSenombre(String senombre) {
		this.senombre = senombre;
	}

	/**
	 * @return the senombree
	 */
	public String getSenombree() {
		return senombree;
	}

	/**
	 * @param senombree
	 *            the senombree to set
	 */
	public void setSenombree(String senombree) {
		this.senombree = senombree;
	}

	/**
	 * @return the hdcodigo
	 */
	public String getHdcodigo() {
		return hdcodigo;
	}

	/**
	 * @param hdcodigo
	 *            the hdcodigo to set
	 */
	public void setHdcodigo(String hdcodigo) {
		this.hdcodigo = hdcodigo;
	}

	/**
	 * @return the hdfehd
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getHdfehd() {
		return hdfehd;
	}

	/**
	 * @param hdfehd
	 *            the hdfehd to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setHdfehd(Date hdfehd) {
		this.hdfehd = hdfehd;
	}

	/**
	 * @return the hdte
	 */
	public String getHdte() {
		return hdte;
	}

	/**
	 * @param hdte
	 *            the hdte to set
	 */
	public void setHdte(String hdte) {
		this.hdte = hdte;
	}

	/**
	 * @return the hdinsoma
	 */
	public String getHdinsoma() {
		return hdinsoma;
	}

	/**
	 * @param hdinsoma
	 *            the hdinsoma to set
	 */
	public void setHdinsoma(String hdinsoma) {
		this.hdinsoma = hdinsoma;
	}

	/**
	 * @return the hdteso
	 */
	public String getHdteso() {
		return hdteso;
	}

	/**
	 * @param hdteso
	 *            the hdteso to set
	 */
	public void setHdteso(String hdteso) {
		this.hdteso = hdteso;
	}

	/**
	 * @return the hdcosc
	 */
	public String getHdcosc() {
		return hdcosc;
	}

	/**
	 * @param hdcosc
	 *            the hdcosc to set
	 */
	public void setHdcosc(String hdcosc) {
		this.hdcosc = hdcosc;
	}

	/**
	 * @return the mocodigo
	 */
	public String getMocodigo() {
		return mocodigo;
	}

	/**
	 * @param mocodigo
	 *            the mocodigo to set
	 */
	public void setMocodigo(String mocodigo) {
		this.mocodigo = mocodigo;
	}

	/**
	 * @return the monombre
	 */
	public String getMonombre() {
		return monombre;
	}

	/**
	 * @param monombre
	 *            the monombre to set
	 */
	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * @return the pscodigo
	 */
	public String getPscodigo() {
		return pscodigo;
	}

	/**
	 * @param pscodigo
	 *            the pscodigo to set
	 */
	public void setPscodigo(String pscodigo) {
		this.pscodigo = pscodigo;
	}

	/**
	 * @return the psnombre
	 */
	public String getPsnombre() {
		return psnombre;
	}

	/**
	 * @param psnombre
	 *            the psnombre to set
	 */
	public void setPsnombre(String psnombre) {
		this.psnombre = psnombre;
	}

	/**
	 * @return the psnombree
	 */
	public String getPsnombree() {
		return psnombree;
	}

	/**
	 * @param psnombree
	 *            the psnombree to set
	 */
	public void setPsnombree(String psnombree) {
		this.psnombree = psnombree;
	}

	/**
	 * @return the tircodigo
	 */
	public String getTircodigo() {
		return tircodigo;
	}

	/**
	 * @param tircodigo
	 *            the tircodigo to set
	 */
	public void setTircodigo(String tircodigo) {
		this.tircodigo = tircodigo;
	}

	/**
	 * @return the tirnombre
	 */
	public String getTirnombre() {
		return tirnombre;
	}

	/**
	 * @param tirnombre
	 *            the tirnombre to set
	 */
	public void setTirnombre(String tirnombre) {
		this.tirnombre = tirnombre;
	}

	/**
	 * @return the tsrcodigo
	 */
	public String getTsrcodigo() {
		return tsrcodigo;
	}

	/**
	 * @param tsrcodigo
	 *            the tsrcodigo to set
	 */
	public void setTsrcodigo(String tsrcodigo) {
		this.tsrcodigo = tsrcodigo;
	}

	/**
	 * @return the tsrnombre
	 */
	public String getTsrnombre() {
		return tsrnombre;
	}

	/**
	 * @param tsrnombre
	 *            the tsrnombre to set
	 */
	public void setTsrnombre(String tsrnombre) {
		this.tsrnombre = tsrnombre;
	}

	/**
	 * @return the tsrnombree
	 */
	public String getTsrnombree() {
		return tsrnombree;
	}

	/**
	 * @param tsrnombree
	 *            the tsrnombree to set
	 */
	public void setTsrnombree(String tsrnombree) {
		this.tsrnombree = tsrnombree;
	}

	/**
	 * @return the estado
	 */
	public String getEstado() {
		return estado;
	}

	/**
	 * @param estado
	 *            the estado to set
	 */
	public void setEstado(String estado) {
		this.estado = estado;
	}

	/**
	 * @return the numExpediente
	 */
	public String getNumExpediente() {
		return numExpediente;
	}

	/**
	 * @param numExpediente
	 *            the numExpediente to set
	 */
	public void setNumExpediente(String numExpediente) {
		this.numExpediente = numExpediente;
	}

	/**
	 * @return the codOrgConectado
	 */
	public String getCodOrgConectado() {
		return codOrgConectado;
	}

	/**
	 * @param codOrgConectado
	 *            the codOrgConectado to set
	 */
	public void setCodOrgConectado(String codOrgConectado) {
		this.codOrgConectado = codOrgConectado;
	}

	/**
	 * @return the hccoor
	 */
	public String getHccoor() {
		return hccoor;
	}

	/**
	 * @param hccoor
	 *            the hccoor to set
	 */
	public void setHccoor(String hccoor) {
		this.hccoor = hccoor;
	}

	/**
	 * @return the ihcoordt
	 */
	public String getIhcoordt() {
		return ihcoordt;
	}

	/**
	 * @param ihcoordt
	 *            the ihcoordt to set
	 */
	public void setIhcoordt(String ihcoordt) {
		this.ihcoordt = ihcoordt;
	}

	/**
	 * @return the ihfereen
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getIhfereen() {
		return ihfereen;
	}

	/**
	 * @param ihfereen
	 *            the ihfereen to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setIhfereen(Date ihfereen) {
		this.ihfereen = ihfereen;
	}

	/**
	 * @return the orgiskontsumonet
	 */
	public String getOrgiskontsumonet() {
		return orgiskontsumonet;
	}

	/**
	 * @param orgiskontsumonet
	 *            the orgiskontsumonet to set
	 */
	public void setOrgiskontsumonet(String orgiskontsumonet) {
		this.orgiskontsumonet = orgiskontsumonet;
	}

	/**
	 * @return the escoem
	 */
	public String getEscoem() {
		return escoem;
	}

	/**
	 * @param escoem
	 *            the escoem to set
	 */
	public void setEscoem(String escoem) {
		this.escoem = escoem;
	}

	/**
	 * @return the denran
	 */
	public Integer getDenran() {
		return denran;
	}

	/**
	 * @param denran
	 *            the denran to set
	 */
	public void setDenran(Integer denran) {
		this.denran = denran;
	}

	/**
	 * @return the denror
	 */
	public Long getDenror() {
		return denror;
	}

	/**
	 * @param denror
	 *            the denror to set
	 */
	public void setDenror(Long denror) {
		this.denror = denror;
	}

	/**
	 * @return the hdnror
	 */
	public Long getHdnror() {
		return hdnror;
	}

	/**
	 * @param hdnror
	 *            the hdnror to set
	 */
	public void setHdnror(Long hdnror) {
		this.hdnror = hdnror;
	}

	/**
	 * @return the hdcaptso
	 */
	public BigDecimal getHdcaptso() {
		return hdcaptso;
	}

	/**
	 * @param hdcaptso
	 *            the hdcaptso to set
	 */
	public void setHdcaptso(BigDecimal hdcaptso) {
		this.hdcaptso = hdcaptso;
	}

	/**
	 * @return the hcfede
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getHcfede() {
		return hcfede;
	}

	/**
	 * @param hcfede
	 *            the hcfede to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setHcfede(Date hcfede) {
		this.hcfede = hcfede;
	}

	/**
	 * @return the dtnombreMunicipio
	 */
	public String getDtnombreMunicipio() {
		return dtnombreMunicipio;
	}

	/**
	 * @param dtnombreMunicipio
	 *            the dtnombreMunicipio to set
	 */
	public void setDtnombreMunicipio(String dtnombreMunicipio) {
		this.dtnombreMunicipio = dtnombreMunicipio;
	}

	/**
	 * @return the esnombreMunicipio
	 */
	public String getEsnombreMunicipio() {
		return esnombreMunicipio;
	}

	/**
	 * @param esnombreMunicipio
	 *            the esnombreMunicipio to set
	 */
	public void setEsnombreMunicipio(String esnombreMunicipio) {
		this.esnombreMunicipio = esnombreMunicipio;
	}

	/**
	 * @return the numregistroentrada
	 */
	public String getNumregistroentrada() {
		return numregistroentrada;
	}

	/**
	 * @param numregistroentrada
	 *            the numregistroentrada to set
	 */
	public void setNumregistroentrada(String numregistroentrada) {
		this.numregistroentrada = numregistroentrada;
	}

	/**
	 * @return the fcodigo
	 */
	public String getFcodigo() {
		return fcodigo;
	}

	/**
	 * @param fcodigo
	 *            the fcodigo to set
	 */
	public void setFcodigo(String fcodigo) {
		this.fcodigo = fcodigo;
	}

	/**
	 * @return the fnombre
	 */
	public String getFnombre() {
		return fnombre;
	}

	/**
	 * @param fnombre
	 *            the fnombre to set
	 */
	public void setFnombre(String fnombre) {
		this.fnombre = fnombre;
	}

	/**
	 * @return the fnombree
	 */
	public String getFnombree() {
		return fnombree;
	}

	/**
	 * @param fnombree
	 *            the fnombree to set
	 */
	public void setFnombree(String fnombree) {
		this.fnombree = fnombree;
	}

	/**
	 * @return the trcodigo
	 */
	public String getTrcodigo() {
		return trcodigo;
	}

	/**
	 * @param trcodigo
	 *            the trcodigo to set
	 */
	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * @return the trnombre
	 */
	public String getTrnombre() {
		return trnombre;
	}

	/**
	 * @param trnombre
	 *            the trnombre to set
	 */
	public void setTrnombre(String trnombre) {
		this.trnombre = trnombre;
	}

	/**
	 * @return the trnombree
	 */
	public String getTrnombree() {
		return trnombree;
	}

	/**
	 * @param trnombree
	 *            the trnombree to set
	 */
	public void setTrnombree(String trnombree) {
		this.trnombree = trnombree;
	}

	/**
	 * @return the trPosibleCodigo
	 */
	public String getTrPosibleCodigo() {
		return trPosibleCodigo;
	}

	/**
	 * @param trPosibleCodigo
	 *            the trPosibleCodigo to set
	 */
	public void setTrPosibleCodigo(String trPosibleCodigo) {
		this.trPosibleCodigo = trPosibleCodigo;
	}

	/**
	 * @return the permisoModificacion
	 */
	public String getPermisoModificacion() {
		return permisoModificacion;
	}

	/**
	 * @param permisoModificacion
	 *            the permisoModificacion to set
	 */
	public void setPermisoModificacion(String permisoModificacion) {
		this.permisoModificacion = permisoModificacion;
	}

	/**
	 * @return the hdformanotificacion
	 */
	public String getHdformanotificacion() {
		return hdformanotificacion;
	}

	/**
	 * @param hdformanotificacion
	 *            the hdformanotificacion to set
	 */
	public void setHdformanotificacion(String hdformanotificacion) {
		this.hdformanotificacion = hdformanotificacion;
	}

	/**
	 * @return the hdcodexpedienteorigen
	 */
	public String getHdcodexpedienteorigen() {
		return hdcodexpedienteorigen;
	}

	/**
	 * @return the hdesnombretelematico
	 */
	public String getHdesnombretelematico() {
		return hdesnombretelematico;
	}

	/**
	 * @return the hdesdirecciontelematico
	 */
	public String getHdesdirecciontelematico() {
		return hdesdirecciontelematico;
	}

	/**
	 * @return the istelematico
	 */
	public String getistelematico() {
		return istelematico;
	}

	/**
	 * @param hdesnombretelematico
	 *            the hdesnombretelematico to set
	 */
	public void setHdesnombretelematico(String hdesnombretelematico) {
		this.hdesnombretelematico = hdesnombretelematico;
	}

	/**
	 * @param hdesdirecciontelematico
	 *            the hdesdirecciontelematico to set
	 */
	public void setHdesdirecciontelematico(String hdesdirecciontelematico) {
		this.hdesdirecciontelematico = hdesdirecciontelematico;
	}

	/**
	 * @param istelematico
	 *            the istelematico to set
	 */
	public void setistelematico(String istelematico) {
		this.istelematico = istelematico;
	}

	/**
	 * @param hdcodexpedienteorigen
	 *            the hdcodexpedienteorigen to set
	 */
	public void setHdcodexpedienteorigen(String hdcodexpedienteorigen) {
		this.hdcodexpedienteorigen = hdcodexpedienteorigen;
	}

	/**
	 * @return the dtapellido1
	 */
	public String getDtapellido1() {
		return dtapellido1;
	}

	/**
	 * @param dtapellido1
	 *            the dtapellido1 to set
	 */
	public void setDtapellido1(String dtapellido1) {
		this.dtapellido1 = dtapellido1;
	}

	/**
	 * @return the dtapellido2
	 */
	public String getDtapellido2() {
		return dtapellido2;
	}

	/**
	 * @param dtapellido2
	 *            the dtapellido2 to set
	 */
	public void setDtapellido2(String dtapellido2) {
		this.dtapellido2 = dtapellido2;
	}

	/**
	 * @return the dtnombreProvincia
	 */
	public String getDtnombreProvincia() {
		return dtnombreProvincia;
	}

	/**
	 * @param dtnombreProvincia
	 *            the dtnombreProvincia to set
	 */
	public void setDtnombreProvincia(String dtnombreProvincia) {
		this.dtnombreProvincia = dtnombreProvincia;
	}

	/**
	 * @return the dtnombreLocalidad
	 */
	public String getDtnombreLocalidad() {
		return dtnombreLocalidad;
	}

	/**
	 * @param dtnombreLocalidad
	 *            the dtnombreLocalidad to set
	 */
	public void setDtnombreLocalidad(String dtnombreLocalidad) {
		this.dtnombreLocalidad = dtnombreLocalidad;
	}

	/**
	 * @return the dtextranjero
	 */
	public String getDtextranjero() {
		return dtextranjero;
	}

	/**
	 * @param dtextranjero
	 *            the dtextranjero to set
	 */
	public void setDtextranjero(String dtextranjero) {
		this.dtextranjero = dtextranjero;
	}

	/**
	 * @return the dtnoraPaisNombre
	 */
	public String getDtnoraPaisNombre() {
		return dtnoraPaisNombre;
	}

	/**
	 * @param dtnoraPaisNombre
	 *            the dtnoraPaisNombre to set
	 */
	public void setDtnoraPaisNombre(String dtnoraPaisNombre) {
		this.dtnoraPaisNombre = dtnoraPaisNombre;
	}

	/**
	 * @return the dtdireccion_nocapv
	 */
	public String getDtdireccion_nocapv() {
		return dtdireccion_nocapv;
	}

	/**
	 * @param dtdireccion_nocapv
	 *            the dtdireccion_nocapv to set
	 */
	public void setDtdireccion_nocapv(String dtdireccion_nocapv) {
		this.dtdireccion_nocapv = dtdireccion_nocapv;
	}

	/**
	 * @return the esnombreProvincia
	 */
	public String getEsnombreProvincia() {
		return esnombreProvincia;
	}

	/**
	 * @param esnombreProvincia
	 *            the esnombreProvincia to set
	 */
	public void setEsnombreProvincia(String esnombreProvincia) {
		this.esnombreProvincia = esnombreProvincia;
	}

	/**
	 * @return the esnombreLocalidad
	 */
	public String getEsnombreLocalidad() {
		return esnombreLocalidad;
	}

	/**
	 * @param esnombreLocalidad
	 *            the esnombreLocalidad to set
	 */
	public void setEsnombreLocalidad(String esnombreLocalidad) {
		this.esnombreLocalidad = esnombreLocalidad;
	}

	/**
	 * @return the esextranjero
	 */
	public String getEsextranjero() {
		return esextranjero;
	}

	/**
	 * @param esextranjero
	 *            the esextranjero to set
	 */
	public void setEsextranjero(String esextranjero) {
		this.esextranjero = esextranjero;
	}

	/**
	 * @return the esnoraPaisNombre
	 */
	public String getEsnoraPaisNombre() {
		return esnoraPaisNombre;
	}

	/**
	 * @param esnoraPaisNombre
	 *            the esnoraPaisNombre to set
	 */
	public void setEsnoraPaisNombre(String esnoraPaisNombre) {
		this.esnoraPaisNombre = esnoraPaisNombre;
	}

	/**
	 * @return the esdireccion_nocapv
	 */
	public String getEsdireccion_nocapv() {
		return esdireccion_nocapv;
	}

	/**
	 * @param esdireccion_nocapv
	 *            the esdireccion_nocapv to set
	 */
	public void setEsdireccion_nocapv(String esdireccion_nocapv) {
		this.esdireccion_nocapv = esdireccion_nocapv;
	}

	/**
	 * @return the hdnomaps
	 */
	public String getHdnomaps() {
		return hdnomaps;
	}

	/**
	 * @param hdnomaps
	 *            the hdnomaps to set
	 */
	public void setHdnomaps(String hdnomaps) {
		this.hdnomaps = hdnomaps;
	}

	/**
	 * @return the hdnomops
	 */
	public String getHdnomops() {
		return hdnomops;
	}

	/**
	 * @param hdnomops
	 *            the hdnomops to set
	 */
	public void setHdnomops(String hdnomops) {
		this.hdnomops = hdnomops;
	}

	/**
	 * @return the hdnrlops
	 */
	public String getHdnrlops() {
		return hdnrlops;
	}

	/**
	 * @param hdnrlops
	 *            the hdnrlops to set
	 */
	public void setHdnrlops(String hdnrlops) {
		this.hdnrlops = hdnrlops;
	}

	/**
	 * @return the hdfedmps
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getHdfedmps() {
		return hdfedmps;
	}

	/**
	 * @param hdfedmps
	 *            the hdfedmps to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setHdfedmps(Date hdfedmps) {
		this.hdfedmps = hdfedmps;
	}

	/**
	 * @return the idsDescriptores
	 */
	public String getIdsDescriptores() {
		return idsDescriptores;
	}

	/**
	 * @param idsDescriptores
	 *            the idsDescriptores to set
	 */
	public void setIdsDescriptores(String idsDescriptores) {
		this.idsDescriptores = idsDescriptores;
	}

	/**
	 * @return the descsDescriptores
	 */
	public String getDescsDescriptores() {
		return descsDescriptores;
	}

	/**
	 * @param descsDescriptores
	 *            the descsDescriptores to set
	 */
	public void setDescsDescriptores(String descsDescriptores) {
		this.descsDescriptores = descsDescriptores;
	}

	/**
	 * @return the permisoConversionDenuncia
	 */
	public String getPermisoConversionDenuncia() {
		return permisoConversionDenuncia;
	}

	/**
	 * @param permisoConversionDenuncia
	 *            the permisoConversionDenuncia to set
	 */
	public void setPermisoConversionDenuncia(String permisoConversionDenuncia) {
		this.permisoConversionDenuncia = permisoConversionDenuncia;
	}

	/**
	 * @return the hdininin
	 */
	public String getHdininin() {
		return hdininin;
	}

	/**
	 * @param hdininin
	 *            the hdininin to set
	 */
	public void setHdininin(String hdininin) {
		this.hdininin = hdininin;
	}

	/**
	 * @return the descriptores
	 */
	public List<Descriptor> getDescriptores() {
		return descriptores;
	}

	/**
	 * @param descriptores
	 *            the descriptores to set
	 */
	public void setDescriptores(List<Descriptor> descriptores) {
		this.descriptores = descriptores;
	}

	/**
	 * @return the dehojareclamacion
	 */
	public String getDehojareclamacion() {
		return dehojareclamacion;
	}

	/**
	 * @param dehojareclamacion
	 *            the dehojareclamacion to set
	 */
	public void setDehojareclamacion(String dehojareclamacion) {
		this.dehojareclamacion = dehojareclamacion;
	}

	/**
	 * @return the hdidioma
	 */
	public String getHdidioma() {
		return hdidioma;
	}

	/**
	 * @param hdidioma
	 *            the hdidioma to set
	 */
	public void setHdidioma(String hdidioma) {
		this.hdidioma = hdidioma;
	}

	/**
	 * @return the permisoModificacionFechaHecho
	 */
	public String getPermisoModificacionFechaHecho() {
		return permisoModificacionFechaHecho;
	}

	/**
	 * @param permisoModificacionFechaHecho
	 *            the permisoModificacionFechaHecho to set
	 */
	public void setPermisoModificacionFechaHecho(String permisoModificacionFechaHecho) {
		this.permisoModificacionFechaHecho = permisoModificacionFechaHecho;
	}

	/**
	 * @return the permisoModificacionTipoSolicitud
	 */
	public String getPermisoModificacionTipoSolicitud() {
		return permisoModificacionTipoSolicitud;
	}

	/**
	 * @param permisoModificacionTipoSolicitud
	 *            the permisoModificacionTipoSolicitud to set
	 */
	public void setPermisoModificacionTipoSolicitud(String permisoModificacionTipoSolicitud) {
		this.permisoModificacionTipoSolicitud = permisoModificacionTipoSolicitud;
	}

	/**
	 * @return the permisoModificacionCambioResponsable
	 */
	public String getPermisoModificacionCambioResponsable() {
		return permisoModificacionCambioResponsable;
	}

	/**
	 * @param permisoModificacionCambioResponsable
	 *            the permisoModificacionCambioResponsable to set
	 */
	public void setPermisoModificacionCambioResponsable(String permisoModificacionCambioResponsable) {
		this.permisoModificacionCambioResponsable = permisoModificacionCambioResponsable;
	}

	/**
	 * @return the siguientesTramitesCambioResponsable
	 */
	public String getSiguientesTramitesCambioResponsable() {
		return siguientesTramitesCambioResponsable;
	}

	/**
	 * @param siguientesTramitesCambioResponsable
	 *            the siguientesTramitesCambioResponsable to set
	 */
	public void setSiguientesTramitesCambioResponsable(String siguientesTramitesCambioResponsable) {
		this.siguientesTramitesCambioResponsable = siguientesTramitesCambioResponsable;
	}

	/**
	 * @return the hdformanotificacionestablecimiento
	 */
	public String getHdformanotificacionestablecimiento() {
		return hdformanotificacionestablecimiento;
	}

	/**
	 * @param hdformanotificacionestablecimiento
	 *            the hdformanotificacionestablecimiento to set
	 */
	public void setHdformanotificacionestablecimiento(String hdformanotificacionestablecimiento) {
		this.hdformanotificacionestablecimiento = hdformanotificacionestablecimiento;
	}

	/**
	 * @return the hdnumregistroentradaorigen
	 */
	public String getHdnumregistroentradaorigen() {
		return hdnumregistroentradaorigen;
	}

	/**
	 * @param hdnumregistroentradaorigen
	 *            the hdnumregistroentradaorigen to set
	 */
	public void setHdnumregistroentradaorigen(String hdnumregistroentradaorigen) {
		this.hdnumregistroentradaorigen = hdnumregistroentradaorigen;
	}

	/**
	 * @return the hdfecharegistroorigen
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getHdfecharegistroorigen() {
		return hdfecharegistroorigen;
	}

	/**
	 * @param hdfecharegistroorigen
	 *            the hdfecharegistroorigen to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setHdfecharegistroorigen(Date hdfecharegistroorigen) {
		this.hdfecharegistroorigen = hdfecharegistroorigen;
	}

	/**
	 * @return the fvcodigo
	 */
	public String getFvcodigo() {
		return fvcodigo;
	}

	/**
	 * @param fvcodigo
	 *            the fvcodigo to set
	 */
	public void setFvcodigo(String fvcodigo) {
		this.fvcodigo = fvcodigo;
	}

	/**
	 * @return the fvnombre
	 */
	public String getFvnombre() {
		return fvnombre;
	}

	/**
	 * @param fvnombre
	 *            the fvnombre to set
	 */
	public void setFvnombre(String fvnombre) {
		this.fvnombre = fvnombre;
	}

	/**
	 * @return the fvnombree
	 */
	public String getFvnombree() {
		return fvnombree;
	}

	/**
	 * @param fvnombree
	 *            the fvnombree to set
	 */
	public void setFvnombree(String fvnombree) {
		this.fvnombree = fvnombree;
	}

	/**
	 * @return the fvtelematicocodigo
	 */
	public String getFvtelematicocodigo() {
		return fvtelematicocodigo;
	}

	/**
	 * @param fvtelematicocodigo
	 *            the fvtelematicocodigo to set
	 */
	public void setFvtelematicocodigo(String fvtelematicocodigo) {
		this.fvtelematicocodigo = fvtelematicocodigo;
	}

	/**
	 * @return the fvtelematiconombre
	 */
	public String getFvtelematiconombre() {
		return fvtelematiconombre;
	}

	/**
	 * @param fvtelematiconombre
	 *            the fvtelematiconombre to set
	 */
	public void setFvtelematiconombre(String fvtelematiconombre) {
		this.fvtelematiconombre = fvtelematiconombre;
	}

	/**
	 * @return the fvtelematiconombree
	 */
	public String getFvtelematiconombree() {
		return fvtelematiconombree;
	}

	/**
	 * @param fvtelematiconombree
	 *            the fvtelematiconombree to set
	 */
	public void setFvtelematiconombree(String fvtelematiconombree) {
		this.fvtelematiconombree = fvtelematiconombree;
	}

	/**
	 * @return the hdfechacierre
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getHdfechacierre() {
		return hdfechacierre;
	}

	/**
	 * @param hdfechacierre
	 *            the hdfechacierre to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setHdfechacierre(Date hdfechacierre) {
		this.hdfechacierre = hdfechacierre;
	}

	/**
	 * @return the existeArbRel
	 */
	public Boolean getExisteArbRel() {
		return existeArbRel;
	}

	/**
	 * @param existeArbRel
	 *            the existeArbRel to set
	 */
	public void setExisteArbRel(Boolean existeArbRel) {
		this.existeArbRel = existeArbRel;
	}

	/**
	 * @return the hccottd
	 */
	public String getHccottd() {
		return hccottd;
	}

	/**
	 * @param hccottd
	 *            the hccottd to set
	 */
	public void setHccottd(String hccottd) {
		this.hccottd = hccottd;
	}

	/**
	 * @return the existeDecisionCorrecta
	 */
	public Boolean getExisteDecisionCorrecta() {
		return existeDecisionCorrecta;
	}

	/**
	 * @param existeDecisionCorrecta
	 *            the existeDecisionCorrecta to set
	 */
	public void setExisteDecisionCorrecta(Boolean existeDecisionCorrecta) {
		this.existeDecisionCorrecta = existeDecisionCorrecta;
	}

	/**
	 * @return the hdcodigobarras
	 */
	public String getHdcodigobarras() {
		return hdcodigobarras;
	}

	/**
	 * @param hdcodigobarras
	 *            the hdcodigobarras to set
	 */
	public void setHdcodigobarras(String hdcodigobarras) {
		this.hdcodigobarras = hdcodigobarras;
	}

	/**
	 * @return the hdinteresado
	 */
	public String getHdinteresado() {
		return hdinteresado;
	}

	/**
	 * @param hdinteresado
	 *            the hdinteresado to set
	 */
	public void setHdinteresado(String hdinteresado) {
		this.hdinteresado = hdinteresado;
	}

	/**
	 * @return the hddenunciaaaccempresas
	 */
	public String getHddenunciaaaccempresas() {
		return hddenunciaaaccempresas;
	}

	/**
	 * @param hddenunciaaaccempresas
	 *            the hddenunciaaaccempresas to set
	 */
	public void setHddenunciaaaccempresas(String hddenunciaaaccempresas) {
		this.hddenunciaaaccempresas = hddenunciaaaccempresas;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "SolicitudDetalle [decodigo=" + decodigo + ", decoor=" + decoor + ", denran=" + denran + ", denror="
				+ denror + ", defede=" + defede + ", defere=" + defere + ", tfpcodigo=" + tfpcodigo + ", tfpnombre="
				+ tfpnombre + ", tfpnombree=" + tfpnombree + ", hdcodexpedienteorigen=" + hdcodexpedienteorigen
				+ ", hdformanotificacion=" + hdformanotificacion + ", hdesnombretelematico=" + hdesnombretelematico
				+ ", hdesdirecciontelematico=" + hdesdirecciontelematico + ", istelematico=" + istelematico
				+ ", numregistroentrada=" + numregistroentrada + ", dtcodigo=" + dtcodigo + ", dtnombre=" + dtnombre
				+ ", dtapellido1=" + dtapellido1 + ", dtapellido2=" + dtapellido2 + ", dtnif=" + dtnif + ", dttecoem="
				+ dttecoem + ", dtnrtel=" + dtnrtel + ", dtnombreProvincia=" + dtnombreProvincia
				+ ", dtnombreMunicipio=" + dtnombreMunicipio + ", dtnombreLocalidad=" + dtnombreLocalidad
				+ ", dtextranjero=" + dtextranjero + ", dtnoraPaisNombre=" + dtnoraPaisNombre + ", dtdireccion_nocapv="
				+ dtdireccion_nocapv + ", escodigo=" + escodigo + ", esnombre=" + esnombre + ", esnif=" + esnif
				+ ", esnoco=" + esnoco + ", escoem=" + escoem + ", esinadar=" + esinadar + ", esnombreProvincia="
				+ esnombreProvincia + ", esnombreMunicipio=" + esnombreMunicipio + ", esnombreLocalidad="
				+ esnombreLocalidad + ", esextranjero=" + esextranjero + ", esnoraPaisNombre=" + esnoraPaisNombre
				+ ", esdireccion_nocapv=" + esdireccion_nocapv + ", secodigo=" + secodigo + ", senombre=" + senombre
				+ ", senombree=" + senombree + ", hdcodigo=" + hdcodigo + ", hdfehd=" + hdfehd + ", hdte=" + hdte
				+ ", hdnror=" + hdnror + ", hdinsoma=" + hdinsoma + ", hdcaptso=" + hdcaptso + ", hdteso=" + hdteso
				+ ", hdcosc=" + hdcosc + ", mocodigo=" + mocodigo + ", monombre=" + monombre + ", pscodigo=" + pscodigo
				+ ", psnombre=" + psnombre + ", psnombree=" + psnombree + ", hdnomaps=" + hdnomaps + ", hdnomops="
				+ hdnomops + ", hdnrlops=" + hdnrlops + ", hdfedmps=" + hdfedmps + ", hdfechacierre=" + hdfechacierre
				+ ", tircodigo=" + tircodigo + ", tirnombre=" + tirnombre + ", tsrcodigo=" + tsrcodigo + ", tsrnombre="
				+ tsrnombre + ", tsrnombree=" + tsrnombree + ", estado=" + estado + ", numExpediente=" + numExpediente
				+ ", codOrgConectado=" + codOrgConectado + ", hccoor=" + hccoor + ", hcfede=" + hcfede + ", ihcoordt="
				+ ihcoordt + ", ihfereen=" + ihfereen + ", orgiskontsumonet=" + orgiskontsumonet + ", fcodigo="
				+ fcodigo + ", fnombre=" + fnombre + ", fnombree=" + fnombree + ", trcodigo=" + trcodigo + ", trnombre="
				+ trnombre + ", trnombree=" + trnombree + ", trPosibleCodigo=" + trPosibleCodigo
				+ ", permisoModificacion=" + permisoModificacion + ", idsDescriptores=" + idsDescriptores
				+ ", descsDescriptores=" + descsDescriptores + ", hdininin=" + hdininin + ", descriptores="
				+ descriptores + "]";
	}

	/**
	 * @return the denombretelematico
	 */
	public String getDenombretelematico() {
		return denombretelematico;
	}

	/**
	 * @param denombretelematico
	 *            the denombretelematico to set
	 */
	public void setDenombretelematico(String denombretelematico) {
		this.denombretelematico = denombretelematico;
	}

	/**
	 * @return the dedirecciontelematico
	 */
	public String getDedirecciontelematico() {
		return dedirecciontelematico;
	}

	/**
	 * @param dedirecciontelematico
	 *            the dedirecciontelematico to set
	 */
	public void setDedirecciontelematico(String dedirecciontelematico) {
		this.dedirecciontelematico = dedirecciontelematico;
	}

	/**
	 * @return the hdtipodenunciante
	 */
	public String getHdtipodenunciante() {
		return hdtipodenunciante;
	}

	/**
	 * @param hdtipodenunciante
	 *            the hdtipodenunciante to set
	 */
	public void setHdtipodenunciante(String hdtipodenunciante) {
		this.hdtipodenunciante = hdtipodenunciante;
	}

	/**
	 * @return the hdidiomareclamado
	 */
	public String getHdidiomareclamado() {
		return hdidiomareclamado;
	}

	/**
	 * @param hdidiomareclamado
	 *            the hdidiomareclamado to set
	 */
	public void setHdidiomareclamado(String hdidiomareclamado) {
		this.hdidiomareclamado = hdidiomareclamado;
	}

	/**
	 * @return the hdparticipacionreclamado
	 */
	public String getHdparticipacionreclamado() {
		return hdparticipacionreclamado;
	}

	/**
	 * @param hdparticipacionreclamado
	 *            the hdparticipacionreclamado to set
	 */
	public void setHdparticipacionreclamado(String hdparticipacionreclamado) {
		this.hdparticipacionreclamado = hdparticipacionreclamado;
	}

	/**
	 * @return the esnrtel
	 */
	public String getEsnrtel() {
		return esnrtel;
	}

	/**
	 * @param esnrtel
	 *            the esnrtel to set
	 */
	public void setEsnrtel(String esnrtel) {
		this.esnrtel = esnrtel;
	}

	/**
	 * @return the hddestnotificareclamante
	 */
	public String getHddestnotificareclamante() {
		return hddestnotificareclamante;
	}

	/**
	 * @param hddestnotificareclamante
	 *            the hddestnotificareclamante to set
	 */
	public void setHddestnotificareclamante(String hddestnotificareclamante) {
		this.hddestnotificareclamante = hddestnotificareclamante;
	}

	/**
	 * @return the hddestnotificareclamado
	 */
	public String getHddestnotificareclamado() {
		return hddestnotificareclamado;
	}

	/**
	 * @param hddestnotificareclamado
	 *            the hddestnotificareclamado to set
	 */
	public void setHddestnotificareclamado(String hddestnotificareclamado) {
		this.hddestnotificareclamado = hddestnotificareclamado;
	}

	/**
	 * @return the reclamanteCambio
	 */
	public String getReclamanteCambio() {
		return reclamanteCambio;
	}

	/**
	 * @param reclamanteCambio
	 *            the reclamanteCambio to set
	 */
	public void setReclamanteCambio(String reclamanteCambio) {
		this.reclamanteCambio = reclamanteCambio;
	}

	/**
	 * @return the reclamadoCambio
	 */
	public String getReclamadoCambio() {
		return reclamadoCambio;
	}

	/**
	 * @param reclamadoCambio
	 *            the reclamadoCambio to set
	 */
	public void setReclamadoCambio(String reclamadoCambio) {
		this.reclamadoCambio = reclamadoCambio;
	}

	/**
	 * @return the hdidparticipacionreclamante
	 */
	public String getHdidparticipacionreclamante() {
		return hdidparticipacionreclamante;
	}

	/**
	 * @param hdidparticipacionreclamante
	 *            the hdidparticipacionreclamante to set
	 */
	public void setHdidparticipacionreclamante(String hdidparticipacionreclamante) {
		this.hdidparticipacionreclamante = hdidparticipacionreclamante;
	}

	/**
	 * @return the hdidparticipacionreclamado
	 */
	public String getHdidparticipacionreclamado() {
		return hdidparticipacionreclamado;
	}

	/**
	 * @param hdidparticipacionreclamado
	 *            the hdidparticipacionreclamado to set
	 */
	public void setHdidparticipacionreclamado(String hdidparticipacionreclamado) {
		this.hdidparticipacionreclamado = hdidparticipacionreclamado;
	}

	/**
	 * @return the hdnops
	 */
	public String getHdnops() {
		return hdnops;
	}

	/**
	 * @param hdnops
	 *            the hdnops to set
	 */
	public void setHdnops(String hdnops) {
		this.hdnops = hdnops;
	}

	/**
	 * @return the dtEstablecimientoCerrado
	 */
	public String getDtEstablecimientoCerrado() {
		return dtEstablecimientoCerrado;
	}

	/**
	 * @param dtEstablecimientoCerrado
	 *            the dtEstablecimientoCerrado to set
	 */
	public void setDtEstablecimientoCerrado(String dtEstablecimientoCerrado) {
		this.dtEstablecimientoCerrado = dtEstablecimientoCerrado;
	}

	/**
	 * @return the esEstablecimientoCerrado
	 */
	public String getEsEstablecimientoCerrado() {
		return esEstablecimientoCerrado;
	}

	/**
	 * @param esEstablecimientoCerrado
	 *            the esEstablecimientoCerrado to set
	 */
	public void setEsEstablecimientoCerrado(String esEstablecimientoCerrado) {
		this.esEstablecimientoCerrado = esEstablecimientoCerrado;
	}

	/**
	 * @return the isSir
	 */
	public String getIsSir() {
		return isSir;
	}

	/**
	 * @param isSir
	 *            the isSir to set
	 */
	public void setIsSir(String isSir) {
		this.isSir = isSir;
	}

	/**
	 * @return the idAsiento
	 */
	public String getIdAsiento() {
		return idAsiento;
	}

	/**
	 * @param idAsiento
	 *            the idAsiento to set
	 */
	public void setIdAsiento(String idAsiento) {
		this.idAsiento = idAsiento;
	}

	/**
	 * @return the arSolicitante
	 */
	public String getArSolicitante() {
		return arSolicitante;
	}

	/**
	 * @param arSolicitante
	 *            the arSolicitante to set
	 */
	public void setArSolicitante(String arSolicitante) {
		this.arSolicitante = arSolicitante;
	}

	/**
	 * @return the arResumen
	 */
	public String getArResumen() {
		return arResumen;
	}

	/**
	 * @param arResumen
	 *            the arResumen to set
	 */
	public void setArResumen(String arResumen) {
		this.arResumen = arResumen;
	}

}
