package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.validation.Y41bNifNieCif;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Email;

/**
 * Secretar  
 * 
 *  
 */

public class Secretar implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String srcodigo;
	@Y41bNifNieCif(message = "error01.required.arnif")
	private String srnif;
	private String srnombre;
	private String srnodir;
	private String srcolo;
	private String srnolo;
	private String srnrcopo;
	private String srcopv;
	private String srnopv;
	private String srnrtel;
	private String srnrtel2;
	private String srnrfax;
	@Email(message = "error02.required.email")
	private String srteem;
	private String srteurl;
	private String srcota1;
	private Date srfeba;
	private String srteobs;
	private String srcoja;
	private String srcozs;
	private String srfemod;
	private List<Solarb> solarbsForSacoses = new ArrayList<Solarb>();
	private List<Solarb> solarbsForSacoset2 = new ArrayList<Solarb>();
	private List<Solarb> solarbsForSacoses2 = new ArrayList<Solarb>();
	private List<Solarb> solarbsForSacoset = new ArrayList<Solarb>();

	private String srprovId;
	private String srmunId;
	private String srlocId;
	private String srdireccionNoCAPV;
	private String srdireccionAntigua;

	private String srThActs;
	private String srThActAraba;
	private String srThActBizkaia;
	private String srThActGipuzkoa;
	private String baja;

	/**
	 * Method 'Secretar'.
	 */
	public Secretar() {
	}

	/**
	 * Method 'Secretar'.
	 * 
	 * @param srcodigo
	 *            String
	 * @param srnif
	 *            String
	 * @param srnombre
	 *            String
	 * @param srnodir
	 *            String
	 * @param srcolo
	 *            String
	 * @param srnolo
	 *            String
	 * @param srnrcopo
	 *            String
	 * @param srcopv
	 *            String
	 * @param srnopv
	 *            String
	 * @param srnrtel
	 *            String
	 * @param srnrtel2
	 *            String
	 * @param srnrfax
	 *            String
	 * @param srteem
	 *            String
	 * @param srteurl
	 *            String
	 * @param srcota1
	 *            String
	 * @param srfeba
	 *            Date
	 * @param srteobs
	 *            String
	 * @param srcoja
	 *            String
	 * @param srcozs
	 *            String
	 * @param srfemod
	 *            String
	 */
	public Secretar(String srcodigo, String srnif, String srnombre,
			String srnodir, String srcolo, String srnolo, String srnrcopo,
			String srcopv, String srnopv, String srnrtel, String srnrtel2,
			String srnrfax, String srteem, String srteurl, String srcota1,
			Date srfeba, String srteobs, String srcoja, String srcozs,
			String srfemod) {
		this.srcodigo = srcodigo;
		this.srnif = srnif;
		this.srnombre = srnombre;
		this.srnodir = srnodir;
		this.srcolo = srcolo;
		this.srnolo = srnolo;
		this.srnrcopo = srnrcopo;
		this.srcopv = srcopv;
		this.srnopv = srnopv;
		this.srnrtel = srnrtel;
		this.srnrtel2 = srnrtel2;
		this.srnrfax = srnrfax;
		this.srteem = srteem;
		this.srteurl = srteurl;
		this.srcota1 = srcota1;
		this.srfeba = srfeba;
		this.srteobs = srteobs;
		this.srcoja = srcoja;
		this.srcozs = srcozs;
		this.srfemod = srfemod;
	}

	/**
	 * Method 'Secretar'.
	 * 
	 * @param srcodigo
	 *            String
	 * @param srnif
	 *            String
	 * @param srnombre
	 *            String
	 * @param srnodir
	 *            String
	 * @param srcolo
	 *            String
	 * @param srnolo
	 *            String
	 * @param srnrcopo
	 *            String
	 * @param srcopv
	 *            String
	 * @param srnopv
	 *            String
	 * @param srnrtel
	 *            String
	 * @param srnrtel2
	 *            String
	 * @param srnrfax
	 *            String
	 * @param srteem
	 *            String
	 * @param srteurl
	 *            String
	 * @param srcota1
	 *            String
	 * @param srfeba
	 *            Date
	 * @param srteobs
	 *            String
	 * @param srcoja
	 *            String
	 * @param srcozs
	 *            String
	 * @param srfemod
	 *            String
	 * @param solarbsForSacoses
	 *            List<Solarb>
	 * @param solarbsForSacoset2
	 *            List<Solarb>
	 * @param solarbsForSacoses2
	 *            List<Solarb>
	 * @param solarbsForSacoset
	 *            List<Solarb>
	 */
	public Secretar(String srcodigo, String srnif, String srnombre,
			String srnodir, String srcolo, String srnolo, String srnrcopo,
			String srcopv, String srnopv, String srnrtel, String srnrtel2,
			String srnrfax, String srteem, String srteurl, String srcota1,
			Date srfeba, String srteobs, String srcoja, String srcozs,
			String srfemod, List<Solarb> solarbsForSacoses,
			List<Solarb> solarbsForSacoset2, List<Solarb> solarbsForSacoses2,
			List<Solarb> solarbsForSacoset) {

		this.srcodigo = srcodigo;
		this.srnif = srnif;
		this.srnombre = srnombre;
		this.srnodir = srnodir;
		this.srcolo = srcolo;
		this.srnolo = srnolo;
		this.srnrcopo = srnrcopo;
		this.srcopv = srcopv;
		this.srnopv = srnopv;
		this.srnrtel = srnrtel;
		this.srnrtel2 = srnrtel2;
		this.srnrfax = srnrfax;
		this.srteem = srteem;
		this.srteurl = srteurl;
		this.srcota1 = srcota1;
		this.srfeba = srfeba;
		this.srteobs = srteobs;
		this.srcoja = srcoja;
		this.srcozs = srcozs;
		this.srfemod = srfemod;
		this.solarbsForSacoses = solarbsForSacoses;
		this.solarbsForSacoset2 = solarbsForSacoset2;
		this.solarbsForSacoses2 = solarbsForSacoses2;
		this.solarbsForSacoset = solarbsForSacoset;
	}

	/**
	 * @param srcodigo
	 * @param srnombre
	 */
	public Secretar(String srcodigo, String srnombre) {
		this.srcodigo = srcodigo;
		this.srnombre = srnombre;
	}

	/**
	 * Method 'getSrcodigo'.
	 * 
	 * @return String
	 */

	public String getSrcodigo() {
		return this.srcodigo;
	}

	/**
	 * Method 'setSrcodigo'.
	 * 
	 * @param srcodigo
	 *            String
	 * @return
	 */

	public void setSrcodigo(String srcodigo) {
		this.srcodigo = srcodigo;
	}

	/**
	 * Method 'getSrnif'.
	 * 
	 * @return String
	 */

	public String getSrnif() {
		return Y41bUtils.upperCase(this.srnif);
	}

	/**
	 * Method 'setSrnif'.
	 * 
	 * @param srnif
	 *            String
	 * @return
	 */

	public void setSrnif(String srnif) {
		this.srnif = Y41bUtils.upperCase(srnif);
	}

	/**
	 * Method 'getSrnombre'.
	 * 
	 * @return String
	 */

	public String getSrnombre() {
		return this.srnombre;
	}

	/**
	 * Method 'setSrnombre'.
	 * 
	 * @param srnombre
	 *            String
	 * @return
	 */

	public void setSrnombre(String srnombre) {
		this.srnombre = srnombre;
	}

	/**
	 * Method 'getSrnodir'.
	 * 
	 * @return String
	 */

	public String getSrnodir() {
		return this.srnodir;
	}

	/**
	 * Method 'setSrnodir'.
	 * 
	 * @param srnodir
	 *            String
	 * @return
	 */

	public void setSrnodir(String srnodir) {
		this.srnodir = srnodir;
	}

	/**
	 * Method 'getSrcolo'.
	 * 
	 * @return String
	 */

	public String getSrcolo() {
		return this.srcolo;
	}

	/**
	 * Method 'setSrcolo'.
	 * 
	 * @param srcolo
	 *            String
	 * @return
	 */

	public void setSrcolo(String srcolo) {
		this.srcolo = srcolo;
	}

	/**
	 * Method 'getSrnolo'.
	 * 
	 * @return String
	 */

	public String getSrnolo() {
		return this.srnolo;
	}

	/**
	 * Method 'setSrnolo'.
	 * 
	 * @param srnolo
	 *            String
	 * @return
	 */

	public void setSrnolo(String srnolo) {
		this.srnolo = srnolo;
	}

	/**
	 * Method 'getSrnrcopo'.
	 * 
	 * @return String
	 */

	public String getSrnrcopo() {
		return this.srnrcopo;
	}

	/**
	 * Method 'setSrnrcopo'.
	 * 
	 * @param srnrcopo
	 *            String
	 * @return
	 */

	public void setSrnrcopo(String srnrcopo) {
		this.srnrcopo = srnrcopo;
	}

	/**
	 * Method 'getSrcopv'.
	 * 
	 * @return String
	 */

	public String getSrcopv() {
		return this.srcopv;
	}

	/**
	 * Method 'setSrcopv'.
	 * 
	 * @param srcopv
	 *            String
	 * @return
	 */

	public void setSrcopv(String srcopv) {
		this.srcopv = srcopv;
	}

	/**
	 * Method 'getSrnopv'.
	 * 
	 * @return String
	 */

	public String getSrnopv() {
		return this.srnopv;
	}

	/**
	 * Method 'setSrnopv'.
	 * 
	 * @param srnopv
	 *            String
	 * @return
	 */

	public void setSrnopv(String srnopv) {
		this.srnopv = srnopv;
	}

	/**
	 * Method 'getSrnrtel'.
	 * 
	 * @return String
	 */

	public String getSrnrtel() {
		return this.srnrtel;
	}

	/**
	 * Method 'setSrnrtel'.
	 * 
	 * @param srnrtel
	 *            String
	 * @return
	 */

	public void setSrnrtel(String srnrtel) {
		this.srnrtel = srnrtel;
	}

	/**
	 * Method 'getSrnrtel2'.
	 * 
	 * @return String
	 */

	public String getSrnrtel2() {
		return this.srnrtel2;
	}

	/**
	 * Method 'setSrnrtel2'.
	 * 
	 * @param srnrtel2
	 *            String
	 * @return
	 */

	public void setSrnrtel2(String srnrtel2) {
		this.srnrtel2 = srnrtel2;
	}

	/**
	 * Method 'getSrnrfax'.
	 * 
	 * @return String
	 */

	public String getSrnrfax() {
		return this.srnrfax;
	}

	/**
	 * Method 'setSrnrfax'.
	 * 
	 * @param srnrfax
	 *            String
	 * @return
	 */

	public void setSrnrfax(String srnrfax) {
		this.srnrfax = srnrfax;
	}

	/**
	 * Method 'getSrteem'.
	 * 
	 * @return String
	 */

	public String getSrteem() {
		return this.srteem;
	}

	/**
	 * Method 'setSrteem'.
	 * 
	 * @param srteem
	 *            String
	 * @return
	 */

	public void setSrteem(String srteem) {
		this.srteem = srteem;
	}

	/**
	 * Method 'getSrteurl'.
	 * 
	 * @return String
	 */

	public String getSrteurl() {
		return this.srteurl;
	}

	/**
	 * Method 'setSrteurl'.
	 * 
	 * @param srteurl
	 *            String
	 * @return
	 */

	public void setSrteurl(String srteurl) {
		this.srteurl = srteurl;
	}

	/**
	 * Method 'getSrcota1'.
	 * 
	 * @return String
	 */

	public String getSrcota1() {
		return this.srcota1;
	}

	/**
	 * Method 'setSrcota1'.
	 * 
	 * @param srcota1
	 *            String
	 * @return
	 */

	public void setSrcota1(String srcota1) {
		this.srcota1 = srcota1;
	}

	/**
	 * Method 'getSrfeba'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getSrfeba() {
		return this.srfeba;
	}

	/**
	 * Method 'setSrfeba'.
	 * 
	 * @param srfeba
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setSrfeba(Date srfeba) {
		this.srfeba = srfeba;
	}

	/**
	 * Method 'getSrteobs'.
	 * 
	 * @return String
	 */

	public String getSrteobs() {
		return this.srteobs;
	}

	/**
	 * Method 'setSrteobs'.
	 * 
	 * @param srteobs
	 *            String
	 * @return
	 */

	public void setSrteobs(String srteobs) {
		this.srteobs = srteobs;
	}

	/**
	 * Method 'getSrcoja'.
	 * 
	 * @return String
	 */

	public String getSrcoja() {
		return this.srcoja;
	}

	/**
	 * Method 'setSrcoja'.
	 * 
	 * @param srcoja
	 *            String
	 * @return
	 */

	public void setSrcoja(String srcoja) {
		this.srcoja = srcoja;
	}

	/**
	 * Method 'getSrcozs'.
	 * 
	 * @return String
	 */

	public String getSrcozs() {
		return this.srcozs;
	}

	/**
	 * Method 'setSrcozs'.
	 * 
	 * @param srcozs
	 *            String
	 * @return
	 */

	public void setSrcozs(String srcozs) {
		this.srcozs = srcozs;
	}

	/**
	 * Method 'getSrfemod'.
	 * 
	 * @return String
	 */

	public String getSrfemod() {
		return this.srfemod;
	}

	/**
	 * Method 'setSrfemod'.
	 * 
	 * @param srfemod
	 *            String
	 * @return
	 */

	public void setSrfemod(String srfemod) {
		this.srfemod = srfemod;
	}

	/**
	 * Method 'getSolarbsForSacoses'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Solarb> getSolarbsForSacoses() {
		return this.solarbsForSacoses;
	}

	/**
	 * Method 'setSolarbsForSacoses'.
	 * 
	 * @param solarbsForSacoses
	 *            List
	 * @return
	 */
	public void setSolarbsForSacoses(List<Solarb> solarbsForSacoses) {
		this.solarbsForSacoses = solarbsForSacoses;
	}

	/**
	 * Method 'getSolarbsForSacoset2'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Solarb> getSolarbsForSacoset2() {
		return this.solarbsForSacoset2;
	}

	/**
	 * Method 'setSolarbsForSacoset2'.
	 * 
	 * @param solarbsForSacoset2
	 *            List
	 * @return
	 */
	public void setSolarbsForSacoset2(List<Solarb> solarbsForSacoset2) {
		this.solarbsForSacoset2 = solarbsForSacoset2;
	}

	/**
	 * Method 'getSolarbsForSacoses2'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Solarb> getSolarbsForSacoses2() {
		return this.solarbsForSacoses2;
	}

	/**
	 * Method 'setSolarbsForSacoses2'.
	 * 
	 * @param solarbsForSacoses2
	 *            List
	 * @return
	 */
	public void setSolarbsForSacoses2(List<Solarb> solarbsForSacoses2) {
		this.solarbsForSacoses2 = solarbsForSacoses2;
	}

	/**
	 * Method 'getSolarbsForSacoset'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Solarb> getSolarbsForSacoset() {
		return this.solarbsForSacoset;
	}

	/**
	 * Method 'setSolarbsForSacoset'.
	 * 
	 * @param solarbsForSacoset
	 *            List
	 * @return
	 */
	public void setSolarbsForSacoset(List<Solarb> solarbsForSacoset) {
		this.solarbsForSacoset = solarbsForSacoset;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ srcodigo: ").append(this.srcodigo).append(" ]");
		result.append(", [ srnif: ").append(this.srnif).append(" ]");
		result.append(", [ srnombre: ").append(this.srnombre).append(" ]");
		result.append(", [ srnodir: ").append(this.srnodir).append(" ]");
		result.append(", [ srcolo: ").append(this.srcolo).append(" ]");
		result.append(", [ srnolo: ").append(this.srnolo).append(" ]");
		result.append(", [ srnrcopo: ").append(this.srnrcopo).append(" ]");
		result.append(", [ srcopv: ").append(this.srcopv).append(" ]");
		result.append(", [ srnopv: ").append(this.srnopv).append(" ]");
		result.append(", [ srnrtel: ").append(this.srnrtel).append(" ]");
		result.append(", [ srnrtel2: ").append(this.srnrtel2).append(" ]");
		result.append(", [ srnrfax: ").append(this.srnrfax).append(" ]");
		result.append(", [ srteem: ").append(this.srteem).append(" ]");
		result.append(", [ srteurl: ").append(this.srteurl).append(" ]");
		result.append(", [ srcota1: ").append(this.srcota1).append(" ]");
		result.append(", [ srfeba: ").append(this.srfeba).append(" ]");
		result.append(", [ srteobs: ").append(this.srteobs).append(" ]");
		result.append(", [ srcoja: ").append(this.srcoja).append(" ]");
		result.append(", [ srcozs: ").append(this.srcozs).append(" ]");
		result.append(", [ srfemod: ").append(this.srfemod).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the srprovId
	 */
	public String getSrprovId() {
		return srprovId;
	}

	/**
	 * @param srprovId
	 *            the srprovId to set
	 */
	public void setSrprovId(String srprovId) {
		this.srprovId = srprovId;
	}

	/**
	 * @return the srmunId
	 */
	public String getSrmunId() {
		return srmunId;
	}

	/**
	 * @param srmunId
	 *            the srmunId to set
	 */
	public void setSrmunId(String srmunId) {
		this.srmunId = srmunId;
	}

	/**
	 * @return the srlocId
	 */
	public String getSrlocId() {
		return srlocId;
	}

	/**
	 * @param srlocId
	 *            the srlocId to set
	 */
	public void setSrlocId(String srlocId) {
		this.srlocId = srlocId;
	}

	/**
	 * @return the srdireccionNoCAPV
	 */
	public String getSrdireccionNoCAPV() {
		return srdireccionNoCAPV;
	}

	/**
	 * @param srdireccionNoCAPV
	 *            the srdireccionNoCAPV to set
	 */
	public void setSrdireccionNoCAPV(String srdireccionNoCAPV) {
		this.srdireccionNoCAPV = srdireccionNoCAPV;
	}

	/**
	 * @return the srdireccionAntigua
	 */
	public String getSrdireccionAntigua() {
		return srdireccionAntigua;
	}

	/**
	 * @param srdireccionAntigua
	 *            the srdireccionAntigua to set
	 */
	public void setSrdireccionAntigua(String srdireccionAntigua) {
		this.srdireccionAntigua = srdireccionAntigua;
	}

	/**
	 * @return the srThActs
	 */
	public String getSrThActs() {
		return srThActs;
	}

	/**
	 * @param srThActs
	 *            the srThActs to set
	 */
	public void setSrThActs(String srThActs) {
		this.srThActs = srThActs;
	}

	/**
	 * @return the baja
	 */
	public String getBaja() {
		return baja;
	}

	/**
	 * @param baja
	 *            the baja to set
	 */
	public void setBaja(String baja) {
		this.baja = baja;
	}

	/**
	 * @return the srThActAraba
	 */
	public String getSrThActAraba() {
		return srThActAraba;
	}

	/**
	 * @param srThActAraba
	 *            the srThActAraba to set
	 */
	public void setSrThActAraba(String srThActAraba) {
		this.srThActAraba = srThActAraba;
	}

	/**
	 * @return the srThActBizkaia
	 */
	public String getSrThActBizkaia() {
		return srThActBizkaia;
	}

	/**
	 * @param srThActBizkaia
	 *            the srThActBizkaia to set
	 */
	public void setSrThActBizkaia(String srThActBizkaia) {
		this.srThActBizkaia = srThActBizkaia;
	}

	/**
	 * @return the srThActGipuzkoa
	 */
	public String getSrThActGipuzkoa() {
		return srThActGipuzkoa;
	}

	/**
	 * @param srThActGipuzkoa
	 *            the srThActGipuzkoa to set
	 */
	public void setSrThActGipuzkoa(String srThActGipuzkoa) {
		this.srThActGipuzkoa = srThActGipuzkoa;
	}

}
