package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.x38.serialization.JsonDateTimeDeserializer;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;

/**
 * Santramexp  
 * 
 *  
 */

public class Santramexp implements java.io.Serializable {

	// TRCODIGO TIPO TRAMITE KONTSUMONET
	// TRCODIGOREL TIPO TRAMITE KONTSUMONET RELACIONADO
	// TRESTADO Tramitado S/N
	// TRESTADOACUSE ACUSE DE RECIBO RECIBIDO: A-Aceptado, R-Rechazado, N-No
	// entregado
	// TRESTIMACION Estimación de la resolución alegaciones denegación de la
	// prueba
	// TREXCODIGO Identificador del expediente
	// TRFCODIGO Fase del trámite
	// TRFECACINI Fecha de Acuerdo de Iniciación/Incoación
	// TRFECACUSE FECHA DE RECEPCIÓN DEL ACUSE DE RECIBO
	// TRFECALTA Fecha de Alta
	// TRFECBOPV Fecha de publicación en boletín para K39
	// TRFECCIERRE Fecha de Cierre
	// TRFECENVIO Fecha de envio para la elaboración informe para asesoria
	// TRFECFIN Fecha Fin
	// TRFECNOTIF Fecha de Notificacion
	// TRFECINI Fecha de Inicio
	// TRFECINITABL Fecha de primer día de publicación en tablón para K39
	// TRFECMODIF Fecha de Modificacion
	// TRFECREGE Registro. Fecha Entrada
	// TRFECREGS Registro. Fecha Salida
	// TRID Identificador del trámite
	// TRIDESPERAPLATEA IDENTIFICATIVO DE LA ESPERA EN PLATEA
	// TRIDNOTIFPLATEA ID NOTIFICACION PLATEA
	// TRMATARESPERA ESPERA MATADA S/N
	// TRMOCODIGO Identificador de monitor asignado
	// TRMOCODIGOEJ Identificador de monitor para ejecución
	// TRNOMTRAMES Nombre del tramite
	// TRNUMDIAS Numero de dias ampliados para el acuerdo de ampliacion de plazo
	// de presentacion de alegaciones K40
	// TRNUMREGE Registro. Num Entrada
	// TRNUMREGS Registro. Num Salida
	// TROBSERVES Observaciones
	// TRRESOFECHA Fecha de la Notificacion / Fecha de propuesta Resolución /
	// Fecha de Resolución / Fecha de la Orden
	// TRRESOIMPORTE Importe
	// TRRESOSAN Sancion Accesoria
	// TRRESOTIPO Tipo de Resolución
	// TRRESULTADO Resultado de la resolución a solicitud de prueba
	// TRTEXTO Texto de la Notificacion/comunicacion
	// TRTIPOCOM TIPO COMUNICACION: T-Telematica, C-Correo ordinario, E-Correo
	// electronico
	// TRTIPONOT Tipo de notificacion T:Telemática P:Postal
	// TRTRIDREL Para guardar las relaciones entre notificaciones, acuses etc.
	// TRUAIDINTERV Interviniente del tramite/ Destinatario del trámite
	// TRUSUALTA Usuario de Alta
	// TRUSUMODIF Usuario de Modificacion

	private static final long serialVersionUID = 1L;

	private String trid;

	private Expedien expedien;

	private String trcodigo;

	private Date trfecini;

	private Date trfecfin;

	private Clob trobserves;

	private String trnomtrames;

	private String trnomtramCompleto;

	private String trestado;

	private CensoMonitor censoMonitor; /* asignacio */

	private CensoMonitor censoMonitorEj; /* ejecucion */

	private String trtridrel;

	private Date trfecacini;

	private BigDecimal trresultado;

	private String trestimacion;

	private Date trresofecha;

	private String trresotipo;

	private BigDecimal trresosan;

	private BigDecimal trresoimporte;

	private String trestadoacuse;
	private String envcdessitcorreoseu;
	private String envcdessitcorreoses;

	private String trtipocom;

	private Date trfecenvio;

	private Date trfeccierre;

	private Fase fase;

	private String trtiponot;

	private String trtiponotplatea;

	private Date trfecacuse;

	private BigDecimal trnumDias;

	private Date trfecbopv;

	private Date trfecinitabl;

	private Date trfecnotif;

	private Tramite tramite;

	private List<Sanenvio> sanenviosForEntridacuse = new ArrayList<Sanenvio>();

	private List<Sanenvio> sanenviosForEntrid = new ArrayList<Sanenvio>();

	private List<Sandoctemp> sandoctemps = new ArrayList<Sandoctemp>();

	private String trcodigorel;

	private String tridnotifplatea;

	private Clob trtexto;

	/* comunicaciones */
	private String trasuntocomunicacion;

	/* interviniente */
	private BigDecimal truaidinterv;

	/* registro */
	private String trnumregs;

	private String trnumrege;

	private Date trfecregs;

	private Date trfecrege;

	/* platea */
	private String trmatarespera;

	private String tridesperaplatea;

	private Date trfecmodif;

	private Date trfecalta;

	private String trusualta;

	private String trusumodif;

	private String tridmailorigen;
	private String trmailorigen;
	private String tridmaildestino;
	private String trmaildestino;

	// Documento
	private String indVariosDocumentos; // S o N

	private String u5codocumento;

	private String u5nofile;

	private Blob u5datafile;

	private Integer u5sizefile;

	private String u5tedesfile;

	private String u5contenttypefile;

	private String trcodrem;

	private String acuseSinNotificacion;

	private Date trfechaEnvioBOPVBOE;

	private String nombreDestOrigen;
	private String tipoDestOrigen;

	private String trproceedingsidplatea;

	private BigDecimal trimporteinicial;

	private Date trfecsolred;

	private String trprontopago;

	private String trreconocimiento;

	private String tracusereintentado;
	private String trautomatico;

	private String trrespuesta;
	private Clob trresumenalegaciones;

	// # INICIO #
	// ADAPTACIONES LEY 39 - COMUNICACION POSTAL INICIO AL
	// SANCIONADO
	private String trisComunicacionInicio;
	// # FIN #

	// Atributo que sirve para la comunicacin de inoacion unicamente
	// Tipo de notificacion (T:Telemtica / C:Ordinaria)
	// Este campo ser leido cuando sea un tramite de incoacin y hay que
	// notificar a los intervinientes
	// determinar si es telemtica u ordinaria.
	// TRISNOTIFICACIONINCOACION
	private String trisNotificacionIncoacion;

	// Flag indicativo de trmites de tipo aporte telemtico
	private String tristelematica;
	// EVOLUTIVO 0135083 2.4 nuevo campo para guardar la documentacion requerida
	// en euskera, en castellano se reutilizara el campo trresumenalegaciones
	private Clob trdocreqeus;

	private String trIsSir;
	private String trIsSirConNumRegEntOri;

	/**
	 * @return the trcodrem
	 */
	public String getTrcodrem() {
		return trcodrem;
	}

	/**
	 * @param trcodrem
	 *            the trcodrem to set
	 */
	public void setTrcodrem(String trcodrem) {
		this.trcodrem = trcodrem;
	}

	/**
	 * @return the trenvrem
	 */
	public String getTrenvrem() {
		return trenvrem;
	}

	/**
	 * @param trenvrem
	 *            the trenvrem to set
	 */
	public void setTrenvrem(String trenvrem) {
		this.trenvrem = trenvrem;
	}

	private String trenvrem;

	/*
	 * notificaciones y comunicaciones
	 */
	private String trsede;

	/*
	 * Liquidacion
	 */
	private String trreferencia;

	/**
	 * Method 'Santramexp'.
	 */
	public Santramexp() {
	}

	/**
	 * Method 'Santramexp'.
	 * 
	 * @param trid
	 *            String
	 */
	public Santramexp(String trid) {
		this.trid = trid;

	}

	/**
	 * Instantiates a new santramexp.
	 * 
	 * @param trid
	 *            the trid
	 * @param trcodigo
	 *            the trcodigo
	 * @param trfecini
	 *            the trfecini
	 * @param trfecfin
	 *            the trfecfin
	 * @param trobserves
	 *            the trobserves
	 * @param trnomtrames
	 *            the trnomtrames
	 * @param trtridrel
	 *            the trtridrel
	 * @param trfecacini
	 *            the trfecacini
	 * @param trresultado
	 *            the trresultado
	 * @param trestimacion
	 *            the trestimacion
	 * @param trresofecha
	 *            the trresofecha
	 * @param trresotipo
	 *            the trresotipo
	 * @param trresosan
	 *            the trresosan
	 * @param trresoimporte
	 *            the trresoimporte
	 * @param trfecregs
	 *            the trfecregs
	 * @param trfecrege
	 *            the trfecrege
	 * @param trestadoacuse
	 *            the trestadoacuse
	 * @param trnumregs
	 *            the trnumregs
	 * @param trnumrege
	 *            the trnumrege
	 * @param trtipocom
	 *            the trtipocom
	 * @param trfecenvio
	 *            the trfecenvio
	 * @param trfeccierre
	 *            the trfeccierre
	 * @param trtiponot
	 *            the trtiponot
	 * @param trnumDias
	 *            the trnum dias
	 * @param truaidinterv
	 *            the truaidinterv
	 * @param trfecbopv
	 *            the trfecbopv
	 * @param trfecinitabl
	 *            the trfecinitabl
	 * @param trfecnotif
	 *            the trfecnotif
	 * @param trfecalta
	 *            the trfecalta
	 * @param trfecmodif
	 *            the trfecmodif
	 * @param trusualta
	 *            the trusualta
	 * @param trusumodif
	 *            the trusumodif
	 * @param expedien
	 *            the expedien
	 * @param fase
	 *            the fase
	 * @param censoMonitor
	 *            the censo monitor
	 * @param censoMonitorEj
	 *            the censo monitor ej
	 * @param trestado
	 *            the trestado
	 * @param trtexto
	 *            the trtexto
	 * @param tridnotifplatea
	 *            the tridnotifplatea
	 * @param trasuntocomunicacion
	 *            the trasuntocomunicacion
	 * @param trtiponotplatea
	 *            the trtiponotplatea
	 * @param trfecacuse
	 *            the trfecacuse
	 * @param tristelematica
	 *            the tristelematica
	 * @param trIsSir
	 *            the trIsSir
	 * @param trIsSirConNumRegEntOri
	 *            the trIsSirConNumRegEntOri
	 */
	public Santramexp(String trid, String trcodigo, Date trfecini, Date trfecfin, Clob trobserves, String trnomtrames,
			String trtridrel, Date trfecacini, BigDecimal trresultado, String trestimacion, Date trresofecha,
			String trresotipo, BigDecimal trresosan, BigDecimal trresoimporte, Date trfecregs, Date trfecrege,
			String trestadoacuse, String trnumregs, String trnumrege, String trtipocom, Date trfecenvio,
			Date trfeccierre, String trtiponot, BigDecimal trnumDias, BigDecimal truaidinterv, Date trfecbopv,
			Date trfecinitabl, Date trfecnotif, Date trfecalta, Date trfecmodif, String trusualta, String trusumodif,
			Expedien expedien, Fase fase, CensoMonitor censoMonitor, CensoMonitor censoMonitorEj, String trestado,
			Clob trtexto, String tridnotifplatea, String trasuntocomunicacion, String trtiponotplatea, Date trfecacuse,
			String trsede, String trcodrem, String trenvrem, String tridmailorigen, String trmailorigen,
			String tridmaildestino, String trmaildestino, String tristelematica, String trIsSir,
			String trIsSirConNumRegEntOri) {
		this.trid = trid;
		this.expedien = expedien;
		this.trcodigo = trcodigo;
		this.trfecini = trfecini;
		this.trfecfin = trfecfin;
		this.trobserves = trobserves;
		this.trnomtrames = trnomtrames;
		this.trtridrel = trtridrel;
		this.trfecacini = trfecacini;
		this.trresultado = trresultado;
		this.trestimacion = trestimacion;
		this.trresofecha = trresofecha;
		this.trresotipo = trresotipo;
		this.trresosan = trresosan;
		this.trresoimporte = trresoimporte;
		this.trfecregs = trfecregs;
		this.trestadoacuse = trestadoacuse;
		this.trnumregs = trnumregs;
		this.trnumrege = trnumrege;
		this.trtipocom = trtipocom;
		this.trfecenvio = trfecenvio;
		this.trfeccierre = trfeccierre;
		this.trtiponot = trtiponot;
		this.trfecalta = trfecalta;
		this.trfecmodif = trfecmodif;
		this.trusualta = trusualta;
		this.trusumodif = trusumodif;
		this.fase = fase;
		this.censoMonitor = censoMonitor;
		this.censoMonitorEj = censoMonitorEj;
		this.trestado = trestado;
		this.trnumDias = trnumDias;
		this.truaidinterv = truaidinterv;
		this.trtexto = trtexto;
		this.tridnotifplatea = tridnotifplatea;
		this.trasuntocomunicacion = trasuntocomunicacion;
		this.trtiponotplatea = trtiponotplatea;
		this.trfecacuse = trfecacuse;
		this.trfecnotif = trfecnotif;
		this.trsede = trsede;
		this.trcodrem = trcodrem;
		this.trenvrem = trenvrem;

		this.tridmailorigen = tridmailorigen;
		this.trmailorigen = trmailorigen;
		this.tridmaildestino = tridmaildestino;
		this.trmaildestino = trmaildestino;

		this.tristelematica = tristelematica;

		this.trIsSir = trIsSir;
		this.trIsSirConNumRegEntOri = trIsSirConNumRegEntOri;
	}

	/**
	 * Instantiates a new santramexp.
	 * 
	 * @param trid
	 *            the trid
	 * @param trcodigo
	 *            the trcodigo
	 * @param trcodigorel
	 *            the trcodigorel
	 * @param trfecini
	 *            the trfecini
	 * @param trfecfin
	 *            the trfecfin
	 * @param trobserves
	 *            the trobserves
	 * @param trnomtrames
	 *            the trnomtrames
	 * @param trtridrel
	 *            the trtridrel
	 * @param trfecacini
	 *            the trfecacini
	 * @param trresultado
	 *            the trresultado
	 * @param trestimacion
	 *            the trestimacion
	 * @param trresofecha
	 *            the trresofecha
	 * @param trresotipo
	 *            the trresotipo
	 * @param trresosan
	 *            the trresosan
	 * @param trresoimporte
	 *            the trresoimporte
	 * @param trfecregs
	 *            the trfecregs
	 * @param trfecrege
	 *            the trfecrege
	 * @param trestadoacuse
	 *            the trestadoacuse
	 * @param trnumregs
	 *            the trnumregs
	 * @param trnumrege
	 *            the trnumrege
	 * @param trtipocom
	 *            the trtipocom
	 * @param trfecenvio
	 *            the trfecenvio
	 * @param trfeccierre
	 *            the trfeccierre
	 * @param trtiponot
	 *            the trtiponot
	 * @param trtiponotplatea
	 *            the trtiponotplatea
	 * @param trnumDias
	 *            the trnum dias
	 * @param truaidinterv
	 *            the truaidinterv
	 * @param trfecbopv
	 *            the trfecbopv
	 * @param trfecinitabl
	 *            the trfecinitabl
	 * @param trfecnotif
	 *            the trfecnotif
	 * @param trfecalta
	 *            the trfecalta
	 * @param trfecmodif
	 *            the trfecmodif
	 * @param trusualta
	 *            the trusualta
	 * @param trusumodif
	 *            the trusumodif
	 * @param expedien
	 *            the expedien
	 * @param fase
	 *            the fase
	 * @param censoMonitor
	 *            the censo monitor
	 * @param censoMonitorEj
	 *            the censo monitor ej
	 * @param trestado
	 *            the trestado
	 * @param trtexto
	 *            the trtexto
	 * @param tridnotifplatea
	 *            the tridnotifplatea
	 */
	public Santramexp(String trid, String trcodigo, String trcodigorel, Date trfecini, Date trfecfin, Clob trobserves,
			String trnomtrames, String trtridrel, Date trfecacini, BigDecimal trresultado, String trestimacion,
			Date trresofecha, String trresotipo, BigDecimal trresosan, BigDecimal trresoimporte, Date trfecregs,
			Date trfecrege, String trestadoacuse, String trnumregs, String trnumrege, String trtipocom, Date trfecenvio,
			Date trfeccierre, String trtiponot, String trtiponotplatea, BigDecimal trnumDias, BigDecimal truaidinterv,
			Date trfecbopv, Date trfecinitabl, Date trfecnotif, Date trfecalta, Date trfecmodif, String trusualta,
			String trusumodif, Expedien expedien, Fase fase, CensoMonitor censoMonitor, CensoMonitor censoMonitorEj,
			String trestado, Clob trtexto, String tridnotifplatea, String trsede) {
		this.trid = trid;
		this.expedien = expedien;
		this.trcodigo = trcodigo;
		this.trcodigorel = trcodigorel;
		this.trfecini = trfecini;
		this.trfecfin = trfecfin;
		this.trobserves = trobserves;
		this.trnomtrames = trnomtrames;
		this.trtridrel = trtridrel;
		this.trfecacini = trfecacini;
		this.trresultado = trresultado;
		this.trestimacion = trestimacion;
		this.trresofecha = trresofecha;
		this.trresotipo = trresotipo;
		this.trresosan = trresosan;
		this.trresoimporte = trresoimporte;
		this.trfecregs = trfecregs;
		this.trestadoacuse = trestadoacuse;
		this.trnumregs = trnumregs;
		this.trnumrege = trnumrege;
		this.trtipocom = trtipocom;
		this.trfecenvio = trfecenvio;
		this.trfeccierre = trfeccierre;
		this.trtiponot = trtiponot;
		this.trtiponotplatea = trtiponotplatea;
		this.trfecalta = trfecalta;
		this.trfecmodif = trfecmodif;
		this.trusualta = trusualta;
		this.trusumodif = trusumodif;
		this.fase = fase;
		this.censoMonitor = censoMonitor;
		this.censoMonitorEj = censoMonitorEj;
		this.trestado = trestado;
		this.trnumDias = trnumDias;
		this.truaidinterv = truaidinterv;
		this.trtexto = trtexto;
		this.tridnotifplatea = tridnotifplatea;
		this.trfecbopv = trfecbopv;
		this.trfecinitabl = trfecinitabl;
		this.trsede = trsede;

	}

	/**
	 * Instantiates a new santramexp.
	 * 
	 * @param trid
	 *            the trid
	 * @param trcodigo
	 *            the trcodigo
	 * @param trfecini
	 *            the trfecini
	 * @param trfecfin
	 *            the trfecfin
	 * @param trobserves
	 *            the trobserves
	 * @param trnomtrames
	 *            the trnomtrames
	 * @param trtridrel
	 *            the trtridrel
	 * @param trfecacini
	 *            the trfecacini
	 * @param trresultado
	 *            the trresultado
	 * @param trestimacion
	 *            the trestimacion
	 * @param trresofecha
	 *            the trresofecha
	 * @param trresotipo
	 *            the trresotipo
	 * @param trresosan
	 *            the trresosan
	 * @param trresoimporte
	 *            the trresoimporte
	 * @param trfecregs
	 *            the trfecregs
	 * @param trestadoacuse
	 *            the trestadoacuse
	 * @param trnumregs
	 *            the trnumregs
	 * @param trnumrege
	 *            the trnumrege
	 * @param trtipocom
	 *            the trtipocom
	 * @param trfecenvio
	 *            the trfecenvio
	 * @param trfeccierre
	 *            the trfeccierre
	 * @param trtiponot
	 *            the trtiponot
	 * @param trnumDias
	 *            the trnum dias
	 * @param trfecbopv
	 *            the trfecbopv
	 * @param trfecinitabl
	 *            the trfecinitabl
	 * @param trfecnotif
	 *            the trfecnotif
	 * @param trfecalta
	 *            the trfecalta
	 * @param trfecmodif
	 *            the trfecmodif
	 * @param trusualta
	 *            the trusualta
	 * @param trusumodif
	 *            the trusumodif
	 * @param expedien
	 *            the expedien
	 * @param fase
	 *            the fase
	 * @param censoMonitor
	 *            the censo monitor
	 * @param trestado
	 *            the trestado
	 * @param tramite
	 *            the tramite
	 */
	public Santramexp(String trid, String trcodigo, Date trfecini, Date trfecfin, Clob trobserves, String trnomtrames,
			String trtridrel, Date trfecacini, BigDecimal trresultado, String trestimacion, Date trresofecha,
			String trresotipo, BigDecimal trresosan, BigDecimal trresoimporte, Date trfecregs, String trestadoacuse,
			String trnumregs, String trnumrege, String trtipocom, Date trfecenvio, Date trfeccierre, String trtiponot,
			BigDecimal trnumDias, Date trfecbopv, Date trfecinitabl, Date trfecnotif, Date trfecalta, Date trfecmodif,
			String trusualta, String trusumodif, Expedien expedien, Fase fase, CensoMonitor censoMonitor,
			String trestado, Tramite tramite) {
		this.trid = trid;
		this.expedien = expedien;
		this.trcodigo = trcodigo;
		this.trfecini = trfecini;
		this.trfecfin = trfecfin;
		this.trobserves = trobserves;
		this.trnomtrames = trnomtrames;
		this.trtridrel = trtridrel;
		this.trfecacini = trfecacini;
		this.trresultado = trresultado;
		this.trestimacion = trestimacion;
		this.trresofecha = trresofecha;
		this.trresotipo = trresotipo;
		this.trresosan = trresosan;
		this.trresoimporte = trresoimporte;
		this.trfecregs = trfecregs;
		this.trestadoacuse = trestadoacuse;
		this.trnumregs = trnumregs;
		this.trnumrege = trnumrege;
		this.trtipocom = trtipocom;
		this.trfecenvio = trfecenvio;
		this.trfeccierre = trfeccierre;
		this.trtiponot = trtiponot;
		this.trfecalta = trfecalta;
		this.trfecmodif = trfecmodif;
		this.trusualta = trusualta;
		this.trusumodif = trusumodif;
		this.fase = fase;
		this.censoMonitor = censoMonitor;
		this.trestado = trestado;
		this.tramite = tramite;
		this.trnumDias = trnumDias;

	}

	/**
	 * Method 'Santramexp'. *
	 * 
	 * @param trid
	 *            BigDecimal
	 * @param trcodigo
	 *            String
	 * @param trobserves
	 *            String
	 * @param trnomtrames
	 *            String *
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tramite
	 *            Tramite
	 */
	public Santramexp(String trid, String trcodigo, Clob trobserves, String trnomtrames, CensoMonitor censoMonitor,
			Tramite tramite) {
		this.trid = trid;
		this.trcodigo = trcodigo;
		this.trobserves = trobserves;
		this.trnomtrames = trnomtrames;
		this.censoMonitor = censoMonitor;
		this.tramite = tramite;

	}

	/**
	 * Instantiates a new santramexp.
	 * 
	 * @param trid
	 *            the trid
	 * @param trcodigo
	 *            the trcodigo
	 * @param trfecini
	 *            the trfecini
	 * @param trfecfin
	 *            the trfecfin
	 * @param trobserves
	 *            the trobserves
	 * @param trnomtrames
	 *            the trnomtrames
	 * @param expedien
	 *            the expedien
	 * @param fase
	 *            the fase
	 * @param censoMonitor
	 *            the censo monitor
	 * @param censoMonitorEj
	 *            the censo monitor ej
	 * @param trestado
	 *            the trestado
	 * @param tramite
	 *            the tramite
	 * @param trresoimporte
	 *            the trresoimporte
	 */
	public Santramexp(String trid, String trcodigo, Date trfecini, Date trfecfin, Clob trobserves, String trnomtrames,
			Expedien expedien, Fase fase, CensoMonitor censoMonitor, CensoMonitor censoMonitorEj, String trestado,
			Tramite tramite, BigDecimal trresoimporte, String trestadoacuse, String trreferencia, String trresotipo,
			BigDecimal trresosan) {
		this.trid = trid;
		this.expedien = expedien;
		this.trcodigo = trcodigo;
		this.trfecini = trfecini;
		this.trfecfin = trfecfin;
		this.trobserves = trobserves;
		this.trnomtrames = trnomtrames;
		this.fase = fase;
		this.censoMonitor = censoMonitor;
		this.censoMonitorEj = censoMonitorEj;
		this.trestado = trestado;
		this.tramite = tramite;
		this.trresoimporte = trresoimporte;
		this.trestadoacuse = trestadoacuse;
		this.trreferencia = trreferencia;
		this.trresotipo = trresotipo;
		this.trresosan = trresosan;

	}

	/**
	 * Method 'Santramexp'. *
	 * 
	 * @param trid
	 *            BigDecimal
	 * @param trobserves
	 *            String
	 * @param trtexto
	 *            the trtexto
	 */
	public Santramexp(String trid, Clob trobserves, Clob trtexto) {
		this.trid = trid;
		this.trobserves = trobserves;
		this.trtexto = trtexto;
	}

	/**
	 * Method 'Santramexp'.
	 * 
	 * @param trid
	 *            BigDecimal
	 * @param trcodigo
	 *            String
	 * @param trfecini
	 *            Date
	 * @param trfecfin
	 *            Date
	 * @param trobserves
	 *            String
	 * @param trmocodigo
	 *            String
	 * @param trtridrel
	 *            BigDecimal
	 * @param trfecacini
	 *            Date
	 * @param trresultado
	 *            String
	 * @param trestimacion
	 *            String
	 * @param trresofecha
	 *            Date
	 * @param trresotipo
	 *            String
	 * @param trresosan
	 *            String
	 * @param trresoimporte
	 *            String
	 * @param trfecregs
	 *            Date
	 * @param trestadoacuse
	 *            String
	 * @param trnumregs
	 *            String
	 * @param trnumrege
	 *            String
	 * @param trtipocom
	 *            String
	 * @param trfecenvio
	 *            String
	 * @param trfeccierre
	 *            Date
	 * @param trtiponot
	 *            String
	 * @param trfecalta
	 *            Date
	 * @param trfecmodif
	 *            Date
	 * @param trusualta
	 *            String
	 * @param trusumodif
	 *            String
	 * @param expedien
	 *            Expedien
	 * @param sanenviosForEntridacuse
	 *            List<Sanenvio>
	 * @param sanenviosForEntrid
	 *            List<Sanenvio>
	 * @param sandoctemps
	 *            List<Sandoctemp>
	 * @param fase
	 *            Fase
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	public Santramexp(String trid, String trcodigo, Date trfecini, Date trfecfin, Clob trobserves, String trmocodigo,
			String trtridrel, Date trfecacini, BigDecimal trresultado, String trestimacion, Date trresofecha,
			String trresotipo, BigDecimal trresosan, BigDecimal trresoimporte, Date trfecregs, String trestadoacuse,
			String trnumregs, String trnumrege, String trtipocom, Date trfecenvio, Date trfeccierre, String trtiponot,
			Date trfecalta, Date trfecmodif, String trusualta, String trusumodif, Expedien expedien,
			List<Sanenvio> sanenviosForEntridacuse, List<Sanenvio> sanenviosForEntrid, List<Sandoctemp> sandoctemps,
			Fase fase, CensoMonitor censoMonitor) {

		this.trid = trid;
		this.expedien = expedien;
		this.trcodigo = trcodigo;
		this.trfecini = trfecini;
		this.trfecfin = trfecfin;
		this.trobserves = trobserves;

		this.trtridrel = trtridrel;
		this.trfecacini = trfecacini;
		this.trresultado = trresultado;
		this.trestimacion = trestimacion;
		this.trresofecha = trresofecha;
		this.trresotipo = trresotipo;
		this.trresosan = trresosan;
		this.trresoimporte = trresoimporte;
		this.trfecregs = trfecregs;
		this.trestadoacuse = trestadoacuse;
		this.trnumregs = trnumregs;
		this.trnumrege = trnumrege;
		this.trtipocom = trtipocom;
		this.trfecenvio = trfecenvio;
		this.trfeccierre = trfeccierre;
		this.trtiponot = trtiponot;
		this.trfecalta = trfecalta;
		this.trfecmodif = trfecmodif;
		this.trusualta = trusualta;
		this.trusumodif = trusumodif;
		this.sanenviosForEntridacuse = sanenviosForEntridacuse;
		this.sanenviosForEntrid = sanenviosForEntrid;
		this.sandoctemps = sandoctemps;
		this.fase = fase;

	}

	/**
	 * Method 'getTrid'.
	 * 
	 * @return String
	 */

	public String getTrid() {
		return this.trid;
	}

	/**
	 * Method 'setTrid'.
	 * 
	 * @param trid
	 *            String
	 * @return
	 */

	public void setTrid(String trid) {
		this.trid = trid;
	}

	/**
	 * Method 'getExpedien'.
	 * 
	 * @return Expedien
	 */
	@JsonIgnore()
	public Expedien getExpedien() {
		return this.expedien;
	}

	/**
	 * Method 'setExpedien'.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return
	 */

	public void setExpedien(Expedien expedien) {
		this.expedien = expedien;
	}

	/**
	 * Method 'getTrcodigo'.
	 * 
	 * @return String
	 */

	public String getTrcodigo() {
		return this.trcodigo;
	}

	/**
	 * Method 'setTrcodigo'.
	 * 
	 * @param trcodigo
	 *            String
	 * @return
	 */

	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * Method 'getTrcodigo'.
	 * 
	 * @return String
	 */

	public String getTrcodigorel() {
		return this.trcodigorel;
	}

	/**
	 * Method 'setTrcodigo'.
	 * 
	 * @param trcodigorel
	 *            the new trcodigorel
	 */

	public void setTrcodigorel(String trcodigorel) {
		this.trcodigorel = trcodigorel;
	}

	/**
	 * Method 'getTrfecini'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getTrfecini() {
		return this.trfecini;
	}

	/**
	 * Method 'setTrfecini'.
	 * 
	 * @param trfecini
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateTimeDeserializer.class)
	public void setTrfecini(Date trfecini) {
		this.trfecini = trfecini;
	}

	/**
	 * Method 'getTrfecfin'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getTrfecfin() {
		return this.trfecfin;
	}

	/**
	 * Method 'setTrfecfin'.
	 * 
	 * @param trfecfin
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateTimeDeserializer.class)
	public void setTrfecfin(Date trfecfin) {
		this.trfecfin = trfecfin;
	}

	/**
	 * Method 'getTrobserves'.
	 * 
	 * @return Clob
	 */

	public Clob getTrobserves() {
		return this.trobserves;
	}

	/**
	 * Method 'setTrobserves'.
	 * 
	 * @param trobserves
	 *            StClobring
	 * @return
	 */

	public void setTrobserves(Clob trobserves) {
		this.trobserves = trobserves;
	}

	/**
	 * // * Method 'getCensoMonitor'.
	 * 
	 * @return CensoMonitor
	 */

	public CensoMonitor getCensoMonitor() {
		return this.censoMonitor;
	}

	/**
	 * Method 'setCensoMonitor'.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return
	 */

	public void setCensoMonitor(CensoMonitor censoMonitor) {
		this.censoMonitor = censoMonitor;
	}

	/**
	 * // * Method 'getCensoMonitorEj'.
	 * 
	 * @return CensoMonitor
	 */

	public CensoMonitor getCensoMonitorEj() {
		return this.censoMonitorEj;
	}

	/**
	 * Method 'setCensoMonitor'.
	 * 
	 * @param censoMonitorEj
	 *            the new censo monitor ej
	 */

	public void setCensoMonitorEj(CensoMonitor censoMonitorEj) {
		this.censoMonitorEj = censoMonitorEj;
	}

	/**
	 * Method 'getTrtridrel'.
	 * 
	 * @return String
	 */

	public String getTrtridrel() {
		return this.trtridrel;
	}

	/**
	 * Method 'setTrtridrel'.
	 * 
	 * @param trtridrel
	 *            String
	 * @return
	 */

	public void setTrtridrel(String trtridrel) {
		this.trtridrel = trtridrel;
	}

	/**
	 * Method 'getTrfecacini'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfecacini() {
		return this.trfecacini;
	}

	/**
	 * Method 'setTrfecacini'.
	 * 
	 * @param trfecacini
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfecacini(Date trfecacini) {
		this.trfecacini = trfecacini;
	}

	/**
	 * Method 'getTrresultado'.
	 * 
	 * @return String
	 */

	public BigDecimal getTrresultado() {
		return this.trresultado;
	}

	/**
	 * Method 'setTrresultado'.
	 * 
	 * @param trresultado
	 *            String
	 * @return
	 */

	public void setTrresultado(BigDecimal trresultado) {
		this.trresultado = trresultado;
	}

	/**
	 * Method 'getTrestimacion'.
	 * 
	 * @return String
	 */

	public String getTrestimacion() {
		return this.trestimacion;
	}

	/**
	 * Method 'setTrestimacion'.
	 * 
	 * @param trestimacion
	 *            String
	 * @return
	 */

	public void setTrestimacion(String trestimacion) {
		this.trestimacion = trestimacion;
	}

	/**
	 * Method 'getTrresofecha'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrresofecha() {
		return this.trresofecha;
	}

	/**
	 * Method 'setTrresofecha'.
	 * 
	 * @param trresofecha
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrresofecha(Date trresofecha) {
		this.trresofecha = trresofecha;
	}

	/**
	 * Method 'getTrresotipo'.
	 * 
	 * @return String
	 */

	public String getTrresotipo() {
		return this.trresotipo;
	}

	/**
	 * Method 'setTrresotipo'.
	 * 
	 * @param trresotipo
	 *            String
	 * @return
	 */

	public void setTrresotipo(String trresotipo) {
		this.trresotipo = trresotipo;
	}

	/**
	 * Method 'getTrresosan'.
	 * 
	 * @return String
	 */

	public BigDecimal getTrresosan() {
		return this.trresosan;
	}

	/**
	 * Method 'setTrresosan'.
	 * 
	 * @param trresosan
	 *            String
	 * @return
	 */

	public void setTrresosan(BigDecimal trresosan) {
		this.trresosan = trresosan;
	}

	/**
	 * Method 'getTrresoimporte'.
	 * 
	 * @return String
	 */

	public BigDecimal getTrresoimporte() {
		return this.trresoimporte;
	}

	/**
	 * Method 'setTrresoimporte'.
	 * 
	 * @param trresoimporte
	 *            String
	 * @return
	 */

	public void setTrresoimporte(BigDecimal trresoimporte) {
		this.trresoimporte = trresoimporte;
	}

	/**
	 * Method 'getTrrcatiporecurso'.
	 * 
	 * @return String
	 */

	public String getTrestadoacuse() {
		return this.trestadoacuse;
	}

	/**
	 * Method 'setTrrcatiporecurso'.
	 * 
	 * @param trestadoacuse
	 *            String
	 * @return
	 */

	public void setTrestadoacuse(String trestadoacuse) {
		this.trestadoacuse = trestadoacuse;
	}

	/**
	 * Method 'getTrnumregs'.
	 * 
	 * @return String
	 */

	public String getTrnumregs() {
		return this.trnumregs;
	}

	/**
	 * Method 'setTrnumregs'.
	 * 
	 * @param trnumregs
	 *            String
	 * @return
	 */

	public void setTrnumregs(String trnumregs) {
		this.trnumregs = trnumregs;
	}

	/**
	 * Method 'getTrnumrege'.
	 * 
	 * @return String
	 */

	public String getTrnumrege() {
		return this.trnumrege;
	}

	/**
	 * Method 'setTrnumrege'.
	 * 
	 * @param trnumrege
	 *            String
	 * @return
	 */

	public void setTrnumrege(String trnumrege) {
		this.trnumrege = trnumrege;
	}

	/**
	 * Method 'getTrfecenvio'.
	 * 
	 * @return String
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfecenvio() {
		return this.trfecenvio;
	}

	/**
	 * Method 'setTrfecenvio'.
	 * 
	 * @param trfecenvio
	 *            String
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfecenvio(Date trfecenvio) {
		this.trfecenvio = trfecenvio;
	}

	/**
	 * Method 'getTrfeccierre'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfeccierre() {
		return this.trfeccierre;
	}

	/**
	 * Method 'setTrfeccierre'.
	 * 
	 * @param trfeccierre
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfeccierre(Date trfeccierre) {
		this.trfeccierre = trfeccierre;
	}

	/**
	 * Method 'getTrtiponot'.
	 * 
	 * @return String
	 */

	public String getTrtiponot() {
		return this.trtiponot;
	}

	/**
	 * Method 'setTrtiponot'.
	 * 
	 * @param trtiponot
	 *            String
	 * @return
	 */

	public void setTrtiponot(String trtiponot) {
		this.trtiponot = trtiponot;
	}

	/**
	 * Method 'getTrfecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfecalta() {
		return this.trfecalta;
	}

	/**
	 * Method 'setTrfecalta'.
	 * 
	 * @param trfecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfecalta(Date trfecalta) {
		this.trfecalta = trfecalta;
	}

	/**
	 * Method 'getTrfecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfecmodif() {
		return this.trfecmodif;
	}

	/**
	 * Method 'setTrfecmodif'.
	 * 
	 * @param trfecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfecmodif(Date trfecmodif) {
		this.trfecmodif = trfecmodif;
	}

	/**
	 * Method 'getTrusualta'.
	 * 
	 * @return String
	 */

	public String getTrusualta() {
		return this.trusualta;
	}

	/**
	 * Method 'setTrusualta'.
	 * 
	 * @param trusualta
	 *            String
	 * @return
	 */

	public void setTrusualta(String trusualta) {
		this.trusualta = trusualta;
	}

	/**
	 * Method 'getTrusumodif'.
	 * 
	 * @return String
	 */

	public String getTrusumodif() {
		return this.trusumodif;
	}

	/**
	 * Method 'setTrusumodif'.
	 * 
	 * @param trusumodif
	 *            String
	 * @return
	 */

	public void setTrusumodif(String trusumodif) {
		this.trusumodif = trusumodif;
	}

	/**
	 * Method 'getSanenviosForEntridacuse'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sanenvio> getSanenviosForEntridacuse() {
		return this.sanenviosForEntridacuse;
	}

	/**
	 * Method 'setSanenviosForEntridacuse'.
	 * 
	 * @param sanenviosForEntridacuse
	 *            List
	 * @return
	 */
	public void setSanenviosForEntridacuse(List<Sanenvio> sanenviosForEntridacuse) {
		this.sanenviosForEntridacuse = sanenviosForEntridacuse;
	}

	/**
	 * Method 'getSanenviosForEntrid'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sanenvio> getSanenviosForEntrid() {
		return this.sanenviosForEntrid;
	}

	/**
	 * Method 'setSanenviosForEntrid'.
	 * 
	 * @param sanenviosForEntrid
	 *            List
	 * @return
	 */
	public void setSanenviosForEntrid(List<Sanenvio> sanenviosForEntrid) {
		this.sanenviosForEntrid = sanenviosForEntrid;
	}

	/**
	 * Method 'getSandoctemps'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sandoctemp> getSandoctemps() {
		return this.sandoctemps;
	}

	/**
	 * Method 'setSandoctemps'.
	 * 
	 * @param sandoctemps
	 *            List
	 * @return
	 */
	public void setSandoctemps(List<Sandoctemp> sandoctemps) {
		this.sandoctemps = sandoctemps;
	}

	/**
	 * Method 'getFase'.
	 * 
	 * @return Fase
	 */

	public Fase getFase() {
		return this.fase;
	}

	/**
	 * Method 'setFase'.
	 * 
	 * @param fase
	 *            Fase
	 * @return
	 */

	public void setFase(Fase fase) {
		this.fase = fase;
	}

	/**
	 * Method 'getTramite'.
	 * 
	 * @return Tramite
	 */

	public Tramite getTramite() {
		return this.tramite;
	}

	/**
	 * Method 'setTramite'.
	 * 
	 * @param tramite
	 *            the new tramite
	 */

	public void setTramite(Tramite tramite) {
		this.tramite = tramite;
	}

	/**
	 * @return the trasuntocomunicacion
	 */
	public String getTrasuntocomunicacion() {
		return this.trasuntocomunicacion;
	}

	/**
	 * @param trasuntocomunicacion
	 *            the trasuntocomunicacion to set
	 */
	public void setTrasuntocomunicacion(String trasuntocomunicacion) {
		this.trasuntocomunicacion = trasuntocomunicacion;
	}

	/**
	 * @return the trsede
	 */
	public String getTrsede() {
		return this.trsede;
	}

	/**
	 * @param trsede
	 *            the trsede to set
	 */
	public void setTrsede(String trsede) {
		this.trsede = trsede;
	}

	/**
	 * Intended only for logging and debugging. Here, the contents of every main
	 * field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ trid: ").append(this.trid).append(" ]");
		result.append(", [ trcodigo: ").append(this.trcodigo).append(" ]");
		result.append(", [ trfecini: ").append(this.trfecini).append(" ]");
		result.append(", [ trfecfin: ").append(this.trfecfin).append(" ]");
		result.append(", [ trobserves: ").append(this.trobserves).append(" ]");

		/*
		 * result.append(", [ trmocodigo: ").append(this.trmocodigo).append(" ]"
		 * ) ;
		 */
		result.append(", [ trtridrel: ").append(this.trtridrel).append(" ]");
		result.append(", [ trfecacini: ").append(this.trfecacini).append(" ]");
		result.append(", [ trresultado: ").append(this.trresultado).append(" ]");
		result.append(", [ trestimacion: ").append(this.trestimacion).append(" ]");
		result.append(", [ trresofecha: ").append(this.trresofecha).append(" ]");
		result.append(", [ trresotipo: ").append(this.trresotipo).append(" ]");
		result.append(", [ trresosan: ").append(this.trresosan).append(" ]");
		result.append(", [ trresoimporte: ").append(this.trresoimporte).append(" ]");
		result.append(", [ trfecregs: ").append(this.trfecregs).append(" ]");
		result.append(", [ trestadoacuse: ").append(this.trestadoacuse).append(" ]");
		result.append(", [ trnumregs: ").append(this.trnumregs).append(" ]");
		result.append(", [ trnumrege: ").append(this.trnumrege).append(" ]");
		result.append(", [ trtipocom: ").append(this.trtipocom).append(" ]");
		result.append(", [ trfecenvio: ").append(this.trfecenvio).append(" ]");
		result.append(", [ trfeccierre: ").append(this.trfeccierre).append(" ]");
		result.append(", [ trfecalta: ").append(this.trfecalta).append(" ]");
		result.append(", [ trfecmodif: ").append(this.trfecmodif).append(" ]");
		result.append(", [ trusualta: ").append(this.trusualta).append(" ]");
		result.append(", [ trusumodif: ").append(this.trusumodif).append(" ]");
		result.append(", [ trisNotificacionIncoacion: ").append(this.trisNotificacionIncoacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @param trnomtrames
	 *            the trestado to set
	 */
	public void setTrnomtrames(String trnomtrames) {
		this.trnomtrames = trnomtrames;
	}

	/**
	 * @return the trnomtrames
	 */
	public String getTrnomtrames() {
		return trnomtrames;
	}

	/**
	 * @param trestado
	 *            the trestado to set
	 */
	public void setTrestado(String trestado) {
		this.trestado = trestado;
	}

	/**
	 * @return the trestado
	 */
	public String getTrestado() {
		return trestado;
	}

	/**
	 * Sets the tridnotifplatea.
	 * 
	 * @param tridnotifplatea
	 *            the new tridnotifplatea
	 */
	public void setTridnotifplatea(String tridnotifplatea) {
		this.tridnotifplatea = tridnotifplatea;
	}

	/**
	 * Gets the tridnotifplatea.
	 * 
	 * @return the tridnotifplatea
	 */
	public String getTridnotifplatea() {
		return tridnotifplatea;
	}

	/**
	 * @param trfecregs
	 *            the trfecregs to set
	 */
	public void setTrfecregs(Date trfecregs) {
		this.trfecregs = trfecregs;
	}

	/**
	 * @return the trfecregs
	 */
	public Date getTrfecregs() {
		return trfecregs;
	}

	/**
	 * @return the trnomtramCompleto
	 */
	public String getTrnomtramCompletoes() {
		if (Y41bConstantes.TRAMITE_SANCIONES_GENERICO.equals(trcodigo)) {
			this.trnomtramCompleto = trnomtrames;
		} else {
			this.trnomtramCompleto = (null == tramite ? "" : tramite.getTrnombre());
		}
		return this.trnomtramCompleto;
	}

	// /**
	// * @param trnomtramCompleto
	// * the trnomtramCompleto to set
	// */
	// public void setTrnomtramCompleto(String trnomtramCompleto) {
	//
	// if (Y41bConstantes.TRAMITE_SANCIONES_GENERICO.equals(trcodigo)) {
	// this.trnomtramCompleto = trnomtrames;
	// } else {
	// this.trnomtramCompleto = trobserves;
	// }
	//
	// }

	/**
	 * @return the trnomtramCompletoEU
	 */

	// public String getTrnomtramCompletoeu() {
	// if (Y41bConstantes.TRAMITE_SANCIONES_GENERICO.equals(trcodigo)) {
	// this.trnomtramCompleto = trnomtrames;
	// } else {
	// this.trnomtramCompleto = tramite.getTrnombree();
	// }
	// return this.trnomtramCompleto;
	// }

	public String getTrnomtramCompletoeu() {
		if (Y41bConstantes.TRAMITE_SANCIONES_GENERICO.equals(trcodigo)) {
			this.trnomtramCompleto = trnomtrames;
		} else {
			this.trnomtramCompleto = (null == tramite ? "" : tramite.getTrnombree());
		}
		return this.trnomtramCompleto;
	}

	/**
	 * Sets the trnum dias.
	 * 
	 * @param trnumDias
	 *            the new trnum dias
	 */
	public void setTrnumDias(BigDecimal trnumDias) {
		this.trnumDias = trnumDias;
	}

	/**
	 * Gets the trnum dias.
	 * 
	 * @return the trnum dias
	 */
	public BigDecimal getTrnumDias() {
		return trnumDias;
	}

	/**
	 * Sets the trfecnotif.
	 * 
	 * @param trfecnotif
	 *            the new trfecnotif
	 */
	public void setTrfecnotif(Date trfecnotif) {
		this.trfecnotif = trfecnotif;
	}

	/**
	 * Gets the trfecnotif.
	 * 
	 * @return the trfecnotif
	 */
	public Date getTrfecnotif() {
		return trfecnotif;
	}

	/**
	 * Sets the trfecinitabl.
	 * 
	 * @param trfecinitabl
	 *            the new trfecinitabl
	 */
	public void setTrfecinitabl(Date trfecinitabl) {
		this.trfecinitabl = trfecinitabl;
	}

	/**
	 * Gets the trfecinitabl.
	 * 
	 * @return the trfecinitabl
	 */
	public Date getTrfecinitabl() {
		return trfecinitabl;
	}

	/**
	 * Sets the trfecbopv.
	 * 
	 * @param trfecbopv
	 *            the new trfecbopv
	 */
	public void setTrfecbopv(Date trfecbopv) {
		this.trfecbopv = trfecbopv;
	}

	/**
	 * Gets the trfecbopv.
	 * 
	 * @return the trfecbopv
	 */
	public Date getTrfecbopv() {
		return trfecbopv;
	}

	/**
	 * Sets the truaidinterv.
	 * 
	 * @param truaidinterv
	 *            the new truaidinterv
	 */
	public void setTruaidinterv(BigDecimal truaidinterv) {
		this.truaidinterv = truaidinterv;
	}

	/**
	 * Gets the truaidinterv.
	 * 
	 * @return the truaidinterv
	 */
	public BigDecimal getTruaidinterv() {
		return truaidinterv;
	}

	/**
	 * @param trtexto
	 *            the trtexto to set
	 */
	public void setTrtexto(Clob trtexto) {
		this.trtexto = trtexto;
	}

	/**
	 * @return the trtexto
	 */
	public Clob getTrtexto() {
		return trtexto;
	}

	/**
	 * @param trfecrege
	 *            the trfecrege to set
	 */
	public void setTrfecrege(Date trfecrege) {
		this.trfecrege = trfecrege;
	}

	/**
	 * @return the trfecrege
	 */
	public Date getTrfecrege() {
		return trfecrege;
	}

	/**
	 * @return the trtipocom
	 */
	public String getTrtipocom() {
		return trtipocom;
	}

	/**
	 * @param trtipocom
	 *            the trtipocom to set
	 */
	public void setTrtipocom(String trtipocom) {
		this.trtipocom = trtipocom;
	}

	/**
	 * @return the ehidesperaplatea
	 */
	public String getTridesperaplatea() {
		return tridesperaplatea;
	}

	/**
	 * Sets the tridesperaplatea.
	 * 
	 * @param tridesperaplatea
	 *            the new tridesperaplatea
	 */
	public void setTridesperaplatea(String tridesperaplatea) {
		this.tridesperaplatea = tridesperaplatea;
	}

	/**
	 * @return the ehmatarespera
	 */
	public String getTrmatarespera() {
		return trmatarespera;
	}

	/**
	 * Sets the trmatarespera.
	 * 
	 * @param trmatarespera
	 *            the new trmatarespera
	 */
	public void setTrmatarespera(String trmatarespera) {
		this.trmatarespera = trmatarespera;
	}

	/**
	 * Method 'getTrfecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfecacuse() {
		return this.trfecacuse;
	}

	/**
	 * Method 'setTrfecalta'.
	 * 
	 * @param trfecacuse
	 *            the new trfecacuse
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfecacuse(Date trfecacuse) {
		this.trfecacuse = trfecacuse;
	}

	/**
	 * @return the trtiponotplatea
	 */
	public String getTrtiponotplatea() {
		return trtiponotplatea;
	}

	/**
	 * @param trtiponotplatea
	 *            the trtiponotplatea to set
	 */
	public void setTrtiponotplatea(String trtiponotplatea) {
		this.trtiponotplatea = trtiponotplatea;
	}

	/**
	 * @return the indVariosDocumentos
	 */
	public String getIndVariosDocumentos() {
		return indVariosDocumentos;
	}

	/**
	 * @param indVariosDocumentos
	 *            the indVariosDocumentos to set
	 */
	public void setIndVariosDocumentos(String indVariosDocumentos) {
		this.indVariosDocumentos = indVariosDocumentos;
	}

	/**
	 * @return the q5codocumento
	 */
	public String getU5codocumento() {
		return u5codocumento;
	}

	/**
	 * @param q5codocumento
	 *            the q5codocumento to set
	 */
	public void setU5codocumento(String q5codocumento) {
		this.u5codocumento = q5codocumento;
	}

	/**
	 * @return the q5nofile
	 */
	public String getU5nofile() {
		return u5nofile;
	}

	/**
	 * @param q5nofile
	 *            the q5nofile to set
	 */
	public void setU5nofile(String q5nofile) {
		this.u5nofile = q5nofile;
	}

	/**
	 * @return the q5datafile
	 */
	public Blob getU5datafile() {
		return u5datafile;
	}

	/**
	 * @param q5datafile
	 *            the q5datafile to set
	 */
	public void setU5datafile(Blob q5datafile) {
		this.u5datafile = q5datafile;
	}

	/**
	 * @return the q5sizefile
	 */
	public Integer getU5sizefile() {
		return u5sizefile;
	}

	/**
	 * @param q5sizefile
	 *            the q5sizefile to set
	 */
	public void setU5sizefile(Integer q5sizefile) {
		this.u5sizefile = q5sizefile;
	}

	/**
	 * @return the q5tedesfile
	 */
	public String getU5tedesfile() {
		return u5tedesfile;
	}

	/**
	 * @param q5tedesfile
	 *            the q5tedesfile to set
	 */
	public void setU5tedesfile(String q5tedesfile) {
		this.u5tedesfile = q5tedesfile;
	}

	/**
	 * @return the q5contenttypefile
	 */
	public String getU5contenttypefile() {
		return u5contenttypefile;
	}

	/**
	 * @param q5contenttypefile
	 *            the q5contenttypefile to set
	 */
	public void setU5contenttypefile(String q5contenttypefile) {
		this.u5contenttypefile = q5contenttypefile;
	}

	/**
	 * @return the trreferencia
	 */
	public String getTrreferencia() {
		return trreferencia;
	}

	/**
	 * @param trreferencia
	 *            the trreferencia to set
	 */
	public void setTrreferencia(String trreferencia) {
		this.trreferencia = trreferencia;
	}

	/**
	 * @return the tridmailorigen
	 */
	public String getTridmailorigen() {
		return tridmailorigen;
	}

	/**
	 * @param tridmailorigen
	 *            the tridmailorigen to set
	 */
	public void setTridmailorigen(String tridmailorigen) {
		this.tridmailorigen = tridmailorigen;
	}

	/**
	 * @return the trmailorigen
	 */
	public String getTrmailorigen() {
		return trmailorigen;
	}

	/**
	 * @param trmailorigen
	 *            the trmailorigen to set
	 */
	public void setTrmailorigen(String trmailorigen) {
		this.trmailorigen = trmailorigen;
	}

	/**
	 * @return the tridmaildestino
	 */
	public String getTridmaildestino() {
		return tridmaildestino;
	}

	/**
	 * @param tridmaildestino
	 *            the tridmaildestino to set
	 */
	public void setTridmaildestino(String tridmaildestino) {
		this.tridmaildestino = tridmaildestino;
	}

	/**
	 * @return the trmaildestino
	 */
	public String getTrmaildestino() {
		return trmaildestino;
	}

	/**
	 * @param trmaildestino
	 *            the trmaildestino to set
	 */
	public void setTrmaildestino(String trmaildestino) {
		this.trmaildestino = trmaildestino;
	}

	/**
	 * @return the acuseSinNotificacion
	 */
	public String getAcuseSinNotificacion() {
		return acuseSinNotificacion;
	}

	/**
	 * @param acuseSinNotificacion
	 *            the acuseSinNotificacion to set
	 */
	public void setAcuseSinNotificacion(String acuseSinNotificacion) {
		this.acuseSinNotificacion = acuseSinNotificacion;
	}

	/**
	 * @return the trfechaEnvioBOPVBOE
	 */
	public Date getTrfechaEnvioBOPVBOE() {
		return trfechaEnvioBOPVBOE;
	}

	/**
	 * @param trfechaEnvioBOPVBOE
	 *            the trfechaEnvioBOPVBOE to set
	 */
	public void setTrfechaEnvioBOPVBOE(Date trfechaEnvioBOPVBOE) {
		this.trfechaEnvioBOPVBOE = trfechaEnvioBOPVBOE;
	}

	/**
	 * @return the envcdessitcorreoseu
	 */
	public String getEnvcdessitcorreoseu() {
		return envcdessitcorreoseu;
	}

	/**
	 * @param envcdessitcorreoseu
	 *            the envcdessitcorreoseu to set
	 */
	public void setEnvcdessitcorreoseu(String envcdessitcorreoseu) {
		this.envcdessitcorreoseu = envcdessitcorreoseu;
	}

	/**
	 * @return the envcdessitcorreoses
	 */
	public String getEnvcdessitcorreoses() {
		return envcdessitcorreoses;
	}

	/**
	 * @param envcdessitcorreoses
	 *            the envcdessitcorreoses to set
	 */
	public void setEnvcdessitcorreoses(String envcdessitcorreoses) {
		this.envcdessitcorreoses = envcdessitcorreoses;
	}

	/**
	 * @return the nombreDestOrigen
	 */
	public String getNombreDestOrigen() {
		return nombreDestOrigen;
	}

	/**
	 * @param nombreDestOrigen
	 *            the nombreDestOrigen to set
	 */
	public void setNombreDestOrigen(String nombreDestOrigen) {
		this.nombreDestOrigen = nombreDestOrigen;
	}

	/**
	 * @return the trproceedingsidplatea
	 */
	public String getTrproceedingsidplatea() {
		return trproceedingsidplatea;
	}

	/**
	 * @param trproceedingsidplatea
	 *            the trproceedingsidplatea to set
	 */
	public void setTrproceedingsidplatea(String trproceedingsidplatea) {
		this.trproceedingsidplatea = trproceedingsidplatea;
	}

	/**
	 * @return the trimporteinicial
	 */
	public BigDecimal getTrimporteinicial() {
		return trimporteinicial;
	}

	/**
	 * @param trimporteinicial
	 *            the trimporteinicial to set
	 */
	public void setTrimporteinicial(BigDecimal trimporteinicial) {
		this.trimporteinicial = trimporteinicial;
	}

	/**
	 * @return the trfecsolred
	 */
	public Date getTrfecsolred() {
		return trfecsolred;
	}

	/**
	 * @param trfecsolred
	 *            the trfecsolred to set
	 */
	public void setTrfecsolred(Date trfecsolred) {
		this.trfecsolred = trfecsolred;
	}

	/**
	 * @return the trprontopago
	 */
	public String getTrprontopago() {
		return trprontopago;
	}

	/**
	 * @param trprontopago
	 *            the trprontopago to set
	 */
	public void setTrprontopago(String trprontopago) {
		this.trprontopago = trprontopago;
	}

	/**
	 * @return the trreconocimiento
	 */
	public String getTrreconocimiento() {
		return trreconocimiento;
	}

	/**
	 * @param trreconocimiento
	 *            the trreconocimiento to set
	 */
	public void setTrreconocimiento(String trreconocimiento) {
		this.trreconocimiento = trreconocimiento;
	}

	/**
	 * @return the tipoDestOrigen
	 */
	public String getTipoDestOrigen() {
		return tipoDestOrigen;
	}

	/**
	 * @param tipoDestOrigen
	 *            the tipoDestOrigen to set
	 */
	public void setTipoDestOrigen(String tipoDestOrigen) {
		this.tipoDestOrigen = tipoDestOrigen;
	}

	/**
	 * @return the trcusereintentado
	 */
	public void setTracusereintentado(String tracusereintentado) {
		this.tracusereintentado = tracusereintentado;
	}

	/**
	 * @param tracusereintentado
	 *            the tracusereintentado to set
	 */
	public String getTracusereintentado() {
		return tracusereintentado;
	}

	/**
	 * @return the trautomatico
	 */
	public String getTrautomatico() {
		return trautomatico;
	}

	/**
	 * @param trautomatico
	 *            the trautomatico to set
	 */
	public void setTrautomatico(String trautomatico) {
		this.trautomatico = trautomatico;
	}

	/**
	 * @param trrespuesta
	 *            the trrespuesta to set
	 */
	public void setTrrespuesta(String trrespuesta) {
		this.trrespuesta = trrespuesta;
	}

	/**
	 * @return the trrespuesta
	 */
	public String getTrrespuesta() {
		return trrespuesta;
	}

	/**
	 * @param trresumenalegaciones
	 *            the trresumenalegaciones to set
	 */
	public void setTrresumenalegaciones(Clob trresumenalegaciones) {
		this.trresumenalegaciones = trresumenalegaciones;
	}

	/**
	 * @return the trresumenalegaciones
	 */
	@JsonIgnore
	public Clob getTrresumenalegaciones() {
		return trresumenalegaciones;
	}

	// # INICIO #
	// ADAPTACIONES LEY 39 - COMUNICACION POSTAL INICIO AL
	// SANCIONADO
	/**
	 * @param trisComunicacionInicio
	 *            the trisComunicacionInicio to set
	 */
	public void setTrisComunicacionInicio(String trisComunicacionInicio) {
		this.trisComunicacionInicio = trisComunicacionInicio;
	}

	/**
	 * @param trisNotificacionIncoacion
	 *            the trisComunicacionInicio to set
	 */
	public void setTrisNotificacionIncoacion(String trisNotificacionIncoacion) {
		this.trisNotificacionIncoacion = trisNotificacionIncoacion;
	}

	/**
	 * @return the trisComunicacionInicio
	 */
	public String getTrisComunicacionInicio() {
		return trisComunicacionInicio;
	}

	/**
	 * @return the trisNotificacionIncoacion
	 */
	public String getTrisNotificacionIncoacion() {
		return trisNotificacionIncoacion;
	}

	// # FIN #

	/**
	 * @param tristelematica
	 *            the tristelematica to set
	 */
	public void setTristelematica(String tristelematica) {
		this.tristelematica = tristelematica;
	}

	/**
	 * @return the tristelematica
	 */
	public String getTristelematica() {
		return tristelematica;
	}

	/**
	 * @param trdocreqeus
	 *            the trdocreqeus to set
	 */
	public void setTrdocreqeus(Clob trdocreqeus) {
		this.trdocreqeus = trdocreqeus;
	}

	/**
	 * @return the trdocreqeus
	 */
	@JsonIgnore
	public Clob getTrdocreqeus() {
		return trdocreqeus;
	}

	public String getTrIsSir() {
		return trIsSir;
	}

	public void setTrIsSir(String trIsSir) {
		this.trIsSir = trIsSir;
	}

	/**
	 * @return the trIsSirConNumRegEntOri
	 */
	public String getTrIsSirConNumRegEntOri() {
		return trIsSirConNumRegEntOri;
	}

	/**
	 * @param trIsSirConNumRegEntOri
	 *            the trIsSirConNumRegEntOri to set
	 */
	public void setTrIsSirConNumRegEntOri(String trIsSirConNumRegEntOri) {
		this.trIsSirConNumRegEntOri = trIsSirConNumRegEntOri;
	}

}
