package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Sanrecrca  
 * 
 *  
 */

public class Sanrecrca implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String recodigo;
	private String rercanumsen;
	private Sancuesfondo sancuesfondo;
	private Sancuesproced sancuesproced;
	private Date rercafecenv;
	private String rercasala;
	private String rercaacue;
	private Date rercafecdev;
	private String rercaimpdev;
	private String rercaabo;
	private String rercanota;
	private Date refecalta;
	private Date refecmodif;
	private String reusualta;
	private String reusumodif;

	// Fecha del recurso
	private Date refeinrc;
	private Date refereor;
	// Fecha de la sentencia
	private Date refeserc;
	// Resultado de la sentencia
	private Sanresulsen sanresulsen;
	// Tribunal
	private Tribunal tribunal;
	// multa
	private String recamurc;
	// expediente
	private String excodigo;
	// FECHA NOT RESOLUCION RECURSO ORDINARIO
	private Date refenrro;

	/**
	 * Method 'Sanrecrca'.
	 */
	public Sanrecrca() {
	}

	/**
	 * Method 'Sanrecrca'.
	 * 
	 * @param recodigo
	 *            String
	 * @param rercafecenv
	 *            Date
	 * @param sanresulsen
	 *            Sanresulsen
	 * @param tribunal
	 *            String
	 * @param rercasala
	 *            String
	 * @param rercaacue
	 *            String
	 * @param rercafecdev
	 *            Date
	 * @param rercaimpdev
	 *            BigDecimal
	 * @param rercaabo
	 *            String
	 * @param rercanota
	 *            String
	 * @param refecalta
	 *            Date
	 * @param refecmodif
	 *            Date
	 * @param reusualta
	 *            String
	 * @param reusumodif
	 *            String
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @param sancuesproced
	 *            Sancuesproced
	 */
	public Sanrecrca(String recodigo, Date rercafecenv, String rercanumsen,
			Sanresulsen sanresulsen, Tribunal tribunal, String rercasala,
			String rercaacue, Date rercafecdev, String rercaimpdev,
			String rercaabo, String rercanota, Date refecalta, Date refecmodif,
			String reusualta, String reusumodif, Sancuesfondo sancuesfondo,
			Sancuesproced sancuesproced) {

		this.recodigo = recodigo;
		this.sancuesfondo = sancuesfondo;
		this.sancuesproced = sancuesproced;
		this.rercafecenv = rercafecenv;
		this.rercanumsen = rercanumsen;
		this.sanresulsen = sanresulsen;
		this.tribunal = tribunal;
		this.rercasala = rercasala;
		this.rercaacue = rercaacue;
		this.rercafecdev = rercafecdev;
		this.rercaimpdev = rercaimpdev;
		this.rercaabo = rercaabo;
		this.rercanota = rercanota;
		this.refecalta = refecalta;
		this.refecmodif = refecmodif;
		this.reusualta = reusualta;
		this.reusumodif = reusumodif;
	}

	/**
	 * Method 'getRecodigo'.
	 * 
	 * @return String
	 */

	public String getRecodigo() {
		return this.recodigo;
	}

	/**
	 * Method 'setRecodigo'.
	 * 
	 * @param recodigo
	 *            String
	 * @return
	 */

	public void setRecodigo(String recodigo) {
		this.recodigo = recodigo;
	}

	/**
	 * Method 'getSancuesfondo'.
	 * 
	 * @return Sancuesfondo
	 */
	@JsonIgnore
	public Sancuesfondo getSancuesfondo() {
		return this.sancuesfondo;
	}

	/**
	 * Method 'setSancuesfondo'.
	 * 
	 * @param sancuesfondo
	 *            Sancuesfondo
	 * @return
	 */

	public void setSancuesfondo(Sancuesfondo sancuesfondo) {
		this.sancuesfondo = sancuesfondo;
	}

	/**
	 * Method 'getSancuesproced'.
	 * 
	 * @return Sancuesproced
	 */
	public Sancuesproced getSancuesproced() {
		return this.sancuesproced;
	}

	/**
	 * Method 'setSancuesproced'.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return
	 */

	public void setSancuesproced(Sancuesproced sancuesproced) {
		this.sancuesproced = sancuesproced;
	}

	/**
	 * Method 'getRercafecenv'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getRercafecenv() {
		return this.rercafecenv;
	}

	/**
	 * Method 'setRercafecenv'.
	 * 
	 * @param rercafecenv
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRercafecenv(Date rercafecenv) {
		this.rercafecenv = rercafecenv;
	}

	/**
	 * Method 'getRercasen'.
	 * 
	 * @return Sanresulsen
	 */

	public Sanresulsen getSanresulsen() {
		return this.sanresulsen;
	}

	/**
	 * Method 'setRercasen'.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return
	 */

	public void setSanresulsen(Sanresulsen sanresulsen) {
		this.sanresulsen = sanresulsen;
	}

	/**
	 * Method 'getTribunal'.
	 * 
	 * @return Tribunal
	 */

	public Tribunal getTribunal() {
		return this.tribunal;
	}

	/**
	 * Method 'setTribunal'.
	 * 
	 * @param tribunal
	 *            Tribunal
	 * @return
	 */

	public void setTribunal(Tribunal tribunal) {
		this.tribunal = tribunal;
	}

	/**
	 * Method 'getRercasala'.
	 * 
	 * @return String
	 */

	public String getRercasala() {
		return this.rercasala;
	}

	/**
	 * Method 'setRercasala'.
	 * 
	 * @param rercasala
	 *            String
	 * @return
	 */

	public void setRercasala(String rercasala) {
		this.rercasala = rercasala;
	}

	/**
	 * Method 'getRercaacue'.
	 * 
	 * @return String
	 */

	public String getRercaacue() {
		return this.rercaacue;
	}

	/**
	 * Method 'setRercaacue'.
	 * 
	 * @param rercaacue
	 *            String
	 * @return
	 */

	public void setRercaacue(String rercaacue) {
		this.rercaacue = rercaacue;
	}

	/**
	 * Method 'getRercafecdev'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getRercafecdev() {
		return this.rercafecdev;
	}

	/**
	 * Method 'setRercafecdev'.
	 * 
	 * @param rercafecdev
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRercafecdev(Date rercafecdev) {
		this.rercafecdev = rercafecdev;
	}

	/**
	 * Method 'getRercaimpdev'.
	 * 
	 * @return String
	 */

	public String getRercaimpdev() {
		return this.rercaimpdev;
	}

	/**
	 * Method 'setRercaimpdev'.
	 * 
	 * @param rercaimpdev
	 *            String
	 * @return
	 */

	public void setRercaimpdev(String rercaimpdev) {
		this.rercaimpdev = rercaimpdev;
	}

	/**
	 * Method 'getRercaabo'.
	 * 
	 * @return String
	 */

	public String getRercaabo() {
		return this.rercaabo;
	}

	/**
	 * Method 'setRercaabo'.
	 * 
	 * @param rercaabo
	 *            String
	 * @return
	 */

	public void setRercaabo(String rercaabo) {
		this.rercaabo = rercaabo;
	}

	/**
	 * Method 'getRercanota'.
	 * 
	 * @return String
	 */

	public String getRercanota() {
		return this.rercanota;
	}

	/**
	 * Method 'setRercanota'.
	 * 
	 * @param rercanota
	 *            String
	 * @return
	 */

	public void setRercanota(String rercanota) {
		this.rercanota = rercanota;
	}

	/**
	 * Method 'getRefecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getRefecalta() {
		return this.refecalta;
	}

	/**
	 * Method 'setRefecalta'.
	 * 
	 * @param refecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRefecalta(Date refecalta) {
		this.refecalta = refecalta;
	}

	/**
	 * Method 'getRefecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getRefecmodif() {
		return this.refecmodif;
	}

	/**
	 * Method 'setRefecmodif'.
	 * 
	 * @param refecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRefecmodif(Date refecmodif) {
		this.refecmodif = refecmodif;
	}

	/**
	 * Method 'getReusualta'.
	 * 
	 * @return String
	 */

	public String getReusualta() {
		return this.reusualta;
	}

	/**
	 * Method 'setReusualta'.
	 * 
	 * @param reusualta
	 *            String
	 * @return
	 */

	public void setReusualta(String reusualta) {
		this.reusualta = reusualta;
	}

	/**
	 * Method 'getReusumodif'.
	 * 
	 * @return String
	 */

	public String getReusumodif() {
		return this.reusumodif;
	}

	/**
	 * Method 'setReusumodif'.
	 * 
	 * @param reusumodif
	 *            String
	 * @return
	 */

	public void setReusumodif(String reusumodif) {
		this.reusumodif = reusumodif;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ recodigo: ").append(this.recodigo).append(" ]");
		result.append(", [ rercafecenv: ").append(this.rercafecenv)
				.append(" ]");
		result.append(", [ sanresulsen: ").append(this.sanresulsen)
				.append(" ]");
		result.append(", [ tribunal: ").append(this.tribunal).append(" ]");
		result.append(", [ rercasala: ").append(this.rercasala).append(" ]");
		result.append(", [ rercaacue: ").append(this.rercaacue).append(" ]");
		result.append(", [ rercafecdev: ").append(this.rercafecdev)
				.append(" ]");
		result.append(", [ rercaimpdev: ").append(this.rercaimpdev)
				.append(" ]");
		result.append(", [ rercaabo: ").append(this.rercaabo).append(" ]");
		result.append(", [ rercanota: ").append(this.rercanota).append(" ]");
		result.append(", [ refecalta: ").append(this.refecalta).append(" ]");
		result.append(", [ refecmodif: ").append(this.refecmodif).append(" ]");
		result.append(", [ reusualta: ").append(this.reusualta).append(" ]");
		result.append(", [ reusumodif: ").append(this.reusumodif).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the refereor
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getRefereor() {
		return refereor;
	}

	/**
	 * @param refereor
	 *            the refereor to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRefereor(Date refereor) {
		this.refereor = refereor;
	}

	/**
	 * @return the refenrro
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getRefenrro() {
		return refenrro;
	}

	/**
	 * @param refenrro
	 *            the refenrro to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRefenrro(Date refenrro) {
		this.refenrro = refenrro;
	}

	/**
	 * @return the refeserc
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getRefeserc() {
		return refeserc;
	}

	/**
	 * @param refeserc
	 *            the refeserc to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRefeserc(Date refeserc) {
		this.refeserc = refeserc;
	}

	/**
	 * @return the recamurc
	 */
	public String getRecamurc() {
		return recamurc;
	}

	/**
	 * @param recamurc
	 *            the recamurc to set
	 */
	public void setRecamurc(String recamurc) {
		this.recamurc = recamurc;
	}

	/**
	 * @return the rercanumsen
	 */
	public String getRercanumsen() {
		return rercanumsen;
	}

	/**
	 * @param rercanumsen
	 *            the rercanumsen to set
	 */
	public void setRercanumsen(String rercanumsen) {
		this.rercanumsen = rercanumsen;
	}

	/**
	 * @return the excodigo
	 */
	public String getExcodigo() {
		return excodigo;
	}

	/**
	 * @param excodigo
	 *            the excodigo to set
	 */
	public void setExcodigo(String excodigo) {
		this.excodigo = excodigo;
	}

	/**
	 * @return the refeinrc
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getRefeinrc() {
		return refeinrc;
	}

	/**
	 * @param refeinrc
	 *            the refeinrc to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRefeinrc(Date refeinrc) {
		this.refeinrc = refeinrc;
	}
}