package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.Y41bUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Saninterv  
 * 
 *  
 */

public class Saninterv implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private BigDecimal uaidinterv;
	private Expedien expedien;
	private String uanombre;
	private String uaapellido1;
	private String uaapellido2;
	private String uacoem;
	private String uanif;
	private String uanrtel;
	private String uanrtel2;
	private String uapaisId;
	private String uaprovId;
	private String uamunId;
	private String ualocId;
	private String uacalleId;
	private String uacpId;
	private String uaportalId;
	private String uanombrePiso;
	private String uadireNocapv;
	private String uadireAnt;
	private String uatipointerv;
	private String uadtcodigo;
	private String uaescodigo;
	private Date uatrfecalta;
	private Date uatrfecmodif;
	private String uatrusualta;
	private String uatrusumodif;
	private Date uafecalta;
	private Date uafecmodif;
	private String uausualta;
	private String uausumodif;
	private List<Sanprue> sanprues = new ArrayList<Sanprue>();
	private List<Sanenvio> sanenvios = new ArrayList<Sanenvio>();
	private String nombreMunicipio;
	private String nombreSector;
	private String direccionCompleta;

	private String uanodir;
	private String uaestado;
	private String uaextranjero;

	private String nombrePais;
	private String nombreProvincia;
	private String nombreLocalidad;
	private String cp;

	private String uaentidad_id;

	private String nombreCompleto;

	private String uanopeco;
	private String uanoco;
	private String uaurl;
	private String uasecodigo;
	private String uasenombre;
	private String uasenombree;

	private String sentenciaFirme;

	private String uafecultmod;
	private String uausuultmod;
	private String usuarioxlnet; // Usuario xlnets correspondiente al
									// uausuultmod

	private String uaformanotificacion;

	private String uaidioma;
	private String uasexo;
	private String uaedad;
	private String uatipoidentificacion;

	private String establecimientoCerrado;
	private String codTipointerv;

	/**
	 * @return the uanodir
	 */
	public String getUanodir() {
		return this.uanodir;
	}

	/**
	 * @param uanodir
	 *            the uanodir to set
	 */
	public void setUanodir(String uanodir) {
		this.uanodir = uanodir;
	}

	/**
	 * Method 'Saninterv'.
	 */
	public Saninterv() {
	}

	/**
	 * Method 'Saninterv'.
	 * 
	 * @param uaidinterv
	 *            the uaidinterv
	 */
	public Saninterv(BigDecimal uaidinterv) {
		this.uaidinterv = uaidinterv;
	}

	/**
	 * Method 'Saninterv'.
	 * 
	 * @param uaidinterv
	 *            the uaidinterv
	 * @param uanombre
	 *            the uanombre
	 * @param uaapellido1
	 *            the uaapellido1
	 * @param uaapellido2
	 *            the uaapellido2
	 */
	public Saninterv(BigDecimal uaidinterv, String uanombre, String uaapellido1, String uaapellido2) {
		this.uaidinterv = uaidinterv;
		this.uanombre = uanombre;
		this.uaapellido1 = uaapellido1;
		this.uaapellido2 = uaapellido2;
	}

	/**
	 * Method 'Saninterv'.
	 * 
	 * @param uaidinterv
	 *            BigDecimal
	 * @param uanombre
	 *            String
	 * @param uaapellido1
	 *            String
	 * @param uaapellido2
	 *            String
	 * @param uanif
	 *            String
	 * @param uanrtel
	 *            String
	 * @param uanrtel2
	 *            String
	 * @param uaprovId
	 *            String
	 * @param uamunId
	 *            String
	 * @param ualocId
	 *            String
	 * @param uacalleId
	 *            String
	 * @param uacpId
	 *            String
	 * @param uaportalId
	 *            String
	 * @param uanombrePiso
	 *            String
	 * @param uadireNocapv
	 *            String
	 * @param uadireAnt
	 *            String
	 * @param uatipointerv
	 *            String
	 * @param uadtcodigo
	 *            String
	 * @param uaescodigo
	 *            String
	 * @param uatrfecalta
	 *            Date
	 * @param uatrfecmodif
	 *            Date
	 * @param uatrusualta
	 *            String
	 * @param uatrusumodif
	 *            String
	 * @param uafecalta
	 *            Date
	 * @param uafecmodif
	 *            Date
	 * @param uausualta
	 *            String
	 * @param uausumodif
	 *            String
	 * @param expedien
	 *            Expedien
	 * @param uanodir
	 *            the uanodir
	 * @param uacoem
	 *            the uacoem
	 * @param sanprues
	 *            the sanprues
	 * @param sanenvios
	 *            the sanenvios
	 * @param uaentidad_id
	 *            the uaentidad_id
	 */
	public Saninterv(BigDecimal uaidinterv, String uanombre, String uaapellido1, String uaapellido2, String uanif,
			String uanrtel, String uanrtel2, String uaprovId, String uamunId, String ualocId, String uacalleId,
			String uacpId, String uaportalId, String uanombrePiso, String uadireNocapv, String uadireAnt,
			String uatipointerv, String uadtcodigo, String uaescodigo, Date uatrfecalta, Date uatrfecmodif,
			String uatrusualta, String uatrusumodif, Date uafecalta, Date uafecmodif, String uausualta,
			String uausumodif, Expedien expedien, String uanodir, String uacoem, List<Sanprue> sanprues,
			List<Sanenvio> sanenvios, String uaentidad_id) {
		this.uaidinterv = uaidinterv;
		this.expedien = expedien;
		this.uanombre = uanombre;
		this.uaapellido1 = uaapellido1;
		this.uaapellido2 = uaapellido2;
		this.uanif = uanif;
		this.uanrtel = uanrtel;
		this.uanrtel2 = uanrtel2;
		this.uaprovId = uaprovId;
		this.uamunId = uamunId;
		this.ualocId = ualocId;
		this.uacalleId = uacalleId;
		this.uacpId = uacpId;
		this.uaportalId = uaportalId;
		this.uanombrePiso = uanombrePiso;
		this.uadireNocapv = uadireNocapv;
		this.uadireAnt = uadireAnt;
		this.uatipointerv = uatipointerv;
		this.uadtcodigo = uadtcodigo;
		this.uaescodigo = uaescodigo;
		this.uatrfecalta = uatrfecalta;
		this.uatrfecmodif = uatrfecmodif;
		this.uatrusualta = uatrusualta;
		this.uatrusumodif = uatrusumodif;
		this.uafecalta = uafecalta;
		this.uafecmodif = uafecmodif;
		this.uausualta = uausualta;
		this.uausumodif = uausumodif;
		this.uanodir = uanodir;
		this.uacoem = uacoem;
		this.uaentidad_id = uaentidad_id;
	}

	// /**
	// * Method 'Saninterv'.
	// *
	// * @param uaidinterv
	// * BigDecimal
	// * @param uanombre
	// * String
	// * @param uanif
	// * String
	// * @param uanrtel
	// * String
	// * @param uanrtel2
	// * String
	// * @param uaprovId
	// * String
	// * @param uamunId
	// * String
	// * @param ualocId
	// * String
	// * @param uacalleId
	// * String
	// * @param uacpId
	// * String
	// * @param uaportalId
	// * String
	// * @param uanombrePiso
	// * String
	// * @param uadireNocapv
	// * String
	// * @param uadireAnt
	// * String
	// * @param uatipointerv
	// * String
	// * @param uadtcodigo
	// * String
	// * @param uaescodigo
	// * String
	// * @param uatrfecalta
	// * Date
	// * @param uatrfecmodif
	// * Date
	// * @param uatrusualta
	// * String
	// * @param uatrusumodif
	// * String
	// * @param uafecalta
	// * Date
	// * @param uafecmodif
	// * Date
	// * @param uausualta
	// * String
	// * @param uausumodif
	// * String
	// * @param expedien
	// * Expedien
	// * @param sanprues
	// * List<Sanprue>
	// * @param sanenvios
	// * List<Sanenvio>
	// */
	// public Saninterv(BigDecimal uaidinterv, String uanombre, String uanif,
	// String uanrtel, String uanrtel2, String uaprovId, String uamunId,
	// String ualocId, String uacalleId, String uacpId, String uaportalId,
	// String uanombrePiso, String uadireNocapv, String uadireAnt,
	// String uatipointerv, String uadtcodigo, String uaescodigo,
	// Date uatrfecalta, Date uatrfecmodif, String uatrusualta,
	// String uatrusumodif, Date uafecalta, Date uafecmodif,
	// String uausualta, String uausumodif, Expedien expedien,
	// List<Sanprue> sanprues, List<Sanenvio> sanenvios) {
	//
	// this.uaidinterv = uaidinterv;
	// this.expedien = expedien;
	// this.uanombre = uanombre;
	// this.uanif = uanif;
	// this.uanrtel = uanrtel;
	// this.uanrtel2 = uanrtel2;
	// this.uaprovId = uaprovId;
	// this.uamunId = uamunId;
	// this.ualocId = ualocId;
	// this.uacalleId = uacalleId;
	// this.uacpId = uacpId;
	// this.uaportalId = uaportalId;
	// this.uanombrePiso = uanombrePiso;
	// this.uadireNocapv = uadireNocapv;
	// this.uadireAnt = uadireAnt;
	// this.uatipointerv = uatipointerv;
	// this.uadtcodigo = uadtcodigo;
	// this.uaescodigo = uaescodigo;
	// this.uatrfecalta = uatrfecalta;
	// this.uatrfecmodif = uatrfecmodif;
	// this.uatrusualta = uatrusualta;
	// this.uatrusumodif = uatrusumodif;
	// this.uafecalta = uafecalta;
	// this.uafecmodif = uafecmodif;
	// this.uausualta = uausualta;
	// this.uausumodif = uausumodif;
	// this.sanprues = sanprues;
	// this.sanenvios = sanenvios;
	// }

	/**
	 * Method 'Saninterv'.
	 * 
	 * @param uaidinterv
	 *            BigDecimal
	 * @param uanombre
	 *            String
	 * @param nombreMunicipio
	 *            String
	 */
	public Saninterv(BigDecimal uaidinterv, String uanombre, String nombreMunicipio) {

		this.uaidinterv = uaidinterv;

		this.uanombre = uanombre;
		this.nombreMunicipio = nombreMunicipio;
	}

	/**
	 * Method 'getUaidinterv'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getUaidinterv() {
		return this.uaidinterv;
	}

	/**
	 * Method 'setUaidinterv'.
	 * 
	 * @param uaidinterv
	 *            BigDecimal
	 * @return
	 */

	public void setUaidinterv(BigDecimal uaidinterv) {
		this.uaidinterv = uaidinterv;
	}

	/**
	 * Method 'getExpedien'.
	 * 
	 * @return Expedien
	 */
	@JsonIgnore()
	public Expedien getExpedien() {
		return this.expedien;
	}

	/**
	 * Method 'setExpedien'.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return
	 */

	public void setExpedien(Expedien expedien) {
		this.expedien = expedien;
	}

	/**
	 * Method 'getUanombre'.
	 * 
	 * @return String
	 */

	public String getUanombre() {
		return this.uanombre;
	}

	/**
	 * Method 'setUanombre'.
	 * 
	 * @param uanombre
	 *            String
	 * @return
	 */

	public void setUanombre(String uanombre) {
		this.uanombre = uanombre;
	}

	/**
	 * @return the uaapellido1
	 */
	public String getUaapellido1() {
		return this.uaapellido1;
	}

	/**
	 * @param uaapellido1
	 *            the uaapellido1 to set
	 */
	public void setUaapellido1(String uaapellido1) {
		this.uaapellido1 = uaapellido1;
	}

	/**
	 * @return the uaapellido2
	 */
	public String getUaapellido2() {
		return this.uaapellido2;
	}

	/**
	 * @param uaapellido2
	 *            the uaapellido2 to set
	 */
	public void setUaapellido2(String uaapellido2) {
		this.uaapellido2 = uaapellido2;
	}

	/**
	 * Method 'getUacoem'.
	 * 
	 * @return String
	 */

	public String getUacoem() {
		return this.uacoem;
	}

	/**
	 * Method 'setUacoem'.
	 * 
	 * @param uacoem
	 *            String
	 * @return
	 */

	public void setUacoem(String uacoem) {
		this.uacoem = uacoem;
	}

	/**
	 * Method 'getUanif'.
	 * 
	 * @return String
	 */

	public String getUanif() {
		return this.uanif;
	}

	/**
	 * Method 'setUanif'.
	 * 
	 * @param uanif
	 *            String
	 * @return
	 */

	public void setUanif(String uanif) {
		this.uanif = uanif;
	}

	/**
	 * Method 'getUanrtel'.
	 * 
	 * @return String
	 */

	public String getUanrtel() {
		return this.uanrtel;
	}

	/**
	 * Method 'setUanrtel'.
	 * 
	 * @param uanrtel
	 *            String
	 * @return
	 */

	public void setUanrtel(String uanrtel) {
		this.uanrtel = uanrtel;
	}

	/**
	 * Method 'getUanrtel2'.
	 * 
	 * @return String
	 */

	public String getUanrtel2() {
		return this.uanrtel2;
	}

	/**
	 * Method 'setUanrtel2'.
	 * 
	 * @param uanrtel2
	 *            String
	 * @return
	 */

	public void setUanrtel2(String uanrtel2) {
		this.uanrtel2 = uanrtel2;
	}

	/**
	 * Method 'getUaprovId'.
	 * 
	 * @return String
	 */

	public String getUaprovId() {
		return this.uaprovId;
	}

	/**
	 * Method 'setUaprovId'.
	 * 
	 * @param uaprovId
	 *            String
	 * @return
	 */

	public void setUaprovId(String uaprovId) {
		this.uaprovId = uaprovId;
	}

	/**
	 * Method 'getUamunId'.
	 * 
	 * @return String
	 */

	public String getUamunId() {
		return this.uamunId;
	}

	/**
	 * Method 'setUamunId'.
	 * 
	 * @param uamunId
	 *            String
	 * @return
	 */

	public void setUamunId(String uamunId) {
		this.uamunId = uamunId;
	}

	/**
	 * Method 'getUalocId'.
	 * 
	 * @return String
	 */

	public String getUalocId() {
		return this.ualocId;
	}

	/**
	 * Method 'setUalocId'.
	 * 
	 * @param ualocId
	 *            String
	 * @return
	 */

	public void setUalocId(String ualocId) {
		this.ualocId = ualocId;
	}

	/**
	 * @return the uapaisId
	 */
	public String getUapaisId() {
		return this.uapaisId;
	}

	/**
	 * @param uapaisId
	 *            the uapaisId to set
	 */
	public void setUapaisId(String uapaisId) {
		this.uapaisId = uapaisId;
	}

	/**
	 * Method 'getUacalleId'.
	 * 
	 * @return String
	 */

	public String getUacalleId() {
		return this.uacalleId;
	}

	/**
	 * Method 'setUacalleId'.
	 * 
	 * @param uacalleId
	 *            String
	 * @return
	 */

	public void setUacalleId(String uacalleId) {
		this.uacalleId = uacalleId;
	}

	/**
	 * Method 'getUacpId'.
	 * 
	 * @return String
	 */

	public String getUacpId() {
		return this.uacpId;
	}

	/**
	 * Method 'setUacpId'.
	 * 
	 * @param uacpId
	 *            String
	 * @return
	 */

	public void setUacpId(String uacpId) {
		this.uacpId = uacpId;
	}

	/**
	 * Method 'getUaportalId'.
	 * 
	 * @return String
	 */

	public String getUaportalId() {
		return this.uaportalId;
	}

	/**
	 * Method 'setUaportalId'.
	 * 
	 * @param uaportalId
	 *            String
	 * @return
	 */

	public void setUaportalId(String uaportalId) {
		this.uaportalId = uaportalId;
	}

	/**
	 * Method 'getUanombrePiso'.
	 * 
	 * @return String
	 */

	public String getUanombrePiso() {
		return this.uanombrePiso;
	}

	/**
	 * Method 'setUanombrePiso'.
	 * 
	 * @param uanombrePiso
	 *            String
	 * @return
	 */

	public void setUanombrePiso(String uanombrePiso) {
		this.uanombrePiso = uanombrePiso;
	}

	/**
	 * Method 'getUadireNocapv'.
	 * 
	 * @return String
	 */

	public String getUadireNocapv() {
		return this.uadireNocapv;
	}

	/**
	 * Method 'setUadireNocapv'.
	 * 
	 * @param uadireNocapv
	 *            String
	 * @return
	 */

	public void setUadireNocapv(String uadireNocapv) {
		this.uadireNocapv = uadireNocapv;
	}

	/**
	 * Method 'getUadireAnt'.
	 * 
	 * @return String
	 */

	public String getUadireAnt() {
		return this.uadireAnt;
	}

	/**
	 * Method 'setUadireAnt'.
	 * 
	 * @param uadireAnt
	 *            String
	 * @return
	 */

	public void setUadireAnt(String uadireAnt) {
		this.uadireAnt = uadireAnt;
	}

	/**
	 * Method 'getUatipointerv'.
	 * 
	 * @return String
	 */

	public String getUatipointerv() {
		return this.uatipointerv;
	}

	/**
	 * Method 'setUatipointerv'.
	 * 
	 * @param uatipointerv
	 *            String
	 * @return
	 */

	public void setUatipointerv(String uatipointerv) {
		this.uatipointerv = uatipointerv;
	}

	/**
	 * Method 'getUadtcodigo'.
	 * 
	 * @return String
	 */

	public String getUadtcodigo() {
		return this.uadtcodigo;
	}

	/**
	 * Method 'setUadtcodigo'.
	 * 
	 * @param uadtcodigo
	 *            String
	 * @return
	 */

	public void setUadtcodigo(String uadtcodigo) {
		this.uadtcodigo = uadtcodigo;
	}

	/**
	 * Method 'getUaescodigo'.
	 * 
	 * @return String
	 */

	public String getUaescodigo() {
		return this.uaescodigo;
	}

	/**
	 * Method 'setUaescodigo'.
	 * 
	 * @param uaescodigo
	 *            String
	 * @return
	 */

	public void setUaescodigo(String uaescodigo) {
		this.uaescodigo = uaescodigo;
	}

	/**
	 * Method 'getUatrfecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUatrfecalta() {
		return this.uatrfecalta;
	}

	/**
	 * Method 'setUatrfecalta'.
	 * 
	 * @param uatrfecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUatrfecalta(Date uatrfecalta) {
		this.uatrfecalta = uatrfecalta;
	}

	/**
	 * Method 'getUatrfecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUatrfecmodif() {
		return this.uatrfecmodif;
	}

	/**
	 * Method 'setUatrfecmodif'.
	 * 
	 * @param uatrfecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUatrfecmodif(Date uatrfecmodif) {
		this.uatrfecmodif = uatrfecmodif;
	}

	/**
	 * Method 'getUatrusualta'.
	 * 
	 * @return String
	 */

	public String getUatrusualta() {
		return this.uatrusualta;
	}

	/**
	 * Method 'setUatrusualta'.
	 * 
	 * @param uatrusualta
	 *            String
	 * @return
	 */

	public void setUatrusualta(String uatrusualta) {
		this.uatrusualta = uatrusualta;
	}

	/**
	 * Method 'getUatrusumodif'.
	 * 
	 * @return String
	 */

	public String getUatrusumodif() {
		return this.uatrusumodif;
	}

	/**
	 * Method 'setUatrusumodif'.
	 * 
	 * @param uatrusumodif
	 *            String
	 * @return
	 */

	public void setUatrusumodif(String uatrusumodif) {
		this.uatrusumodif = uatrusumodif;
	}

	/**
	 * Method 'getUafecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUafecalta() {
		return this.uafecalta;
	}

	/**
	 * Method 'setUafecalta'.
	 * 
	 * @param uafecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUafecalta(Date uafecalta) {
		this.uafecalta = uafecalta;
	}

	/**
	 * Method 'getUafecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUafecmodif() {
		return this.uafecmodif;
	}

	/**
	 * Method 'setUafecmodif'.
	 * 
	 * @param uafecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUafecmodif(Date uafecmodif) {
		this.uafecmodif = uafecmodif;
	}

	/**
	 * Method 'getUausualta'.
	 * 
	 * @return String
	 */

	public String getUausualta() {
		return this.uausualta;
	}

	/**
	 * Method 'setUausualta'.
	 * 
	 * @param uausualta
	 *            String
	 * @return
	 */

	public void setUausualta(String uausualta) {
		this.uausualta = uausualta;
	}

	/**
	 * Method 'getUausumodif'.
	 * 
	 * @return String
	 */

	public String getUausumodif() {
		return this.uausumodif;
	}

	/**
	 * Method 'setUausumodif'.
	 * 
	 * @param uausumodif
	 *            String
	 * @return
	 */

	public void setUausumodif(String uausumodif) {
		this.uausumodif = uausumodif;
	}

	/**
	 * Method 'getSanprues'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sanprue> getSanprues() {
		return this.sanprues;
	}

	/**
	 * Method 'setSanprues'.
	 * 
	 * @param sanprues
	 *            List
	 * @return
	 */
	public void setSanprues(List<Sanprue> sanprues) {
		this.sanprues = sanprues;
	}

	/**
	 * Method 'getSanenvios'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sanenvio> getSanenvios() {
		return this.sanenvios;
	}

	/**
	 * Method 'setSanenvios'.
	 * 
	 * @param sanenvios
	 *            List
	 * @return
	 */
	public void setSanenvios(List<Sanenvio> sanenvios) {
		this.sanenvios = sanenvios;
	}

	/**
	 * Method 'getUausumodif'.
	 * 
	 * @return String
	 */

	public String getNombreMunicipio() {
		return this.nombreMunicipio;
	}

	/**
	 * Method 'setUausumodif'.
	 * 
	 * @param nombreMunicipio
	 *            String
	 * @return
	 */

	public void setNombreMunicipio(String nombreMunicipio) {
		this.nombreMunicipio = nombreMunicipio;
	}

	/**
	 * 
	 * @param nombreSector
	 *            String
	 */
	public void setNombreSector(String nombreSector) {
		this.nombreSector = nombreSector;
	}

	/**
	 * 
	 * @return String
	 */
	public String getNombreSector() {
		return this.nombreSector;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ uaidinterv: ").append(this.uaidinterv).append(" ]");
		result.append(", [ uanombre: ").append(this.uanombre).append(" ]");
		result.append(", [ uaapellido1: ").append(this.uaapellido1).append(" ]");
		result.append(", [ uaapellido2: ").append(this.uaapellido2).append(" ]");
		result.append(", [ uanif: ").append(this.uanif).append(" ]");
		result.append(", [ uanrtel: ").append(this.uanrtel).append(" ]");
		result.append(", [ uanrtel2: ").append(this.uanrtel2).append(" ]");
		result.append(", [ uaprovId: ").append(this.uaprovId).append(" ]");
		result.append(", [ uamunId: ").append(this.uamunId).append(" ]");
		result.append(", [ ualocId: ").append(this.ualocId).append(" ]");
		result.append(", [ uapaisId: ").append(this.uapaisId).append(" ]");
		result.append(", [ uacalleId: ").append(this.uacalleId).append(" ]");
		result.append(", [ uacpId: ").append(this.uacpId).append(" ]");
		result.append(", [ uaportalId: ").append(this.uaportalId).append(" ]");
		result.append(", [ uanombrePiso: ").append(this.uanombrePiso).append(" ]");
		result.append(", [ uadireNocapv: ").append(this.uadireNocapv).append(" ]");
		result.append(", [ uadireAnt: ").append(this.uadireAnt).append(" ]");
		result.append(", [ uatipointerv: ").append(this.uatipointerv).append(" ]");
		result.append(", [ uadtcodigo: ").append(this.uadtcodigo).append(" ]");
		result.append(", [ uaescodigo: ").append(this.uaescodigo).append(" ]");
		result.append(", [ uatrfecalta: ").append(this.uatrfecalta).append(" ]");
		result.append(", [ uatrfecmodif: ").append(this.uatrfecmodif).append(" ]");
		result.append(", [ uatrusualta: ").append(this.uatrusualta).append(" ]");
		result.append(", [ uatrusumodif: ").append(this.uatrusumodif).append(" ]");
		result.append(", [ uafecalta: ").append(this.uafecalta).append(" ]");
		result.append(", [ uafecmodif: ").append(this.uafecmodif).append(" ]");
		result.append(", [ uausualta: ").append(this.uausualta).append(" ]");
		result.append(", [ uausumodif: ").append(this.uausumodif).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @return the string
	 */
	public String getDireccionCompleta() {
		return (this.direccionCompleta);

	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param direccionCompleta
	 *            the new direccion completa
	 */
	public void setDireccionCompleta(String direccionCompleta) {
		this.direccionCompleta = direccionCompleta;

	}

	public boolean getTieneDireccionCompleta() {
		// tiene direccion completa (como esta en el js)
		// 0193046: FAC. Direccin de notificacin completa

		boolean resultado = true;

		if (!Y41bConstantes.COD_PAIS_ESTADO.equals(this.getUapaisId())) {
			// si es extranjero
			if (!Y41bUtils.esNullOCadenaVacia(this.getUapaisId())
					&& !Y41bUtils.esNullOCadenaVacia(this.getUadireNocapv())) {
				resultado = true;
			} else {
				resultado = false;
			}
		} else {
			if (this.getUaprovId() != null && !("".equalsIgnoreCase(this.getUaprovId())) && this.getUamunId() != null
					&& !("".equalsIgnoreCase(this.getUamunId())) && this.getUacalleId() != null
					&& !("".equalsIgnoreCase(this.getUacalleId()))) {
				resultado = true;
				// si NO es de capv
			} else if (this.getUadireNocapv() != null && !("".equalsIgnoreCase(this.getUadireNocapv()))) {
				resultado = true;
			} else {
				resultado = false;
			}
		}

		return resultado;

	}

	/**
	 * @return the uaestado
	 */
	public String getUaestado() {
		return this.uaestado;
	}

	/**
	 * @param uaestado
	 *            the uaestado to set
	 */
	public void setUaestado(String uaestado) {
		this.uaestado = uaestado;
	}

	/**
	 * @return the uaextranjero
	 */
	public String getUaextranjero() {
		return this.uaextranjero;
	}

	/**
	 * @param uaextranjero
	 *            the uaextranjero to set
	 */
	public void setUaextranjero(String uaextranjero) {
		this.uaextranjero = uaextranjero;
	}

	/**
	 * @return the nombrePais
	 */
	public String getNombrePais() {
		return this.nombrePais;
	}

	/**
	 * @param nombrePais
	 *            the nombrePais to set
	 */
	public void setNombrePais(String nombrePais) {
		this.nombrePais = nombrePais;
	}

	/**
	 * @return the nombreProvincia
	 */
	public String getNombreProvincia() {
		return this.nombreProvincia;
	}

	/**
	 * @param nombreProvincia
	 *            the nombreProvincia to set
	 */
	public void setNombreProvincia(String nombreProvincia) {
		this.nombreProvincia = nombreProvincia;
	}

	/**
	 * @return the nombreLocalidad
	 */
	public String getNombreLocalidad() {
		return this.nombreLocalidad;
	}

	/**
	 * @param nombreLocalidad
	 *            the nombreLocalidad to set
	 */
	public void setNombreLocalidad(String nombreLocalidad) {
		this.nombreLocalidad = nombreLocalidad;
	}

	/**
	 * @return the cp
	 */
	public String getCp() {
		return this.cp;
	}

	/**
	 * @param cp
	 *            the cp to set
	 */
	public void setCp(String cp) {
		this.cp = cp;
	}

	/**
	 * @return the uaentidad_id
	 */
	public String getUaentidad_id() {
		return this.uaentidad_id;
	}

	/**
	 * @param uaentidad_id
	 *            the uaentidad_id to set
	 */
	public void setUaentidad_id(String uaentidad_id) {
		this.uaentidad_id = uaentidad_id;
	}

	/**
	 * @return the nombreCompleto
	 */
	public String getNombreCompleto() {
		return this.nombreCompleto;
	}

	/**
	 * @param nombreCompleto
	 *            the nombreCompleto to set
	 */
	public void setNombreCompleto(String nombreCompleto) {
		this.nombreCompleto = nombreCompleto;
	}

	/**
	 * @return the uanopeco
	 */
	public String getUanopeco() {
		return this.uanopeco;
	}

	/**
	 * @param uanopeco
	 *            the uanopeco to set
	 */
	public void setUanopeco(String uanopeco) {
		this.uanopeco = uanopeco;
	}

	/**
	 * @return the uanoco
	 */
	public String getUanoco() {
		return this.uanoco;
	}

	/**
	 * @param uanoco
	 *            the uanoco to set
	 */
	public void setUanoco(String uanoco) {
		this.uanoco = uanoco;
	}

	/**
	 * @return the uaurl
	 */
	public String getUaurl() {
		return this.uaurl;
	}

	/**
	 * @param uaurl
	 *            the uaurl to set
	 */
	public void setUaurl(String uaurl) {
		this.uaurl = uaurl;
	}

	/**
	 * @return the uasecodigo
	 */
	public String getUasecodigo() {
		return this.uasecodigo;
	}

	/**
	 * @param uasecodigo
	 *            the uasecodigo to set
	 */
	public void setUasecodigo(String uasecodigo) {
		this.uasecodigo = uasecodigo;
	}

	/**
	 * @return the uasenombre
	 */
	public String getUasenombre() {
		return this.uasenombre;
	}

	/**
	 * @param uasenombre
	 *            the uasenombre to set
	 */
	public void setUasenombre(String uasenombre) {
		this.uasenombre = uasenombre;
	}

	/**
	 * @return the uasenombree
	 */
	public String getUasenombree() {
		return this.uasenombree;
	}

	/**
	 * @param uasenombree
	 *            the uasenombree to set
	 */
	public void setUasenombree(String uasenombree) {
		this.uasenombree = uasenombree;
	}

	/**
	 * @return the sentenciaFirme
	 */
	public String getSentenciaFirme() {
		return this.sentenciaFirme;
	}

	/**
	 * @param sentenciaFirme
	 *            the sentenciaFirme to set
	 */
	public void setSentenciaFirme(String sentenciaFirme) {
		this.sentenciaFirme = sentenciaFirme;
	}

	/**
	 * @return the uafecultmod
	 */
	public String getUafecultmod() {
		return this.uafecultmod;
	}

	/**
	 * @param uafecultmod
	 *            the uafecultmod to set
	 */
	public void setUafecultmod(String uafecultmod) {
		this.uafecultmod = uafecultmod;
	}

	/**
	 * @return the uausuultmod
	 */
	public String getUausuultmod() {
		return this.uausuultmod;
	}

	/**
	 * @param uausuultmod
	 *            the uausuultmod to set
	 */
	public void setUausuultmod(String uausuultmod) {
		this.uausuultmod = uausuultmod;
	}

	/**
	 * @return the usuarioxlnet
	 */
	public String getUsuarioxlnet() {
		return this.usuarioxlnet;
	}

	/**
	 * @param usuarioxlnet
	 *            the usuarioxlnet to set
	 */
	public void setUsuarioxlnet(String usuarioxlnet) {
		this.usuarioxlnet = usuarioxlnet;
	}

	/**
	 * @return the uaformanotificacion
	 */
	public String getUaformanotificacion() {
		return this.uaformanotificacion;
	}

	/**
	 * @param uaformanotificacion
	 *            the uaformanotificacion to set
	 */
	public void setUaformanotificacion(String uaformanotificacion) {
		this.uaformanotificacion = uaformanotificacion;
	}

	/**
	 * @return the uaidioma
	 */
	public String getUaidioma() {
		return this.uaidioma;
	}

	/**
	 * @param uaidioma
	 *            the uaidioma to set
	 */
	public void setUaidioma(String uaidioma) {
		this.uaidioma = uaidioma;
	}

	/**
	 * @return the uasexo
	 */
	public String getUasexo() {
		return this.uasexo;
	}

	/**
	 * @param uasexo
	 *            the uasexo to set
	 */
	public void setUasexo(String uasexo) {
		this.uasexo = uasexo;
	}

	/**
	 * @return the uatipoidentificacion
	 */
	public String getUatipoidentificacion() {
		return this.uatipoidentificacion;
	}

	/**
	 * @param uatipoidentificacion
	 *            the uatipoidentificacion to set
	 */
	public void setUatipoidentificacion(String uatipoidentificacion) {
		this.uatipoidentificacion = uatipoidentificacion;
	}

	/**
	 * @return the uaedad
	 */
	public String getUaedad() {
		return this.uaedad;
	}

	/**
	 * @param uaedad
	 *            the uaedad to set
	 */
	public void setUaedad(String uaedad) {
		this.uaedad = uaedad;
	}

	public void setEstablecimientoCerrado(String establecimientoCerrado) {
		this.establecimientoCerrado = establecimientoCerrado;
	}

	public String getEstablecimientoCerrado() {
		return establecimientoCerrado;
	}

	public String getCodTipointerv() {
		return codTipointerv;
	}

	public void setCodTipointerv(String codTipointerv) {
		this.codTipointerv = codTipointerv;
	}

}
