package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.math.BigDecimal;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Sanenvio  
 * 
 *  
 */

public class Sanenvio implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private BigDecimal enid;
	private Santramexp santramexpByEntrid;
	private Saninterv saninterv;
	private Expedien expedien;
	private Santramexp santramexpByEntridacuse;
	private Date enfecenvio;
	private Date fecharegistro;
	private Date enfecacuse;
	private String enestado;
	private Date enfecalta;
	private Date enfecmodif;
	private String enusualta;
	private String enusumodif;
	private String entipoenvio;

	// Documento
	private String indVariosDocumentos; // S o N
	private String u5codocumento;
	private String u5tedesfile;

	private String trenvrem;
	private String trcodrem;
	private String rmestado;
	private String tracusereintentado;

	/**
	 * Method 'Sanenvio'.
	 */
	public Sanenvio() {
	}

	/**
	 * Method 'Sanenvio'.
	 * 
	 * @param enid
	 *            BigDecimal
	 * @param enfecenvio
	 *            Date
	 * @param enfecacuse
	 *            Date
	 * @param enestado
	 *            String
	 * @param enfecalta
	 *            Date
	 * @param enfecmodif
	 *            Date
	 * @param enusualta
	 *            String
	 * @param enusumodif
	 *            String
	 * @param santramexpByEntrid
	 *            Santramexp
	 * @param saninterv
	 *            Saninterv
	 * @param expedien
	 *            Expedien
	 * @param santramexpByEntridacuse
	 *            Santramexp
	 * @param entipoenvio
	 *            String
	 */
	public Sanenvio(BigDecimal enid, Date enfecenvio, Date enfecacuse,
			String enestado, Date enfecalta, Date enfecmodif, String enusualta,
			String enusumodif, Santramexp santramexpByEntrid,
			Saninterv saninterv, Expedien expedien,
			Santramexp santramexpByEntridacuse, String entipoenvio) {

		this.enid = enid;
		this.santramexpByEntrid = santramexpByEntrid;
		this.saninterv = saninterv;
		this.expedien = expedien;
		this.santramexpByEntridacuse = santramexpByEntridacuse;
		this.enfecenvio = enfecenvio;
		this.enfecacuse = enfecacuse;
		this.enestado = enestado;
		this.enfecalta = enfecalta;
		this.enfecmodif = enfecmodif;
		this.enusualta = enusualta;
		this.enusumodif = enusumodif;
		this.entipoenvio = entipoenvio;
	}

	/**
	 * Method 'getEnid'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getEnid() {
		return this.enid;
	}

	/**
	 * Method 'setEnid'.
	 * 
	 * @param enid
	 *            BigDecimal
	 * @return
	 */

	public void setEnid(BigDecimal enid) {
		this.enid = enid;
	}

	/**
	 * Method 'getSantramexpByEntrid'.
	 * 
	 * @return Santramexp
	 */

	public Santramexp getSantramexpByEntrid() {
		return this.santramexpByEntrid;
	}

	/**
	 * Method 'setSantramexpByEntrid'.
	 * 
	 * @param santramexpByEntrid
	 *            Santramexp
	 * @return
	 */

	public void setSantramexpByEntrid(Santramexp santramexpByEntrid) {
		this.santramexpByEntrid = santramexpByEntrid;
	}

	/**
	 * Method 'getSaninterv'.
	 * 
	 * @return Saninterv
	 */

	public Saninterv getSaninterv() {
		return this.saninterv;
	}

	/**
	 * Method 'setSaninterv'.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return
	 */

	public void setSaninterv(Saninterv saninterv) {
		this.saninterv = saninterv;
	}

	/**
	 * Method 'getExpedien'.
	 * 
	 * @return Expedien
	 */
	@JsonIgnore()
	public Expedien getExpedien() {
		return this.expedien;
	}

	/**
	 * Method 'setExpedien'.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return
	 */

	public void setExpedien(Expedien expedien) {
		this.expedien = expedien;
	}

	/**
	 * Method 'getSantramexpByEntridacuse'.
	 * 
	 * @return Santramexp
	 */
	@JsonIgnore()
	public Santramexp getSantramexpByEntridacuse() {
		return this.santramexpByEntridacuse;
	}

	/**
	 * Method 'setSantramexpByEntridacuse'.
	 * 
	 * @param santramexpByEntridacuse
	 *            Santramexp
	 * @return
	 */

	public void setSantramexpByEntridacuse(Santramexp santramexpByEntridacuse) {
		this.santramexpByEntridacuse = santramexpByEntridacuse;
	}

	/**
	 * Method 'getEnfecenvio'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getEnfecenvio() {
		return this.enfecenvio;
	}

	/**
	 * Method 'setEnfecenvio'.
	 * 
	 * @param enfecenvio
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setEnfecenvio(Date enfecenvio) {
		this.enfecenvio = enfecenvio;
	}

	/**
	 * Method 'getEnfecacuse'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getEnfecacuse() {
		return this.enfecacuse;
	}

	/**
	 * Method 'setEnfecacuse'.
	 * 
	 * @param enfecacuse
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setEnfecacuse(Date enfecacuse) {
		this.enfecacuse = enfecacuse;
	}

	/**
	 * Method 'getEnestado'.
	 * 
	 * @return String
	 */

	public String getEnestado() {
		return this.enestado;
	}

	/**
	 * Method 'setEnestado'.
	 * 
	 * @param enestado
	 *            String
	 * @return
	 */

	public void setEnestado(String enestado) {
		this.enestado = enestado;
	}

	/**
	 * Method 'getEnfecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getEnfecalta() {
		return this.enfecalta;
	}

	/**
	 * Method 'setEnfecalta'.
	 * 
	 * @param enfecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setEnfecalta(Date enfecalta) {
		this.enfecalta = enfecalta;
	}

	/**
	 * Method 'getEnfecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getEnfecmodif() {
		return this.enfecmodif;
	}

	/**
	 * Method 'setEnfecmodif'.
	 * 
	 * @param enfecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setEnfecmodif(Date enfecmodif) {
		this.enfecmodif = enfecmodif;
	}

	/**
	 * Method 'getEnusualta'.
	 * 
	 * @return String
	 */

	public String getEnusualta() {
		return this.enusualta;
	}

	/**
	 * Method 'setEnusualta'.
	 * 
	 * @param enusualta
	 *            String
	 * @return
	 */

	public void setEnusualta(String enusualta) {
		this.enusualta = enusualta;
	}

	/**
	 * Method 'getEnusumodif'.
	 * 
	 * @return String
	 */

	public String getEnusumodif() {
		return this.enusumodif;
	}

	/**
	 * Method 'setEnusumodif'.
	 * 
	 * @param enusumodif
	 *            String
	 * @return
	 */

	public void setEnusumodif(String enusumodif) {
		this.enusumodif = enusumodif;
	}

	/**
	 * @return the entipoenvio
	 */
	public String getEntipoenvio() {
		return this.entipoenvio;
	}

	/**
	 * @param entipoenvio
	 *            the entipoenvio to set
	 */
	public void setEntipoenvio(String entipoenvio) {
		this.entipoenvio = entipoenvio;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ enid: ").append(this.enid).append(" ]");
		result.append(", [ enfecenvio: ").append(this.enfecenvio).append(" ]");
		result.append(", [ enfecacuse: ").append(this.enfecacuse).append(" ]");
		result.append(", [ enestado: ").append(this.enestado).append(" ]");
		result.append(", [ enfecalta: ").append(this.enfecalta).append(" ]");
		result.append(", [ enfecmodif: ").append(this.enfecmodif).append(" ]");
		result.append(", [ enusualta: ").append(this.enusualta).append(" ]");
		result.append(", [ enusumodif: ").append(this.enusumodif).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the fecharegistro
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecharegistro() {
		return this.fecharegistro;
	}

	/**
	 * @param fecharegistro
	 *            the fecharegistro to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecharegistro(Date fecharegistro) {
		this.fecharegistro = fecharegistro;
	}

	/**
	 * @return the indVariosDocumentos
	 */
	public String getIndVariosDocumentos() {
		return this.indVariosDocumentos;
	}

	/**
	 * @param indVariosDocumentos
	 *            the indVariosDocumentos to set
	 */
	public void setIndVariosDocumentos(String indVariosDocumentos) {
		this.indVariosDocumentos = indVariosDocumentos;
	}

	/**
	 * @return the u5codocumento
	 */
	public String getU5codocumento() {
		return this.u5codocumento;
	}

	/**
	 * @param u5codocumento
	 *            the u5codocumento to set
	 */
	public void setU5codocumento(String u5codocumento) {
		this.u5codocumento = u5codocumento;
	}

	/**
	 * @return the u5tedesfile
	 */
	public String getU5tedesfile() {
		return this.u5tedesfile;
	}

	/**
	 * @param u5tedesfile
	 *            the u5tedesfile to set
	 */
	public void setU5tedesfile(String u5tedesfile) {
		this.u5tedesfile = u5tedesfile;
	}

	/**
	 * @return this. the trenvrem
	 */
	public String getTrenvrem() {
		return this.trenvrem;
	}

	/**
	 * @param trenvrem
	 *            the trenvrem to set
	 */
	public void setTrenvrem(String trenvrem) {
		this.trenvrem = trenvrem;
	}

	/**
	 * @return the trcodrem
	 */
	public String getTrcodrem() {
		return this.trcodrem;
	}

	/**
	 * @param trcodrem
	 *            the trcodrem to set
	 */
	public void setTrcodrem(String trcodrem) {
		this.trcodrem = trcodrem;
	}

	/**
	 * @return the rmestado
	 */
	public String getRmestado() {
		return this.rmestado;
	}

	/**
	 * @param rmestado
	 *            the rmestado to set
	 */
	public void setRmestado(String rmestado) {
		this.rmestado = rmestado;
	}

	/**
	 * @param tracusereintentado
	 *            the tracusereintentado to set
	 */
	public void setTracusereintentado(String tracusereintentado) {
		this.tracusereintentado = tracusereintentado;
	}

	/**
	 * @return the tracusereintentado
	 */
	public String getTracusereintentado() {
		return tracusereintentado;
	}

}
