package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

import java.io.InputStream;
import java.sql.Blob;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Sandoctemp  
 * 
 *  
 */

public class Sandoctemp implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String u5codocumento;
	private Expedien expedien;
	private Santramexp santramexp;
	private String u5nofile;
	private Blob u5datafile;
	private InputStream u5datafileinputstream;
	private Integer u5sizefile;
	private String u5tedesfile;
	private String u5origen;
	private Date u5fecha;
	private String u5conttype;
	private String u5indmail;
	private String u5trmail;
	private String u5iddocumentum;
	private String u5tipodocumento;
	private Date u5fechaaportacion;
	private Date u5fechaentrada;
	private String u5numregistroentrada;
	private String u5idPerfilfirma;
	private String u5estadodocumento;
	private Date u5fechasolfirma;
	private Date u5fechafirma;
	private String u5comofirma;
	private Date u5fecalta;
	private Date u5fecmodif;
	private String u5usualta;
	private String u5usumodif;
	private String u5destino;
	private String u5ptcodigo;
	private Date u5fechasollocalizador;
	private Date u5fecharegistroorigen;
	private String u5idinterviniente;

	// Tipo de procedimiento
	private String u5pcodigo;

	/**
	 * Method 'Sandoctemp'.
	 */
	public Sandoctemp() {
	}

	/**
	 * Method 'Sandoctemp'.
	 * 
	 * @param u5codocumento
	 *            String
	 * @param u5nofile
	 *            String
	 * @param u5datafile
	 *            Blob
	 * @param u5sizefile
	 *            Integer
	 * @param u5tedesfile
	 *            String
	 * @param u5origen
	 *            String
	 * @param u5fecha
	 *            Date
	 * @param u5conttype
	 *            String
	 * @param u5indmail
	 *            String
	 * @param u5trmail
	 *            String
	 * @param u5iddocumentum
	 *            String
	 * @param u5tipodocumento
	 *            String
	 * @param u5fechaaportacion
	 *            Date
	 * @param u5fechaentrada
	 *            Date
	 * @param u5numregistroentrada
	 *            String
	 * @param u5idPerfilfirma
	 *            String
	 * @param u5estadodocumento
	 *            String
	 * @param u5fechasolfirma
	 *            Date
	 * @param u5fechafirma
	 *            Date
	 * @param u5comofirma
	 *            String
	 * @param u5fecalta
	 *            Date
	 * @param u5fecmodif
	 *            Date
	 * @param u5usualta
	 *            String
	 * @param u5usumodif
	 *            String
	 * @param expedien
	 *            Expedien
	 * @param santramexp
	 *            Santramexp
	 * @param u5destino
	 *            String
	 * @param u5ptcodigo
	 *            String
	 * @param u5fechasollocalizador
	 *            Date
	 * @param u5pcodigo
	 *            String
	 * @param u5idinterviniente
	 *            String
	 * 
	 */
	public Sandoctemp(String u5codocumento, String u5nofile, Blob u5datafile, Integer u5sizefile, String u5tedesfile,
			String u5origen, Date u5fecha, String u5conttype, String u5indmail, String u5trmail, String u5iddocumentum,
			String u5tipodocumento, Date u5fechaaportacion, Date u5fechaentrada, String u5numregistroentrada,
			String u5idPerfilfirma, String u5estadodocumento, Date u5fechasolfirma, Date u5fechafirma,
			String u5comofirma, Date u5fecalta, Date u5fecmodif, String u5usualta, String u5usumodif, Expedien expedien,
			Santramexp santramexp, String u5destino, String u5ptcodigo, Date u5fechasollocalizador, String u5pcodigo,
			String u5idinterviniente) {

		this.u5codocumento = u5codocumento;
		this.expedien = expedien;
		this.santramexp = santramexp;
		this.u5nofile = u5nofile;
		this.u5datafile = u5datafile;
		this.u5sizefile = u5sizefile;
		this.u5tedesfile = u5tedesfile;
		this.u5origen = u5origen;
		this.u5fecha = u5fecha;
		this.u5conttype = u5conttype;
		this.u5indmail = u5indmail;
		this.u5trmail = u5trmail;
		this.u5iddocumentum = u5iddocumentum;
		this.u5tipodocumento = u5tipodocumento;
		this.u5fechaaportacion = u5fechaaportacion;
		this.u5fechaentrada = u5fechaentrada;
		this.u5numregistroentrada = u5numregistroentrada;
		this.u5idPerfilfirma = u5idPerfilfirma;
		this.u5estadodocumento = u5estadodocumento;
		this.u5fechasolfirma = u5fechasolfirma;
		this.u5fechafirma = u5fechafirma;
		this.u5comofirma = u5comofirma;
		this.u5fecalta = u5fecalta;
		this.u5fecmodif = u5fecmodif;
		this.u5usualta = u5usualta;
		this.u5usumodif = u5usumodif;
		this.u5destino = u5destino;
		this.u5ptcodigo = u5ptcodigo;
		this.u5fechasollocalizador = u5fechasollocalizador;
		this.u5pcodigo = u5pcodigo;
		this.u5idinterviniente = u5idinterviniente;
	}

	/**
	 * @param codocumento
	 *            String
	 * @param iddocumentum
	 *            String
	 */
	public Sandoctemp(String codocumento, String iddocumentum) {
		super();
		this.u5codocumento = codocumento;
		this.u5iddocumentum = iddocumentum;
	}

	/**
	 * Method 'DocumentoHecho'.
	 * 
	 * @param q5codocumento
	 *            String
	 * @param q5hdcodigo
	 *            String
	 * @param q5nofile
	 *            String
	 * @param q5datafile
	 *            Blob
	 * @param q5sizefile
	 *            Integer
	 * @param q5tedesfile
	 *            String
	 * @param q5origen
	 *            String
	 * @param q5tramite
	 *            String
	 * @param q5fecha
	 *            Date
	 * @param q5indmail
	 *            String
	 * @param q5trmail
	 *            String
	 * @param q5contenttypefile
	 *            String
	 * @param q5iddocumentum
	 *            String
	 * @param q5fechaaportacion
	 *            Date
	 * @param q5fechaentrada
	 *            Date
	 * @param q5numregistroentrada
	 *            String
	 * @param q5idPerfilfirma
	 *            String
	 * @param q5estadodocumento
	 *            String
	 * @param q5fechasolfirma
	 *            Date
	 * @param q5fechalimfirma
	 *            Date
	 * @param q5fechafirma
	 *            Date
	 * @param q5comofirma
	 *            String
	 * @param q5idTipodoc
	 *            String
	 * @param q5destino
	 *            String
	 * @param u5ptcodigo
	 *            String
	 * @param u5fechasollocalizador
	 *            Date
	 * @param u5pcodigo
	 *            String
	 * @param u5idinterviniente
	 *            String
	 */
	public Sandoctemp(String q5codocumento, String q5hdcodigo, String q5nofile, Blob q5datafile, Integer q5sizefile,
			String q5tedesfile, String q5origen, String q5tramite, Date q5fecha, String q5indmail, String q5trmail,
			String q5contenttypefile, String q5iddocumentum, Date q5fechaaportacion, Date q5fechaentrada,
			String q5numregistroentrada, String q5idPerfilfirma, String q5estadodocumento, Date q5fechasolfirma,
			Date q5fechalimfirma, Date q5fechafirma, String q5comofirma, String q5idTipodoc, String q5destino,
			String u5ptcodigo, Date u5fechasollocalizador, String u5pcodigo, String u5idinterviniente) {

		this.u5codocumento = q5codocumento;
		this.expedien = new Expedien(q5hdcodigo);
		this.u5nofile = q5nofile;
		this.u5datafile = q5datafile;
		this.u5sizefile = q5sizefile;
		this.u5tedesfile = q5tedesfile;
		this.u5origen = q5origen;
		this.santramexp = new Santramexp(q5tramite);
		this.u5fecha = q5fecha;
		this.u5indmail = q5indmail;
		this.u5trmail = q5trmail;
		this.u5conttype = q5contenttypefile;
		this.u5iddocumentum = q5iddocumentum;
		this.u5fechaaportacion = q5fechaaportacion;
		this.u5fechaentrada = q5fechaentrada;
		this.u5numregistroentrada = q5numregistroentrada;
		this.u5idPerfilfirma = q5idPerfilfirma;
		this.u5estadodocumento = q5estadodocumento;
		this.u5fechasolfirma = q5fechasolfirma;
		this.u5fechafirma = q5fechalimfirma;
		this.u5fechafirma = q5fechafirma;
		this.u5comofirma = q5comofirma;
		this.u5tipodocumento = q5idTipodoc;
		this.u5destino = q5destino;
		this.u5ptcodigo = u5ptcodigo;
		this.u5fechasollocalizador = u5fechasollocalizador;
		this.u5pcodigo = u5pcodigo;
		this.u5idinterviniente = u5idinterviniente;
	}

	/**
	 * Method 'Sandoctemp'.
	 * 
	 * @param u5codocumento
	 *            String
	 * 
	 * @param u5datafile
	 *            Blob
	 */
	public Sandoctemp(String u5codocumento, Blob u5datafile) {
		this.u5codocumento = u5codocumento;
		this.u5datafile = u5datafile;
	}

	/**
	 * Method 'getU5codocumento'.
	 * 
	 * @return String
	 */

	public String getU5codocumento() {
		return this.u5codocumento;
	}

	/**
	 * Method 'setU5codocumento'.
	 * 
	 * @param u5codocumento
	 *            String
	 * @return
	 */

	public void setU5codocumento(String u5codocumento) {
		this.u5codocumento = u5codocumento;
	}

	/**
	 * Method 'getExpedien'.
	 * 
	 * @return Expedien
	 */
	@JsonIgnore()
	public Expedien getExpedien() {
		return this.expedien;
	}

	/**
	 * Method 'setExpedien'.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return
	 */

	public void setExpedien(Expedien expedien) {
		this.expedien = expedien;
	}

	/**
	 * Method 'getSantramexp'.
	 * 
	 * @return Santramexp
	 */
	@JsonIgnore()
	public Santramexp getSantramexp() {
		return this.santramexp;
	}

	/**
	 * Method 'setSantramexp'.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return
	 */

	public void setSantramexp(Santramexp santramexp) {
		this.santramexp = santramexp;
	}

	/**
	 * Method 'getU5nofile'.
	 * 
	 * @return String
	 */

	public String getU5nofile() {
		return this.u5nofile;
	}

	/**
	 * Method 'setU5nofile'.
	 * 
	 * @param u5nofile
	 *            String
	 * @return
	 */

	public void setU5nofile(String u5nofile) {
		this.u5nofile = u5nofile;
	}

	/**
	 * Method 'getU5datafile'.
	 * 
	 * @return Blob
	 */
	@JsonIgnore()
	public Blob getU5datafile() {
		return this.u5datafile;
	}

	/**
	 * Method 'setU5datafile'.
	 * 
	 * @param u5datafile
	 *            Blob
	 * @return
	 */

	public void setU5datafile(Blob u5datafile) {
		this.u5datafile = u5datafile;
	}

	/**
	 * Method 'getU5datafileinputstream'.
	 * 
	 * @return InputStream
	 */
	@JsonIgnore()
	public InputStream getU5datafileinputstream() {
		return this.u5datafileinputstream;
	}

	/**
	 * Method 'setU5datafileinputstream'.
	 * 
	 * @param u5datafileinputstream
	 *            InputStream
	 * @return
	 */

	public void setU5datafileinputstream(InputStream u5datafileinputstream) {
		this.u5datafileinputstream = u5datafileinputstream;
	}

	/**
	 * Method 'getU5sizefile'.
	 * 
	 * @return Integer
	 */

	public Integer getU5sizefile() {
		return this.u5sizefile;
	}

	/**
	 * Method 'setU5sizefile'.
	 * 
	 * @param u5sizefile
	 *            Integer
	 * @return
	 */

	public void setU5sizefile(Integer u5sizefile) {
		this.u5sizefile = u5sizefile;
	}

	/**
	 * Method 'getU5tedesfile'.
	 * 
	 * @return String
	 */

	public String getU5tedesfile() {
		return this.u5tedesfile;
	}

	/**
	 * Method 'setU5tedesfile'.
	 * 
	 * @param u5tedesfile
	 *            String
	 * @return
	 */

	public void setU5tedesfile(String u5tedesfile) {
		this.u5tedesfile = u5tedesfile;
	}

	/**
	 * Method 'getU5origen'.
	 * 
	 * @return String
	 */

	public String getU5origen() {
		return this.u5origen;
	}

	/**
	 * Method 'setU5origen'.
	 * 
	 * @param u5origen
	 *            String
	 * @return
	 */

	public void setU5origen(String u5origen) {
		this.u5origen = u5origen;
	}

	/**
	 * Method 'getU5fecha'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getU5fecha() {
		return this.u5fecha;
	}

	/**
	 * Method 'setU5fecha'.
	 * 
	 * @param u5fecha
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setU5fecha(Date u5fecha) {
		this.u5fecha = u5fecha;
	}

	/**
	 * Method 'getU5conttype'.
	 * 
	 * @return String
	 */

	public String getU5conttype() {
		return this.u5conttype;
	}

	/**
	 * Method 'setU5conttype'.
	 * 
	 * @param u5conttype
	 *            String
	 * @return
	 */

	public void setU5conttype(String u5conttype) {
		this.u5conttype = u5conttype;
	}

	/**
	 * Method 'getU5indmail'.
	 * 
	 * @return String
	 */

	public String getU5indmail() {
		return this.u5indmail;
	}

	/**
	 * Method 'setU5indmail'.
	 * 
	 * @param u5indmail
	 *            String
	 * @return
	 */

	public void setU5indmail(String u5indmail) {
		this.u5indmail = u5indmail;
	}

	/**
	 * Method 'getU5trmail'.
	 * 
	 * @return String
	 */

	public String getU5trmail() {
		return this.u5trmail;
	}

	/**
	 * Method 'setU5trmail'.
	 * 
	 * @param u5trmail
	 *            String
	 * @return
	 */

	public void setU5trmail(String u5trmail) {
		this.u5trmail = u5trmail;
	}

	/**
	 * Method 'getU5iddocumentum'.
	 * 
	 * @return String
	 */

	public String getU5iddocumentum() {
		return this.u5iddocumentum;
	}

	/**
	 * Method 'setU5iddocumentum'.
	 * 
	 * @param u5iddocumentum
	 *            String
	 * @return
	 */

	public void setU5iddocumentum(String u5iddocumentum) {
		this.u5iddocumentum = u5iddocumentum;
	}

	/**
	 * Method 'getU5tipodocumento'.
	 * 
	 * @return String
	 */

	public String getU5tipodocumento() {
		return this.u5tipodocumento;
	}

	/**
	 * Method 'setU5tipodocumento'.
	 * 
	 * @param u5tipodocumento
	 *            String
	 * @return
	 */

	public void setU5tipodocumento(String u5tipodocumento) {
		this.u5tipodocumento = u5tipodocumento;
	}

	/**
	 * Method 'getU5fechaaportacion'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getU5fechaaportacion() {
		return this.u5fechaaportacion;
	}

	/**
	 * Method 'setU5fechaaportacion'.
	 * 
	 * @param u5fechaaportacion
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setU5fechaaportacion(Date u5fechaaportacion) {
		this.u5fechaaportacion = u5fechaaportacion;
	}

	/**
	 * Method 'getU5fechaentrada'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getU5fechaentrada() {
		return this.u5fechaentrada;
	}

	/**
	 * Method 'setU5fechaentrada'.
	 * 
	 * @param u5fechaentrada
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setU5fechaentrada(Date u5fechaentrada) {
		this.u5fechaentrada = u5fechaentrada;
	}

	/**
	 * Method 'getU5numregistroentrada'.
	 * 
	 * @return String
	 */

	public String getU5numregistroentrada() {
		return this.u5numregistroentrada;
	}

	/**
	 * Method 'setU5numregistroentrada'.
	 * 
	 * @param u5numregistroentrada
	 *            String
	 * @return
	 */

	public void setU5numregistroentrada(String u5numregistroentrada) {
		this.u5numregistroentrada = u5numregistroentrada;
	}

	/**
	 * Method 'getU5idPerfilfirma'.
	 * 
	 * @return String
	 */

	public String getU5idPerfilfirma() {
		return this.u5idPerfilfirma;
	}

	/**
	 * Method 'setU5idPerfilfirma'.
	 * 
	 * @param u5idPerfilfirma
	 *            String
	 * @return
	 */

	public void setU5idPerfilfirma(String u5idPerfilfirma) {
		this.u5idPerfilfirma = u5idPerfilfirma;
	}

	/**
	 * Method 'getU5estadodocumento'.
	 * 
	 * @return String
	 */

	public String getU5estadodocumento() {
		return this.u5estadodocumento;
	}

	/**
	 * Method 'setU5estadodocumento'.
	 * 
	 * @param u5estadodocumento
	 *            String
	 * @return
	 */

	public void setU5estadodocumento(String u5estadodocumento) {
		this.u5estadodocumento = u5estadodocumento;
	}

	/**
	 * Method 'getU5fechasolfirma'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getU5fechasolfirma() {
		return this.u5fechasolfirma;
	}

	/**
	 * Method 'setU5fechasolfirma'.
	 * 
	 * @param u5fechasolfirma
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setU5fechasolfirma(Date u5fechasolfirma) {
		this.u5fechasolfirma = u5fechasolfirma;
	}

	/**
	 * Method 'getU5fechafirma'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getU5fechafirma() {
		return this.u5fechafirma;
	}

	/**
	 * Method 'setU5fechafirma'.
	 * 
	 * @param u5fechafirma
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setU5fechafirma(Date u5fechafirma) {
		this.u5fechafirma = u5fechafirma;
	}

	/**
	 * Method 'getU5comofirma'.
	 * 
	 * @return String
	 */

	public String getU5comofirma() {
		return this.u5comofirma;
	}

	/**
	 * Method 'setU5comofirma'.
	 * 
	 * @param u5comofirma
	 *            String
	 * @return
	 */

	public void setU5comofirma(String u5comofirma) {
		this.u5comofirma = u5comofirma;
	}

	/**
	 * 
	 * @param u5destino
	 *            String
	 */
	public void setU5destino(String u5destino) {
		this.u5destino = u5destino;
	}

	/**
	 * 
	 * @return String
	 */
	public String getU5destino() {
		return this.u5destino;
	}

	/**
	 * Method 'getU5fecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getU5fecalta() {
		return this.u5fecalta;
	}

	/**
	 * Method 'setU5fecalta'.
	 * 
	 * @param u5fecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setU5fecalta(Date u5fecalta) {
		this.u5fecalta = u5fecalta;
	}

	/**
	 * Method 'getU5fecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getU5fecmodif() {
		return this.u5fecmodif;
	}

	/**
	 * Method 'setU5fecmodif'.
	 * 
	 * @param u5fecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setU5fecmodif(Date u5fecmodif) {
		this.u5fecmodif = u5fecmodif;
	}

	/**
	 * Method 'getU5usualta'.
	 * 
	 * @return String
	 */

	public String getU5usualta() {
		return this.u5usualta;
	}

	/**
	 * Method 'setU5usualta'.
	 * 
	 * @param u5usualta
	 *            String
	 * @return
	 */

	public void setU5usualta(String u5usualta) {
		this.u5usualta = u5usualta;
	}

	/**
	 * Method 'getU5usumodif'.
	 * 
	 * @return String
	 */

	public String getU5usumodif() {
		return this.u5usumodif;
	}

	/**
	 * Method 'setU5usumodif'.
	 * 
	 * @param u5usumodif
	 *            String
	 * @return
	 */

	public void setU5usumodif(String u5usumodif) {
		this.u5usumodif = u5usumodif;
	}

	/**
	 * @return the u5ptcodigo
	 */
	public String getU5ptcodigo() {
		return this.u5ptcodigo;
	}

	/**
	 * @param u5ptcodigo
	 *            the u5ptcodigo to set
	 */
	public void setU5ptcodigo(String u5ptcodigo) {
		this.u5ptcodigo = u5ptcodigo;
	}

	/**
	 * @param u5fechasollocalizador
	 *            the u5fechasollocalizador to set
	 */
	public void setU5fechasollocalizador(Date u5fechasollocalizador) {
		this.u5fechasollocalizador = u5fechasollocalizador;
	}

	/**
	 * @return the u5fechasollocalizador
	 */
	public Date getU5fechasollocalizador() {
		return this.u5fechasollocalizador;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ u5codocumento: ").append(this.u5codocumento).append(" ]");
		result.append(", [ u5nofile: ").append(this.u5nofile).append(" ]");
		result.append(", [ u5sizefile: ").append(this.u5sizefile).append(" ]");
		result.append(", [ u5tedesfile: ").append(this.u5tedesfile).append(" ]");
		result.append(", [ u5origen: ").append(this.u5origen).append(" ]");
		result.append(", [ u5fecha: ").append(this.u5fecha).append(" ]");
		result.append(", [ u5conttype: ").append(this.u5conttype).append(" ]");
		result.append(", [ u5indmail: ").append(this.u5indmail).append(" ]");
		result.append(", [ u5trmail: ").append(this.u5trmail).append(" ]");
		result.append(", [ u5iddocumentum: ").append(this.u5iddocumentum).append(" ]");
		result.append(", [ u5tipodocumento: ").append(this.u5tipodocumento).append(" ]");
		result.append(", [ u5fechaaportacion: ").append(this.u5fechaaportacion).append(" ]");
		result.append(", [ u5fechaentrada: ").append(this.u5fechaentrada).append(" ]");
		result.append(", [ u5numregistroentrada: ").append(this.u5numregistroentrada).append(" ]");
		result.append(", [ u5idPerfilfirma: ").append(this.u5idPerfilfirma).append(" ]");
		result.append(", [ u5estadodocumento: ").append(this.u5estadodocumento).append(" ]");
		result.append(", [ u5fechasolfirma: ").append(this.u5fechasolfirma).append(" ]");
		result.append(", [ u5fechafirma: ").append(this.u5fechafirma).append(" ]");
		result.append(", [ u5comofirma: ").append(this.u5comofirma).append(" ]");
		result.append(", [ u5fecalta: ").append(this.u5fecalta).append(" ]");
		result.append(", [ u5fecmodif: ").append(this.u5fecmodif).append(" ]");
		result.append(", [ u5usualta: ").append(this.u5usualta).append(" ]");
		result.append(", [ u5usumodif: ").append(this.u5usumodif).append(" ]");
		result.append(", [ u5ptcodigo: ").append(this.u5ptcodigo).append(" ]");
		result.append(", [ u5destino: ").append(this.u5destino).append(" ]");
		result.append(", [ u5fechasollocalizador: ").append(this.u5fechasollocalizador).append(" ]");
		result.append(", [ u5pcodigo: ").append(this.u5pcodigo).append(" ]");
		result.append(", [ u5idinterviniente: ").append(this.u5idinterviniente).append(" ]");
		result.append(", [ expedien.getExcodigo: ").append(this.expedien == null ? "" : this.expedien.getExcodigo())
				.append(" ]");
		result.append(", [ santramexp().getTrid(): ").append(this.santramexp == null ? "" : this.santramexp.getTrid())
				.append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the u5fecharegistroorigen
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getU5fecharegistroorigen() {
		return this.u5fecharegistroorigen;
	}

	/**
	 * @param u5fecharegistroorigen
	 *            the u5fecharegistroorigen to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setU5fecharegistroorigen(Date u5fecharegistroorigen) {
		this.u5fecharegistroorigen = u5fecharegistroorigen;
	}

	/**
	 * @return the u5pcodigo
	 */
	public String getU5pcodigo() {
		return u5pcodigo;
	}

	/**
	 * @param u5pcodigo
	 *            the u5pcodigo to set
	 */
	public void setU5pcodigo(String u5pcodigo) {
		this.u5pcodigo = u5pcodigo;
	}

	/**
	 * @return the u5idinterviniente
	 */
	public String getU5idinterviniente() {
		return u5idinterviniente;
	}

	/**
	 * @param u5idinterviniente
	 *            the u5idinterviniente to set
	 */
	public void setU5idinterviniente(String u5idinterviniente) {
		this.u5idinterviniente = u5idinterviniente;
	}

}
