package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Sancuesproced  
 * 
 *  
 */

public class Sancuesproced implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String cpcodigo;
	private String cpdesces;
	private String cpdesceu;
	private Date cpfecalta;
	private Date cpfecmodif;
	private String cpusualta;
	private String cpusumodif;
	private List<Sanrecrca> sanrecrcas = new ArrayList<Sanrecrca>();

	/**
	 * Method 'Sancuesproced'.
	 */
	public Sancuesproced() {
	}

	/**
	 * Method 'Sancuesproced'.
	 * 
	 * @param cpcodigo
	 *            String
	 * @param cpdesces
	 *            String
	 * @param cpdesceu
	 *            String
	 */
	public Sancuesproced(String cpcodigo, String cpdesces, String cpdesceu) {
		this.cpcodigo = cpcodigo;
		this.cpdesces = cpdesces;
		this.cpdesceu = cpdesceu;
	}

	/**
	 * Method 'Sancuesproced'.
	 * 
	 * @param cpcodigo
	 *            String
	 * @param cpdesces
	 *            String
	 * @param cpdesceu
	 *            String
	 * @param cpfecalta
	 *            Date
	 * @param cpfecmodif
	 *            Date
	 * @param cpusualta
	 *            String
	 * @param cpusumodif
	 *            String
	 */
	public Sancuesproced(String cpcodigo, String cpdesces, String cpdesceu,
			Date cpfecalta, Date cpfecmodif, String cpusualta, String cpusumodif) {
		this.cpcodigo = cpcodigo;
		this.cpdesces = cpdesces;
		this.cpdesceu = cpdesceu;
		this.cpfecalta = cpfecalta;
		this.cpfecmodif = cpfecmodif;
		this.cpusualta = cpusualta;
		this.cpusumodif = cpusumodif;
	}

	/**
	 * Method 'Sancuesproced'.
	 * 
	 * @param cpcodigo
	 *            String
	 * @param cpdesces
	 *            String
	 * @param cpdesceu
	 *            String
	 * @param cpfecalta
	 *            Date
	 * @param cpfecmodif
	 *            Date
	 * @param cpusualta
	 *            String
	 * @param cpusumodif
	 *            String
	 * @param sanrecrcas
	 *            List<Sanrecrca>
	 */
	public Sancuesproced(String cpcodigo, String cpdesces, String cpdesceu,
			Date cpfecalta, Date cpfecmodif, String cpusualta,
			String cpusumodif, List<Sanrecrca> sanrecrcas) {

		this.cpcodigo = cpcodigo;
		this.cpdesces = cpdesces;
		this.cpdesceu = cpdesceu;
		this.cpfecalta = cpfecalta;
		this.cpfecmodif = cpfecmodif;
		this.cpusualta = cpusualta;
		this.cpusumodif = cpusumodif;
		this.sanrecrcas = sanrecrcas;
	}

	/**
	 * Method 'getCpcodigo'.
	 * 
	 * @return String
	 */

	public String getCpcodigo() {
		return this.cpcodigo;
	}

	/**
	 * Method 'setCpcodigo'.
	 * 
	 * @param cpcodigo
	 *            String
	 * @return
	 */

	public void setCpcodigo(String cpcodigo) {
		this.cpcodigo = cpcodigo;
	}

	/**
	 * Method 'getCpdesces'.
	 * 
	 * @return String
	 */

	public String getCpdesces() {
		return this.cpdesces;
	}

	/**
	 * Method 'setCpdesces'.
	 * 
	 * @param cpdesces
	 *            String
	 * @return
	 */

	public void setCpdesces(String cpdesces) {
		this.cpdesces = cpdesces;
	}

	/**
	 * Method 'getCpdesceu'.
	 * 
	 * @return String
	 */

	public String getCpdesceu() {
		return this.cpdesceu;
	}

	/**
	 * Method 'setCpdesceu'.
	 * 
	 * @param cpdesceu
	 *            String
	 * @return
	 */

	public void setCpdesceu(String cpdesceu) {
		this.cpdesceu = cpdesceu;
	}

	/**
	 * Method 'getCpfecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCpfecalta() {
		return this.cpfecalta;
	}

	/**
	 * Method 'setCpfecalta'.
	 * 
	 * @param cpfecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCpfecalta(Date cpfecalta) {
		this.cpfecalta = cpfecalta;
	}

	/**
	 * Method 'getCpfecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCpfecmodif() {
		return this.cpfecmodif;
	}

	/**
	 * Method 'setCpfecmodif'.
	 * 
	 * @param cpfecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCpfecmodif(Date cpfecmodif) {
		this.cpfecmodif = cpfecmodif;
	}

	/**
	 * Method 'getCpusualta'.
	 * 
	 * @return String
	 */

	public String getCpusualta() {
		return this.cpusualta;
	}

	/**
	 * Method 'setCpusualta'.
	 * 
	 * @param cpusualta
	 *            String
	 * @return
	 */

	public void setCpusualta(String cpusualta) {
		this.cpusualta = cpusualta;
	}

	/**
	 * Method 'getCpusumodif'.
	 * 
	 * @return String
	 */

	public String getCpusumodif() {
		return this.cpusumodif;
	}

	/**
	 * Method 'setCpusumodif'.
	 * 
	 * @param cpusumodif
	 *            String
	 * @return
	 */

	public void setCpusumodif(String cpusumodif) {
		this.cpusumodif = cpusumodif;
	}

	/**
	 * Method 'getSanrecrcas'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sanrecrca> getSanrecrcas() {
		return this.sanrecrcas;
	}

	/**
	 * Method 'setSanrecrcas'.
	 * 
	 * @param sanrecrcas
	 *            List
	 * @return
	 */
	public void setSanrecrcas(List<Sanrecrca> sanrecrcas) {
		this.sanrecrcas = sanrecrcas;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ cpcodigo: ").append(this.cpcodigo).append(" ]");
		result.append(", [ cpdesces: ").append(this.cpdesces).append(" ]");
		result.append(", [ cpdesceu: ").append(this.cpdesceu).append(" ]");
		result.append(", [ cpfecalta: ").append(this.cpfecalta).append(" ]");
		result.append(", [ cpfecmodif: ").append(this.cpfecmodif).append(" ]");
		result.append(", [ cpusualta: ").append(this.cpusualta).append(" ]");
		result.append(", [ cpusumodif: ").append(this.cpusumodif).append(" ]");
		result.append("}");
		return result.toString();
	}

}
