package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Sancuesfondo  
 * 
 *  
 */

public class Sancuesfondo implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String cfcodigo;
	private String cfdesces;
	private String cfdesceu;
	private Date cffecalta;
	private Date cffecmodif;
	private String cfusualta;
	private String cfusumodif;
	private List<Sanrecrca> sanrecrcas = new ArrayList<Sanrecrca>();

	/**
	 * Method 'Sancuesfondo'.
	 */
	public Sancuesfondo() {
	}

	/**
	 * Method 'Sancuesfondo'.
	 * 
	 * @param cfcodigo
	 *            String
	 * @param cfdesces
	 *            String
	 * @param cfdesceu
	 *            String
	 * @param cffecalta
	 *            Date
	 * @param cffecmodif
	 *            Date
	 * @param cfusualta
	 *            String
	 * @param cfusumodif
	 *            String
	 */
	public Sancuesfondo(String cfcodigo, String cfdesces, String cfdesceu,
			Date cffecalta, Date cffecmodif, String cfusualta, String cfusumodif) {
		this.cfcodigo = cfcodigo;
		this.cfdesces = cfdesces;
		this.cfdesceu = cfdesceu;
		this.cffecalta = cffecalta;
		this.cffecmodif = cffecmodif;
		this.cfusualta = cfusualta;
		this.cfusumodif = cfusumodif;
	}

	/**
	 * Method 'Sancuesfondo'.
	 * 
	 * @param cfcodigo
	 *            String
	 * @param cfdesces
	 *            String
	 * @param cfdesceu
	 *            String
	 * @param cffecalta
	 *            Date
	 * @param cffecmodif
	 *            Date
	 * @param cfusualta
	 *            String
	 * @param cfusumodif
	 *            String
	 * @param sanrecrcas
	 *            List<Sanrecrca>
	 */
	public Sancuesfondo(String cfcodigo, String cfdesces, String cfdesceu,
			Date cffecalta, Date cffecmodif, String cfusualta,
			String cfusumodif, List<Sanrecrca> sanrecrcas) {

		this.cfcodigo = cfcodigo;
		this.cfdesces = cfdesces;
		this.cfdesceu = cfdesceu;
		this.cffecalta = cffecalta;
		this.cffecmodif = cffecmodif;
		this.cfusualta = cfusualta;
		this.cfusumodif = cfusumodif;
		this.sanrecrcas = sanrecrcas;
	}

	/**
	 * Method 'getCfcodigo'.
	 * 
	 * @return String
	 */

	public String getCfcodigo() {
		return this.cfcodigo;
	}

	/**
	 * Method 'setCfcodigo'.
	 * 
	 * @param cfcodigo
	 *            String
	 * @return
	 */

	public void setCfcodigo(String cfcodigo) {
		this.cfcodigo = cfcodigo;
	}

	/**
	 * Method 'getCfdesces'.
	 * 
	 * @return String
	 */

	public String getCfdesces() {
		return this.cfdesces;
	}

	/**
	 * Method 'setCfdesces'.
	 * 
	 * @param cfdesces
	 *            String
	 * @return
	 */

	public void setCfdesces(String cfdesces) {
		this.cfdesces = cfdesces;
	}

	/**
	 * Method 'getCfdesceu'.
	 * 
	 * @return String
	 */

	public String getCfdesceu() {
		return this.cfdesceu;
	}

	/**
	 * Method 'setCfdesceu'.
	 * 
	 * @param cfdesceu
	 *            String
	 * @return
	 */

	public void setCfdesceu(String cfdesceu) {
		this.cfdesceu = cfdesceu;
	}

	/**
	 * Method 'getCffecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCffecalta() {
		return this.cffecalta;
	}

	/**
	 * Method 'setCffecalta'.
	 * 
	 * @param cffecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCffecalta(Date cffecalta) {
		this.cffecalta = cffecalta;
	}

	/**
	 * Method 'getCffecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCffecmodif() {
		return this.cffecmodif;
	}

	/**
	 * Method 'setCffecmodif'.
	 * 
	 * @param cffecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCffecmodif(Date cffecmodif) {
		this.cffecmodif = cffecmodif;
	}

	/**
	 * Method 'getCfusualta'.
	 * 
	 * @return String
	 */

	public String getCfusualta() {
		return this.cfusualta;
	}

	/**
	 * Method 'setCfusualta'.
	 * 
	 * @param cfusualta
	 *            String
	 * @return
	 */

	public void setCfusualta(String cfusualta) {
		this.cfusualta = cfusualta;
	}

	/**
	 * Method 'getCfusumodif'.
	 * 
	 * @return String
	 */

	public String getCfusumodif() {
		return this.cfusumodif;
	}

	/**
	 * Method 'setCfusumodif'.
	 * 
	 * @param cfusumodif
	 *            String
	 * @return
	 */

	public void setCfusumodif(String cfusumodif) {
		this.cfusumodif = cfusumodif;
	}

	/**
	 * Method 'getSanrecrcas'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sanrecrca> getSanrecrcas() {
		return this.sanrecrcas;
	}

	/**
	 * Method 'setSanrecrcas'.
	 * 
	 * @param sanrecrcas
	 *            List
	 * @return
	 */
	public void setSanrecrcas(List<Sanrecrca> sanrecrcas) {
		this.sanrecrcas = sanrecrcas;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ cfcodigo: ").append(this.cfcodigo).append(" ]");
		result.append(", [ cfdesces: ").append(this.cfdesces).append(" ]");
		result.append(", [ cfdesceu: ").append(this.cfdesceu).append(" ]");
		result.append(", [ cffecalta: ").append(this.cffecalta).append(" ]");
		result.append(", [ cffecmodif: ").append(this.cffecmodif).append(" ]");
		result.append(", [ cfusualta: ").append(this.cfusualta).append(" ]");
		result.append(", [ cfusumodif: ").append(this.cfusumodif).append(" ]");
		result.append("}");
		return result.toString();
	}

}
