package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;

/**
 * * Respuesta  
 * 
 *  
 */

public class Respuesta implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String p9codigo;
	private TipoRespuesta tipoRespuesta;
	private Consulta consulta;
	private Date p9feanot;
	private String p9inemlusu;
	private Date p9feresp;
	private String p9teres;
	private BigDecimal p9nufiladj;
	private List<RespuestaFile> respuestaFiles = new ArrayList<RespuestaFile>();

	/**
	 * Method 'Respuesta'.
	 * 
	 */
	public Respuesta() {
	}

	/**
	 * Method 'Respuesta'.
	 * 
	 * @param p9codigo
	 *            String
	 * @param p9feanot
	 *            Date
	 * @param p9inemlusu
	 *            String
	 * @param p9feresp
	 *            Date
	 * @param p9teres
	 *            String
	 * @param p9nufiladj
	 *            BigDecimal
	 * @param tipoRespuesta
	 *            TipoRespuesta
	 * @param consulta
	 *            Consulta
	 */
	public Respuesta(String p9codigo, Date p9feanot, String p9inemlusu,
			Date p9feresp, String p9teres, BigDecimal p9nufiladj,
			TipoRespuesta tipoRespuesta, Consulta consulta) {
		this.p9codigo = p9codigo;
		this.tipoRespuesta = tipoRespuesta;
		this.consulta = consulta;
		this.p9feanot = p9feanot;
		this.p9inemlusu = p9inemlusu;
		this.p9feresp = p9feresp;
		this.p9teres = p9teres;
		this.p9nufiladj = p9nufiladj;
	}

	/**
	 * Method 'Respuesta'.
	 * 
	 * @param p9codigo
	 *            String
	 * @param p9feanot
	 *            Date
	 * @param p9inemlusu
	 *            String
	 * @param p9feresp
	 *            Date
	 * @param p9teres
	 *            String
	 * @param p9nufiladj
	 *            BigDecimal
	 * @param tipoRespuesta
	 *            TipoRespuesta
	 * @param consulta
	 *            Consulta
	 * @param respuestaFiles
	 *            List<RespuestaFile>
	 */
	public Respuesta(String p9codigo, Date p9feanot, String p9inemlusu,
			Date p9feresp, String p9teres, BigDecimal p9nufiladj,
			TipoRespuesta tipoRespuesta, Consulta consulta,
			List<RespuestaFile> respuestaFiles) {

		this.p9codigo = p9codigo;
		this.tipoRespuesta = tipoRespuesta;
		this.consulta = consulta;
		this.p9feanot = p9feanot;
		this.p9inemlusu = p9inemlusu;
		this.p9feresp = p9feresp;
		this.p9teres = p9teres;
		this.p9nufiladj = p9nufiladj;
		this.respuestaFiles = respuestaFiles;
	}

	/**
	 * Method 'getP9codigo'.
	 * 
	 * @return String
	 */

	public String getP9codigo() {
		return this.p9codigo;
	}

	/**
	 * Method 'setP9codigo'.
	 * 
	 * @param p9codigo
	 *            String
	 * @return
	 */

	public void setP9codigo(String p9codigo) {
		this.p9codigo = p9codigo;
	}

	/**
	 * Method 'getTipoRespuesta'.
	 * 
	 * @return TipoRespuesta
	 */
	@JsonIgnore
	public TipoRespuesta getTipoRespuesta() {
		return this.tipoRespuesta;
	}

	/**
	 * Method 'setTipoRespuesta'.
	 * 
	 * @param tipoRespuesta
	 *            TipoRespuesta
	 * @return
	 */

	public void setTipoRespuesta(TipoRespuesta tipoRespuesta) {
		this.tipoRespuesta = tipoRespuesta;
	}

	/**
	 * Method 'getConsulta'.
	 * 
	 * @return Consulta
	 */
	@JsonIgnore
	public Consulta getConsulta() {
		return this.consulta;
	}

	/**
	 * Method 'setConsulta'.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return
	 */

	public void setConsulta(Consulta consulta) {
		this.consulta = consulta;
	}

	/**
	 * Method 'getP9feanot'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getP9feanot() {
		return this.p9feanot;
	}

	/**
	 * Method 'setP9feanot'.
	 * 
	 * @param p9feanot
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setP9feanot(Date p9feanot) {
		this.p9feanot = p9feanot;
	}

	/**
	 * Method 'getP9inemlusu'.
	 * 
	 * @return String
	 */

	public String getP9inemlusu() {
		return this.p9inemlusu;
	}

	/**
	 * Method 'setP9inemlusu'.
	 * 
	 * @param p9inemlusu
	 *            String
	 * @return
	 */

	public void setP9inemlusu(String p9inemlusu) {
		this.p9inemlusu = p9inemlusu;
	}

	/**
	 * Method 'getP9feresp'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getP9feresp() {
		return this.p9feresp;
	}

	/**
	 * Method 'setP9feresp'.
	 * 
	 * @param p9feresp
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setP9feresp(Date p9feresp) {
		this.p9feresp = p9feresp;
	}

	/**
	 * Method 'getP9teres'.
	 * 
	 * @return String
	 */
	@JsonIgnore
	public String getP9teres() {
		return this.p9teres;
	}

	/**
	 * Method 'setP9teres'.
	 * 
	 * @param p9teres
	 *            String
	 * @return
	 */

	public void setP9teres(String p9teres) {
		this.p9teres = p9teres;
	}

	/**
	 * Method 'getP9nufiladj'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getP9nufiladj() {
		return this.p9nufiladj;
	}

	/**
	 * Method 'setP9nufiladj'.
	 * 
	 * @param p9nufiladj
	 *            BigDecimal
	 * @return
	 */

	public void setP9nufiladj(BigDecimal p9nufiladj) {
		this.p9nufiladj = p9nufiladj;
	}

	/**
	 * Method 'getRespuestaFiles'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<RespuestaFile> getRespuestaFiles() {
		return this.respuestaFiles;
	}

	/**
	 * Method 'setRespuestaFiles'.
	 * 
	 * @param respuestaFiles
	 *            List
	 * @return
	 */
	public void setRespuestaFiles(List<RespuestaFile> respuestaFiles) {
		this.respuestaFiles = respuestaFiles;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ p9codigo: ").append(this.p9codigo).append(" ]");
		result.append(", [ p9feanot: ").append(this.p9feanot).append(" ]");
		result.append(", [ p9inemlusu: ").append(this.p9inemlusu).append(" ]");
		result.append(", [ p9feresp: ").append(this.p9feresp).append(" ]");
		result.append(", [ p9nufiladj: ").append(this.p9nufiladj).append(" ]");
		result.append("}");
		return result.toString();
	}

}
