package com.ejie.y41b.model;

import java.sql.Blob;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;

/**
 * Remesa  
 * 
 *  
 */

public class Remesa implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String rmcodigo;
	private String rmtipo;
	private String rmestado;
	private String rmcodplantcaratula;
	private String rmcodplantacuse;
	private String rmcodplantlistado;
	private Blob rmdatafile;
	private Blob rmlistadofile;
	private Blob rmacusesfile;
	private Date rmfechageneracion;
	private Date rmfechaemision;
	private String rmcomo;
	private String rmtipoproc;
	private String rmnombremonitor;
	private Integer rmidColeccionAA66;
	private String rmcodColeccionAA66;
	private Integer rmidRemesaAA66;
	private String rmcodRemesaAA66;
	private String rmdesDesremesa;
	private String rmdesMotremes;
	private String rmdesMotremeu;
	private String rmdesErrores;
	private String rmdesErroreu;
	//
	private Date rmFechaActualizacion;
	private Date rmFechaEnvioMasReciente;
	private String rmtpnombres;
	private String rmtpnombreu;
	private String rmtramitador;
	private String rmnumexpediente;
	private String rmtramitadorenviocod;
	private String rmtramitadorenvionb;
	//
	private String rmacto;
	private String rmdestinatario;
	private String rmCP;
	private String rmProvincia;
	private String rmMunicipio;
	private Date rmFecha;
	private String rmEstadoEnvio;
	private String rmSituacionEnviocod;
	private String rmSituacionEnvioes;
	private String rmSituacionEnvioeu;
	private String rmSituacionAcuse;
	private String rmTramitacionAcuse;
	private String rmSituacionCorreoscod;
	private String rmSituacionCorreoses;
	private String rmSituacionCorreoseu;
	private Integer rmIdEnvioDevueltoAA66;
	private String rmCodEnvioDevueltoAA66;
	private String rmCodigoBarras;
	private String rmDescEnvioes;
	private String rmDescEnvioeu;
	private Date rmFechaActEnvio;

	//
	private List<TramiteHecho> rmtramiteshechos;

	/**
	 * Method 'Remesa'.
	 */
	public Remesa() {
	}

	/**
	 * Method 'Remesa'.
	 * 
	 * @param rmcodigo
	 */
	public Remesa(String rmcodigo) {
		super();
		this.rmcodigo = rmcodigo;
	}

	/**
	 * Method 'Remesa'.
	 * 
	 * @param rmcodigo
	 *            String
	 * @param rmtipo
	 *            String
	 * @param rmestado
	 *            String
	 * @param rmcodplantcaratula
	 *            String
	 * @param rmcodplantacuse
	 *            String
	 * @param rmcodplantlistado
	 *            String
	 * @param rmdatafile
	 *            Blob
	 * @param rmlistadofile
	 *            Blob
	 * @param rmacusesfile
	 *            Blob
	 * @param rmfechageneracion
	 *            Date
	 * @param rmfechaemision
	 *            Date
	 * @param rmcomo
	 *            String
	 * @param tramiteHechos
	 *            List<TramiteHecho>
	 */
	public Remesa(String rmcodigo, String rmtipo, String rmestado,
			String rmcodplantcaratula, String rmcodplantacuse,
			String rmcodplantlistado, Blob rmdatafile, Blob rmlistadofile,
			Blob rmacusesfile, Date rmfechageneracion, Date rmfechaemision,
			String rmcomo, String rmtipoproc,
			List<TramiteHecho> rmtramiteshechos) {

		this.rmcodigo = rmcodigo;
		this.rmtipo = rmtipo;
		this.rmestado = rmestado;
		this.rmcodplantcaratula = rmcodplantcaratula;
		this.rmcodplantacuse = rmcodplantacuse;
		this.rmcodplantlistado = rmcodplantlistado;
		this.rmdatafile = rmdatafile;
		this.rmlistadofile = rmlistadofile;
		this.rmacusesfile = rmacusesfile;
		this.rmfechageneracion = rmfechageneracion;
		this.rmfechaemision = rmfechaemision;
		this.rmcomo = rmcomo;
		this.rmtipoproc = rmtipoproc;
		this.rmtramiteshechos = rmtramiteshechos;
	}

	/**
	 * @param rmcodigo
	 * @param rmtipo
	 * @param rmestado
	 * @param rmcodplantcaratula
	 * @param rmcodplantacuse
	 * @param rmcodplantlistado
	 * @param rmdatafile
	 * @param rmlistadofile
	 * @param rmacusesfile
	 * @param rmfechageneracion
	 * @param rmfechaemision
	 * @param rmcomo
	 * @param rmtipoproc
	 * @param rmnombremonitor
	 * @param rmidColeccionAA66
	 * @param rmcodColeccionAA66
	 * @param rmidRemesaAA66
	 * @param rmcodRemesaAA66
	 * @param rmdesDesremesa
	 * @param rmdesMotremes
	 * @param rmdesMotremeu
	 * @param rmdesErrores
	 * @param rmdesErroreu
	 * @param rmtramiteshechos
	 */
	public Remesa(String rmcodigo, String rmtipo, String rmestado,
			String rmcodplantcaratula, String rmcodplantacuse,
			String rmcodplantlistado, Blob rmdatafile, Blob rmlistadofile,
			Blob rmacusesfile, Date rmfechageneracion, Date rmfechaemision,
			String rmcomo, String rmtipoproc, String rmnombremonitor,
			Integer rmidColeccionAA66, String rmcodColeccionAA66,
			Integer rmidRemesaAA66, String rmcodRemesaAA66,
			String rmdesDesremesa, String rmdesMotremes, String rmdesMotremeu,
			String rmdesErrores, String rmdesErroreu,
			Date rmFechaActualizacion, List<TramiteHecho> rmtramiteshechos) {
		super();
		this.rmcodigo = rmcodigo;
		this.rmtipo = rmtipo;
		this.rmestado = rmestado;
		this.rmcodplantcaratula = rmcodplantcaratula;
		this.rmcodplantacuse = rmcodplantacuse;
		this.rmcodplantlistado = rmcodplantlistado;
		this.rmdatafile = rmdatafile;
		this.rmlistadofile = rmlistadofile;
		this.rmacusesfile = rmacusesfile;
		this.rmfechageneracion = rmfechageneracion;
		this.rmfechaemision = rmfechaemision;
		this.rmcomo = rmcomo;
		this.rmtipoproc = rmtipoproc;
		this.rmnombremonitor = rmnombremonitor;
		this.rmidColeccionAA66 = rmidColeccionAA66;
		this.rmcodColeccionAA66 = rmcodColeccionAA66;
		this.rmidRemesaAA66 = rmidRemesaAA66;
		this.rmcodRemesaAA66 = rmcodRemesaAA66;
		this.rmdesDesremesa = rmdesDesremesa;
		this.rmdesMotremes = rmdesMotremes;
		this.rmdesMotremeu = rmdesMotremeu;
		this.rmdesErrores = rmdesErrores;
		this.rmdesErroreu = rmdesErroreu;
		this.rmFechaActualizacion = rmFechaActualizacion;

		this.rmtramiteshechos = rmtramiteshechos;
	}

	/**
	 * @param rmcodigo
	 * @param rmtipo
	 * @param rmestado
	 * @param rmcodplantcaratula
	 * @param rmcodplantacuse
	 * @param rmcodplantlistado
	 * @param rmdatafile
	 * @param rmlistadofile
	 * @param rmacusesfile
	 * @param rmfechageneracion
	 * @param rmfechaemision
	 * @param rmcomo
	 * @param rmtipoproc
	 * @param rmnombremonitor
	 * @param rmidColeccionAA66
	 * @param rmcodColeccionAA66
	 * @param rmidRemesaAA66
	 * @param rmcodRemesaAA66
	 * @param rmdesDesremesa
	 * @param rmdesMotremes
	 * @param rmdesMotremeu
	 * @param rmdesErrores
	 * @param rmdesErroreu
	 * @param rmtramiteshechos
	 */
	public Remesa(String rmcodigo, String rmtipo, String rmestado,
			String rmcodplantcaratula, String rmcodplantacuse,
			String rmcodplantlistado, Blob rmdatafile, Blob rmlistadofile,
			Blob rmacusesfile, Date rmfechageneracion, Date rmfechaemision,
			String rmcomo, String rmtipoproc, String rmtpnombres,
			String rmtpnombreu, String rmtramitador, String rmnumexpediente,
			String rmtramitadorenviocod, String rmtramitadorenvionb,
			String rmacto, String rmdestinatario, String rmCP,
			String rmProvincia, String rmMunicipio, Date rmFecha,
			String rmEstadoEnvio, String rmSituacionEnviocod,
			String rmSituacionEnvioes, String rmSituacionEnvioeu,
			String rmSituacionAcuse, String rmTramitacionAcuse,
			String rmSituacionCorreoscod, String rmSituacionCorreoses,
			String rmSituacionCorreoseu, Integer rmIdEnvioDevueltoAA66,
			String rmCodEnvioDevueltoAA66, String rmCodigoBarras,
			String rmDescEnvioes, String rmDescEnvioeu, Date rmFechaActEnvio,
			String rmnombremonitor, Integer rmidColeccionAA66,
			String rmcodColeccionAA66, Integer rmidRemesaAA66,
			String rmcodRemesaAA66, String rmdesDesremesa,
			String rmdesMotremes, String rmdesMotremeu, String rmdesErrores,
			String rmdesErroreu, Date rmFechaActualizacion,
			List<TramiteHecho> rmtramiteshechos) {
		super();
		this.rmcodigo = rmcodigo;
		this.rmtipo = rmtipo;
		this.rmestado = rmestado;
		this.rmcodplantcaratula = rmcodplantcaratula;
		this.rmcodplantacuse = rmcodplantacuse;
		this.rmcodplantlistado = rmcodplantlistado;
		this.rmdatafile = rmdatafile;
		this.rmlistadofile = rmlistadofile;
		this.rmacusesfile = rmacusesfile;
		this.rmfechageneracion = rmfechageneracion;
		this.rmfechaemision = rmfechaemision;
		this.rmcomo = rmcomo;
		this.rmtipoproc = rmtipoproc;
		this.rmtpnombres = rmtpnombres;
		this.rmtpnombreu = rmtpnombreu;
		this.rmtramitador = rmtramitador;
		this.rmnumexpediente = rmnumexpediente;
		this.rmtramitadorenviocod = rmtramitadorenviocod;
		this.rmtramitadorenvionb = rmtramitadorenvionb;
		this.rmacto = rmacto;
		this.rmdestinatario = rmdestinatario;
		this.rmCP = rmCP;
		this.rmProvincia = rmProvincia;
		this.rmMunicipio = rmMunicipio;
		this.rmFecha = rmFecha;
		this.rmEstadoEnvio = rmEstadoEnvio;
		this.rmSituacionEnviocod = rmSituacionEnviocod;
		this.rmSituacionEnvioes = rmSituacionEnvioes;
		this.rmSituacionEnvioeu = rmSituacionEnvioeu;
		this.rmSituacionAcuse = rmSituacionAcuse;
		this.rmTramitacionAcuse = rmTramitacionAcuse;
		this.rmSituacionCorreoscod = rmSituacionCorreoscod;
		this.rmSituacionCorreoses = rmSituacionCorreoses;
		this.rmSituacionCorreoseu = rmSituacionCorreoseu;
		this.rmIdEnvioDevueltoAA66 = rmIdEnvioDevueltoAA66;
		this.rmCodEnvioDevueltoAA66 = rmCodEnvioDevueltoAA66;
		this.rmCodigoBarras = rmCodigoBarras;
		this.rmDescEnvioes = rmDescEnvioes;
		this.rmDescEnvioeu = rmDescEnvioeu;
		this.rmFechaActEnvio = rmFechaActEnvio;
		this.rmnombremonitor = rmnombremonitor;
		this.rmidColeccionAA66 = rmidColeccionAA66;
		this.rmcodColeccionAA66 = rmcodColeccionAA66;
		this.rmidRemesaAA66 = rmidRemesaAA66;
		this.rmcodRemesaAA66 = rmcodRemesaAA66;
		this.rmdesDesremesa = rmdesDesremesa;
		this.rmdesMotremes = rmdesMotremes;
		this.rmdesMotremeu = rmdesMotremeu;
		this.rmdesErrores = rmdesErrores;
		this.rmdesErroreu = rmdesErroreu;
		this.rmFechaActualizacion = rmFechaActualizacion;
		this.rmtramiteshechos = rmtramiteshechos;
	}

	/**
	 * Method 'Remesa'.
	 * 
	 * @param rmcodigo
	 *            String
	 * @param rmtipo
	 *            String
	 * @param rmestado
	 *            String
	 * @param rmcodplantcaratula
	 *            String
	 * @param rmcodplantacuse
	 *            String
	 * @param rmcodplantlistado
	 *            String
	 * @param rmdatafile
	 *            Blob
	 * @param rmlistadofile
	 *            Blob
	 * @param rmacusesfile
	 *            Blob
	 * @param rmfechageneracion
	 *            Date
	 * @param rmfechaemision
	 *            Date
	 * @param rmcomo
	 *            String
	 * @param tramiteHechos
	 *            List<TramiteHecho>
	 */
	public Remesa(String rmcodigo, Blob rmdatafile, Blob rmlistadofile,
			Blob rmacusesfile) {

		this.rmcodigo = rmcodigo;
		this.rmdatafile = rmdatafile;
		this.rmlistadofile = rmlistadofile;
		this.rmacusesfile = rmacusesfile;
	}

	/**
	 * Method 'Remesa'.
	 * 
	 * @param rmcodigo
	 *            String
	 * @param rmtipo
	 *            String
	 * @param rmestado
	 *            String
	 * 
	 * @param rmfechageneracion
	 *            Date
	 * @param rmfechaemision
	 *            Date
	 * 
	 * @param rmFechaEnvioMasReciente
	 *            Date
	 */
	public Remesa(String rmcodigo, String rmtipo, String rmestado,
			Date rmfechageneracion, Date rmfechaemision,
			Date rmFechaEnvioMasReciente) {

		this.rmcodigo = rmcodigo;
		this.rmtipo = rmtipo;
		this.rmestado = rmestado;
		this.rmfechageneracion = rmfechageneracion;
		this.rmfechaemision = rmfechaemision;
		this.rmFechaEnvioMasReciente = rmFechaEnvioMasReciente;
	}

	/**
	 * Method 'getRmcodigo'.
	 * 
	 * @return String
	 */

	public String getRmcodigo() {
		return this.rmcodigo;
	}

	/**
	 * Method 'setRmcodigo'.
	 * 
	 * @param rmcodigo
	 *            String
	 * @return
	 */

	public void setRmcodigo(String rmcodigo) {
		this.rmcodigo = rmcodigo;
	}

	/**
	 * Method 'getRmtipo'.
	 * 
	 * @return String
	 */

	public String getRmtipo() {
		return this.rmtipo;
	}

	/**
	 * Method 'setRmtipo'.
	 * 
	 * @param rmtipo
	 *            String
	 * @return
	 */

	public void setRmtipo(String rmtipo) {
		this.rmtipo = rmtipo;
	}

	/**
	 * Method 'getRmestado'.
	 * 
	 * @return String
	 */

	public String getRmestado() {
		return this.rmestado;
	}

	/**
	 * Method 'setRmestado'.
	 * 
	 * @param rmestado
	 *            String
	 * @return
	 */

	public void setRmestado(String rmestado) {
		this.rmestado = rmestado;
	}

	/**
	 * Method 'getRmcodplantcaratula'.
	 * 
	 * @return String
	 */

	public String getRmcodplantcaratula() {
		return this.rmcodplantcaratula;
	}

	/**
	 * Method 'setRmcodplantcaratula'.
	 * 
	 * @param rmcodplantcaratula
	 *            String
	 * @return
	 */

	public void setRmcodplantcaratula(String rmcodplantcaratula) {
		this.rmcodplantcaratula = rmcodplantcaratula;
	}

	/**
	 * Method 'getRmcodplantacuse'.
	 * 
	 * @return String
	 */

	public String getRmcodplantacuse() {
		return this.rmcodplantacuse;
	}

	/**
	 * Method 'setRmcodplantacuse'.
	 * 
	 * @param rmcodplantacuse
	 *            String
	 * @return
	 */

	public void setRmcodplantacuse(String rmcodplantacuse) {
		this.rmcodplantacuse = rmcodplantacuse;
	}

	/**
	 * Method 'getRmcodplantlistado'.
	 * 
	 * @return String
	 */

	public String getRmcodplantlistado() {
		return this.rmcodplantlistado;
	}

	/**
	 * Method 'setRmcodplantlistado'.
	 * 
	 * @param rmcodplantlistado
	 *            String
	 * @return
	 */

	public void setRmcodplantlistado(String rmcodplantlistado) {
		this.rmcodplantlistado = rmcodplantlistado;
	}

	/**
	 * Method 'getRmdatafile'.
	 * 
	 * @return Blob
	 */
	@JsonIgnore
	public Blob getRmdatafile() {
		return this.rmdatafile;
	}

	/**
	 * Method 'setRmdatafile'.
	 * 
	 * @param rmdatafile
	 *            Blob
	 * @return
	 */

	public void setRmdatafile(Blob rmdatafile) {
		this.rmdatafile = rmdatafile;
	}

	/**
	 * Method 'getRmlistadofile'.
	 * 
	 * @return Blob
	 */
	@JsonIgnore
	public Blob getRmlistadofile() {
		return this.rmlistadofile;
	}

	/**
	 * Method 'setRmlistadofile'.
	 * 
	 * @param rmlistadofile
	 *            Blob
	 * @return
	 */

	public void setRmlistadofile(Blob rmlistadofile) {
		this.rmlistadofile = rmlistadofile;
	}

	/**
	 * Method 'getRmacusesfile'.
	 * 
	 * @return Blob
	 */
	@JsonIgnore
	public Blob getRmacusesfile() {
		return this.rmacusesfile;
	}

	/**
	 * Method 'setRmacusesfile'.
	 * 
	 * @param rmacusesfile
	 *            Blob
	 * @return
	 */

	public void setRmacusesfile(Blob rmacusesfile) {
		this.rmacusesfile = rmacusesfile;
	}

	/**
	 * Method 'getRmfechageneracion'.
	 * 
	 * @return Date
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	// @JsonSerialize(using = JsonDateSerializer.class)
	public Date getRmfechageneracion() {
		return this.rmfechageneracion;
	}

	/**
	 * Method 'setRmfechageneracion'.
	 * 
	 * @param rmfechageneracion
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	// @JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRmfechageneracion(Date rmfechageneracion) {
		this.rmfechageneracion = rmfechageneracion;
	}

	/**
	 * Method 'getRmfechaemision'.
	 * 
	 * @return Date
	 */

	// @JsonSerialize(using = Y41bJsonDateSerializer.class)
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getRmfechaemision() {
		return this.rmfechaemision;
	}

	/**
	 * Method 'setRmfechaemision'.
	 * 
	 * @param rmfechaemision
	 *            Date
	 * @return
	 */
	// @JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRmfechaemision(Date rmfechaemision) {
		this.rmfechaemision = rmfechaemision;
	}

	/**
	 * Method 'getRmcomo'.
	 * 
	 * @return String
	 */

	public String getRmcomo() {
		return this.rmcomo;
	}

	/**
	 * Method 'setRmcomo'.
	 * 
	 * @param rmcomo
	 *            String
	 * @return
	 */

	public void setRmcomo(String rmcomo) {
		this.rmcomo = rmcomo;
	}

	/**
	 * @return the rmtipoproc
	 */
	public String getRmtipoproc() {
		return rmtipoproc;
	}

	/**
	 * @param rmtipoproc
	 *            the rmtipoproc to set
	 */
	public void setRmtipoproc(String rmtipoproc) {
		this.rmtipoproc = rmtipoproc;
	}

	/**
	 * @return the rmtpnombres
	 */
	public String getRmtpnombres() {
		return rmtpnombres;
	}

	/**
	 * @param rmtpnombres
	 *            the rmtpnombres to set
	 */
	public void setRmtpnombres(String rmtpnombres) {
		this.rmtpnombres = rmtpnombres;
	}

	/**
	 * @return the rmtpnombreu
	 */
	public String getRmtpnombreu() {
		return rmtpnombreu;
	}

	/**
	 * @param rmtpnombreu
	 *            the rmtpnombreu to set
	 */
	public void setRmtpnombreu(String rmtpnombreu) {
		this.rmtpnombreu = rmtpnombreu;
	}

	/**
	 * @return the rmnombremonitor
	 */
	public String getRmnombremonitor() {
		return rmnombremonitor;
	}

	/**
	 * @param rmnombremonitor
	 *            the rmnombremonitor to set
	 */
	public void setRmnombremonitor(String rmnombremonitor) {
		this.rmnombremonitor = rmnombremonitor;
	}

	/**
	 * @return the rmtramiteshechos
	 */
	public List<TramiteHecho> getRmtramiteshechos() {
		return rmtramiteshechos;
	}

	/**
	 * @param rmtramiteshechos
	 *            the rmtramiteshechos to set
	 */
	public void setRmtramiteshechos(List<TramiteHecho> rmtramiteshechos) {
		this.rmtramiteshechos = rmtramiteshechos;
	}

	/**
	 * @return the rmidColeccionAA66
	 */
	public Integer getRmidColeccionAA66() {
		return rmidColeccionAA66;
	}

	/**
	 * @param rmidColeccionAA66
	 *            the rmidColeccionAA66 to set
	 */
	public void setRmidColeccionAA66(Integer rmidColeccionAA66) {
		this.rmidColeccionAA66 = rmidColeccionAA66;
	}

	/**
	 * @return the rmcodColeccionAA66
	 */
	public String getRmcodColeccionAA66() {
		return rmcodColeccionAA66;
	}

	/**
	 * @param rmcodColeccionAA66
	 *            the rmcodColeccionAA66 to set
	 */
	public void setRmcodColeccionAA66(String rmcodColeccionAA66) {
		this.rmcodColeccionAA66 = rmcodColeccionAA66;
	}

	/**
	 * @return the rmidRemesaAA66
	 */
	public Integer getRmidRemesaAA66() {
		return rmidRemesaAA66;
	}

	/**
	 * @param rmidRemesaAA66
	 *            the rmidRemesaAA66 to set
	 */
	public void setRmidRemesaAA66(Integer rmidRemesaAA66) {
		this.rmidRemesaAA66 = rmidRemesaAA66;
	}

	/**
	 * @return the rmcodRemesaAA66
	 */
	public String getRmcodRemesaAA66() {
		return rmcodRemesaAA66;
	}

	/**
	 * @param rmcodRemesaAA66
	 *            the rmcodRemesaAA66 to set
	 */
	public void setRmcodRemesaAA66(String rmcodRemesaAA66) {
		this.rmcodRemesaAA66 = rmcodRemesaAA66;
	}

	/**
	 * @return the rmdesDesremesa
	 */
	public String getRmdesDesremesa() {
		return rmdesDesremesa;
	}

	/**
	 * @param rmdesDesremesa
	 *            the rmdesDesremesa to set
	 */
	public void setRmdesDesremesa(String rmdesDesremesa) {
		this.rmdesDesremesa = rmdesDesremesa;
	}

	/**
	 * @return the rmdesMotremes
	 */
	public String getRmdesMotremes() {
		return rmdesMotremes;
	}

	/**
	 * @param rmdesMotremes
	 *            the rmdesMotremes to set
	 */
	public void setRmdesMotremes(String rmdesMotremes) {
		this.rmdesMotremes = rmdesMotremes;
	}

	/**
	 * @return the rmdesMotremeu
	 */
	public String getRmdesMotremeu() {
		return rmdesMotremeu;
	}

	/**
	 * @param rmdesMotremeu
	 *            the rmdesMotremeu to set
	 */
	public void setRmdesMotremeu(String rmdesMotremeu) {
		this.rmdesMotremeu = rmdesMotremeu;
	}

	/**
	 * @return the rmdesErrores
	 */
	public String getRmdesErrores() {
		return rmdesErrores;
	}

	/**
	 * @param rmdesErrores
	 *            the rmdesErrores to set
	 */
	public void setRmdesErrores(String rmdesErrores) {
		this.rmdesErrores = rmdesErrores;
	}

	/**
	 * @return the rmdesErroreu
	 */
	public String getRmdesErroreu() {
		return rmdesErroreu;
	}

	/**
	 * @param rmdesErroreu
	 *            the rmdesErroreu to set
	 */
	public void setRmdesErroreu(String rmdesErroreu) {
		this.rmdesErroreu = rmdesErroreu;
	}

	/**
	 * @return the rmFechaActualizacion
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getRmFechaActualizacion() {
		return rmFechaActualizacion;
	}

	/**
	 * @param rmFechaActualizacion
	 *            the rmFechaActualizacion to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRmFechaActualizacion(Date rmFechaActualizacion) {
		this.rmFechaActualizacion = rmFechaActualizacion;
	}

	/**
	 * @return the rmFechaEnvioMasReciente
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getRmFechaEnvioMasReciente() {
		return rmFechaEnvioMasReciente;
	}

	/**
	 * @param rmFechaEnvioMasReciente
	 *            the rmFechaEnvioMasReciente to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRmFechaEnvioMasReciente(Date rmFechaEnvioMasReciente) {
		this.rmFechaEnvioMasReciente = rmFechaEnvioMasReciente;
	}

	/**
	 * @return the rmtramitador
	 */
	public String getRmtramitador() {
		return rmtramitador;
	}

	/**
	 * @param rmtramitador
	 *            the rmtramitador to set
	 */
	public void setRmtramitador(String rmtramitador) {
		this.rmtramitador = rmtramitador;
	}

	/**
	 * @return the rmnumexpediente
	 */
	public String getRmnumexpediente() {
		return rmnumexpediente;
	}

	/**
	 * @param rmnumexpediente
	 *            the rmnumexpediente to set
	 */
	public void setRmnumexpediente(String rmnumexpediente) {
		this.rmnumexpediente = rmnumexpediente;
	}

	/**
	 * @return the rmtramitadorenviocod
	 */
	public String getRmtramitadorenviocod() {
		return rmtramitadorenviocod;
	}

	/**
	 * @param rmtramitadorenviocod
	 *            the rmtramitadorenviocod to set
	 */
	public void setRmtramitadorenviocod(String rmtramitadorenviocod) {
		this.rmtramitadorenviocod = rmtramitadorenviocod;
	}

	/**
	 * @return the rmtramitadorenvionb
	 */
	public String getRmtramitadorenvionb() {
		return rmtramitadorenvionb;
	}

	/**
	 * @param rmtramitadorenvionb
	 *            the rmtramitadorenvionb to set
	 */
	public void setRmtramitadorenvionb(String rmtramitadorenvionb) {
		this.rmtramitadorenvionb = rmtramitadorenvionb;
	}

	/**
	 * @return the rmacto
	 */
	public String getRmacto() {
		return rmacto;
	}

	/**
	 * @param rmacto
	 *            the rmacto to set
	 */
	public void setRmacto(String rmacto) {
		this.rmacto = rmacto;
	}

	/**
	 * @return the rmdestinatario
	 */
	public String getRmdestinatario() {
		return rmdestinatario;
	}

	/**
	 * @param rmdestinatario
	 *            the rmdestinatario to set
	 */
	public void setRmdestinatario(String rmdestinatario) {
		this.rmdestinatario = rmdestinatario;
	}

	/**
	 * @return the rmCP
	 */
	public String getRmCP() {
		return rmCP;
	}

	/**
	 * @param rmCP
	 *            the rmCP to set
	 */
	public void setRmCP(String rmCP) {
		this.rmCP = rmCP;
	}

	/**
	 * @return the rmProvincia
	 */
	public String getRmProvincia() {
		return rmProvincia;
	}

	/**
	 * @param rmProvincia
	 *            the rmProvincia to set
	 */
	public void setRmProvincia(String rmProvincia) {
		this.rmProvincia = rmProvincia;
	}

	/**
	 * @return the rmMunicipio
	 */
	public String getRmMunicipio() {
		return rmMunicipio;
	}

	/**
	 * @param rmMunicipio
	 *            the rmMunicipio to set
	 */
	public void setRmMunicipio(String rmMunicipio) {
		this.rmMunicipio = rmMunicipio;
	}

	/**
	 * @return the rmFecha
	 */
	public Date getRmFecha() {
		return rmFecha;
	}

	/**
	 * @param rmFecha
	 *            the rmFecha to set
	 */
	public void setRmFecha(Date rmFecha) {
		this.rmFecha = rmFecha;
	}

	/**
	 * @return the rmEstadoEnvio
	 */
	public String getRmEstadoEnvio() {
		return rmEstadoEnvio;
	}

	/**
	 * @param rmEstadoEnvio
	 *            the rmEstadoEnvio to set
	 */
	public void setRmEstadoEnvio(String rmEstadoEnvio) {
		this.rmEstadoEnvio = rmEstadoEnvio;
	}

	/**
	 * @return the rmSituacionEnviocod
	 */
	public String getRmSituacionEnviocod() {
		return rmSituacionEnviocod;
	}

	/**
	 * @param rmSituacionEnviocod
	 *            the rmSituacionEnviocod to set
	 */
	public void setRmSituacionEnviocod(String rmSituacionEnviocod) {
		this.rmSituacionEnviocod = rmSituacionEnviocod;
	}

	/**
	 * @return the rmSituacionEnvioes
	 */
	public String getRmSituacionEnvioes() {
		return rmSituacionEnvioes;
	}

	/**
	 * @param rmSituacionEnvioes
	 *            the rmSituacionEnvioes to set
	 */
	public void setRmSituacionEnvioes(String rmSituacionEnvioes) {
		this.rmSituacionEnvioes = rmSituacionEnvioes;
	}

	/**
	 * @return the rmSituacionEnvioeu
	 */
	public String getRmSituacionEnvioeu() {
		return rmSituacionEnvioeu;
	}

	/**
	 * @param rmSituacionEnvioeu
	 *            the rmSituacionEnvioeu to set
	 */
	public void setRmSituacionEnvioeu(String rmSituacionEnvioeu) {
		this.rmSituacionEnvioeu = rmSituacionEnvioeu;
	}

	/**
	 * @return the rmSituacionAcuse
	 */
	public String getRmSituacionAcuse() {
		return rmSituacionAcuse;
	}

	/**
	 * @param rmSituacionAcuse
	 *            the rmSituacionAcuse to set
	 */
	public void setRmSituacionAcuse(String rmSituacionAcuse) {
		this.rmSituacionAcuse = rmSituacionAcuse;
	}

	/**
	 * @return the rmTramitacionAcuse
	 */
	public String getRmTramitacionAcuse() {
		return rmTramitacionAcuse;
	}

	/**
	 * @param rmTramitacionAcuse
	 *            the rmTramitacionAcuse to set
	 */
	public void setRmTramitacionAcuse(String rmTramitacionAcuse) {
		this.rmTramitacionAcuse = rmTramitacionAcuse;
	}

	/**
	 * @return the rmSituacionCorreoscod
	 */
	public String getRmSituacionCorreoscod() {
		return rmSituacionCorreoscod;
	}

	/**
	 * @param rmSituacionCorreoscod
	 *            the rmSituacionCorreoscod to set
	 */
	public void setRmSituacionCorreoscod(String rmSituacionCorreoscod) {
		this.rmSituacionCorreoscod = rmSituacionCorreoscod;
	}

	/**
	 * @return the rmSituacionCorreoses
	 */
	public String getRmSituacionCorreoses() {
		return rmSituacionCorreoses;
	}

	/**
	 * @param rmSituacionCorreoses
	 *            the rmSituacionCorreoses to set
	 */
	public void setRmSituacionCorreoses(String rmSituacionCorreoses) {
		this.rmSituacionCorreoses = rmSituacionCorreoses;
	}

	/**
	 * @return the rmSituacionCorreoseu
	 */
	public String getRmSituacionCorreoseu() {
		return rmSituacionCorreoseu;
	}

	/**
	 * @param rmSituacionCorreoseu
	 *            the rmSituacionCorreoseu to set
	 */
	public void setRmSituacionCorreoseu(String rmSituacionCorreoseu) {
		this.rmSituacionCorreoseu = rmSituacionCorreoseu;
	}

	/**
	 * @return the rmIdEnvioDevueltoAA66
	 */
	public Integer getRmIdEnvioDevueltoAA66() {
		return rmIdEnvioDevueltoAA66;
	}

	/**
	 * @param rmIdEnvioDevueltoAA66
	 *            the rmIdEnvioDevueltoAA66 to set
	 */
	public void setRmIdEnvioDevueltoAA66(Integer rmIdEnvioDevueltoAA66) {
		this.rmIdEnvioDevueltoAA66 = rmIdEnvioDevueltoAA66;
	}

	/**
	 * @return the rmCodEnvioDevueltoAA66
	 */
	public String getRmCodEnvioDevueltoAA66() {
		return rmCodEnvioDevueltoAA66;
	}

	/**
	 * @param rmCodEnvioDevueltoAA66
	 *            the rmCodEnvioDevueltoAA66 to set
	 */
	public void setRmCodEnvioDevueltoAA66(String rmCodEnvioDevueltoAA66) {
		this.rmCodEnvioDevueltoAA66 = rmCodEnvioDevueltoAA66;
	}

	/**
	 * @return the rmCodigoBarras
	 */
	public String getRmCodigoBarras() {
		return rmCodigoBarras;
	}

	/**
	 * @param rmCodigoBarras
	 *            the rmCodigoBarras to set
	 */
	public void setRmCodigoBarras(String rmCodigoBarras) {
		this.rmCodigoBarras = rmCodigoBarras;
	}

	/**
	 * @return the rmDescEnvioes
	 */
	public String getRmDescEnvioes() {
		return rmDescEnvioes;
	}

	/**
	 * @param rmDescEnvioes
	 *            the rmDescEnvioes to set
	 */
	public void setRmDescEnvioes(String rmDescEnvioes) {
		this.rmDescEnvioes = rmDescEnvioes;
	}

	/**
	 * @return the rmDescEnvioeu
	 */
	public String getRmDescEnvioeu() {
		return rmDescEnvioeu;
	}

	/**
	 * @param rmDescEnvioeu
	 *            the rmDescEnvioeu to set
	 */
	public void setRmDescEnvioeu(String rmDescEnvioeu) {
		this.rmDescEnvioeu = rmDescEnvioeu;
	}

	/**
	 * @return the rmFechaActEnvio
	 */
	public Date getRmFechaActEnvio() {
		return rmFechaActEnvio;
	}

	/**
	 * @param rmFechaActEnvio
	 *            the rmFechaActEnvio to set
	 */
	public void setRmFechaActEnvio(Date rmFechaActEnvio) {
		this.rmFechaActEnvio = rmFechaActEnvio;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ rmcodigo: ").append(this.rmcodigo).append(" ]");
		result.append(", [ rmtipo: ").append(this.rmtipo).append(" ]");
		result.append(", [ rmestado: ").append(this.rmestado).append(" ]");
		result.append(", [ rmcodplantcaratula: ")
				.append(this.rmcodplantcaratula).append(" ]");
		result.append(", [ rmcodplantacuse: ").append(this.rmcodplantacuse)
				.append(" ]");
		result.append(", [ rmcodplantlistado: ").append(this.rmcodplantlistado)
				.append(" ]");
		result.append(", [ rmfechageneracion: ").append(this.rmfechageneracion)
				.append(" ]");
		result.append(", [ rmfechaemision: ").append(this.rmfechaemision)
				.append(" ]");
		result.append(", [ rmcomo: ").append(this.rmcomo).append(" ]");
		result.append(", [ rmtipoproc: ").append(this.rmtipoproc).append(" ]");
		result.append(", [ rmtramiteshechos: ").append(this.rmtramiteshechos)
				.append(" ]");
		result.append("}");
		return result.toString();
	}

}
