package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;

/**
 * Pagos  
 * 
 *  
 */

public class PagosBusqueda implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String sgcodigo;
	private Metodopago metodopago;
	private Conceptopago conceptopago;
	private Estadopago estadopago;
	private String sgreferencia;
	private String sgexpediente;
	private String excoor;
	private BigDecimal exnran;
	private BigDecimal exnror;
	private String sgidexpediente;
	private String sgcodproc;
	private Establecimiento sgestablecimiento;
	private Date sgfechaemision;
	private Date sgfechaemisiondesde;
	private Date sgfechaemisionhasta;
	private Date sgfechaestado;
	private Date sgfechalimitepago;
	private Date sgfechalimitepagodesde;
	private Date sgfechalimitepagohasta;
	private Date sgfechapago;
	private String sgfraccionado;
	private BigDecimal sgimporte;
	private String sgdescripcionpago;
	private String sgobservaciones;
	private String sgdigitocontrol;
	private String sgreferenciafracc;
	private BigDecimal sgimporteinteres;
	private Long sgnumfraccion;
	private String sgviaapremio;
	private String sgprontopago;

	/**
	 * Method 'Pagos'.
	 */
	public PagosBusqueda() {
	}

	/**
	 * Constructor
	 * 
	 * @param sgcodigo
	 *            String
	 * @param metodopago
	 *            Metodopago
	 * @param conceptopago
	 *            Conceptopago
	 * @param estadopago
	 *            Estadopago
	 * @param sgreferencia
	 *            String
	 * @param sgexpediente
	 *            String
	 * @param sgidexpediente
	 *            String
	 * @param sgcodproc
	 *            String
	 * @param sgestablecimiento
	 *            Establecimiento
	 * @param sgfechaemision
	 *            Date
	 * @param sgfechaemisiondesde
	 *            Date
	 * @param sgfechaemisionhasta
	 *            Date
	 * @param sgfechaestado
	 *            Date
	 * @param sgfechalimitepago
	 *            Date
	 * @param sgfechalimitepagodesde
	 *            Date
	 * @param sgfechalimitepagohasta
	 *            Date
	 * @param sgfechapago
	 *            Date
	 * @param sgfraccionado
	 *            String
	 * @param sgimporte
	 *            String
	 * @param sgdescripcionpago
	 *            String
	 * @param sgobservaciones
	 *            String
	 * @param sgdigitocontrol
	 *            String
	 * @param sgreferenciafracc
	 *            String
	 * @param sgimporteinteres
	 *            String
	 * @param sgnumfraccion
	 *            String
	 */
	public PagosBusqueda(String sgcodigo, Metodopago metodopago,
			Conceptopago conceptopago, Estadopago estadopago,
			String sgreferencia, String sgexpediente, String sgidexpediente,
			String sgcodproc, Establecimiento sgestablecimiento,
			Date sgfechaemision, Date sgfechaemisiondesde,
			Date sgfechaemisionhasta, Date sgfechaestado,
			Date sgfechalimitepago, Date sgfechalimitepagodesde,
			Date sgfechalimitepagohasta, Date sgfechapago,
			String sgfraccionado, BigDecimal sgimporte,
			String sgdescripcionpago, String sgobservaciones,
			String sgdigitocontrol, String sgreferenciafracc,
			BigDecimal sgimporteinteres, Long sgnumfraccion) {
		super();
		this.sgcodigo = sgcodigo;
		this.metodopago = metodopago;
		this.conceptopago = conceptopago;
		this.estadopago = estadopago;
		this.sgreferencia = sgreferencia;
		this.sgexpediente = sgexpediente;
		this.sgidexpediente = sgidexpediente;
		this.sgcodproc = sgcodproc;
		this.sgestablecimiento = sgestablecimiento;
		this.sgfechaemision = sgfechaemision;
		this.sgfechaemisiondesde = sgfechaemisiondesde;
		this.sgfechaemisionhasta = sgfechaemisionhasta;
		this.sgfechaestado = sgfechaestado;
		this.sgfechalimitepago = sgfechalimitepago;
		this.sgfechalimitepagodesde = sgfechalimitepagodesde;
		this.sgfechalimitepagohasta = sgfechalimitepagohasta;
		this.sgfechapago = sgfechapago;
		this.sgfraccionado = sgfraccionado;
		this.sgimporte = sgimporte;
		this.sgdescripcionpago = sgdescripcionpago;
		this.sgobservaciones = sgobservaciones;
		this.sgdigitocontrol = sgdigitocontrol;
		this.sgreferenciafracc = sgreferenciafracc;
		this.sgimporteinteres = sgimporteinteres;
		this.sgnumfraccion = sgnumfraccion;
	}

	/**
	 * Method 'getSgcodigo'.
	 * 
	 * @return String
	 */

	public String getSgcodigo() {
		return this.sgcodigo;
	}

	/**
	 * Method 'setSgcodigo'.
	 * 
	 * @param sgcodigo
	 *            String
	 * @return
	 */

	public void setSgcodigo(String sgcodigo) {
		this.sgcodigo = sgcodigo;
	}

	/**
	 * Method 'getMetodopago'.
	 * 
	 * @return Metodopago
	 */
	@JsonIgnore()
	public Metodopago getMetodopago() {
		return this.metodopago;
	}

	/**
	 * Method 'setMetodopago'.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @return
	 */

	public void setMetodopago(Metodopago metodopago) {
		this.metodopago = metodopago;
	}

	/**
	 * Method 'getConceptopago'.
	 * 
	 * @return Conceptopago
	 */
	@JsonIgnore()
	public Conceptopago getConceptopago() {
		return this.conceptopago;
	}

	/**
	 * Method 'setConceptopago'.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return
	 */

	public void setConceptopago(Conceptopago conceptopago) {
		this.conceptopago = conceptopago;
	}

	/**
	 * Method 'getEstadopago'.
	 * 
	 * @return Estadopago
	 */
	@JsonIgnore()
	public Estadopago getEstadopago() {
		return this.estadopago;
	}

	/**
	 * Method 'setEstadopago'.
	 * 
	 * @param estadopago
	 *            Estadopago
	 * @return
	 */

	public void setEstadopago(Estadopago estadopago) {
		this.estadopago = estadopago;
	}

	/**
	 * Method 'getSgreferencia'.
	 * 
	 * @return String
	 */

	public String getSgreferencia() {
		return this.sgreferencia;
	}

	/**
	 * Method 'setSgreferencia'.
	 * 
	 * @param sgreferencia
	 *            String
	 * @return
	 */

	public void setSgreferencia(String sgreferencia) {
		this.sgreferencia = (sgreferencia != null && sgreferencia.equals("")) ? null
				: sgreferencia;
	}

	/**
	 * Method 'getSgexpediente'.
	 * 
	 * @return String
	 */

	public String getSgexpediente() {
		return this.sgexpediente;
	}

	/**
	 * Method 'setSgexpediente'.
	 * 
	 * @param sgexpediente
	 *            String
	 * @return
	 */

	public void setSgexpediente(String sgexpediente) {
		this.sgexpediente = (sgexpediente != null && sgexpediente.equals("")) ? null
				: sgexpediente;
		;
	}

	/**
	 * Method 'getSgidexpediente'.
	 * 
	 * @return String
	 */

	public String getSgidexpediente() {
		return this.sgidexpediente;
	}

	/**
	 * Method 'setSgidexpediente'.
	 * 
	 * @param sgidexpediente
	 *            String
	 * @return
	 */

	public void setSgidexpediente(String sgidexpediente) {
		this.sgidexpediente = (sgidexpediente != null && sgidexpediente
				.equals("")) ? null : sgidexpediente;
	}

	/**
	 * Method 'getSgcodproc'.
	 * 
	 * @return String
	 */

	public String getSgcodproc() {
		return this.sgcodproc;
	}

	/**
	 * Method 'setSgcodproc'.
	 * 
	 * @param sgcodproc
	 *            String
	 * @return
	 */

	public void setSgcodproc(String sgcodproc) {
		this.sgcodproc = sgcodproc;
	}

	/**
	 * @return the sgestablecimiento
	 */
	public Establecimiento getSgestablecimiento() {
		return this.sgestablecimiento;
	}

	/**
	 * @param sgestablecimiento
	 *            the sgestablecimiento to set
	 */
	public void setSgestablecimiento(Establecimiento sgestablecimiento) {
		this.sgestablecimiento = sgestablecimiento;
	}

	/**
	 * Method 'getSgfechaemision'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getSgfechaemision() {
		return this.sgfechaemision;
	}

	/**
	 * Method 'setSgfechaemision'.
	 * 
	 * @param sgfechaemision
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setSgfechaemision(Date sgfechaemision) {
		this.sgfechaemision = sgfechaemision;
	}

	/**
	 * Method 'getSgfechaestado'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getSgfechaestado() {
		return this.sgfechaestado;
	}

	/**
	 * Method 'setSgfechaestado'.
	 * 
	 * @param sgfechaestado
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setSgfechaestado(Date sgfechaestado) {
		this.sgfechaestado = sgfechaestado;
	}

	/**
	 * Method 'getSgfechalimitepago'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getSgfechalimitepago() {
		return this.sgfechalimitepago;
	}

	/**
	 * Method 'setSgfechalimitepago'.
	 * 
	 * @param sgfechalimitepago
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setSgfechalimitepago(Date sgfechalimitepago) {
		this.sgfechalimitepago = sgfechalimitepago;
	}

	/**
	 * Method 'getSgfechapago'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getSgfechapago() {
		return this.sgfechapago;
	}

	/**
	 * Method 'setSgfechapago'.
	 * 
	 * @param sgfechapago
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setSgfechapago(Date sgfechapago) {
		this.sgfechapago = sgfechapago;
	}

	/**
	 * Method 'getSgfraccionado'.
	 * 
	 * @return String
	 */

	public String getSgfraccionado() {
		return this.sgfraccionado;
	}

	/**
	 * Method 'setSgfraccionado'.
	 * 
	 * @param sgfraccionado
	 *            String
	 * @return
	 */

	public void setSgfraccionado(String sgfraccionado) {
		this.sgfraccionado = sgfraccionado;
	}

	/**
	 * Method 'getSgimporte'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getSgimporte() {
		return this.sgimporte;
	}

	/**
	 * Method 'setSgimporte'.
	 * 
	 * @param sgimporte
	 *            BigDecimal
	 * @return
	 */

	public void setSgimporte(BigDecimal sgimporte) {
		this.sgimporte = sgimporte;
	}

	/**
	 * Method 'getSgdescripcionpago'.
	 * 
	 * @return String
	 */

	public String getSgdescripcionpago() {
		return this.sgdescripcionpago;
	}

	/**
	 * Method 'setSgdescripcionpago'.
	 * 
	 * @param sgdescripcionpago
	 *            String
	 * @return
	 */

	public void setSgdescripcionpago(String sgdescripcionpago) {
		this.sgdescripcionpago = sgdescripcionpago;
	}

	/**
	 * Method 'getSgobservaciones'.
	 * 
	 * @return String
	 */

	public String getSgobservaciones() {
		return this.sgobservaciones;
	}

	/**
	 * Method 'setSgobservaciones'.
	 * 
	 * @param sgobservaciones
	 *            String
	 * @return
	 */

	public void setSgobservaciones(String sgobservaciones) {
		this.sgobservaciones = sgobservaciones;
	}

	/**
	 * Method 'getSgdigitocontrol'.
	 * 
	 * @return String
	 */

	public String getSgdigitocontrol() {
		return this.sgdigitocontrol;
	}

	/**
	 * Method 'setSgdigitocontrol'.
	 * 
	 * @param sgdigitocontrol
	 *            String
	 * @return
	 */

	public void setSgdigitocontrol(String sgdigitocontrol) {
		this.sgdigitocontrol = sgdigitocontrol;
	}

	/**
	 * Method 'getSgreferenciafracc'.
	 * 
	 * @return String
	 */

	public String getSgreferenciafracc() {
		return this.sgreferenciafracc;
	}

	/**
	 * Method 'setSgreferenciafracc'.
	 * 
	 * @param sgreferenciafracc
	 *            String
	 * @return
	 */

	public void setSgreferenciafracc(String sgreferenciafracc) {
		this.sgreferenciafracc = sgreferenciafracc;
	}

	/**
	 * Method 'getSgimporteinteres'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getSgimporteinteres() {
		return this.sgimporteinteres;
	}

	/**
	 * Method 'setSgimporteinteres'.
	 * 
	 * @param sgimporteinteres
	 *            BigDecimal
	 * @return
	 */

	public void setSgimporteinteres(BigDecimal sgimporteinteres) {
		this.sgimporteinteres = sgimporteinteres;
	}

	/**
	 * Method 'getSgnumfraccion'.
	 * 
	 * @return Long
	 */

	public Long getSgnumfraccion() {
		return this.sgnumfraccion;
	}

	/**
	 * Method 'setSgnumfraccion'.
	 * 
	 * @param sgnumfraccion
	 *            Long
	 * @return
	 */

	public void setSgnumfraccion(Long sgnumfraccion) {
		this.sgnumfraccion = sgnumfraccion;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ sgcodigo: ").append(this.sgcodigo).append(" ]");
		result.append(", [ sgreferencia: ").append(this.sgreferencia)
				.append(" ]");
		result.append(", [ sgexpediente: ").append(this.sgexpediente)
				.append(" ]");
		result.append(", [ sgidexpediente: ").append(this.sgidexpediente)
				.append(" ]");
		result.append(", [ sgcodproc: ").append(this.sgcodproc).append(" ]");
		result.append(", [ sgestablecimiento: ").append(this.sgestablecimiento)
				.append(" ]");
		result.append(", [ sgfechaemision: ").append(this.sgfechaemision)
				.append(" ]");
		result.append(", [ sgfechaestado: ").append(this.sgfechaestado)
				.append(" ]");
		result.append(", [ sgfechalimitepago: ").append(this.sgfechalimitepago)
				.append(" ]");
		result.append(", [ sgfechapago: ").append(this.sgfechapago)
				.append(" ]");
		result.append(", [ sgfraccionado: ").append(this.sgfraccionado)
				.append(" ]");
		result.append(", [ sgimporte: ").append(this.sgimporte).append(" ]");
		result.append(", [ sgdescripcionpago: ").append(this.sgdescripcionpago)
				.append(" ]");
		result.append(", [ sgobservaciones: ").append(this.sgobservaciones)
				.append(" ]");
		result.append(", [ sgdigitocontrol: ").append(this.sgdigitocontrol)
				.append(" ]");
		result.append(", [ sgreferenciafracc: ").append(this.sgreferenciafracc)
				.append(" ]");
		result.append(", [ sgimporteinteres: ").append(this.sgimporteinteres)
				.append(" ]");
		result.append(", [ sgnumfraccion: ").append(this.sgnumfraccion)
				.append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the sgfechaemisiondesde
	 */
	public Date getSgfechaemisiondesde() {
		return this.sgfechaemisiondesde;
	}

	/**
	 * @return the sgfechaemisionhasta
	 */
	public Date getSgfechaemisionhasta() {
		return this.sgfechaemisionhasta;
	}

	/**
	 * @return the sgfechalimitepagodesde
	 */
	public Date getSgfechalimitepagodesde() {
		return this.sgfechalimitepagodesde;
	}

	/**
	 * @return the sgfechalimitepagohasta
	 */
	public Date getSgfechalimitepagohasta() {
		return this.sgfechalimitepagohasta;
	}

	/**
	 * @param sgfechaemisiondesde
	 *            the sgfechaemisiondesde to set
	 */
	public void setSgfechaemisiondesde(Date sgfechaemisiondesde) {
		this.sgfechaemisiondesde = sgfechaemisiondesde;
	}

	/**
	 * @param sgfechaemisionhasta
	 *            the sgfechaemisionhasta to set
	 */
	public void setSgfechaemisionhasta(Date sgfechaemisionhasta) {
		this.sgfechaemisionhasta = sgfechaemisionhasta;
	}

	/**
	 * @param sgfechalimitepagodesde
	 *            the sgfechalimitepagodesde to set
	 */
	public void setSgfechalimitepagodesde(Date sgfechalimitepagodesde) {
		this.sgfechalimitepagodesde = sgfechalimitepagodesde;
	}

	/**
	 * @param sgfechalimitepagohasta
	 *            the sgfechalimitepagohasta to set
	 */
	public void setSgfechalimitepagohasta(Date sgfechalimitepagohasta) {
		this.sgfechalimitepagohasta = sgfechalimitepagohasta;
	}

	/**
	 * @return the excoor
	 */
	public String getExcoor() {
		return this.excoor;
	}

	/**
	 * @param excoor
	 *            the excoor to set
	 */
	public void setExcoor(String excoor) {
		this.excoor = excoor;
	}

	/**
	 * @return the exnran
	 */
	public BigDecimal getExnran() {
		return this.exnran;
	}

	/**
	 * @param exnran
	 *            the exnran to set
	 */
	public void setExnran(BigDecimal exnran) {
		this.exnran = exnran;
	}

	/**
	 * @return the exnror
	 */
	public BigDecimal getExnror() {
		return this.exnror;
	}

	/**
	 * @param exnror
	 *            the exnror to set
	 */
	public void setExnror(BigDecimal exnror) {
		this.exnror = exnror;
	}

	/**
	 * @return the sgviaapremio
	 */
	public String getSgviaapremio() {
		return this.sgviaapremio;
	}

	/**
	 * @param sgviaapremio
	 *            the sgviaapremio to set
	 */
	public void setSgviaapremio(String sgviaapremio) {
		this.sgviaapremio = sgviaapremio;
	}

	/**
	 * @return the sgprontopago
	 */
	public String getSgprontopago() {
		return sgprontopago;
	}

	/**
	 * @param sgprontopago
	 *            the sgprontopago to set
	 */
	public void setSgprontopago(String sgprontopago) {
		this.sgprontopago = sgprontopago;
	}
}
