package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;

/**
 * Pagos  
 * 
 *  
 */

public class Pagos implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String sgcodigo;
	private Metodopago metodopago;
	private Conceptopago conceptopago;
	private Conceptopago conceptopagoInteres;
	private Estadopago estadopago;
	private String sgreferencia;
	private String sgexpediente;
	private String sgidexpediente;
	private String sgcodproc;
	private Establecimiento sgestablecimiento;
	private Date sgfechaemision;
	private Date sgfechaestado;
	private Date sgfechalimitepago;
	private Date sgfechapago;
	private String sgfraccionado;
	private BigDecimal sgimporte;
	private String sgdescripcionpago;
	private String sgobservaciones;
	private String sgdigitocontrol;
	private String sgreferenciafracc;
	private BigDecimal sgimporteinteres;
	private Long sgnumfraccion;

	private String sgimporteEuros;
	private String sgimporteinteresEuros;

	private String sgiban;
	private String sgnombretitular;

	private String sgfichero;

	private Date sgfecalta;
	private Date sgfecmodif;

	private String sgnombre;
	private String sgapellido1;
	private String sgapellido2;

	private String sgcomentarioes;
	private String sgcomentarioeu;
	private Date sgfechanot;
	private String sgaplicpresupuestaria;
	private String sgaplicpresupinteres;

	private String sgviaapremio;
	private String sgprontopago;

	// Campos para EIKA. Evolutivo: 0207107
	private String sgcodsubvencion;
	private Date sgfechareintegro;
	private String sgcausareintegro;

	/**
	 * Method 'Pagos'.
	 */
	public Pagos() {
	}

	/**
	 * Method 'Pagos'.
	 * 
	 * @param sgcodigo
	 *            String
	 * @param sgreferencia
	 *            String
	 * @param sgexpediente
	 *            String
	 * @param sgidexpediente
	 *            String
	 * @param sgcodproc
	 *            String
	 * @param sgestablecimiento
	 *            Establecimiento
	 * @param sgfechaemision
	 *            Date
	 * @param sgfechaestado
	 *            Date
	 * @param sgfechalimitepago
	 *            Date
	 * @param sgfechapago
	 *            Date
	 * @param sgfraccionado
	 *            String
	 * @param sgimporte
	 *            BigDecimal
	 * @param sgdescripcionpago
	 *            String
	 * @param sgobservaciones
	 *            String
	 * @param sgdigitocontrol
	 *            String
	 * @param sgreferenciafracc
	 *            String
	 * @param sgimporteinteres
	 *            BigDecimal
	 * @param sgnumfraccion
	 *            Long
	 * @param metodopago
	 *            Metodopago
	 * @param conceptopago
	 *            Conceptopago
	 * @param estadopago
	 *            Estadopago
	 */
	public Pagos(String sgcodigo, String sgreferencia, String sgexpediente, String sgidexpediente, String sgcodproc,
			Establecimiento sgestablecimiento, Date sgfechaemision, Date sgfechaestado, Date sgfechalimitepago,
			Date sgfechapago, String sgfraccionado, BigDecimal sgimporte, String sgdescripcionpago,
			String sgobservaciones, String sgdigitocontrol, String sgreferenciafracc, BigDecimal sgimporteinteres,
			Long sgnumfraccion, Metodopago metodopago, Conceptopago conceptopago, Estadopago estadopago) {

		this.sgcodigo = sgcodigo;
		this.metodopago = metodopago;
		this.conceptopago = conceptopago;
		this.estadopago = estadopago;
		this.sgreferencia = sgreferencia;
		this.sgexpediente = sgexpediente;
		this.sgidexpediente = sgidexpediente;
		this.sgcodproc = sgcodproc;
		this.sgestablecimiento = sgestablecimiento;
		this.sgfechaemision = sgfechaemision;
		this.sgfechaestado = sgfechaestado;
		this.sgfechalimitepago = sgfechalimitepago;
		this.sgfechapago = sgfechapago;
		this.sgfraccionado = sgfraccionado;
		this.sgimporte = sgimporte;
		this.sgdescripcionpago = sgdescripcionpago;
		this.sgobservaciones = sgobservaciones;
		this.sgdigitocontrol = sgdigitocontrol;
		this.sgreferenciafracc = sgreferenciafracc;
		this.sgimporteinteres = sgimporteinteres;
		this.sgnumfraccion = sgnumfraccion;
	}

	/**
	 * Method 'getSgcodigo'.
	 * 
	 * @return String
	 */

	public String getSgcodigo() {
		return this.sgcodigo;
	}

	/**
	 * Method 'setSgcodigo'.
	 * 
	 * @param sgcodigo
	 *            String
	 * @return
	 */

	public void setSgcodigo(String sgcodigo) {
		this.sgcodigo = sgcodigo;
	}

	/**
	 * Method 'getMetodopago'.
	 * 
	 * @return Metodopago
	 */
	public Metodopago getMetodopago() {
		return this.metodopago;
	}

	/**
	 * Method 'setMetodopago'.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @return
	 */

	public void setMetodopago(Metodopago metodopago) {
		this.metodopago = metodopago;
	}

	/**
	 * Method 'getConceptopago'.
	 * 
	 * @return Conceptopago
	 */
	public Conceptopago getConceptopago() {
		return this.conceptopago;
	}

	/**
	 * Method 'setConceptopago'.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return
	 */

	public void setConceptopago(Conceptopago conceptopago) {
		this.conceptopago = conceptopago;
	}

	/**
	 * Method 'getEstadopago'.
	 * 
	 * @return Estadopago
	 */
	public Estadopago getEstadopago() {
		return this.estadopago;
	}

	/**
	 * Method 'setEstadopago'.
	 * 
	 * @param estadopago
	 *            Estadopago
	 * @return
	 */

	public void setEstadopago(Estadopago estadopago) {
		this.estadopago = estadopago;
	}

	/**
	 * Method 'getSgreferencia'.
	 * 
	 * @return String
	 */

	public String getSgreferencia() {
		return this.sgreferencia;
	}

	/**
	 * Method 'setSgreferencia'.
	 * 
	 * @param sgreferencia
	 *            String
	 * @return
	 */

	public void setSgreferencia(String sgreferencia) {
		this.sgreferencia = sgreferencia;
	}

	/**
	 * Method 'getSgexpediente'.
	 * 
	 * @return String
	 */

	public String getSgexpediente() {
		return this.sgexpediente;
	}

	/**
	 * Method 'setSgexpediente'.
	 * 
	 * @param sgexpediente
	 *            String
	 * @return
	 */

	public void setSgexpediente(String sgexpediente) {
		this.sgexpediente = sgexpediente;
	}

	/**
	 * Method 'getSgidexpediente'.
	 * 
	 * @return String
	 */

	public String getSgidexpediente() {
		return this.sgidexpediente;
	}

	/**
	 * Method 'setSgidexpediente'.
	 * 
	 * @param sgidexpediente
	 *            String
	 * @return
	 */

	public void setSgidexpediente(String sgidexpediente) {
		this.sgidexpediente = sgidexpediente;
	}

	/**
	 * Method 'getSgcodproc'.
	 * 
	 * @return String
	 */

	public String getSgcodproc() {
		return this.sgcodproc;
	}

	/**
	 * Method 'setSgcodproc'.
	 * 
	 * @param sgcodproc
	 *            String
	 * @return
	 */

	public void setSgcodproc(String sgcodproc) {
		this.sgcodproc = sgcodproc;
	}

	/**
	 * Method 'getSgestablecimiento'.
	 * 
	 * @return Establecimiento
	 */

	public Establecimiento getSgestablecimiento() {
		return this.sgestablecimiento;
	}

	/**
	 * Method 'setSgestablecimiento'.
	 * 
	 * @param sgestablecimiento
	 *            Establecimiento
	 * @return
	 */

	public void setSgestablecimiento(Establecimiento sgestablecimiento) {
		this.sgestablecimiento = sgestablecimiento;
	}

	/**
	 * Method 'getSgfechaemision'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getSgfechaemision() {
		return this.sgfechaemision;
	}

	/**
	 * Method 'setSgfechaemision'.
	 * 
	 * @param sgfechaemision
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setSgfechaemision(Date sgfechaemision) {
		this.sgfechaemision = sgfechaemision;
	}

	/**
	 * Method 'getSgfechaestado'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getSgfechaestado() {
		return this.sgfechaestado;
	}

	/**
	 * Method 'setSgfechaestado'.
	 * 
	 * @param sgfechaestado
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setSgfechaestado(Date sgfechaestado) {
		this.sgfechaestado = sgfechaestado;
	}

	/**
	 * Method 'getSgfechalimitepago'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getSgfechalimitepago() {
		return this.sgfechalimitepago;
	}

	/**
	 * Method 'setSgfechalimitepago'.
	 * 
	 * @param sgfechalimitepago
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setSgfechalimitepago(Date sgfechalimitepago) {
		this.sgfechalimitepago = sgfechalimitepago;
	}

	/**
	 * Method 'getSgfechapago'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getSgfechapago() {
		return this.sgfechapago;
	}

	/**
	 * Method 'setSgfechapago'.
	 * 
	 * @param sgfechapago
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setSgfechapago(Date sgfechapago) {
		this.sgfechapago = sgfechapago;
	}

	/**
	 * Method 'getSgfraccionado'.
	 * 
	 * @return String
	 */

	public String getSgfraccionado() {
		return this.sgfraccionado;
	}

	/**
	 * Method 'setSgfraccionado'.
	 * 
	 * @param sgfraccionado
	 *            String
	 * @return
	 */

	public void setSgfraccionado(String sgfraccionado) {
		this.sgfraccionado = sgfraccionado;
	}

	/**
	 * Method 'getSgimporte'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getSgimporte() {
		return this.sgimporte;
	}

	/**
	 * Method 'setSgimporte'.
	 * 
	 * @param sgimporte
	 *            BigDecimal
	 * @return
	 */

	public void setSgimporte(BigDecimal sgimporte) {
		this.sgimporte = sgimporte;
	}

	/**
	 * Method 'getSgdescripcionpago'.
	 * 
	 * @return String
	 */

	public String getSgdescripcionpago() {
		return this.sgdescripcionpago;
	}

	/**
	 * Method 'setSgdescripcionpago'.
	 * 
	 * @param sgdescripcionpago
	 *            String
	 * @return
	 */

	public void setSgdescripcionpago(String sgdescripcionpago) {
		this.sgdescripcionpago = sgdescripcionpago;
	}

	/**
	 * Method 'getSgobservaciones'.
	 * 
	 * @return String
	 */

	public String getSgobservaciones() {
		return this.sgobservaciones;
	}

	/**
	 * Method 'setSgobservaciones'.
	 * 
	 * @param sgobservaciones
	 *            String
	 * @return
	 */

	public void setSgobservaciones(String sgobservaciones) {
		this.sgobservaciones = sgobservaciones;
	}

	/**
	 * Method 'getSgdigitocontrol'.
	 * 
	 * @return String
	 */

	public String getSgdigitocontrol() {
		return this.sgdigitocontrol;
	}

	/**
	 * Method 'setSgdigitocontrol'.
	 * 
	 * @param sgdigitocontrol
	 *            String
	 * @return
	 */

	public void setSgdigitocontrol(String sgdigitocontrol) {
		this.sgdigitocontrol = sgdigitocontrol;
	}

	/**
	 * Method 'getSgreferenciafracc'.
	 * 
	 * @return String
	 */

	public String getSgreferenciafracc() {
		return this.sgreferenciafracc;
	}

	/**
	 * Method 'setSgreferenciafracc'.
	 * 
	 * @param sgreferenciafracc
	 *            String
	 * @return
	 */

	public void setSgreferenciafracc(String sgreferenciafracc) {
		this.sgreferenciafracc = sgreferenciafracc;
	}

	/**
	 * Method 'getSgimporteinteres'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getSgimporteinteres() {
		return this.sgimporteinteres;
	}

	/**
	 * Method 'setSgimporteinteres'.
	 * 
	 * @param sgimporteinteres
	 *            BigDecimal
	 * @return
	 */

	public void setSgimporteinteres(BigDecimal sgimporteinteres) {
		this.sgimporteinteres = sgimporteinteres;
	}

	/**
	 * Method 'getSgnumfraccion'.
	 * 
	 * @return Long
	 */

	public Long getSgnumfraccion() {
		return this.sgnumfraccion;
	}

	/**
	 * Method 'setSgnumfraccion'.
	 * 
	 * @param sgnumfraccion
	 *            Long
	 * @return
	 */

	public void setSgnumfraccion(Long sgnumfraccion) {
		this.sgnumfraccion = sgnumfraccion;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ sgcodigo: ").append(this.sgcodigo).append(" ]");
		result.append(", [ sgreferencia: ").append(this.sgreferencia).append(" ]");
		result.append(", [ sgexpediente: ").append(this.sgexpediente).append(" ]");
		result.append(", [ sgidexpediente: ").append(this.sgidexpediente).append(" ]");
		result.append(", [ sgcodproc: ").append(this.sgcodproc).append(" ]");
		result.append(", [ sgidestablecimiento: ").append(this.sgestablecimiento).append(" ]");
		result.append(", [ sgfechaemision: ").append(this.sgfechaemision).append(" ]");
		result.append(", [ sgfechaestado: ").append(this.sgfechaestado).append(" ]");
		result.append(", [ sgfechalimitepago: ").append(this.sgfechalimitepago).append(" ]");
		result.append(", [ sgfechapago: ").append(this.sgfechapago).append(" ]");
		result.append(", [ sgfraccionado: ").append(this.sgfraccionado).append(" ]");
		result.append(", [ sgimporte: ").append(this.sgimporte).append(" ]");
		result.append(", [ sgdescripcionpago: ").append(this.sgdescripcionpago).append(" ]");
		result.append(", [ sgobservaciones: ").append(this.sgobservaciones).append(" ]");
		result.append(", [ sgdigitocontrol: ").append(this.sgdigitocontrol).append(" ]");
		result.append(", [ sgreferenciafracc: ").append(this.sgreferenciafracc).append(" ]");
		result.append(", [ sgimporteinteres: ").append(this.sgimporteinteres).append(" ]");
		result.append(", [ sgnumfraccion: ").append(this.sgnumfraccion).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the sgimporteEuros
	 */
	public String getSgimporteEuros() {
		return this.sgimporteEuros;
	}

	/**
	 * @param sgimporteEuros
	 *            the sgimporteEuros to set
	 */
	public void setSgimporteEuros(String sgimporteEuros) {
		this.sgimporteEuros = sgimporteEuros;
	}

	/**
	 * @return the sgiban
	 */
	public String getSgiban() {
		return this.sgiban;
	}

	/**
	 * @param sgiban
	 *            the sgiban to set
	 */
	public void setSgiban(String sgiban) {
		this.sgiban = sgiban;
	}

	/**
	 * @return the sgnombretitular
	 */
	public String getSgnombretitular() {
		return this.sgnombretitular;
	}

	/**
	 * @param sgnombretitular
	 *            the sgnombretitular to set
	 */
	public void setSgnombretitular(String sgnombretitular) {
		this.sgnombretitular = sgnombretitular;
	}

	/**
	 * @return the sgfichero
	 */
	public String getSgfichero() {
		return this.sgfichero;
	}

	/**
	 * @param sgfichero
	 *            the sgfichero to set
	 */
	public void setSgfichero(String sgfichero) {
		this.sgfichero = sgfichero;
	}

	/**
	 * @return the sgfecalta
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getSgfecalta() {
		return this.sgfecalta;
	}

	/**
	 * @param sgfecalta
	 *            the sgfecalta to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setSgfecalta(Date sgfecalta) {
		this.sgfecalta = sgfecalta;
	}

	/**
	 * @return the sgfecmodif
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getSgfecmodif() {
		return this.sgfecmodif;
	}

	/**
	 * @param sgfecmodif
	 *            the sgfecmodif to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setSgfecmodif(Date sgfecmodif) {
		this.sgfecmodif = sgfecmodif;
	}

	/**
	 * @return the sgnombre
	 */
	public String getSgnombre() {
		return this.sgnombre;
	}

	/**
	 * @param sgnombre
	 *            the sgnombre to set
	 */
	public void setSgnombre(String sgnombre) {
		this.sgnombre = sgnombre;
	}

	/**
	 * @return the sgapellido1
	 */
	public String getSgapellido1() {
		return this.sgapellido1;
	}

	/**
	 * @param sgapellido1
	 *            the sgapellido1 to set
	 */
	public void setSgapellido1(String sgapellido1) {
		this.sgapellido1 = sgapellido1;
	}

	/**
	 * @return the sgapellido2
	 */
	public String getSgapellido2() {
		return this.sgapellido2;
	}

	/**
	 * @param sgapellido2
	 *            the sgapellido2 to set
	 */
	public void setSgapellido2(String sgapellido2) {
		this.sgapellido2 = sgapellido2;
	}

	/**
	 * @return the sgcomentarioes
	 */
	public String getSgcomentarioes() {
		return this.sgcomentarioes;
	}

	/**
	 * @param sgcomentarioes
	 *            the sgcomentarioes to set
	 */
	public void setSgcomentarioes(String sgcomentarioes) {
		this.sgcomentarioes = sgcomentarioes;
	}

	/**
	 * @return the sgcomentarioeu
	 */
	public String getSgcomentarioeu() {
		return this.sgcomentarioeu;
	}

	/**
	 * @param sgcomentarioeu
	 *            the sgcomentarioeu to set
	 */
	public void setSgcomentarioeu(String sgcomentarioeu) {
		this.sgcomentarioeu = sgcomentarioeu;
	}

	/**
	 * @return the sgfechanot
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getSgfechanot() {
		return this.sgfechanot;
	}

	/**
	 * @param sgfechanot
	 *            the sgfechanot to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setSgfechanot(Date sgfechanot) {
		this.sgfechanot = sgfechanot;
	}

	/**
	 * @return the sgaplicpresupuestaria
	 */
	public String getSgaplicpresupuestaria() {
		return this.sgaplicpresupuestaria;
	}

	/**
	 * @param sgaplicpresupuestaria
	 *            the sgaplicpresupuestaria to set
	 */
	public void setSgaplicpresupuestaria(String sgaplicpresupuestaria) {
		this.sgaplicpresupuestaria = sgaplicpresupuestaria;
	}

	/**
	 * @return the sgimporteinteresEuros
	 */
	public String getSgimporteinteresEuros() {
		return this.sgimporteinteresEuros;
	}

	/**
	 * @param sgimporteinteresEuros
	 *            the sgimporteinteresEuros to set
	 */
	public void setSgimporteinteresEuros(String sgimporteinteresEuros) {
		this.sgimporteinteresEuros = sgimporteinteresEuros;
	}

	/**
	 * @return the sgaplicpresupinteres
	 */
	public String getSgaplicpresupinteres() {
		return this.sgaplicpresupinteres;
	}

	/**
	 * @param sgaplicpresupinteres
	 *            the sgaplicpresupinteres to set
	 */
	public void setSgaplicpresupinteres(String sgaplicpresupinteres) {
		this.sgaplicpresupinteres = sgaplicpresupinteres;
	}

	/**
	 * @return the conceptopagoInteres
	 */
	public Conceptopago getConceptopagoInteres() {
		return this.conceptopagoInteres;
	}

	/**
	 * @param conceptopagoInteres
	 *            the conceptopagoInteres to set
	 */
	public void setConceptopagoInteres(Conceptopago conceptopagoInteres) {
		this.conceptopagoInteres = conceptopagoInteres;
	}

	/**
	 * @return the sgviaapremio
	 */
	public String getSgviaapremio() {
		return this.sgviaapremio;
	}

	/**
	 * @param sgviaapremio
	 *            the sgviaapremio to set
	 */
	public void setSgviaapremio(String sgviaapremio) {
		this.sgviaapremio = sgviaapremio;
	}

	/**
	 * @return the sgprontopago
	 */
	public String getSgprontopago() {
		return sgprontopago;
	}

	/**
	 * @param sgprontopago
	 *            the sgprontopago to set
	 */
	public void setSgprontopago(String sgprontopago) {
		this.sgprontopago = sgprontopago;
	}

	/**
	 * @return the sgcodsubvencion
	 */
	public String getSgcodsubvencion() {
		return sgcodsubvencion;
	}

	/**
	 * @param sgcodsubvencion
	 *            the sgcodsubvencion to set
	 */
	public void setSgcodsubvencion(String sgcodsubvencion) {
		this.sgcodsubvencion = sgcodsubvencion;
	}

	/**
	 * @return the sgfechareintegro
	 */
	public Date getSgfechareintegro() {
		return sgfechareintegro;
	}

	/**
	 * @param sgfechareintegro
	 *            the sgfechareintegro to set
	 */
	public void setSgfechareintegro(Date sgfechareintegro) {
		this.sgfechareintegro = sgfechareintegro;
	}

	/**
	 * @return the sgcausareintegro
	 */
	public String getSgcausareintegro() {
		return sgcausareintegro;
	}

	/**
	 * @param sgcausareintegro
	 *            the sgcausareintegro to set
	 */
	public void setSgcausareintegro(String sgcausareintegro) {
		this.sgcausareintegro = sgcausareintegro;
	}

}
