package com.ejie.y41b.model;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

/**
 * * TramiteRegistroSolicitud  
 * 
 *  
 */

public class NotificacionesComunicacionesBusqueda implements
		java.io.Serializable {

	private static final long serialVersionUID = 1L;
	/* Criterios de busqueda */
	private String rmcodigo;
	private String rmtipo;
	private String rmcomo;
	private Date rmfecha;
	private String rmtipoExpediente;
	private String rmorganico;
	private String rmcapv;

	/* Resultados busqueda */
	private String modoRemesa;

	// Tramite de notificacion o comunicacion
	private String trcodigo;
	private String idTramite;
	private String codExpediente;
	private String numExpediente;
	private String decoor;
	private String denran;
	private BigDecimal denror;
	private BigDecimal hdnror;
	private Date ehfechainicio;
	private String ehfecharegistrosalidacas;
	private String ehfecharegistrosalidaeus;
	private String ehnumregistrosalida;
	private String acto;
	private String asunto;
	private String ehestadotramite; // j

	// Responsable del expediente
	private String mocodigoExpediente;
	private String monombre;
	private String usuarioXlNet;
	private String puestoXlNet;

	// Destinatario de la notificacion o comunicacion
	private String idInterviniente;
	private String nif;
	private String nombreDestinatario;
	private String nombreComercialDestinatario;
	private String extranjero;
	private String nombre_Provincia;
	private String nombre_Municipio;
	private String nombre_Localidad;
	private String nombre_Calle;
	private String nombre_CP;
	private String nombre_Portal;
	private String nombre_Piso;
	private String nombre_Pais;
	private String direccionNocapv;
	private String direccionAntigua;
	private String direccion1;
	private String direccion2;
	private InputStream codigoBarras;
	private InputStream codigoBarrasCaratula;

	private String ehsede;
	// Codigo del establecimiento
	private String escodigo;
	// Datos de documento_hecho
	private String q5coddoc;
	private Blob q5datafile;
	private String q5iddocumentum;

	// Hecho Denunciado
	private String hdcodigo;

	// Organismo
	private String codOrg;
	private String nombreEs;
	private String nombreEu;
	private String noraProvinciaId;
	private String nombreProvincia;
	private String noraMunicipioId;
	private String nombreMunicipio;
	private String noraLocalidadId;
	private String nombreLocalidad;
	private String noraCalleId;
	private String nombreCalle;
	private String noraCpId;
	private String nombreCp;
	private String noraPortalId;
	private String nombrePortal;
	private String direccionOrganismo;
	private String cpMunicipioOrganismo;
	private String telefonoOrganismo;
	private String faxOrganismo;
	private String emailOrganismo;
	private String webOrganismo;
	private String piePaginaLinea1;
	private String piePaginaLinea2;

	private String tipoInterviniente;

	// Tabla Envo por remesas
	private String envcestado;
	private String envcdeserrores;
	private String envcdeserroreu;
	private Integer envcidenvio;
	private String envccodSitCorreos;
	private String envcdessitcorreoseu;
	private String envcdessitcorreoses;

	private Date envfechaactualizacion; // j
	private String envcodbarras; // j

	// Comprobacin de compatibilidad AA66
	private boolean compatibleAA66;

	// Acuse de recibo asociado (En caso de notificaciones y notificaciones
	// electrnicas)
	private String idTramiteAcuseRelacionado;
	private String ehacusereciborecibido;

	private String tipoProcedimiento;

	/**
	 * 
	 */
	public NotificacionesComunicacionesBusqueda() {
		super();
	}

	/**
	 * Method 'NotificacionesComunicacionesBusqueda'.
	 * 
	 * @param idTramite
	 *            String
	 * 
	 * @param rmcodigo
	 *            String
	 * @param rmtipo
	 *            String
	 * @param rmcomo
	 *            String
	 * @param rmfecha
	 *            Date
	 * @param rmtipoExpediente
	 *            String
	 * @param rmorganico
	 *            String
	 * @param rmcapv
	 *            String
	 * 
	 * @param numExpediente
	 *            String
	 * @param decoor
	 *            String
	 * @param denran
	 *            BigDecimal
	 * @param denror
	 *            BigDecimal
	 * @param hdnror
	 *            BigDecimal
	 * @param ehfechainicio
	 *            Date
	 * @param ehnumregistrosalida
	 *            String
	 * @param acto
	 *            String
	 * @param mocodigoExpediente
	 *            String
	 * @param monombre
	 *            String
	 * @param idInterviniente
	 *            String
	 * @param nif
	 *            String
	 * @param nombreInterviniente
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param nombre_CP
	 *            String
	 * @param codOrg
	 * @param nombreEs
	 * @param nombreEu
	 * @param noraProvinciaId
	 * @param nombreProvincia
	 * @param noraMunicipioId
	 * @param nombreMunicipio
	 * @param noraLocalidadId
	 * @param nombreLocalidad
	 * @param noraCalleId
	 * @param nombreCalle
	 * @param noraCpId
	 * @param nombreCp
	 * @param noraPortalId
	 * @param nombrePortal
	 * @param telefonoOrganismo
	 * @param faxOrganismo
	 * @param emailOrganismo
	 * @param webOrganismo
	 */
	public NotificacionesComunicacionesBusqueda(String idTramite,
			String codExpediente, String decoor, String denran,
			BigDecimal denror, BigDecimal hdnror, Date ehfechainicio,
			String ehnumregistrosalida, String acto, String mocodigoExpediente,
			String monombre, String idInterviniente, String nif,
			String nombreInterviniente, String extranjero,
			String nombreProvincia, String nombreMunicipio,
			String nombreLocalidad, String nombre_CP, String nombreCalle,
			String nombrePortal, String nombrePiso, String nombrePais,
			String direccionNoCapv, String direccionAntigua, String direccion1,
			String direccion2, String asunto, String ehsede, String escodigo,
			String hdcodigo, String codOrg, String nombreEs, String nombreEu,
			String noraProvinciaId, String nombreProvinciaOrg,
			String noraMunicipioId, String nombreMunicipioOrg,
			String noraLocalidadId, String nombreLocalidadOrg,
			String noraCalleId, String nombreCalleOrg, String noraCpId,
			String nombreCp, String noraPortalId, String nombrePortalOrg,
			String telefonoOrganismo, String faxOrganismo,
			String emailOrganismo, String webOrganismo) {
		super();
		this.idTramite = idTramite;
		this.codExpediente = codExpediente;
		this.decoor = decoor;
		this.denran = denran;
		this.denror = denror;
		this.hdnror = hdnror;
		this.ehfechainicio = ehfechainicio;
		this.ehnumregistrosalida = ehnumregistrosalida;
		this.acto = acto;
		this.mocodigoExpediente = mocodigoExpediente;
		this.monombre = monombre;
		this.idInterviniente = idInterviniente;
		this.nif = nif;
		this.nombreDestinatario = nombreInterviniente;
		this.extranjero = extranjero;
		this.nombre_Provincia = nombreProvincia;
		this.nombre_Municipio = nombreMunicipio;
		this.nombre_Localidad = nombreLocalidad;
		this.nombre_CP = nombre_CP;
		this.nombre_Calle = nombreCalle;
		this.nombre_Portal = nombrePortal;
		this.nombre_Piso = nombrePiso;
		this.nombre_Pais = nombrePais;
		this.direccionNocapv = direccionNoCapv;
		this.direccionAntigua = direccionAntigua;
		this.direccion1 = direccion1;
		this.direccion2 = direccion2;
		this.asunto = asunto;
		this.ehsede = ehsede;
		this.escodigo = escodigo;
		this.hdcodigo = hdcodigo;

		this.codOrg = codOrg;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.noraProvinciaId = noraProvinciaId;
		this.nombreProvincia = nombreProvinciaOrg;
		this.noraMunicipioId = noraMunicipioId;
		this.nombreMunicipio = nombreMunicipioOrg;
		this.noraLocalidadId = noraLocalidadId;
		this.nombreLocalidad = nombreLocalidadOrg;
		this.noraCalleId = noraCalleId;
		this.nombreCalle = nombreCalleOrg;
		this.noraCpId = noraCpId;
		this.nombreCp = nombreCp;
		this.noraPortalId = noraPortalId;
		this.nombrePortal = nombrePortalOrg;
		this.telefonoOrganismo = telefonoOrganismo;
		this.faxOrganismo = faxOrganismo;
		this.emailOrganismo = emailOrganismo;
		this.webOrganismo = webOrganismo;
	}

	public NotificacionesComunicacionesBusqueda(String idTramite,
			String codExpediente, String decoor, String denran,
			BigDecimal denror, BigDecimal hdnror, Date ehfechainicio,
			String ehnumregistrosalida, String acto, String mocodigoExpediente,
			String monombre, String idInterviniente, String nif,
			String nombreInterviniente, String nombreComercialInterviniente,
			String extranjero, String nombreProvincia, String nombreMunicipio,
			String nombreLocalidad, String nombre_CP, String nombreCalle,
			String nombrePortal, String nombrePiso, String nombrePais,
			String direccionNoCapv, String direccionAntigua, String direccion1,
			String direccion2, String asunto, String ehestadotramite,
			String ehsede, String escodigo, String hdcodigo, String codOrg,
			String nombreEs, String nombreEu, String noraProvinciaId,
			String nombreProvinciaOrg, String noraMunicipioId,
			String nombreMunicipioOrg, String noraLocalidadId,
			String nombreLocalidadOrg, String noraCalleId,
			String nombreCalleOrg, String noraCpId, String nombreCp,
			String noraPortalId, String nombrePortalOrg,
			String telefonoOrganismo, String faxOrganismo,
			String emailOrganismo, String webOrganismo, String trcodigo,
			String tipoInterviniente, String usuarioXlNet, String puestoXlNet,
			String envcestado, String envcdeserrores, String envcdeserroreu,
			Integer envcidenvio, String envccodSitCorreos,
			String envcdessitcorreoses, String envcdessitcorreoseu,
			Date envfechaactualizacion, String envcodbarras,
			String idTramiteAcuseRelacionado, String ehacusereciborecibido) {
		super();
		this.usuarioXlNet = usuarioXlNet;
		this.puestoXlNet = puestoXlNet;
		this.trcodigo = trcodigo;
		this.tipoInterviniente = tipoInterviniente;
		this.envcestado = envcestado;
		this.envcdeserrores = envcdeserrores;
		this.envcdeserroreu = envcdeserroreu;
		this.envcidenvio = envcidenvio;
		this.envccodSitCorreos = envccodSitCorreos;
		this.envcdessitcorreoses = envcdessitcorreoses;
		this.envcdessitcorreoseu = envcdessitcorreoseu;

		this.envfechaactualizacion = envfechaactualizacion;
		this.envcodbarras = envcodbarras;

		this.idTramiteAcuseRelacionado = idTramiteAcuseRelacionado;
		this.ehacusereciborecibido = ehacusereciborecibido;
		this.idTramite = idTramite;
		this.codExpediente = codExpediente;
		this.decoor = decoor;
		this.denran = denran;
		this.denror = denror;
		this.hdnror = hdnror;
		this.ehfechainicio = ehfechainicio;
		this.ehnumregistrosalida = ehnumregistrosalida;
		this.acto = acto;
		this.mocodigoExpediente = mocodigoExpediente;
		this.monombre = monombre;
		this.idInterviniente = idInterviniente;
		this.nif = nif;
		this.nombreDestinatario = nombreInterviniente;
		this.nombreComercialDestinatario = nombreComercialInterviniente;
		this.extranjero = extranjero;
		this.nombre_Provincia = nombreProvincia;
		this.nombre_Municipio = nombreMunicipio;
		this.nombre_Localidad = nombreLocalidad;
		this.nombre_CP = nombre_CP;
		this.nombre_Calle = nombreCalle;
		this.nombre_Portal = nombrePortal;
		this.nombre_Piso = nombrePiso;
		this.nombre_Pais = nombrePais;
		this.direccionNocapv = direccionNoCapv;
		this.direccionAntigua = direccionAntigua;
		this.direccion1 = direccion1;
		this.direccion2 = direccion2;
		this.asunto = asunto;
		this.ehestadotramite = ehestadotramite;
		this.ehsede = ehsede;
		this.escodigo = escodigo;
		this.hdcodigo = hdcodigo;

		this.codOrg = codOrg;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.noraProvinciaId = noraProvinciaId;
		this.nombreProvincia = nombreProvinciaOrg;
		this.noraMunicipioId = noraMunicipioId;
		this.nombreMunicipio = nombreMunicipioOrg;
		this.noraLocalidadId = noraLocalidadId;
		this.nombreLocalidad = nombreLocalidadOrg;
		this.noraCalleId = noraCalleId;
		this.nombreCalle = nombreCalleOrg;
		this.noraCpId = noraCpId;
		this.nombreCp = nombreCp;
		this.noraPortalId = noraPortalId;
		this.nombrePortal = nombrePortalOrg;
		this.telefonoOrganismo = telefonoOrganismo;
		this.faxOrganismo = faxOrganismo;
		this.emailOrganismo = emailOrganismo;
		this.webOrganismo = webOrganismo;
	}

	public NotificacionesComunicacionesBusqueda(String rmcodigo,
			String ehcodigo, String codDoc, Blob docfile, String q5iddocumentum) {
		super();

		this.rmcodigo = rmcodigo;
		this.codExpediente = ehcodigo;
		this.q5coddoc = codDoc;
		this.q5datafile = docfile;
		this.q5iddocumentum = q5iddocumentum;
	}

	/**
	 * @return the ehacusereciborecibido
	 */
	public String getEhacusereciborecibido() {
		return ehacusereciborecibido;
	}

	/**
	 * @param ehacusereciborecibido
	 *            the ehacusereciborecibido to set
	 */
	public void setEhacusereciborecibido(String ehacusereciborecibido) {
		this.ehacusereciborecibido = ehacusereciborecibido;
	}

	/**
	 * @return the idTramiteAcuseRelacionado
	 */
	public String getIdTramiteAcuseRelacionado() {
		return idTramiteAcuseRelacionado;
	}

	/**
	 * @param idTramiteAcuseRelacionado
	 *            the idTramiteAcuseRelacionado to set
	 */
	public void setIdTramiteAcuseRelacionado(String idTramiteAcuseRelacionado) {
		this.idTramiteAcuseRelacionado = idTramiteAcuseRelacionado;
	}

	/**
	 * @return the modoRemesa
	 */
	public String getModoRemesa() {
		return modoRemesa;
	}

	/**
	 * @param modoRemesa
	 *            the modoRemesa to set
	 */
	public void setModoRemesa(String modoRemesa) {
		this.modoRemesa = modoRemesa;
	}

	/**
	 * @return the envcdessitcorreoseu
	 */
	public String getEnvcdessitcorreoseu() {
		return envcdessitcorreoseu;
	}

	/**
	 * @param envcdessitcorreoseu
	 *            the envcdessitcorreoseu to set
	 */
	public void setEnvcdessitcorreoseu(String envcdessitcorreoseu) {
		this.envcdessitcorreoseu = envcdessitcorreoseu;
	}

	/**
	 * @return the envcdessitcorreoses
	 */
	public String getEnvcdessitcorreoses() {
		return envcdessitcorreoses;
	}

	/**
	 * @param envcdessitcorreoses
	 *            the envcdessitcorreoses to set
	 */
	public void setEnvcdessitcorreoses(String envcdessitcorreoses) {
		this.envcdessitcorreoses = envcdessitcorreoses;
	}

	/**
	 * @return the envccodSitCorreos
	 */
	public String getEnvccodSitCorreos() {
		return envccodSitCorreos;
	}

	/**
	 * @param envccodSitCorreos
	 *            the envccodSitCorreos to set
	 */
	public void setEnvccodSitCorreos(String envccodSitCorreos) {
		this.envccodSitCorreos = envccodSitCorreos;
	}

	/**
	 * @return the compatibleAA66
	 */
	public boolean isCompatibleAA66() {
		return compatibleAA66;
	}

	/**
	 * @param compatibleAA66
	 *            the compatibleAA66 to set
	 */
	public void setCompatibleAA66(boolean compatibleAA66) {
		this.compatibleAA66 = compatibleAA66;
	}

	/**
	 * @return the envcidenvio
	 */
	public Integer getEnvcidenvio() {
		return envcidenvio;
	}

	/**
	 * @param envcidenvio
	 *            the envcidenvio to set
	 */
	public void setEnvcidenvio(Integer envcidenvio) {
		this.envcidenvio = envcidenvio;
	}

	/**
	 * @return the envcdeserrores
	 */
	public String getEnvcdeserrores() {
		return envcdeserrores;
	}

	/**
	 * @param envcdeserrores
	 *            the envcdeserrores to set
	 */
	public void setEnvcdeserrores(String envcdeserrores) {
		this.envcdeserrores = envcdeserrores;
	}

	/**
	 * @return the envcdeserroreu
	 */
	public String getEnvcdeserroreu() {
		return envcdeserroreu;
	}

	/**
	 * @param envcdeserroreu
	 *            the envcdeserroreu to set
	 */
	public void setEnvcdeserroreu(String envcdeserroreu) {
		this.envcdeserroreu = envcdeserroreu;
	}

	/**
	 * @return the usuarioXlNet
	 */
	public String getUsuarioXlNet() {
		return usuarioXlNet;
	}

	/**
	 * @param usuarioXlNet
	 *            the usuarioXlNet to set
	 */
	public void setUsuarioXlNet(String usuarioXlNet) {
		this.usuarioXlNet = usuarioXlNet;
	}

	/**
	 * @return the puestoXlNet
	 */
	public String getPuestoXlNet() {
		return puestoXlNet;
	}

	/**
	 * @param puestoXlNet
	 *            the puestoXlNet to set
	 */
	public void setPuestoXlNet(String puestoXlNet) {
		this.puestoXlNet = puestoXlNet;
	}

	/**
	 * Method 'getRmcodigo'.
	 * 
	 * @return String
	 */

	public String getRmcodigo() {
		return this.rmcodigo;
	}

	/**
	 * @param rmcodigo
	 *            the rmcodigo to set
	 */
	public void setRmcodigo(String rmcodigo) {
		this.rmcodigo = rmcodigo;
	}

	/**
	 * @return the rmtipo
	 */
	public String getRmtipo() {
		return rmtipo;
	}

	/**
	 * @param rmtipo
	 *            the rmtipo to set
	 */
	public void setRmtipo(String rmtipo) {
		this.rmtipo = rmtipo;
	}

	/**
	 * @return the rmcomo
	 */
	public String getRmcomo() {
		return rmcomo;
	}

	/**
	 * @param rmcomo
	 *            the rmcomo to set
	 */
	public void setRmcomo(String rmcomo) {
		this.rmcomo = rmcomo;
	}

	/**
	 * @return the rmfecha
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getRmfecha() {
		return rmfecha;
	}

	/**
	 * @param rmfecha
	 *            the rmfecha to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setRmfecha(Date rmfecha) {
		this.rmfecha = rmfecha;
	}

	/**
	 * @return the rmtipoExpediente
	 */
	public String getRmtipoExpediente() {
		return rmtipoExpediente;
	}

	/**
	 * @param rmtipoExpediente
	 *            the rmtipoExpediente to set
	 */
	public void setRmtipoExpediente(String rmtipoExpediente) {
		this.rmtipoExpediente = rmtipoExpediente;
	}

	/**
	 * @return the rmorganico
	 */
	public String getRmorganico() {
		return rmorganico;
	}

	/**
	 * @param rmorganico
	 *            the rmorganico to set
	 */
	public void setRmorganico(String rmorganico) {
		this.rmorganico = rmorganico;
	}

	/**
	 * @return the rmcapv
	 */
	public String isRmcapv() {
		return rmcapv;
	}

	/**
	 * @param rmcapv
	 *            the rmcapv to set
	 */
	public void setRmcapv(String rmcapv) {
		this.rmcapv = rmcapv;
	}

	/**
	 * @return the idTramite
	 */
	public String getIdTramite() {
		return idTramite;
	}

	/**
	 * @param idTramite
	 *            the idTramite to set
	 */
	public void setIdTramite(String idTramite) {
		this.idTramite = idTramite;
	}

	/**
	 * @return the codExpediente
	 */
	public String getCodExpediente() {
		return codExpediente;
	}

	/**
	 * @param codExpediente
	 *            the codExpediente to set
	 */
	public void setCodExpediente(String codExpediente) {
		this.codExpediente = codExpediente;
	}

	/**
	 * @return the numExpediente
	 */
	public String getNumExpediente() {
		return numExpediente;
	}

	/**
	 * @param numExpediente
	 *            the numExpediente to set
	 */
	public void setNumExpediente(String numExpediente) {
		this.numExpediente = numExpediente;
	}

	/**
	 * @return the decoor
	 */
	public String getDecoor() {
		return decoor;
	}

	/**
	 * @param decoor
	 *            the decoor to set
	 */
	public void setDecoor(String decoor) {
		this.decoor = decoor;
	}

	/**
	 * @return the denran
	 */
	public String getDenran() {
		return denran;
	}

	/**
	 * @param denran
	 *            the denran to set
	 */
	public void setDenran(String denran) {
		this.denran = denran;
	}

	/**
	 * @return the denror
	 */
	public BigDecimal getDenror() {
		return denror;
	}

	/**
	 * @param denror
	 *            the denror to set
	 */
	public void setDenror(BigDecimal denror) {
		this.denror = denror;
	}

	/**
	 * @return the hdnror
	 */
	public BigDecimal getHdnror() {
		return hdnror;
	}

	/**
	 * @param hdnror
	 *            the hdnror to set
	 */
	public void setHdnror(BigDecimal hdnror) {
		this.hdnror = hdnror;
	}

	/**
	 * @return the fechaTramite
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getEhfechainicio() {
		return ehfechainicio;
	}

	/**
	 * @param ehfechainicio
	 *            the fechaTramite to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setEhfechainicio(Date ehfechainicio) {
		this.ehfechainicio = ehfechainicio;
	}

	/**
	 * @return the acto
	 */
	public String getActo() {
		return acto;
	}

	/**
	 * @param acto
	 *            the acto to set
	 */
	public void setActo(String acto) {
		this.acto = acto;
	}

	/**
	 * @return the asunto
	 */
	public String getAsunto() {
		return asunto;
	}

	/**
	 * @param asunto
	 *            the asunto to set
	 */
	public void setAsunto(String asunto) {
		this.asunto = asunto;
	}

	/**
	 * @return the mocodigoExpediente
	 */
	public String getMocodigoExpediente() {
		return mocodigoExpediente;
	}

	/**
	 * @param mocodigoExpediente
	 *            the mocodigoExpediente to set
	 */
	public void setMocodigoExpediente(String mocodigoExpediente) {
		this.mocodigoExpediente = mocodigoExpediente;
	}

	/**
	 * @return the monombreExpediente
	 */
	public String getMonombre() {
		return monombre;
	}

	/**
	 * @param monombre
	 *            the monombreExpediente to set
	 */
	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * @return the idInterviniente
	 */
	public String getIdInterviniente() {
		return idInterviniente;
	}

	/**
	 * @param idInterviniente
	 *            the idInterviniente to set
	 */
	public void setIdInterviniente(String idInterviniente) {
		this.idInterviniente = idInterviniente;
	}

	/**
	 * @return the nombreDestinatario
	 */
	public String getNombreDestinatario() {
		return nombreDestinatario;
	}

	/**
	 * @param nombreDestinatario
	 *            the nombreDestinatario to set
	 */
	public void setNombreDestinatario(String nombreDestinatario) {
		this.nombreDestinatario = nombreDestinatario;
	}

	/**
	 * @return the nombreProvincia
	 */
	public String getNombre_Provincia() {
		return nombre_Provincia;
	}

	/**
	 * @param nombre_Provincia
	 *            the nombreProvincia to set
	 */
	public void setNombre_Provincia(String nombre_Provincia) {
		this.nombre_Provincia = nombre_Provincia;
	}

	/**
	 * @return the nombreMunicipio
	 */
	public String getNombre_Municipio() {
		return nombre_Municipio;
	}

	/**
	 * @param nombre_Municipio
	 *            the nombreMunicipio to set
	 */
	public void setNombre_Municipio(String nombre_Municipio) {
		this.nombre_Municipio = nombre_Municipio;
	}

	/**
	 * @return the codigoPostal
	 */
	public String getNombre_CP() {
		return nombre_CP;
	}

	/**
	 * @param nombre_CP
	 *            the codigoPostal to set
	 */
	public void setNombre_CP(String nombre_CP) {
		this.nombre_CP = nombre_CP;
	}

	/**
	 * @return the direccion1
	 */
	public String getDireccion1() {
		return direccion1;
	}

	/**
	 * @param direccion1
	 *            the direccion1 to set
	 */
	public void setDireccion1(String direccion1) {
		this.direccion1 = direccion1;
	}

	/**
	 * @return the direccion2
	 */
	public String getDireccion2() {
		return direccion2;
	}

	/**
	 * @param direccion2
	 *            the direccion2 to set
	 */
	public void setDireccion2(String direccion2) {
		this.direccion2 = direccion2;
	}

	/**
	 * @return the codigoBarras
	 */
	public InputStream getCodigoBarras() {
		return codigoBarras;
	}

	/**
	 * @param codigoBarras
	 *            the codigoBarras to set
	 */
	public void setCodigoBarras(InputStream codigoBarras) {
		this.codigoBarras = codigoBarras;
	}

	/**
	 * @return the codigoBarras
	 */
	public InputStream getCodigoBarrasCaratula() {
		return codigoBarrasCaratula;
	}

	/**
	 * @param codigoBarras
	 *            the codigoBarras to set
	 */
	public void setCodigoBarrasCaratula(InputStream codigoBarras) {
		this.codigoBarrasCaratula = codigoBarras;
	}

	/**
	 * @return the q5coddoc
	 */
	public String getQ5coddoc() {
		return q5coddoc;
	}

	/**
	 * @param q5coddoc
	 *            the q5coddoc to set
	 */
	public void setQ5coddoc(String q5coddoc) {
		this.q5coddoc = q5coddoc;
	}

	/**
	 * @return the q5datafile
	 */
	@JsonIgnore
	public Blob getQ5datafile() {
		return q5datafile;
	}

	/**
	 * @param q5datafile
	 *            the q5datafile to set
	 */
	public void setQ5datafile(Blob q5datafile) {
		this.q5datafile = q5datafile;
	}

	/**
	 * @return the ehnumregistrosalida
	 */
	public String getEhnumregistrosalida() {
		return ehnumregistrosalida;
	}

	/**
	 * @param ehnumregistrosalida
	 *            the ehnumregistrosalida to set
	 */
	public void setEhnumregistrosalida(String ehnumregistrosalida) {
		this.ehnumregistrosalida = ehnumregistrosalida;
	}

	/**
	 * @return the extranjero
	 */
	public String getExtranjero() {
		return extranjero;
	}

	/**
	 * @param extranjero
	 *            the extranjero to set
	 */
	public void setExtranjero(String extranjero) {
		this.extranjero = extranjero;
	}

	/**
	 * @return the nombre_Localidad
	 */
	public String getNombre_Localidad() {
		return nombre_Localidad;
	}

	/**
	 * @param nombre_Localidad
	 *            the nombre_Localidad to set
	 */
	public void setNombre_Localidad(String nombre_Localidad) {
		this.nombre_Localidad = nombre_Localidad;
	}

	/**
	 * @return the nombre_Calle
	 */
	public String getNombre_Calle() {
		return nombre_Calle;
	}

	/**
	 * @param nombre_Calle
	 *            the nombre_Calle to set
	 */
	public void setNombre_Calle(String nombre_Calle) {
		this.nombre_Calle = nombre_Calle;
	}

	/**
	 * @return the nombre_Portal
	 */
	public String getNombre_Portal() {
		return nombre_Portal;
	}

	/**
	 * @param nombre_Portal
	 *            the nombre_Portal to set
	 */
	public void setNombre_Portal(String nombre_Portal) {
		this.nombre_Portal = nombre_Portal;
	}

	/**
	 * @return the nombre_Piso
	 */
	public String getNombre_Piso() {
		return nombre_Piso;
	}

	/**
	 * @param nombre_Piso
	 *            the nombre_Piso to set
	 */
	public void setNombre_Piso(String nombre_Piso) {
		this.nombre_Piso = nombre_Piso;
	}

	/**
	 * @return the nombre_Pais
	 */
	public String getNombre_Pais() {
		return nombre_Pais;
	}

	/**
	 * @param nombre_Pais
	 *            the nombre_Pais to set
	 */
	public void setNombre_Pais(String nombre_Pais) {
		this.nombre_Pais = nombre_Pais;
	}

	/**
	 * @return the direccionNocapv
	 */
	public String getDireccionNocapv() {
		return direccionNocapv;
	}

	/**
	 * @param direccionNocapv
	 *            the direccionNocapv to set
	 */
	public void setDireccionNocapv(String direccionNocapv) {
		this.direccionNocapv = direccionNocapv;
	}

	/**
	 * @return the direccionAntigua
	 */
	public String getDireccionAntigua() {
		return direccionAntigua;
	}

	/**
	 * @param direccionAntigua
	 *            the direccionAntigua to set
	 */
	public void setDireccionAntigua(String direccionAntigua) {
		this.direccionAntigua = direccionAntigua;
	}

	/**
	 * @return the ehsede
	 */
	public String getEhsede() {
		return ehsede;
	}

	/**
	 * @param ehsede
	 *            the ehsede to set
	 */
	public void setEhsede(String ehsede) {
		this.ehsede = ehsede;
	}

	/**
	 * @return the escodigo
	 */
	public String getEscodigo() {
		return escodigo;
	}

	/**
	 * @param escodigo
	 *            the escodigo to set
	 */
	public void setEscodigo(String escodigo) {
		this.escodigo = escodigo;
	}

	/**
	 * @return the hdcodigo
	 */
	public String getHdcodigo() {
		return hdcodigo;
	}

	/**
	 * @param hdcodigo
	 *            the hdcodigo to set
	 */
	public void setHdcodigo(String hdcodigo) {
		this.hdcodigo = hdcodigo;
	}

	/**
	 * @return the ehfecharegistrosalidacas
	 */
	public String getEhfecharegistrosalidacas() {
		return ehfecharegistrosalidacas;
	}

	/**
	 * @param ehfecharegistrosalidacas
	 *            the ehfecharegistrosalidacas to set
	 */
	public void setEhfecharegistrosalidacas(String ehfecharegistrosalidacas) {
		this.ehfecharegistrosalidacas = ehfecharegistrosalidacas;
	}

	/**
	 * @return the ehfecharegistrosalidaeus
	 */
	public String getEhfecharegistrosalidaeus() {
		return ehfecharegistrosalidaeus;
	}

	/**
	 * @param ehfecharegistrosalidaeus
	 *            the ehfecharegistrosalidaeus to set
	 */
	public void setEhfecharegistrosalidaeus(String ehfecharegistrosalidaeus) {
		this.ehfecharegistrosalidaeus = ehfecharegistrosalidaeus;
	}

	/**
	 * @return the codOrg
	 */
	public String getCodOrg() {
		return codOrg;
	}

	/**
	 * @param codOrg
	 *            the codOrg to set
	 */
	public void setCodOrg(String codOrg) {
		this.codOrg = codOrg;
	}

	/**
	 * @return the nombreEs
	 */
	public String getNombreEs() {
		return nombreEs;
	}

	/**
	 * @param nombreEs
	 *            the nombreEs to set
	 */
	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * @return the nombreEu
	 */
	public String getNombreEu() {
		return nombreEu;
	}

	/**
	 * @param nombreEu
	 *            the nombreEu to set
	 */
	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * @return the noraProvinciaId
	 */
	public String getNoraProvinciaId() {
		return noraProvinciaId;
	}

	/**
	 * @param noraProvinciaId
	 *            the noraProvinciaId to set
	 */
	public void setNoraProvinciaId(String noraProvinciaId) {
		this.noraProvinciaId = noraProvinciaId;
	}

	/**
	 * @return the nombreProvincia
	 */
	public String getNombreProvincia() {
		return nombreProvincia;
	}

	/**
	 * @param nombreProvincia
	 *            the nombreProvincia to set
	 */
	public void setNombreProvincia(String nombreProvincia) {
		this.nombreProvincia = nombreProvincia;
	}

	/**
	 * @return the noraMunicipioId
	 */
	public String getNoraMunicipioId() {
		return noraMunicipioId;
	}

	/**
	 * @param noraMunicipioId
	 *            the noraMunicipioId to set
	 */
	public void setNoraMunicipioId(String noraMunicipioId) {
		this.noraMunicipioId = noraMunicipioId;
	}

	/**
	 * @return the nombreMunicipio
	 */
	public String getNombreMunicipio() {
		return nombreMunicipio;
	}

	/**
	 * @param nombreMunicipio
	 *            the nombreMunicipio to set
	 */
	public void setNombreMunicipio(String nombreMunicipio) {
		this.nombreMunicipio = nombreMunicipio;
	}

	/**
	 * @return the noraLocalidadId
	 */
	public String getNoraLocalidadId() {
		return noraLocalidadId;
	}

	/**
	 * @param noraLocalidadId
	 *            the noraLocalidadId to set
	 */
	public void setNoraLocalidadId(String noraLocalidadId) {
		this.noraLocalidadId = noraLocalidadId;
	}

	/**
	 * @return the nombreLocalidad
	 */
	public String getNombreLocalidad() {
		return nombreLocalidad;
	}

	/**
	 * @param nombreLocalidad
	 *            the nombreLocalidad to set
	 */
	public void setNombreLocalidad(String nombreLocalidad) {
		this.nombreLocalidad = nombreLocalidad;
	}

	/**
	 * @return the noraCalleId
	 */
	public String getNoraCalleId() {
		return noraCalleId;
	}

	/**
	 * @param noraCalleId
	 *            the noraCalleId to set
	 */
	public void setNoraCalleId(String noraCalleId) {
		this.noraCalleId = noraCalleId;
	}

	/**
	 * @return the nombreCalle
	 */
	public String getNombreCalle() {
		return nombreCalle;
	}

	/**
	 * @param nombreCalle
	 *            the nombreCalle to set
	 */
	public void setNombreCalle(String nombreCalle) {
		this.nombreCalle = nombreCalle;
	}

	/**
	 * @return the noraCpId
	 */
	public String getNoraCpId() {
		return noraCpId;
	}

	/**
	 * @param noraCpId
	 *            the noraCpId to set
	 */
	public void setNoraCpId(String noraCpId) {
		this.noraCpId = noraCpId;
	}

	/**
	 * @return the nombreCp
	 */
	public String getNombreCp() {
		return nombreCp;
	}

	/**
	 * @param nombreCp
	 *            the nombreCp to set
	 */
	public void setNombreCp(String nombreCp) {
		this.nombreCp = nombreCp;
	}

	/**
	 * @return the noraPortalId
	 */
	public String getNoraPortalId() {
		return noraPortalId;
	}

	/**
	 * @param noraPortalId
	 *            the noraPortalId to set
	 */
	public void setNoraPortalId(String noraPortalId) {
		this.noraPortalId = noraPortalId;
	}

	/**
	 * @return the nombrePortal
	 */
	public String getNombrePortal() {
		return nombrePortal;
	}

	/**
	 * @param nombrePortal
	 *            the nombrePortal to set
	 */
	public void setNombrePortal(String nombrePortal) {
		this.nombrePortal = nombrePortal;
	}

	/**
	 * @return the direccionOrganismo
	 */
	public String getDireccionOrganismo() {
		return direccionOrganismo;
	}

	/**
	 * @param direccionOrganismo
	 *            the direccionOrganismo to set
	 */
	public void setDireccionOrganismo(String direccionOrganismo) {
		this.direccionOrganismo = direccionOrganismo;
	}

	/**
	 * @return the cpMunicipioOrganismo
	 */
	public String getCpMunicipioOrganismo() {
		return cpMunicipioOrganismo;
	}

	/**
	 * @param cpMunicipioOrganismo
	 *            the cpMunicipioOrganismo to set
	 */
	public void setCpMunicipioOrganismo(String cpMunicipioOrganismo) {
		this.cpMunicipioOrganismo = cpMunicipioOrganismo;
	}

	/**
	 * @return the telefonoOrganismo
	 */
	public String getTelefonoOrganismo() {
		return telefonoOrganismo;
	}

	/**
	 * @param telefonoOrganismo
	 *            the telefonoOrganismo to set
	 */
	public void setTelefonoOrganismo(String telefonoOrganismo) {
		this.telefonoOrganismo = telefonoOrganismo;
	}

	/**
	 * @return the faxOrganismo
	 */
	public String getFaxOrganismo() {
		return faxOrganismo;
	}

	/**
	 * @param faxOrganismo
	 *            the faxOrganismo to set
	 */
	public void setFaxOrganismo(String faxOrganismo) {
		this.faxOrganismo = faxOrganismo;
	}

	/**
	 * @return the emailOrganismo
	 */
	public String getEmailOrganismo() {
		return emailOrganismo;
	}

	/**
	 * @param emailOrganismo
	 *            the emailOrganismo to set
	 */
	public void setEmailOrganismo(String emailOrganismo) {
		this.emailOrganismo = emailOrganismo;
	}

	/**
	 * @return the webOrganismo
	 */
	public String getWebOrganismo() {
		return webOrganismo;
	}

	/**
	 * @param webOrganismo
	 *            the webOrganismo to set
	 */
	public void setWebOrganismo(String webOrganismo) {
		this.webOrganismo = webOrganismo;
	}

	/**
	 * @return the piePaginaLinea1
	 */
	public String getPiePaginaLinea1() {
		return piePaginaLinea1;
	}

	/**
	 * @param piePaginaLinea1
	 *            the piePaginaLinea1 to set
	 */
	public void setPiePaginaLinea1(String piePaginaLinea1) {
		this.piePaginaLinea1 = piePaginaLinea1;
	}

	/**
	 * @return the piePaginaLinea2
	 */
	public String getPiePaginaLinea2() {
		return piePaginaLinea2;
	}

	/**
	 * @param piePaginaLinea2
	 *            the piePaginaLinea2 to set
	 */
	public void setPiePaginaLinea2(String piePaginaLinea2) {
		this.piePaginaLinea2 = piePaginaLinea2;
	}

	/**
	 * @return the rmcapv
	 */
	public String getRmcapv() {
		return rmcapv;
	}

	/**
	 * @return the nif
	 */
	public String getNif() {
		return nif;
	}

	/**
	 * @param nif
	 *            the nif to set
	 */
	public void setNif(String nif) {
		this.nif = nif;
	}

	/**
	 * @return the trcodigo
	 */
	public String getTrcodigo() {
		return trcodigo;
	}

	/**
	 * @param trcodigo
	 *            the trcodigo to set
	 */
	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * @return the tipoInterviniente
	 */
	public String getTipoInterviniente() {
		return tipoInterviniente;
	}

	/**
	 * @param tipoInterviniente
	 *            the tipoInterviniente to set
	 */
	public void setTipoInterviniente(String tipoInterviniente) {
		this.tipoInterviniente = tipoInterviniente;
	}

	/**
	 * @return the envcestado
	 */
	public String getEnvcestado() {
		return envcestado;
	}

	/**
	 * @param envcestado
	 *            the envcestado to set
	 */
	public void setEnvcestado(String envcestado) {
		this.envcestado = envcestado;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "NotificacionesComunicacionesBusqueda [rmcodigo=" + rmcodigo
				+ ", rmtipo=" + rmtipo + ", rmcomo=" + rmcomo + ", rmfecha="
				+ rmfecha + ", rmtipoExpediente=" + rmtipoExpediente
				+ ", rmorganico=" + rmorganico + ", rmcapv=" + rmcapv
				+ ", idTramite=" + idTramite + ", numExpediente="
				+ numExpediente + ", decoor=" + decoor + ", denran=" + denran
				+ ", denror=" + denror + ", hdnror=" + hdnror
				+ ", fechaTramite=" + ehfechainicio + ", numregistrosalida="
				+ ehnumregistrosalida + ", acto=" + acto
				+ ", mocodigoExpediente=" + mocodigoExpediente
				+ ", monombreExpediente=" + monombre + ", idInterviniente="
				+ idInterviniente + ", nombreInterviniente="
				+ nombreDestinatario + ", nombreProvincia=" + nombre_Provincia
				+ ", nombreMunicipio=" + nombre_Municipio + ", codigoPostal="
				+ nombre_CP + "]";
	}

	/**
	 * @return the tipoProcedimiento
	 */
	public String getTipoProcedimiento() {
		return tipoProcedimiento;
	}

	/**
	 * @param tipoProcedimiento
	 *            the tipoProcedimiento to set
	 */
	public void setTipoProcedimiento(String tipoProcedimiento) {
		this.tipoProcedimiento = tipoProcedimiento;
	}

	/**
	 * @return the q5iddocumentum
	 */
	public String getQ5iddocumentum() {
		return q5iddocumentum;
	}

	/**
	 * @param q5iddocumentum
	 *            the q5iddocumentum to set
	 */
	public void setQ5iddocumentum(String q5iddocumentum) {
		this.q5iddocumentum = q5iddocumentum;
	}

	/**
	 * @return the ehestadotramite
	 */
	public String getEhestadotramite() {
		return ehestadotramite;
	}

	/**
	 * @param ehestadotramite
	 *            the ehestadotramite to set
	 */
	public void setEhestadotramite(String ehestadotramite) {
		this.ehestadotramite = ehestadotramite;
	}

	/**
	 * @return the envfechaactualizacion
	 */
	public Date getEnvfechaactualizacion() {
		return envfechaactualizacion;
	}

	/**
	 * @param envfechaactualizacion
	 *            the envfechaactualizacion to set
	 */
	public void setEnvfechaactualizacion(Date envfechaactualizacion) {
		this.envfechaactualizacion = envfechaactualizacion;
	}

	/**
	 * @return the envcodbarras
	 */
	public String getEnvcodbarras() {
		return envcodbarras;
	}

	/**
	 * @param envcodbarras
	 *            the envcodbarras to set
	 */
	public void setEnvcodbarras(String envcodbarras) {
		this.envcodbarras = envcodbarras;
	}

	/**
	 * @return the nombreComercialDestinatario
	 */
	public String getNombreComercialDestinatario() {
		return nombreComercialDestinatario;
	}

	/**
	 * @param nombreComercialDestinatario
	 *            the nombreComercialDestinatario to set
	 */
	public void setNombreComercialDestinatario(
			String nombreComercialDestinatario) {
		this.nombreComercialDestinatario = nombreComercialDestinatario;
	}

}
