package com.ejie.y41b.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;

/**
 * * Motivo  
 * 
 *  
 */

public class Motivo implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String tircodigo;
	private String tirnombre;
	private String tirnombree;
	private String e8codigo;
	private List<ProdAgrupado> prodAgrupados = new ArrayList<ProdAgrupado>();
	private List<Consulta> consultas = new ArrayList<Consulta>();

	/**
	 * Method 'Motivo'.
	 * 
	 */
	public Motivo() {
	}

	/**
	 * @param tircodigo
	 * @param tirnombre
	 * @param tirnombree
	 */
	public Motivo(String tircodigo, String tirnombre, String tirnombree) {
		super();
		this.tircodigo = tircodigo;
		this.tirnombre = tirnombre;
		this.tirnombree = tirnombree;
	}

	/**
	 * @param tircodigo
	 * @param tirnombre
	 * @param tirnombree
	 * @param e8codigo
	 */
	public Motivo(String tircodigo, String tirnombre, String tirnombree,
			String e8codigo) {
		super();
		this.tircodigo = tircodigo;
		this.tirnombre = tirnombre;
		this.tirnombree = tirnombree;
		this.e8codigo = e8codigo;
	}

	/**
	 * Method 'Motivo'.
	 * 
	 * @param tircodigo
	 *            String
	 * @param tirnombre
	 *            String
	 * @param prodAgrupados
	 *            List<ProdAgrupado>
	 * @param consultas
	 *            List<Consulta>
	 */
	public Motivo(String tircodigo, String tirnombre,
			List<ProdAgrupado> prodAgrupados, List<Consulta> consultas) {

		this.tircodigo = tircodigo;
		this.tirnombre = tirnombre;
		this.prodAgrupados = prodAgrupados;
		this.consultas = consultas;
	}

	/**
	 * Method 'getTircodigo'.
	 * 
	 * @return String
	 */

	public String getTircodigo() {
		return this.tircodigo;
	}

	/**
	 * Method 'setTircodigo'.
	 * 
	 * @param tircodigo
	 *            String
	 * @return
	 */

	public void setTircodigo(String tircodigo) {
		this.tircodigo = tircodigo;
	}

	/**
	 * Method 'getTirnombre'.
	 * 
	 * @return String
	 */

	public String getTirnombre() {
		return this.tirnombre;
	}

	/**
	 * Method 'setTirnombre'.
	 * 
	 * @param tirnombre
	 *            String
	 * @return
	 */

	public void setTirnombre(String tirnombre) {
		this.tirnombre = tirnombre;
	}

	/**
	 * Method 'getProdAgrupados'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<ProdAgrupado> getProdAgrupados() {
		return this.prodAgrupados;
	}

	/**
	 * Method 'setProdAgrupados'.
	 * 
	 * @param prodAgrupados
	 *            List
	 * @return
	 */
	public void setProdAgrupados(List<ProdAgrupado> prodAgrupados) {
		this.prodAgrupados = prodAgrupados;
	}

	/**
	 * Method 'getConsultas'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Consulta> getConsultas() {
		return this.consultas;
	}

	/**
	 * Method 'setConsultas'.
	 * 
	 * @param consultas
	 *            List
	 * @return
	 */
	public void setConsultas(List<Consulta> consultas) {
		this.consultas = consultas;
	}

	/**
	 * @return the e8codigo
	 */
	public String getE8codigo() {
		return e8codigo;
	}

	/**
	 * @param e8codigo
	 *            the e8codigo to set
	 */
	public void setE8codigo(String e8codigo) {
		this.e8codigo = e8codigo;
	}

	/**
	 * @return the tirnombree
	 */
	public String getTirnombree() {
		return tirnombree;
	}

	/**
	 * @param tirnombree
	 *            the tirnombree to set
	 */
	public void setTirnombree(String tirnombree) {
		this.tirnombree = tirnombree;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Motivo [tircodigo=" + tircodigo + ", tirnombre=" + tirnombre
				+ ", tirnombree=" + tirnombree + ", e8codigo=" + e8codigo
				+ ", prodAgrupados=" + prodAgrupados + ", consultas="
				+ consultas + "]";
	}

}
