package com.ejie.y41b.model;

import java.io.IOException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * Mensajecola  
 * 
 *  
 */

public class Mensajecola implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String swcodmensaje;
	private String swdtipomensaje;
	private String swdnumexp;
	private String swidprocedure;
	private String swnumreg;
	private String swfecreg;
	private Clob swmensaje;
	private Date swfecrecepcion;
	private String swjmsmessageid;

	/**
	 * Method 'Mensajecola'.
	 */
	public Mensajecola() {
	}

	/**
	 * Method 'Mensajecola'.
	 * 
	 * @param swcodmensaje
	 *            String
	 * @param swdtipomensaje
	 *            String
	 * @param swdnumexp
	 *            String
	 * @param swidprocedure
	 *            String
	 * @param swnumreg
	 *            String
	 * @param swfecreg
	 *            String
	 * @param swmensaje
	 *            Clob
	 * @param swfecrecepcion
	 *            Date
	 * @param swjmsmessageid
	 *            String
	 */
	public Mensajecola(String swcodmensaje, String swdtipomensaje, String swdnumexp, String swidprocedure,
			String swnumreg, String swfecreg, Clob swmensaje, Date swfecrecepcion, String swjmsmessageid) {

		this.swcodmensaje = swcodmensaje;
		this.swdtipomensaje = swdtipomensaje;
		this.swdnumexp = swdnumexp;
		this.swidprocedure = swidprocedure;
		this.swnumreg = swnumreg;
		this.swfecreg = swfecreg;
		this.swmensaje = swmensaje;
		this.swfecrecepcion = swfecrecepcion;
		this.swjmsmessageid = swjmsmessageid;
	}

	/**
	 * Method 'getSwcodmensaje'.
	 * 
	 * @return String
	 */

	public String getSwcodmensaje() {
		return this.swcodmensaje;
	}

	/**
	 * Method 'setSwcodmensaje'.
	 * 
	 * @param swcodmensaje
	 *            String
	 * @return
	 */

	public void setSwcodmensaje(String swcodmensaje) {
		this.swcodmensaje = swcodmensaje;
	}

	/**
	 * Method 'getSwdtipomensaje'.
	 * 
	 * @return String
	 */

	public String getSwdtipomensaje() {
		return this.swdtipomensaje;
	}

	/**
	 * Method 'setSwdtipomensaje'.
	 * 
	 * @param swdtipomensaje
	 *            String
	 * @return
	 */

	public void setSwdtipomensaje(String swdtipomensaje) {
		this.swdtipomensaje = swdtipomensaje;
	}

	/**
	 * Method 'getSwdnumexp'.
	 * 
	 * @return String
	 */

	public String getSwdnumexp() {
		return this.swdnumexp;
	}

	/**
	 * Method 'setSwdnumexp'.
	 * 
	 * @param swdnumexp
	 *            String
	 * @return
	 */

	public void setSwdnumexp(String swdnumexp) {
		this.swdnumexp = swdnumexp;
	}

	/**
	 * Method 'getSwidprocedure'.
	 * 
	 * @return String
	 */

	public String getSwidprocedure() {
		return this.swidprocedure;
	}

	/**
	 * Method 'setSwidprocedure'.
	 * 
	 * @param swidprocedure
	 *            String
	 * @return
	 */

	public void setSwidprocedure(String swidprocedure) {
		this.swidprocedure = swidprocedure;
	}

	/**
	 * Method 'getSwnumreg'.
	 * 
	 * @return String
	 */

	public String getSwnumreg() {
		return this.swnumreg;
	}

	/**
	 * Method 'setSwnumreg'.
	 * 
	 * @param swnumreg
	 *            String
	 * @return
	 */

	public void setSwnumreg(String swnumreg) {
		this.swnumreg = swnumreg;
	}

	/**
	 * Method 'getSwfecreg'.
	 * 
	 * @return String
	 */

	public String getSwfecreg() {
		return this.swfecreg;
	}

	/**
	 * Method 'setSwfecreg'.
	 * 
	 * @param swfecreg
	 *            String
	 * @return
	 */

	public void setSwfecreg(String swfecreg) {
		this.swfecreg = swfecreg;
	}

	/**
	 * Method 'getSwmensaje'.
	 * 
	 * @return Clob
	 */
	@JsonIgnore
	public Clob getSwmensaje() {
		return this.swmensaje;
	}

	/**
	 * Method 'setSwmensaje'.
	 * 
	 * @param swmensaje
	 *            Clob
	 * @return
	 */

	public void setSwmensaje(Clob swmensaje) {
		this.swmensaje = swmensaje;
	}

	/**
	 * Method 'setSwmensaje'.
	 * 
	 * @param swmensaje
	 *            Clob
	 * @return
	 * @throws IOException
	 *             e
	 * @throws SQLException
	 *             e
	 */

	public void setSwmensaje(String swmensaje) throws SQLException, IOException {
		this.swmensaje = Y41bUtils.stringToClob(swmensaje);
	}

	/**
	 * Method 'getSwfecrecepcion'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getSwfecrecepcion() {
		return this.swfecrecepcion;
	}

	/**
	 * Method 'setSwfecrecepcion'.
	 * 
	 * @param swfecrecepcion
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setSwfecrecepcion(Date swfecrecepcion) {
		this.swfecrecepcion = swfecrecepcion;
	}

	/**
	 * @return the swjmsmessageid
	 */
	public String getSwjmsmessageid() {
		return swjmsmessageid;
	}

	/**
	 * @param swjmsmessageid
	 *            the swjmsmessageid to set
	 */
	public void setSwjmsmessageid(String swjmsmessageid) {
		this.swjmsmessageid = swjmsmessageid;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Mensajecola [swcodmensaje=" + swcodmensaje + ", swdtipomensaje=" + swdtipomensaje + ", swdnumexp="
				+ swdnumexp + ", swidprocedure=" + swidprocedure + ", swnumreg=" + swnumreg + ", swfecreg=" + swfecreg
				+ ", swmensaje=" + swmensaje + ", swfecrecepcion=" + swfecrecepcion + ", swjmsmessageid="
				+ swjmsmessageid + "]";
	}

}
