package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.validation.Y41bNifNieCif;

import java.util.Date;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * Jjaa  
 * 
 *  
 */

public class Jjaa implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	@NotEmpty(message = "error01.required.jacodigo")
	private String jacodigo;
	private String janop;
	@Y41bNifNieCif(message = "error02.required.janifp")
	private String janifp;
	@Email(message = "error03.required.email")
	private String jateemp;
	private String jateurlp;
	private String janos;
	@Y41bNifNieCif(message = "error04.required.janifs")
	private String janifs;
	@Email(message = "error05.required.email")
	private String jateems;
	private String jateurls;
	private String janoa;
	private String janifa;
	private String jateema;
	private String jateurla;
	private String jatelefonop;
	private String jatelefonos;
	private String janoc;
	@Y41bNifNieCif(message = "error06.required.janifc")
	private String janifc;
	@Email(message = "error07.required.email")
	private String jateemc;
	private String jatelefonoc;
	private Date jafecalta;
	private Date jafecmodif;
	private String jausualta;
	private String jausumodif;

	private Organismo organismo;
	private String janombre;

	/**
	 * Method 'Jjaa'.
	 */
	public Jjaa() {
	}

	/**
	 * Method 'Jjaa'.
	 * 
	 * @param jacodigo
	 *            String
	 * @param janop
	 *            String
	 * @param janifp
	 *            String
	 * @param jateemp
	 *            String
	 * @param jateurlp
	 *            String
	 * @param janos
	 *            String
	 * @param janifs
	 *            String
	 * @param jateems
	 *            String
	 * @param jateurls
	 *            String
	 * @param janoa
	 *            String
	 * @param janifa
	 *            String
	 * @param jateema
	 *            String
	 * @param jateurla
	 *            String
	 * @param jatelefonop
	 *            String
	 * @param jatelefonos
	 *            String
	 * @param janoc
	 *            String
	 * @param janifc
	 *            String
	 * @param jateemc
	 *            String
	 * @param jatelefonoc
	 *            String
	 * @param jafecalta
	 *            Date
	 * @param jafecmodif
	 *            Date
	 * @param jausualta
	 *            String
	 * @param jausumodif
	 *            String
	 */
	public Jjaa(String jacodigo, String janop, String janifp, String jateemp,
			String jateurlp, String janos, String janifs, String jateems,
			String jateurls, String janoa, String janifa, String jateema,
			String jateurla, String jatelefonop, String jatelefonos,
			String janoc, String janifc, String jateemc, String jatelefonoc,
			Date jafecalta, Date jafecmodif, String jausualta, String jausumodif) {

		this.jacodigo = jacodigo;
		this.janop = janop;
		this.janifp = janifp;
		this.jateemp = jateemp;
		this.jateurlp = jateurlp;
		this.janos = janos;
		this.janifs = janifs;
		this.jateems = jateems;
		this.jateurls = jateurls;
		this.janoa = janoa;
		this.janifa = janifa;
		this.jateema = jateema;
		this.jateurla = jateurla;
		this.jatelefonop = jatelefonop;
		this.jatelefonos = jatelefonos;
		this.janoc = janoc;
		this.janifc = janifc;
		this.jateemc = jateemc;
		this.jatelefonoc = jatelefonoc;
		this.jafecalta = jafecalta;
		this.jafecmodif = jafecmodif;
		this.jausualta = jausualta;
		this.jausumodif = jausumodif;
	}

	/**
	 * Method 'getJacodigo'.
	 * 
	 * @return String
	 */

	public String getJacodigo() {
		return this.jacodigo;
	}

	/**
	 * Method 'setJacodigo'.
	 * 
	 * @param jacodigo
	 *            String
	 * @return
	 */

	public void setJacodigo(String jacodigo) {
		this.jacodigo = jacodigo;
	}

	/**
	 * Method 'getJanop'.
	 * 
	 * @return String
	 */

	public String getJanop() {
		return this.janop;
	}

	/**
	 * Method 'setJanop'.
	 * 
	 * @param janop
	 *            String
	 * @return
	 */

	public void setJanop(String janop) {
		this.janop = janop;
	}

	/**
	 * Method 'getJanifp'.
	 * 
	 * @return String
	 */

	public String getJanifp() {
		return Y41bUtils.upperCase(this.janifp);
	}

	/**
	 * Method 'setJanifp'.
	 * 
	 * @param janifp
	 *            String
	 * @return
	 */

	public void setJanifp(String janifp) {
		this.janifp = Y41bUtils.upperCase(janifp);
	}

	/**
	 * Method 'getJateemp'.
	 * 
	 * @return String
	 */

	public String getJateemp() {
		return this.jateemp;
	}

	/**
	 * Method 'setJateemp'.
	 * 
	 * @param jateemp
	 *            String
	 * @return
	 */

	public void setJateemp(String jateemp) {
		this.jateemp = jateemp;
	}

	/**
	 * Method 'getJateurlp'.
	 * 
	 * @return String
	 */

	public String getJateurlp() {
		return this.jateurlp;
	}

	/**
	 * Method 'setJateurlp'.
	 * 
	 * @param jateurlp
	 *            String
	 * @return
	 */

	public void setJateurlp(String jateurlp) {
		this.jateurlp = jateurlp;
	}

	/**
	 * Method 'getJanos'.
	 * 
	 * @return String
	 */

	public String getJanos() {
		return this.janos;
	}

	/**
	 * Method 'setJanos'.
	 * 
	 * @param janos
	 *            String
	 * @return
	 */

	public void setJanos(String janos) {
		this.janos = janos;
	}

	/**
	 * Method 'getJanifs'.
	 * 
	 * @return String
	 */

	public String getJanifs() {
		return Y41bUtils.upperCase(this.janifs);
	}

	/**
	 * Method 'setJanifs'.
	 * 
	 * @param janifs
	 *            String
	 * @return
	 */

	public void setJanifs(String janifs) {
		this.janifs = Y41bUtils.upperCase(janifs);
	}

	/**
	 * Method 'getJateems'.
	 * 
	 * @return String
	 */

	public String getJateems() {
		return this.jateems;
	}

	/**
	 * Method 'setJateems'.
	 * 
	 * @param jateems
	 *            String
	 * @return
	 */

	public void setJateems(String jateems) {
		this.jateems = jateems;
	}

	/**
	 * Method 'getJateurls'.
	 * 
	 * @return String
	 */

	public String getJateurls() {
		return this.jateurls;
	}

	/**
	 * Method 'setJateurls'.
	 * 
	 * @param jateurls
	 *            String
	 * @return
	 */

	public void setJateurls(String jateurls) {
		this.jateurls = jateurls;
	}

	/**
	 * Method 'getJanoa'.
	 * 
	 * @return String
	 */

	public String getJanoa() {
		return this.janoa;
	}

	/**
	 * Method 'setJanoa'.
	 * 
	 * @param janoa
	 *            String
	 * @return
	 */

	public void setJanoa(String janoa) {
		this.janoa = janoa;
	}

	/**
	 * Method 'getJanifa'.
	 * 
	 * @return String
	 */

	public String getJanifa() {
		return this.janifa;
	}

	/**
	 * Method 'setJanifa'.
	 * 
	 * @param janifa
	 *            String
	 * @return
	 */

	public void setJanifa(String janifa) {
		this.janifa = janifa;
	}

	/**
	 * Method 'getJateema'.
	 * 
	 * @return String
	 */

	public String getJateema() {
		return this.jateema;
	}

	/**
	 * Method 'setJateema'.
	 * 
	 * @param jateema
	 *            String
	 * @return
	 */

	public void setJateema(String jateema) {
		this.jateema = jateema;
	}

	/**
	 * Method 'getJateurla'.
	 * 
	 * @return String
	 */

	public String getJateurla() {
		return this.jateurla;
	}

	/**
	 * Method 'setJateurla'.
	 * 
	 * @param jateurla
	 *            String
	 * @return
	 */

	public void setJateurla(String jateurla) {
		this.jateurla = jateurla;
	}

	/**
	 * Method 'getJatelefonop'.
	 * 
	 * @return String
	 */

	public String getJatelefonop() {
		return this.jatelefonop;
	}

	/**
	 * Method 'setJatelefonop'.
	 * 
	 * @param jatelefonop
	 *            String
	 * @return
	 */

	public void setJatelefonop(String jatelefonop) {
		this.jatelefonop = jatelefonop;
	}

	/**
	 * Method 'getJatelefonos'.
	 * 
	 * @return String
	 */

	public String getJatelefonos() {
		return this.jatelefonos;
	}

	/**
	 * Method 'setJatelefonos'.
	 * 
	 * @param jatelefonos
	 *            String
	 * @return
	 */

	public void setJatelefonos(String jatelefonos) {
		this.jatelefonos = jatelefonos;
	}

	/**
	 * Method 'getJanoc'.
	 * 
	 * @return String
	 */

	public String getJanoc() {
		return this.janoc;
	}

	/**
	 * Method 'setJanoc'.
	 * 
	 * @param janoc
	 *            String
	 * @return
	 */

	public void setJanoc(String janoc) {
		this.janoc = janoc;
	}

	/**
	 * Method 'getJanifc'.
	 * 
	 * @return String
	 */

	public String getJanifc() {
		return Y41bUtils.upperCase(this.janifc);
	}

	/**
	 * Method 'setJanifc'.
	 * 
	 * @param janifc
	 *            String
	 * @return
	 */

	public void setJanifc(String janifc) {
		this.janifc = Y41bUtils.upperCase(janifc);
	}

	/**
	 * Method 'getJateemc'.
	 * 
	 * @return String
	 */

	public String getJateemc() {
		return this.jateemc;
	}

	/**
	 * Method 'setJateemc'.
	 * 
	 * @param jateemc
	 *            String
	 * @return
	 */

	public void setJateemc(String jateemc) {
		this.jateemc = jateemc;
	}

	/**
	 * Method 'getJatelefonoc'.
	 * 
	 * @return String
	 */

	public String getJatelefonoc() {
		return this.jatelefonoc;
	}

	/**
	 * Method 'setJatelefonoc'.
	 * 
	 * @param jatelefonoc
	 *            String
	 * @return
	 */

	public void setJatelefonoc(String jatelefonoc) {
		this.jatelefonoc = jatelefonoc;
	}

	/**
	 * Method 'getJafecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getJafecalta() {
		return this.jafecalta;
	}

	/**
	 * Method 'setJafecalta'.
	 * 
	 * @param jafecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setJafecalta(Date jafecalta) {
		this.jafecalta = jafecalta;
	}

	/**
	 * Method 'getJafecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getJafecmodif() {
		return this.jafecmodif;
	}

	/**
	 * Method 'setJafecmodif'.
	 * 
	 * @param jafecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setJafecmodif(Date jafecmodif) {
		this.jafecmodif = jafecmodif;
	}

	/**
	 * Method 'getJausualta'.
	 * 
	 * @return String
	 */

	public String getJausualta() {
		return this.jausualta;
	}

	/**
	 * Method 'setJausualta'.
	 * 
	 * @param jausualta
	 *            String
	 * @return
	 */

	public void setJausualta(String jausualta) {
		this.jausualta = jausualta;
	}

	/**
	 * Method 'getJausumodif'.
	 * 
	 * @return String
	 */

	public String getJausumodif() {
		return this.jausumodif;
	}

	/**
	 * Method 'setJausumodif'.
	 * 
	 * @param jausumodif
	 *            String
	 * @return
	 */

	public void setJausumodif(String jausumodif) {
		this.jausumodif = jausumodif;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ jacodigo: ").append(this.jacodigo).append(" ]");
		result.append(", [ janop: ").append(this.janop).append(" ]");
		result.append(", [ janifp: ").append(this.janifp).append(" ]");
		result.append(", [ jateemp: ").append(this.jateemp).append(" ]");
		result.append(", [ jateurlp: ").append(this.jateurlp).append(" ]");
		result.append(", [ janos: ").append(this.janos).append(" ]");
		result.append(", [ janifs: ").append(this.janifs).append(" ]");
		result.append(", [ jateems: ").append(this.jateems).append(" ]");
		result.append(", [ jateurls: ").append(this.jateurls).append(" ]");
		result.append(", [ janoa: ").append(this.janoa).append(" ]");
		result.append(", [ janifa: ").append(this.janifa).append(" ]");
		result.append(", [ jateema: ").append(this.jateema).append(" ]");
		result.append(", [ jateurla: ").append(this.jateurla).append(" ]");
		result.append(", [ jatelefonop: ").append(this.jatelefonop)
				.append(" ]");
		result.append(", [ jatelefonos: ").append(this.jatelefonos)
				.append(" ]");
		result.append(", [ janoc: ").append(this.janoc).append(" ]");
		result.append(", [ janifc: ").append(this.janifc).append(" ]");
		result.append(", [ jateemc: ").append(this.jateemc).append(" ]");
		result.append(", [ jatelefonoc: ").append(this.jatelefonoc)
				.append(" ]");
		result.append(", [ jafecalta: ").append(this.jafecalta).append(" ]");
		result.append(", [ jafecmodif: ").append(this.jafecmodif).append(" ]");
		result.append(", [ jausualta: ").append(this.jausualta).append(" ]");
		result.append(", [ jausumodif: ").append(this.jausumodif).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the organismo
	 */
	public Organismo getOrganismo() {
		return this.organismo;
	}

	/**
	 * @param organismo
	 *            the organismo to set
	 */
	public void setOrganismo(Organismo organismo) {
		this.organismo = organismo;
	}

	/**
	 * @return the janombre
	 */
	public String getJanombre() {
		return this.janombre;
	}

	/**
	 * @param janombre
	 *            the janombre to set
	 */
	public void setJanombre(String janombre) {
		this.janombre = janombre;
	}

}
