package com.ejie.y41b.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * Intervinientes  
 * 
 *  
 */

public class Intervinientes implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idinterviniente;
	private String dtcodigo;
	private String escodigo;
	private String entidadId;
	private String nombre;
	private String apellido1;
	private String apellido2;
	private String esnoco;
	private String dtintipid; // Tipo identificacion
	private String nif;
	private String dtrango_edad; // Edad
	private String dtcosx; // Sexo
	private String coidco; // Idioma
	private String esteurl; // web
	private String esnopeco; // contacto
	private Date esfeba; // Fecha cierre
	private String nrtel;
	private String nrtel2;
	private String coem;
	private String extranjero;
	private String noraProvinciaId;
	private String nombreProvincia;
	private String noraMunicipioId;
	private String nombreMunicipio;
	private String noraLocalidadId;
	private String nombreLocalidad;
	private String noraCalleId;
	private String nombreCalle;
	private String noraCpId;
	private String nombreCp;
	private String noraPortalId;
	private String nombrePortal;
	private String nombrePiso;
	private String noraPaisId;
	private String nombrePais;
	private String direccionNocapv;
	private String direccionAntigua;
	private String inadar;
	private String secodigo;
	private String senombre;
	private String senombree;
	private String tipoInterviniente;
	private String idExpediente;

	private String direccionCompleta;
	private boolean tieneDireccionCompleta;
	private TipoProcedimiento tipoProcedimiento;

	// mocodigo;
	private String incozs; // Codigo del Usuario que ha modificado la ultima vez
							// el censo del que proviene el interviniente (se
							// recupera del censo monitor a traves del campo
							// INCOZS)
	private String usuarioxlnet; // Usuario xlnets correspondiente al incozs
	private String infemod; // Fecha en que ha modificado la ultima vez el censo
							// del que proviene el interviniente

	// private String t3usumodif; // Usuario de modificacin

	private String sanFormanotificacion;

	private String arbFormanotificacion;

	private String insFormanotificacion;

	private String solFormanotificacion;

	private String activos;

	private String establecimientoCerrado;

	private String exhdformanotiforigen;

	/**
	 * Method 'Intervinientes'.
	 */
	public Intervinientes() {
	}

	/**
	 * Method 'Intervinientes'.
	 */
	public Intervinientes(String idinterviniente) {
		this.idinterviniente = idinterviniente;
	}

	/**
	 * Method 'Intervinientes'.
	 * 
	 * @param idinterviniente
	 *            String
	 * @param dtcodigo
	 *            String
	 * @param escodigo
	 *            String
	 * @param entidadId
	 *            String
	 * @param nombre
	 *            String
	 * @param apellido1
	 *            String
	 * @param apellido2
	 *            String
	 * @param esnoco
	 *            String
	 * @param dtintipid
	 *            String
	 * @param nif
	 *            String
	 * @param dtrango_edad
	 *            String
	 * @param dtcosx
	 *            String
	 * @param coidco
	 *            String
	 * @param esteurl
	 *            String
	 * @param esnopeco
	 *            String
	 * @param esfeba
	 *            Date
	 * @param nrtel
	 *            String
	 * @param nrtel2
	 *            String
	 * @param coem
	 *            String
	 * @param extranjero
	 *            String
	 * @param noraProvinciaId
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param noraMunicipioId
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param noraLocalidadId
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param direccionNocapv
	 *            String
	 * @param direccionAntigua
	 *            String
	 * @param inadar
	 *            String
	 * @param secodigo
	 *            String
	 * @param senombre
	 *            String
	 * @param senombree
	 *            String
	 * @param tipoInterviniente
	 *            String
	 * @param idExpediente
	 *            String
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @param infemod
	 *            String
	 * @param incozs
	 *            String
	 * @param usuarioxlnet
	 *            String
	 */
	public Intervinientes(String idinterviniente, String dtcodigo, String escodigo, String entidadId, String nombre,
			String apellido1, String apellido2, String esnoco, String dtintipid, String nif, String dtrango_edad,
			String dtcosx, String coidco, String esteurl, String esnopeco, Date esfeba, String nrtel, String nrtel2,
			String coem, String extranjero, String noraProvinciaId, String nombreProvincia, String noraMunicipioId,
			String nombreMunicipio, String noraLocalidadId, String nombreLocalidad, String noraCalleId,
			String nombreCalle, String noraCpId, String nombreCp, String noraPortalId, String nombrePortal,
			String nombrePiso, String noraPaisId, String nombrePais, String direccionNocapv, String direccionAntigua,
			String inadar, String secodigo, String senombre, String senombree, String tipoInterviniente,
			String idExpediente, TipoProcedimiento tipoProcedimiento, String infemod, String incozs,
			String usuarioxlnet) {

		this.idinterviniente = idinterviniente;
		this.dtcodigo = dtcodigo;
		this.escodigo = escodigo;
		this.entidadId = entidadId;
		this.nombre = nombre;
		this.apellido1 = apellido1;
		this.apellido2 = apellido2;
		this.esnoco = esnoco;
		this.dtintipid = dtintipid;
		this.nif = nif;
		this.dtrango_edad = dtrango_edad;
		this.dtcosx = dtcosx;
		this.coidco = coidco;
		this.esteurl = esteurl;
		this.esnopeco = esnopeco;
		this.esfeba = esfeba;
		this.nrtel = nrtel;
		this.nrtel2 = nrtel2;
		this.coem = coem;
		this.extranjero = extranjero;
		this.noraProvinciaId = noraProvinciaId;
		this.nombreProvincia = nombreProvincia;
		this.noraMunicipioId = noraMunicipioId;
		this.nombreMunicipio = nombreMunicipio;
		this.noraLocalidadId = noraLocalidadId;
		this.nombreLocalidad = nombreLocalidad;
		this.noraCalleId = noraCalleId;
		this.nombreCalle = nombreCalle;
		this.noraCpId = noraCpId;
		this.nombreCp = nombreCp;
		this.noraPortalId = noraPortalId;
		this.nombrePortal = nombrePortal;
		this.nombrePiso = nombrePiso;
		this.noraPaisId = noraPaisId;
		this.nombrePais = nombrePais;
		this.direccionNocapv = direccionNocapv;
		this.direccionAntigua = direccionAntigua;
		this.inadar = inadar;
		this.secodigo = secodigo;
		this.senombre = senombre;
		this.senombree = senombree;
		this.tipoInterviniente = tipoInterviniente;
		this.idExpediente = idExpediente;
		this.tipoProcedimiento = tipoProcedimiento;

		this.infemod = infemod;
		this.incozs = incozs;
		this.usuarioxlnet = usuarioxlnet;
	}

	/**
	 * Method 'Intervinientes'.
	 * 
	 * @param idinterviniente
	 *            String
	 * @param nombre
	 *            String
	 * @param nif
	 *            String
	 * @param esnoco
	 *            String
	 */
	public Intervinientes(String idinterviniente, String nombre, String nif, String esnoco) {
		this.escodigo = (escodigo != null && escodigo.equals("")) ? null : escodigo;
		this.nombre = (nombre != null && nombre.equals("")) ? null : nombre;
		this.nif = (nif != null && nif.equals("")) ? null : nif;
		this.esnoco = (esnoco != null && esnoco.equals("")) ? null : esnoco;
	}

	/**
	 * Method 'getIdinterviniente'.
	 * 
	 * @return String
	 */

	public String getIdinterviniente() {
		return this.idinterviniente;
	}

	/**
	 * Method 'setIdinterviniente'.
	 * 
	 * @param idinterviniente
	 *            String
	 * @return
	 */

	public void setIdinterviniente(String idinterviniente) {
		this.idinterviniente = idinterviniente;
	}

	/**
	 * Method 'getNombre'.
	 * 
	 * @return String
	 */

	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Method 'setNombre'.
	 * 
	 * @param nombre
	 *            String
	 * @return
	 */

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Method 'getNif'.
	 * 
	 * @return String
	 */

	public String getNif() {
		return Y41bUtils.upperCase(this.nif);
	}

	/**
	 * Method 'setNif'.
	 * 
	 * @param nif
	 *            String
	 * @return
	 */

	public void setNif(String nif) {
		this.nif = Y41bUtils.upperCase(nif);
	}

	/**
	 * Method 'getNrtel'.
	 * 
	 * @return String
	 */

	public String getNrtel() {
		return this.nrtel;
	}

	/**
	 * Method 'setNrtel'.
	 * 
	 * @param nrtel
	 *            String
	 * @return
	 */

	public void setNrtel(String nrtel) {
		this.nrtel = nrtel;
	}

	/**
	 * Method 'getNrtel2'.
	 * 
	 * @return String
	 */

	public String getNrtel2() {
		return this.nrtel2;
	}

	/**
	 * Method 'setNrtel2'.
	 * 
	 * @param nrtel2
	 *            String
	 * @return
	 */

	public void setNrtel2(String nrtel2) {
		this.nrtel2 = nrtel2;
	}

	/**
	 * Method 'getCoem'.
	 * 
	 * @return String
	 */

	public String getCoem() {
		return this.coem;
	}

	/**
	 * Method 'setCoem'.
	 * 
	 * @param coem
	 *            String
	 * @return
	 */

	public void setCoem(String coem) {
		this.coem = coem;
	}

	/**
	 * Method 'getNoraProvinciaId'.
	 * 
	 * @return String
	 */

	public String getNoraProvinciaId() {
		return this.noraProvinciaId;
	}

	/**
	 * Method 'setNoraProvinciaId'.
	 * 
	 * @param noraProvinciaId
	 *            String
	 * @return
	 */

	public void setNoraProvinciaId(String noraProvinciaId) {
		this.noraProvinciaId = noraProvinciaId;
	}

	/**
	 * Method 'getNombreProvincia'.
	 * 
	 * @return String
	 */

	public String getNombreProvincia() {
		return this.nombreProvincia;
	}

	/**
	 * Method 'setNombreProvincia'.
	 * 
	 * @param nombreProvincia
	 *            String
	 * @return
	 */

	public void setNombreProvincia(String nombreProvincia) {
		this.nombreProvincia = nombreProvincia;
	}

	/**
	 * Method 'getNoraMunicipioId'.
	 * 
	 * @return String
	 */

	public String getNoraMunicipioId() {
		return this.noraMunicipioId;
	}

	/**
	 * Method 'setNoraMunicipioId'.
	 * 
	 * @param noraMunicipioId
	 *            String
	 * @return
	 */

	public void setNoraMunicipioId(String noraMunicipioId) {
		this.noraMunicipioId = noraMunicipioId;
	}

	/**
	 * Method 'getNombreMunicipio'.
	 * 
	 * @return String
	 */

	public String getNombreMunicipio() {
		return this.nombreMunicipio;
	}

	/**
	 * Method 'setNombreMunicipio'.
	 * 
	 * @param nombreMunicipio
	 *            String
	 * @return
	 */

	public void setNombreMunicipio(String nombreMunicipio) {
		this.nombreMunicipio = nombreMunicipio;
	}

	/**
	 * Method 'getNoraLocalidadId'.
	 * 
	 * @return String
	 */

	public String getNoraLocalidadId() {
		return this.noraLocalidadId;
	}

	/**
	 * Method 'setNoraLocalidadId'.
	 * 
	 * @param noraLocalidadId
	 *            String
	 * @return
	 */

	public void setNoraLocalidadId(String noraLocalidadId) {
		this.noraLocalidadId = noraLocalidadId;
	}

	/**
	 * Method 'getNombreLocalidad'.
	 * 
	 * @return String
	 */

	public String getNombreLocalidad() {
		return this.nombreLocalidad;
	}

	/**
	 * Method 'setNombreLocalidad'.
	 * 
	 * @param nombreLocalidad
	 *            String
	 * @return
	 */

	public void setNombreLocalidad(String nombreLocalidad) {
		this.nombreLocalidad = nombreLocalidad;
	}

	/**
	 * Method 'getNoraCalleId'.
	 * 
	 * @return String
	 */

	public String getNoraCalleId() {
		return this.noraCalleId;
	}

	/**
	 * Method 'setNoraCalleId'.
	 * 
	 * @param noraCalleId
	 *            String
	 * @return
	 */

	public void setNoraCalleId(String noraCalleId) {
		this.noraCalleId = noraCalleId;
	}

	/**
	 * Method 'getNombreCalle'.
	 * 
	 * @return String
	 */

	public String getNombreCalle() {
		return this.nombreCalle;
	}

	/**
	 * Method 'setNombreCalle'.
	 * 
	 * @param nombreCalle
	 *            String
	 * @return
	 */

	public void setNombreCalle(String nombreCalle) {
		this.nombreCalle = nombreCalle;
	}

	/**
	 * Method 'getNoraCpId'.
	 * 
	 * @return String
	 */

	public String getNoraCpId() {
		return this.noraCpId;
	}

	/**
	 * Method 'setNoraCpId'.
	 * 
	 * @param noraCpId
	 *            String
	 * @return
	 */

	public void setNoraCpId(String noraCpId) {
		this.noraCpId = noraCpId;
	}

	/**
	 * Method 'getNombreCp'.
	 * 
	 * @return String
	 */

	public String getNombreCp() {
		return this.nombreCp;
	}

	/**
	 * Method 'setNombreCp'.
	 * 
	 * @param nombreCp
	 *            String
	 * @return
	 */

	public void setNombreCp(String nombreCp) {
		this.nombreCp = nombreCp;
	}

	/**
	 * Method 'getNoraPortalId'.
	 * 
	 * @return String
	 */

	public String getNoraPortalId() {
		return this.noraPortalId;
	}

	/**
	 * Method 'setNoraPortalId'.
	 * 
	 * @param noraPortalId
	 *            String
	 * @return
	 */

	public void setNoraPortalId(String noraPortalId) {
		this.noraPortalId = noraPortalId;
	}

	/**
	 * Method 'getNombrePortal'.
	 * 
	 * @return String
	 */

	public String getNombrePortal() {
		return this.nombrePortal;
	}

	/**
	 * Method 'setNombrePortal'.
	 * 
	 * @param nombrePortal
	 *            String
	 * @return
	 */

	public void setNombrePortal(String nombrePortal) {
		this.nombrePortal = nombrePortal;
	}

	/**
	 * Method 'getNombrePiso'.
	 * 
	 * @return String
	 */

	public String getNombrePiso() {
		return this.nombrePiso;
	}

	/**
	 * Method 'setNombrePiso'.
	 * 
	 * @param nombrePiso
	 *            String
	 * @return
	 */

	public void setNombrePiso(String nombrePiso) {
		this.nombrePiso = nombrePiso;
	}

	/**
	 * Method 'getDireccionNocapv'.
	 * 
	 * @return String
	 */

	public String getDireccionNocapv() {
		return this.direccionNocapv;
	}

	/**
	 * Method 'setDireccionNocapv'.
	 * 
	 * @param direccionNocapv
	 *            String
	 * @return
	 */

	public void setDireccionNocapv(String direccionNocapv) {
		this.direccionNocapv = direccionNocapv;
	}

	/**
	 * Method 'getDireccionAntigua'.
	 * 
	 * @return String
	 */

	public String getDireccionAntigua() {
		return this.direccionAntigua;
	}

	/**
	 * Method 'setDireccionAntigua'.
	 * 
	 * @param direccionAntigua
	 *            String
	 * @return
	 */

	public void setDireccionAntigua(String direccionAntigua) {
		this.direccionAntigua = direccionAntigua;
	}

	/**
	 * Method 'getTipoInterviniente'.
	 * 
	 * @return String
	 */

	public String getTipoInterviniente() {
		return this.tipoInterviniente;
	}

	/**
	 * Method 'setTipoInterviniente'.
	 * 
	 * @param tipoInterviniente
	 *            String
	 * @return
	 */

	public void setTipoInterviniente(String tipoInterviniente) {
		this.tipoInterviniente = tipoInterviniente;
	}

	/**
	 * Method 'getIdExpediente'.
	 * 
	 * @return String
	 */

	public String getIdExpediente() {
		return this.idExpediente;
	}

	/**
	 * Method 'setIdExpediente'.
	 * 
	 * @param idExpediente
	 *            String
	 * @return
	 */

	public void setIdExpediente(String idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * @return the inadar
	 */
	public String getInadar() {
		return inadar;
	}

	/**
	 * @param inadar
	 *            the inadar to set
	 */
	public void setInadar(String inadar) {
		this.inadar = inadar;
	}

	/**
	 * @return the secodigo
	 */
	public String getSecodigo() {
		return secodigo;
	}

	/**
	 * @param secodigo
	 *            the secodigo to set
	 */
	public void setSecodigo(String secodigo) {
		this.secodigo = secodigo;
	}

	/**
	 * @return the senombre
	 */
	public String getSenombre() {
		return senombre;
	}

	/**
	 * @param senombre
	 *            the senombre to set
	 */
	public void setSenombre(String senombre) {
		this.senombre = senombre;
	}

	/**
	 * @return the senombree
	 */
	public String getSenombree() {
		return senombree;
	}

	/**
	 * @param senombree
	 *            the senombree to set
	 */
	public void setSenombree(String senombree) {
		this.senombree = senombree;
	}

	/**
	 * @return the direccionCompleta
	 */
	public String getDireccionCompleta() {
		return direccionCompleta;
	}

	/**
	 * @param direccionCompleta
	 *            the direccionCompleta to set
	 */
	public void setDireccionCompleta(String direccionCompleta) {
		this.direccionCompleta = direccionCompleta;
	}

	/**
	 * @return the tieneDireccionCompleta
	 */
	public boolean isTieneDireccionCompleta() {
		return tieneDireccionCompleta;
	}

	/**
	 * @param tieneDireccionCompleta
	 *            the tieneDireccionCompleta to set
	 */
	public void setTieneDireccionCompleta(boolean tieneDireccionCompleta) {
		this.tieneDireccionCompleta = tieneDireccionCompleta;
	}

	/**
	 * Method 'getTipoProcedimiento'.
	 * 
	 * @return TipoProcedimiento
	 */
	public TipoProcedimiento getTipoProcedimiento() {
		return this.tipoProcedimiento;
	}

	/**
	 * Method 'setTipoProcedimiento'.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return
	 */

	public void setTipoProcedimiento(TipoProcedimiento tipoProcedimiento) {
		this.tipoProcedimiento = tipoProcedimiento;
	}

	/**
	 * @return the apellido1
	 */
	public String getApellido1() {
		return apellido1;
	}

	/**
	 * @param apellido1
	 *            the apellido1 to set
	 */
	public void setApellido1(String apellido1) {
		this.apellido1 = apellido1;
	}

	/**
	 * @return the apellido2
	 */
	public String getApellido2() {
		return apellido2;
	}

	/**
	 * @param apellido2
	 *            the apellido2 to set
	 */
	public void setApellido2(String apellido2) {
		this.apellido2 = apellido2;
	}

	/**
	 * @return the esnoco
	 */
	public String getEsnoco() {
		return esnoco;
	}

	/**
	 * @param esnoco
	 *            the esnoco to set
	 */
	public void setEsnoco(String esnoco) {
		this.esnoco = esnoco;
	}

	/**
	 * @return the extranjero
	 */
	public String getExtranjero() {
		return extranjero;
	}

	/**
	 * @param extranjero
	 *            the extranjero to set
	 */
	public void setExtranjero(String extranjero) {
		this.extranjero = extranjero;
	}

	/**
	 * @return the noraPaisId
	 */
	public String getNoraPaisId() {
		return noraPaisId;
	}

	/**
	 * @param noraPaisId
	 *            the noraPaisId to set
	 */
	public void setNoraPaisId(String noraPaisId) {
		this.noraPaisId = noraPaisId;
	}

	/**
	 * @return the nombrePais
	 */
	public String getNombrePais() {
		return nombrePais;
	}

	/**
	 * @param nombrePais
	 *            the nombrePais to set
	 */
	public void setNombrePais(String nombrePais) {
		this.nombrePais = nombrePais;
	}

	/**
	 * @return the dtcodigo
	 */
	public String getDtcodigo() {
		return dtcodigo;
	}

	/**
	 * @param dtcodigo
	 *            the dtcodigo to set
	 */
	public void setDtcodigo(String dtcodigo) {
		this.dtcodigo = dtcodigo;
	}

	/**
	 * @return the escodigo
	 */
	public String getEscodigo() {
		return escodigo;
	}

	/**
	 * @param escodigo
	 *            the escodigo to set
	 */
	public void setEscodigo(String escodigo) {
		this.escodigo = escodigo;
	}

	/**
	 * @return the entidadId
	 */
	public String getEntidadId() {
		return entidadId;
	}

	/**
	 * @param entidadId
	 *            the entidadId to set
	 */
	public void setEntidadId(String entidadId) {
		this.entidadId = entidadId;
	}

	/**
	 * @return the dtintipid
	 */
	public String getDtintipid() {
		return dtintipid;
	}

	/**
	 * @param dtintipid
	 *            the dtintipid to set
	 */
	public void setDtintipid(String dtintipid) {
		this.dtintipid = dtintipid;
	}

	/**
	 * @return the dtrango_edad
	 */
	public String getDtrango_edad() {
		return dtrango_edad;
	}

	/**
	 * @param dtrango_edad
	 *            the dtrango_edad to set
	 */
	public void setDtrango_edad(String dtrango_edad) {
		this.dtrango_edad = dtrango_edad;
	}

	/**
	 * @return the dtcosx
	 */
	public String getDtcosx() {
		return dtcosx;
	}

	/**
	 * @param dtcosx
	 *            the dtcosx to set
	 */
	public void setDtcosx(String dtcosx) {
		this.dtcosx = dtcosx;
	}

	/**
	 * @return the coidco
	 */
	public String getCoidco() {
		return coidco;
	}

	/**
	 * @param coidco
	 *            the coidco to set
	 */
	public void setCoidco(String coidco) {
		this.coidco = coidco;
	}

	/**
	 * @return the esteurl
	 */
	public String getEsteurl() {
		return esteurl;
	}

	/**
	 * @param esteurl
	 *            the esteurl to set
	 */
	public void setEsteurl(String esteurl) {
		this.esteurl = esteurl;
	}

	/**
	 * @return the esnopeco
	 */
	public String getEsnopeco() {
		return esnopeco;
	}

	/**
	 * @param esnopeco
	 *            the esnopeco to set
	 */
	public void setEsnopeco(String esnopeco) {
		this.esnopeco = esnopeco;
	}

	/**
	 * @return the esfeba
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getEsfeba() {
		return esfeba;
	}

	/**
	 * @param esfeba
	 *            the esfeba to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setEsfeba(Date esfeba) {
		this.esfeba = esfeba;
	}

	/**
	 * Method 'getInfemod'.
	 * 
	 * @return String
	 */
	public String getInfemod() {
		return this.infemod;
	}

	/**
	 * Method 'setInfemod'.
	 * 
	 * @param infemod
	 *            String
	 * @return
	 */
	public void setInfemod(String infemod) {
		this.infemod = infemod;
	}

	public void setIncozs(String incozs) {
		this.incozs = incozs;
	}

	public String getIncozs() {
		return incozs;
	}

	/**
	 * @return the usuarioxlnet
	 */
	public String getUsuarioxlnet() {
		return usuarioxlnet;
	}

	/**
	 * @param usuarioxlnet
	 *            the usuarioxlnet to set
	 */
	public void setUsuarioxlnet(String usuarioxlnet) {
		this.usuarioxlnet = usuarioxlnet;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Intervinientes [idinterviniente=" + idinterviniente + ", dtcodigo=" + dtcodigo + ", escodigo="
				+ escodigo + ", entidadId=" + entidadId + ", nombre=" + nombre + ", apellido1=" + apellido1
				+ ", apellido2=" + apellido2 + ", esnoco=" + esnoco + ", dtintipid=" + dtintipid + ", nif=" + nif
				+ ", dtrango_edad=" + dtrango_edad + ", dtcosx=" + dtcosx + ", coidco=" + coidco + ", esteurl="
				+ esteurl + ", esnopeco=" + esnopeco + ", esfeba=" + esfeba + ", nrtel=" + nrtel + ", nrtel2=" + nrtel2
				+ ", coem=" + coem + ", extranjero=" + extranjero + ", noraProvinciaId=" + noraProvinciaId
				+ ", nombreProvincia=" + nombreProvincia + ", noraMunicipioId=" + noraMunicipioId + ", nombreMunicipio="
				+ nombreMunicipio + ", noraLocalidadId=" + noraLocalidadId + ", nombreLocalidad=" + nombreLocalidad
				+ ", noraCalleId=" + noraCalleId + ", nombreCalle=" + nombreCalle + ", noraCpId=" + noraCpId
				+ ", nombreCp=" + nombreCp + ", noraPortalId=" + noraPortalId + ", nombrePortal=" + nombrePortal
				+ ", nombrePiso=" + nombrePiso + ", noraPaisId=" + noraPaisId + ", nombrePais=" + nombrePais
				+ ", direccionNocapv=" + direccionNocapv + ", direccionAntigua=" + direccionAntigua + ", inadar="
				+ inadar + ", secodigo=" + secodigo + ", senombre=" + senombre + ", senombree=" + senombree
				+ ", tipoInterviniente=" + tipoInterviniente + ", idExpediente=" + idExpediente + ", direccionCompleta="
				+ direccionCompleta + ", tieneDireccionCompleta=" + tieneDireccionCompleta + ",tipoProcedimiento="
				+ tipoProcedimiento + ", infemod=" + infemod + ", incozs=" + incozs + ", usuarioxlnet=" + usuarioxlnet
				+ "]";
	}

	/**
	 * @return the sanFormanotificacion
	 */
	public String getSanFormanotificacion() {
		return sanFormanotificacion;
	}

	/**
	 * @param sanFormanotificacion
	 *            the sanFormanotificacion to set
	 */
	public void setSanFormanotificacion(String sanFormanotificacion) {
		this.sanFormanotificacion = sanFormanotificacion;
	}

	/**
	 * @return the arbFormanotificacion
	 */
	public String getArbFormanotificacion() {
		return arbFormanotificacion;
	}

	/**
	 * @param arbFormanotificacion
	 *            the arbFormanotificacion to set
	 */
	public void setArbFormanotificacion(String arbFormanotificacion) {
		this.arbFormanotificacion = arbFormanotificacion;
	}

	/**
	 * @return the activos
	 */
	public String getActivos() {
		return activos;
	}

	/**
	 * @param activos
	 *            the activos to set
	 */
	public void setActivos(String activos) {
		this.activos = activos;
	}

	/**
	 * @return the insFormanotificacion
	 */
	public String getInsFormanotificacion() {
		return insFormanotificacion;
	}

	/**
	 * @param insFormanotificacion
	 *            the insFormanotificacion to set
	 */
	public void setInsFormanotificacion(String insFormanotificacion) {
		this.insFormanotificacion = insFormanotificacion;
	}

	/**
	 * @return the solFormanotificacion
	 */
	public String getSolFormanotificacion() {
		return solFormanotificacion;
	}

	/**
	 * @param solFormanotificacion
	 *            the solFormanotificacion to set
	 */
	public void setSolFormanotificacion(String solFormanotificacion) {
		this.solFormanotificacion = solFormanotificacion;
	}

	/**
	 * @return the establecimientoCerrado
	 */
	public String getEstablecimientoCerrado() {
		return establecimientoCerrado;
	}

	/**
	 * @param establecimientoCerrado
	 *            the establecimientoCerrado to set
	 */
	public void setEstablecimientoCerrado(String establecimientoCerrado) {
		this.establecimientoCerrado = establecimientoCerrado;
	}

	public void setExhdformanotiforigen(String exhdformanotiforigen) {
		this.exhdformanotiforigen = exhdformanotiforigen;
	}

	public String getExhdformanotiforigen() {
		return exhdformanotiforigen;
	}

}
