package com.ejie.y41b.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;

/**
 * InfraccHechoDen  
 * 
 *  
 */

public class InfraccHechoDen implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String hicodigo;
	private String hicohd;
	private String hiinexii;
	private String hiifid;
	private String tipo;
	private Date hifecalta;
	private Date hifecmodif;
	private String hiusualta;
	private String hiusumodif;

	private List<InfraccHechoDenExpSanc> infraccHechoDenExpSancs = new ArrayList<InfraccHechoDenExpSanc>();
	private TipReqNormativo tipReqNormativo;

	/**
	 * Method 'InfraccHechoDen'.
	 */
	public InfraccHechoDen() {
	}

	/**
	 * Method 'InfraccHechoDen'.
	 * 
	 * @param hicodigo
	 *            String
	 * @param hicohd
	 *            String
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param hiinexii
	 *            String
	 * @param hiifid
	 *            String
	 */
	public InfraccHechoDen(String hicodigo, String hicohd,
			TipReqNormativo tipReqNormativo, String hiinexii, String hiifid) {
		this.hicodigo = hicodigo;
		this.hicohd = hicohd;
		this.hiinexii = hiinexii;
		this.hiifid = hiifid;
		this.tipReqNormativo = tipReqNormativo;
	}

	/**
	 * @return the tipo
	 */
	public String getTipo() {
		return this.tipo;
	}

	/**
	 * @param tipo
	 *            the tipo to set
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * Method 'InfraccHechoDen'.
	 * 
	 * @param hicodigo
	 *            String
	 * @param hicohd
	 *            String
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param hiinexii
	 *            String
	 * @param hiifid
	 *            String
	 * @param tipo
	 *            String
	 */
	public InfraccHechoDen(String hicodigo, String hicohd,
			TipReqNormativo tipReqNormativo, String hiinexii, String hiifid,
			String tipo) {
		this.hicodigo = hicodigo;
		this.hicohd = hicohd;
		this.hiinexii = hiinexii;
		this.hiifid = hiifid;
		this.tipReqNormativo = tipReqNormativo;
		this.tipo = tipo;
	}

	/**
	 * Method 'InfraccHechoDen'.
	 * 
	 * @param hicodigo
	 *            String
	 * @param hicohd
	 *            String
	 * @param hicotti
	 *            String
	 * @param hiinexii
	 *            String
	 * @param hiifid
	 *            String
	 * @param infraccHechoDenExpSancs
	 *            List<InfraccHechoDenExpSanc>
	 */
	public InfraccHechoDen(String hicodigo, String hicohd, String hicotti,
			String hiinexii, String hiifid,
			List<InfraccHechoDenExpSanc> infraccHechoDenExpSancs) {

		this.hicodigo = hicodigo;
		this.hicohd = hicohd;
		this.hiinexii = hiinexii;
		this.hiifid = hiifid;
		this.infraccHechoDenExpSancs = infraccHechoDenExpSancs;
	}

	/**
	 * Method 'getHicodigo'.
	 * 
	 * @return String
	 */

	public String getHicodigo() {
		return this.hicodigo;
	}

	/**
	 * Method 'setHicodigo'.
	 * 
	 * @param hicodigo
	 *            String
	 * @return
	 */

	public void setHicodigo(String hicodigo) {
		this.hicodigo = hicodigo;
	}

	/**
	 * Method 'getHicohd'.
	 * 
	 * @return String
	 */

	public String getHicohd() {
		return this.hicohd;
	}

	/**
	 * Method 'setHicohd'.
	 * 
	 * @param hicohd
	 *            String
	 * @return
	 */

	public void setHicohd(String hicohd) {
		this.hicohd = hicohd;
	}

	/**
	 * Method 'getHiinexii'.
	 * 
	 * @return String
	 */

	public String getHiinexii() {
		return this.hiinexii;
	}

	/**
	 * Method 'setHiinexii'.
	 * 
	 * @param hiinexii
	 *            String
	 * @return
	 */

	public void setHiinexii(String hiinexii) {
		this.hiinexii = hiinexii;
	}

	/**
	 * Method 'getHiifid'.
	 * 
	 * @return String
	 */

	public String getHiifid() {
		return this.hiifid;
	}

	/**
	 * Method 'setHiifid'.
	 * 
	 * @param hiifid
	 *            String
	 * @return
	 */

	public void setHiifid(String hiifid) {
		this.hiifid = hiifid;
	}

	/**
	 * Method 'getInfraccHechoDenExpSancs'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<InfraccHechoDenExpSanc> getInfraccHechoDenExpSancs() {
		return this.infraccHechoDenExpSancs;
	}

	/**
	 * Method 'setInfraccHechoDenExpSancs'.
	 * 
	 * @param infraccHechoDenExpSancs
	 *            List
	 * @return
	 */
	public void setInfraccHechoDenExpSancs(
			List<InfraccHechoDenExpSanc> infraccHechoDenExpSancs) {
		this.infraccHechoDenExpSancs = infraccHechoDenExpSancs;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ hicodigo: ").append(this.hicodigo).append(" ]");
		result.append(", [ hicohd: ").append(this.hicohd).append(" ]");
		result.append(", [ hiinexii: ").append(this.hiinexii).append(" ]");
		result.append(", [ hiifid: ").append(this.hiifid).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the tipReqNormativo
	 */
	public TipReqNormativo getTipReqNormativo() {
		return this.tipReqNormativo;
	}

	/**
	 * @param tipReqNormativo
	 *            the tipReqNormativo to set
	 */
	public void setTipReqNormativo(TipReqNormativo tipReqNormativo) {
		this.tipReqNormativo = tipReqNormativo;
	}

	/**
	 * @return the hifecalta
	 */
	public Date getHifecalta() {
		return this.hifecalta;
	}

	/**
	 * @param hifecalta
	 *            the hifecalta to set
	 */
	public void setHifecalta(Date hifecalta) {
		this.hifecalta = hifecalta;
	}

	/**
	 * @return the hifecmodif
	 */
	public Date getHifecmodif() {
		return this.hifecmodif;
	}

	/**
	 * @param hifecmodif
	 *            the hifecmodif to set
	 */
	public void setHifecmodif(Date hifecmodif) {
		this.hifecmodif = hifecmodif;
	}

	/**
	 * @return the hiusualta
	 */
	public String getHiusualta() {
		return this.hiusualta;
	}

	/**
	 * @param hiusualta
	 *            the hiusualta to set
	 */
	public void setHiusualta(String hiusualta) {
		this.hiusualta = hiusualta;
	}

	/**
	 * @return the hiusumodif
	 */
	public String getHiusumodif() {
		return this.hiusumodif;
	}

	/**
	 * @param hiusumodif
	 *            the hiusumodif to set
	 */
	public void setHiusumodif(String hiusumodif) {
		this.hiusumodif = hiusumodif;
	}

}
