package com.ejie.y41b.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;

/**
 * InfraccArb  
 * 
 *  
 */

public class InfraccArb implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String hicodigo;
	private String hicoarb;
	private String hiinexii;
	private String hiifid;
	private String tipo;

	private List<InfraccHechoDenExpSanc> infraccArbExpSancs = new ArrayList<InfraccHechoDenExpSanc>();
	private TipReqNormativo tipReqNormativo;

	/**
	 * Method 'InfraccArb'.
	 */
	public InfraccArb() {
	}

	/**
	 * Method 'InfraccArb'.
	 * 
	 * @param hicodigo
	 *            String
	 * @param hicoarb
	 *            String
	 * @param hicotti
	 *            String
	 * @param hiinexii
	 *            String
	 * @param hiifid
	 *            String
	 */
	public InfraccArb(String hicodigo, String hicoarb,
			TipReqNormativo tipReqNormativo, String hiinexii, String hiifid) {
		this.hicodigo = hicodigo;
		this.hicoarb = hicoarb;
		this.hiinexii = hiinexii;
		this.hiifid = hiifid;
		this.tipReqNormativo = tipReqNormativo;
	}

	/**
	 * @return the tipo
	 */
	public String getTipo() {
		return tipo;
	}

	/**
	 * @param tipo
	 *            the tipo to set
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * Method 'InfraccArb'.
	 * 
	 * @param hicodigo
	 *            String
	 * @param hicoarb
	 *            String
	 * @param hicotti
	 *            String
	 * @param hiinexii
	 *            String
	 * @param hiifid
	 *            String
	 */
	public InfraccArb(String hicodigo, String hicoarb,
			TipReqNormativo tipReqNormativo, String hiinexii, String hiifid,
			String tipo) {
		this.hicodigo = hicodigo;
		this.hicoarb = hicoarb;
		this.hiinexii = hiinexii;
		this.hiifid = hiifid;
		this.tipReqNormativo = tipReqNormativo;
		this.tipo = tipo;
	}

	/**
	 * Method 'InfraccArb'.
	 * 
	 * @param hicodigo
	 *            String
	 * @param hicoarb
	 *            String
	 * @param hicotti
	 *            String
	 * @param hiinexii
	 *            String
	 * @param hiifid
	 *            String
	 * @param infraccArbExpSancs
	 *            List<InfraccHechoDenExpSanc>
	 */
	public InfraccArb(String hicodigo, String hicoarb, String hicotti,
			String hiinexii, String hiifid,
			List<InfraccHechoDenExpSanc> infraccArbExpSancs) {

		this.hicodigo = hicodigo;
		this.hicoarb = hicoarb;
		this.hiinexii = hiinexii;
		this.hiifid = hiifid;
		this.infraccArbExpSancs = infraccArbExpSancs;
	}

	/**
	 * Method 'getHicodigo'.
	 * 
	 * @return String
	 */

	public String getHicodigo() {
		return this.hicodigo;
	}

	/**
	 * Method 'setHicodigo'.
	 * 
	 * @param hicodigo
	 *            String
	 * @return
	 */

	public void setHicodigo(String hicodigo) {
		this.hicodigo = hicodigo;
	}

	/**
	 * Method 'getHicoarb'.
	 * 
	 * @return String
	 */

	public String getHicoarb() {
		return this.hicoarb;
	}

	/**
	 * Method 'setHicoarb'.
	 * 
	 * @param hicoarb
	 *            String
	 * @return
	 */

	public void setHicoarb(String hicoarb) {
		this.hicoarb = hicoarb;
	}

	/**
	 * Method 'getHiinexii'.
	 * 
	 * @return String
	 */

	public String getHiinexii() {
		return this.hiinexii;
	}

	/**
	 * Method 'setHiinexii'.
	 * 
	 * @param hiinexii
	 *            String
	 * @return
	 */

	public void setHiinexii(String hiinexii) {
		this.hiinexii = hiinexii;
	}

	/**
	 * Method 'getHiifid'.
	 * 
	 * @return String
	 */

	public String getHiifid() {
		return this.hiifid;
	}

	/**
	 * Method 'setHiifid'.
	 * 
	 * @param hiifid
	 *            String
	 * @return
	 */

	public void setHiifid(String hiifid) {
		this.hiifid = hiifid;
	}

	/**
	 * Method 'getInfraccHechoDenExpSancs'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<InfraccHechoDenExpSanc> getInfraccHechoDenExpSancs() {
		return this.infraccArbExpSancs;
	}

	/**
	 * Method 'setInfraccHechoDenExpSancs'.
	 * 
	 * @param infraccArbExpSancs
	 *            List
	 * @return
	 */
	public void setInfraccHechoDenExpSancs(
			List<InfraccHechoDenExpSanc> infraccArbExpSancs) {
		this.infraccArbExpSancs = infraccArbExpSancs;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ hicodigo: ").append(this.hicodigo).append(" ]");
		result.append(", [ hicoarb: ").append(this.hicoarb).append(" ]");
		result.append(", [ hiinexii: ").append(this.hiinexii).append(" ]");
		result.append(", [ hiifid: ").append(this.hiifid).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the tipReqNormativo
	 */
	public TipReqNormativo getTipReqNormativo() {
		return tipReqNormativo;
	}

	/**
	 * @param tipReqNormativo
	 *            the tipReqNormativo to set
	 */
	public void setTipReqNormativo(TipReqNormativo tipReqNormativo) {
		this.tipReqNormativo = tipReqNormativo;
	}

}
