package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.math.BigDecimal;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Historico  
 * 
 *  
 */

public class Historico implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String shcodigo;
	private Movimientos movimientos;
	private String shreferencia;
	private String shexpediente;
	private String shidexpediente;
	private String shcodproc;
	private String shidestablecimiento;
	private Date shfechaemision;
	private String shidestadopago;
	private Date shfechaestado;
	private Date shfechalimitepago;
	private Date shfechapago;
	private String shidmetodopago;
	private String shfraccionado;
	private BigDecimal shimporte;
	private String shidconcepto;
	private String shdescripcionpago;
	private String shobservaciones;
	private String shdigitocontrol;
	private String shreferenciafracc;
	private BigDecimal shimporteinteres;
	private Long shnumfraccion;

	/**
	 * Method 'Historico'.
	 */
	public Historico() {
	}

	/**
	 * Method 'Historico'.
	 * 
	 * @param pagos
	 *            Pagos
	 */
	public Historico(Pagos pagos, Movimientos movimientos) {

		this.movimientos = movimientos;
		if (pagos != null) {
			this.shreferencia = pagos.getSgreferencia();
			this.shexpediente = pagos.getSgexpediente();
			this.shidexpediente = pagos.getSgidexpediente();
			this.shcodproc = pagos.getSgcodproc();
			this.shidestablecimiento = pagos.getSgestablecimiento()
					.getEscodigo();
			this.shfechaemision = pagos.getSgfechaemision();
			this.shidestadopago = pagos.getEstadopago().getSacodigo();
			this.shfechaestado = pagos.getSgfechaestado();
			this.shfechalimitepago = pagos.getSgfechalimitepago();
			this.shfechapago = pagos.getSgfechapago();
			this.shidmetodopago = pagos.getMetodopago().getSbcodigo();
			this.shfraccionado = pagos.getSgfraccionado();
			this.shimporte = pagos.getSgimporte();
			this.shidconcepto = pagos.getConceptopago().getSdcodigo();
			this.shdescripcionpago = pagos.getSgdescripcionpago();
			this.shobservaciones = pagos.getSgobservaciones();
			this.shdigitocontrol = pagos.getSgdigitocontrol();
			this.shreferenciafracc = pagos.getSgreferenciafracc();
			this.shimporteinteres = pagos.getSgimporteinteres();
			this.shnumfraccion = pagos.getSgnumfraccion();
		}
	}

	/**
	 * Method 'Historico'.
	 * 
	 * @param shcodigo
	 *            String
	 * @param shreferencia
	 *            String
	 * @param shexpediente
	 *            String
	 * @param shidexpediente
	 *            String
	 * @param shcodproc
	 *            String
	 * @param shidestablecimiento
	 *            String
	 * @param shfechaemision
	 *            Date
	 * @param shidestadopago
	 *            String
	 * @param shfechaestado
	 *            Date
	 * @param shfechalimitepago
	 *            Date
	 * @param shfechapago
	 *            Date
	 * @param shidmetodopago
	 *            String
	 * @param shfraccionado
	 *            String
	 * @param shimporte
	 *            BigDecimal
	 * @param shidconcepto
	 *            String
	 * @param shdescripcionpago
	 *            String
	 * @param shobservaciones
	 *            String
	 * @param shdigitocontrol
	 *            String
	 * @param shreferenciafracc
	 *            String
	 * @param shimporteinteres
	 *            BigDecimal
	 * @param shnumfraccion
	 *            Long
	 * @param movimientos
	 *            Movimientos
	 */
	public Historico(String shcodigo, String shreferencia, String shexpediente,
			String shidexpediente, String shcodproc,
			String shidestablecimiento, Date shfechaemision,
			String shidestadopago, Date shfechaestado, Date shfechalimitepago,
			Date shfechapago, String shidmetodopago, String shfraccionado,
			BigDecimal shimporte, String shidconcepto,
			String shdescripcionpago, String shobservaciones,
			String shdigitocontrol, String shreferenciafracc,
			BigDecimal shimporteinteres, Long shnumfraccion,
			Movimientos movimientos) {

		this.shcodigo = shcodigo;
		this.movimientos = movimientos;
		this.shreferencia = shreferencia;
		this.shexpediente = shexpediente;
		this.shidexpediente = shidexpediente;
		this.shcodproc = shcodproc;
		this.shidestablecimiento = shidestablecimiento;
		this.shfechaemision = shfechaemision;
		this.shidestadopago = shidestadopago;
		this.shfechaestado = shfechaestado;
		this.shfechalimitepago = shfechalimitepago;
		this.shfechapago = shfechapago;
		this.shidmetodopago = shidmetodopago;
		this.shfraccionado = shfraccionado;
		this.shimporte = shimporte;
		this.shidconcepto = shidconcepto;
		this.shdescripcionpago = shdescripcionpago;
		this.shobservaciones = shobservaciones;
		this.shdigitocontrol = shdigitocontrol;
		this.shreferenciafracc = shreferenciafracc;
		this.shimporteinteres = shimporteinteres;
		this.shnumfraccion = shnumfraccion;
	}

	/**
	 * Method 'getShcodigo'.
	 * 
	 * @return String
	 */

	public String getShcodigo() {
		return this.shcodigo;
	}

	/**
	 * Method 'setShcodigo'.
	 * 
	 * @param shcodigo
	 *            String
	 * @return
	 */

	public void setShcodigo(String shcodigo) {
		this.shcodigo = shcodigo;
	}

	/**
	 * Method 'getMovimientos'.
	 * 
	 * @return Movimientos
	 */
	@JsonIgnore
	public Movimientos getMovimientos() {
		return this.movimientos;
	}

	/**
	 * Method 'setMovimientos'.
	 * 
	 * @param movimientos
	 *            Movimientos
	 * @return
	 */

	public void setMovimientos(Movimientos movimientos) {
		this.movimientos = movimientos;
	}

	/**
	 * Method 'getShreferencia'.
	 * 
	 * @return String
	 */

	public String getShreferencia() {
		return this.shreferencia;
	}

	/**
	 * Method 'setShreferencia'.
	 * 
	 * @param shreferencia
	 *            String
	 * @return
	 */

	public void setShreferencia(String shreferencia) {
		this.shreferencia = shreferencia;
	}

	/**
	 * Method 'getShexpediente'.
	 * 
	 * @return String
	 */

	public String getShexpediente() {
		return this.shexpediente;
	}

	/**
	 * Method 'setShexpediente'.
	 * 
	 * @param shexpediente
	 *            String
	 * @return
	 */

	public void setShexpediente(String shexpediente) {
		this.shexpediente = shexpediente;
	}

	/**
	 * Method 'getShidexpediente'.
	 * 
	 * @return String
	 */

	public String getShidexpediente() {
		return this.shidexpediente;
	}

	/**
	 * Method 'setShidexpediente'.
	 * 
	 * @param shidexpediente
	 *            String
	 * @return
	 */

	public void setShidexpediente(String shidexpediente) {
		this.shidexpediente = shidexpediente;
	}

	/**
	 * Method 'getShcodproc'.
	 * 
	 * @return String
	 */

	public String getShcodproc() {
		return this.shcodproc;
	}

	/**
	 * Method 'setShcodproc'.
	 * 
	 * @param shcodproc
	 *            String
	 * @return
	 */

	public void setShcodproc(String shcodproc) {
		this.shcodproc = shcodproc;
	}

	/**
	 * Method 'getShidestablecimiento'.
	 * 
	 * @return String
	 */

	public String getShidestablecimiento() {
		return this.shidestablecimiento;
	}

	/**
	 * Method 'setShidestablecimiento'.
	 * 
	 * @param shidestablecimiento
	 *            String
	 * @return
	 */

	public void setShidestablecimiento(String shidestablecimiento) {
		this.shidestablecimiento = shidestablecimiento;
	}

	/**
	 * Method 'getShfechaemision'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getShfechaemision() {
		return this.shfechaemision;
	}

	/**
	 * Method 'setShfechaemision'.
	 * 
	 * @param shfechaemision
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setShfechaemision(Date shfechaemision) {
		this.shfechaemision = shfechaemision;
	}

	/**
	 * Method 'getShidestadopago'.
	 * 
	 * @return String
	 */

	public String getShidestadopago() {
		return this.shidestadopago;
	}

	/**
	 * Method 'setShidestadopago'.
	 * 
	 * @param shidestadopago
	 *            String
	 * @return
	 */

	public void setShidestadopago(String shidestadopago) {
		this.shidestadopago = shidestadopago;
	}

	/**
	 * Method 'getShfechaestado'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getShfechaestado() {
		return this.shfechaestado;
	}

	/**
	 * Method 'setShfechaestado'.
	 * 
	 * @param shfechaestado
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setShfechaestado(Date shfechaestado) {
		this.shfechaestado = shfechaestado;
	}

	/**
	 * Method 'getShfechalimitepago'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getShfechalimitepago() {
		return this.shfechalimitepago;
	}

	/**
	 * Method 'setShfechalimitepago'.
	 * 
	 * @param shfechalimitepago
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setShfechalimitepago(Date shfechalimitepago) {
		this.shfechalimitepago = shfechalimitepago;
	}

	/**
	 * Method 'getShfechapago'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getShfechapago() {
		return this.shfechapago;
	}

	/**
	 * Method 'setShfechapago'.
	 * 
	 * @param shfechapago
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setShfechapago(Date shfechapago) {
		this.shfechapago = shfechapago;
	}

	/**
	 * Method 'getShidmetodopago'.
	 * 
	 * @return String
	 */

	public String getShidmetodopago() {
		return this.shidmetodopago;
	}

	/**
	 * Method 'setShidmetodopago'.
	 * 
	 * @param shidmetodopago
	 *            String
	 * @return
	 */

	public void setShidmetodopago(String shidmetodopago) {
		this.shidmetodopago = shidmetodopago;
	}

	/**
	 * Method 'getShfraccionado'.
	 * 
	 * @return String
	 */

	public String getShfraccionado() {
		return this.shfraccionado;
	}

	/**
	 * Method 'setShfraccionado'.
	 * 
	 * @param shfraccionado
	 *            String
	 * @return
	 */

	public void setShfraccionado(String shfraccionado) {
		this.shfraccionado = shfraccionado;
	}

	/**
	 * Method 'getShimporte'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getShimporte() {
		return this.shimporte;
	}

	/**
	 * Method 'setShimporte'.
	 * 
	 * @param shimporte
	 *            BigDecimal
	 * @return
	 */

	public void setShimporte(BigDecimal shimporte) {
		this.shimporte = shimporte;
	}

	/**
	 * Method 'getShidconcepto'.
	 * 
	 * @return String
	 */

	public String getShidconcepto() {
		return this.shidconcepto;
	}

	/**
	 * Method 'setShidconcepto'.
	 * 
	 * @param shidconcepto
	 *            String
	 * @return
	 */

	public void setShidconcepto(String shidconcepto) {
		this.shidconcepto = shidconcepto;
	}

	/**
	 * Method 'getShdescripcionpago'.
	 * 
	 * @return String
	 */

	public String getShdescripcionpago() {
		return this.shdescripcionpago;
	}

	/**
	 * Method 'setShdescripcionpago'.
	 * 
	 * @param shdescripcionpago
	 *            String
	 * @return
	 */

	public void setShdescripcionpago(String shdescripcionpago) {
		this.shdescripcionpago = shdescripcionpago;
	}

	/**
	 * Method 'getShobservaciones'.
	 * 
	 * @return String
	 */

	public String getShobservaciones() {
		return this.shobservaciones;
	}

	/**
	 * Method 'setShobservaciones'.
	 * 
	 * @param shobservaciones
	 *            String
	 * @return
	 */

	public void setShobservaciones(String shobservaciones) {
		this.shobservaciones = shobservaciones;
	}

	/**
	 * Method 'getShdigitocontrol'.
	 * 
	 * @return String
	 */

	public String getShdigitocontrol() {
		return this.shdigitocontrol;
	}

	/**
	 * Method 'setShdigitocontrol'.
	 * 
	 * @param shdigitocontrol
	 *            String
	 * @return
	 */

	public void setShdigitocontrol(String shdigitocontrol) {
		this.shdigitocontrol = shdigitocontrol;
	}

	/**
	 * Method 'getShreferenciafracc'.
	 * 
	 * @return String
	 */

	public String getShreferenciafracc() {
		return this.shreferenciafracc;
	}

	/**
	 * Method 'setShreferenciafracc'.
	 * 
	 * @param shreferenciafracc
	 *            String
	 * @return
	 */

	public void setShreferenciafracc(String shreferenciafracc) {
		this.shreferenciafracc = shreferenciafracc;
	}

	/**
	 * Method 'getShimporteinteres'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getShimporteinteres() {
		return this.shimporteinteres;
	}

	/**
	 * Method 'setShimporteinteres'.
	 * 
	 * @param shimporteinteres
	 *            BigDecimal
	 * @return
	 */

	public void setShimporteinteres(BigDecimal shimporteinteres) {
		this.shimporteinteres = shimporteinteres;
	}

	/**
	 * Method 'getShnumfraccion'.
	 * 
	 * @return Long
	 */

	public Long getShnumfraccion() {
		return this.shnumfraccion;
	}

	/**
	 * Method 'setShnumfraccion'.
	 * 
	 * @param shnumfraccion
	 *            Long
	 * @return
	 */

	public void setShnumfraccion(Long shnumfraccion) {
		this.shnumfraccion = shnumfraccion;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ shcodigo: ").append(this.shcodigo).append(" ]");
		result.append(", [ shreferencia: ").append(this.shreferencia)
				.append(" ]");
		result.append(", [ shexpediente: ").append(this.shexpediente)
				.append(" ]");
		result.append(", [ shidexpediente: ").append(this.shidexpediente)
				.append(" ]");
		result.append(", [ shcodproc: ").append(this.shcodproc).append(" ]");
		result.append(", [ shidestablecimiento: ")
				.append(this.shidestablecimiento).append(" ]");
		result.append(", [ shfechaemision: ").append(this.shfechaemision)
				.append(" ]");
		result.append(", [ shidestadopago: ").append(this.shidestadopago)
				.append(" ]");
		result.append(", [ shfechaestado: ").append(this.shfechaestado)
				.append(" ]");
		result.append(", [ shfechalimitepago: ").append(this.shfechalimitepago)
				.append(" ]");
		result.append(", [ shfechapago: ").append(this.shfechapago)
				.append(" ]");
		result.append(", [ shidmetodopago: ").append(this.shidmetodopago)
				.append(" ]");
		result.append(", [ shfraccionado: ").append(this.shfraccionado)
				.append(" ]");
		result.append(", [ shimporte: ").append(this.shimporte).append(" ]");
		result.append(", [ shidconcepto: ").append(this.shidconcepto)
				.append(" ]");
		result.append(", [ shdescripcionpago: ").append(this.shdescripcionpago)
				.append(" ]");
		result.append(", [ shobservaciones: ").append(this.shobservaciones)
				.append(" ]");
		result.append(", [ shdigitocontrol: ").append(this.shdigitocontrol)
				.append(" ]");
		result.append(", [ shreferenciafracc: ").append(this.shreferenciafracc)
				.append(" ]");
		result.append(", [ shimporteinteres: ").append(this.shimporteinteres)
				.append(" ]");
		result.append(", [ shnumfraccion: ").append(this.shnumfraccion)
				.append(" ]");
		result.append("}");
		return result.toString();
	}

}
