package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

import org.springframework.context.support.ReloadableResourceBundleMessageSource;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * Pagos  
 * 
 *  
 */

public class Fraccionamiento implements java.io.Serializable {

	/**
     * 
     */
	private static final long serialVersionUID = 1L;

	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Method 'Pagos'.
	 */
	public Fraccionamiento() {
	}

	/**
	 * Deletes multiple rows in the Sanfracsipca table.
	 * 
	 * @param pagoLiquidacion
	 *            the pago liquidacion
	 * @return the sanfracsipca
	 */

	public Sanfracsipca creaCabeceraFraccionamiento(Pagos pagoLiquidacion) {
		/*
		 * AHORA CARGAMOS EL REGISTRO EN LA TABLA FRACCIONAMIENTO DONDE IRA LA
		 * CABECERA DE LA LLAMADA
		 */
		Date hoy = new Date();
		Conceptopago conceptoLiquidacion = pagoLiquidacion.getConceptopago();
		String descripcionFraccionEstandar = appMessageSource.getMessage(
				"sanciones.calificacion.leve", null, new Locale(
						Y41bConstantes.CASTELLANO));

		Sanfracsipca cabeceraFraccionamiento = new Sanfracsipca();
		cabeceraFraccionamiento
				.setLftipreg(Y41bConstantes.CABECERA_LIQUIDACION_TIPO_REGISTRO);/* 1 */
		cabeceraFraccionamiento
				.setLftipop(Y41bConstantes.OPERACION_SIPCA_FRACCIONAMIENTO);/* 2 */
		cabeceraFraccionamiento.setLfentem(conceptoLiquidacion
				.getSdentemisora());/* 3 */
		cabeceraFraccionamiento.setLfsufijo(conceptoLiquidacion.getSdsufijo()
				.toString());/* 4 */

		// ***** CAMPOS DE LA TABLA PAGOS
		cabeceraFraccionamiento.setLfnumref(pagoLiquidacion.getSgreferencia());/* 5 */
		cabeceraFraccionamiento.setLfdigcon(pagoLiquidacion
				.getSgdigitocontrol());/* 6 */
		cabeceraFraccionamiento.setLffeclimpa(pagoLiquidacion
				.getSgfechalimitepago());/* 7 */
		BigDecimal importe = pagoLiquidacion.getSgimporte();
		String importeCentimos = Y41bUtils.transformarEurosACents(importe);
		cabeceraFraccionamiento.setLfimporte(importeCentimos);/* 8 */
		cabeceraFraccionamiento.setLffecoper(hoy);/* 9 */

		// ****** FIN PRIMERA PARTE
		cabeceraFraccionamiento.setLffecsolic(hoy);/* 10 */
		String calcularTipoTercero = ""; /* TODO: AMAIA CALCULAR TIPO TERCERO */
		cabeceraFraccionamiento.setLftipter(calcularTipoTercero);/* 11 */
		String cif = ""; /* TODO: AMAIA CALCULAR CIF */

		/* TODO: AMAIA DATOS SOBRE EL SANCIONADO */
		cabeceraFraccionamiento.setLfcif(cif);/* 12 */
		cabeceraFraccionamiento.setLfnombre("");/* 13 */
		cabeceraFraccionamiento.setLfape1("");/* 14 */
		cabeceraFraccionamiento.setLfape2("");/* 15 */
		cabeceraFraccionamiento.setLftel("");/* 16 */
		cabeceraFraccionamiento.setLffax("");/* 17 */
		cabeceraFraccionamiento.setLfemail("");/* 18 */

		/* TODO: AMAIA DATOS SOBRE LA DIRECCION DEL SANCIONADO */
		cabeceraFraccionamiento.setLfsigl("");/* 19 */
		cabeceraFraccionamiento.setLfviapu("");/* 20 */
		cabeceraFraccionamiento.setLfportal("");/* 21 */
		cabeceraFraccionamiento.setLfletra("");/* 22 */
		cabeceraFraccionamiento.setLfescal("");/* 23 */
		cabeceraFraccionamiento.setLfpiso("");/* 24 */
		cabeceraFraccionamiento.setLfpuerta("");/* 25 */
		cabeceraFraccionamiento.setLfcodprov("");/* 26 */
		cabeceraFraccionamiento.setLfcodmun("");/* 27 */
		cabeceraFraccionamiento.setLfcodloc("");/* 28 */
		cabeceraFraccionamiento.setLfcodpos("");/* 29 */

		/* TODO: AMAIA DATOS SOBRE LA FRACCION */
		cabeceraFraccionamiento
				.setLfcodcau(Y41bConstantes.CABECERA_LIQUIDACION_CODIGO_CAUSA);/* 30 */
		cabeceraFraccionamiento.setLfmotcau(descripcionFraccionEstandar);/* 31 */
		cabeceraFraccionamiento.setLfpropag("");/* 32 */// DATO DE LA PANTALLA
		cabeceraFraccionamiento.setLfmotpro(descripcionFraccionEstandar);/* 33 */
		cabeceraFraccionamiento.setLfcuenta("");/* 34 */// DATO DE LA PANTALLA
		cabeceraFraccionamiento.setLfexgara("");/* 35 */// CALCULAR
		cabeceraFraccionamiento.setLftipgara("");/* 36 */// CALCULAR
		cabeceraFraccionamiento.setLffecdep(null);/* 37 */
		cabeceraFraccionamiento.setLffecaporav(null);/* 38 */
		cabeceraFraccionamiento.setLfindicsuf(null);/* 39 */
		cabeceraFraccionamiento.setLffecnotif(null);/* 40 */
		cabeceraFraccionamiento.setLffecinform(null);/* 41 */
		cabeceraFraccionamiento.setLffecresol(null);/* 42 */
		cabeceraFraccionamiento
				.setLfestimresol(Y41bConstantes.CABECERA_LIQUIDACION_ESTIMACION_RESOLUCION);/* 43 */
		cabeceraFraccionamiento.setLfmotres(descripcionFraccionEstandar);/* 44 */
		cabeceraFraccionamiento.setLfnumpl("");/* 45 */// DATO DE LA PANTALLA
		cabeceraFraccionamiento.setLffrecpl("");/* 46 */// DATO DE LA PANTALLA
		cabeceraFraccionamiento.setLffeclim1pa(hoy); // CALCULAR /*47*/
		cabeceraFraccionamiento.setLfporcdem("");/* 48 */// SACAR DE PARAMETROS
		cabeceraFraccionamiento
				.setLftippag(Y41bConstantes.CABECERA_LIQUIDACION_TIPO_DE_PAGO);/* 49 */
		cabeceraFraccionamiento
				.setLftipnot(Y41bConstantes.CABECERA_LIQUIDACION_TIPO_NOTIFICACION);/* 50 */
		cabeceraFraccionamiento.setLffecnotresol(hoy);/* 51 */
		cabeceraFraccionamiento.setLffecinval(null);/* 52 */
		cabeceraFraccionamiento.setLftipinval(null);/* 53 */
		cabeceraFraccionamiento.setLfmotinval(null);/* 54 */
		cabeceraFraccionamiento.setLffecalc(hoy);/* 55 */
		cabeceraFraccionamiento.setLfimppdte("");/* 56 */// DATO DE LA PANTALLA,
														// IMPORTE SIN MAS
		cabeceraFraccionamiento.setLfimpint("");/* 57 */// SACAR DE PARAMETROS
		cabeceraFraccionamiento
				.setLforgresp(Y41bConstantes.CABECERA_LIQUIDACION_ORGANO_RESPONSABLE_RESOLUCION);/* 58 */
		cabeceraFraccionamiento.setLfnumexp("");/* 59 */// DATO DE LA PANTALLA
		cabeceraFraccionamiento.setLffecenv3(hoy);/* 60 */
		cabeceraFraccionamiento.setLffecenvcen(hoy);/* 61 */
		cabeceraFraccionamiento.setLffeclimpagvol(hoy); // ESTA NO ES HOY, ES LA
														// FECHA LIMITE DE PAGO
														// /*62*/
		cabeceraFraccionamiento.setLfiban("");/* 63 */// DATO DE LA PANTALLA

		return cabeceraFraccionamiento;
	}

	/**
	 * Devuelve string fraccionamiento.
	 * 
	 * @param cabeceraFraccionamiento
	 *            the cabecera fraccionamiento
	 * @return the string
	 */
	public String devuelveStringFraccionamiento(
			Sanfracsipca cabeceraFraccionamiento) {
		StringBuffer cadena = new StringBuffer();

		String campo1 = cabeceraFraccionamiento.getLftipreg();/* 1 */
		String campo2 = cabeceraFraccionamiento.getLftipop();/* 2 */
		String campo3 = cabeceraFraccionamiento.getLfentem();/* 3 */
		String campo4 = cabeceraFraccionamiento.getLfsufijo();/* 4 */

		// ***** CAMPOS DE LA TABLA PAGOS
		String campo5 = cabeceraFraccionamiento.getLfnumref();/* 5 */
		String campo6 = cabeceraFraccionamiento.getLfdigcon();/* 6 */
		String campo7 = cabeceraFraccionamiento.getLffeclimpa().toString();/* 7 */
		String campo8 = cabeceraFraccionamiento.getLfimporte();/* 8 */
		String campo9 = cabeceraFraccionamiento.getLffecoper().toString();/* 9 */

		// ****** FIN PRIMERA PARTE
		String campo10 = cabeceraFraccionamiento.getLffecsolic().toString();/* 10 */
		String campo11 = cabeceraFraccionamiento.getLftipter();/* 11 */

		/* TODO: AMAIA DATOS SOBRE EL SANCIONADO */
		String campo12 = cabeceraFraccionamiento.getLfcif();/* 12 */
		String campo13 = cabeceraFraccionamiento.getLfnombre();/* 13 */
		String campo14 = cabeceraFraccionamiento.getLfape1();/* 14 */
		String campo15 = cabeceraFraccionamiento.getLfape2();/* 15 */
		String campo16 = cabeceraFraccionamiento.getLftel();/* 16 */
		String campo17 = cabeceraFraccionamiento.getLffax();/* 17 */
		String campo18 = cabeceraFraccionamiento.getLfemail();/* 18 */

		/* TODO: AMAIA DATOS SOBRE LA DIRECCION DEL SANCIONADO */
		String campo19 = cabeceraFraccionamiento.getLfsigl();/* 19 */
		String campo20 = cabeceraFraccionamiento.getLfviapu();/* 20 */
		String campo21 = cabeceraFraccionamiento.getLfportal();/* 21 */
		String campo22 = cabeceraFraccionamiento.getLfletra();/* 22 */
		String campo23 = cabeceraFraccionamiento.getLfescal();/* 23 */
		String campo24 = cabeceraFraccionamiento.getLfpiso();/* 24 */
		String campo25 = cabeceraFraccionamiento.getLfpuerta();/* 25 */
		String campo26 = cabeceraFraccionamiento.getLfcodprov();/* 26 */
		String campo27 = cabeceraFraccionamiento.getLfcodmun();/* 27 */
		String campo28 = cabeceraFraccionamiento.getLfcodloc();/* 28 */
		String campo29 = cabeceraFraccionamiento.getLfcodpos();/* 29 */

		/* TODO: AMAIA DATOS SOBRE LA FRACCION */
		String campo30 = cabeceraFraccionamiento.getLfcodcau();/* 30 */
		String campo31 = cabeceraFraccionamiento.getLfmotcau();/* 31 */
		String campo32 = cabeceraFraccionamiento.getLfpropag();/* 32 */
		String campo33 = cabeceraFraccionamiento.getLfmotpro();/* 33 */
		String campo34 = cabeceraFraccionamiento.getLfcuenta();/* 34 */
		String campo35 = cabeceraFraccionamiento.getLfexgara();/* 35 */
		String campo36 = cabeceraFraccionamiento.getLftipgara();/* 36 */
		String campo37 = cabeceraFraccionamiento.getLffecdep().toString();/* 37 */
		String campo38 = cabeceraFraccionamiento.getLffecaporav().toString();/* 38 */
		String campo39 = cabeceraFraccionamiento.getLfindicsuf();/* 39 */
		String campo40 = cabeceraFraccionamiento.getLffecnotif().toString();/* 40 */
		String campo41 = cabeceraFraccionamiento.getLffecinform().toString();/* 41 */
		String campo42 = cabeceraFraccionamiento.getLffecresol().toString();/* 42 */
		String campo43 = cabeceraFraccionamiento.getLfestimresol();/* 43 */
		String campo44 = cabeceraFraccionamiento.getLfmotres();/* 44 */
		String campo45 = cabeceraFraccionamiento.getLfnumpl();/* 45 */
		String campo46 = cabeceraFraccionamiento.getLffrecpl();/* 46 */
		String campo47 = cabeceraFraccionamiento.getLffeclim1pa().toString(); /* 47 */
		String campo48 = cabeceraFraccionamiento.getLfporcdem();/* 48 */
		String campo49 = cabeceraFraccionamiento.getLftippag();/* 49 */
		String campo50 = cabeceraFraccionamiento.getLftipnot();/* 50 */
		String campo51 = cabeceraFraccionamiento.getLffecnotresol().toString();/* 51 */
		String campo52 = cabeceraFraccionamiento.getLffecinval().toString();/* 52 */
		String campo53 = cabeceraFraccionamiento.getLftipinval();/* 53 */
		String campo54 = cabeceraFraccionamiento.getLfmotinval();/* 54 */
		String campo55 = cabeceraFraccionamiento.getLffecalc().toString();/* 55 */
		String campo56 = cabeceraFraccionamiento.getLfimppdte();/* 56 */
		String campo57 = cabeceraFraccionamiento.getLfimpint();/* 57 */
		String campo58 = cabeceraFraccionamiento.getLforgresp();/* 58 */
		String campo59 = cabeceraFraccionamiento.getLfnumexp();/* 59 */
		String campo60 = cabeceraFraccionamiento.getLffecenv3().toString();/* 60 */
		String campo61 = cabeceraFraccionamiento.getLffecenvcen().toString();/* 61 */
		String campo62 = cabeceraFraccionamiento.getLffeclimpagvol().toString(); /* 62 */
		String campo63 = cabeceraFraccionamiento.getLfiban();/* 63 */

		String caracterRellenoNumeros = "0";
		String caracterRellenoStrings = " ";
		String caracterRellenoFechas = " ";

		cadena.append(Y41bUtils.rellenaIzda(campo1, caracterRellenoNumeros, 2));
		cadena.append(Y41bUtils.rellenaIzda(campo2, caracterRellenoNumeros, 2));
		cadena.append(Y41bUtils.rellenaIzda(campo3, caracterRellenoStrings, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo4, caracterRellenoNumeros, 3));
		cadena.append(Y41bUtils.rellenaIzda(campo5, caracterRellenoNumeros, 11));
		cadena.append(Y41bUtils.rellenaIzda(campo6, caracterRellenoNumeros, 2));
		cadena.append(Y41bUtils.rellenaIzda(campo7, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo8, caracterRellenoNumeros, 13));
		cadena.append(Y41bUtils.rellenaIzda(campo9, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo10, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo11, caracterRellenoStrings, 1));
		cadena.append(Y41bUtils.rellenaIzda(campo12, caracterRellenoStrings, 9));
		cadena.append(Y41bUtils
				.rellenaIzda(campo13, caracterRellenoStrings, 40));
		cadena.append(Y41bUtils
				.rellenaIzda(campo14, caracterRellenoStrings, 25));
		cadena.append(Y41bUtils
				.rellenaIzda(campo15, caracterRellenoStrings, 25));
		cadena.append(Y41bUtils
				.rellenaIzda(campo16, caracterRellenoStrings, 12));
		cadena.append(Y41bUtils
				.rellenaIzda(campo17, caracterRellenoStrings, 12));
		cadena.append(Y41bUtils.rellenaIzda(campo18, caracterRellenoStrings,
				320));
		cadena.append(Y41bUtils.rellenaIzda(campo19, caracterRellenoStrings, 2));
		cadena.append(Y41bUtils
				.rellenaIzda(campo20, caracterRellenoStrings, 25));
		cadena.append(Y41bUtils.rellenaIzda(campo21, caracterRellenoStrings, 5));
		cadena.append(Y41bUtils.rellenaIzda(campo22, caracterRellenoStrings, 3));
		cadena.append(Y41bUtils.rellenaIzda(campo23, caracterRellenoStrings, 2));
		cadena.append(Y41bUtils.rellenaIzda(campo24, caracterRellenoStrings, 2));
		cadena.append(Y41bUtils.rellenaIzda(campo25, caracterRellenoStrings, 2));
		cadena.append(Y41bUtils.rellenaIzda(campo26, caracterRellenoNumeros, 2));
		cadena.append(Y41bUtils.rellenaIzda(campo27, caracterRellenoNumeros, 4));
		cadena.append(Y41bUtils.rellenaIzda(campo28, caracterRellenoNumeros, 4));
		cadena.append(Y41bUtils.rellenaIzda(campo29, caracterRellenoStrings, 5));
		cadena.append(Y41bUtils.rellenaIzda(campo30, caracterRellenoStrings, 1));
		cadena.append(Y41bUtils
				.rellenaIzda(campo31, caracterRellenoStrings, 80));
		cadena.append(Y41bUtils.rellenaIzda(campo32, caracterRellenoStrings, 1));
		cadena.append(Y41bUtils
				.rellenaIzda(campo33, caracterRellenoStrings, 80));
		cadena.append(Y41bUtils
				.rellenaIzda(campo34, caracterRellenoStrings, 20));
		cadena.append(Y41bUtils.rellenaIzda(campo35, caracterRellenoStrings, 1));
		cadena.append(Y41bUtils.rellenaIzda(campo36, caracterRellenoStrings, 1));
		cadena.append(Y41bUtils.rellenaIzda(campo37, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo38, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo39, caracterRellenoStrings, 1));
		cadena.append(Y41bUtils.rellenaIzda(campo40, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo41, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo42, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo43, caracterRellenoStrings, 1));
		cadena.append(Y41bUtils
				.rellenaIzda(campo44, caracterRellenoStrings, 80));
		cadena.append(Y41bUtils.rellenaIzda(campo45, caracterRellenoNumeros, 2));
		cadena.append(Y41bUtils.rellenaIzda(campo46, caracterRellenoStrings, 1));
		cadena.append(Y41bUtils.rellenaIzda(campo47, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo48, caracterRellenoNumeros, 5));
		cadena.append(Y41bUtils.rellenaIzda(campo49, caracterRellenoStrings, 1));
		cadena.append(Y41bUtils.rellenaIzda(campo50, caracterRellenoStrings, 2));
		cadena.append(Y41bUtils.rellenaIzda(campo51, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo52, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo53, caracterRellenoStrings, 1));
		cadena.append(Y41bUtils
				.rellenaIzda(campo54, caracterRellenoStrings, 80));
		cadena.append(Y41bUtils.rellenaIzda(campo55, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils
				.rellenaIzda(campo56, caracterRellenoNumeros, 13));
		cadena.append(Y41bUtils
				.rellenaIzda(campo57, caracterRellenoNumeros, 13));
		cadena.append(Y41bUtils.rellenaIzda(campo58, caracterRellenoStrings, 1));
		cadena.append(Y41bUtils
				.rellenaIzda(campo59, caracterRellenoStrings, 25));
		cadena.append(Y41bUtils.rellenaIzda(campo60, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo61, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils.rellenaIzda(campo62, caracterRellenoFechas, 8));
		cadena.append(Y41bUtils
				.rellenaIzda(campo63, caracterRellenoStrings, 34));

		return cadena.toString();
	}
}
