package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.constantes.Y41bConstantes;

/**
 * FiltroSanciones  
 * 
 *  
 */

/**
 *  
 * 
 */
/**
 *  
 *
 */
/**
 *  
 * 
 */
public class FiltroSanciones implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String excodigo;
	private String excoor;
	private BigDecimal exnran;
	private BigDecimal exnror;
	private Date exfere;
	private Date fechaIniDesde;
	private Date fechaIniHasta;
	private String excoit;
	private Establecimiento establecimiento;
	private String exinexva;
	private String codCompleto;
	private Sanexp sanexp;
	private Saninterv denunciado;
	private String estadoExpediente;
	private String cifnif;
	private String conoco;
	private String provinciaId;
	private String municipioId;
	private String localidadId;
	private String idFase;
	private String tramite;
	private boolean ultimoTramite;
	private boolean acuseRecibo;
	private String tipoResolucion;
	private String instructor;
	private Date fechaTramitacionDesde;
	private Date fechaTramitacionHasta;
	private CensoMonitor censoMonitor;
	private Santramexp santramexp;
	private Fase fase;
	private Date exfecfin;
	private Saninterv consumidor;
	private Date fechaHechoDesde;
	private Date fechaHechoHasta;

	private boolean indPendienteFirma;

	private boolean hayLiquidacionesPE;

	private BigDecimal excamure;
	private String responsable;
	// EVOLUTIVO 0135083 2.7
	private String infracRelacionadas[];
	private String infracRelacionadasStr;
	private String infracRelacionadasDescripciones[];
	private String infracRelacionadasDescripcionesStr;

	// EVOLUTIVO 0135083 2.7

	private String pcodigo;
	private String accoororigen;
	private String atcocm;

	private String exexcluido;

	/**
	 * @return the tctipres
	 */
	public Tctipres getTctipres() {
		return tctipres;
	}

	/**
	 * @param tctipres
	 *            the tctipres to set
	 */
	public void setTctipres(Tctipres tctipres) {
		this.tctipres = tctipres;
	}

	private Tctipres tctipres;

	private String fechaIniDesdeStr;
	private String fechaIniHastaStr;
	private String fechaTramitacionDesdeStr;
	private String fechaTramitacionHastaStr;

	private String escodigo;
	private String importeDesde;
	private String importeHasta;
	private boolean conRecursoAlzada;
	private boolean sinRecursoAlzada;
	private boolean sinLiquidacionesFirmes;
	private Date fechaNotiReso;
	private Date fechaNotiOrden;
	private Date fechaEnvioReso;
	private String importePendiente;
	private Date fechaPresentacionRA;
	private String resolucionRAes;
	private String resolucionRAeu;
	private Date fechaNotiRA;

	/**
	 * Method 'FiltroSanciones'.
	 */
	public FiltroSanciones() {
	}

	/**
	 * Method 'FiltroSanciones'.
	 * 
	 * @param excoor
	 *            String
	 * @param exnran
	 *            BigDecimal
	 * @param exnror
	 *            BigDecimal
	 * @param codCompleto
	 *            String
	 * @param exfere
	 *            Date
	 * @param excoit
	 *            String
	 * @param establecimiento
	 *            Establecimiento
	 * @param exinexva
	 *            String
	 * @param sanexp
	 *            Sanexp
	 * @param saninterv
	 *            Saninterv
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param santramexp
	 *            Santramexp
	 * @param fase
	 *            Fase
	 * @param exfecfin
	 *            Date
	 * @param tctipres
	 *            Tctipres
	 */

	public FiltroSanciones(String excodigo, String excoor, BigDecimal exnran, BigDecimal exnror, String codCompleto,
			Date exfere, String excoit, Establecimiento establecimiento, String exinexva, Sanexp sanexp,
			Saninterv saninterv, CensoMonitor censoMonitor, Santramexp santramexp, Fase fase, Date exfecfin,
			Tctipres tctipres) {

		this.excodigo = excodigo;
		this.excoor = excoor;
		this.exnran = exnran;
		this.exnror = exnror;
		this.exfere = exfere;
		this.excoit = excoit;
		this.establecimiento = establecimiento;
		this.exinexva = exinexva;
		this.sanexp = sanexp;
		this.codCompleto = codCompleto;
		this.setDenunciado(saninterv);
		this.censoMonitor = censoMonitor;
		this.santramexp = santramexp;
		this.setFase(fase);
		this.exfecfin = exfecfin;
		this.tctipres = tctipres;
	}

	/**
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param consumidor
	 *            Saninterv
	 */
	public FiltroSanciones(Establecimiento establecimiento, Saninterv consumidor) {
		this.establecimiento = establecimiento;
		this.consumidor = consumidor;
	}

	/**
	 * @param excodigo
	 *            the excodigo to set
	 */
	public void setExcodigo(String excodigo) {
		this.excodigo = excodigo;
	}

	/**
	 * @return the excodigo
	 */
	public String getExcodigo() {
		return excodigo;
	}

	/**
	 * Method 'getExcoor'.
	 * 
	 * @return String
	 */

	public String getExcoor() {
		return this.excoor;
	}

	/**
	 * Method 'setExcoor'.
	 * 
	 * @param excoor
	 *            String
	 * @return
	 */

	public void setExcoor(String excoor) {
		this.excoor = excoor;
	}

	/**
	 * Method 'getExnran'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getExnran() {
		return this.exnran;
	}

	/**
	 * Method 'setExnran'.
	 * 
	 * @param exnran
	 *            BigDecimal
	 * @return
	 */

	public void setExnran(BigDecimal exnran) {
		this.exnran = exnran;
	}

	/**
	 * Method 'getExnror'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getExnror() {
		return this.exnror;
	}

	/**
	 * Method 'setExnror'.
	 * 
	 * @param exnror
	 *            BigDecimal
	 * @return
	 */

	public void setExnror(BigDecimal exnror) {
		this.exnror = exnror;
	}

	/**
	 * @return the exfere
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfere() {
		return exfere;
	}

	/**
	 * @param exfere
	 *            the exfere to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfere(Date exfere) {
		this.exfere = exfere;
	}

	/**
	 * @return the fechaIniDesde
	 */
	public Date getFechaIniDesde() {
		return fechaIniDesde;
	}

	/**
	 * @param fechaIniDesde
	 *            the fechaIniDesde to set
	 */
	public void setFechaIniDesde(Date fechaIniDesde) {
		this.fechaIniDesde = fechaIniDesde;
	}

	/**
	 * @return the fechaIniHasta
	 */
	public Date getFechaIniHasta() {
		return fechaIniHasta;
	}

	/**
	 * @param fechaIniHasta
	 *            the fechaIniHasta to set
	 */
	public void setFechaIniHasta(Date fechaIniHasta) {
		this.fechaIniHasta = fechaIniHasta;
	}

	/**
	 * Method 'getExcoit'.
	 * 
	 * @return String
	 */

	public String getExcoit() {
		return this.excoit;
	}

	/**
	 * Method 'setExcoit'.
	 * 
	 * @param excoit
	 *            String
	 * @return
	 */

	public void setExcoit(String excoit) {
		this.excoit = excoit;
	}

	/**
	 * Method 'getEstablecimiento'.
	 * 
	 * @return Establecimiento
	 */

	public Establecimiento getEstablecimiento() {
		return this.establecimiento;
	}

	/**
	 * Method 'setEstablecimiento'.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */

	public void setEstablecimiento(Establecimiento establecimiento) {
		this.establecimiento = establecimiento;
	}

	/**
	 * Method 'getExinexva'.
	 * 
	 * @return String
	 */

	public String getExinexva() {
		return this.exinexva;
	}

	/**
	 * Method 'setExinexva'.
	 * 
	 * @param exinexva
	 *            String
	 * @return
	 */

	public void setExinexva(String exinexva) {
		this.exinexva = exinexva;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(", [ excoor: ").append(this.excoor).append(" ]");
		result.append(", [ exnran: ").append(this.exnran).append(" ]");
		result.append(", [ exnror: ").append(this.exnror).append(" ]");
		result.append(", [ fechaIniDesde: ").append(this.fechaIniDesde).append(" ]");
		result.append(", [ fechaIniHasta: ").append(this.fechaIniHasta).append(" ]");
		result.append(", [ excoit: ").append(this.excoit).append(" ]");
		result.append(", [ exinexva: ").append(this.exinexva).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * Method 'getSanexp'.
	 * 
	 * @return Sanexp
	 */

	public Sanexp getSanexp() {
		return this.sanexp;
	}

	/**
	 * Method 'setSanexp'.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return
	 */

	public void setSanexp(Sanexp sanexp) {
		this.sanexp = sanexp;
	}

	/**
	 * 
	 * @return
	 */
	public String getcodCompleto() {
		// return getExcoor() + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP +
		// getExnror().toString() + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP +
		// getExnran().toString();
		return this.codCompleto;
	}

	/**
	 * Method 'setcodCompleto'.
	 * 
	 * @param codCompleto
	 *            String
	 * @return
	 */

	public void setcodCompleto(String codCompleto) {
		this.codCompleto = codCompleto;
		int posicionPrimerDelimitador = codCompleto.indexOf(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP, 0);
		int posicionSegundoDelimitador = codCompleto.indexOf(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP,
				posicionPrimerDelimitador + 1);

		try {
			if (posicionPrimerDelimitador >= 0 && posicionSegundoDelimitador > posicionPrimerDelimitador + 1) {
				this.setExcoor(codCompleto.substring(0, posicionPrimerDelimitador));
				this.setExnror(new BigDecimal(
						codCompleto.substring(posicionPrimerDelimitador + 1, posicionSegundoDelimitador)));
				this.setExnran(
						new BigDecimal(codCompleto.substring(posicionSegundoDelimitador + 1, codCompleto.length())));
			} else {
				this.setExcoor("   ");
			}
		} // captura de excepción por si el usuario introduce en el filtro un
			// código de expediente con letras en lugar de números, caracteres
			// raros... (contol para que no se obtenga ningún registro
			// resultante en la búsqueda)
		catch (Exception e) {
			e.printStackTrace();
			this.setExcoor("   ");
		}
	}

	/**
	 * @param denunciado
	 *            Saninterv
	 */
	public void setDenunciado(Saninterv denunciado) {
		this.denunciado = denunciado;
	}

	/**
	 * @return Saninterv
	 */
	public Saninterv getDenunciado() {
		return denunciado;
	}

	/**
	 * @param estadoExpediente
	 *            String
	 */
	public void setEstadoExpediente(String estadoExpediente) {
		this.estadoExpediente = estadoExpediente;
	}

	/**
	 * @return
	 */
	public String getEstadoExpediente() {
		return estadoExpediente;
	}

	/**
	 * @return the cifnif
	 */
	public String getCifnif() {
		return cifnif;
	}

	/**
	 * @param cifnif
	 *            the cifnif to set
	 */
	public void setCifnif(String cifnif) {
		this.cifnif = cifnif;
	}

	/**
	 * @return the conoco
	 */
	public String getConoco() {
		return conoco;
	}

	/**
	 * @param conoco
	 *            the conoco to set
	 */
	public void setConoco(String conoco) {
		this.conoco = conoco;
	}

	/**
	 * @return the provinciaId
	 */
	public String getProvinciaId() {
		return provinciaId;
	}

	/**
	 * @param provinciaId
	 *            the provinciaId to set
	 */
	public void setProvinciaId(String provinciaId) {
		this.provinciaId = provinciaId;
	}

	/**
	 * @return the municipioId
	 */
	public String getMunicipioId() {
		return municipioId;
	}

	/**
	 * @param municipioId
	 *            the municipioId to set
	 */
	public void setMunicipioId(String municipioId) {
		this.municipioId = municipioId;
	}

	/**
	 * @return the localidadId
	 */
	public String getLocalidadId() {
		return localidadId;
	}

	/**
	 * @param localidadId
	 *            the localidadId to set
	 */
	public void setLocalidadId(String localidadId) {
		this.localidadId = localidadId;
	}

	/**
	 * @param idFase
	 *            the idFase to set
	 */
	public void setIdFase(String idFase) {
		this.idFase = idFase;
	}

	/**
	 * @return the idFase
	 */
	public String getIdFase() {
		return idFase;
	}

	/**
	 * @return the tramite
	 */
	public String getTramite() {
		return tramite;
	}

	/**
	 * @param tramite
	 *            the tramite to set
	 */
	public void setTramite(String tramite) {
		this.tramite = tramite;
	}

	/**
	 * @return the ultimoTramite
	 */
	public boolean getUltimoTramite() {
		return ultimoTramite;
	}

	/**
	 * @param ultimoTramite
	 *            the ultimoTramite to set
	 */
	public void setUltimoTramite(boolean ultimoTramite) {
		this.ultimoTramite = ultimoTramite;
	}

	/**
	 * @return the tipoResolucion
	 */
	public String getTipoResolucion() {
		return tipoResolucion;
	}

	/**
	 * @param tipoResolucion
	 *            the tipoResolucion to set
	 */
	public void setTipoResolucion(String tipoResolucion) {
		this.tipoResolucion = tipoResolucion;
	}

	/**
	 * @return the instructor
	 */
	public String getInstructor() {
		return instructor;
	}

	/**
	 * @param instructor
	 *            the instructor to set
	 */
	public void setInstructor(String instructor) {
		this.instructor = instructor;
	}

	/**
	 * @return the acuseRecibo
	 */
	public boolean getAcuseRecibo() {
		return acuseRecibo;
	}

	/**
	 * @param acuseRecibo
	 *            the acuseRecibo to set
	 */
	public void setAcuseRecibo(boolean acuseRecibo) {
		this.acuseRecibo = acuseRecibo;
	}

	/**
	 * @return the fechaTramitacionDesde
	 */
	public Date getFechaTramitacionDesde() {
		return fechaTramitacionDesde;
	}

	/**
	 * @param fechaTramitacionDesde
	 *            the fechaTramitacionDesde to set
	 */
	public void setFechaTramitacionDesde(Date fechaTramitacionDesde) {
		this.fechaTramitacionDesde = fechaTramitacionDesde;
	}

	/**
	 * @return the fechaTramitacionHasta
	 */
	public Date getFechaTramitacionHasta() {
		return fechaTramitacionHasta;
	}

	/**
	 * @param fechaTramitacionHasta
	 *            the fechaTramitacionHasta to set
	 */
	public void setFechaTramitacionHasta(Date fechaTramitacionHasta) {
		this.fechaTramitacionHasta = fechaTramitacionHasta;
	}

	/**
	 * @param censoMonitor
	 *            the censoMonitor to set
	 */
	public void setCensoMonitor(CensoMonitor censoMonitor) {
		this.censoMonitor = censoMonitor;
	}

	/**
	 * @return the censoMonitor
	 */
	public CensoMonitor getCensoMonitor() {
		return censoMonitor;
	}

	/**
	 * @param santramexp
	 *            the santramexp to set
	 */
	public void setSantramexp(Santramexp santramexp) {
		this.santramexp = santramexp;
	}

	/**
	 * @return the santramexp
	 */
	public Santramexp getSantramexp() {
		return santramexp;
	}

	/**
	 * @param fase
	 *            the fase to set
	 */
	public void setFase(Fase fase) {
		this.fase = fase;
	}

	/**
	 * @return the exfecfin
	 */
	public Date getExfecfin() {
		return exfecfin;
	}

	/**
	 * @param exfecfin
	 *            the exfecfin to set
	 */
	public void setExfecfin(Date exfecfin) {
		this.exfecfin = exfecfin;
	}

	/**
	 * @return the consumidor
	 */
	public Saninterv getConsumidor() {
		return consumidor;
	}

	/**
	 * @param consumidor
	 *            the consumidor to set
	 */
	public void setConsumidor(Saninterv consumidor) {
		this.consumidor = consumidor;
	}

	/**
	 * @return the fase
	 */
	public Fase getFase() {
		return fase;
	}

	/**
	 * @return the fechaIniDesdeStr
	 */
	public String getFechaIniDesdeStr() {
		return fechaIniDesdeStr;
	}

	/**
	 * @param fechaIniDesdeStr
	 *            the fechaIniDesdeStr to set
	 */
	public void setFechaIniDesdeStr(String fechaIniDesdeStr) {
		this.fechaIniDesdeStr = fechaIniDesdeStr;
	}

	/**
	 * @return the fechaIniHastaStr
	 */
	public String getFechaIniHastaStr() {
		return fechaIniHastaStr;
	}

	/**
	 * @param fechaIniHastaStr
	 *            the fechaIniHastaStr to set
	 */
	public void setFechaIniHastaStr(String fechaIniHastaStr) {
		this.fechaIniHastaStr = fechaIniHastaStr;
	}

	/**
	 * @return the fechaTramitacionDesdeStr
	 */
	public String getFechaTramitacionDesdeStr() {
		return fechaTramitacionDesdeStr;
	}

	/**
	 * @param fechaTramitacionDesdeStr
	 *            the fechaTramitacionDesdeStr to set
	 */
	public void setFechaTramitacionDesdeStr(String fechaTramitacionDesdeStr) {
		this.fechaTramitacionDesdeStr = fechaTramitacionDesdeStr;
	}

	/**
	 * @return the fechaTramitacionHastaStr
	 */
	public String getFechaTramitacionHastaStr() {
		return fechaTramitacionHastaStr;
	}

	/**
	 * @param fechaTramitacionHastaStr
	 *            the fechaTramitacionHastaStr to set
	 */
	public void setFechaTramitacionHastaStr(String fechaTramitacionHastaStr) {
		this.fechaTramitacionHastaStr = fechaTramitacionHastaStr;
	}

	/**
	 * @return the fechaHechoDesde
	 */
	public Date getFechaHechoDesde() {
		return fechaHechoDesde;
	}

	/**
	 * @param fechaHechoDesde
	 *            the fechaHechoDesde to set
	 */
	public void setFechaHechoDesde(Date fechaHechoDesde) {
		this.fechaHechoDesde = fechaHechoDesde;
	}

	/**
	 * @return the fechaHechoHasta
	 */
	public Date getFechaHechoHasta() {
		return fechaHechoHasta;
	}

	/**
	 * @param fechaHechoHasta
	 *            the fechaHechoHasta to set
	 */
	public void setFechaHechoHasta(Date fechaHechoHasta) {
		this.fechaHechoHasta = fechaHechoHasta;
	}

	/**
	 * @return the indPendienteFirma
	 */
	public boolean getIndPendienteFirma() {
		return indPendienteFirma;
	}

	/**
	 * @param indPendienteFirma
	 *            the indPendienteFirma to set
	 */
	public void setIndPendienteFirma(boolean indPendienteFirma) {
		this.indPendienteFirma = indPendienteFirma;
	}

	/**
	 * @return the importeDesde
	 */
	public String getImporteDesde() {
		return importeDesde;
	}

	/**
	 * @param importeDesde
	 *            the importeDesde to set
	 */
	public void setImporteDesde(String importeDesde) {
		this.importeDesde = importeDesde;
	}

	/**
	 * @return the importeHasta
	 */
	public String getImporteHasta() {
		return importeHasta;
	}

	/**
	 * @param importeHasta
	 *            the importeHasta to set
	 */
	public void setImporteHasta(String importeHasta) {
		this.importeHasta = importeHasta;
	}

	/**
	 * @return the conRecursoAlzada
	 */
	public boolean getConRecursoAlzada() {
		return conRecursoAlzada;
	}

	/**
	 * @param conRecursoAlzada
	 *            the conRecursoAlzada to set
	 */
	public void setConRecursoAlzada(boolean conRecursoAlzada) {
		this.conRecursoAlzada = conRecursoAlzada;
	}

	/**
	 * @return the sinRecursoAlzada
	 */
	public boolean getSinRecursoAlzada() {
		return sinRecursoAlzada;
	}

	/**
	 * @param sinRecursoAlzada
	 *            the sinRecursoAlzada to set
	 */
	public void setSinRecursoAlzada(boolean sinRecursoAlzada) {
		this.sinRecursoAlzada = sinRecursoAlzada;
	}

	/**
	 * @return the sinLiquidacionesFirmes
	 */
	public boolean getSinLiquidacionesFirmes() {
		return this.sinLiquidacionesFirmes;
	}

	/**
	 * @param sinLiquidacionesFirmes
	 *            the sinLiquidacionesFirmes to set
	 */
	public void setSinLiquidacionesFirmes(boolean sinLiquidacionesFirmes) {
		this.sinLiquidacionesFirmes = sinLiquidacionesFirmes;
	}

	/**
	 * @return the fechaNotiReso
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaNotiReso() {
		return fechaNotiReso;
	}

	/**
	 * @param fechaNotiReso
	 *            the fechaNotiReso to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaNotiReso(Date fechaNotiReso) {
		this.fechaNotiReso = fechaNotiReso;
	}

	/**
	 * @return the escodigo
	 */
	public String getEscodigo() {
		return escodigo;
	}

	/**
	 * @param escodigo
	 *            the escodigo to set
	 */
	public void setEscodigo(String escodigo) {
		this.escodigo = escodigo;
	}

	/**
	 * @param bigDecimal
	 */
	public void setImportePendiente(String importe) {
		this.importePendiente = importe;
	}

	/**
	 * @return the importePendiente
	 */
	public String getImportePendiente() {
		return importePendiente;
	}

	/**
	 * @return the fechaEnvioReso
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaEnvioReso() {
		return fechaEnvioReso;
	}

	/**
	 * @param fechaEnvioReso
	 *            the fechaEnvioReso to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaEnvioReso(Date fechaEnvioReso) {
		this.fechaEnvioReso = fechaEnvioReso;
	}

	/**
	 * @return the fechaPresentacionRA
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaPresentacionRA() {
		return fechaPresentacionRA;
	}

	/**
	 * @param fechaPresentacionRA
	 *            the fechaPresentacionRA to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaPresentacionRA(Date fechaPresentacionRA) {
		this.fechaPresentacionRA = fechaPresentacionRA;
	}

	/**
	 * @return the resolucionRAes
	 */
	public String getResolucionRAes() {
		return resolucionRAes;
	}

	/**
	 * @param resolucionRAes
	 *            the resolucionRAes to set
	 */
	public void setResolucionRAes(String resolucionRAes) {
		this.resolucionRAes = resolucionRAes;
	}

	/**
	 * @return the resolucionRAeu
	 */
	public String getResolucionRAeu() {
		return resolucionRAeu;
	}

	/**
	 * @param resolucionRAeu
	 *            the resolucionRAeu to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setResolucionRAeu(String resolucionRAeu) {
		this.resolucionRAeu = resolucionRAeu;
	}

	/**
	 * @return the fechaNotiRA
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaNotiRA() {
		return fechaNotiRA;
	}

	/**
	 * @param fechaNotiRA
	 *            the fechaNotiRA to set
	 */
	public void setFechaNotiRA(Date fechaNotiRA) {
		this.fechaNotiRA = fechaNotiRA;
	}

	/**
	 * @return the hayLiquidacionesPE
	 */
	public boolean isHayLiquidacionesPE() {
		return hayLiquidacionesPE;
	}

	/**
	 * @param hayLiquidacionesPE
	 *            the hayLiquidacionesPE to set
	 */
	public void setHayLiquidacionesPE(boolean hayLiquidacionesPE) {
		this.hayLiquidacionesPE = hayLiquidacionesPE;
	}

	/**
	 * @return the excamure
	 */
	public BigDecimal getExcamure() {
		return excamure;
	}

	/**
	 * @param excamure
	 *            the excamure to set
	 */
	public void setExcamure(BigDecimal excamure) {
		this.excamure = excamure;
	}

	/**
	 * @return the responsable
	 */
	public String getResponsable() {
		return responsable;
	}

	/**
	 * @param responsable
	 *            the responsable to set
	 */
	public void setResponsable(String responsable) {
		this.responsable = responsable;
	}

	/**
	 * @return the fechaNotiOrden
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaNotiOrden() {
		return fechaNotiOrden;
	}

	/**
	 * @param fechaNotiOrden
	 *            the fechaNotiOrden to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaNotiOrden(Date fechaNotiOrden) {
		this.fechaNotiOrden = fechaNotiOrden;
	}

	// EVOLUTIVO 0135083 2.7
	public void setInfracRelacionadas(String infracRelacionadas[]) {
		this.infracRelacionadas = infracRelacionadas;
	}

	public String[] getInfracRelacionadas() {
		return infracRelacionadas;
	}

	public void setInfracRelacionadasDescripciones(String infracRelacionadasDescripciones[]) {
		this.infracRelacionadasDescripciones = infracRelacionadasDescripciones;
	}

	public String[] getInfracRelacionadasDescripciones() {
		return infracRelacionadasDescripciones;
	}

	public void setInfracRelacionadasStr(String infracRelacionadasStr) {
		this.infracRelacionadasStr = infracRelacionadasStr;
	}

	public String getInfracRelacionadasStr() {
		return infracRelacionadasStr;
	}

	public void setInfracRelacionadasDescripcionesStr(String infracRelacionadasDescripcionesStr) {
		this.infracRelacionadasDescripcionesStr = infracRelacionadasDescripcionesStr;
	}

	public String getInfracRelacionadasDescripcionesStr() {
		return infracRelacionadasDescripcionesStr;
	}

	public void setPcodigo(String pcodigo) {
		this.pcodigo = pcodigo;
	}

	public String getPcodigo() {
		return pcodigo;
	}

	public void setAccoororigen(String accoororigen) {
		this.accoororigen = accoororigen;
	}

	public String getAccoororigen() {
		return accoororigen;
	}

	public void setAtcocm(String atcocm) {
		this.atcocm = atcocm;
	}

	public String getAtcocm() {
		return atcocm;
	}

	public String getExexcluido() {
		return exexcluido;
	}

	public void setExexcluido(String exexcluido) {
		this.exexcluido = exexcluido;
	}

	// EVOLUTIVO 0135083 2.7
}
