package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;

/**
 * * SolicitudBusqueda  
 * 
 *  
 */

public class FiltroInspeccion implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private String atcodigo;
	private BigDecimal acnran;
	private String acnror;
	private BigDecimal atnror;
	private String accoor;

	private Date acfere;

	private Date acfereDesde;
	private Date acfereHasta;

	private Date atfechafin;

	private String numExpediente;

	private String codOrgSeleccionado;
	private String orgNombre;
	private String mocodigoExpediente;
	private String monombreExpediente;

	private String Esnif;

	public FiltroInspeccion() {

	}

	public FiltroInspeccion(String atcodigo, String accoor, BigDecimal acnran,
			String acnror, BigDecimal atnror, String mocodigoExpediente,
			String monombreExpediente, Date acfere, Date atfechafin) {

		this.atcodigo = atcodigo;
		this.accoor = accoor;
		this.acnran = acnran;
		this.acnror = acnror;
		this.atnror = atnror;
		this.mocodigoExpediente = mocodigoExpediente;
		this.monombreExpediente = monombreExpediente;
		this.acfere = acfere;
		this.atfechafin = atfechafin;

	}

	/**
	 * @return the atfechafin
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getAtfechafin() {
		return atfechafin;
	}

	/**
	 * @param atfechafin
	 *            the atfechafin to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setAtfechafin(Date atfechafin) {
		this.atfechafin = atfechafin;
	}

	/**
	 * @return the esnif
	 */
	public String getEsnif() {
		return Esnif;
	}

	/**
	 * @param esnif
	 *            the esnif to set
	 */
	public void setEsnif(String esnif) {
		Esnif = esnif;
	}

	/**
	 * @return the atcodigo
	 */
	public String getAtcodigo() {
		return atcodigo;
	}

	/**
	 * @param atcodigo
	 *            the atcodigo to set
	 */
	public void setAtcodigo(String atcodigo) {
		this.atcodigo = atcodigo;
	}

	/**
	 * @return the acnran
	 */
	public BigDecimal getAcnran() {
		return acnran;
	}

	/**
	 * @param acnran
	 *            the acnran to set
	 */
	public void setAcnran(BigDecimal acnran) {
		this.acnran = acnran;
	}

	/**
	 * @return the acnror
	 */
	public String getAcnror() {
		return acnror;
	}

	/**
	 * @param acnror
	 *            the acnror to set
	 */
	public void setAcnror(String acnror) {
		this.acnror = acnror;
	}

	/**
	 * @return the atnror
	 */
	public BigDecimal getAtnror() {
		return atnror;
	}

	/**
	 * @param atnror
	 *            the atnror to set
	 */
	public void setAtnror(BigDecimal atnror) {
		this.atnror = atnror;
	}

	/**
	 * @return the accoor
	 */
	public String getAccoor() {
		return accoor;
	}

	/**
	 * @param accoor
	 *            the accoor to set
	 */
	public void setAccoor(String accoor) {
		this.accoor = accoor;
	}

	/**
	 * @return the acfere
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getAcfere() {
		return acfere;
	}

	/**
	 * @param acfere
	 *            the acfere to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setAcfere(Date acfere) {
		this.acfere = acfere;
	}

	/**
	 * @return the acfereDesde
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getAcfereDesde() {
		return acfereDesde;
	}

	/**
	 * @param acfereDesde
	 *            the acfereDesde to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setAcfereDesde(Date acfereDesde) {
		this.acfereDesde = acfereDesde;
	}

	/**
	 * @return the acfereHasta
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getAcfereHasta() {
		return acfereHasta;
	}

	/**
	 * @param acfereHasta
	 *            the acfereHasta to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setAcfereHasta(Date acfereHasta) {
		this.acfereHasta = acfereHasta;
	}

	/**
	 * @return the numExpediente
	 */
	public String getNumExpediente() {
		return numExpediente;
	}

	/**
	 * @param numExpediente
	 *            the numExpediente to set
	 */
	public void setNumExpediente(String numExpediente) {
		this.numExpediente = numExpediente;
	}

	/**
	 * @return the codOrgSeleccionado
	 */
	public String getCodOrgSeleccionado() {
		return codOrgSeleccionado;
	}

	/**
	 * @param codOrgSeleccionado
	 *            the codOrgSeleccionado to set
	 */
	public void setCodOrgSeleccionado(String codOrgSeleccionado) {
		this.codOrgSeleccionado = codOrgSeleccionado;
	}

	/**
	 * @return the orgNombre
	 */
	public String getOrgNombre() {
		return orgNombre;
	}

	/**
	 * @param orgNombre
	 *            the orgNombre to set
	 */
	public void setOrgNombre(String orgNombre) {
		this.orgNombre = orgNombre;
	}

	/**
	 * @return the mocodigoExpediente
	 */
	public String getMocodigoExpediente() {
		return mocodigoExpediente;
	}

	/**
	 * @param mocodigoExpediente
	 *            the mocodigoExpediente to set
	 */
	public void setMocodigoExpediente(String mocodigoExpediente) {
		this.mocodigoExpediente = mocodigoExpediente;
	}

	/**
	 * @return the monombreExpediente
	 */
	public String getMonombreExpediente() {
		return monombreExpediente;
	}

	/**
	 * @param monombreExpediente
	 *            the monombreExpediente to set
	 */
	public void setMonombreExpediente(String monombreExpediente) {
		this.monombreExpediente = monombreExpediente;
	}

}
