package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

/**
 * 
 *  
 * 
 */
public class FiltroArbitraje {

	private static final long serialVersionUID = 1L;

	private String sacodigo;
	private String sacoja;
	private BigDecimal sanror;
	private BigDecimal sanran;
	private Date safesoli;
	private String mocodigo;
	private Establecimiento establecimiento;
	private Arbexp arbexp;
	private String codCompleto;

	private String idFase;
	private String tramite;
	private String estadoExpediente;
	private String tipoResolucion;
	private String instructor;
	private String responsable;

	private Arbinterv arbintervReclamante;
	private Arbinterv arbintervReclamado;

	private CensoMonitor censoMonitor;
	private Arbtramexp arbtramexp;
	private Fase fase;
	private Date safecfin;

	private Date fechaIniDesde;
	private Date fechaIniHasta;
	private Date fechaHechoDesde;
	private Date fechaHechoHasta;

	private String fechaIniDesdeStr;
	private String fechaIniHastaStr;
	private Date fechaTramitacionDesde;
	private String fechaTramitacionDesdeStr;
	private Date fechaTramitacionHasta;
	private String fechaTramitacionHastaStr;

	private Boolean ultimoTramite;
	private Boolean acuseRecibo;
	private Boolean indPendienteFirma;
	private Boolean indPendienteDecision;
	private Boolean indCerrados;
	// EVOLUTIVO 0134898 2.10
	private String radioTramite;

	// EVOLUTIVO 0134898 2.10

	/**
	 * Constructor
	 */
	public FiltroArbitraje() {
		this.arbtramexp = new Arbtramexp();
		this.arbexp = new Arbexp();
		this.arbintervReclamante = new Arbinterv();
		this.arbintervReclamado = new Arbinterv();
	}

	/**
	 * Constructor
	 */
	public FiltroArbitraje(Arbinterv reclamado, Arbinterv reclamante) {
		this.arbtramexp = new Arbtramexp();
		this.arbexp = new Arbexp();
		this.arbintervReclamante = reclamante;
		this.arbintervReclamado = reclamado;
	}

	/**
	 * 
	 * @param sacodigo
	 *            String
	 * @param sacoja
	 *            String
	 * @param sanran
	 *            BigDecimal
	 * @param sanror
	 *            BigDecimal
	 * @param codCompleto
	 *            String
	 * @param safesoli
	 *            Date
	 * @param mocodigo
	 *            String
	 * @param establecimiento
	 *            Establecimiento
	 * @param arbexp
	 *            Arbexp
	 * @param arbintervReclamante
	 *            Arbinterv
	 * @param arbintervReclamado
	 *            Arbinterv
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param fase
	 *            Fase
	 * @param safecfin
	 *            Date
	 */
	public FiltroArbitraje(String sacodigo, String sacoja, BigDecimal sanran,
			BigDecimal sanror, String codCompleto, Date safesoli,
			String mocodigo, Establecimiento establecimiento, Arbexp arbexp,
			Arbinterv arbintervReclamante, Arbinterv arbintervReclamado,
			CensoMonitor censoMonitor, Arbtramexp arbtramexp, Fase fase,
			Date safecfin) {

		this.sacodigo = sacodigo;
		this.sacoja = sacoja;
		this.sanran = sanran;
		this.sanror = sanror;
		this.safesoli = safesoli;
		this.mocodigo = mocodigo;
		this.establecimiento = establecimiento;
		this.arbexp = arbexp;
		this.codCompleto = codCompleto;
		this.arbintervReclamante = arbintervReclamante;
		this.arbintervReclamado = arbintervReclamado;
		this.censoMonitor = censoMonitor;
		this.arbtramexp = arbtramexp;
		this.safecfin = safecfin;
		this.fase = fase;
	}

	/**
	 * @return the idFase
	 */
	public String getIdFase() {
		return idFase;
	}

	/**
	 * @param idFase
	 *            the idFase to set
	 */
	public void setIdFase(String idFase) {
		this.idFase = idFase;
	}

	/**
	 * @return the tramite
	 */
	public String getTramite() {
		return tramite;
	}

	/**
	 * @param tramite
	 *            the tramite to set
	 */
	public void setTramite(String tramite) {
		this.tramite = tramite;
	}

	/**
	 * @return the estadoExpediente
	 */
	public String getEstadoExpediente() {
		return estadoExpediente;
	}

	/**
	 * @param estadoExpediente
	 *            the estadoExpediente to set
	 */
	public void setEstadoExpediente(String estadoExpediente) {
		this.estadoExpediente = estadoExpediente;
	}

	/**
	 * @return the tipoResolucion
	 */
	public String getTipoResolucion() {
		return tipoResolucion;
	}

	/**
	 * @param tipoResolucion
	 *            the tipoResolucion to set
	 */
	public void setTipoResolucion(String tipoResolucion) {
		this.tipoResolucion = tipoResolucion;
	}

	/**
	 * @return the instructor
	 */
	public String getInstructor() {
		return instructor;
	}

	/**
	 * @param instructor
	 *            the instructor to set
	 */
	public void setInstructor(String instructor) {
		this.instructor = instructor;
	}

	/**
	 * @return the responsable
	 */
	public String getResponsable() {
		return responsable;
	}

	/**
	 * @param responsable
	 *            the responsable to set
	 */
	public void setResponsable(String responsable) {
		this.responsable = responsable;
	}

	/**
	 * @return the fechaIniDesdeStr
	 */
	public String getFechaIniDesdeStr() {
		return fechaIniDesdeStr;
	}

	/**
	 * @param fechaIniDesdeStr
	 *            the fechaIniDesdeStr to set
	 */
	public void setFechaIniDesdeStr(String fechaIniDesdeStr) {
		this.fechaIniDesdeStr = fechaIniDesdeStr;
	}

	/**
	 * @return the fechaIniHastaStr
	 */
	public String getFechaIniHastaStr() {
		return fechaIniHastaStr;
	}

	/**
	 * @param fechaIniHastaStr
	 *            the fechaIniHastaStr to set
	 */
	public void setFechaIniHastaStr(String fechaIniHastaStr) {
		this.fechaIniHastaStr = fechaIniHastaStr;
	}

	/**
	 * @return the fechaTramitacionDesde
	 */
	public Date getFechaTramitacionDesde() {
		return fechaTramitacionDesde;
	}

	/**
	 * @param fechaTramitacionDesde
	 *            the fechaTramitacionDesde to set
	 */
	public void setFechaTramitacionDesde(Date fechaTramitacionDesde) {
		this.fechaTramitacionDesde = fechaTramitacionDesde;
	}

	/**
	 * @return the fechaTramitacionDesdeStr
	 */
	public String getFechaTramitacionDesdeStr() {
		return fechaTramitacionDesdeStr;
	}

	/**
	 * @param fechaTramitacionDesdeStr
	 *            the fechaTramitacionDesdeStr to set
	 */
	public void setFechaTramitacionDesdeStr(String fechaTramitacionDesdeStr) {
		this.fechaTramitacionDesdeStr = fechaTramitacionDesdeStr;
	}

	/**
	 * @return the fechaTramitacionHasta
	 */
	public Date getFechaTramitacionHasta() {
		return fechaTramitacionHasta;
	}

	/**
	 * @param fechaTramitacionHasta
	 *            the fechaTramitacionHasta to set
	 */
	public void setFechaTramitacionHasta(Date fechaTramitacionHasta) {
		this.fechaTramitacionHasta = fechaTramitacionHasta;
	}

	/**
	 * @return the fechaTramitacionHastaStr
	 */
	public String getFechaTramitacionHastaStr() {
		return fechaTramitacionHastaStr;
	}

	/**
	 * @param fechaTramitacionHastaStr
	 *            the fechaTramitacionHastaStr to set
	 */
	public void setFechaTramitacionHastaStr(String fechaTramitacionHastaStr) {
		this.fechaTramitacionHastaStr = fechaTramitacionHastaStr;
	}

	/**
	 * @return the acuseRecibo
	 */
	public Boolean getAcuseRecibo() {
		return acuseRecibo;
	}

	/**
	 * @param acuseRecibo
	 *            the acuseRecibo to set
	 */
	public void setAcuseRecibo(Boolean acuseRecibo) {
		this.acuseRecibo = acuseRecibo;
	}

	/**
	 * @return the indPendienteFirma
	 */
	public Boolean getIndPendienteFirma() {
		return indPendienteFirma;
	}

	/**
	 * @param indPendienteFirma
	 *            the indPendienteFirma to set
	 */
	public void setIndPendienteFirma(Boolean indPendienteFirma) {
		this.indPendienteFirma = indPendienteFirma;
	}

	/**
	 * @return the ultimoTramite
	 */
	public Boolean getUltimoTramite() {
		return ultimoTramite;
	}

	/**
	 * @param ultimoTramite
	 *            the ultimoTramite to set
	 */
	public void setUltimoTramite(Boolean ultimoTramite) {
		this.ultimoTramite = ultimoTramite;
	}

	/**
	 * @return the sacoja
	 */
	public String getSacoja() {
		return this.sacoja;
	}

	/**
	 * @param sacoja
	 *            the sacoja to set
	 */
	public void setSacoja(String sacoja) {
		this.sacoja = sacoja;
	}

	/**
	 * @return the sanror
	 */
	public BigDecimal getSanror() {
		return this.sanror;
	}

	/**
	 * @param sanror
	 *            the sanror to set
	 */
	public void setSanror(BigDecimal sanror) {
		this.sanror = sanror;
	}

	/**
	 * @return the sanran
	 */
	public BigDecimal getSanran() {
		return this.sanran;
	}

	/**
	 * @param sanran
	 *            the sanran to set
	 */
	public void setSanran(BigDecimal sanran) {
		this.sanran = sanran;
	}

	/**
	 * @return the fechaIniDesde
	 */
	public Date getFechaIniDesde() {
		return this.fechaIniDesde;
	}

	/**
	 * @param fechaIniDesde
	 *            the fechaIniDesde to set
	 */
	public void setFechaIniDesde(Date fechaIniDesde) {
		this.fechaIniDesde = fechaIniDesde;
	}

	/**
	 * @return the fechaTramitacionHasta
	 */
	public Date getFechaIniHasta() {
		return this.fechaIniHasta;
	}

	/**
	 * @param fechaIniHasta
	 *            the fechaTramitacionHasta to set
	 */
	public void setFechaIniHasta(Date fechaIniHasta) {
		this.fechaIniHasta = fechaIniHasta;
	}

	/**
	 * @return the fechaHechoDesde
	 */
	public Date getFechaHechoDesde() {
		return this.fechaHechoDesde;
	}

	/**
	 * @param fechaHechoDesde
	 *            the fechaHechoDesde to set
	 */
	public void setFechaHechoDesde(Date fechaHechoDesde) {
		this.fechaHechoDesde = fechaHechoDesde;
	}

	/**
	 * @return the fechaHechoHasta
	 */
	public Date getFechaHechoHasta() {
		return this.fechaHechoHasta;
	}

	/**
	 * @param fechaHechoHasta
	 *            the fechaHechoHasta to set
	 */
	public void setFechaHechoHasta(Date fechaHechoHasta) {
		this.fechaHechoHasta = fechaHechoHasta;
	}

	/**
	 * @return the sacodigo
	 */
	public String getSacodigo() {
		return this.sacodigo;
	}

	/**
	 * @param sacodigo
	 *            the sacodigo to set
	 */
	public void setSacodigo(String sacodigo) {
		this.sacodigo = sacodigo;
	}

	/**
	 * @return the safesoli
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getSafesoli() {
		return this.safesoli;
	}

	/**
	 * @param safesoli
	 *            the safesoli to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setSafesoli(Date safesoli) {
		this.safesoli = safesoli;
	}

	/**
	 * @return the mocodigo
	 */
	public String getMocodigo() {
		return this.mocodigo;
	}

	/**
	 * @param mocodigo
	 *            the mocodigo to set
	 */
	public void setMocodigo(String mocodigo) {
		this.mocodigo = mocodigo;
	}

	/**
	 * @return the establecimiento
	 */
	public Establecimiento getEstablecimiento() {
		return this.establecimiento;
	}

	/**
	 * @param establecimiento
	 *            the establecimiento to set
	 */
	public void setEstablecimiento(Establecimiento establecimiento) {
		this.establecimiento = establecimiento;
	}

	/**
	 * @return the arbexp
	 */
	public Arbexp getArbexp() {
		return this.arbexp;
	}

	/**
	 * @param arbexp
	 *            the arbexp to set
	 */
	public void setArbexp(Arbexp arbexp) {
		this.arbexp = arbexp;
	}

	/**
	 * @return the codCompleto
	 */
	public String getCodCompleto() {
		return this.codCompleto;
	}

	/**
	 * @param codCompleto
	 *            the codCompleto to set
	 */
	public void setCodCompleto(String codCompleto) {
		this.codCompleto = codCompleto;
	}

	/**
	 * @return the arbintervReclamante
	 */
	public Arbinterv getArbintervReclamante() {
		return arbintervReclamante;
	}

	/**
	 * @param arbintervReclamante
	 *            the arbintervReclamante to set
	 */
	public void setArbintervReclamante(Arbinterv arbintervReclamante) {
		this.arbintervReclamante = arbintervReclamante;
	}

	/**
	 * @return the arbintervReclamado
	 */
	public Arbinterv getArbintervReclamado() {
		return arbintervReclamado;
	}

	/**
	 * @param arbintervReclamado
	 *            the arbintervReclamado to set
	 */
	public void setArbintervReclamado(Arbinterv arbintervReclamado) {
		this.arbintervReclamado = arbintervReclamado;
	}

	/**
	 * @return the censoMonitor
	 */
	public CensoMonitor getCensoMonitor() {
		return this.censoMonitor;
	}

	/**
	 * @param censoMonitor
	 *            the censoMonitor to set
	 */
	public void setCensoMonitor(CensoMonitor censoMonitor) {
		this.censoMonitor = censoMonitor;
	}

	/**
	 * @return the arbtramexp
	 */
	public Arbtramexp getArbtramexp() {
		return this.arbtramexp;
	}

	/**
	 * @param arbtramexp
	 *            the arbtramexp to set
	 */
	public void setArbtramexp(Arbtramexp arbtramexp) {
		this.arbtramexp = arbtramexp;
	}

	/**
	 * @return the fase
	 */
	public Fase getFase() {
		return this.fase;
	}

	/**
	 * @param fase
	 *            the fase to set
	 */
	public void setFase(Fase fase) {
		this.fase = fase;
	}

	/**
	 * @return the safecfin
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getSafecfin() {
		return this.safecfin;
	}

	/**
	 * @param safecfin
	 *            the safecfin to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setSafecfin(Date safecfin) {
		this.safecfin = safecfin;
	}

	/**
	 * @return the indPendienteDecision
	 */
	public Boolean getIndPendienteDecision() {
		return indPendienteDecision;
	}

	/**
	 * @param indPendienteDecision
	 *            the indPendienteDecision to set
	 */
	public void setIndPendienteDecision(Boolean indPendienteDecision) {
		this.indPendienteDecision = indPendienteDecision;
	}

	/**
	 * @return the indCerrados
	 */
	public Boolean getIndCerrados() {
		return indCerrados;
	}

	/**
	 * @param indCerrados
	 *            the indCerrados to set
	 */
	public void setIndCerrados(Boolean indCerrados) {
		this.indCerrados = indCerrados;
	}

	/**
	 * @return the radioTramite
	 */
	public String getRadioTramite() {
		return radioTramite;
	}

	/**
	 * @param ultimoTramite
	 *            the ultimoTramite to set
	 */
	public void setRadioTramite(String radioTramite) {
		this.radioTramite = radioTramite;
	}
}
