package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Fase  
 * 
 *  
 */

public class Fase implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String fcodigo;
	private TipoProcedimiento tipoProcedimiento;
	private String fnombre;
	private String fnombree;
	private Date fbaja;
	private List<BandejaFirma> bandejaFirmas = new ArrayList<BandejaFirma>();

	/**
	 * Method 'Fase'.
	 */
	public Fase() {
	}

	/**
	 * Method 'Fase'.
	 * 
	 * @param fcodigo
	 *            String
	 */
	public Fase(String fcodigo) {
		this.fcodigo = fcodigo;

	}

	/**
	 * Method 'Fase'.
	 * 
	 * @param fcodigo
	 *            String
	 * @param fnombre
	 *            String
	 * @param fnombree
	 *            String
	 * @param fbaja
	 *            Date
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 */
	public Fase(String fcodigo, String fnombre, String fnombree, Date fbaja,
			TipoProcedimiento tipoProcedimiento) {
		this.fcodigo = fcodigo;
		this.tipoProcedimiento = tipoProcedimiento;
		this.fnombre = fnombre;
		this.fnombree = fnombree;
		this.fbaja = fbaja;
	}

	/**
	 * Method 'Fase'.
	 * 
	 * @param fcodigo
	 *            String
	 * @param fnombre
	 *            String
	 * @param fnombree
	 *            String
	 * @param fbaja
	 *            Date
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @param bandejaFirmas
	 *            List<BandejaFirma>
	 */
	public Fase(String fcodigo, String fnombre, String fnombree, Date fbaja,
			TipoProcedimiento tipoProcedimiento,
			List<BandejaFirma> bandejaFirmas) {

		this.fcodigo = fcodigo;
		this.tipoProcedimiento = tipoProcedimiento;
		this.fnombre = fnombre;
		this.fnombree = fnombree;
		this.fbaja = fbaja;
		this.bandejaFirmas = bandejaFirmas;
	}

	/**
	 * Method 'getFcodigo'.
	 * 
	 * @return String
	 */

	public String getFcodigo() {
		return this.fcodigo;
	}

	/**
	 * Method 'setFcodigo'.
	 * 
	 * @param fcodigo
	 *            String
	 * @return
	 */

	public void setFcodigo(String fcodigo) {
		this.fcodigo = fcodigo;
	}

	/**
	 * Method 'getTipoProcedimiento'.
	 * 
	 * @return TipoProcedimiento
	 */
	@JsonIgnore
	public TipoProcedimiento getTipoProcedimiento() {
		return this.tipoProcedimiento;
	}

	/**
	 * Method 'setTipoProcedimiento'.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return
	 */

	public void setTipoProcedimiento(TipoProcedimiento tipoProcedimiento) {
		this.tipoProcedimiento = tipoProcedimiento;
	}

	/**
	 * Method 'getFnombre'.
	 * 
	 * @return String
	 */

	public String getFnombre() {
		return this.fnombre;
	}

	/**
	 * Method 'setFnombre'.
	 * 
	 * @param fnombre
	 *            String
	 * @return
	 */

	public void setFnombre(String fnombre) {
		this.fnombre = fnombre;
	}

	/**
	 * Method 'getFnombree'.
	 * 
	 * @return String
	 */

	public String getFnombree() {
		return this.fnombree;
	}

	/**
	 * Method 'setFnombree'.
	 * 
	 * @param fnombree
	 *            String
	 * @return
	 */

	public void setFnombree(String fnombree) {
		this.fnombree = fnombree;
	}

	/**
	 * Method 'getFbaja'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFbaja() {
		return this.fbaja;
	}

	/**
	 * Method 'setFbaja'.
	 * 
	 * @param fbaja
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFbaja(Date fbaja) {
		this.fbaja = fbaja;
	}

	/**
	 * Method 'getBandejaFirmas'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<BandejaFirma> getBandejaFirmas() {
		return this.bandejaFirmas;
	}

	/**
	 * Method 'setBandejaFirmas'.
	 * 
	 * @param bandejaFirmas
	 *            List
	 * @return
	 */
	public void setBandejaFirmas(List<BandejaFirma> bandejaFirmas) {
		this.bandejaFirmas = bandejaFirmas;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ fcodigo: ").append(this.fcodigo).append(" ]");
		result.append(", [ fnombre: ").append(this.fnombre).append(" ]");
		result.append(", [ fnombree: ").append(this.fnombree).append(" ]");
		result.append(", [ fbaja: ").append(this.fbaja).append(" ]");
		result.append("}");
		return result.toString();
	}

}
