package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.constantes.Y41bConstantes;

/**
 * Expedien  
 * 
 *  
 */

public class Expedien implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String excodigo;
	private String excoor;
	private BigDecimal exnran;
	private BigDecimal exnror;
	private Date exfere;
	private String excoit;
	private String excoes;
	private Date exfeacin;
	private Date exfeemca;
	private Date exfeplca;
	private Date exfpnopc;
	private Date exfede;
	private Date exfecoal;
	private Date exfenopr;
	private Date exfepupr;
	private String excoospr;
	private Date exfealpr;
	private Date exfeel;
	private Date exferes;
	private Date exfenore;
	private Date exfepure;
	private String excoosre;
	private String excottr;
	private BigDecimal excamure;
	private Date exfeta;
	private String excotsa;
	private Date exfecroi;
	private Date exfear;
	private String excoorie;
	private String exinre;
	private String exincoco;
	private String exinexva;
	private Date exfecirc;
	private Date exfenoai;
	private Date exfecolm;
	private String exnuinlm;
	private Date exfeinmu;
	private Date exfeavmu;
	private Date exfeimcd;
	private Date exfecede;
	private String excops;
	private String excose;
	private Sanexp sanexp;
	private Saninterv denunciante;
	private Saninterv denunciado;
	private List<Sanenvio> sanenvios = new ArrayList<Sanenvio>();
	private List<Santramexp> santramexps = new ArrayList<Santramexp>();
	private List<Sandoctemp> sandoctemps = new ArrayList<Sandoctemp>();
	private List<Sanexprel> sanexprelsForRlexcodigo = new ArrayList<Sanexprel>();
	private List<Sanprue> sanprues = new ArrayList<Sanprue>();
	private List<Saninterv> sanintervs = new ArrayList<Saninterv>();
	private List<Sanexprel> sanexprelsForRlexcodrel = new ArrayList<Sanexprel>();
	private List<Sanbandeja> sanbandejas = new ArrayList<Sanbandeja>();
	private String codCompleto;
	// private Instructor instructor;
	private Establecimiento establecimiento;
	private Recurso recurso;
	private List<String> articulosAniadidos = new ArrayList<String>();
	private List<String> materiasAniadidas = new ArrayList<String>();

	// Apertura mediante establecimiento o mediante expedientes relacionados
	private String tipoApertura;
	private String escodigo;
	private List<InfraccHechoDen> materias;
	private List<InfraccHechoDen> articulos;

	private Tctipres tctipres;
	private BigDecimal uaidinterv;
	private String sancionadoCambio;
	private String formanotificacion;

	private String idsDescriptores;
	private String descsDescriptores;

	private List<Descriptor> descriptores = new ArrayList<Descriptor>();

	/**
	 * @return the uaidinterv
	 */
	public BigDecimal getUaidinterv() {
		return this.uaidinterv;
	}

	/**
	 * @param uaidinterv
	 *            the uaidinterv to set
	 */
	public void setUaidinterv(BigDecimal uaidinterv) {
		this.uaidinterv = uaidinterv;
	}

	private Producto producto;

	// CAMPOS PARA ETIQUETA
	private String esNombreMunicipio;
	private String esNombreSancionado;

	/**
	 * @return the esNombreMunicipio
	 */
	public String getEsNombreMunicipio() {
		return this.esNombreMunicipio;
	}

	/**
	 * @param esNombreMunicipio
	 *            the esNombreMunicipio to set
	 */
	public void setEsNombreMunicipio(String esNombreMunicipio) {
		this.esNombreMunicipio = esNombreMunicipio;
	}

	/**
	 * @return the esNombreSancionado
	 */
	public String getEsNombreSancionado() {
		return this.esNombreSancionado;
	}

	/**
	 * @param esNombreSancionado
	 *            the esNombreSancionado to set
	 */
	public void setEsNombreSancionado(String esNombreSancionado) {
		this.esNombreSancionado = esNombreSancionado;
	}

	/**
	 * Method 'Expedien'.
	 */
	public Expedien() {
	}

	/**
	 * Method 'Expedien'.
	 * 
	 * @param excodigo
	 *            String
	 * @param excoor
	 *            String
	 * @param exnran
	 *            BigDecimal
	 * @param exnror
	 *            BigDecimal
	 * @param exfere
	 *            Date
	 * @param excoit
	 *            String
	 * @param excoes
	 *            String
	 * @param exfeacin
	 *            Date
	 * @param exfeemca
	 *            Date
	 * @param exfeplca
	 *            Date
	 * @param exfpnopc
	 *            Date
	 * @param exfede
	 *            Date
	 * @param exfecoal
	 *            Date
	 * @param exfenopr
	 *            Date
	 * @param exfepupr
	 *            Date
	 * @param excoospr
	 *            String
	 * @param exfealpr
	 *            Date
	 * @param exfeel
	 *            Date
	 * @param exferes
	 *            Date
	 * @param exfenore
	 *            Date
	 * @param exfepure
	 *            Date
	 * @param excoosre
	 *            String
	 * @param excottr
	 *            String
	 * @param excamure
	 *            BigDecimal
	 * @param exfeta
	 *            Date
	 * @param excotsa
	 *            String
	 * @param exfecroi
	 *            Date
	 * @param exfear
	 *            Date
	 * @param excoorie
	 *            String
	 * @param exinre
	 *            String
	 * @param exincoco
	 *            String
	 * @param exinexva
	 *            String
	 * @param exfecirc
	 *            Date
	 * @param exfenoai
	 *            Date
	 * @param exfecolm
	 *            Date
	 * @param exnuinlm
	 *            String
	 * @param exfeinmu
	 *            Date
	 * @param exfeavmu
	 *            Date
	 * @param exfeimcd
	 *            Date
	 * @param exfecede
	 *            Date
	 * @param excops
	 *            String
	 * @param excose
	 *            String
	 * @param sanexp
	 *            Sanexp
	 * @param establecimiento
	 *            Establecimiento
	 * @param recurso
	 *            Recurso
	 * @param producto
	 *            Producto
	 */
	public Expedien(String excodigo, String excoor, BigDecimal exnran, BigDecimal exnror, Date exfere, String excoit,
			String excoes, Date exfeacin, Date exfeemca, Date exfeplca, Date exfpnopc, Date exfede, Date exfecoal,
			Date exfenopr, Date exfepupr, String excoospr, Date exfealpr, Date exfeel, Date exferes, Date exfenore,
			Date exfepure, String excoosre, String excottr, BigDecimal excamure, Date exfeta, String excotsa,
			Date exfecroi, Date exfear, String excoorie, String exinre, String exincoco, String exinexva, Date exfecirc,
			Date exfenoai, Date exfecolm, String exnuinlm, Date exfeinmu, Date exfeavmu, Date exfeimcd, Date exfecede,
			String excops, String excose, Sanexp sanexp, Establecimiento establecimiento, Recurso recurso,
			Producto producto) {
		this.excodigo = excodigo;
		this.excoor = excoor;
		this.exnran = exnran;
		this.exnror = exnror;

		if (this.excoor != null && this.exnror != null && this.exnran != null) {
			this.codCompleto = this.excoor + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + this.exnror
					+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + this.exnran;
		}

		this.exfere = exfere;
		this.excoit = excoit;
		this.excoes = excoes;
		this.exfeacin = exfeacin;
		this.exfeemca = exfeemca;
		this.exfeplca = exfeplca;
		this.exfpnopc = exfpnopc;
		this.exfede = exfede;
		this.exfecoal = exfecoal;
		this.exfenopr = exfenopr;
		this.exfepupr = exfepupr;
		this.excoospr = excoospr;
		this.exfealpr = exfealpr;
		this.exfeel = exfeel;
		this.exferes = exferes;
		this.exfenore = exfenore;
		this.exfepure = exfepure;
		this.excoosre = excoosre;
		this.excottr = excottr;
		this.excamure = excamure;
		this.exfeta = exfeta;
		this.excotsa = excotsa;
		this.exfecroi = exfecroi;
		this.exfear = exfear;
		this.excoorie = excoorie;
		this.exinre = exinre;
		this.exincoco = exincoco;
		this.exinexva = exinexva;
		this.exfecirc = exfecirc;
		this.exfenoai = exfenoai;
		this.exfecolm = exfecolm;
		this.exnuinlm = exnuinlm;
		this.exfeinmu = exfeinmu;
		this.exfeavmu = exfeavmu;
		this.exfeimcd = exfeimcd;
		this.exfecede = exfecede;
		this.excops = excops;
		this.excose = excose;
		this.sanexp = sanexp;
		this.recurso = recurso;
		this.producto = producto;
		this.establecimiento = establecimiento;
	}

	/**
	 * 
	 * @param excodigo
	 *            String
	 * @param codCompleto
	 *            String
	 * @param exfere
	 *            Date
	 * @param sanexp
	 *            Sanexp
	 * @param saninterv
	 *            Saninterv
	 * @param excoor
	 *            String
	 * @param exnran
	 *            String
	 * @param exnror
	 *            String
	 * @param excoit
	 *            String
	 */
	public Expedien(String excodigo, String codCompleto, Date exfere, Sanexp sanexp, Saninterv saninterv, String excoor,
			BigDecimal exnran, BigDecimal exnror, String excoit) {
		this.excodigo = excodigo;
		this.codCompleto = codCompleto;
		this.exfere = exfere;
		this.sanexp = sanexp;
		this.denunciado = saninterv;
		this.excoor = excoor;
		this.exnran = exnran;
		this.exnror = exnror;
		this.excoit = excoit;
	}

	/**
	 * 
	 * @param excodigo
	 *            String
	 * 
	 */
	public Expedien(String excodigo) {
		this.excodigo = excodigo;

	}

	/**
	 * Method 'Expedien'.
	 * 
	 * @param excodigo
	 *            String
	 * @param excoor
	 *            String
	 * @param exnran
	 *            BigDecimal
	 * @param exnror
	 *            BigDecimal
	 * @param exfere
	 *            Date
	 * @param excoit
	 *            String
	 * @param excoes
	 *            String
	 * @param exfeacin
	 *            Date
	 * @param exfeemca
	 *            Date
	 * @param exfeplca
	 *            Date
	 * @param exfpnopc
	 *            Date
	 * @param exfede
	 *            Date
	 * @param exfecoal
	 *            Date
	 * @param exfenopr
	 *            Date
	 * @param exfepupr
	 *            Date
	 * @param excoospr
	 *            String
	 * @param exfealpr
	 *            Date
	 * @param exfeel
	 *            Date
	 * @param exferes
	 *            Date
	 * @param exfenore
	 *            Date
	 * @param exfepure
	 *            Date
	 * @param excoosre
	 *            String
	 * @param excottr
	 *            String
	 * @param excamure
	 *            BigDecimal
	 * @param exfeta
	 *            Date
	 * @param excotsa
	 *            String
	 * @param exfecroi
	 *            Date
	 * @param exfear
	 *            Date
	 * @param excoorie
	 *            String
	 * @param exinre
	 *            String
	 * @param exincoco
	 *            String
	 * @param exinexva
	 *            String
	 * @param exfecirc
	 *            Date
	 * @param exfenoai
	 *            Date
	 * @param exfecolm
	 *            Date
	 * @param exnuinlm
	 *            String
	 * @param exfeinmu
	 *            Date
	 * @param exfeavmu
	 *            Date
	 * @param exfeimcd
	 *            Date
	 * @param exfecede
	 *            Date
	 * @param excops
	 *            String
	 * @param excose
	 *            String
	 * @param sanexp
	 *            Sanexp
	 * @param sanenvios
	 *            List<Sanenvio>
	 * @param santramexps
	 *            List<Santramexp>
	 * @param sandoctemps
	 *            List<Sandoctemp>
	 * @param sanexprelsForRlexcodigo
	 *            List<Sanexprel>
	 * @param sanprues
	 *            List<Sanprue>
	 * @param sanintervs
	 *            List<Saninterv>
	 * @param sanexprelsForRlexcodrel
	 *            List<Sanexprel>
	 * @param sanbandejas
	 *            List<Sanbandeja>
	 */
	public Expedien(String excodigo, String excoor, BigDecimal exnran, BigDecimal exnror, Date exfere, String excoit,
			String excoes, Date exfeacin, Date exfeemca, Date exfeplca, Date exfpnopc, Date exfede, Date exfecoal,
			Date exfenopr, Date exfepupr, String excoospr, Date exfealpr, Date exfeel, Date exferes, Date exfenore,
			Date exfepure, String excoosre, String excottr, BigDecimal excamure, Date exfeta, String excotsa,
			Date exfecroi, Date exfear, String excoorie, String exinre, String exincoco, String exinexva, Date exfecirc,
			Date exfenoai, Date exfecolm, String exnuinlm, Date exfeinmu, Date exfeavmu, Date exfeimcd, Date exfecede,
			String excops, String excose, Sanexp sanexp, List<Sanenvio> sanenvios, List<Santramexp> santramexps,
			List<Sandoctemp> sandoctemps, List<Sanexprel> sanexprelsForRlexcodigo, List<Sanprue> sanprues,
			List<Saninterv> sanintervs, List<Sanexprel> sanexprelsForRlexcodrel, List<Sanbandeja> sanbandejas) {

		this.excodigo = excodigo;
		this.excoor = excoor;
		this.exnran = exnran;
		this.exnror = exnror;
		this.exfere = exfere;
		this.excoit = excoit;
		this.excoes = excoes;
		this.exfeacin = exfeacin;
		this.exfeemca = exfeemca;
		this.exfeplca = exfeplca;
		this.exfpnopc = exfpnopc;
		this.exfede = exfede;
		this.exfecoal = exfecoal;
		this.exfenopr = exfenopr;
		this.exfepupr = exfepupr;
		this.excoospr = excoospr;
		this.exfealpr = exfealpr;
		this.exfeel = exfeel;
		this.exferes = exferes;
		this.exfenore = exfenore;
		this.exfepure = exfepure;
		this.excoosre = excoosre;
		this.excottr = excottr;
		this.excamure = excamure;
		this.exfeta = exfeta;
		this.excotsa = excotsa;
		this.exfecroi = exfecroi;
		this.exfear = exfear;
		this.excoorie = excoorie;
		this.exinre = exinre;
		this.exincoco = exincoco;
		this.exinexva = exinexva;
		this.exfecirc = exfecirc;
		this.exfenoai = exfenoai;
		this.exfecolm = exfecolm;
		this.exnuinlm = exnuinlm;
		this.exfeinmu = exfeinmu;
		this.exfeavmu = exfeavmu;
		this.exfeimcd = exfeimcd;
		this.exfecede = exfecede;
		this.excops = excops;
		this.excose = excose;
		this.sanexp = sanexp;
		this.sanenvios = sanenvios;
		this.santramexps = santramexps;
		this.sandoctemps = sandoctemps;
		this.sanexprelsForRlexcodigo = sanexprelsForRlexcodigo;
		this.sanprues = sanprues;
		this.sanintervs = sanintervs;
		this.sanexprelsForRlexcodrel = sanexprelsForRlexcodrel;
		this.sanbandejas = sanbandejas;
	}

	/**
	 * Method 'getExcodigo'.
	 * 
	 * @return String
	 */

	public String getExcodigo() {
		return this.excodigo;
	}

	/**
	 * Method 'setExcodigo'.
	 * 
	 * @param excodigo
	 *            String
	 * @return
	 */

	public void setExcodigo(String excodigo) {
		this.excodigo = excodigo;
	}

	/**
	 * Method 'getExcoor'.
	 * 
	 * @return String
	 */

	public String getExcoor() {
		return this.excoor;
	}

	/**
	 * Method 'setExcoor'.
	 * 
	 * @param excoor
	 *            String
	 * @return
	 */

	public void setExcoor(String excoor) {
		this.excoor = excoor;
	}

	/**
	 * Method 'getExnran'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getExnran() {
		return this.exnran;
	}

	/**
	 * Method 'setExnran'.
	 * 
	 * @param exnran
	 *            BigDecimal
	 * @return
	 */

	public void setExnran(BigDecimal exnran) {
		this.exnran = exnran;
	}

	/**
	 * Method 'getExnror'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getExnror() {
		return this.exnror;
	}

	/**
	 * Method 'setExnror'.
	 * 
	 * @param exnror
	 *            BigDecimal
	 * @return
	 */

	public void setExnror(BigDecimal exnror) {
		this.exnror = exnror;
	}

	/**
	 * Method 'getExfere'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfere() {
		return this.exfere;
	}

	/**
	 * Method 'setExfere'.
	 * 
	 * @param exfere
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfere(Date exfere) {
		this.exfere = exfere;
	}

	/**
	 * Method 'getExcoit'.
	 * 
	 * @return String
	 */

	public String getExcoit() {
		return this.excoit;
	}

	/**
	 * Method 'setExcoit'.
	 * 
	 * @param excoit
	 *            String
	 * @return
	 */

	public void setExcoit(String excoit) {
		this.excoit = excoit;
	}

	/**
	 * Method 'getExcoes'.
	 * 
	 * @return String
	 */

	public String getExcoes() {
		return this.excoes;
	}

	/**
	 * Method 'setExcoes'.
	 * 
	 * @param excoes
	 *            String
	 * @return
	 */

	public void setExcoes(String excoes) {
		this.excoes = excoes;
	}

	/**
	 * Method 'getExfeacin'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfeacin() {
		return this.exfeacin;
	}

	/**
	 * Method 'setExfeacin'.
	 * 
	 * @param exfeacin
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfeacin(Date exfeacin) {
		this.exfeacin = exfeacin;
	}

	/**
	 * Method 'getExfeemca'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfeemca() {
		return this.exfeemca;
	}

	/**
	 * Method 'setExfeemca'.
	 * 
	 * @param exfeemca
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfeemca(Date exfeemca) {
		this.exfeemca = exfeemca;
	}

	/**
	 * Method 'getExfeplca'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfeplca() {
		return this.exfeplca;
	}

	/**
	 * Method 'setExfeplca'.
	 * 
	 * @param exfeplca
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfeplca(Date exfeplca) {
		this.exfeplca = exfeplca;
	}

	/**
	 * Method 'getExfpnopc'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfpnopc() {
		return this.exfpnopc;
	}

	/**
	 * Method 'setExfpnopc'.
	 * 
	 * @param exfpnopc
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfpnopc(Date exfpnopc) {
		this.exfpnopc = exfpnopc;
	}

	/**
	 * Method 'getExfede'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfede() {
		return this.exfede;
	}

	/**
	 * Method 'setExfede'.
	 * 
	 * @param exfede
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfede(Date exfede) {
		this.exfede = exfede;
	}

	/**
	 * Method 'getExfecoal'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfecoal() {
		return this.exfecoal;
	}

	/**
	 * Method 'setExfecoal'.
	 * 
	 * @param exfecoal
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfecoal(Date exfecoal) {
		this.exfecoal = exfecoal;
	}

	/**
	 * Method 'getExfenopr'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfenopr() {
		return this.exfenopr;
	}

	/**
	 * Method 'setExfenopr'.
	 * 
	 * @param exfenopr
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfenopr(Date exfenopr) {
		this.exfenopr = exfenopr;
	}

	/**
	 * Method 'getExfepupr'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfepupr() {
		return this.exfepupr;
	}

	/**
	 * Method 'setExfepupr'.
	 * 
	 * @param exfepupr
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfepupr(Date exfepupr) {
		this.exfepupr = exfepupr;
	}

	/**
	 * Method 'getExcoospr'.
	 * 
	 * @return String
	 */

	public String getExcoospr() {
		return this.excoospr;
	}

	/**
	 * Method 'setExcoospr'.
	 * 
	 * @param excoospr
	 *            String
	 * @return
	 */

	public void setExcoospr(String excoospr) {
		this.excoospr = excoospr;
	}

	/**
	 * Method 'getExfealpr'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfealpr() {
		return this.exfealpr;
	}

	/**
	 * Method 'setExfealpr'.
	 * 
	 * @param exfealpr
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfealpr(Date exfealpr) {
		this.exfealpr = exfealpr;
	}

	/**
	 * Method 'getExfeel'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfeel() {
		return this.exfeel;
	}

	/**
	 * Method 'setExfeel'.
	 * 
	 * @param exfeel
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfeel(Date exfeel) {
		this.exfeel = exfeel;
	}

	/**
	 * Method 'getExferes'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExferes() {
		return this.exferes;
	}

	/**
	 * Method 'setExferes'.
	 * 
	 * @param exferes
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExferes(Date exferes) {
		this.exferes = exferes;
	}

	/**
	 * Method 'getExfenore'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfenore() {
		return this.exfenore;
	}

	/**
	 * Method 'setExfenore'.
	 * 
	 * @param exfenore
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfenore(Date exfenore) {
		this.exfenore = exfenore;
	}

	/**
	 * Method 'getExfepure'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfepure() {
		return this.exfepure;
	}

	/**
	 * Method 'setExfepure'.
	 * 
	 * @param exfepure
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfepure(Date exfepure) {
		this.exfepure = exfepure;
	}

	/**
	 * Method 'getExcoosre'.
	 * 
	 * @return String
	 */

	public String getExcoosre() {
		return this.excoosre;
	}

	/**
	 * Method 'setExcoosre'.
	 * 
	 * @param excoosre
	 *            String
	 * @return
	 */

	public void setExcoosre(String excoosre) {
		this.excoosre = excoosre;
	}

	/**
	 * Method 'getExcottr'.
	 * 
	 * @return String
	 */

	public String getExcottr() {
		return this.excottr;
	}

	/**
	 * Method 'setExcottr'.
	 * 
	 * @param excottr
	 *            String
	 * @return
	 */

	public void setExcottr(String excottr) {
		this.excottr = excottr;
	}

	/**
	 * Method 'getExcamure'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getExcamure() {
		return this.excamure;
	}

	/**
	 * Method 'setExcamure'.
	 * 
	 * @param excamure
	 *            BigDecimal
	 * @return
	 */

	public void setExcamure(BigDecimal excamure) {
		this.excamure = excamure;
	}

	/**
	 * Method 'getExfeta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfeta() {
		return this.exfeta;
	}

	/**
	 * Method 'setExfeta'.
	 * 
	 * @param exfeta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfeta(Date exfeta) {
		this.exfeta = exfeta;
	}

	/**
	 * Method 'getExcotsa'.
	 * 
	 * @return String
	 */

	public String getExcotsa() {
		return this.excotsa;
	}

	/**
	 * Method 'setExcotsa'.
	 * 
	 * @param excotsa
	 *            String
	 * @return
	 */

	public void setExcotsa(String excotsa) {
		this.excotsa = excotsa;
	}

	/**
	 * Method 'getExfecroi'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfecroi() {
		return this.exfecroi;
	}

	/**
	 * Method 'setExfecroi'.
	 * 
	 * @param exfecroi
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfecroi(Date exfecroi) {
		this.exfecroi = exfecroi;
	}

	/**
	 * Method 'getExfear'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfear() {
		return this.exfear;
	}

	/**
	 * Method 'setExfear'.
	 * 
	 * @param exfear
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfear(Date exfear) {
		this.exfear = exfear;
	}

	/**
	 * Method 'getExcoorie'.
	 * 
	 * @return String
	 */

	public String getExcoorie() {
		return this.excoorie;
	}

	/**
	 * Method 'setExcoorie'.
	 * 
	 * @param excoorie
	 *            String
	 * @return
	 */

	public void setExcoorie(String excoorie) {
		this.excoorie = excoorie;
	}

	/**
	 * Method 'getExinre'.
	 * 
	 * @return String
	 */

	public String getExinre() {
		return this.exinre;
	}

	/**
	 * Method 'setExinre'.
	 * 
	 * @param exinre
	 *            String
	 * @return
	 */

	public void setExinre(String exinre) {
		this.exinre = exinre;
	}

	/**
	 * Method 'getExincoco'.
	 * 
	 * @return String
	 */

	public String getExincoco() {
		return this.exincoco;
	}

	/**
	 * Method 'setExincoco'.
	 * 
	 * @param exincoco
	 *            String
	 * @return
	 */

	public void setExincoco(String exincoco) {
		this.exincoco = exincoco;
	}

	/**
	 * Method 'getExinexva'.
	 * 
	 * @return String
	 */

	public String getExinexva() {
		return this.exinexva;
	}

	/**
	 * Method 'setExinexva'.
	 * 
	 * @param exinexva
	 *            String
	 * @return
	 */

	public void setExinexva(String exinexva) {
		this.exinexva = exinexva;
	}

	/**
	 * Method 'getExfecirc'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfecirc() {
		return this.exfecirc;
	}

	/**
	 * Method 'setExfecirc'.
	 * 
	 * @param exfecirc
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfecirc(Date exfecirc) {
		this.exfecirc = exfecirc;
	}

	/**
	 * Method 'getExfenoai'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfenoai() {
		return this.exfenoai;
	}

	/**
	 * Method 'setExfenoai'.
	 * 
	 * @param exfenoai
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfenoai(Date exfenoai) {
		this.exfenoai = exfenoai;
	}

	/**
	 * Method 'getExfecolm'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfecolm() {
		return this.exfecolm;
	}

	/**
	 * Method 'setExfecolm'.
	 * 
	 * @param exfecolm
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfecolm(Date exfecolm) {
		this.exfecolm = exfecolm;
	}

	/**
	 * Method 'getExnuinlm'.
	 * 
	 * @return String
	 */

	public String getExnuinlm() {
		return this.exnuinlm;
	}

	/**
	 * Method 'setExnuinlm'.
	 * 
	 * @param exnuinlm
	 *            String
	 * @return
	 */

	public void setExnuinlm(String exnuinlm) {
		this.exnuinlm = exnuinlm;
	}

	/**
	 * Method 'getExfeinmu'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfeinmu() {
		return this.exfeinmu;
	}

	/**
	 * Method 'setExfeinmu'.
	 * 
	 * @param exfeinmu
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfeinmu(Date exfeinmu) {
		this.exfeinmu = exfeinmu;
	}

	/**
	 * Method 'getExfeavmu'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfeavmu() {
		return this.exfeavmu;
	}

	/**
	 * Method 'setExfeavmu'.
	 * 
	 * @param exfeavmu
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfeavmu(Date exfeavmu) {
		this.exfeavmu = exfeavmu;
	}

	/**
	 * Method 'getExfeimcd'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfeimcd() {
		return this.exfeimcd;
	}

	/**
	 * Method 'setExfeimcd'.
	 * 
	 * @param exfeimcd
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfeimcd(Date exfeimcd) {
		this.exfeimcd = exfeimcd;
	}

	/**
	 * Method 'getExfecede'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getExfecede() {
		return this.exfecede;
	}

	/**
	 * Method 'setExfecede'.
	 * 
	 * @param exfecede
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setExfecede(Date exfecede) {
		this.exfecede = exfecede;
	}

	/**
	 * Method 'getExcops'.
	 * 
	 * @return String
	 */

	public String getExcops() {
		return this.excops;
	}

	/**
	 * Method 'setExcops'.
	 * 
	 * @param excops
	 *            String
	 * @return
	 */

	public void setExcops(String excops) {
		this.excops = excops;
	}

	/**
	 * Method 'getExcose'.
	 * 
	 * @return String
	 */

	public String getExcose() {
		return this.excose;
	}

	/**
	 * Method 'setExcose'.
	 * 
	 * @param excose
	 *            String
	 * @return
	 */

	public void setExcose(String excose) {
		this.excose = excose;
	}

	/**
	 * Method 'getSanexp'.
	 * 
	 * @return Sanexp
	 */

	public Sanexp getSanexp() {
		return this.sanexp;
	}

	/**
	 * Method 'setSanexp'.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return
	 */

	public void setSanexp(Sanexp sanexp) {
		this.sanexp = sanexp;
	}

	/**
	 * Method 'getSanexp'.
	 * 
	 * @return Sanexp
	 */

	public Saninterv getDenunciante() {
		return this.denunciante;
	}

	/**
	 * Method 'setSanexp'.
	 * 
	 * @param denunciante
	 *            Saninterv
	 */

	public void setDenunciante(Saninterv denunciante) {
		this.denunciante = denunciante;
	}

	/**
	 * Method 'getSanexp'.
	 * 
	 * @return Sanexp
	 */

	public Saninterv getDenunciado() {
		return this.denunciado;
	}

	/**
	 * Method 'setSanexp'.
	 * 
	 * @param denunciado
	 *            Saninterv
	 */

	public void setDenunciado(Saninterv denunciado) {
		this.denunciado = denunciado;
	}

	/**
	 * Method 'getSanenvios'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sanenvio> getSanenvios() {
		return this.sanenvios;
	}

	/**
	 * Method 'setSanenvios'.
	 * 
	 * @param sanenvios
	 *            List
	 * @return
	 */
	public void setSanenvios(List<Sanenvio> sanenvios) {
		this.sanenvios = sanenvios;
	}

	/**
	 * Method 'getSantramexps'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Santramexp> getSantramexps() {
		return this.santramexps;
	}

	/**
	 * Method 'setSantramexps'.
	 * 
	 * @param santramexps
	 *            List
	 * @return
	 */
	public void setSantramexps(List<Santramexp> santramexps) {
		this.santramexps = santramexps;
	}

	/**
	 * Method 'getSandoctemps'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sandoctemp> getSandoctemps() {
		return this.sandoctemps;
	}

	/**
	 * Method 'setSandoctemps'.
	 * 
	 * @param sandoctemps
	 *            List
	 * @return
	 */
	public void setSandoctemps(List<Sandoctemp> sandoctemps) {
		this.sandoctemps = sandoctemps;
	}

	/**
	 * Method 'getSanexprelsForRlexcodigo'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sanexprel> getSanexprelsForRlexcodigo() {
		return this.sanexprelsForRlexcodigo;
	}

	/**
	 * Method 'setSanexprelsForRlexcodigo'.
	 * 
	 * @param sanexprelsForRlexcodigo
	 *            List
	 * @return
	 */
	public void setSanexprelsForRlexcodigo(List<Sanexprel> sanexprelsForRlexcodigo) {
		this.sanexprelsForRlexcodigo = sanexprelsForRlexcodigo;
	}

	/**
	 * Method 'getSanprues'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sanprue> getSanprues() {
		return this.sanprues;
	}

	/**
	 * Method 'setSanprues'.
	 * 
	 * @param sanprues
	 *            List
	 * @return
	 */
	public void setSanprues(List<Sanprue> sanprues) {
		this.sanprues = sanprues;
	}

	/**
	 * Method 'getSanintervs'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Saninterv> getSanintervs() {
		return this.sanintervs;
	}

	/**
	 * Method 'setSanintervs'.
	 * 
	 * @param sanintervs
	 *            List
	 * @return
	 */
	public void setSanintervs(List<Saninterv> sanintervs) {
		this.sanintervs = sanintervs;
	}

	/**
	 * Method 'getSanexprelsForRlexcodrel'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sanexprel> getSanexprelsForRlexcodrel() {
		return this.sanexprelsForRlexcodrel;
	}

	/**
	 * Method 'setSanexprelsForRlexcodrel'.
	 * 
	 * @param sanexprelsForRlexcodrel
	 *            List
	 * @return
	 */
	public void setSanexprelsForRlexcodrel(List<Sanexprel> sanexprelsForRlexcodrel) {
		this.sanexprelsForRlexcodrel = sanexprelsForRlexcodrel;
	}

	/**
	 * Method 'getSanbandejas'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Sanbandeja> getSanbandejas() {
		return this.sanbandejas;
	}

	/**
	 * Method 'setSanbandejas'.
	 * 
	 * @param sanbandejas
	 *            List
	 * @return
	 */
	public void setSanbandejas(List<Sanbandeja> sanbandejas) {
		this.sanbandejas = sanbandejas;

	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ excodigo: ").append(this.excodigo).append(" ]");
		result.append(", [ excoor: ").append(this.excoor).append(" ]");
		result.append(", [ exnran: ").append(this.exnran).append(" ]");
		result.append(", [ exnror: ").append(this.exnror).append(" ]");
		result.append(", [ exfere: ").append(this.exfere).append(" ]");
		result.append(", [ excoit: ").append(this.excoit).append(" ]");
		result.append(", [ excoes: ").append(this.excoes).append(" ]");
		result.append(", [ exfeacin: ").append(this.exfeacin).append(" ]");
		result.append(", [ exfeemca: ").append(this.exfeemca).append(" ]");
		result.append(", [ exfeplca: ").append(this.exfeplca).append(" ]");
		result.append(", [ exfpnopc: ").append(this.exfpnopc).append(" ]");
		result.append(", [ exfede: ").append(this.exfede).append(" ]");
		result.append(", [ exfecoal: ").append(this.exfecoal).append(" ]");
		result.append(", [ exfenopr: ").append(this.exfenopr).append(" ]");
		result.append(", [ exfepupr: ").append(this.exfepupr).append(" ]");
		result.append(", [ excoospr: ").append(this.excoospr).append(" ]");
		result.append(", [ exfealpr: ").append(this.exfealpr).append(" ]");
		result.append(", [ exfeel: ").append(this.exfeel).append(" ]");
		result.append(", [ exferes: ").append(this.exferes).append(" ]");
		result.append(", [ exfenore: ").append(this.exfenore).append(" ]");
		result.append(", [ exfepure: ").append(this.exfepure).append(" ]");
		result.append(", [ excoosre: ").append(this.excoosre).append(" ]");
		result.append(", [ excottr: ").append(this.excottr).append(" ]");
		result.append(", [ excamure: ").append(this.excamure).append(" ]");
		result.append(", [ exfeta: ").append(this.exfeta).append(" ]");
		result.append(", [ excotsa: ").append(this.excotsa).append(" ]");
		result.append(", [ exfecroi: ").append(this.exfecroi).append(" ]");
		result.append(", [ exfear: ").append(this.exfear).append(" ]");
		result.append(", [ excoorie: ").append(this.excoorie).append(" ]");
		result.append(", [ exinre: ").append(this.exinre).append(" ]");
		result.append(", [ exincoco: ").append(this.exincoco).append(" ]");
		result.append(", [ exinexva: ").append(this.exinexva).append(" ]");
		result.append(", [ exfecirc: ").append(this.exfecirc).append(" ]");
		result.append(", [ exfenoai: ").append(this.exfenoai).append(" ]");
		result.append(", [ exfecolm: ").append(this.exfecolm).append(" ]");
		result.append(", [ exnuinlm: ").append(this.exnuinlm).append(" ]");
		result.append(", [ exfeinmu: ").append(this.exfeinmu).append(" ]");
		result.append(", [ exfeavmu: ").append(this.exfeavmu).append(" ]");
		result.append(", [ exfeimcd: ").append(this.exfeimcd).append(" ]");
		result.append(", [ exfecede: ").append(this.exfecede).append(" ]");
		result.append(", [ excops: ").append(this.excops).append(" ]");
		result.append(", [ excose: ").append(this.excose).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * Damecod completo.
	 * 
	 * @return the string
	 */
	public String damecodCompleto() {
		return this.getExcoor() + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + this.getExnror().toString()
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + this.getExnran().toString();

	}

	/**
	 * Damecod completo platea.
	 * 
	 * @return the string
	 */
	public String damecodCompletoPlatea() {
		return Y41bConstantes.TIPO_PROC_SANCIONES + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + this.getExcoor()
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + this.getExnror().toString()
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + this.getExnran().toString();

	}

	/**
	 * 
	 * @return String
	 */
	public String getCodCompletoConPrefijo() {
		return this.damecodCompletoPlatea();
	}

	/**
	 * Gets the cod completo.
	 * 
	 * @return the cod completo
	 */
	public String getcodCompleto() {
		// return getExcoor() + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP +
		// getExnror().toString() + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP +
		// getExnran().toString();
		return this.codCompleto;
	}

	/**
	 * Method 'setcodCompleto'.
	 * 
	 * @param codCompleto
	 *            String
	 * @return
	 */

	public void setcodCompleto(String codCompleto) {
		this.codCompleto = codCompleto;
		if (!"".equals(codCompleto)) {
			int posicionPrimerDelimitador = codCompleto.indexOf(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP, 0);
			int posicionSegundoDelimitador = codCompleto.indexOf(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP,
					posicionPrimerDelimitador + 1);

			this.setExcoor(codCompleto.substring(0, posicionPrimerDelimitador));
			this.setExnror(
					new BigDecimal(codCompleto.substring(posicionPrimerDelimitador + 1, posicionSegundoDelimitador)));
			this.setExnran(new BigDecimal(codCompleto.substring(posicionSegundoDelimitador + 1, codCompleto.length())));
		}
	}

	/**
	 * @param establecimiento
	 *            the establecimiento to set
	 */
	public void setEstablecimiento(Establecimiento establecimiento) {
		this.establecimiento = establecimiento;
	}

	/**
	 * @return the establecimiento
	 */
	public Establecimiento getEstablecimiento() {
		return this.establecimiento;
	}

	/**
	 * @param recurso
	 *            the recurso to set
	 */
	public void setRecurso(Recurso recurso) {
		this.recurso = recurso;
	}

	/**
	 * @return the recurso
	 */
	public Recurso getRecurso() {
		return this.recurso;
	}

	/**
	 * 
	 * @param articulosAniadidos
	 *            List<String>
	 */
	public void setArticulosAniadidos(List<String> articulosAniadidos) {
		this.articulosAniadidos = articulosAniadidos;
	}

	/**
	 * 
	 * @return List
	 */
	public List<String> getArticulosAniadidos() {
		return this.articulosAniadidos;
	}

	/**
	 * 
	 * @param materiasAniadidas
	 *            List
	 */
	public void setMateriasAniadidas(List<String> materiasAniadidas) {
		this.materiasAniadidas = materiasAniadidas;
	}

	/**
	 * 
	 * @return List
	 */
	public List<String> getMateriasAniadidas() {
		return this.materiasAniadidas;
	}

	/**
	 * @return the tipoApertura
	 */
	public String getTipoApertura() {
		return this.tipoApertura;
	}

	/**
	 * @param tipoApertura
	 *            the tipoApertura to set
	 */
	public void setTipoApertura(String tipoApertura) {
		this.tipoApertura = tipoApertura;
	}

	/**
	 * @return the escodigo
	 */
	public String getEscodigo() {
		return this.escodigo;
	}

	/**
	 * @param escodigo
	 *            the escodigo to set
	 */
	public void setEscodigo(String escodigo) {
		this.escodigo = escodigo;
	}

	/**
	 * @return the materias
	 */
	public List<InfraccHechoDen> getMaterias() {
		return this.materias;
	}

	/**
	 * @param materias
	 *            the materias to set
	 */
	public void setMaterias(List<InfraccHechoDen> materias) {
		this.materias = materias;
	}

	/**
	 * @return the articulos
	 */
	public List<InfraccHechoDen> getArticulos() {
		return this.articulos;
	}

	/**
	 * @param articulos
	 *            the articulos to set
	 */
	public void setArticulos(List<InfraccHechoDen> articulos) {
		this.articulos = articulos;
	}

	/**
	 * @return the tctipres
	 */
	public Tctipres getTctipres() {
		return this.tctipres;
	}

	/**
	 * @param tctipres
	 *            the tctipres to set
	 */
	public void setTctipres(Tctipres tctipres) {
		this.tctipres = tctipres;
	}

	/**
	 * @return the producto
	 */
	public Producto getProducto() {
		return this.producto;
	}

	/**
	 * @param producto
	 *            the producto to set
	 */
	public void setProducto(Producto producto) {
		this.producto = producto;
	}

	/**
	 * @return the sancionadoCambio
	 */
	public String getSancionadoCambio() {
		return this.sancionadoCambio;
	}

	/**
	 * @param sancionadoCambio
	 *            the sancionadoCambio to set
	 */
	public void setSancionadoCambio(String sancionadoCambio) {
		this.sancionadoCambio = sancionadoCambio;
	}

	/**
	 * @return the formanotificacion
	 */
	public String getFormanotificacion() {
		return this.formanotificacion;
	}

	/**
	 * @param formanotificacion
	 *            the formanotificacion to set
	 */
	public void setFormanotificacion(String formanotificacion) {
		this.formanotificacion = formanotificacion;
	}

	/**
	 * @return the idsDescriptores
	 */
	public String getIdsDescriptores() {
		return idsDescriptores;
	}

	/**
	 * @param idsDescriptores
	 *            the idsDescriptores to set
	 */
	public void setIdsDescriptores(String idsDescriptores) {
		this.idsDescriptores = idsDescriptores;
	}

	/**
	 * @return the descsDescriptores
	 */
	public String getDescsDescriptores() {
		return descsDescriptores;
	}

	/**
	 * @param descsDescriptores
	 *            the descsDescriptores to set
	 */
	public void setDescsDescriptores(String descsDescriptores) {
		this.descsDescriptores = descsDescriptores;
	}

	/**
	 * @return the descriptores
	 */
	public List<Descriptor> getDescriptores() {
		return descriptores;
	}

	/**
	 * @param descriptores
	 *            the descriptores to set
	 */
	public void setDescriptores(List<Descriptor> descriptores) {
		this.descriptores = descriptores;
	}

}
