package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.validation.Y41bNifNieCif;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Email;

/**
 * Empper  
 * 
 *  
 */

public class Empper implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String pecodigo;
	@Y41bNifNieCif(message = "error01.required.pecif")
	private String pecif;
	private String penombre;
	private String penodir;
	private String pecolo;
	private String penolo;
	private String penrcopo;
	private String pecopv;
	private String penopv;
	private String penrtel;
	private String penrtel2;
	private String penrfax;
	@Email(message = "error02.required.email")
	private String peteem;
	private String peteurl;
	private String pecoes;
	private Date pefeba;
	private String peteobs;
	private String pecoja;
	private String pecozs;
	private String pefemod;
	private String peprovId;
	private String pemunId;
	private String pelocId;
	private String pecalleId;
	private String peportalId;
	private Date pefecalta;
	private String peusualta;
	private List<Peta1> peta1s = new ArrayList<Peta1>();
	private List<Pese> peses = new ArrayList<Pese>();

	private Establecimiento establecimiento;
	private String peThActAraba;
	private String peThActBizkaia;
	private String peThActGipuzkoa;

	private String baja;

	private String peThActs;
	private String pesecodigo;

	private String pecalle;
	private String pedireccionNoCAPV;
	private String pedireccionAntigua;

	private String senombre;
	private String secodigo;

	private String penombreCp;
	private String penombrePiso;

	/**
	 * Method 'Empper'.
	 */
	public Empper() {
	}

	/**
	 * Method 'Empper'.
	 * 
	 * @param pecodigo
	 *            String
	 * @param pecif
	 *            String
	 * @param penombre
	 *            String
	 * @param penodir
	 *            String
	 * @param pecolo
	 *            String
	 * @param penolo
	 *            String
	 * @param penrcopo
	 *            String
	 * @param pecopv
	 *            String
	 * @param penopv
	 *            String
	 * @param penrtel
	 *            String
	 * @param penrtel2
	 *            String
	 * @param penrfax
	 *            String
	 * @param peteem
	 *            String
	 * @param peteurl
	 *            String
	 * @param pecoes
	 *            String
	 * @param pefeba
	 *            Date
	 * @param peteobs
	 *            String
	 * @param pecoja
	 *            String
	 * @param pecozs
	 *            String
	 * @param pefemod
	 *            String
	 * @param peprovId
	 *            String
	 * @param pemunId
	 *            String
	 * @param pelocId
	 *            String
	 * @param pecalleId
	 *            String
	 * @param peportalId
	 *            String
	 * @param pefecalta
	 *            Date
	 * @param peusualta
	 *            String
	 */
	public Empper(String pecodigo, String pecif, String penombre,
			String penodir, String pecolo, String penolo, String penrcopo,
			String pecopv, String penopv, String penrtel, String penrtel2,
			String penrfax, String peteem, String peteurl, String pecoes,
			Date pefeba, String peteobs, String pecoja, String pecozs,
			String pefemod, String peprovId, String pemunId, String pelocId,
			String pecalleId, String peportalId, Date pefecalta,
			String peusualta) {
		this.pecodigo = pecodigo;
		this.pecif = pecif;
		this.penombre = penombre;
		this.penodir = penodir;
		this.pecolo = pecolo;
		this.penolo = penolo;
		this.penrcopo = penrcopo;
		this.pecopv = pecopv;
		this.penopv = penopv;
		this.penrtel = penrtel;
		this.penrtel2 = penrtel2;
		this.penrfax = penrfax;
		this.peteem = peteem;
		this.peteurl = peteurl;
		this.pecoes = pecoes;
		this.pefeba = pefeba;
		this.peteobs = peteobs;
		this.pecoja = pecoja;
		this.pecozs = pecozs;
		this.pefemod = pefemod;
		this.peprovId = peprovId;
		this.pemunId = pemunId;
		this.pelocId = pelocId;
		this.pecalleId = pecalleId;
		this.peportalId = peportalId;
		this.pefecalta = pefecalta;
		this.peusualta = peusualta;
	}

	/**
	 * Method 'Empper'.
	 * 
	 * @param pecodigo
	 *            String
	 * @param pecif
	 *            String
	 * @param penombre
	 *            String
	 * @param penodir
	 *            String
	 * @param pecolo
	 *            String
	 * @param penolo
	 *            String
	 * @param penrcopo
	 *            String
	 * @param pecopv
	 *            String
	 * @param penopv
	 *            String
	 * @param penrtel
	 *            String
	 * @param penrtel2
	 *            String
	 * @param penrfax
	 *            String
	 * @param peteem
	 *            String
	 * @param peteurl
	 *            String
	 * @param pecoes
	 *            String
	 * @param pefeba
	 *            Date
	 * @param peteobs
	 *            String
	 * @param pecoja
	 *            String
	 * @param pecozs
	 *            String
	 * @param pefemod
	 *            String
	 * @param peprovId
	 *            String
	 * @param pemunId
	 *            String
	 * @param pelocId
	 *            String
	 * @param pecalleId
	 *            String
	 * @param peportalId
	 *            String
	 * @param pefecalta
	 *            Date
	 * @param peusualta
	 *            String
	 * @param peta1s
	 *            List<Peta1>
	 * @param peses
	 *            List<Pese>
	 */
	public Empper(String pecodigo, String pecif, String penombre,
			String penodir, String pecolo, String penolo, String penrcopo,
			String pecopv, String penopv, String penrtel, String penrtel2,
			String penrfax, String peteem, String peteurl, String pecoes,
			Date pefeba, String peteobs, String pecoja, String pecozs,
			String pefemod, String peprovId, String pemunId, String pelocId,
			String pecalleId, String peportalId, Date pefecalta,
			String peusualta, List<Peta1> peta1s, List<Pese> peses) {

		this.pecodigo = pecodigo;
		this.pecif = pecif;
		this.penombre = penombre;
		this.penodir = penodir;
		this.pecolo = pecolo;
		this.penolo = penolo;
		this.penrcopo = penrcopo;
		this.pecopv = pecopv;
		this.penopv = penopv;
		this.penrtel = penrtel;
		this.penrtel2 = penrtel2;
		this.penrfax = penrfax;
		this.peteem = peteem;
		this.peteurl = peteurl;
		this.pecoes = pecoes;
		this.pefeba = pefeba;
		this.peteobs = peteobs;
		this.pecoja = pecoja;
		this.pecozs = pecozs;
		this.pefemod = pefemod;
		this.peprovId = peprovId;
		this.pemunId = pemunId;
		this.pelocId = pelocId;
		this.pecalleId = pecalleId;
		this.peportalId = peportalId;
		this.pefecalta = pefecalta;
		this.peusualta = peusualta;
		this.peta1s = peta1s;
		this.peses = peses;
	}

	/**
	 * Method 'getPecodigo'.
	 * 
	 * @return String
	 */

	public String getPecodigo() {
		return this.pecodigo;
	}

	/**
	 * Method 'setPecodigo'.
	 * 
	 * @param pecodigo
	 *            String
	 * @return
	 */

	public void setPecodigo(String pecodigo) {
		this.pecodigo = pecodigo;
	}

	/**
	 * Method 'getPecif'.
	 * 
	 * @return String
	 */

	public String getPecif() {
		return Y41bUtils.upperCase(this.pecif);
	}

	/**
	 * Method 'setPecif'.
	 * 
	 * @param pecif
	 *            String
	 * @return
	 */

	public void setPecif(String pecif) {
		this.pecif = Y41bUtils.upperCase(pecif);
	}

	/**
	 * Method 'getPenombre'.
	 * 
	 * @return String
	 */

	public String getPenombre() {
		return this.penombre;
	}

	/**
	 * Method 'setPenombre'.
	 * 
	 * @param penombre
	 *            String
	 * @return
	 */

	public void setPenombre(String penombre) {
		this.penombre = penombre;
	}

	/**
	 * Method 'getPenodir'.
	 * 
	 * @return String
	 */

	public String getPenodir() {
		return this.penodir;
	}

	/**
	 * Method 'setPenodir'.
	 * 
	 * @param penodir
	 *            String
	 * @return
	 */

	public void setPenodir(String penodir) {
		this.penodir = penodir;
	}

	/**
	 * Method 'getPecolo'.
	 * 
	 * @return String
	 */

	public String getPecolo() {
		return this.pecolo;
	}

	/**
	 * Method 'setPecolo'.
	 * 
	 * @param pecolo
	 *            String
	 * @return
	 */

	public void setPecolo(String pecolo) {
		this.pecolo = pecolo;
	}

	/**
	 * Method 'getPenolo'.
	 * 
	 * @return String
	 */

	public String getPenolo() {
		return this.penolo;
	}

	/**
	 * Method 'setPenolo'.
	 * 
	 * @param penolo
	 *            String
	 * @return
	 */

	public void setPenolo(String penolo) {
		this.penolo = penolo;
	}

	/**
	 * Method 'getPenrcopo'.
	 * 
	 * @return String
	 */

	public String getPenrcopo() {
		return this.penrcopo;
	}

	/**
	 * Method 'setPenrcopo'.
	 * 
	 * @param penrcopo
	 *            String
	 * @return
	 */

	public void setPenrcopo(String penrcopo) {
		this.penrcopo = penrcopo;
	}

	/**
	 * Method 'getPecopv'.
	 * 
	 * @return String
	 */

	public String getPecopv() {
		return this.pecopv;
	}

	/**
	 * Method 'setPecopv'.
	 * 
	 * @param pecopv
	 *            String
	 * @return
	 */

	public void setPecopv(String pecopv) {
		this.pecopv = pecopv;
	}

	/**
	 * Method 'getPenopv'.
	 * 
	 * @return String
	 */

	public String getPenopv() {
		return this.penopv;
	}

	/**
	 * Method 'setPenopv'.
	 * 
	 * @param penopv
	 *            String
	 * @return
	 */

	public void setPenopv(String penopv) {
		this.penopv = penopv;
	}

	/**
	 * Method 'getPenrtel'.
	 * 
	 * @return String
	 */

	public String getPenrtel() {
		return this.penrtel;
	}

	/**
	 * Method 'setPenrtel'.
	 * 
	 * @param penrtel
	 *            String
	 * @return
	 */

	public void setPenrtel(String penrtel) {
		this.penrtel = penrtel;
	}

	/**
	 * Method 'getPenrtel2'.
	 * 
	 * @return String
	 */

	public String getPenrtel2() {
		return this.penrtel2;
	}

	/**
	 * Method 'setPenrtel2'.
	 * 
	 * @param penrtel2
	 *            String
	 * @return
	 */

	public void setPenrtel2(String penrtel2) {
		this.penrtel2 = penrtel2;
	}

	/**
	 * Method 'getPenrfax'.
	 * 
	 * @return String
	 */

	public String getPenrfax() {
		return this.penrfax;
	}

	/**
	 * Method 'setPenrfax'.
	 * 
	 * @param penrfax
	 *            String
	 * @return
	 */

	public void setPenrfax(String penrfax) {
		this.penrfax = penrfax;
	}

	/**
	 * Method 'getPeteem'.
	 * 
	 * @return String
	 */

	public String getPeteem() {
		return this.peteem;
	}

	/**
	 * Method 'setPeteem'.
	 * 
	 * @param peteem
	 *            String
	 * @return
	 */

	public void setPeteem(String peteem) {
		if (!"null".equalsIgnoreCase(peteem)) {
			this.peteem = peteem;
		}
	}

	/**
	 * Method 'getPeteurl'.
	 * 
	 * @return String
	 */

	public String getPeteurl() {
		return this.peteurl;
	}

	/**
	 * Method 'setPeteurl'.
	 * 
	 * @param peteurl
	 *            String
	 * @return
	 */

	public void setPeteurl(String peteurl) {
		this.peteurl = peteurl;
	}

	/**
	 * Method 'getPecoes'.
	 * 
	 * @return String
	 */

	public String getPecoes() {
		return this.pecoes;
	}

	/**
	 * Method 'setPecoes'.
	 * 
	 * @param pecoes
	 *            String
	 * @return
	 */

	public void setPecoes(String pecoes) {
		this.pecoes = pecoes;
	}

	/**
	 * Method 'getPefeba'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getPefeba() {
		return this.pefeba;
	}

	/**
	 * Method 'setPefeba'.
	 * 
	 * @param pefeba
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setPefeba(Date pefeba) {
		this.pefeba = pefeba;
	}

	/**
	 * Method 'getPeteobs'.
	 * 
	 * @return String
	 */

	public String getPeteobs() {
		return this.peteobs;
	}

	/**
	 * Method 'setPeteobs'.
	 * 
	 * @param peteobs
	 *            String
	 * @return
	 */

	public void setPeteobs(String peteobs) {
		this.peteobs = peteobs;
	}

	/**
	 * Method 'getPecoja'.
	 * 
	 * @return String
	 */

	public String getPecoja() {
		return this.pecoja;
	}

	/**
	 * Method 'setPecoja'.
	 * 
	 * @param pecoja
	 *            String
	 * @return
	 */

	public void setPecoja(String pecoja) {
		this.pecoja = pecoja;
	}

	/**
	 * Method 'getPecozs'.
	 * 
	 * @return String
	 */

	public String getPecozs() {
		return this.pecozs;
	}

	/**
	 * Method 'setPecozs'.
	 * 
	 * @param pecozs
	 *            String
	 * @return
	 */

	public void setPecozs(String pecozs) {
		this.pecozs = pecozs;
	}

	/**
	 * Method 'getPefemod'.
	 * 
	 * @return String
	 */

	public String getPefemod() {
		return this.pefemod;
	}

	/**
	 * Method 'setPefemod'.
	 * 
	 * @param pefemod
	 *            String
	 * @return
	 */

	public void setPefemod(String pefemod) {
		this.pefemod = pefemod;
	}

	/**
	 * Method 'getPeprovId'.
	 * 
	 * @return String
	 */

	public String getPeprovId() {
		return this.peprovId;
	}

	/**
	 * Method 'setPeprovId'.
	 * 
	 * @param peprovId
	 *            String
	 * @return
	 */

	public void setPeprovId(String peprovId) {
		this.peprovId = peprovId;
	}

	/**
	 * Method 'getPemunId'.
	 * 
	 * @return String
	 */

	public String getPemunId() {
		return this.pemunId;
	}

	/**
	 * Method 'setPemunId'.
	 * 
	 * @param pemunId
	 *            String
	 * @return
	 */

	public void setPemunId(String pemunId) {
		this.pemunId = pemunId;
	}

	/**
	 * Method 'getPelocId'.
	 * 
	 * @return String
	 */

	public String getPelocId() {
		return this.pelocId;
	}

	/**
	 * Method 'setPelocId'.
	 * 
	 * @param pelocId
	 *            String
	 * @return
	 */

	public void setPelocId(String pelocId) {
		this.pelocId = pelocId;
	}

	/**
	 * Method 'getPecalleId'.
	 * 
	 * @return String
	 */

	public String getPecalleId() {
		return this.pecalleId;
	}

	/**
	 * Method 'setPecalleId'.
	 * 
	 * @param pecalleId
	 *            String
	 * @return
	 */

	public void setPecalleId(String pecalleId) {
		this.pecalleId = pecalleId;
	}

	/**
	 * Method 'getPeportalId'.
	 * 
	 * @return String
	 */

	public String getPeportalId() {
		return this.peportalId;
	}

	/**
	 * Method 'setPeportalId'.
	 * 
	 * @param peportalId
	 *            String
	 * @return
	 */

	public void setPeportalId(String peportalId) {
		this.peportalId = peportalId;
	}

	/**
	 * Method 'getPefecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getPefecalta() {
		return this.pefecalta;
	}

	/**
	 * Method 'setPefecalta'.
	 * 
	 * @param pefecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setPefecalta(Date pefecalta) {
		this.pefecalta = pefecalta;
	}

	/**
	 * Method 'getPeusualta'.
	 * 
	 * @return String
	 */

	public String getPeusualta() {
		return this.peusualta;
	}

	/**
	 * Method 'setPeusualta'.
	 * 
	 * @param peusualta
	 *            String
	 * @return
	 */

	public void setPeusualta(String peusualta) {
		this.peusualta = peusualta;
	}

	/**
	 * Method 'getPeta1s'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Peta1> getPeta1s() {
		return this.peta1s;
	}

	/**
	 * Method 'setPeta1s'.
	 * 
	 * @param peta1s
	 *            List
	 * @return
	 */
	public void setPeta1s(List<Peta1> peta1s) {
		this.peta1s = peta1s;
	}

	/**
	 * Method 'getPeses'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Pese> getPeses() {
		return this.peses;
	}

	/**
	 * Method 'setPeses'.
	 * 
	 * @param peses
	 *            List
	 * @return
	 */
	public void setPeses(List<Pese> peses) {
		this.peses = peses;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ pecodigo: ").append(this.pecodigo).append(" ]");
		result.append(", [ pecif: ").append(this.pecif).append(" ]");
		result.append(", [ penombre: ").append(this.penombre).append(" ]");
		result.append(", [ penodir: ").append(this.penodir).append(" ]");
		result.append(", [ pecolo: ").append(this.pecolo).append(" ]");
		result.append(", [ penolo: ").append(this.penolo).append(" ]");
		result.append(", [ penrcopo: ").append(this.penrcopo).append(" ]");
		result.append(", [ pecopv: ").append(this.pecopv).append(" ]");
		result.append(", [ penopv: ").append(this.penopv).append(" ]");
		result.append(", [ penrtel: ").append(this.penrtel).append(" ]");
		result.append(", [ penrtel2: ").append(this.penrtel2).append(" ]");
		result.append(", [ penrfax: ").append(this.penrfax).append(" ]");
		result.append(", [ peteem: ").append(this.peteem).append(" ]");
		result.append(", [ peteurl: ").append(this.peteurl).append(" ]");
		result.append(", [ pecoes: ").append(this.pecoes).append(" ]");
		result.append(", [ pefeba: ").append(this.pefeba).append(" ]");
		result.append(", [ peteobs: ").append(this.peteobs).append(" ]");
		result.append(", [ pecoja: ").append(this.pecoja).append(" ]");
		result.append(", [ pecozs: ").append(this.pecozs).append(" ]");
		result.append(", [ pefemod: ").append(this.pefemod).append(" ]");
		result.append(", [ peprovId: ").append(this.peprovId).append(" ]");
		result.append(", [ pemunId: ").append(this.pemunId).append(" ]");
		result.append(", [ pelocId: ").append(this.pelocId).append(" ]");
		result.append(", [ pecalleId: ").append(this.pecalleId).append(" ]");
		result.append(", [ peportalId: ").append(this.peportalId).append(" ]");
		result.append(", [ pefecalta: ").append(this.pefecalta).append(" ]");
		result.append(", [ peusualta: ").append(this.peusualta).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the establecimiento
	 */
	public Establecimiento getEstablecimiento() {
		return this.establecimiento;
	}

	/**
	 * @param establecimiento
	 *            the establecimiento to set
	 */
	public void setEstablecimiento(Establecimiento establecimiento) {
		this.establecimiento = establecimiento;
	}

	/**
	 * @return the peThActGipuzkoa
	 */
	public String getPeThActGipuzkoa() {
		return this.peThActGipuzkoa;
	}

	/**
	 * @param peThActGipuzkoa
	 *            the peThActGipuzkoa to set
	 */
	public void setPeThActGipuzkoa(String peThActGipuzkoa) {
		this.peThActGipuzkoa = peThActGipuzkoa;
	}

	/**
	 * @return the peThActAraba
	 */
	public String getPeThActAraba() {
		return this.peThActAraba;
	}

	/**
	 * @param peThActAraba
	 *            the peThActAraba to set
	 */
	public void setPeThActAraba(String peThActAraba) {
		this.peThActAraba = peThActAraba;
	}

	/**
	 * @return the peThActBizkaia
	 */
	public String getPeThActBizkaia() {
		return this.peThActBizkaia;
	}

	/**
	 * @param peThActBizkaia
	 *            the peThActBizkaia to set
	 */
	public void setPeThActBizkaia(String peThActBizkaia) {
		this.peThActBizkaia = peThActBizkaia;
	}

	/**
	 * @return the peThActs
	 */
	public String getPeThActs() {
		return this.peThActs;
	}

	/**
	 * @param peThActs
	 *            the peThActs to set
	 */
	public void setPeThActs(String peThActs) {
		this.peThActs = peThActs;
	}

	/**
	 * @return the pesecodigo
	 */
	public String getPesecodigo() {
		return this.pesecodigo;
	}

	/**
	 * @param pesecodigo
	 *            the pesecodigo to set
	 */
	public void setPesecodigo(String pesecodigo) {
		this.pesecodigo = pesecodigo;
	}

	/**
	 * @return the pecalle
	 */
	public String getPecalle() {
		return this.pecalle;
	}

	/**
	 * @param pecalle
	 *            the pecalle to set
	 */
	public void setPecalle(String pecalle) {
		this.pecalle = pecalle;
	}

	/**
	 * @return the pedireccionNoCAPV
	 */
	public String getPedireccionNoCAPV() {
		return this.pedireccionNoCAPV;
	}

	/**
	 * @param pedireccionNoCAPV
	 *            the pedireccionNoCAPV to set
	 */
	public void setPedireccionNoCAPV(String pedireccionNoCAPV) {
		this.pedireccionNoCAPV = pedireccionNoCAPV;
	}

	/**
	 * @return the pedireccionAntigua
	 */
	public String getPedireccionAntigua() {
		return this.pedireccionAntigua;
	}

	/**
	 * @param pedireccionAntigua
	 *            the pedireccionAntigua to set
	 */
	public void setPedireccionAntigua(String pedireccionAntigua) {
		this.pedireccionAntigua = pedireccionAntigua;
	}

	/**
	 * @return the senombre
	 */
	public String getSenombre() {
		return senombre;
	}

	/**
	 * @param senombre
	 *            the senombre to set
	 */
	public void setSenombre(String senombre) {
		this.senombre = senombre;
	}

	/**
	 * @return the secodigo
	 */
	public String getSecodigo() {
		return secodigo;
	}

	/**
	 * @param secodigo
	 *            the secodigo to set
	 */
	public void setSecodigo(String secodigo) {
		this.secodigo = secodigo;
	}

	/**
	 * @return the penombreCp
	 */
	public String getPenombreCp() {
		return penombreCp;
	}

	/**
	 * @param penombreCp
	 *            the penombreCp to set
	 */
	public void setPenombreCp(String penombreCp) {
		if (penombreCp != null)
			this.penombreCp = penombreCp.trim();
	}

	/**
	 * @return the penombrePiso
	 */
	public String getPenombrePiso() {
		return penombrePiso;
	}

	/**
	 * @param penombrePiso
	 *            the penombrePiso to set
	 */
	public void setPenombrePiso(String penombrePiso) {
		this.penombrePiso = penombrePiso;
	}

	public void setBaja(String baja) {
		this.baja = baja;
	}

	public String getBaja() {
		return baja;
	}

}
