package com.ejie.y41b.model;

import java.io.InputStream;
import java.sql.Blob;
import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;
import com.ejie.y41b.control.Y41bJsonDateTimeDeserializer;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;

/**
 * * DocumentoHecho  
 * 
 *  
 */

public class DocumentoHecho implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String q5codocumento;
	private String q5hdcodigo;
	private String q5nofile;
	private Blob q5datafile;
	private InputStream q5datafileinputstream;
	private Integer q5sizefile;
	private String q5tedesfile;
	private String q5origen;
	private String q5tramite;
	private Date q5fecha;
	private String q5indmail;
	private String q5trmail;
	private String q5contenttypefile;
	private String q5iddocumentum;
	private Date q5fechaaportacion;
	private Date q5fechaentrada;
	private String q5numregistroentrada;
	private String q5idPerfilfirma;
	private String q5estadodocumento;
	private Date q5fechasolfirma;
	private Date q5fechalimfirma;
	private Date q5fechafirma;
	private String q5comofirma;
	private String q5idTipodoc;
	private String q5destino;
	private Date q5fechasollocalizador;
	private String q5ptcodigo;
	// Tipo de procedimiento
	private String q5pcodigo;

	private String q5numExpediente;

	private String q5idinterviniente;
	private TipoDocumento tipoDocumento;

	private String q5hashfile;

	private String q5NumRegistroOrigen;
	private Date q5FechaRegistroOrigen;

	// Este campo contiene la ruta del pif donde se encuentra el fichero
	private String rutaPif;

	/**
	 * Method 'DocumentoHecho'.
	 */
	public DocumentoHecho() {
	}

	/**
	 * Method 'DocumentoHecho'.
	 * 
	 * @param q5codocumento
	 *            String
	 * @param q5hdcodigo
	 *            String
	 * @param q5nofile
	 *            String
	 * @param q5datafile
	 *            Blob
	 * @param q5sizefile
	 *            Integer
	 * @param q5tedesfile
	 *            String
	 * @param q5origen
	 *            String
	 * @param q5tramite
	 *            String
	 * @param q5fecha
	 *            Date
	 * @param q5indmail
	 *            String
	 * @param q5trmail
	 *            String
	 * @param q5contenttypefile
	 *            String
	 * @param q5iddocumentum
	 *            String
	 * @param q5fechaaportacion
	 *            Date
	 * @param q5fechaentrada
	 *            Date
	 * @param q5numregistroentrada
	 *            String
	 * @param q5idPerfilfirma
	 *            String
	 * @param q5estadodocumento
	 *            String
	 * @param q5fechasolfirma
	 *            Date
	 * @param q5fechalimfirma
	 *            Date
	 * @param q5fechafirma
	 *            Date
	 * @param q5comofirma
	 *            String
	 * @param q5idTipodoc
	 *            String
	 * @param q5destino
	 *            String
	 * @param q5fechasollocalizador
	 *            Date
	 * @param q5ptcodigo
	 *            String
	 * @param q5pcodigo
	 *            String
	 * @param q5hashfile
	 *            String
	 * @param q5FechaRegistroOrigen
	 *            Date
	 * @param q5NumRegistroOrigen
	 *            String
	 * 
	 */
	public DocumentoHecho(String q5codocumento, String q5hdcodigo, String q5nofile, Blob q5datafile, Integer q5sizefile,
			String q5tedesfile, String q5origen, String q5tramite, Date q5fecha, String q5indmail, String q5trmail,
			String q5contenttypefile, String q5iddocumentum, Date q5fechaaportacion, Date q5fechaentrada,
			String q5numregistroentrada, String q5idPerfilfirma, String q5estadodocumento, Date q5fechasolfirma,
			Date q5fechalimfirma, Date q5fechafirma, String q5comofirma, String q5idTipodoc, String q5destino,
			Date q5fechasollocalizador, String q5ptcodigo, String q5pcodigo, String q5hashfile,
			Date q5FechaRegistroOrigen, String q5NumRegistroOrigen) {

		this.q5codocumento = q5codocumento;
		this.q5hdcodigo = q5hdcodigo;
		this.q5nofile = q5nofile;
		this.q5datafile = q5datafile;
		this.q5sizefile = q5sizefile;
		this.q5tedesfile = q5tedesfile;
		this.q5origen = q5origen;
		this.q5tramite = q5tramite;
		this.q5fecha = q5fecha;
		this.q5indmail = q5indmail;
		this.q5trmail = q5trmail;
		this.q5contenttypefile = q5contenttypefile;
		this.q5iddocumentum = q5iddocumentum;
		this.q5fechaaportacion = q5fechaaportacion;
		this.q5fechaentrada = q5fechaentrada;
		this.q5numregistroentrada = q5numregistroentrada;
		this.q5idPerfilfirma = q5idPerfilfirma;
		this.q5estadodocumento = q5estadodocumento;
		this.q5fechasolfirma = q5fechasolfirma;
		this.q5fechalimfirma = q5fechalimfirma;
		this.q5fechafirma = q5fechafirma;
		this.q5comofirma = q5comofirma;
		this.q5idTipodoc = q5idTipodoc;
		this.q5destino = q5destino;
		this.q5fechasollocalizador = q5fechasollocalizador;
		this.q5ptcodigo = q5ptcodigo;
		this.q5pcodigo = q5pcodigo;
		this.q5hashfile = q5hashfile;
		this.q5FechaRegistroOrigen = q5FechaRegistroOrigen;
		this.q5NumRegistroOrigen = q5NumRegistroOrigen;
	}

	/**
	 * Method 'DocumentoHecho'.
	 * 
	 * @param q5codocumento
	 *            String
	 * @param q5nofile
	 *            String
	 * @param tipoDocumento
	 *            TipoDocumento
	 */
	public DocumentoHecho(String q5codocumento, String q5nofile, TipoDocumento tipoDocumento) {
		this.q5codocumento = q5codocumento;
		this.q5nofile = q5nofile;
		this.tipoDocumento = tipoDocumento;
	}

	/**
	 * Method 'getQ5codocumento'.
	 * 
	 * @return String
	 */

	public String getQ5codocumento() {
		return this.q5codocumento;
	}

	/**
	 * Method 'setQ5codocumento'.
	 * 
	 * @param q5codocumento
	 *            String
	 * @return
	 */

	public void setQ5codocumento(String q5codocumento) {
		this.q5codocumento = q5codocumento;
	}

	/**
	 * Method 'getQ5hdcodigo'.
	 * 
	 * @return String
	 */

	public String getQ5hdcodigo() {
		return this.q5hdcodigo;
	}

	/**
	 * Method 'setQ5hdcodigo'.
	 * 
	 * @param q5hdcodigo
	 *            String
	 * @return
	 */

	public void setQ5hdcodigo(String q5hdcodigo) {
		this.q5hdcodigo = q5hdcodigo;
	}

	/**
	 * Method 'getQ5nofile'.
	 * 
	 * @return String
	 */

	public String getQ5nofile() {
		return this.q5nofile;
	}

	/**
	 * Method 'setQ5nofile'.
	 * 
	 * @param q5nofile
	 *            String
	 * @return
	 */

	public void setQ5nofile(String q5nofile) {
		this.q5nofile = q5nofile;
	}

	/**
	 * Method 'getQ5datafile'.
	 * 
	 * @return Blob
	 */
	@JsonIgnore
	public Blob getQ5datafile() {
		return this.q5datafile;
	}

	/**
	 * Method 'setQ5datafile'.
	 * 
	 * @param q5datafile
	 *            Blob
	 * @return
	 */

	public void setQ5datafile(Blob q5datafile) {
		this.q5datafile = q5datafile;
	}

	/**
	 * Method 'getQ5datafileinputstream'.
	 * 
	 * @return InputStream
	 */
	@JsonIgnore
	public InputStream getQ5datafileinputstream() {
		return this.q5datafileinputstream;
	}

	/**
	 * Method 'setQ5datafileinputstream'.
	 * 
	 * @param q5datafileinputstream
	 *            Blob
	 * @return
	 */

	public void setQ5datafileinputstream(InputStream q5datafileinputstream) {
		this.q5datafileinputstream = q5datafileinputstream;
	}

	/**
	 * Method 'getQ5sizefile'.
	 * 
	 * @return Integer
	 */

	public Integer getQ5sizefile() {
		return this.q5sizefile;
	}

	/**
	 * Method 'setQ5sizefile'.
	 * 
	 * @param q5sizefile
	 *            Integer
	 * @return
	 */

	public void setQ5sizefile(Integer q5sizefile) {
		this.q5sizefile = q5sizefile;
	}

	/**
	 * Method 'getQ5tedesfile'.
	 * 
	 * @return String
	 */

	public String getQ5tedesfile() {
		return this.q5tedesfile;
	}

	/**
	 * Method 'setQ5tedesfile'.
	 * 
	 * @param q5tedesfile
	 *            String
	 * @return
	 */

	public void setQ5tedesfile(String q5tedesfile) {
		this.q5tedesfile = q5tedesfile;
	}

	/**
	 * Method 'getQ5origen'.
	 * 
	 * @return String
	 */

	public String getQ5origen() {
		return this.q5origen;
	}

	/**
	 * Method 'setQ5origen'.
	 * 
	 * @param q5origen
	 *            String
	 * @return
	 */

	public void setQ5origen(String q5origen) {
		this.q5origen = q5origen;
	}

	/**
	 * Method 'getQ5tramite'.
	 * 
	 * @return String
	 */

	public String getQ5tramite() {
		return this.q5tramite;
	}

	/**
	 * Method 'setQ5tramite'.
	 * 
	 * @param q5tramite
	 *            String
	 * @return
	 */

	public void setQ5tramite(String q5tramite) {
		this.q5tramite = q5tramite;
	}

	/**
	 * Method 'getQ5fecha'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getQ5fecha() {
		return this.q5fecha;
	}

	/**
	 * Method 'setQ5fecha'.
	 * 
	 * @param q5fecha
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setQ5fecha(Date q5fecha) {
		this.q5fecha = q5fecha;
	}

	/**
	 * Method 'getQ5indmail'.
	 * 
	 * @return String
	 */

	public String getQ5indmail() {
		return this.q5indmail;
	}

	/**
	 * Method 'setQ5indmail'.
	 * 
	 * @param q5indmail
	 *            String
	 * @return
	 */

	public void setQ5indmail(String q5indmail) {
		this.q5indmail = q5indmail;
	}

	/**
	 * Method 'getQ5trmail'.
	 * 
	 * @return String
	 */

	public String getQ5trmail() {
		return this.q5trmail;
	}

	/**
	 * Method 'setQ5trmail'.
	 * 
	 * @param q5trmail
	 *            String
	 * @return
	 */

	public void setQ5trmail(String q5trmail) {
		this.q5trmail = q5trmail;
	}

	/**
	 * Method 'getQ5contenttypefile'.
	 * 
	 * @return String
	 */

	public String getQ5contenttypefile() {
		return this.q5contenttypefile;
	}

	/**
	 * Method 'setQ5contenttypefile'.
	 * 
	 * @param q5contenttypefile
	 *            String
	 * @return
	 */

	public void setQ5contenttypefile(String q5contenttypefile) {
		this.q5contenttypefile = q5contenttypefile;
	}

	/**
	 * Method 'getQ5iddocumentum'.
	 * 
	 * @return String
	 */

	public String getQ5iddocumentum() {
		return this.q5iddocumentum;
	}

	/**
	 * Method 'setQ5iddocumentum'.
	 * 
	 * @param q5iddocumentum
	 *            String
	 * @return
	 */

	public void setQ5iddocumentum(String q5iddocumentum) {
		this.q5iddocumentum = q5iddocumentum;
	}

	/**
	 * Method 'getQ5fechaaportacion'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getQ5fechaaportacion() {
		return this.q5fechaaportacion;
	}

	/**
	 * Method 'setQ5fechaaportacion'.
	 * 
	 * @param q5fechaaportacion
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setQ5fechaaportacion(Date q5fechaaportacion) {
		this.q5fechaaportacion = q5fechaaportacion;
	}

	/**
	 * Method 'getQ5fechaentrada'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getQ5fechaentrada() {
		return this.q5fechaentrada;
	}

	/**
	 * Method 'setQ5fechaentrada'.
	 * 
	 * @param q5fechaentrada
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setQ5fechaentrada(Date q5fechaentrada) {
		this.q5fechaentrada = q5fechaentrada;
	}

	/**
	 * Method 'getQ5numregistroentrada'.
	 * 
	 * @return String
	 */

	public String getQ5numregistroentrada() {
		return this.q5numregistroentrada;
	}

	/**
	 * Method 'setQ5numregistroentrada'.
	 * 
	 * @param q5numregistroentrada
	 *            String
	 * @return
	 */

	public void setQ5numregistroentrada(String q5numregistroentrada) {
		this.q5numregistroentrada = q5numregistroentrada;
	}

	/**
	 * Method 'getQ5idPerfilfirma'.
	 * 
	 * @return String
	 */

	public String getQ5idPerfilfirma() {
		return this.q5idPerfilfirma;
	}

	/**
	 * Method 'setQ5idPerfilfirma'.
	 * 
	 * @param q5idPerfilfirma
	 *            String
	 * @return
	 */

	public void setQ5idPerfilfirma(String q5idPerfilfirma) {
		this.q5idPerfilfirma = q5idPerfilfirma;
	}

	/**
	 * Method 'getQ5estadodocumento'.
	 * 
	 * @return String
	 */

	public String getQ5estadodocumento() {
		return this.q5estadodocumento;
	}

	/**
	 * Method 'setQ5estadodocumento'.
	 * 
	 * @param q5estadodocumento
	 *            String
	 * @return
	 */

	public void setQ5estadodocumento(String q5estadodocumento) {
		this.q5estadodocumento = q5estadodocumento;
	}

	/**
	 * Method 'getQ5fechasolfirma'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getQ5fechasolfirma() {
		return this.q5fechasolfirma;
	}

	/**
	 * Method 'setQ5fechasolfirma'.
	 * 
	 * @param q5fechasolfirma
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setQ5fechasolfirma(Date q5fechasolfirma) {
		this.q5fechasolfirma = q5fechasolfirma;
	}

	/**
	 * @return the q5fechasollocalizador
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getQ5fechasollocalizador() {
		return q5fechasollocalizador;
	}

	/**
	 * @param q5fechasollocalizador
	 *            the q5fechasollocalizador to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setQ5fechasollocalizador(Date q5fechasollocalizador) {
		this.q5fechasollocalizador = q5fechasollocalizador;
	}

	/**
	 * Method 'getQ5fechalimfirma'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getQ5fechalimfirma() {
		return this.q5fechalimfirma;
	}

	/**
	 * Method 'setQ5fechalimfirma'.
	 * 
	 * @param q5fechalimfirma
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setQ5fechalimfirma(Date q5fechalimfirma) {
		this.q5fechalimfirma = q5fechalimfirma;
	}

	/**
	 * Method 'getQ5fechafirma'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getQ5fechafirma() {
		return this.q5fechafirma;
	}

	/**
	 * Method 'setQ5fechafirma'.
	 * 
	 * @param q5fechafirma
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setQ5fechafirma(Date q5fechafirma) {
		this.q5fechafirma = q5fechafirma;
	}

	/**
	 * Method 'getQ5comofirma'.
	 * 
	 * @return String
	 */

	public String getQ5comofirma() {
		return this.q5comofirma;
	}

	/**
	 * Method 'setQ5comofirma'.
	 * 
	 * @param q5comofirma
	 *            String
	 * @return
	 */

	public void setQ5comofirma(String q5comofirma) {
		this.q5comofirma = q5comofirma;
	}

	/**
	 * Method 'getQ5idTipodoc'.
	 * 
	 * @return String
	 */

	public String getQ5idTipodoc() {
		return this.q5idTipodoc;
	}

	/**
	 * Method 'setQ5idTipodoc'.
	 * 
	 * @param q5idTipodoc
	 *            String
	 * @return
	 */

	public void setQ5idTipodoc(String q5idTipodoc) {
		this.q5idTipodoc = q5idTipodoc;
	}

	/**
	 * @return the q5destino
	 */
	public String getQ5destino() {
		return q5destino;
	}

	/**
	 * @param q5destino
	 *            the q5destino to set
	 */
	public void setQ5destino(String q5destino) {
		this.q5destino = q5destino;
	}

	/**
	 * @return the q5ptcodigo
	 */
	public String getQ5ptcodigo() {
		return q5ptcodigo;
	}

	/**
	 * @param q5ptcodigo
	 *            the q5ptcodigo to set
	 */
	public void setQ5ptcodigo(String q5ptcodigo) {
		this.q5ptcodigo = q5ptcodigo;
	}

	/**
	 * @return the q5pcodigo
	 */
	public String getQ5pcodigo() {
		return q5pcodigo;
	}

	/**
	 * @param q5pcodigo
	 *            the q5pcodigo to set
	 */
	public void setQ5pcodigo(String q5pcodigo) {
		this.q5pcodigo = q5pcodigo;
	}

	/**
	 * @return the q5numExpediente
	 */
	public String getQ5numExpediente() {
		return q5numExpediente;
	}

	/**
	 * @param q5numExpediente
	 *            the q5numExpediente to set
	 */
	public void setQ5numExpediente(String q5numExpediente) {
		this.q5numExpediente = q5numExpediente;
	}

	/**
	 * @return the q5idinterviniente
	 */
	public String getQ5idinterviniente() {
		return q5idinterviniente;
	}

	/**
	 * @param q5idinterviniente
	 *            the q5idinterviniente to set
	 */
	public void setQ5idinterviniente(String q5idinterviniente) {
		this.q5idinterviniente = q5idinterviniente;
	}

	/**
	 * @return the tipoDocumento
	 */
	public TipoDocumento getTipoDocumento() {
		return tipoDocumento;
	}

	/**
	 * @param tipoDocumento
	 *            the tipoDocumento to set
	 */
	public void setTipoDocumento(TipoDocumento tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}

	/**
	 * @return the q5hashfile
	 */
	public String getQ5hashfile() {
		return q5hashfile;
	}

	/**
	 * @param q5hashfile
	 *            the q5hashfile to set
	 */
	public void setQ5hashfile(String q5hashfile) {
		this.q5hashfile = q5hashfile;
	}

	/**
	 * @return the q5NumRegistroOrigen
	 */
	public String getQ5NumRegistroOrigen() {
		return q5NumRegistroOrigen;
	}

	/**
	 * @param q5NumRegistroOrigen
	 *            the q5NumRegistroOrigen to set
	 */
	public void setQ5NumRegistroOrigen(String q5NumRegistroOrigen) {
		this.q5NumRegistroOrigen = q5NumRegistroOrigen;
	}

	/**
	 * @return the q5FechaRegistroOrigen
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getQ5FechaRegistroOrigen() {
		return q5FechaRegistroOrigen;
	}

	/**
	 * @param q5FechaRegistroOrigen
	 *            the q5FechaRegistroOrigen to set
	 */

	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setQ5FechaRegistroOrigen(Date q5FechaRegistroOrigen) {
		this.q5FechaRegistroOrigen = q5FechaRegistroOrigen;
	}

	/**
	 * @return the rutaPif
	 */
	public String getRutaPif() {
		return rutaPif;
	}

	/**
	 * @param rutaPif
	 *            the rutaPif to set
	 */
	public void setRutaPif(String rutaPif) {
		this.rutaPif = rutaPif;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "DocumentoHecho [q5codocumento=" + q5codocumento + ", q5hdcodigo=" + q5hdcodigo + ", q5nofile="
				+ q5nofile + ", q5datafile=" + q5datafile + ", q5sizefile=" + q5sizefile + ", q5tedesfile="
				+ q5tedesfile + ", q5origen=" + q5origen + ", q5tramite=" + q5tramite + ", q5fecha=" + q5fecha
				+ ", q5indmail=" + q5indmail + ", q5trmail=" + q5trmail + ", q5contenttypefile=" + q5contenttypefile
				+ ", q5iddocumentum=" + q5iddocumentum + ", q5fechaaportacion=" + q5fechaaportacion
				+ ", q5fechaentrada=" + q5fechaentrada + ", q5numregistroentrada=" + q5numregistroentrada
				+ ", q5idPerfilfirma=" + q5idPerfilfirma + ", q5estadodocumento=" + q5estadodocumento
				+ ", q5fechasolfirma=" + q5fechasolfirma + ", q5fechalimfirma=" + q5fechalimfirma + ", q5fechafirma="
				+ q5fechafirma + ", q5comofirma=" + q5comofirma + ", q5idTipodoc=" + q5idTipodoc + ", q5destino="
				+ q5destino + "]";
	}

}
