package com.ejie.y41b.model;

import java.sql.Blob;
import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateSerializer;
import com.ejie.y41b.control.Y41bJsonDateTimeDeserializer;

/**
 * * DocumentoExpediente  
 * 
 *  
 */

public class DocumentoExpediente implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String de;
	private String codocumento;
	private String idExpediente;
	private String nofile;
	private Blob datafile;
	private Integer sizefile;
	private String contenttypefile;
	private String tedesfile;
	private String origen;
	private Date fecha;
	private String iddocumentum;
	private Date fechaaportacion;
	private Date fechaentrada;
	private String numregistroentrada;
	private String incluidoTablet;

	// Tipo Documento
	private String idTipodoc;
	private String tdnombre;
	private String tdnombree;

	// Fase
	private String fcodigo;
	private String fnombre;
	private String fnombree;

	// Tramite
	private String trcodigo;
	private String trnombre;
	private String trnombree;

	// Tipo de procedimiento
	private String pcodigo;

	// S o N
	private String incluidoComunicacion;

	/**
	 * Method 'DocumentoExpediente'.
	 */
	public DocumentoExpediente() {
	}

	/**
	 * @param codocumento
	 * @param idExpediente
	 * @param nofile
	 * @param datafile
	 * @param sizefile
	 * @param contenttypefile
	 * @param tedesfile
	 * @param origen
	 * @param fecha
	 * @param iddocumentum
	 * @param fechaaportacion
	 * @param fechaentrada
	 * @param numregistroentrada
	 * @param idTipodoc
	 * @param tdnombre
	 * @param tdnombree
	 * @param fcodigo
	 * @param fnombre
	 * @param fnombree
	 * @param trcodigo
	 * @param trnombre
	 * @param trnombree
	 * @param incluidoComunicacion
	 */
	public DocumentoExpediente(String codocumento, String idExpediente, String nofile, Blob datafile, Integer sizefile,
			String contenttypefile, String tedesfile, String origen, Date fecha, String iddocumentum,
			Date fechaaportacion, Date fechaentrada, String numregistroentrada, String idTipodoc, String tdnombre,
			String tdnombree, String fcodigo, String fnombre, String fnombree, String trcodigo, String trnombre,
			String trnombree, String incluidoComunicacion, String pcodigo) {
		super();
		this.codocumento = codocumento;
		this.idExpediente = idExpediente;
		this.nofile = nofile;
		this.datafile = datafile;
		this.sizefile = sizefile;
		this.contenttypefile = contenttypefile;
		this.tedesfile = tedesfile;
		this.origen = origen;
		this.fecha = fecha;
		this.iddocumentum = iddocumentum;
		this.fechaaportacion = fechaaportacion;
		this.fechaentrada = fechaentrada;
		this.numregistroentrada = numregistroentrada;
		this.idTipodoc = idTipodoc;
		this.tdnombre = tdnombre;
		this.tdnombree = tdnombree;
		this.fcodigo = fcodigo;
		this.fnombre = fnombre;
		this.fnombree = fnombree;
		this.trcodigo = trcodigo;
		this.trnombre = trnombre;
		this.trnombree = trnombree;
		this.incluidoComunicacion = incluidoComunicacion;
		this.pcodigo = pcodigo;
	}

	/**
	 * @param de
	 * @param codocumento
	 * @param idExpediente
	 * @param nofile
	 * @param datafile
	 * @param sizefile
	 * @param contenttypefile
	 * @param tedesfile
	 * @param origen
	 * @param fecha
	 * @param iddocumentum
	 * @param fechaaportacion
	 * @param fechaentrada
	 * @param numregistroentrada
	 * @param incluidoTablet
	 * @param idTipodoc
	 * @param tdnombre
	 * @param tdnombree
	 * @param fcodigo
	 * @param fnombre
	 * @param fnombree
	 * @param trcodigo
	 * @param trnombre
	 * @param trnombree
	 * @param incluidoComunicacion
	 */
	public DocumentoExpediente(String de, String codocumento, String idExpediente, String nofile, Blob datafile,
			Integer sizefile, String contenttypefile, String tedesfile, String origen, Date fecha, String iddocumentum,
			Date fechaaportacion, Date fechaentrada, String numregistroentrada, String incluidoTablet, String idTipodoc,
			String tdnombre, String tdnombree, String fcodigo, String fnombre, String fnombree, String trcodigo,
			String trnombre, String trnombree, String incluidoComunicacion, String pcodigo) {
		super();
		this.de = de;
		this.codocumento = codocumento;
		this.idExpediente = idExpediente;
		this.nofile = nofile;
		this.datafile = datafile;
		this.sizefile = sizefile;
		this.contenttypefile = contenttypefile;
		this.tedesfile = tedesfile;
		this.origen = origen;
		this.fecha = fecha;
		this.iddocumentum = iddocumentum;
		this.fechaaportacion = fechaaportacion;
		this.fechaentrada = fechaentrada;
		this.numregistroentrada = numregistroentrada;
		this.incluidoTablet = incluidoTablet;
		this.idTipodoc = idTipodoc;
		this.tdnombre = tdnombre;
		this.tdnombree = tdnombree;
		this.fcodigo = fcodigo;
		this.fnombre = fnombre;
		this.fnombree = fnombree;
		this.trcodigo = trcodigo;
		this.trnombre = trnombre;
		this.trnombree = trnombree;
		this.incluidoComunicacion = incluidoComunicacion;
		this.pcodigo = pcodigo;
	}

	/**
	 * @param codocumento
	 * @param iddocumentum
	 */
	public DocumentoExpediente(String codocumento, String iddocumentum) {
		super();
		this.codocumento = codocumento;
		this.iddocumentum = iddocumentum;
	}

	/**
	 * @return the de
	 */
	public String getDe() {
		return de;
	}

	/**
	 * @param de
	 *            the de to set
	 */
	public void setDe(String de) {
		this.de = de;
	}

	/**
	 * @return the codocumento
	 */
	public String getCodocumento() {
		return codocumento;
	}

	/**
	 * @param codocumento
	 *            the codocumento to set
	 */
	public void setCodocumento(String codocumento) {
		this.codocumento = codocumento;
	}

	/**
	 * @return the idExpediente
	 */
	public String getIdExpediente() {
		return idExpediente;
	}

	/**
	 * @param idExpediente
	 *            the idExpediente to set
	 */
	public void setIdExpediente(String idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * @return the nofile
	 */
	public String getNofile() {
		return nofile;
	}

	/**
	 * @param nofile
	 *            the nofile to set
	 */
	public void setNofile(String nofile) {
		this.nofile = nofile;
	}

	/**
	 * @return the datafile
	 */
	@JsonIgnore
	public Blob getDatafile() {
		return datafile;
	}

	/**
	 * @param datafile
	 *            the datafile to set
	 */
	public void setDatafile(Blob datafile) {
		this.datafile = datafile;
	}

	/**
	 * @return the sizefile
	 */
	public Integer getSizefile() {
		return sizefile;
	}

	/**
	 * @param sizefile
	 *            the sizefile to set
	 */
	public void setSizefile(Integer sizefile) {
		this.sizefile = sizefile;
	}

	/**
	 * @return the contenttypefile
	 */
	public String getContenttypefile() {
		return contenttypefile;
	}

	/**
	 * @param contenttypefile
	 *            the contenttypefile to set
	 */
	public void setContenttypefile(String contenttypefile) {
		this.contenttypefile = contenttypefile;
	}

	/**
	 * @return the tedesfile
	 */
	public String getTedesfile() {
		return tedesfile;
	}

	/**
	 * @param tedesfile
	 *            the tedesfile to set
	 */
	public void setTedesfile(String tedesfile) {
		this.tedesfile = tedesfile;
	}

	/**
	 * @return the origen
	 */
	public String getOrigen() {
		return origen;
	}

	/**
	 * @param origen
	 *            the origen to set
	 */
	public void setOrigen(String origen) {
		this.origen = origen;
	}

	/**
	 * @return the fecha
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getFecha() {
		return fecha;
	}

	/**
	 * @param fecha
	 *            the fecha to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setFecha(Date fecha) {
		this.fecha = fecha;
	}

	/**
	 * @return the iddocumentum
	 */
	public String getIddocumentum() {
		return iddocumentum;
	}

	/**
	 * @param iddocumentum
	 *            the iddocumentum to set
	 */
	public void setIddocumentum(String iddocumentum) {
		this.iddocumentum = iddocumentum;
	}

	/**
	 * @return the fechaaportacion
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getFechaaportacion() {
		return fechaaportacion;
	}

	/**
	 * @param fechaaportacion
	 *            the fechaaportacion to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setFechaaportacion(Date fechaaportacion) {
		this.fechaaportacion = fechaaportacion;
	}

	/**
	 * @return the fechaentrada
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getFechaentrada() {
		return fechaentrada;
	}

	/**
	 * @param fechaentrada
	 *            the fechaentrada to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setFechaentrada(Date fechaentrada) {
		this.fechaentrada = fechaentrada;
	}

	/**
	 * @return the numregistroentrada
	 */
	public String getNumregistroentrada() {
		return numregistroentrada;
	}

	/**
	 * @param numregistroentrada
	 *            the numregistroentrada to set
	 */
	public void setNumregistroentrada(String numregistroentrada) {
		this.numregistroentrada = numregistroentrada;
	}

	/**
	 * @return the incluidoTablet
	 */
	public String getIncluidoTablet() {
		return incluidoTablet;
	}

	/**
	 * @param incluidoTablet
	 *            the incluidoTablet to set
	 */
	public void setIncluidoTablet(String incluidoTablet) {
		this.incluidoTablet = incluidoTablet;
	}

	/**
	 * @return the idTipodoc
	 */
	public String getIdTipodoc() {
		return idTipodoc;
	}

	/**
	 * @param idTipodoc
	 *            the idTipodoc to set
	 */
	public void setIdTipodoc(String idTipodoc) {
		this.idTipodoc = idTipodoc;
	}

	/**
	 * @return the tdnombre
	 */
	public String getTdnombre() {
		return tdnombre;
	}

	/**
	 * @param tdnombre
	 *            the tdnombre to set
	 */
	public void setTdnombre(String tdnombre) {
		this.tdnombre = tdnombre;
	}

	/**
	 * @return the tdnombree
	 */
	public String getTdnombree() {
		return tdnombree;
	}

	/**
	 * @param tdnombree
	 *            the tdnombree to set
	 */
	public void setTdnombree(String tdnombree) {
		this.tdnombree = tdnombree;
	}

	/**
	 * @return the incluidoComunicacion
	 */
	public String getIncluidoComunicacion() {
		return incluidoComunicacion;
	}

	/**
	 * @param incluidoComunicacion
	 *            the incluidoComunicacion to set
	 */
	public void setIncluidoComunicacion(String incluidoComunicacion) {
		this.incluidoComunicacion = incluidoComunicacion;
	}

	/**
	 * @return the fcodigo
	 */
	public String getFcodigo() {
		return fcodigo;
	}

	/**
	 * @param fcodigo
	 *            the fcodigo to set
	 */
	public void setFcodigo(String fcodigo) {
		this.fcodigo = fcodigo;
	}

	/**
	 * @return the fnombre
	 */
	public String getFnombre() {
		return fnombre;
	}

	/**
	 * @param fnombre
	 *            the fnombre to set
	 */
	public void setFnombre(String fnombre) {
		this.fnombre = fnombre;
	}

	/**
	 * @return the fnombree
	 */
	public String getFnombree() {
		return fnombree;
	}

	/**
	 * @param fnombree
	 *            the fnombree to set
	 */
	public void setFnombree(String fnombree) {
		this.fnombree = fnombree;
	}

	/**
	 * @return the trcodigo
	 */
	public String getTrcodigo() {
		return trcodigo;
	}

	/**
	 * @param trcodigo
	 *            the trcodigo to set
	 */
	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * @return the trnombre
	 */
	public String getTrnombre() {
		return trnombre;
	}

	/**
	 * @param trnombre
	 *            the trnombre to set
	 */
	public void setTrnombre(String trnombre) {
		this.trnombre = trnombre;
	}

	/**
	 * @return the trnombree
	 */
	public String getTrnombree() {
		return trnombree;
	}

	/**
	 * @param trnombree
	 *            the trnombree to set
	 */
	public void setTrnombree(String trnombree) {
		this.trnombree = trnombree;
	}

	/**
	 * @return the pcodigo
	 */
	public String getPcodigo() {
		return pcodigo;
	}

	/**
	 * @param pcodigo
	 *            the pcodigo to set
	 */
	public void setPcodigo(String pcodigo) {
		this.pcodigo = pcodigo;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "DocumentoExpediente [de=" + de + ", codocumento=" + codocumento + ", idExpediente=" + idExpediente
				+ ", nofile=" + nofile + ", datafile=" + datafile + ", sizefile=" + sizefile + ", contenttypefile="
				+ contenttypefile + ", tedesfile=" + tedesfile + ", origen=" + origen + ", fecha=" + fecha
				+ ", iddocumentum=" + iddocumentum + ", fechaaportacion=" + fechaaportacion + ", fechaentrada="
				+ fechaentrada + ", numregistroentrada=" + numregistroentrada + ", incluidoTablet=" + incluidoTablet
				+ ", idTipodoc=" + idTipodoc + ", tdnombre=" + tdnombre + ", tdnombree=" + tdnombree + ", fcodigo="
				+ fcodigo + ", fnombre=" + fnombre + ", fnombree=" + fnombree + ", trcodigo=" + trcodigo + ", trnombre="
				+ trnombre + ", trnombree=" + trnombree + ", incluidoComunicacion=" + incluidoComunicacion + "]";
	}

}
