package com.ejie.y41b.model;

import java.io.InputStream;
import java.sql.Blob;
import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateTimeDeserializer;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;

/**
 * DocEsCanalPrioritario  
 * 
 *  
 */

public class DocEsCanalPrioritario implements java.io.Serializable {

	private static long serialVersionUID = 1L;
	private String yhcodocumento;
	private String yhcif;
	private String yhnofile;
	private Blob yhdatafile;
	private InputStream yhdatafileinputstream;
	private Integer yhsizefile;
	private String yhtedesfile;
	private String yhcontenttypefile;
	private Date yhfecalta;
	private Date yhfecmodif;
	private String yhusualta;
	private String yhusumodif;

	/**
	 * Method 'DocEsCanalPrioritario'.
	 */
	public DocEsCanalPrioritario() {
	}

	/**
	 * @param thcodocumento
	 *            String
	 * @param thdatafile
	 *            Blob
	 */
	public DocEsCanalPrioritario(String yhcodocumento, Blob yhdatafile) {
		super();
		this.yhcodocumento = yhcodocumento;
		this.yhdatafile = yhdatafile;
	}

	/**
	 * @param thcodocumento
	 *            String
	 * @param thdatafile
	 *            Blob
	 */
	public DocEsCanalPrioritario(String thcodocumento, InputStream yhdatafileinputstream) {
		super();
		this.yhcodocumento = yhcodocumento;
		this.yhdatafileinputstream = yhdatafileinputstream;
	}

	/**
	 * Method 'DocEsCanalPrioritario'.
	 * 
	 * @param yhcodocumento
	 *            String
	 * @param yhcif
	 *            String
	 * @param yhnofile
	 *            String
	 * @param yhdatafile
	 *            Blob
	 * @param yhsizefile
	 *            Integer
	 * @param yhtedesfile
	 *            String
	 * @param thorigen
	 *            String
	 * @param yhcontenttypefile
	 *            String
	 * @param yhfecalta
	 *            Date
	 * @param yhfecmodif
	 *            Date
	 * @param yhusualta
	 *            String
	 * @param yhusumodif
	 *            String
	 */
	public DocEsCanalPrioritario(String yhcodocumento, String yhcif, String yhnofile, Blob yhdatafile,
			Integer yhsizefile, String yhtedesfile, String yhcontenttypefile, Date yhfecalta, Date yhfecmodif,
			String yhusualta, String yhusumodif) {

		this.yhcodocumento = yhcodocumento;
		this.yhcif = yhcif;
		this.yhnofile = yhnofile;
		this.yhdatafile = yhdatafile;
		this.yhsizefile = yhsizefile;
		this.yhtedesfile = yhtedesfile;
		this.yhcontenttypefile = yhcontenttypefile;
		this.yhfecalta = yhfecalta;
		this.yhfecmodif = yhfecmodif;
		this.yhusualta = yhusualta;
		this.yhusumodif = yhusumodif;
	}

	/**
	 * @return the serialversionuid
	 */
	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	/**
	 * @param serialversionuid
	 *            the serialversionuid to set
	 */
	public static void setSerialversionuid(long serialversionuid) {
		serialVersionUID = serialversionuid;
	}

	/**
	 * @return the yhcodocumento
	 */
	public String getYhcodocumento() {
		return yhcodocumento;
	}

	/**
	 * @param yhcodocumento
	 *            the yhcodocumento to set
	 */
	public void setYhcodocumento(String yhcodocumento) {
		this.yhcodocumento = yhcodocumento;
	}

	/**
	 * @return the yhcif
	 */
	public String getYhcif() {
		return yhcif;
	}

	/**
	 * @param yhcif
	 *            the yhcif to set
	 */
	public void setYhcif(String yhcif) {
		this.yhcif = yhcif;
	}

	/**
	 * @return the yhnofile
	 */
	public String getYhnofile() {
		return yhnofile;
	}

	/**
	 * @param yhnofile
	 *            the yhnofile to set
	 */
	public void setYhnofile(String yhnofile) {
		this.yhnofile = yhnofile;
	}

	/**
	 * @return the yhdatafile
	 */
	public Blob getYhdatafile() {
		return yhdatafile;
	}

	/**
	 * @param yhdatafile
	 *            the yhdatafile to set
	 */
	public void setYhdatafile(Blob yhdatafile) {
		this.yhdatafile = yhdatafile;
	}

	/**
	 * @return the yhdatafileinputstream
	 */
	public InputStream getYhdatafileinputstream() {
		return yhdatafileinputstream;
	}

	/**
	 * @param yhdatafileinputstream
	 *            the yhdatafileinputstream to set
	 */
	public void setYhdatafileinputstream(InputStream yhdatafileinputstream) {
		this.yhdatafileinputstream = yhdatafileinputstream;
	}

	/**
	 * @return the yhsizefile
	 */
	public Integer getYhsizefile() {
		return yhsizefile;
	}

	/**
	 * @param yhsizefile
	 *            the yhsizefile to set
	 */
	public void setYhsizefile(Integer yhsizefile) {
		this.yhsizefile = yhsizefile;
	}

	/**
	 * @return the yhtedesfile
	 */
	public String getYhtedesfile() {
		return yhtedesfile;
	}

	/**
	 * @param yhtedesfile
	 *            the yhtedesfile to set
	 */
	public void setYhtedesfile(String yhtedesfile) {
		this.yhtedesfile = yhtedesfile;
	}

	/**
	 * @return the yhcontenttypefile
	 */
	public String getYhcontenttypefile() {
		return yhcontenttypefile;
	}

	/**
	 * @param yhcontenttypefile
	 *            the yhcontenttypefile to set
	 */
	public void setYhcontenttypefile(String yhcontenttypefile) {
		this.yhcontenttypefile = yhcontenttypefile;
	}

	/**
	 * @return the yhfecalta
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getYhfecalta() {
		return yhfecalta;
	}

	/**
	 * @param yhfecalta
	 *            the yhfecalta to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setYhfecalta(Date yhfecalta) {
		this.yhfecalta = yhfecalta;
	}

	/**
	 * @return the yhfecmodif
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getYhfecmodif() {
		return yhfecmodif;
	}

	/**
	 * @param yhfecmodif
	 *            the yhfecmodif to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setYhfecmodif(Date yhfecmodif) {
		this.yhfecmodif = yhfecmodif;
	}

	/**
	 * @return the yhusualta
	 */
	public String getYhusualta() {
		return yhusualta;
	}

	/**
	 * @param yhusualta
	 *            the yhusualta to set
	 */
	public void setYhusualta(String yhusualta) {
		this.yhusualta = yhusualta;
	}

	/**
	 * @return the yhusumodif
	 */
	public String getYhusumodif() {
		return yhusumodif;
	}

	/**
	 * @param yhusumodif
	 *            the yhusumodif to set
	 */
	public void setYhusumodif(String yhusumodif) {
		this.yhusumodif = yhusumodif;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Adjuntardocs [yhcodocumento=" + yhcodocumento + ", yhcif=" + yhcif + ", yhnofile=" + yhnofile
				+ ", yhdatafile=" + yhdatafile + ", yhsizefile=" + yhsizefile + ", yhtedesfile=" + yhtedesfile
				+ ", yhcontenttypefile=" + yhcontenttypefile + ", yhfecalta=" + yhfecalta + ", yhfecmodif=" + yhfecmodif
				+ ", yhusualta=" + yhusualta + ", yhusumodif=" + yhusumodif + "]";
	}

}
