package com.ejie.y41b.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;

/**
 * Distribuidor  
 * 
 *  
 */

public class Distribuidor implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String rdcodigo;
	private Alerta alerta;
	private String rdcoes;
	private String rdfabricante;
	private String rdidinterviniente;
	private List<AlertaProgramacion> alertaProgramacions = new ArrayList<AlertaProgramacion>();
	private Intervinientes interviniente;

	/**
	 * Method 'Distribuidor'.
	 */
	public Distribuidor() {
	}

	/**
	 * Method 'Distribuidor'.
	 * 
	 * @param rdcodigo
	 *            String
	 * @param rdcoes
	 *            String
	 * @param rdfabricante
	 *            String
	 * @param rdidinterviniente
	 *            String
	 * @param alerta
	 *            Alerta
	 */
	public Distribuidor(String rdcodigo, String rdcoes, String rdfabricante,
			String rdidinterviniente, Alerta alerta) {
		this.rdcodigo = rdcodigo;
		this.alerta = alerta;
		this.rdcoes = rdcoes;
		this.rdfabricante = rdfabricante;
		this.rdidinterviniente = rdidinterviniente;
	}

	/**
	 * Method 'Distribuidor'.
	 * 
	 * @param rdcodigo
	 *            String
	 * @param rdcoes
	 *            String
	 * @param rdfabricante
	 *            String
	 * @param rdidinterviniente
	 *            String
	 * @param alerta
	 *            Alerta
	 */
	public Distribuidor(String rdcodigo, String rdcoes, String rdfabricante,
			String rdidinterviniente, Alerta alerta,
			Intervinientes interviniente) {
		this.rdcodigo = rdcodigo;
		this.alerta = alerta;
		this.rdcoes = rdcoes;
		this.rdfabricante = rdfabricante;
		this.rdidinterviniente = rdidinterviniente;
		this.interviniente = interviniente;
	}

	/**
	 * Method 'Distribuidor'.
	 * 
	 * @param rdcodigo
	 *            String
	 * @param rdcoes
	 *            String
	 * @param rdfabricante
	 *            String
	 * @param rdidinterviniente
	 *            String
	 * @param alerta
	 *            Alerta
	 * @param alertaProgramacions
	 *            List<AlertaProgramacion>
	 */
	public Distribuidor(String rdcodigo, String rdcoes, String rdfabricante,
			String rdidinterviniente, Alerta alerta,
			List<AlertaProgramacion> alertaProgramacions) {

		this.rdcodigo = rdcodigo;
		this.alerta = alerta;
		this.rdcoes = rdcoes;
		this.rdfabricante = rdfabricante;
		this.rdidinterviniente = rdidinterviniente;
		this.alertaProgramacions = alertaProgramacions;
	}

	/**
	 * Method 'getRdcodigo'.
	 * 
	 * @return String
	 */

	public String getRdcodigo() {
		return this.rdcodigo;
	}

	/**
	 * Method 'setRdcodigo'.
	 * 
	 * @param rdcodigo
	 *            String
	 * @return
	 */

	public void setRdcodigo(String rdcodigo) {
		this.rdcodigo = rdcodigo;
	}

	/**
	 * Method 'getAlerta'.
	 * 
	 * @return Alerta
	 */
	@JsonIgnore
	public Alerta getAlerta() {
		return this.alerta;
	}

	/**
	 * Method 'setAlerta'.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */

	public void setAlerta(Alerta alerta) {
		this.alerta = alerta;
	}

	/**
	 * Method 'getRdcoes'.
	 * 
	 * @return String
	 */

	public String getRdcoes() {
		return this.rdcoes;
	}

	/**
	 * Method 'setRdcoes'.
	 * 
	 * @param rdcoes
	 *            String
	 * @return
	 */

	public void setRdcoes(String rdcoes) {
		this.rdcoes = rdcoes;
	}

	/**
	 * Method 'getRdfabricante'.
	 * 
	 * @return String
	 */

	public String getRdfabricante() {
		return this.rdfabricante;
	}

	/**
	 * Method 'setRdfabricante'.
	 * 
	 * @param rdfabricante
	 *            String
	 * @return
	 */

	public void setRdfabricante(String rdfabricante) {
		this.rdfabricante = rdfabricante;
	}

	/**
	 * Method 'getRdidinterviniente'.
	 * 
	 * @return String
	 */

	public String getRdidinterviniente() {
		return this.rdidinterviniente;
	}

	/**
	 * Method 'setRdidinterviniente'.
	 * 
	 * @param rdidinterviniente
	 *            String
	 * @return
	 */

	public void setRdidinterviniente(String rdidinterviniente) {
		this.rdidinterviniente = rdidinterviniente;
	}

	/**
	 * Method 'getAlertaProgramacions'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<AlertaProgramacion> getAlertaProgramacions() {
		return this.alertaProgramacions;
	}

	/**
	 * Method 'setAlertaProgramacions'.
	 * 
	 * @param alertaProgramacions
	 *            List
	 * @return
	 */
	public void setAlertaProgramacions(
			List<AlertaProgramacion> alertaProgramacions) {
		this.alertaProgramacions = alertaProgramacions;
	}

	/**
	 * @return the interviniente
	 */
	public Intervinientes getInterviniente() {
		return interviniente;
	}

	/**
	 * @param interviniente
	 *            the interviniente to set
	 */
	public void setInterviniente(Intervinientes interviniente) {
		this.interviniente = interviniente;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ rdcodigo: ").append(this.rdcodigo).append(" ]");
		result.append(", [ rdcoes: ").append(this.rdcoes).append(" ]");
		result.append(", [ rdfabricante: ").append(this.rdfabricante)
				.append(" ]");
		result.append(", [ rdidinterviniente: ").append(this.rdidinterviniente)
				.append(" ]");
		result.append("}");
		return result.toString();
	}

}
