package com.ejie.y41b.model;


import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 *  * DenunciaRecib  
 *  
 */

public class DenunciaRecib  implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
            private String s6codigo;
            private HechoDenunciado hechoDenunciado;
            private String s6codorganismo;
            private Date s6feccomunicacion;
            private Date s6fecfinalizacion;
            private Integer s6cantidadactuaciones;
            private List<Actuacion> actuacions = new ArrayList<Actuacion>();

	/** Method 'DenunciaRecib'.
	*
	*/
    public DenunciaRecib() {
    }
    /** Method 'DenunciaRecib'.
    * @param s6codigo String
    * @param s6codorganismo String
    * @param s6feccomunicacion Date
    * @param s6fecfinalizacion Date
    * @param s6cantidadactuaciones Integer
    * @param hechoDenunciado HechoDenunciado
    */
    public DenunciaRecib(String s6codigo, String s6codorganismo, Date s6feccomunicacion, Date s6fecfinalizacion, Integer s6cantidadactuaciones , HechoDenunciado hechoDenunciado) {	
        this.s6codigo = s6codigo;
        this.hechoDenunciado = hechoDenunciado;
        this.s6codorganismo = s6codorganismo;
        this.s6feccomunicacion = s6feccomunicacion;
        this.s6fecfinalizacion = s6fecfinalizacion;
        this.s6cantidadactuaciones = s6cantidadactuaciones;
    }

    /** Method 'DenunciaRecib'.
    * @param s6codigo String
    * @param s6codorganismo String
    * @param s6feccomunicacion Date
    * @param s6fecfinalizacion Date
    * @param s6cantidadactuaciones Integer
    * @param hechoDenunciado HechoDenunciado
    * @param actuacions List<Actuacion>
    */
   public DenunciaRecib(String s6codigo, String s6codorganismo, Date s6feccomunicacion, Date s6fecfinalizacion, Integer s6cantidadactuaciones, HechoDenunciado hechoDenunciado, List<Actuacion> actuacions) {	

           this.s6codigo = s6codigo;
           this.hechoDenunciado = hechoDenunciado;
           this.s6codorganismo = s6codorganismo;
           this.s6feccomunicacion = s6feccomunicacion;
           this.s6fecfinalizacion = s6fecfinalizacion;
           this.s6cantidadactuaciones = s6cantidadactuaciones;
           this.actuacions = actuacions;
    }

    /**
	 * Method 'getS6codigo'.
	 *
	 * @return String
	 */
	
	
	public String getS6codigo() {
		return this.s6codigo;
	}

	/**
	 * Method 'setS6codigo'.
	 *
	 * @param s6codigo String
	 * @return
     */
	
	public void setS6codigo(String s6codigo) {
		this.s6codigo = s6codigo;
	}
    /**
	 * Method 'getHechoDenunciado'.
	 *
	 * @return HechoDenunciado
	 */
	@JsonIgnore
	
	public HechoDenunciado getHechoDenunciado() {
		return this.hechoDenunciado;
	}

	/**
	 * Method 'setHechoDenunciado'.
	 *
	 * @param hechoDenunciado HechoDenunciado
	 * @return
     */
	
	public void setHechoDenunciado(HechoDenunciado hechoDenunciado) {
		this.hechoDenunciado = hechoDenunciado;
	}
    /**
	 * Method 'getS6codorganismo'.
	 *
	 * @return String
	 */
	
	
	public String getS6codorganismo() {
		return this.s6codorganismo;
	}

	/**
	 * Method 'setS6codorganismo'.
	 *
	 * @param s6codorganismo String
	 * @return
     */
	
	public void setS6codorganismo(String s6codorganismo) {
		this.s6codorganismo = s6codorganismo;
	}
    /**
	 * Method 'getS6feccomunicacion'.
	 *
	 * @return Date
	 */
	
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getS6feccomunicacion() {
		return this.s6feccomunicacion;
	}

	/**
	 * Method 'setS6feccomunicacion'.
	 *
	 * @param s6feccomunicacion Date
	 * @return
     */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setS6feccomunicacion(Date s6feccomunicacion) {
		this.s6feccomunicacion = s6feccomunicacion;
	}
    /**
	 * Method 'getS6fecfinalizacion'.
	 *
	 * @return Date
	 */
	
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getS6fecfinalizacion() {
		return this.s6fecfinalizacion;
	}

	/**
	 * Method 'setS6fecfinalizacion'.
	 *
	 * @param s6fecfinalizacion Date
	 * @return
     */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setS6fecfinalizacion(Date s6fecfinalizacion) {
		this.s6fecfinalizacion = s6fecfinalizacion;
	}
    /**
	 * Method 'getS6cantidadactuaciones'.
	 *
	 * @return Integer
	 */
	
	
	public Integer getS6cantidadactuaciones() {
		return this.s6cantidadactuaciones;
	}

	/**
	 * Method 'setS6cantidadactuaciones'.
	 *
	 * @param s6cantidadactuaciones Integer
	 * @return
     */
	
	public void setS6cantidadactuaciones(Integer s6cantidadactuaciones) {
		this.s6cantidadactuaciones = s6cantidadactuaciones;
	}
	/**
	 * Method 'getActuacions'.
	 *
	 * @return List
	 */
	@JsonIgnore
	public List<Actuacion> getActuacions() {
		return this.actuacions;
	}
	
	/**
	 * Method 'setActuacions'.
	 *
	 * @param actuacions List
	 * @return
	 */
	public void setActuacions(List<Actuacion> actuacions) {
		this.actuacions = actuacions;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { " ); 
		result.append(" [ s6codigo: ").append(this.s6codigo).append(" ]");
		result.append(", [ s6codorganismo: ").append(this.s6codorganismo).append(" ]");
		result.append(", [ s6feccomunicacion: ").append(this.s6feccomunicacion).append(" ]");
		result.append(", [ s6fecfinalizacion: ").append(this.s6fecfinalizacion).append(" ]");
		result.append(", [ s6cantidadactuaciones: ").append(this.s6cantidadactuaciones).append(" ]");
		result.append("}");
		return result.toString();
	}


}

