package com.ejie.y41b.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;

/**
 * * Decision  
 * 
 *  
 */

public class Decision implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String decodigo;
	@NotEmpty(message = "required.decision")
	@NotNull()
	@Length(max = 50, message = "lenght.decision")
	private String denombre;
	@NotEmpty(message = "required.decisione")
	@NotNull()
	@Length(max = 50, message = "lenght.decision")
	private String denombree;
	private String demediacion;
	private Date debaja;

	private String pcodigo;
	private String pnombre;
	private String pnombree;

	private String detiposolicitud;
	private List<PlantillaDecision> plantillaDecisions = new ArrayList<PlantillaDecision>();

	/**
	 * Method 'Decision'.
	 * 
	 */
	public Decision() {
	}

	/**
	 * Method 'Decision'.
	 * 
	 * @param decodigo
	 *            String
	 * @param denombre
	 *            String
	 * @param denombree
	 *            String
	 * @param demediacion
	 *            String
	 * @param debaja
	 *            Date
	 * @param pcodigo
	 *            String
	 * @param detiposolicitud
	 *            String
	 */
	public Decision(String decodigo, String denombre, String denombree,
			String demediacion, Date debaja, String pcodigo,
			String detiposolicitud) {
		this.decodigo = decodigo;
		this.denombre = denombre;
		this.denombree = denombree;
		this.demediacion = demediacion;
		this.debaja = debaja;
		this.pcodigo = pcodigo;
		this.detiposolicitud = detiposolicitud;
	}

	/**
	 * @param decodigo
	 * @param denombre
	 * @param denombree
	 * @param demediacion
	 * @param debaja
	 * @param pcodigo
	 * @param pnombre
	 * @param pnombree
	 * @param detiposolicitud
	 */
	public Decision(String decodigo, String denombre, String denombree,
			String demediacion, Date debaja, String pcodigo, String pnombre,
			String pnombree, String detiposolicitud) {
		super();
		this.decodigo = decodigo;
		this.denombre = denombre;
		this.denombree = denombree;
		this.demediacion = demediacion;
		this.debaja = debaja;
		this.pcodigo = pcodigo;
		this.pnombre = pnombre;
		this.pnombree = pnombree;
		this.detiposolicitud = detiposolicitud;
	}

	/**
	 * Method 'Decision'.
	 * 
	 * @param decodigo
	 *            String
	 * @param denombre
	 *            String
	 * @param denombree
	 *            String
	 * @param demediacion
	 *            String
	 * @param debaja
	 *            Date
	 * @param pcodigo
	 *            String
	 * @param detiposolicitud
	 *            String
	 * @param plantillaDecisions
	 *            List<PlantillaDecision>
	 */
	public Decision(String decodigo, String denombre, String denombree,
			String demediacion, Date debaja, String pcodigo,
			String detiposolicitud, List<PlantillaDecision> plantillaDecisions) {

		this.decodigo = decodigo;
		this.denombre = denombre;
		this.denombree = denombree;
		this.demediacion = demediacion;
		this.debaja = debaja;
		this.pcodigo = pcodigo;
		this.detiposolicitud = detiposolicitud;
		this.plantillaDecisions = plantillaDecisions;
	}

	/**
	 * Method 'getDecodigo'.
	 * 
	 * @return String
	 */

	public String getDecodigo() {
		return this.decodigo;
	}

	/**
	 * Method 'setDecodigo'.
	 * 
	 * @param decodigo
	 *            String
	 * @return
	 */

	public void setDecodigo(String decodigo) {
		this.decodigo = decodigo;
	}

	/**
	 * Method 'getDenombre'.
	 * 
	 * @return String
	 */

	public String getDenombre() {
		return this.denombre;
	}

	/**
	 * Method 'setDenombre'.
	 * 
	 * @param denombre
	 *            String
	 * @return
	 */

	public void setDenombre(String denombre) {
		this.denombre = denombre;
	}

	/**
	 * Method 'getDenombree'.
	 * 
	 * @return String
	 */

	public String getDenombree() {
		return this.denombree;
	}

	/**
	 * Method 'setDenombree'.
	 * 
	 * @param denombree
	 *            String
	 * @return
	 */

	public void setDenombree(String denombree) {
		this.denombree = denombree;
	}

	/**
	 * Method 'getDebaja'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getDebaja() {
		return this.debaja;
	}

	/**
	 * Method 'setDebaja'.
	 * 
	 * @param debaja
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setDebaja(Date debaja) {
		this.debaja = debaja;
	}

	/**
	 * Method 'getPlantillaDecisions'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<PlantillaDecision> getPlantillaDecisions() {
		return this.plantillaDecisions;
	}

	/**
	 * Method 'setPlantillaDecisions'.
	 * 
	 * @param plantillaDecisions
	 *            List
	 * @return
	 */
	public void setPlantillaDecisions(List<PlantillaDecision> plantillaDecisions) {
		this.plantillaDecisions = plantillaDecisions;
	}

	/**
	 * @return the pcodigo
	 */
	public String getPcodigo() {
		return pcodigo;
	}

	/**
	 * @param pcodigo
	 *            the pcodigo to set
	 */
	public void setPcodigo(String pcodigo) {
		this.pcodigo = pcodigo;
	}

	/**
	 * @return the detiposolicitud
	 */
	public String getDetiposolicitud() {
		return detiposolicitud;
	}

	/**
	 * @param detiposolicitud
	 *            the detiposolicitud to set
	 */
	public void setDetiposolicitud(String detiposolicitud) {
		this.detiposolicitud = detiposolicitud;
	}

	/**
	 * @return the pnombre
	 */
	public String getPnombre() {
		return pnombre;
	}

	/**
	 * @param pnombre
	 *            the pnombre to set
	 */
	public void setPnombre(String pnombre) {
		this.pnombre = pnombre;
	}

	/**
	 * @return the pnombree
	 */
	public String getPnombree() {
		return pnombree;
	}

	/**
	 * @param pnombree
	 *            the pnombree to set
	 */
	public void setPnombree(String pnombree) {
		this.pnombree = pnombree;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Decision [decodigo=" + decodigo + ", denombre=" + denombre
				+ ", denombree=" + denombree + ", debaja=" + debaja
				+ ", pcodigo=" + pcodigo + ", detiposolicitud="
				+ detiposolicitud + ", plantillaDecisions="
				+ plantillaDecisions + "]";
	}

	public void setDemediacion(String demediacion) {
		this.demediacion = demediacion;
	}

	public String getDemediacion() {
		return demediacion;
	}
}
