package com.ejie.y41b.model;

import java.util.Date;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.springframework.format.annotation.NumberFormat;
import org.springframework.format.annotation.NumberFormat.Style;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;

/**
 * * Consulta  
 * 
 *  
 */

public class ConsultaRespuestaEmail implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// @Length(max = 20, message = "lenght.cocodigo")
	// @NotEmpty(message = "required.cocodigo")
	// @NotNull()
	private String cocodigo;
	@NotNull(message = "required.cofecha")
	private Date cofecha;
	@Length(max = 6, message = "lenght.codOrg")
	private String codOrg;
	@Digits(integer = 6, fraction = 0, message = "lenght.conrreg")
	@NumberFormat(style = Style.NUMBER)
	private Integer conrreg;
	@Digits(integer = 4, fraction = 0, message = "lenght.conranrg")
	@NumberFormat(style = Style.NUMBER)
	private Long conranrg;
	@Length(max = 4000, message = "lenght.cotexto")
	private String cotexto;
	@Email
	@Length(max = 50, message = "lenght.cocoemco")
	private String cocoemco;
	@NotNull(message = "required.p9feresp")
	private Date p9feresp;
	private String p9teres;

	/**
	 * Method 'Consulta'.
	 * 
	 */
	public ConsultaRespuestaEmail() {
	}

	/**
	 * @param cocodigo
	 * @param cofecha
	 * @param codOrg
	 * @param conrreg
	 * @param conranrg
	 * @param cocoemco
	 * @param cotexto
	 */
	public ConsultaRespuestaEmail(String cocodigo, String codOrg, Date cofecha,
			String cotexto, Integer conrreg, String cocoemco, Long conranrg) {
		super();
		this.cocodigo = cocodigo;
		this.codOrg = codOrg;
		this.cofecha = cofecha;
		this.cotexto = cotexto;
		this.conrreg = conrreg;
		this.cocoemco = cocoemco;
		this.conranrg = conranrg;
	}

	/**
	 * @return the cocodigo
	 */
	public String getCocodigo() {
		return cocodigo;
	}

	/**
	 * @param cocodigo
	 *            the cocodigo to set
	 */
	public void setCocodigo(String cocodigo) {
		this.cocodigo = cocodigo;
	}

	/**
	 * @return the codOrg
	 */
	public String getCodOrg() {
		return codOrg;
	}

	/**
	 * @param codOrg
	 *            the codOrg to set
	 */
	public void setCodOrg(String codOrg) {
		this.codOrg = codOrg;
	}

	/**
	 * @return the cofecha
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getCofecha() {
		return cofecha;
	}

	/**
	 * @param cofecha
	 *            the cofecha to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setCofecha(Date cofecha) {
		this.cofecha = cofecha;
	}

	/**
	 * @return the cotexto
	 */
	public String getCotexto() {
		return cotexto;
	}

	/**
	 * @param cotexto
	 *            the cotexto to set
	 */
	public void setCotexto(String cotexto) {
		this.cotexto = cotexto;
	}

	/**
	 * @return the conrreg
	 */
	public Integer getConrreg() {
		return conrreg;
	}

	/**
	 * @param conrreg
	 *            the conrreg to set
	 */
	public void setConrreg(Integer conrreg) {
		this.conrreg = conrreg;
	}

	/**
	 * @return the cocoemco
	 */
	public String getCocoemco() {
		return cocoemco;
	}

	/**
	 * @param cocoemco
	 *            the cocoemco to set
	 */
	public void setCocoemco(String cocoemco) {
		this.cocoemco = cocoemco;
	}

	/**
	 * @return the conranrg
	 */
	public Long getConranrg() {
		return conranrg;
	}

	/**
	 * @param conranrg
	 *            the conranrg to set
	 */
	public void setConranrg(Long conranrg) {
		this.conranrg = conranrg;
	}

	/**
	 * @return the p9feresp
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getP9feresp() {
		return p9feresp;
	}

	/**
	 * @param p9feresp
	 *            the p9feresp to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setP9feresp(Date p9feresp) {
		this.p9feresp = p9feresp;
	}

	/**
	 * @return the p9teres
	 */
	public String getP9teres() {
		return p9teres;
	}

	/**
	 * @param p9teres
	 *            the p9teres to set
	 */
	public void setP9teres(String p9teres) {
		this.p9teres = p9teres;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ cocodigo: ").append(this.cocodigo).append(" ]");
		result.append(", [ cofecha: ").append(this.cofecha).append(" ]");
		result.append(", [ cotexto: ").append(this.cotexto).append(" ]");
		result.append(", [ conrreg: ").append(this.conrreg).append(" ]");
		result.append(", [ cocoemco: ").append(this.cocoemco).append(" ]");
		result.append(", [ conranrg: ").append(this.conranrg).append(" ]");
		result.append("}");
		return result.toString();
	}

}
