package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.Date;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.format.annotation.NumberFormat;
import org.springframework.format.annotation.NumberFormat.Style;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;
import com.ejie.y41b.control.Y41bJsonDateTimeDeserializer;
import com.ejie.y41b.validation.Y41bCif;
import com.ejie.y41b.validation.Y41bNifNieCif;

/**
 * * Consulta  
 * 
 *  
 */

public class ConsultaDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private String cocodigo;
	@Length(max = 20, message = "error08.lenght.tircodigo")
	private String tircodigo;
	@Length(max = 100, message = "lenght.tirnombre")
	private String tirnombre;
	@Length(max = 20, message = "error05.lenght.pscodigo")
	private String pscodigo;
	@Length(max = 260, message = "error06.lenght.psnombre")
	private String psnombre;
	@Length(max = 110, message = "error07.lenght.psnombree")
	private String psnombree;
	@Length(max = 2, message = "error11.lenght.rancod")
	private String rancod;
	@Length(max = 10, message = "error12.lenght.randesc")
	private String randesc;
	@NotEmpty(message = "error03.required.tfpcodigo")
	@NotNull()
	@Length(max = 1, message = "error03.lenght.tfpcodigo")
	private String tfpcodigo;
	@Length(max = 30, message = "lenght.tfpnombre")
	private String tfpnombre;
	@Length(max = 30, message = "lenght.tfpnombree")
	private String tfpnombree;
	// Organismo
	@Length(max = 6, message = "lenght.codOrg")
	private String codOrg;
	private String orgnombreEs;
	private String orgnombreEu;

	private String orgtelefono;
	private String orgfax;
	private String orgemail;
	private String orgurl;
	private String orgnoraPaisId;
	private String orgnombrePais;
	private String orgnoraProvinciaId;
	private String orgnombreProvincia;
	private String orgnoraMunicipioId;
	private String orgnombreMunicipio;
	private String orgnoraLocalidadId;
	private String orgnombreLocalidad;
	private String orgnoraCalleId;
	private String orgnombreCalle;
	private String orgnoraCpId;
	private String orgnombreCp;
	private String orgnoraPortalId;
	private String orgnombrePortal;

	@NotEmpty(message = "error02.required.mocodigo")
	@NotNull()
	@Length(max = 3, message = "error02.lenght.mocodigo")
	private String mocodigo;
	private String monombre;
	@NotNull(message = "error01.required.cofecha")
	private Date cofecha;
	@Length(max = 1, message = "error13.lenght.cocosx")
	private String cocosx;
	@Length(max = 3, message = "lenght.conran")
	private String conran;
	@Length(max = 7, message = "lenght.cocose")
	private String cocose;
	@Length(max = 4000, message = "error04.lenght.cotexto")
	private String cotexto;
	@Digits(integer = 6, fraction = 0, message = "lenght.conrreg")
	@NumberFormat(style = Style.NUMBER)
	private Integer conrreg;
	@Length(max = 50, message = "error10.lenght.conoco")
	private String conoco;
	@Length(max = 50, message = "lenght.conodirco")
	private String conodirco;
	@Length(max = 5, message = "lenght.conrcpco")
	private String conrcpco;
	@Length(max = 20, message = "lenght.cocoloco")
	private String cocoloco;
	@Length(max = 40, message = "lenght.conoloco")
	private String conoloco;
	@Length(max = 50, message = "lenght.conomuco")
	private String conomuco;
	@Length(max = 2, message = "lenght.cocopvco")
	private String cocopvco;
	@Length(max = 3, message = "lenght.cocopaco")
	private String cocopaco;
	// @Y41bTelefono(message = "validacion.telefono1")
	@Length(max = 15, message = "error15.lenght.conrtelco")
	private String conrtelco;
	// @Y41bTelefono(message = "error16.validacion.telefono2")
	@Length(max = 15, message = "error16.lenght.conrfaxco")
	private String conrfaxco;
	@Email(message = "required.email")
	@Length(max = 50, message = "error14.lenght.cocoemco")
	private String cocoemco;
	private Date coferes;
	@Length(max = 1, message = "lenght.coinreenv")
	private String coinreenv;
	@Length(max = 1000, message = "lenght.coteresp")
	private String coteresp;
	@Length(max = 1, message = "lenght.cocotfpr")
	private String cocotfpr;
	@Length(max = 1, message = "lenght.coinl37")
	private String coinl37;
	@Digits(integer = 4, fraction = 0, message = "lenght.conranrg")
	@NumberFormat(style = Style.NUMBER)
	private Long conranrg;
	@Length(max = 6, message = "lenght.cocopro")
	private String cocopro;
	@Length(max = 20, message = "lenght.cohdcodigo")
	private String cohdcodigo;

	private String cohora;

	private Date cofechaconsumidor;
	private String cofechaconshora;
	@Length(max = 40, message = "lenght.noraPaisId")
	private String noraPaisId;
	@Length(max = 40, message = "lenght.nombrePais")
	private String nombrePais;
	// @NotEmpty(message = "error18.required.provinciaId")
	// @NotNull()
	// @Length(max = 40, message = "error18.lenght.provinciaId")
	private String provinciaId;
	// @Length(max = 255, message = "error19.lenght.nombreProvincia")
	private String nombreProvincia;
	// @NotEmpty(message = "error20.required.municipioId")
	// @NotNull()
	// @Length(max = 40, message = "error20.lenght.municipioId")
	private String municipioId;
	// @Length(max = 255, message = "error21.lenght.nombreMunicipio")
	private String nombreMunicipio;
	// @NotEmpty(message = "required.localidadId")
	// @NotNull()
	@Length(max = 40, message = "error22.lenght.localidadId")
	private String localidadId;
	@Length(max = 255, message = "error23.lenght.nombreLocalidad")
	private String nombreLocalidad;
	@Length(max = 40, message = "error24.lenght.calleId")
	private String calleId;
	@Length(max = 255, message = "error24.lenght.nombreCalle")
	private String calleId_label;
	@Length(max = 40, message = "error25.lenght.cpId")
	private String cpId;
	@Length(max = 40, message = "error17.lenght.nombreCp")
	private String nombreCp;
	@Length(max = 40, message = "lenght.portalId")
	private String portalId;
	@Length(max = 255, message = "lenght.nombrePortal")
	private String nombrePortal;
	@Length(max = 1, message = "lenght.coinl21")
	private String coinl21;
	@Length(max = 1, message = "lenght.cosituacion")
	private String cosituacion;
	@Length(max = 40, message = "lenght.nombrePiso")
	private String nombrePiso;
	private String direccion_nocapv;
	@Length(max = 20, message = "lenght.p9codigo")
	private String p9codigo;
	@Length(max = 5, message = "error09.lenght.p8codigo")
	private String p8codigo;
	@Length(max = 150, message = "lenght.p8nombre")
	private String p8nombre;
	@Length(max = 150, message = "lenght.p8nombree")
	private String p8nombree;
	private Date p9feanot;
	@Length(max = 1, message = "lenght.p9inemlusu")
	private String p9inemlusu;
	private Date p9feresp;

	private String p9teres;
	@NumberFormat(style = Style.NUMBER)
	private BigDecimal p9nufiladj;

	private String direccionAntiguaCompleta;

	private String llegadaHoras;
	private String llegadaMinutos;
	private String atencionHoras;
	private String atencionMinutos;
	private String coextranjero;

	// Consultas empresas
	private String coconsultaaaccempresas;

	@Y41bNifNieCif(groups = Y41bCifChecks.class, message = "error03.required.cif")
	private String cocif;
	private String corazonsocial;
	private String conombrecomercial;

	/**
	 * Method 'Consulta'.
	 * 
	 */
	public ConsultaDetalle() {
	}

	/**
	 * @param cocodigo
	 * @param tircodigo
	 * @param tirnombre
	 * @param pscodigo
	 * @param psnombre
	 * @param psnombree
	 * @param rancod
	 * @param randesc
	 * @param tfpcodigo
	 * @param tfpnombre
	 * @param tfpnombree
	 * @param codOrg
	 * @param orgnombreEs
	 * @param orgnombreEu
	 * @param orgtelefono
	 * @param orgfax
	 * @param orgemail
	 * @param orgurl
	 * @param orgnoraPaisId
	 * @param orgnombrePais
	 * @param orgnoraProvinciaId
	 * @param orgnombreProvincia
	 * @param orgnoraMunicipioId
	 * @param orgnombreMunicipio
	 * @param orgnoraLocalidadId
	 * @param orgnombreLocalidad
	 * @param orgnoraCalleId
	 * @param orgnombreCalle
	 * @param orgnoraCpId
	 * @param orgnombreCp
	 * @param orgnoraPortalId
	 * @param orgnombrePortal
	 * @param mocodigo
	 * @param monombre
	 * @param cofecha
	 * @param cocosx
	 * @param conran
	 * @param cocose
	 * @param cotexto
	 * @param conrreg
	 * @param conoco
	 * @param conodirco
	 * @param conrcpco
	 * @param cocoloco
	 * @param conoloco
	 * @param conomuco
	 * @param cocopvco
	 * @param cocopaco
	 * @param conrtelco
	 * @param conrfaxco
	 * @param cocoemco
	 * @param coferes
	 * @param coinreenv
	 * @param coteresp
	 * @param cocotfpr
	 * @param coinl37
	 * @param conranrg
	 * @param cocopro
	 * @param cohdcodigo
	 * @param cohora
	 * @param cofechaconsumidor
	 * @param cofechaconshora
	 * @param noraPaisId
	 * @param nombrePais
	 * @param provinciaId
	 * @param nombreProvincia
	 * @param municipioId
	 * @param nombreMunicipio
	 * @param localidadId
	 * @param nombreLocalidad
	 * @param calleId
	 * @param calleId_label
	 * @param cpId
	 * @param nombreCp
	 * @param portalId
	 * @param nombrePortal
	 * @param coinl21
	 * @param cosituacion
	 * @param nombrePiso
	 * @param direccion_nocapv
	 * @param p9codigo
	 * @param p8codigo
	 * @param p8nombre
	 * @param p8nombree
	 * @param p9feanot
	 * @param p9inemlusu
	 * @param p9feresp
	 * @param p9teres
	 * @param p9nufiladj
	 * @param direccionAntiguaCompleta
	 * @param llegadaHoras
	 * @param llegadaMinutos
	 * @param atencionHoras
	 * @param atencionMinutos
	 * @param coextranjero
	 * @param coconsultaaaccempresas
	 * @param cocif
	 * @param corazonsocial
	 * @param conombrecomercial
	 */
	public ConsultaDetalle(String cocodigo, String tircodigo, String tirnombre, String pscodigo, String psnombre,
			String psnombree, String rancod, String randesc, String tfpcodigo, String tfpnombre, String tfpnombree,
			String codOrg, String orgnombreEs, String orgnombreEu, String orgtelefono, String orgfax, String orgemail,
			String orgurl, String orgnoraPaisId, String orgnombrePais, String orgnoraProvinciaId,
			String orgnombreProvincia, String orgnoraMunicipioId, String orgnombreMunicipio, String orgnoraLocalidadId,
			String orgnombreLocalidad, String orgnoraCalleId, String orgnombreCalle, String orgnoraCpId,
			String orgnombreCp, String orgnoraPortalId, String orgnombrePortal, String mocodigo, String monombre,
			Date cofecha, String cocosx, String conran, String cocose, String cotexto, Integer conrreg, String conoco,
			String conodirco, String conrcpco, String cocoloco, String conoloco, String conomuco, String cocopvco,
			String cocopaco, String conrtelco, String conrfaxco, String cocoemco, Date coferes, String coinreenv,
			String coteresp, String cocotfpr, String coinl37, Long conranrg, String cocopro, String cohdcodigo,
			String cohora, Date cofechaconsumidor, String cofechaconshora, String noraPaisId, String nombrePais,
			String provinciaId, String nombreProvincia, String municipioId, String nombreMunicipio, String localidadId,
			String nombreLocalidad, String calleId, String calleId_label, String cpId, String nombreCp, String portalId,
			String nombrePortal, String coinl21, String cosituacion, String nombrePiso, String direccion_nocapv,
			String p9codigo, String p8codigo, String p8nombre, String p8nombree, Date p9feanot, String p9inemlusu,
			Date p9feresp, String p9teres, BigDecimal p9nufiladj, String direccionAntiguaCompleta, String llegadaHoras,
			String llegadaMinutos, String atencionHoras, String atencionMinutos, String coextranjero,
			String coconsultaaaccempresas, String cocif, String corazonsocial, String conombrecomercial) {
		this.cocodigo = cocodigo;
		this.tircodigo = tircodigo;
		this.tirnombre = tirnombre;
		this.pscodigo = pscodigo;
		this.psnombre = psnombre;
		this.psnombree = psnombree;
		this.rancod = rancod;
		this.randesc = randesc;
		this.tfpcodigo = tfpcodigo;
		this.tfpnombre = tfpnombre;
		this.tfpnombree = tfpnombree;
		this.codOrg = codOrg;
		this.orgnombreEs = orgnombreEs;
		this.orgnombreEu = orgnombreEu;
		this.orgtelefono = orgtelefono;
		this.orgfax = orgfax;
		this.orgemail = orgemail;
		this.orgurl = orgurl;
		this.orgnoraPaisId = orgnoraPaisId;
		this.orgnombrePais = orgnombrePais;
		this.orgnoraProvinciaId = orgnoraProvinciaId;
		this.orgnombreProvincia = orgnombreProvincia;
		this.orgnoraMunicipioId = orgnoraMunicipioId;
		this.orgnombreMunicipio = orgnombreMunicipio;
		this.orgnoraLocalidadId = orgnoraLocalidadId;
		this.orgnombreLocalidad = orgnombreLocalidad;
		this.orgnoraCalleId = orgnoraCalleId;
		this.orgnombreCalle = orgnombreCalle;
		this.orgnoraCpId = orgnoraCpId;
		this.orgnombreCp = orgnombreCp;
		this.orgnoraPortalId = orgnoraPortalId;
		this.orgnombrePortal = orgnombrePortal;
		this.mocodigo = mocodigo;
		this.monombre = monombre;
		this.cofecha = cofecha;
		this.cocosx = cocosx;
		this.conran = conran;
		this.cocose = cocose;
		this.cotexto = cotexto;
		this.conrreg = conrreg;
		this.conoco = conoco;
		this.conodirco = conodirco;
		this.conrcpco = conrcpco;
		this.cocoloco = cocoloco;
		this.conoloco = conoloco;
		this.conomuco = conomuco;
		this.cocopvco = cocopvco;
		this.cocopaco = cocopaco;
		this.conrtelco = conrtelco;
		this.conrfaxco = conrfaxco;
		this.cocoemco = cocoemco;
		this.coferes = coferes;
		this.coinreenv = coinreenv;
		this.coteresp = coteresp;
		this.cocotfpr = cocotfpr;
		this.coinl37 = coinl37;
		this.conranrg = conranrg;
		this.cocopro = cocopro;
		this.cohdcodigo = cohdcodigo;
		this.cohora = cohora;
		this.cofechaconsumidor = cofechaconsumidor;
		this.cofechaconshora = cofechaconshora;
		this.noraPaisId = noraPaisId;
		this.nombrePais = nombrePais;
		this.provinciaId = provinciaId;
		this.nombreProvincia = nombreProvincia;
		this.municipioId = municipioId;
		this.nombreMunicipio = nombreMunicipio;
		this.localidadId = localidadId;
		this.nombreLocalidad = nombreLocalidad;
		this.calleId = calleId;
		this.calleId_label = calleId_label;
		this.cpId = cpId;
		this.nombreCp = nombreCp;
		this.portalId = portalId;
		this.nombrePortal = nombrePortal;
		this.coinl21 = coinl21;
		this.cosituacion = cosituacion;
		this.nombrePiso = nombrePiso;
		this.direccion_nocapv = direccion_nocapv;
		this.p9codigo = p9codigo;
		this.p8codigo = p8codigo;
		this.p8nombre = p8nombre;
		this.p8nombree = p8nombree;
		this.p9feanot = p9feanot;
		this.p9inemlusu = p9inemlusu;
		this.p9feresp = p9feresp;
		this.p9teres = p9teres;
		this.p9nufiladj = p9nufiladj;
		this.direccionAntiguaCompleta = direccionAntiguaCompleta;
		this.llegadaHoras = llegadaHoras;
		this.llegadaMinutos = llegadaMinutos;
		this.atencionHoras = atencionHoras;
		this.atencionMinutos = atencionMinutos;
		this.coextranjero = coextranjero;
		this.coconsultaaaccempresas = coconsultaaaccempresas;
		this.cocif = cocif;
		this.corazonsocial = corazonsocial;
		this.conombrecomercial = conombrecomercial;
	}

	/**
	 * @param codOrg
	 * @param conranrg
	 * @param conrreg
	 */
	public ConsultaDetalle(String codOrg, Long conranrg, Integer conrreg) {
		this.codOrg = codOrg;
		this.conranrg = conranrg;
		this.conrreg = conrreg;
	}

	/**
	 * @return the cocodigo
	 */
	public String getCocodigo() {
		return cocodigo;
	}

	/**
	 * @param cocodigo
	 *            the cocodigo to set
	 */
	public void setCocodigo(String cocodigo) {
		this.cocodigo = cocodigo;
	}

	/**
	 * @return the tircodigo
	 */
	public String getTircodigo() {
		return tircodigo;
	}

	/**
	 * @param tircodigo
	 *            the tircodigo to set
	 */
	public void setTircodigo(String tircodigo) {
		this.tircodigo = tircodigo;
	}

	/**
	 * @return the tirnombre
	 */
	public String getTirnombre() {
		return tirnombre;
	}

	/**
	 * @param tirnombre
	 *            the tirnombre to set
	 */
	public void setTirnombre(String tirnombre) {
		this.tirnombre = tirnombre;
	}

	/**
	 * @return the pscodigo
	 */
	public String getPscodigo() {
		return pscodigo;
	}

	/**
	 * @param pscodigo
	 *            the pscodigo to set
	 */
	public void setPscodigo(String pscodigo) {
		this.pscodigo = pscodigo;
	}

	/**
	 * @return the psnombre
	 */
	public String getPsnombre() {
		return psnombre;
	}

	/**
	 * @param psnombre
	 *            the psnombre to set
	 */
	public void setPsnombre(String psnombre) {
		this.psnombre = psnombre;
	}

	/**
	 * @return the psnombree
	 */
	public String getPsnombree() {
		return psnombree;
	}

	/**
	 * @param psnombree
	 *            the psnombree to set
	 */
	public void setPsnombree(String psnombree) {
		this.psnombree = psnombree;
	}

	/**
	 * @return the rancod
	 */
	public String getRancod() {
		return rancod;
	}

	/**
	 * @param rancod
	 *            the rancod to set
	 */
	public void setRancod(String rancod) {
		this.rancod = rancod;
	}

	/**
	 * @return the randesc
	 */
	public String getRandesc() {
		return randesc;
	}

	/**
	 * @param randesc
	 *            the randesc to set
	 */
	public void setRandesc(String randesc) {
		this.randesc = randesc;
	}

	/**
	 * @return the tfpcodigo
	 */
	public String getTfpcodigo() {
		return tfpcodigo;
	}

	/**
	 * @param tfpcodigo
	 *            the tfpcodigo to set
	 */
	public void setTfpcodigo(String tfpcodigo) {
		this.tfpcodigo = tfpcodigo;
	}

	/**
	 * @return the tfpnombre
	 */
	public String getTfpnombre() {
		return tfpnombre;
	}

	/**
	 * @param tfpnombre
	 *            the tfpnombre to set
	 */
	public void setTfpnombre(String tfpnombre) {
		this.tfpnombre = tfpnombre;
	}

	/**
	 * @return the tfpnombree
	 */
	public String getTfpnombree() {
		return tfpnombree;
	}

	/**
	 * @param tfpnombree
	 *            the tfpnombree to set
	 */
	public void setTfpnombree(String tfpnombree) {
		this.tfpnombree = tfpnombree;
	}

	/**
	 * @return the codOrg
	 */
	public String getCodOrg() {
		return codOrg;
	}

	/**
	 * @param codOrg
	 *            the codOrg to set
	 */
	public void setCodOrg(String codOrg) {
		this.codOrg = codOrg;
	}

	/**
	 * @return the mocodigo
	 */
	public String getMocodigo() {
		return mocodigo;
	}

	/**
	 * @param mocodigo
	 *            the mocodigo to set
	 */
	public void setMocodigo(String mocodigo) {
		this.mocodigo = mocodigo;
	}

	/**
	 * @return the cofecha
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getCofecha() {
		return cofecha;
	}

	/**
	 * @param cofecha
	 *            the cofecha to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setCofecha(Date cofecha) {
		this.cofecha = cofecha;
	}

	/**
	 * @return the cocosx
	 */
	public String getCocosx() {
		return cocosx;
	}

	/**
	 * @param cocosx
	 *            the cocosx to set
	 */
	public void setCocosx(String cocosx) {
		this.cocosx = cocosx;
	}

	/**
	 * @return the conran
	 */
	public String getConran() {
		return conran;
	}

	/**
	 * @param conran
	 *            the conran to set
	 */
	public void setConran(String conran) {
		this.conran = conran;
	}

	/**
	 * @return the cocose
	 */
	public String getCocose() {
		return cocose;
	}

	/**
	 * @param cocose
	 *            the cocose to set
	 */
	public void setCocose(String cocose) {
		this.cocose = cocose;
	}

	/**
	 * @return the cotexto
	 */
	public String getCotexto() {
		return cotexto;
	}

	/**
	 * @param cotexto
	 *            the cotexto to set
	 */
	public void setCotexto(String cotexto) {
		this.cotexto = cotexto;
	}

	/**
	 * @return the conrreg
	 */
	public Integer getConrreg() {
		return conrreg;
	}

	/**
	 * @param conrreg
	 *            the conrreg to set
	 */
	public void setConrreg(Integer conrreg) {
		this.conrreg = conrreg;
	}

	/**
	 * @return the conoco
	 */
	public String getConoco() {
		return conoco;
	}

	/**
	 * @param conoco
	 *            the conoco to set
	 */
	public void setConoco(String conoco) {
		this.conoco = conoco;
	}

	/**
	 * @return the conodirco
	 */
	public String getConodirco() {
		return conodirco;
	}

	/**
	 * @param conodirco
	 *            the conodirco to set
	 */
	public void setConodirco(String conodirco) {
		this.conodirco = conodirco;
	}

	/**
	 * @return the conrcpco
	 */
	public String getConrcpco() {
		return conrcpco;
	}

	/**
	 * @param conrcpco
	 *            the conrcpco to set
	 */
	public void setConrcpco(String conrcpco) {
		this.conrcpco = conrcpco;
	}

	/**
	 * @return the cocoloco
	 */
	public String getCocoloco() {
		return cocoloco;
	}

	/**
	 * @param cocoloco
	 *            the cocoloco to set
	 */
	public void setCocoloco(String cocoloco) {
		this.cocoloco = cocoloco;
	}

	/**
	 * @return the conoloco
	 */
	public String getConoloco() {
		return conoloco;
	}

	/**
	 * @param conoloco
	 *            the conoloco to set
	 */
	public void setConoloco(String conoloco) {
		this.conoloco = conoloco;
	}

	/**
	 * @return the conomuco
	 */
	public String getConomuco() {
		return conomuco;
	}

	/**
	 * @param conomuco
	 *            the conomuco to set
	 */
	public void setConomuco(String conomuco) {
		this.conomuco = conomuco;
	}

	/**
	 * @return the cocopvco
	 */
	public String getCocopvco() {
		return cocopvco;
	}

	/**
	 * @param cocopvco
	 *            the cocopvco to set
	 */
	public void setCocopvco(String cocopvco) {
		this.cocopvco = cocopvco;
	}

	/**
	 * @return the cocopaco
	 */
	public String getCocopaco() {
		return cocopaco;
	}

	/**
	 * @param cocopaco
	 *            the cocopaco to set
	 */
	public void setCocopaco(String cocopaco) {
		this.cocopaco = cocopaco;
	}

	/**
	 * @return the conrtelco
	 */
	public String getConrtelco() {
		return conrtelco;
	}

	/**
	 * @param conrtelco
	 *            the conrtelco to set
	 */
	public void setConrtelco(String conrtelco) {
		this.conrtelco = conrtelco;
	}

	/**
	 * @return the conrfaxco
	 */
	public String getConrfaxco() {
		return conrfaxco;
	}

	/**
	 * @param conrfaxco
	 *            the conrfaxco to set
	 */
	public void setConrfaxco(String conrfaxco) {
		this.conrfaxco = conrfaxco;
	}

	/**
	 * @return the cocoemco
	 */
	public String getCocoemco() {
		return cocoemco;
	}

	/**
	 * @param cocoemco
	 *            the cocoemco to set
	 */
	public void setCocoemco(String cocoemco) {
		this.cocoemco = cocoemco;
	}

	/**
	 * @return the coferes
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getCoferes() {
		return coferes;
	}

	/**
	 * @param coferes
	 *            the coferes to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setCoferes(Date coferes) {
		this.coferes = coferes;
	}

	/**
	 * @return the coinreenv
	 */
	public String getCoinreenv() {
		return coinreenv;
	}

	/**
	 * @param coinreenv
	 *            the coinreenv to set
	 */
	public void setCoinreenv(String coinreenv) {
		this.coinreenv = coinreenv;
	}

	/**
	 * @return the coteresp
	 */
	public String getCoteresp() {
		return coteresp;
	}

	/**
	 * @param coteresp
	 *            the coteresp to set
	 */
	public void setCoteresp(String coteresp) {
		this.coteresp = coteresp;
	}

	/**
	 * @return the cocotfpr
	 */
	public String getCocotfpr() {
		return cocotfpr;
	}

	/**
	 * @param cocotfpr
	 *            the cocotfpr to set
	 */
	public void setCocotfpr(String cocotfpr) {
		this.cocotfpr = cocotfpr;
	}

	/**
	 * @return the coinl37
	 */
	public String getCoinl37() {
		return coinl37;
	}

	/**
	 * @param coinl37
	 *            the coinl37 to set
	 */
	public void setCoinl37(String coinl37) {
		this.coinl37 = coinl37;
	}

	/**
	 * @return the conranrg
	 */
	public Long getConranrg() {
		return conranrg;
	}

	/**
	 * @param conranrg
	 *            the conranrg to set
	 */
	public void setConranrg(Long conranrg) {
		this.conranrg = conranrg;
	}

	/**
	 * @return the cocopro
	 */
	public String getCocopro() {
		return cocopro;
	}

	/**
	 * @param cocopro
	 *            the cocopro to set
	 */
	public void setCocopro(String cocopro) {
		this.cocopro = cocopro;
	}

	/**
	 * @return the cohdcodigo
	 */
	public String getCohdcodigo() {
		return cohdcodigo;
	}

	/**
	 * @param cohdcodigo
	 *            the cohdcodigo to set
	 */
	public void setCohdcodigo(String cohdcodigo) {
		this.cohdcodigo = cohdcodigo;
	}

	/**
	 * @return the cohora
	 */
	public String getCohora() {
		return cohora;
	}

	/**
	 * @param cohora
	 *            the cohora to set
	 */
	public void setCohora(String cohora) {
		this.cohora = cohora;
	}

	/**
	 * @return the cofechaconsumidor
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getCofechaconsumidor() {
		return cofechaconsumidor;
	}

	/**
	 * @param cofechaconsumidor
	 *            the cofechaconsumidor to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setCofechaconsumidor(Date cofechaconsumidor) {
		this.cofechaconsumidor = cofechaconsumidor;
	}

	/**
	 * @return the noraPaisId
	 */
	public String getNoraPaisId() {
		return noraPaisId;
	}

	/**
	 * @param noraPaisId
	 *            the noraPaisId to set
	 */
	public void setNoraPaisId(String noraPaisId) {
		this.noraPaisId = noraPaisId;
	}

	/**
	 * @return the nombrePais
	 */
	public String getNombrePais() {
		return nombrePais;
	}

	/**
	 * @param nombrePais
	 *            the nombrePais to set
	 */
	public void setNombrePais(String nombrePais) {
		this.nombrePais = nombrePais;
	}

	/**
	 * @return the provinciaId
	 */
	public String getProvinciaId() {
		return provinciaId;
	}

	/**
	 * @param provinciaId
	 *            the provinciaId to set
	 */
	public void setProvinciaId(String provinciaId) {
		this.provinciaId = provinciaId;
	}

	/**
	 * @return the nombreProvincia
	 */
	public String getNombreProvincia() {
		return nombreProvincia;
	}

	/**
	 * @param nombreProvincia
	 *            the nombreProvincia to set
	 */
	public void setNombreProvincia(String nombreProvincia) {
		this.nombreProvincia = nombreProvincia;
	}

	/**
	 * @return the municipioId
	 */
	public String getMunicipioId() {
		return municipioId;
	}

	/**
	 * @param municipioId
	 *            the municipioId to set
	 */
	public void setMunicipioId(String municipioId) {
		this.municipioId = municipioId;
	}

	/**
	 * @return the nombreMunicipio
	 */
	public String getNombreMunicipio() {
		return nombreMunicipio;
	}

	/**
	 * @param nombreMunicipio
	 *            the nombreMunicipio to set
	 */
	public void setNombreMunicipio(String nombreMunicipio) {
		this.nombreMunicipio = nombreMunicipio;
	}

	/**
	 * @return the localidadId
	 */
	public String getLocalidadId() {
		return localidadId;
	}

	/**
	 * @param localidadId
	 *            the localidadId to set
	 */
	public void setLocalidadId(String localidadId) {
		this.localidadId = localidadId;
	}

	/**
	 * @return the nombreLocalidad
	 */
	public String getNombreLocalidad() {
		return nombreLocalidad;
	}

	/**
	 * @param nombreLocalidad
	 *            the nombreLocalidad to set
	 */
	public void setNombreLocalidad(String nombreLocalidad) {
		this.nombreLocalidad = nombreLocalidad;
	}

	/**
	 * @return the calleId
	 */
	public String getCalleId() {
		return calleId;
	}

	/**
	 * @param calleId
	 *            the calleId to set
	 */
	public void setCalleId(String calleId) {
		this.calleId = calleId;
	}

	/**
	 * @return the calleId_label
	 */
	public String getCalleId_label() {
		return calleId_label;
	}

	/**
	 * @param calleId_label
	 *            the calleId_label to set
	 */
	public void setCalleId_label(String calleId_label) {
		this.calleId_label = calleId_label;
	}

	/**
	 * @return the cpId
	 */
	public String getCpId() {
		return cpId;
	}

	/**
	 * @param cpId
	 *            the cpId to set
	 */
	public void setCpId(String cpId) {
		this.cpId = cpId;
	}

	/**
	 * @return the nombreCp
	 */
	public String getNombreCp() {
		return nombreCp;
	}

	/**
	 * @param nombreCp
	 *            the nombreCp to set
	 */
	public void setNombreCp(String nombreCp) {
		this.nombreCp = nombreCp;
	}

	/**
	 * @return the portalId
	 */
	public String getPortalId() {
		return portalId;
	}

	/**
	 * @param portalId
	 *            the portalId to set
	 */
	public void setPortalId(String portalId) {
		this.portalId = portalId;
	}

	/**
	 * @return the nombrePortal
	 */
	public String getNombrePortal() {
		return nombrePortal;
	}

	/**
	 * @param nombrePortal
	 *            the nombrePortal to set
	 */
	public void setNombrePortal(String nombrePortal) {
		this.nombrePortal = nombrePortal;
	}

	/**
	 * @return the coinl21
	 */
	public String getCoinl21() {
		return coinl21;
	}

	/**
	 * @param coinl21
	 *            the coinl21 to set
	 */
	public void setCoinl21(String coinl21) {
		this.coinl21 = coinl21;
	}

	/**
	 * @return the cosituacion
	 */
	public String getCosituacion() {
		return cosituacion;
	}

	/**
	 * @param cosituacion
	 *            the cosituacion to set
	 */
	public void setCosituacion(String cosituacion) {
		this.cosituacion = cosituacion;
	}

	/**
	 * @return the nombrePiso
	 */
	public String getNombrePiso() {
		return nombrePiso;
	}

	/**
	 * @param nombrePiso
	 *            the nombrePiso to set
	 */
	public void setNombrePiso(String nombrePiso) {
		this.nombrePiso = nombrePiso;
	}

	/**
	 * @return the p9codigo
	 */
	public String getP9codigo() {
		return p9codigo;
	}

	/**
	 * @param p9codigo
	 *            the p9codigo to set
	 */
	public void setP9codigo(String p9codigo) {
		this.p9codigo = p9codigo;
	}

	/**
	 * @return the p8codigo
	 */
	public String getP8codigo() {
		return p8codigo;
	}

	/**
	 * @param p8codigo
	 *            the p8codigo to set
	 */
	public void setP8codigo(String p8codigo) {
		this.p8codigo = p8codigo;
	}

	/**
	 * @return the p8nombre
	 */
	public String getP8nombre() {
		return p8nombre;
	}

	/**
	 * @param p8nombre
	 *            the p8nombre to set
	 */
	public void setP8nombre(String p8nombre) {
		this.p8nombre = p8nombre;
	}

	/**
	 * @return the p8nombree
	 */
	public String getP8nombree() {
		return p8nombree;
	}

	/**
	 * @param p8nombree
	 *            the p8nombree to set
	 */
	public void setP8nombree(String p8nombree) {
		this.p8nombree = p8nombree;
	}

	/**
	 * @return the p9feanot
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getP9feanot() {
		return p9feanot;
	}

	/**
	 * @param p9feanot
	 *            the p9feanot to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setP9feanot(Date p9feanot) {
		this.p9feanot = p9feanot;
	}

	/**
	 * @return the p9inemlusu
	 */
	public String getP9inemlusu() {
		return p9inemlusu;
	}

	/**
	 * @param p9inemlusu
	 *            the p9inemlusu to set
	 */
	public void setP9inemlusu(String p9inemlusu) {
		this.p9inemlusu = p9inemlusu;
	}

	/**
	 * @return the p9feresp
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getP9feresp() {
		return p9feresp;
	}

	/**
	 * @param p9feresp
	 *            the p9feresp to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setP9feresp(Date p9feresp) {
		this.p9feresp = p9feresp;
	}

	/**
	 * @return the p9teres
	 */
	public String getP9teres() {
		return p9teres;
	}

	/**
	 * @param p9teres
	 *            the p9teres to set
	 */
	public void setP9teres(String p9teres) {
		this.p9teres = p9teres;
	}

	/**
	 * @return the p9nufiladj
	 */
	public BigDecimal getP9nufiladj() {
		return p9nufiladj;
	}

	/**
	 * @param p9nufiladj
	 *            the p9nufiladj to set
	 */
	public void setP9nufiladj(BigDecimal p9nufiladj) {
		this.p9nufiladj = p9nufiladj;
	}

	/**
	 * @return the cofechaconshora
	 */
	public String getCofechaconshora() {
		return cofechaconshora;
	}

	/**
	 * @param cofechaconshora
	 *            the cofechaconshora to set
	 */
	public void setCofechaconshora(String cofechaconshora) {
		this.cofechaconshora = cofechaconshora;
	}

	/**
	 * @return the llegadaHoras
	 */
	public String getLlegadaHoras() {
		return llegadaHoras;
	}

	/**
	 * @param llegadaHoras
	 *            the llegadaHoras to set
	 */
	public void setLlegadaHoras(String llegadaHoras) {
		this.llegadaHoras = llegadaHoras;
	}

	/**
	 * @return the llegadaMinutos
	 */
	public String getLlegadaMinutos() {
		return llegadaMinutos;
	}

	/**
	 * @param llegadaMinutos
	 *            the llegadaMinutos to set
	 */
	public void setLlegadaMinutos(String llegadaMinutos) {
		this.llegadaMinutos = llegadaMinutos;
	}

	/**
	 * @return the atencionHoras
	 */
	public String getAtencionHoras() {
		return atencionHoras;
	}

	/**
	 * @param atencionHoras
	 *            the atencionHoras to set
	 */
	public void setAtencionHoras(String atencionHoras) {
		this.atencionHoras = atencionHoras;
	}

	/**
	 * @return the atencionMinutos
	 */
	public String getAtencionMinutos() {
		return atencionMinutos;
	}

	/**
	 * @param atencionMinutos
	 *            the atencionMinutos to set
	 */
	public void setAtencionMinutos(String atencionMinutos) {
		this.atencionMinutos = atencionMinutos;
	}

	/**
	 * @return the direccionAntiguaCompleta
	 */
	public String getDireccionAntiguaCompleta() {
		return direccionAntiguaCompleta;
	}

	/**
	 * @param direccionAntiguaCompleta
	 *            the direccionAntiguaCompleta to set
	 */
	public void setDireccionAntiguaCompleta(String direccionAntiguaCompleta) {
		this.direccionAntiguaCompleta = direccionAntiguaCompleta;
	}

	/**
	 * @return the monombre
	 */
	public String getMonombre() {
		return monombre;
	}

	/**
	 * @param monombre
	 *            the monombre to set
	 */
	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * @return the orgnombreEs
	 */
	public String getOrgnombreEs() {
		return orgnombreEs;
	}

	/**
	 * @param orgnombreEs
	 *            the orgnombreEs to set
	 */
	public void setOrgnombreEs(String orgnombreEs) {
		this.orgnombreEs = orgnombreEs;
	}

	/**
	 * @return the orgnombreEu
	 */
	public String getOrgnombreEu() {
		return orgnombreEu;
	}

	/**
	 * @param orgnombreEu
	 *            the orgnombreEu to set
	 */
	public void setOrgnombreEu(String orgnombreEu) {
		this.orgnombreEu = orgnombreEu;
	}

	/**
	 * @return the orgtelefono
	 */
	public String getOrgtelefono() {
		return orgtelefono;
	}

	/**
	 * @param orgtelefono
	 *            the orgtelefono to set
	 */
	public void setOrgtelefono(String orgtelefono) {
		this.orgtelefono = orgtelefono;
	}

	/**
	 * @return the orgfax
	 */
	public String getOrgfax() {
		return orgfax;
	}

	/**
	 * @param orgfax
	 *            the orgfax to set
	 */
	public void setOrgfax(String orgfax) {
		this.orgfax = orgfax;
	}

	/**
	 * @return the orgemail
	 */
	public String getOrgemail() {
		return orgemail;
	}

	/**
	 * @param orgemail
	 *            the orgemail to set
	 */
	public void setOrgemail(String orgemail) {
		this.orgemail = orgemail;
	}

	/**
	 * @return the orgurl
	 */
	public String getOrgurl() {
		return orgurl;
	}

	/**
	 * @param orgurl
	 *            the orgurl to set
	 */
	public void setOrgurl(String orgurl) {
		this.orgurl = orgurl;
	}

	/**
	 * @return the orgnoraPaisId
	 */
	public String getOrgnoraPaisId() {
		return orgnoraPaisId;
	}

	/**
	 * @param orgnoraPaisId
	 *            the orgnoraPaisId to set
	 */
	public void setOrgnoraPaisId(String orgnoraPaisId) {
		this.orgnoraPaisId = orgnoraPaisId;
	}

	/**
	 * @return the orgnombrePais
	 */
	public String getOrgnombrePais() {
		return orgnombrePais;
	}

	/**
	 * @param orgnombrePais
	 *            the orgnombrePais to set
	 */
	public void setOrgnombrePais(String orgnombrePais) {
		this.orgnombrePais = orgnombrePais;
	}

	/**
	 * @return the orgnoraProvinciaId
	 */
	public String getOrgnoraProvinciaId() {
		return orgnoraProvinciaId;
	}

	/**
	 * @param orgnoraProvinciaId
	 *            the orgnoraProvinciaId to set
	 */
	public void setOrgnoraProvinciaId(String orgnoraProvinciaId) {
		this.orgnoraProvinciaId = orgnoraProvinciaId;
	}

	/**
	 * @return the orgnombreProvincia
	 */
	public String getOrgnombreProvincia() {
		return orgnombreProvincia;
	}

	/**
	 * @param orgnombreProvincia
	 *            the orgnombreProvincia to set
	 */
	public void setOrgnombreProvincia(String orgnombreProvincia) {
		this.orgnombreProvincia = orgnombreProvincia;
	}

	/**
	 * @return the orgnoraMunicipioId
	 */
	public String getOrgnoraMunicipioId() {
		return orgnoraMunicipioId;
	}

	/**
	 * @param orgnoraMunicipioId
	 *            the orgnoraMunicipioId to set
	 */
	public void setOrgnoraMunicipioId(String orgnoraMunicipioId) {
		this.orgnoraMunicipioId = orgnoraMunicipioId;
	}

	/**
	 * @return the orgnombreMunicipio
	 */
	public String getOrgnombreMunicipio() {
		return orgnombreMunicipio;
	}

	/**
	 * @param orgnombreMunicipio
	 *            the orgnombreMunicipio to set
	 */
	public void setOrgnombreMunicipio(String orgnombreMunicipio) {
		this.orgnombreMunicipio = orgnombreMunicipio;
	}

	/**
	 * @return the orgnoraLocalidadId
	 */
	public String getOrgnoraLocalidadId() {
		return orgnoraLocalidadId;
	}

	/**
	 * @param orgnoraLocalidadId
	 *            the orgnoraLocalidadId to set
	 */
	public void setOrgnoraLocalidadId(String orgnoraLocalidadId) {
		this.orgnoraLocalidadId = orgnoraLocalidadId;
	}

	/**
	 * @return the orgnombreLocalidad
	 */
	public String getOrgnombreLocalidad() {
		return orgnombreLocalidad;
	}

	/**
	 * @param orgnombreLocalidad
	 *            the orgnombreLocalidad to set
	 */
	public void setOrgnombreLocalidad(String orgnombreLocalidad) {
		this.orgnombreLocalidad = orgnombreLocalidad;
	}

	/**
	 * @return the orgnoraCalleId
	 */
	public String getOrgnoraCalleId() {
		return orgnoraCalleId;
	}

	/**
	 * @param orgnoraCalleId
	 *            the orgnoraCalleId to set
	 */
	public void setOrgnoraCalleId(String orgnoraCalleId) {
		this.orgnoraCalleId = orgnoraCalleId;
	}

	/**
	 * @return the orgnombreCalle
	 */
	public String getOrgnombreCalle() {
		return orgnombreCalle;
	}

	/**
	 * @param orgnombreCalle
	 *            the orgnombreCalle to set
	 */
	public void setOrgnombreCalle(String orgnombreCalle) {
		this.orgnombreCalle = orgnombreCalle;
	}

	/**
	 * @return the orgnoraCpId
	 */
	public String getOrgnoraCpId() {
		return orgnoraCpId;
	}

	/**
	 * @param orgnoraCpId
	 *            the orgnoraCpId to set
	 */
	public void setOrgnoraCpId(String orgnoraCpId) {
		this.orgnoraCpId = orgnoraCpId;
	}

	/**
	 * @return the orgnombreCp
	 */
	public String getOrgnombreCp() {
		return orgnombreCp;
	}

	/**
	 * @param orgnombreCp
	 *            the orgnombreCp to set
	 */
	public void setOrgnombreCp(String orgnombreCp) {
		this.orgnombreCp = orgnombreCp;
	}

	/**
	 * @return the orgnoraPortalId
	 */
	public String getOrgnoraPortalId() {
		return orgnoraPortalId;
	}

	/**
	 * @param orgnoraPortalId
	 *            the orgnoraPortalId to set
	 */
	public void setOrgnoraPortalId(String orgnoraPortalId) {
		this.orgnoraPortalId = orgnoraPortalId;
	}

	/**
	 * @return the orgnombrePortal
	 */
	public String getOrgnombrePortal() {
		return orgnombrePortal;
	}

	/**
	 * @param orgnombrePortal
	 *            the orgnombrePortal to set
	 */
	public void setOrgnombrePortal(String orgnombrePortal) {
		this.orgnombrePortal = orgnombrePortal;
	}

	/**
	 * @return the direccion_nocapv
	 */
	public String getDireccion_nocapv() {
		return direccion_nocapv;
	}

	/**
	 * @param direccion_nocapv
	 *            the direccion_nocapv to set
	 */
	public void setDireccion_nocapv(String direccion_nocapv) {
		this.direccion_nocapv = direccion_nocapv;
	}

	/**
	 * @return the coextranjero
	 */
	public String getCoextranjero() {
		return coextranjero;
	}

	/**
	 * @param coextranjero
	 *            the coextranjero to set
	 */
	public void setCoextranjero(String coextranjero) {
		this.coextranjero = coextranjero;
	}

	/**
	 * @return the coconsultaaaccempresas
	 */
	public String getCoconsultaaaccempresas() {
		return coconsultaaaccempresas;
	}

	/**
	 * @param coconsultaaaccempresas
	 *            the coconsultaaaccempresas to set
	 */
	public void setCoconsultaaaccempresas(String coconsultaaaccempresas) {
		this.coconsultaaaccempresas = coconsultaaaccempresas;
	}

	/**
	 * @return the cocif
	 */
	public String getCocif() {
		return cocif;
	}

	/**
	 * @param cocif
	 *            the cocif to set
	 */
	public void setCocif(String cocif) {
		this.cocif = cocif;
	}

	/**
	 * @return the corazonsocial
	 */
	public String getCorazonsocial() {
		return corazonsocial;
	}

	/**
	 * @param corazonsocial
	 *            the corazonsocial to set
	 */
	public void setCorazonsocial(String corazonsocial) {
		this.corazonsocial = corazonsocial;
	}

	/**
	 * @return the conombrecomercial
	 */
	public String getConombrecomercial() {
		return conombrecomercial;
	}

	/**
	 * @param conombrecomercial
	 *            the conombrecomercial to set
	 */
	public void setConombrecomercial(String conombrecomercial) {
		this.conombrecomercial = conombrecomercial;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "ConsultaDetalle [cocodigo=" + cocodigo + ", tircodigo=" + tircodigo + ", tirnombre=" + tirnombre
				+ ", pscodigo=" + pscodigo + ", psnombre=" + psnombre + ", psnombree=" + psnombree + ", rancod="
				+ rancod + ", randesc=" + randesc + ", tfpcodigo=" + tfpcodigo + ", tfpnombre=" + tfpnombre
				+ ", tfpnombree=" + tfpnombree + ", codOrg=" + codOrg + ", orgnombreEs=" + orgnombreEs
				+ ", orgnombreEu=" + orgnombreEu + ", orgtelefono=" + orgtelefono + ", orgfax=" + orgfax + ", orgemail="
				+ orgemail + ", orgurl=" + orgurl + ", orgnoraPaisId=" + orgnoraPaisId + ", orgnombrePais="
				+ orgnombrePais + ", orgnoraProvinciaId=" + orgnoraProvinciaId + ", orgnombreProvincia="
				+ orgnombreProvincia + ", orgnoraMunicipioId=" + orgnoraMunicipioId + ", orgnombreMunicipio="
				+ orgnombreMunicipio + ", orgnoraLocalidadId=" + orgnoraLocalidadId + ", orgnombreLocalidad="
				+ orgnombreLocalidad + ", orgnoraCalleId=" + orgnoraCalleId + ", orgnombreCalle=" + orgnombreCalle
				+ ", orgnoraCpId=" + orgnoraCpId + ", orgnombreCp=" + orgnombreCp + ", orgnoraPortalId="
				+ orgnoraPortalId + ", orgnombrePortal=" + orgnombrePortal + ", mocodigo=" + mocodigo + ", monombre="
				+ monombre + ", cofecha=" + cofecha + ", cocosx=" + cocosx + ", conran=" + conran + ", cocose=" + cocose
				+ ", cotexto=" + cotexto + ", conrreg=" + conrreg + ", conoco=" + conoco + ", conodirco=" + conodirco
				+ ", conrcpco=" + conrcpco + ", cocoloco=" + cocoloco + ", conoloco=" + conoloco + ", conomuco="
				+ conomuco + ", cocopvco=" + cocopvco + ", cocopaco=" + cocopaco + ", conrtelco=" + conrtelco
				+ ", conrfaxco=" + conrfaxco + ", cocoemco=" + cocoemco + ", coferes=" + coferes + ", coinreenv="
				+ coinreenv + ", coteresp=" + coteresp + ", cocotfpr=" + cocotfpr + ", coinl37=" + coinl37
				+ ", conranrg=" + conranrg + ", cocopro=" + cocopro + ", cohdcodigo=" + cohdcodigo + ", cohora="
				+ cohora + ", cofechaconsumidor=" + cofechaconsumidor + ", cofechaconshora=" + cofechaconshora
				+ ", noraPaisId=" + noraPaisId + ", nombrePais=" + nombrePais + ", provinciaId=" + provinciaId
				+ ", nombreProvincia=" + nombreProvincia + ", municipioId=" + municipioId + ", nombreMunicipio="
				+ nombreMunicipio + ", localidadId=" + localidadId + ", nombreLocalidad=" + nombreLocalidad
				+ ", calleId=" + calleId + ", calleId_label=" + calleId_label + ", cpId=" + cpId + ", nombreCp="
				+ nombreCp + ", portalId=" + portalId + ", nombrePortal=" + nombrePortal + ", coinl21=" + coinl21
				+ ", cosituacion=" + cosituacion + ", nombrePiso=" + nombrePiso + ", direccion_nocapv="
				+ direccion_nocapv + ", p9codigo=" + p9codigo + ", p8codigo=" + p8codigo + ", p8nombre=" + p8nombre
				+ ", p8nombree=" + p8nombree + ", p9feanot=" + p9feanot + ", p9inemlusu=" + p9inemlusu + ", p9feresp="
				+ p9feresp + ", p9teres=" + p9teres + ", p9nufiladj=" + p9nufiladj + ", direccionAntiguaCompleta="
				+ direccionAntiguaCompleta + ", llegadaHoras=" + llegadaHoras + ", llegadaMinutos=" + llegadaMinutos
				+ ", atencionHoras=" + atencionHoras + ", atencionMinutos=" + atencionMinutos + ", coextranjero="
				+ coextranjero + ", coconsultaaaccempresas=" + coconsultaaaccempresas + ", cocif=" + cocif
				+ ", corazonsocial=" + corazonsocial + ", conombrecomercial=" + conombrecomercial + "]";
	}

}
