package com.ejie.y41b.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;
import com.ejie.y41b.validation.Y41bNif;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * * CensoMonitor  
 * 
 *  
 */

public class CensoMonitor implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String mocodigo;
	private Organismo organismo;
	@Length(max = 35, message = "error03.lenght.monombre")
	@NotEmpty(message = "error03.required.monombre")
	@NotNull()
	private String monombre;
	@NotEmpty(message = "error04.required.emailnull")
	@NotNull()
	@Email(message = "error05.required.email")
	private String mocoem;
	@Length(max = 100, message = "error06.length.usuarioxlnet")
	@NotEmpty(message = "error06.required.usuarioxlnet")
	@NotNull()
	private String usuarioxlnet;
	@Length(max = 100, message = "error07.length.puestoxlnet")
	@NotEmpty(message = "error07.required.puestoxlnet")
	@NotNull()
	private String puestoxlnet;

	@NotEmpty(message = "error01.required.nif")
	@Y41bNif(message = "error01.required.nifValido")
	private String modni;

	private Date mofecbaja;
	private String mofecbajaDesde;

	private Perfil perfilSolicitudes;
	private Perfil perfilSanciones;
	private Perfil perfilInspecciones;
	private Perfil perfilArbitraje;
	private Perfil perfilOrganizacion;
	private Perfil perfilMaestros;
	private Perfil perfilEconomico;
	private Perfil perfilConsultas;

	private String mobopvboe;

	private String mobandejadefecto;

	private String moadmiliquidacion;

	private String mopagolaudo;

	private String moadmidenunciaempresas;

	// Checks
	private String indIncluirBaja;

	private List<Consulta> consultas = new ArrayList<Consulta>();
	private List<Establecimiento> establecimientos = new ArrayList<Establecimiento>();
	private List<Consumidor> consumidors = new ArrayList<Consumidor>();

	/**
	 * Method 'CensoMonitor'.
	 * 
	 */
	public CensoMonitor() {
	}

	/**
	 * Method 'CensoMonitor'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param monombre
	 *            String
	 * @param mocoem
	 *            String
	 * @param modni
	 *            String
	 * @param usuarioxlnet
	 *            String
	 * @param puestoxlnet
	 *            String
	 * @param mofecbaja
	 *            Date
	 * @param organismo
	 *            Organismo
	 * @param perfilSolicitudes
	 *            Perfil
	 * @param perfilSanciones
	 *            Perfil
	 * @param perfilInspecciones
	 *            Perfil
	 * @param perfilArbitraje
	 *            Perfil
	 * @param perfilOrganizacion
	 *            Perfil
	 * @param perfilMaestros
	 *            Perfil
	 * @param perfilEconomico
	 *            Perfil
	 * @param perfilConsultas
	 *            Perfil
	 * @param mobopvboe
	 *            String
	 * @param moadmiliquidacion
	 *            String
	 * @param mobandejadefecto
	 *            String
	 * @param indIncluirBaja
	 *            String
	 * @param mopagolaudo
	 *            String
	 * @param moadmidenunciaempresas
	 *            String
	 * 
	 */
	public CensoMonitor(String mocodigo, String monombre, String mocoem,
			String modni, String usuarioxlnet, String puestoxlnet,
			Date mofecbaja, Organismo organismo, Perfil perfilSolicitudes,
			Perfil perfilSanciones, Perfil perfilInspecciones,
			Perfil perfilArbitraje, Perfil perfilOrganizacion,
			Perfil perfilMaestros, Perfil perfilEconomico,
			Perfil perfilConsultas, String mobopvboe, String moadmiliquidacion,
			String mobandejadefecto, String indIncluirBaja, String mopagolaudo,
			String moadmidenunciaempresas) {
		this.mocodigo = mocodigo;
		this.organismo = organismo;
		this.monombre = monombre;
		this.mocoem = mocoem;
		this.modni = modni;
		this.usuarioxlnet = usuarioxlnet;
		this.puestoxlnet = puestoxlnet;
		this.mofecbaja = mofecbaja;

		this.perfilSolicitudes = perfilSolicitudes;
		this.perfilSanciones = perfilSanciones;
		this.perfilInspecciones = perfilInspecciones;
		this.perfilArbitraje = perfilArbitraje;
		this.perfilOrganizacion = perfilOrganizacion;
		this.perfilMaestros = perfilMaestros;
		this.perfilEconomico = perfilEconomico;
		this.perfilConsultas = perfilConsultas;

		this.mobopvboe = mobopvboe;
		this.moadmiliquidacion = moadmiliquidacion;
		this.mobandejadefecto = mobandejadefecto;
		this.indIncluirBaja = indIncluirBaja;
		this.mopagolaudo = mopagolaudo;
		this.moadmidenunciaempresas = moadmidenunciaempresas;
	}

	/**
	 * Method 'CensoMonitor'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param monombre
	 *            String
	 * 
	 * 
	 */
	public CensoMonitor(String mocodigo, String monombre) {
		this.mocodigo = mocodigo;
		this.monombre = monombre;
	}

	/**
	 * @return the mocodigo
	 */
	public String getMocodigo() {
		return mocodigo;
	}

	/**
	 * @param mocodigo
	 *            the mocodigo to set
	 */
	public void setMocodigo(String mocodigo) {
		this.mocodigo = mocodigo;
	}

	/**
	 * @return the organismo
	 */
	public Organismo getOrganismo() {
		return organismo;
	}

	/**
	 * @param organismo
	 *            the organismo to set
	 */
	public void setOrganismo(Organismo organismo) {
		this.organismo = organismo;
	}

	/**
	 * @return the monombre
	 */
	public String getMonombre() {
		return monombre;
	}

	/**
	 * @param monombre
	 *            the monombre to set
	 */
	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * @return the mocoem
	 */
	public String getMocoem() {
		return mocoem;
	}

	/**
	 * @param mocoem
	 *            the mocoem to set
	 */
	public void setMocoem(String mocoem) {
		this.mocoem = mocoem;
	}

	/**
	 * @return the usuarioxlnet
	 */
	public String getUsuarioxlnet() {
		return usuarioxlnet;
	}

	/**
	 * @param usuarioxlnet
	 *            the usuarioxlnet to set
	 */
	public void setUsuarioxlnet(String usuarioxlnet) {
		this.usuarioxlnet = usuarioxlnet;
	}

	/**
	 * @return the puestoxlnet
	 */
	public String getPuestoxlnet() {
		return puestoxlnet;
	}

	/**
	 * @param puestoxlnet
	 *            the puestoxlnet to set
	 */
	public void setPuestoxlnet(String puestoxlnet) {
		this.puestoxlnet = puestoxlnet;
	}

	/**
	 * Method 'getMofecbaja'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getMofecbaja() {
		return this.mofecbaja;
	}

	/**
	 * Method 'setMofecbaja'.
	 * 
	 * @param mofecbaja
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setMofecbaja(Date mofecbaja) {
		this.mofecbaja = mofecbaja;
	}

	/**
	 * @return the perfilSolicitudes
	 */
	public Perfil getPerfilSolicitudes() {
		return perfilSolicitudes;
	}

	/**
	 * @param perfilSolicitudes
	 *            the perfilSolicitudes to set
	 */
	public void setPerfilSolicitudes(Perfil perfilSolicitudes) {
		this.perfilSolicitudes = perfilSolicitudes;
	}

	/**
	 * @return the perfilSanciones
	 */
	public Perfil getPerfilSanciones() {
		return perfilSanciones;
	}

	/**
	 * @param perfilSanciones
	 *            the perfilSanciones to set
	 */
	public void setPerfilSanciones(Perfil perfilSanciones) {
		this.perfilSanciones = perfilSanciones;
	}

	/**
	 * @return the perfilInspecciones
	 */
	public Perfil getPerfilInspecciones() {
		return perfilInspecciones;
	}

	/**
	 * @param perfilInspecciones
	 *            the perfilInspecciones to set
	 */
	public void setPerfilInspecciones(Perfil perfilInspecciones) {
		this.perfilInspecciones = perfilInspecciones;
	}

	/**
	 * @return the perfilArbitraje
	 */
	public Perfil getPerfilArbitraje() {
		return perfilArbitraje;
	}

	/**
	 * @param perfilArbitraje
	 *            the perfilArbitraje to set
	 */
	public void setPerfilArbitraje(Perfil perfilArbitraje) {
		this.perfilArbitraje = perfilArbitraje;
	}

	/**
	 * @return the perfilOrganizacion
	 */
	public Perfil getPerfilOrganizacion() {
		return perfilOrganizacion;
	}

	/**
	 * @param perfilOrganizacion
	 *            the perfilOrganizacion to set
	 */
	public void setPerfilOrganizacion(Perfil perfilOrganizacion) {
		this.perfilOrganizacion = perfilOrganizacion;
	}

	/**
	 * @return the perfilMaestros
	 */
	public Perfil getPerfilMaestros() {
		return perfilMaestros;
	}

	/**
	 * @param perfilMaestros
	 *            the perfilMaestros to set
	 */
	public void setPerfilMaestros(Perfil perfilMaestros) {
		this.perfilMaestros = perfilMaestros;
	}

	/**
	 * @return the perfilEconomico
	 */
	public Perfil getPerfilEconomico() {
		return perfilEconomico;
	}

	/**
	 * @param perfilEconomico
	 *            the perfilEconomico to set
	 */
	public void setPerfilEconomico(Perfil perfilEconomico) {
		this.perfilEconomico = perfilEconomico;
	}

	/**
	 * @return the consultas
	 */
	public List<Consulta> getConsultas() {
		return consultas;
	}

	/**
	 * @param consultas
	 *            the consultas to set
	 */
	public void setConsultas(List<Consulta> consultas) {
		this.consultas = consultas;
	}

	/**
	 * @return the establecimientos
	 */
	public List<Establecimiento> getEstablecimientos() {
		return establecimientos;
	}

	/**
	 * @param establecimientos
	 *            the establecimientos to set
	 */
	public void setEstablecimientos(List<Establecimiento> establecimientos) {
		this.establecimientos = establecimientos;
	}

	/**
	 * @return the consumidors
	 */
	public List<Consumidor> getConsumidors() {
		return consumidors;
	}

	/**
	 * @param consumidors
	 *            the consumidors to set
	 */
	public void setConsumidors(List<Consumidor> consumidors) {
		this.consumidors = consumidors;
	}

	/**
	 * @return the modni
	 */
	public String getModni() {
		return Y41bUtils.upperCase(this.modni);
	}

	/**
	 * @param modni
	 *            the modni to set
	 */
	public void setModni(String modni) {
		this.modni = Y41bUtils.upperCase(modni);
	}

	/**
	 * @return the perfilConsultas
	 */
	public Perfil getPerfilConsultas() {
		return perfilConsultas;
	}

	/**
	 * @param perfilConsultas
	 *            the perfilConsultas to set
	 */
	public void setPerfilConsultas(Perfil perfilConsultas) {
		this.perfilConsultas = perfilConsultas;
	}

	/**
	 * @return the mobopvboe
	 */
	public String getMobopvboe() {
		return mobopvboe;
	}

	/**
	 * @param mobopvboe
	 *            the mobopvboe to set
	 */
	public void setMobopvboe(String mobopvboe) {
		this.mobopvboe = mobopvboe;
	}

	/**
	 * @return the mofecbajaDesde
	 */
	public String getMofecbajaDesde() {
		return mofecbajaDesde;
	}

	/**
	 * @param mofecbajaDesde
	 *            the mofecbajaDesde to set
	 */
	public void setMofecbajaDesde(String mofecbajaDesde) {
		this.mofecbajaDesde = mofecbajaDesde;
	}

	/**
	 * @return the mobandejadefecto
	 */
	public String getMobandejadefecto() {
		return mobandejadefecto;
	}

	/**
	 * @param mobandejadefecto
	 *            the mobandejadefecto to set
	 */
	public void setMobandejadefecto(String mobandejadefecto) {
		this.mobandejadefecto = mobandejadefecto;
	}

	/**
	 * @return the indIncluirBaja
	 */
	public String getIndIncluirBaja() {
		return indIncluirBaja;
	}

	/**
	 * @param indIncluirBaja
	 *            the indIncluirBaja to set
	 */
	public void setIndIncluirBaja(String indIncluirBaja) {
		this.indIncluirBaja = indIncluirBaja;
	}

	/**
	 * @return the moadmiliquidacion
	 */
	public String getMoadmiliquidacion() {
		return moadmiliquidacion;
	}

	/**
	 * @param moadmiliquidacion
	 *            the moadmiliquidacion to set
	 */
	public void setMoadmiliquidacion(String moadmiliquidacion) {
		this.moadmiliquidacion = moadmiliquidacion;
	}

	/**
	 * @return the mopagolaudo
	 */
	public String getMopagolaudo() {
		return mopagolaudo;
	}

	/**
	 * @param mopagolaudo
	 *            the mopagolaudo to set
	 */
	public void setMopagolaudo(String mopagolaudo) {
		this.mopagolaudo = mopagolaudo;
	}

	/**
	 * @return the moadmidenunciaempresas
	 */
	public String getMoadmidenunciaempresas() {
		return moadmidenunciaempresas;
	}

	/**
	 * @param moadmidenunciaempresas
	 *            the moadmidenunciaempresas to set
	 */
	public void setMoadmidenunciaempresas(String moadmidenunciaempresas) {
		this.moadmidenunciaempresas = moadmidenunciaempresas;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "CensoMonitor [mocodigo=" + mocodigo + ", organismo="
				+ organismo + ", monombre=" + monombre + ", mocoem=" + mocoem
				+ ", usuarioxlnet=" + usuarioxlnet + ", puestoxlnet="
				+ puestoxlnet + ", modni=" + modni + ", mofecbaja=" + mofecbaja
				+ ", mofecbajaDesde=" + mofecbajaDesde + ", perfilSolicitudes="
				+ perfilSolicitudes + ", perfilSanciones=" + perfilSanciones
				+ ", perfilInspecciones=" + perfilInspecciones
				+ ", perfilArbitraje=" + perfilArbitraje
				+ ", perfilOrganizacion=" + perfilOrganizacion
				+ ", perfilMaestros=" + perfilMaestros + ", perfilEconomico="
				+ perfilEconomico + ", perfilConsultas=" + perfilConsultas
				+ ", mobopvboe=" + mobopvboe + ", mobandejadefecto="
				+ mobandejadefecto + ", moadmiliquidacion=" + moadmiliquidacion
				+ ", mopagolaudo=" + mopagolaudo + ", moadmidenunciaempresas="
				+ moadmidenunciaempresas + ", indIncluirBaja=" + indIncluirBaja
				+ ", consultas=" + consultas + ", establecimientos="
				+ establecimientos + ", consumidors=" + consumidors + "]";
	}

}
