package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * CampanhaProgramacion  
 * 
 *  
 */

public class CampanhaProgramacion implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String pgcodigo;
	private Campanha campanha;
	private String pgnombre;
	private String pgcotpg;
	private Date pgfedesd;
	private Date pgfehast;
	private String pgcoor;
	private String pginsese;
	private Integer pgnumTomasMuestrasSol;
	private Integer pgnumControlesEstandarSol;
	private Integer pgnumControlesOtrosSol;
	private String pgfase;
	private Integer pgnumInspecAdicionalesSol;
	private List<BandejaCampanha> bandejaCampanhas = new ArrayList<BandejaCampanha>();

	private String pgprogramaciondesc;
	private String pgprogramaciondesce;

	/**
	 * Method 'CampanhaProgramacion'.
	 */
	public CampanhaProgramacion() {
	}

	/**
	 * Method 'CampanhaProgramacion'.
	 * 
	 * @param pgcodigo
	 *            String
	 */
	public CampanhaProgramacion(String pgcodigo) {
		this.pgcodigo = pgcodigo;
	}

	/**
	 * Method 'CampanhaProgramacion'.
	 * 
	 * @param pgcodigo
	 *            String
	 * @param pgnombre
	 *            String
	 * @param pgcotpg
	 *            String
	 * @param pgfedesd
	 *            Date
	 * @param pgfehast
	 *            Date
	 * @param pgcoor
	 *            String
	 * @param pginsese
	 *            String
	 * @param pgnumTomasMuestrasSol
	 *            Integer
	 * @param pgnumControlesEstandarSol
	 *            Integer
	 * @param pgnumControlesOtrosSol
	 *            Integer
	 * @param pgnumInspecAdicionalesSol
	 *            Integer
	 * @param campanha
	 *            Campanha
	 */
	public CampanhaProgramacion(String pgcodigo, String pgnombre, String pgcotpg, Date pgfedesd, Date pgfehast,
			String pgcoor, String pginsese, Integer pgnumTomasMuestrasSol, Integer pgnumControlesEstandarSol,
			Integer pgnumControlesOtrosSol, Integer pgnumInspecAdicionalesSol, Campanha campanha) {
		this.pgcodigo = pgcodigo;
		this.campanha = campanha;
		this.pgnombre = pgnombre;
		this.pgcotpg = pgcotpg;
		this.pgfedesd = pgfedesd;
		this.pgfehast = pgfehast;
		this.pgcoor = pgcoor;
		this.pginsese = pginsese;
		this.pgnumTomasMuestrasSol = pgnumTomasMuestrasSol;
		this.pgnumControlesEstandarSol = pgnumControlesEstandarSol;
		this.pgnumControlesOtrosSol = pgnumControlesOtrosSol;
		this.pgnumInspecAdicionalesSol = pgnumInspecAdicionalesSol;
	}

	/**
	 * Method 'CampanhaProgramacion'.
	 * 
	 * @param pgfedesd
	 *            Date
	 * @param pgfehast
	 *            Date
	 */
	public CampanhaProgramacion(Date pgfedesd, Date pgfehast) {
		this.pgfedesd = pgfedesd;
		this.pgfehast = pgfehast;
	}

	/**
	 * Method 'CampanhaProgramacion'.
	 * 
	 * @param pgcodigo
	 *            String
	 * @param pgnombre
	 *            String
	 * @param pgcotpg
	 *            String
	 * @param pgfedesd
	 *            Date
	 * @param pgfehast
	 *            Date
	 * @param pgcoor
	 *            String
	 * @param pginsese
	 *            String
	 * @param pgnumTomasMuestrasSol
	 *            Integer
	 * @param pgnumControlesEstandarSol
	 *            Integer
	 * @param pgnumControlesOtrosSol
	 *            Integer
	 * @param pgnumInspecAdicionalesSol
	 *            Integer
	 * @param campanha
	 *            Campanha
	 * @param bandejaCampanhas
	 *            List<BandejaCampanha>
	 */
	public CampanhaProgramacion(String pgcodigo, String pgnombre, String pgcotpg, Date pgfedesd, Date pgfehast,
			String pgcoor, String pginsese, Integer pgnumTomasMuestrasSol, Integer pgnumControlesEstandarSol,
			Integer pgnumControlesOtrosSol, Integer pgnumInspecAdicionalesSol, Campanha campanha,
			List<BandejaCampanha> bandejaCampanhas) {

		this.pgcodigo = pgcodigo;
		this.campanha = campanha;
		this.pgnombre = pgnombre;
		this.pgcotpg = pgcotpg;
		this.pgfedesd = pgfedesd;
		this.pgfehast = pgfehast;
		this.pgcoor = pgcoor;
		this.pginsese = pginsese;
		this.pgnumTomasMuestrasSol = pgnumTomasMuestrasSol;
		this.pgnumControlesEstandarSol = pgnumControlesEstandarSol;
		this.pgnumControlesOtrosSol = pgnumControlesOtrosSol;
		this.pgnumInspecAdicionalesSol = pgnumInspecAdicionalesSol;
		this.bandejaCampanhas = bandejaCampanhas;
	}

	/**
	 * Method 'getPgcodigo'.
	 * 
	 * @return String
	 */

	public String getPgcodigo() {
		return this.pgcodigo;
	}

	/**
	 * Method 'setPgcodigo'.
	 * 
	 * @param pgcodigo
	 *            String
	 * @return
	 */

	public void setPgcodigo(String pgcodigo) {
		this.pgcodigo = pgcodigo;
	}

	/**
	 * Method 'getCampanha'.
	 * 
	 * @return Campanha
	 */
	@JsonIgnore
	public Campanha getCampanha() {
		return this.campanha;
	}

	/**
	 * Method 'setCampanha'.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return
	 */

	public void setCampanha(Campanha campanha) {
		this.campanha = campanha;
	}

	/**
	 * Method 'getPgnombre'.
	 * 
	 * @return String
	 */

	public String getPgnombre() {
		return this.pgnombre;
	}

	/**
	 * Method 'setPgnombre'.
	 * 
	 * @param pgnombre
	 *            String
	 * @return
	 */

	public void setPgnombre(String pgnombre) {
		this.pgnombre = pgnombre;
	}

	/**
	 * Method 'getPgcotpg'.
	 * 
	 * @return String
	 */

	public String getPgcotpg() {
		return this.pgcotpg;
	}

	/**
	 * Method 'setPgcotpg'.
	 * 
	 * @param pgcotpg
	 *            String
	 * @return
	 */

	public void setPgcotpg(String pgcotpg) {
		this.pgcotpg = pgcotpg;
	}

	/**
	 * Method 'getPgfedesd'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getPgfedesd() {
		return this.pgfedesd;
	}

	/**
	 * Method 'setPgfedesd'.
	 * 
	 * @param pgfedesd
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setPgfedesd(Date pgfedesd) {
		this.pgfedesd = pgfedesd;
	}

	/**
	 * Method 'getPgfehast'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getPgfehast() {
		return this.pgfehast;
	}

	/**
	 * Method 'setPgfehast'.
	 * 
	 * @param pgfehast
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setPgfehast(Date pgfehast) {
		this.pgfehast = pgfehast;
	}

	/**
	 * Method 'getPgcoor'.
	 * 
	 * @return String
	 */

	public String getPgcoor() {
		return this.pgcoor;
	}

	/**
	 * Method 'setPgcoor'.
	 * 
	 * @param pgcoor
	 *            String
	 * @return
	 */

	public void setPgcoor(String pgcoor) {
		this.pgcoor = pgcoor;
	}

	/**
	 * Method 'getPginsese'.
	 * 
	 * @return String
	 */

	public String getPginsese() {
		return this.pginsese;
	}

	/**
	 * Method 'setPginsese'.
	 * 
	 * @param pginsese
	 *            String
	 * @return
	 */

	public void setPginsese(String pginsese) {
		this.pginsese = pginsese;
	}

	/**
	 * Method 'getPgnumTomasMuestrasSol'.
	 * 
	 * @return Integer
	 */

	public Integer getPgnumTomasMuestrasSol() {
		return this.pgnumTomasMuestrasSol;
	}

	/**
	 * Method 'setPgnumTomasMuestrasSol'.
	 * 
	 * @param pgnumTomasMuestrasSol
	 *            Integer
	 * @return
	 */

	public void setPgnumTomasMuestrasSol(Integer pgnumTomasMuestrasSol) {
		this.pgnumTomasMuestrasSol = pgnumTomasMuestrasSol;
	}

	/**
	 * Method 'getPgnumControlesEstandarSol'.
	 * 
	 * @return Integer
	 */

	public Integer getPgnumControlesEstandarSol() {
		return this.pgnumControlesEstandarSol;
	}

	/**
	 * Method 'setPgnumControlesEstandarSol'.
	 * 
	 * @param pgnumControlesEstandarSol
	 *            Integer
	 * @return
	 */

	public void setPgnumControlesEstandarSol(Integer pgnumControlesEstandarSol) {
		this.pgnumControlesEstandarSol = pgnumControlesEstandarSol;
	}

	/**
	 * Method 'getPgnumControlesOtrosSol'.
	 * 
	 * @return Integer
	 */

	public Integer getPgnumControlesOtrosSol() {
		return this.pgnumControlesOtrosSol;
	}

	/**
	 * Method 'setPgnumControlesOtrosSol'.
	 * 
	 * @param pgnumControlesOtrosSol
	 *            Integer
	 * @return
	 */

	public void setPgnumControlesOtrosSol(Integer pgnumControlesOtrosSol) {
		this.pgnumControlesOtrosSol = pgnumControlesOtrosSol;
	}

	/**
	 * Method 'getPgfase'.
	 * 
	 * @return String
	 */

	public String getPgfase() {
		return this.pgfase;
	}

	/**
	 * Method 'setPgfase'.
	 * 
	 * @param pgfase
	 *            String
	 * @return
	 */

	public void setPgfase(String pgfase) {
		this.pgfase = pgfase;
	}

	/**
	 * Method 'getPgnumInspecAdicionalesSol'.
	 * 
	 * @return Integer
	 */

	public Integer getPgnumInspecAdicionalesSol() {
		return this.pgnumInspecAdicionalesSol;
	}

	/**
	 * Method 'setPgnumInspecAdicionalesSol'.
	 * 
	 * @param pgnumInspecAdicionalesSol
	 *            Integer
	 * @return
	 */

	public void setPgnumInspecAdicionalesSol(Integer pgnumInspecAdicionalesSol) {
		this.pgnumInspecAdicionalesSol = pgnumInspecAdicionalesSol;
	}

	/**
	 * Method 'getBandejaCampanhas'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<BandejaCampanha> getBandejaCampanhas() {
		return this.bandejaCampanhas;
	}

	/**
	 * Method 'setBandejaCampanhas'.
	 * 
	 * @param bandejaCampanhas
	 *            List
	 * @return
	 */
	public void setBandejaCampanhas(List<BandejaCampanha> bandejaCampanhas) {
		this.bandejaCampanhas = bandejaCampanhas;
	}

	/**
	 * @return the pgprogramaciondesc
	 */
	public String getPgprogramaciondesc() {
		return pgprogramaciondesc;
	}

	/**
	 * @param pgprogramaciondesc
	 *            the pgprogramaciondesc to set
	 */
	public void setPgprogramaciondesc(String pgprogramaciondesc) {
		this.pgprogramaciondesc = pgprogramaciondesc;
	}

	/**
	 * @return the pgprogramaciondesce
	 */
	public String getPgprogramaciondesce() {
		return pgprogramaciondesce;
	}

	/**
	 * @param pgprogramaciondesce
	 *            the pgprogramaciondesce to set
	 */
	public void setPgprogramaciondesce(String pgprogramaciondesce) {
		this.pgprogramaciondesce = pgprogramaciondesce;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ pgcodigo: ").append(this.pgcodigo).append(" ]");
		result.append(", [ pgnombre: ").append(this.pgnombre).append(" ]");
		result.append(", [ pgcotpg: ").append(this.pgcotpg).append(" ]");
		result.append(", [ pgfedesd: ").append(this.pgfedesd).append(" ]");
		result.append(", [ pgfehast: ").append(this.pgfehast).append(" ]");
		result.append(", [ pgcoor: ").append(this.pgcoor).append(" ]");
		result.append(", [ pginsese: ").append(this.pginsese).append(" ]");
		result.append(", [ pgnumTomasMuestrasSol: ").append(this.pgnumTomasMuestrasSol).append(" ]");
		result.append(", [ pgnumControlesEstandarSol: ").append(this.pgnumControlesEstandarSol).append(" ]");
		result.append(", [ pgnumControlesOtrosSol: ").append(this.pgnumControlesOtrosSol).append(" ]");
		result.append(", [ pgfase: ").append(this.pgfase).append(" ]");
		result.append(", [ pgnumInspecAdicionalesSol: ").append(this.pgnumInspecAdicionalesSol).append(" ]");
		result.append("}");
		return result.toString();
	}

}
