package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Campanha  
 * 
 *  
 */

public class Campanha implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String cmcodigo;
	private String cmnombre;
	private String cmcops;
	private String cmcopsdesc;
	private String cmnoar;
	private String cmnops;
	private String cmcotmo;
	private String cmorigen;
	private String cmtipo;
	private String cmcaracter;
	private Date cmfechainicio;
	private Date cmfechainicioDesde;
	private Date cmfechainicioHasta;
	private Date cmfechacierre;
	private Date cmfechacierreDesde;
	private Date cmfechacierreHasta;
	private String cmactiva;
	private String cmfase;
	private String cmonline;

	private String cmincluircerradas;
	private String cmincluirnoactivas;

	private String cmfechainicioDesdeStr;
	private String cmfechainicioHastaStr;
	private String cmfechacierreDesdeStr;
	private String cmfechacierreHastaStr;

	private Date cmfeciniborrador;
	private Date cmfecfinborrador;
	private Date cmfecinivalidacion;
	private Date cmfecfinvalidacion;

	private String cminiciarcampanha;

	// Protocolo
	private String tpcodigo;

	private List<TipProtocolo> tipProtocolos = new ArrayList<TipProtocolo>();
	private List<CampanhaProgramacion> campanhaProgramacions = new ArrayList<CampanhaProgramacion>();
	private List<CampanhaProd> campanhaProds = new ArrayList<CampanhaProd>();
	private List<BandejaCampanha> bandejaCampanhas = new ArrayList<BandejaCampanha>();
	private List<TipProtocolo> tipProtocolos_1 = new ArrayList<TipProtocolo>();

	/**
	 * Method 'Campanha'.
	 */
	public Campanha() {
	}

	/**
	 * Method 'Campanha'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @param cmnombre
	 *            String
	 * @param cmcops
	 *            String
	 * @param cmnoar
	 *            String
	 * @param cmnops
	 *            String
	 * @param cmcotmo
	 *            String
	 * @param cmorigen
	 *            String
	 * @param cmtipo
	 *            String
	 * @param cmcaracter
	 *            String
	 * @param cmfechainicio
	 *            Date
	 * @param cmfechacierre
	 *            Date
	 * @param cmactiva
	 *            String
	 * @param cmonline
	 *            String
	 * @param cmfeciniborrador
	 *            Date
	 * @param cmfecfinborrador
	 *            Date
	 * @param cmfecinivalidacion
	 *            Date
	 * @param cmfecfinvalidacion
	 *            Date
	 */
	public Campanha(String cmcodigo, String cmnombre, String cmcops, String cmnoar, String cmnops, String cmcotmo,
			String cmorigen, String cmtipo, String cmcaracter, Date cmfechainicio, Date cmfechacierre, String cmactiva,
			String cmonline, Date cmfeciniborrador, Date cmfecfinborrador, Date cmfecinivalidacion,
			Date cmfecfinvalidacion) {
		this.cmcodigo = cmcodigo;
		this.cmnombre = cmnombre;
		this.cmcops = cmcops;
		this.cmnoar = cmnoar;
		this.cmnops = cmnops;
		this.cmcotmo = cmcotmo;
		this.cmorigen = cmorigen;
		this.cmtipo = cmtipo;
		this.cmcaracter = cmcaracter;
		this.cmfechainicio = cmfechainicio;
		this.cmfechacierre = cmfechacierre;
		this.cmactiva = cmactiva;
		this.cmonline = cmonline;
		this.cmfeciniborrador = cmfeciniborrador;
		this.cmfecfinborrador = cmfecfinborrador;
		this.cmfecinivalidacion = cmfecinivalidacion;
		this.cmfecfinvalidacion = cmfecfinvalidacion;
	}

	/**
	 * Method 'Campanha'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @param cmnombre
	 *            String
	 * @param cmcops
	 *            String
	 * @param cmnoar
	 *            String
	 * @param cmnops
	 *            String
	 * @param cmcotmo
	 *            String
	 * @param cmorigen
	 *            String
	 * @param cmtipo
	 *            String
	 * @param cmcaracter
	 *            String
	 * @param cmfechainicio
	 *            Date
	 * @param cmfechacierre
	 *            Date
	 * @param cmactiva
	 *            String
	 * @param cmonline
	 *            String
	 * @param tipProtocolos
	 *            List<TipProtocolo>
	 * @param campanhaProgramacions
	 *            List<CampanhaProgramacion>
	 * @param campanhaProds
	 *            List<CampanhaProd>
	 * @param bandejaCampanhas
	 *            List<BandejaCampanha>
	 * @param tipProtocolos_1
	 *            List<TipProtocolo>
	 * @param cmfeciniborrador
	 *            Date
	 * @param cmfecfinborrador
	 *            Date
	 * @param cmfecinivalidacion
	 *            Date
	 * @param cmfecfinvalidacion
	 *            Date
	 */
	public Campanha(String cmcodigo, String cmnombre, String cmcops, String cmnoar, String cmnops, String cmcotmo,
			String cmorigen, String cmtipo, String cmcaracter, Date cmfechainicio, Date cmfechacierre, String cmactiva,
			String cmonline, List<TipProtocolo> tipProtocolos, List<CampanhaProgramacion> campanhaProgramacions,
			List<CampanhaProd> campanhaProds, List<BandejaCampanha> bandejaCampanhas,
			List<TipProtocolo> tipProtocolos_1, Date cmfeciniborrador, Date cmfecfinborrador, Date cmfecinivalidacion,
			Date cmfecfinvalidacion) {

		this.cmcodigo = cmcodigo;
		this.cmnombre = cmnombre;
		this.cmcops = cmcops;
		this.cmnoar = cmnoar;
		this.cmnops = cmnops;
		this.cmcotmo = cmcotmo;
		this.cmorigen = cmorigen;
		this.cmtipo = cmtipo;
		this.cmcaracter = cmcaracter;
		this.cmfechainicio = cmfechainicio;
		this.cmfechacierre = cmfechacierre;
		this.cmactiva = cmactiva;
		this.cmonline = cmonline;
		this.tipProtocolos = tipProtocolos;
		this.campanhaProgramacions = campanhaProgramacions;
		this.campanhaProds = campanhaProds;
		this.bandejaCampanhas = bandejaCampanhas;
		this.tipProtocolos_1 = tipProtocolos_1;
		this.cmfeciniborrador = cmfeciniborrador;
		this.cmfecfinborrador = cmfecfinborrador;
		this.cmfecinivalidacion = cmfecinivalidacion;
		this.cmfecfinvalidacion = cmfecfinvalidacion;
	}

	/**
	 * Method 'getCmcodigo'.
	 * 
	 * @return String
	 */

	public String getCmcodigo() {
		return this.cmcodigo;
	}

	/**
	 * Method 'setCmcodigo'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @return
	 */

	public void setCmcodigo(String cmcodigo) {
		this.cmcodigo = cmcodigo;
	}

	/**
	 * Method 'getCmnombre'.
	 * 
	 * @return String
	 */

	public String getCmnombre() {
		return this.cmnombre;
	}

	/**
	 * Method 'setCmnombre'.
	 * 
	 * @param cmnombre
	 *            String
	 * @return
	 */

	public void setCmnombre(String cmnombre) {
		this.cmnombre = cmnombre;
	}

	/**
	 * Method 'getCmcops'.
	 * 
	 * @return String
	 */

	public String getCmcops() {
		return this.cmcops;
	}

	/**
	 * Method 'setCmcops'.
	 * 
	 * @param cmcops
	 *            String
	 * @return
	 */

	public void setCmcops(String cmcops) {
		this.cmcops = cmcops;
	}

	/**
	 * Method 'getCmnoar'.
	 * 
	 * @return String
	 */

	public String getCmnoar() {
		return this.cmnoar;
	}

	/**
	 * Method 'setCmnoar'.
	 * 
	 * @param cmnoar
	 *            String
	 * @return
	 */

	public void setCmnoar(String cmnoar) {
		this.cmnoar = cmnoar;
	}

	/**
	 * Method 'getCmnops'.
	 * 
	 * @return String
	 */

	public String getCmnops() {
		return this.cmnops;
	}

	/**
	 * Method 'setCmnops'.
	 * 
	 * @param cmnops
	 *            String
	 * @return
	 */

	public void setCmnops(String cmnops) {
		this.cmnops = cmnops;
	}

	/**
	 * Method 'getCmcotmo'.
	 * 
	 * @return String
	 */

	public String getCmcotmo() {
		return this.cmcotmo;
	}

	/**
	 * Method 'setCmcotmo'.
	 * 
	 * @param cmcotmo
	 *            String
	 * @return
	 */

	public void setCmcotmo(String cmcotmo) {
		this.cmcotmo = cmcotmo;
	}

	/**
	 * Method 'getCmorigen'.
	 * 
	 * @return String
	 */

	public String getCmorigen() {
		return this.cmorigen;
	}

	/**
	 * Method 'setCmorigen'.
	 * 
	 * @param cmorigen
	 *            String
	 * @return
	 */

	public void setCmorigen(String cmorigen) {
		this.cmorigen = cmorigen;
	}

	/**
	 * Method 'getCmtipo'.
	 * 
	 * @return String
	 */

	public String getCmtipo() {
		return this.cmtipo;
	}

	/**
	 * Method 'setCmtipo'.
	 * 
	 * @param cmtipo
	 *            String
	 * @return
	 */

	public void setCmtipo(String cmtipo) {
		this.cmtipo = cmtipo;
	}

	/**
	 * Method 'getCmfechainicio'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCmfechainicio() {
		return this.cmfechainicio;
	}

	/**
	 * Method 'setCmfechainicio'.
	 * 
	 * @param cmfechainicio
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCmfechainicio(Date cmfechainicio) {
		this.cmfechainicio = cmfechainicio;
	}

	/**
	 * Method 'getCmfechacierre'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCmfechacierre() {
		return this.cmfechacierre;
	}

	/**
	 * Method 'setCmfechacierre'.
	 * 
	 * @param cmfechacierre
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCmfechacierre(Date cmfechacierre) {
		this.cmfechacierre = cmfechacierre;
	}

	/**
	 * Method 'getCmactiva'.
	 * 
	 * @return String
	 */

	public String getCmactiva() {
		return this.cmactiva;
	}

	/**
	 * Method 'setCmactiva'.
	 * 
	 * @param cmactiva
	 *            String
	 * @return
	 */

	public void setCmactiva(String cmactiva) {
		this.cmactiva = cmactiva;
	}

	/**
	 * Method 'getCmfase'.
	 * 
	 * @return String
	 */

	public String getCmfase() {
		return this.cmfase;
	}

	/**
	 * Method 'setCmfase'.
	 * 
	 * @param cmfase
	 *            String
	 * @return
	 */

	public void setCmfase(String cmfase) {
		this.cmfase = cmfase;
	}

	/**
	 * Method 'getTipProtocolos'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<TipProtocolo> getTipProtocolos() {
		return this.tipProtocolos;
	}

	/**
	 * Method 'setTipProtocolos'.
	 * 
	 * @param tipProtocolos
	 *            List
	 * @return
	 */
	public void setTipProtocolos(List<TipProtocolo> tipProtocolos) {
		this.tipProtocolos = tipProtocolos;
	}

	/**
	 * Method 'getCampanhaProgramacions'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<CampanhaProgramacion> getCampanhaProgramacions() {
		return this.campanhaProgramacions;
	}

	/**
	 * Method 'setCampanhaProgramacions'.
	 * 
	 * @param campanhaProgramacions
	 *            List
	 * @return
	 */
	public void setCampanhaProgramacions(List<CampanhaProgramacion> campanhaProgramacions) {
		this.campanhaProgramacions = campanhaProgramacions;
	}

	/**
	 * Method 'getCampanhaProds'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<CampanhaProd> getCampanhaProds() {
		return this.campanhaProds;
	}

	/**
	 * Method 'setCampanhaProds'.
	 * 
	 * @param campanhaProds
	 *            List
	 * @return
	 */
	public void setCampanhaProds(List<CampanhaProd> campanhaProds) {
		this.campanhaProds = campanhaProds;
	}

	/**
	 * Method 'getBandejaCampanhas'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<BandejaCampanha> getBandejaCampanhas() {
		return this.bandejaCampanhas;
	}

	/**
	 * Method 'setBandejaCampanhas'.
	 * 
	 * @param bandejaCampanhas
	 *            List
	 * @return
	 */
	public void setBandejaCampanhas(List<BandejaCampanha> bandejaCampanhas) {
		this.bandejaCampanhas = bandejaCampanhas;
	}

	/**
	 * Method 'getTipProtocolos_1'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<TipProtocolo> getTipProtocolos_1() {
		return this.tipProtocolos_1;
	}

	/**
	 * Method 'setTipProtocolos_1'.
	 * 
	 * @param tipProtocolos_1
	 *            List
	 * @return
	 */
	public void setTipProtocolos_1(List<TipProtocolo> tipProtocolos_1) {
		this.tipProtocolos_1 = tipProtocolos_1;
	}

	/**
	 * @return the cmfechainicioDesde
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCmfechainicioDesde() {
		return cmfechainicioDesde;
	}

	/**
	 * @param cmfechainicioDesde
	 *            the cmfechainicioDesde to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCmfechainicioDesde(Date cmfechainicioDesde) {
		this.cmfechainicioDesde = cmfechainicioDesde;
	}

	/**
	 * @return the cmfechainicioHasta
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCmfechainicioHasta() {
		return cmfechainicioHasta;
	}

	/**
	 * @param cmfechainicioHasta
	 *            the cmfechainicioHasta to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCmfechainicioHasta(Date cmfechainicioHasta) {
		this.cmfechainicioHasta = cmfechainicioHasta;
	}

	/**
	 * @return the cmfechacierreDesde
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCmfechacierreDesde() {
		return cmfechacierreDesde;
	}

	/**
	 * @param cmfechacierreDesde
	 *            the cmfechacierreDesde to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCmfechacierreDesde(Date cmfechacierreDesde) {
		this.cmfechacierreDesde = cmfechacierreDesde;
	}

	/**
	 * @return the cmfechacierreHasta
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCmfechacierreHasta() {
		return cmfechacierreHasta;
	}

	/**
	 * @param cmfechacierreHasta
	 *            the cmfechacierreHasta to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCmfechacierreHasta(Date cmfechacierreHasta) {
		this.cmfechacierreHasta = cmfechacierreHasta;
	}

	/**
	 * @return the cmincluircerradas
	 */
	public String getCmincluircerradas() {
		return cmincluircerradas;
	}

	/**
	 * @param cmincluircerradas
	 *            the cmincluircerradas to set
	 */
	public void setCmincluircerradas(String cmincluircerradas) {
		this.cmincluircerradas = cmincluircerradas;
	}

	/**
	 * @return the cmfechainicioDesdeStr
	 */
	public String getCmfechainicioDesdeStr() {
		return cmfechainicioDesdeStr;
	}

	/**
	 * @param cmfechainicioDesdeStr
	 *            the cmfechainicioDesdeStr to set
	 */
	public void setCmfechainicioDesdeStr(String cmfechainicioDesdeStr) {
		this.cmfechainicioDesdeStr = cmfechainicioDesdeStr;
	}

	/**
	 * @return the cmfechainicioHastaStr
	 */
	public String getCmfechainicioHastaStr() {
		return cmfechainicioHastaStr;
	}

	/**
	 * @param cmfechainicioHastaStr
	 *            the cmfechainicioHastaStr to set
	 */
	public void setCmfechainicioHastaStr(String cmfechainicioHastaStr) {
		this.cmfechainicioHastaStr = cmfechainicioHastaStr;
	}

	/**
	 * @return the cmfechacierreDesdeStr
	 */
	public String getCmfechacierreDesdeStr() {
		return cmfechacierreDesdeStr;
	}

	/**
	 * @param cmfechacierreDesdeStr
	 *            the cmfechacierreDesdeStr to set
	 */
	public void setCmfechacierreDesdeStr(String cmfechacierreDesdeStr) {
		this.cmfechacierreDesdeStr = cmfechacierreDesdeStr;
	}

	/**
	 * @return the cmfechacierreHastaStr
	 */
	public String getCmfechacierreHastaStr() {
		return cmfechacierreHastaStr;
	}

	/**
	 * @param cmfechacierreHastaStr
	 *            the cmfechacierreHastaStr to set
	 */
	public void setCmfechacierreHastaStr(String cmfechacierreHastaStr) {
		this.cmfechacierreHastaStr = cmfechacierreHastaStr;
	}

	/**
	 * @return the cminiciarcampanha
	 */
	public String getCminiciarcampanha() {
		return cminiciarcampanha;
	}

	/**
	 * @param cminiciarcampanha
	 *            the cminiciarcampanha to set
	 */
	public void setCminiciarcampanha(String cminiciarcampanha) {
		this.cminiciarcampanha = cminiciarcampanha;
	}

	/**
	 * @return the tpcodigo
	 */
	public String getTpcodigo() {
		return tpcodigo;
	}

	/**
	 * @param tpcodigo
	 *            the tpcodigo to set
	 */
	public void setTpcodigo(String tpcodigo) {
		this.tpcodigo = tpcodigo;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ cmcodigo: ").append(this.cmcodigo).append(" ]");
		result.append(", [ cmnombre: ").append(this.cmnombre).append(" ]");
		result.append(", [ cmcops: ").append(this.cmcops).append(" ]");
		result.append(", [ cmnoar: ").append(this.cmnoar).append(" ]");
		result.append(", [ cmnops: ").append(this.cmnops).append(" ]");
		result.append(", [ cmcotmo: ").append(this.cmcotmo).append(" ]");
		result.append(", [ cmorigen: ").append(this.cmorigen).append(" ]");
		result.append(", [ cmtipo: ").append(this.cmtipo).append(" ]");
		result.append(", [ cmfechainicio: ").append(this.cmfechainicio).append(" ]");
		result.append(", [ cmfechacierre: ").append(this.cmfechacierre).append(" ]");
		result.append(", [ cmactiva: ").append(this.cmactiva).append(" ]");
		result.append(", [ cmfase: ").append(this.cmfase).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the cmcopsdesc
	 */
	public String getCmcopsdesc() {
		return cmcopsdesc;
	}

	/**
	 * @param cmcopsdesc
	 *            the cmcopsdesc to set
	 */
	public void setCmcopsdesc(String cmcopsdesc) {
		this.cmcopsdesc = cmcopsdesc;
	}

	/**
	 * @return the cmincluirnoactivas
	 */
	public String getCmincluirnoactivas() {
		return cmincluirnoactivas;
	}

	/**
	 * @param cmincluirnoactivas
	 *            the cmincluirnoactivas to set
	 */
	public void setCmincluirnoactivas(String cmincluirnoactivas) {
		this.cmincluirnoactivas = cmincluirnoactivas;
	}

	/**
	 * @return the cmfeciniborrador
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCmfeciniborrador() {
		return cmfeciniborrador;
	}

	/**
	 * @param cmfeciniborrador
	 *            the cmfeciniborrador to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCmfeciniborrador(Date cmfeciniborrador) {
		this.cmfeciniborrador = cmfeciniborrador;
	}

	/**
	 * @return the cmfecfinborrador
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCmfecfinborrador() {
		return cmfecfinborrador;
	}

	/**
	 * @param cmfecfinborrador
	 *            the cmfecfinborrador to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCmfecfinborrador(Date cmfecfinborrador) {
		this.cmfecfinborrador = cmfecfinborrador;
	}

	/**
	 * @return the cmfecinivalidacion
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCmfecinivalidacion() {
		return cmfecinivalidacion;
	}

	/**
	 * @param cmfecinivalidacion
	 *            the cmfecinivalidacion to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCmfecinivalidacion(Date cmfecinivalidacion) {
		this.cmfecinivalidacion = cmfecinivalidacion;
	}

	/**
	 * @return the cmfecfinvalidacion
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCmfecfinvalidacion() {
		return cmfecfinvalidacion;
	}

	/**
	 * @param cmfecfinvalidacion
	 *            the cmfecfinvalidacion to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCmfecfinvalidacion(Date cmfecfinvalidacion) {
		this.cmfecfinvalidacion = cmfecfinvalidacion;
	}

	/**
	 * @return the cmcaracter
	 */
	public String getCmcaracter() {
		return cmcaracter;
	}

	/**
	 * @param cmcaracter
	 *            the cmcaracter to set
	 */
	public void setCmcaracter(String cmcaracter) {
		this.cmcaracter = cmcaracter;
	}

	/**
	 * @return the cmonline
	 */
	public String getCmonline() {
		return cmonline;
	}

	/**
	 * @param cmonline
	 *            the cmonline to set
	 */
	public void setCmonline(String cmonline) {
		this.cmonline = cmonline;
	}

}
