package com.ejie.y41b.model;


import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 *  * CampahnaRecib  
 *  
 */

public class CampahnaRecib  implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
            private String s4codigo;
            private Campanha campanha;
            private String s4codorganismo;
            private Date s4feccomunicacion;
            private Date s4fecfinalizacion;
            private Integer s4cantidadactuaciones;
            private List<Actuacion> actuacions = new ArrayList<Actuacion>();

	/** Method 'CampahnaRecib'.
	*
	*/
    public CampahnaRecib() {
    }
    /** Method 'CampahnaRecib'.
    * @param s4codigo String
    * @param s4codorganismo String
    * @param s4feccomunicacion Date
    * @param s4fecfinalizacion Date
    * @param s4cantidadactuaciones Integer
    * @param campanha Campanha
    */
    public CampahnaRecib(String s4codigo, String s4codorganismo, Date s4feccomunicacion, Date s4fecfinalizacion, Integer s4cantidadactuaciones , Campanha campanha) {	
        this.s4codigo = s4codigo;
        this.campanha = campanha;
        this.s4codorganismo = s4codorganismo;
        this.s4feccomunicacion = s4feccomunicacion;
        this.s4fecfinalizacion = s4fecfinalizacion;
        this.s4cantidadactuaciones = s4cantidadactuaciones;
    }

    /** Method 'CampahnaRecib'.
    * @param s4codigo String
    * @param s4codorganismo String
    * @param s4feccomunicacion Date
    * @param s4fecfinalizacion Date
    * @param s4cantidadactuaciones Integer
    * @param campanha Campanha
    * @param actuacions List<Actuacion>
    */
   public CampahnaRecib(String s4codigo, String s4codorganismo, Date s4feccomunicacion, Date s4fecfinalizacion, Integer s4cantidadactuaciones, Campanha campanha, List<Actuacion> actuacions) {	

           this.s4codigo = s4codigo;
           this.campanha = campanha;
           this.s4codorganismo = s4codorganismo;
           this.s4feccomunicacion = s4feccomunicacion;
           this.s4fecfinalizacion = s4fecfinalizacion;
           this.s4cantidadactuaciones = s4cantidadactuaciones;
           this.actuacions = actuacions;
    }

    /**
	 * Method 'getS4codigo'.
	 *
	 * @return String
	 */
	
	
	public String getS4codigo() {
		return this.s4codigo;
	}

	/**
	 * Method 'setS4codigo'.
	 *
	 * @param s4codigo String
	 * @return
     */
	
	public void setS4codigo(String s4codigo) {
		this.s4codigo = s4codigo;
	}
    /**
	 * Method 'getCampanha'.
	 *
	 * @return Campanha
	 */
	@JsonIgnore
	
	public Campanha getCampanha() {
		return this.campanha;
	}

	/**
	 * Method 'setCampanha'.
	 *
	 * @param campanha Campanha
	 * @return
     */
	
	public void setCampanha(Campanha campanha) {
		this.campanha = campanha;
	}
    /**
	 * Method 'getS4codorganismo'.
	 *
	 * @return String
	 */
	
	
	public String getS4codorganismo() {
		return this.s4codorganismo;
	}

	/**
	 * Method 'setS4codorganismo'.
	 *
	 * @param s4codorganismo String
	 * @return
     */
	
	public void setS4codorganismo(String s4codorganismo) {
		this.s4codorganismo = s4codorganismo;
	}
    /**
	 * Method 'getS4feccomunicacion'.
	 *
	 * @return Date
	 */
	
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getS4feccomunicacion() {
		return this.s4feccomunicacion;
	}

	/**
	 * Method 'setS4feccomunicacion'.
	 *
	 * @param s4feccomunicacion Date
	 * @return
     */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setS4feccomunicacion(Date s4feccomunicacion) {
		this.s4feccomunicacion = s4feccomunicacion;
	}
    /**
	 * Method 'getS4fecfinalizacion'.
	 *
	 * @return Date
	 */
	
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getS4fecfinalizacion() {
		return this.s4fecfinalizacion;
	}

	/**
	 * Method 'setS4fecfinalizacion'.
	 *
	 * @param s4fecfinalizacion Date
	 * @return
     */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setS4fecfinalizacion(Date s4fecfinalizacion) {
		this.s4fecfinalizacion = s4fecfinalizacion;
	}
    /**
	 * Method 'getS4cantidadactuaciones'.
	 *
	 * @return Integer
	 */
	
	
	public Integer getS4cantidadactuaciones() {
		return this.s4cantidadactuaciones;
	}

	/**
	 * Method 'setS4cantidadactuaciones'.
	 *
	 * @param s4cantidadactuaciones Integer
	 * @return
     */
	
	public void setS4cantidadactuaciones(Integer s4cantidadactuaciones) {
		this.s4cantidadactuaciones = s4cantidadactuaciones;
	}
	/**
	 * Method 'getActuacions'.
	 *
	 * @return List
	 */
	@JsonIgnore
	public List<Actuacion> getActuacions() {
		return this.actuacions;
	}
	
	/**
	 * Method 'setActuacions'.
	 *
	 * @param actuacions List
	 * @return
	 */
	public void setActuacions(List<Actuacion> actuacions) {
		this.actuacions = actuacions;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { " ); 
		result.append(" [ s4codigo: ").append(this.s4codigo).append(" ]");
		result.append(", [ s4codorganismo: ").append(this.s4codorganismo).append(" ]");
		result.append(", [ s4feccomunicacion: ").append(this.s4feccomunicacion).append(" ]");
		result.append(", [ s4fecfinalizacion: ").append(this.s4fecfinalizacion).append(" ]");
		result.append(", [ s4cantidadactuaciones: ").append(this.s4cantidadactuaciones).append(" ]");
		result.append("}");
		return result.toString();
	}


}

