package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * BandejaFirma  
 * 
 *  
 */

public class BandejaFirma implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idbandejafirma;
	private Fase fase;
	private String idexpediente;
	private String expediente;
	private String pcodigo;
	private String hccoor;
	private String idtramitehecho;
	private String trcodigo;
	private String codocumento;
	private String iddocumentum;
	private String nofile;
	private Date fechalimfirma;
	private String comofirma;
	private String idperfilfirma;
	private String desfile;
	// Este campo es necesario para la funcionalidad de firma de la bandeja
	private String firma;
	private String hashfile;
	private String comoasigfirma;

	private String motivorechazo;

	// Este campo contiene la ruta del pif donde se encuentra el fichero
	private String rutaPif;

	// Este campo contiene la ruta del pif donde se encuentra el fichero
	// devuelto por Giltza con la firma
	private String rutaPifFileFirma;

	/**
	 * Method 'BandejaFirma'.
	 */
	public BandejaFirma() {
	}

	/**
	 * Method 'BandejaFirma'.
	 * 
	 * @param idbandejafirma
	 *            String
	 * @param idexpediente
	 *            String
	 * @param expediente
	 *            String
	 * @param pcodigo
	 *            String
	 * @param hccoor
	 *            String
	 * @param idtramitehecho
	 *            String
	 * @param trcodigo
	 *            String
	 * @param codocumento
	 *            String
	 * @param iddocumentum
	 *            String
	 * @param nofile
	 *            String
	 * @param fechalimfirma
	 *            Date
	 * @param comofirma
	 *            String
	 * @param idperfilfirma
	 *            String
	 * @param desfile
	 *            String
	 * @param fase
	 *            Fase
	 */
	public BandejaFirma(String idbandejafirma, String idexpediente, String expediente, String pcodigo, String hccoor,
			String idtramitehecho, String trcodigo, String codocumento, String iddocumentum, String nofile,
			Date fechalimfirma, String comofirma, String idperfilfirma, String desfile, Fase fase, String hashfile) {

		this.idbandejafirma = idbandejafirma;
		this.fase = fase;
		this.idexpediente = idexpediente;
		this.expediente = expediente;
		this.pcodigo = pcodigo;
		this.hccoor = hccoor;
		this.idtramitehecho = idtramitehecho;
		this.trcodigo = trcodigo;
		this.codocumento = codocumento;
		this.iddocumentum = iddocumentum;
		this.nofile = nofile;
		this.fechalimfirma = fechalimfirma;
		this.comofirma = comofirma;
		this.idperfilfirma = idperfilfirma;
		this.desfile = desfile;
		this.hashfile = hashfile;
	}

	/**
	 * Method 'getIdbandejafirma'.
	 * 
	 * @return String
	 */

	public String getIdbandejafirma() {
		return this.idbandejafirma;
	}

	/**
	 * Method 'setIdbandejafirma'.
	 * 
	 * @param idbandejafirma
	 *            String
	 * @return
	 */

	public void setIdbandejafirma(String idbandejafirma) {
		this.idbandejafirma = idbandejafirma;
	}

	/**
	 * Method 'getFase'.
	 * 
	 * @return Fase
	 */
	@JsonIgnore
	public Fase getFase() {
		return this.fase;
	}

	/**
	 * Method 'setFase'.
	 * 
	 * @param fase
	 *            Fase
	 * @return
	 */

	public void setFase(Fase fase) {
		this.fase = fase;
	}

	/**
	 * Method 'getIdexpediente'.
	 * 
	 * @return String
	 */

	public String getIdexpediente() {
		return this.idexpediente;
	}

	/**
	 * Method 'setIdexpediente'.
	 * 
	 * @param idexpediente
	 *            String
	 * @return
	 */

	public void setIdexpediente(String idexpediente) {
		this.idexpediente = idexpediente;
	}

	/**
	 * Method 'getExpediente'.
	 * 
	 * @return String
	 */

	public String getExpediente() {
		return this.expediente;
	}

	/**
	 * Method 'setExpediente'.
	 * 
	 * @param expediente
	 *            String
	 * @return
	 */

	public void setExpediente(String expediente) {
		this.expediente = expediente;
	}

	/**
	 * Method 'getPcodigo'.
	 * 
	 * @return String
	 */

	public String getPcodigo() {
		return this.pcodigo;
	}

	/**
	 * Method 'setPcodigo'.
	 * 
	 * @param pcodigo
	 *            String
	 * @return
	 */

	public void setPcodigo(String pcodigo) {
		this.pcodigo = pcodigo;
	}

	/**
	 * Method 'getHccoor'.
	 * 
	 * @return String
	 */

	public String getHccoor() {
		return this.hccoor;
	}

	/**
	 * Method 'setHccoor'.
	 * 
	 * @param hccoor
	 *            String
	 * @return
	 */

	public void setHccoor(String hccoor) {
		this.hccoor = hccoor;
	}

	/**
	 * Method 'getIdtramitehecho'.
	 * 
	 * @return String
	 */

	public String getIdtramitehecho() {
		return this.idtramitehecho;
	}

	/**
	 * Method 'setIdtramitehecho'.
	 * 
	 * @param idtramitehecho
	 *            String
	 * @return
	 */

	public void setIdtramitehecho(String idtramitehecho) {
		this.idtramitehecho = idtramitehecho;
	}

	/**
	 * Method 'getTrcodigo'.
	 * 
	 * @return String
	 */

	public String getTrcodigo() {
		return this.trcodigo;
	}

	/**
	 * Method 'setTrcodigo'.
	 * 
	 * @param trcodigo
	 *            String
	 * @return
	 */

	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * Method 'getCodocumento'.
	 * 
	 * @return String
	 */

	public String getCodocumento() {
		return this.codocumento;
	}

	/**
	 * Method 'setCodocumento'.
	 * 
	 * @param codocumento
	 *            String
	 * @return
	 */

	public void setCodocumento(String codocumento) {
		this.codocumento = codocumento;
	}

	/**
	 * Method 'getIddocumentum'.
	 * 
	 * @return String
	 */

	public String getIddocumentum() {
		return this.iddocumentum;
	}

	/**
	 * Method 'setIddocumentum'.
	 * 
	 * @param iddocumentum
	 *            String
	 * @return
	 */

	public void setIddocumentum(String iddocumentum) {
		this.iddocumentum = iddocumentum;
	}

	/**
	 * Method 'getNofile'.
	 * 
	 * @return String
	 */

	public String getNofile() {
		return this.nofile;
	}

	/**
	 * Method 'setNofile'.
	 * 
	 * @param nofile
	 *            String
	 * @return
	 */

	public void setNofile(String nofile) {
		this.nofile = nofile;
	}

	/**
	 * Method 'getFechalimfirma'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechalimfirma() {
		return this.fechalimfirma;
	}

	/**
	 * Method 'setFechalimfirma'.
	 * 
	 * @param fechalimfirma
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechalimfirma(Date fechalimfirma) {
		this.fechalimfirma = fechalimfirma;
	}

	/**
	 * Method 'getComofirma'.
	 * 
	 * @return String
	 */

	public String getComofirma() {
		return this.comofirma;
	}

	/**
	 * Method 'setComofirma'.
	 * 
	 * @param comofirma
	 *            String
	 * @return
	 */

	public void setComofirma(String comofirma) {
		this.comofirma = comofirma;
	}

	/**
	 * @return the firma
	 */
	public String getFirma() {
		return firma;
	}

	/**
	 * @param firma
	 *            the firma to set
	 */
	public void setFirma(String firma) {
		this.firma = firma;
	}

	/**
	 * @return the idperfilfirma
	 */
	public String getIdperfilfirma() {
		return idperfilfirma;
	}

	/**
	 * @param idperfilfirma
	 *            the idperfilfirma to set
	 */
	public void setIdperfilfirma(String idperfilfirma) {
		this.idperfilfirma = idperfilfirma;
	}

	/**
	 * @return the desfile
	 */
	public String getDesfile() {
		return desfile;
	}

	/**
	 * @param desfile
	 *            the desfile to set
	 */
	public void setDesfile(String desfile) {
		this.desfile = desfile;
	}

	/**
	 * @return the motivorechazo
	 */
	public String getMotivorechazo() {
		return motivorechazo;
	}

	/**
	 * @param motivorechazo
	 *            the motivorechazo to set
	 */
	public void setMotivorechazo(String motivorechazo) {
		this.motivorechazo = motivorechazo;
	}

	/**
	 * @return the hashfile
	 */
	public String getHashfile() {
		return hashfile;
	}

	/**
	 * @param hashfile
	 *            the hashfile to set
	 */
	public void setHashfile(String hashfile) {
		this.hashfile = hashfile;
	}

	/**
	 * @return the comoasigfirma
	 */
	public String getComoasigfirma() {
		return comoasigfirma;
	}

	/**
	 * @param comoasigfirma
	 *            the comoasigfirma to set
	 */
	public void setComoasigfirma(String comoasigfirma) {
		this.comoasigfirma = comoasigfirma;
	}

	/**
	 * @return the rutaPif
	 */
	public String getRutaPif() {
		return rutaPif;
	}

	/**
	 * @param rutaPif
	 *            the rutaPif to set
	 */
	public void setRutaPif(String rutaPif) {
		this.rutaPif = rutaPif;
	}

	/**
	 * @return the rutaPifFileFirma
	 */
	public String getRutaPifFileFirma() {
		return rutaPifFileFirma;
	}

	/**
	 * @param rutaPifFileFirma
	 *            the rutaPifFileFirma to set
	 */
	public void setRutaPifFileFirma(String rutaPifFileFirma) {
		this.rutaPifFileFirma = rutaPifFileFirma;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "BandejaFirma [idbandejafirma=" + idbandejafirma + ", fase=" + fase + ", idexpediente=" + idexpediente
				+ ", expediente=" + expediente + ", pcodigo=" + pcodigo + ", hccoor=" + hccoor + ", idtramitehecho="
				+ idtramitehecho + ", trcodigo=" + trcodigo + ", codocumento=" + codocumento + ", iddocumentum="
				+ iddocumentum + ", nofile=" + nofile + ", fechalimfirma=" + fechalimfirma + ", comofirma=" + comofirma
				+ ", idperfilfirma=" + idperfilfirma + ", desfile=" + desfile + ", firma=" + firma + ", hashfile="
				+ hashfile + ", comoasigfirma=" + comoasigfirma + ", motivorechazo=" + motivorechazo + ", rutaPif="
				+ rutaPif + ", rutaPifFileFirma=" + rutaPifFileFirma + "]";
	}

}
